% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDiscretePars.R
\name{ctStanDiscreteParsPlot}
\alias{ctStanDiscreteParsPlot}
\title{ctStanDiscreteParsPlot}
\usage{
ctStanDiscreteParsPlot(
  x,
  indices = "all",
  quantiles = c(0.025, 0.5, 0.975),
  latentNames = "auto",
  ylab = "Coefficient",
  xlab = "Time interval",
  ylim = NA,
  facets = NA,
  splitSubjects = TRUE,
  colour = "Effect",
  title = "Temporal regressions | independent shock of 1.0",
  polygonalpha = 0.1,
  ggcode = NA
)
}
\arguments{
\item{x}{list object returned from \code{\link{ctStanDiscretePars}}.}

\item{indices}{Either a string specifying type of plot to create, or an n by 2
matrix specifying which indices of the output matrix to plot.
'AR' specifies all diagonals, for discrete time autoregression parameters.
'CR' specifies all off-diagonals,for discrete time cross regression parameters.
'all' plots all AR and CR effects at once.}

\item{quantiles}{numeric vector of length 3, with values between 0 and 1, specifying which quantiles to plot.
The default of c(.05,.5,.95) plots 95\% credible intervals and the posterior median at 50\%.}

\item{latentNames}{Vector of character strings denoting names for the latent variables. 
'auto' just uses eta1 eta2 etc.}

\item{ylab}{y label.}

\item{xlab}{x label.}

\item{ylim}{Custom ylim.}

\item{facets}{May be 'Subject' or 'Effect'.}

\item{splitSubjects}{if TRUE, subjects are plotted separately, if FALSE they are combined.}

\item{colour}{Character string denoting how colour varies. 'Effect' or 'Subject'.}

\item{title}{Character string.}

\item{polygonalpha}{Numeric between 0 and 1 to multiply the alpha of 
the fill.}

\item{ggcode}{if TRUE, returns a list containing the data.table to plot, and a character string that can be
evaluated (with the necessary arguments such as ylab etc filled in). For modifying plots.}
}
\value{
A ggplot2 object. This can be modified by the various ggplot2 functions, or displayed using print(x).
}
\description{
Plots model implied regression strengths at specified times for 
continuous time models fit with ctStanFit.
}
\examples{
data.table::setDTthreads(1) #ignore this line
x <- ctStanDiscretePars(ctstantestfit)
ctStanDiscreteParsPlot(x, indices='CR')

#to modify plot:
g <- ctStanDiscreteParsPlot(x, indices='CR') + 
 ggplot2::labs(title='My ggplot modification')
print(g)

}
