% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initHMM.R
\name{initHMM}
\alias{initHMM}
\title{Initializing dagHMM with given parameters}
\usage{
initHMM(
  States,
  dagmat,
  net = NULL,
  observation,
  startProbs = NULL,
  transProbs = NULL,
  leak_param = 0
)
}
\arguments{
\item{States}{A (2 * 1) vector with first element being discrete state value for the cases(or positive) and second element being discrete state value for the controls(or negative) for given dagHMM}

\item{dagmat}{Adjacent Symmetry Matrix that describes the topology of the dag}

\item{net}{Object of type 'bn' provided as output by \link{bnlearn}{model2network} showing the TAN structure between target variable and covariates.}

\item{observation}{Dataframe containing the discritized character values of covariates at each node. If "net" is not given, dataframe should also contain the column for target variable (as the last column) so as to learn the structure. Column names of dataframe should be same as the covariate names. Missing values should be denoted by "NA".}

\item{startProbs}{(Optional) (2 * 1) vector containing starting probabilities for the states. Default is equally probable states}

\item{transProbs}{(Optional) (2 * 2) matrix containing transition probabilities for the states.}

\item{leak_param}{(Optional) Leak parameter used in Noisy-OR algorithm used in \code{\link{forward}} and \code{\link{noisy_or}}.Default is 0}
}
\value{
List describing the parameters of dagHMM(pi, alpha, beta, dagmat, net)
}
\description{
Initializing dagHMM with given parameters
}
\examples{

library(bnlearn)

tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped dag
states = c("P","N") #"P" represent cases(or positive) and "N" represent controls(or negative)
bnet = model2network("[A][C|A:B][D|A:C][B|A]") #A is the target variable while
                                               #B, C and D are covariates.
obsvA=data.frame(list(B=c("L","H","H","L","L"),C=c("H","H","L","L","H"),D=c("L","L","L","H","H")))
hmmA = initHMM(States=states, dagmat= tmat, net=bnet, observation=obsvA)
obsvB=data.frame(list(B=c("L","H","H","L","L"),C=c("H","H","L","L","H"),D=c("L","L","L","H","H")),
                      A=c("P","N","P","P","N"))
hmmB = initHMM(States=states, dagmat= tmat, net=NULL, observation=obsvB)
}
