% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fmesher_spherical_bsplines1}
\alias{fmesher_spherical_bsplines1}
\alias{fmesher_spherical_bsplines}
\title{Rotationally invariant spherical B-splines}
\usage{
fmesher_spherical_bsplines1(loc, n, degree, uniform)

fmesher_spherical_bsplines(loc, n, degree, uniform)
}
\arguments{
\item{loc}{numeric vector/matrix; coordinates of points to locate in the mesh,
only the z-coordinates are used (\code{sin(latitude)})}

\item{n}{The number of basis functions}

\item{degree}{The polynomial basis degree}

\item{uniform}{logical; If \code{TRUE}, the knots are spaced uniformly by latitude,
if \code{FALSE}, the knots are spaced uniformly by \code{sin(latitude)}}
}
\value{
A matrix of evaluated b-spline basis functions
}
\description{
Compute rotationally invariant spherical B-splines on the unit sphere
}
\examples{
m <- fm_rcdt_2d(globe = 1)
fmesher_spherical_bsplines(m$loc, n = 3, degree = 2, uniform = FALSE)
fmesher_spherical_bsplines1(m$loc[, 3], n = 3, degree = 2, uniform = FALSE)
}
\keyword{internal}
