% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.fm_mesh_2d}
\alias{plot.fm_mesh_2d}
\alias{lines.fm_mesh_2d}
\title{Draw a triangulation mesh object}
\usage{
\method{lines}{fm_mesh_2d}(x, ..., add = TRUE)

\method{plot}{fm_mesh_2d}(
  x,
  col = "white",
  t.sub = seq_len(nrow(x$graph$tv)),
  add = FALSE,
  lwd = 1,
  xlim = range(x$loc[, 1]),
  ylim = range(x$loc[, 2]),
  main = NULL,
  size = 1,
  draw.vertices = FALSE,
  vertex.color = "black",
  draw.edges = TRUE,
  edge.color = rgb(0.3, 0.3, 0.3),
  draw.segments = draw.edges,
  rgl = deprecated(),
  visibility = "front",
  asp = 1,
  axes = FALSE,
  xlab = "",
  ylab = "",
  ...
)
}
\arguments{
\item{x}{An \code{\link[=fm_mesh_2d]{fm_mesh_2d()}} object.}

\item{\dots}{Further graphics parameters, interpreted by the respective
plotting systems.}

\item{add}{If \code{TRUE}, adds to the current plot instead of starting a
new one.}

\item{col}{Color specification.  A single named color, a vector of scalar
values, or a matrix of RGB values.  Requires \code{rgl=TRUE}.}

\item{t.sub}{Optional triangle index subset to be drawn.}

\item{lwd}{Line width for triangle edges.}

\item{xlim}{X-axis limits.}

\item{ylim}{Y-axis limits.}

\item{main}{Deprecated.}

\item{size}{argument \code{cex} for vertex points.}

\item{draw.vertices}{If \code{TRUE}, draw triangle vertices.}

\item{vertex.color}{Color specification for all vertices.}

\item{draw.edges}{If \code{TRUE}, draw triangle edges.}

\item{edge.color}{Color specification for all edges.}

\item{draw.segments}{If \code{TRUE}, draw boundary and interior constraint
edges more prominently.}

\item{rgl}{Deprecated}

\item{visibility}{If "front" only display mesh faces with normal pointing
towards the camera.}

\item{asp}{Aspect ratio for new plots. Default 1.}

\item{axes}{logical; whether axes should be drawn on the plot.
Default FALSE.}

\item{xlab, ylab}{character; labels for the axes.}
}
\value{
None
}
\description{
Plots an \code{\link[=fm_mesh_2d]{fm_mesh_2d()}} object using standard graphics.
}
\examples{

mesh <- fm_rcdt_2d(globe = 10)
plot(mesh)

mesh <- fm_mesh_2d(cbind(0, 1), offset = c(1, 1.5), max.edge = 0.5)
plot(mesh)
}
\seealso{
\code{\link[=plot.fm_segm]{plot.fm_segm()}}, \code{\link[=plot_rgl.fm_mesh_2d]{plot_rgl.fm_mesh_2d()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
