% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/access-methods.R, R/utils.R
\docType{methods}
\name{ExplicitRepresentationAccessors}
\alias{ExplicitRepresentationAccessors}
\alias{[,ExplicitRepresentation,index,index,ANY-method}
\alias{[,ExplicitRepresentationDense,index,index,ANY-method}
\alias{[,ExplicitRepresentationDense,index,missing,ANY-method}
\alias{[,ExplicitRepresentationDense,missing,index,ANY-method}
\alias{[,ExplicitRepresentationSparse,index,index,ANY-method}
\alias{[,ExplicitRepresentationSparse,index,index,logical-method}
\alias{[,ExplicitRepresentationSparse,index,index,missing-method}
\alias{[,ExplicitRepresentationSparse,index,missing,ANY-method}
\alias{[,ExplicitRepresentationSparse,index,missing,logical-method}
\alias{[,ExplicitRepresentationSparse,index,missing,missing-method}
\alias{[,ExplicitRepresentationSparse,missing,index,ANY-method}
\alias{[,ExplicitRepresentationSparse,missing,index,logical-method}
\alias{[,ExplicitRepresentationSparse,missing,index,missing-method}
\alias{\%*\%,dgRMatrix,numeric-method}
\alias{\%*\%,matrix,dgRMatrix-method}
\title{ExplicitRepresentation Accessors}
\usage{
## S4 methods for signature 'ExplicitRepresentation'
## x[i,j]

## further methods see below

\S4method{\%*\%}{matrix,dgRMatrix}(x, y)

\S4method{\%*\%}{dgRMatrix,numeric}(x, y)
}
\arguments{
\item{x}{an explicit representation in dense or sparse format}

\item{i}{integer vector or character vector with a subset of the sample
indices or names}

\item{y}{in the first case and explicit representation and \code{x} is a
\code{matrix}, for the second case a numeric matrix and x is an explicit
representation}

\item{j}{integer vector or character vector with a subset of the feature
indices or names}
}
\value{
see details above
}
\description{
ExplicitRepresentation Accessors
}
\section{Accessor-like methods}{


\describe{
  \item{\code{x[i, ]}}{
  returns a \code{KernelMatrix} object that only contains the rows selected
  with the subsetting parameter \code{i}. This parameter can be a numeric
  vector with indices or a character vector which is matched against the
  names of \code{x}.
  }
  \item{\code{x[ ,j]}}{
  returns a \code{KernelMatrix} object that only contains the columns
  selected with the subsetting parameter \code{j}. This parameter can be a
  numeric vector with indices or a character vector which is matched against
  the names of \code{x}.
  }
  \item{\code{x[i, j]}}{
  returns a \code{KernelMatrix} object that only contains the rows selected
  with the subsetting parameter \code{i} and columns selected by \code{j}.
  Both parameters can be a numeric vector with indices or a character vector
  which is matched against the names of \code{x}.
  }
}
}

\section{Accessor-like methods}{

\describe{
  \item{\code{\%*\%}}{
  this operator provides the multiplication of a \code{dgRMatrix} or
  a sparse explicit representation (which is derived from \code{dgRMatrix})
  with a matrix or a vector. This functionality is not available in package
  \bold{Matrix} for a \code{dgRMatrix}.
  }
}
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}

