% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils.R
\name{computeROCandAUC}
\alias{computeROCandAUC}
\title{Compute Receiver Operating Characteristic And Area Under The Curve}
\usage{
computeROCandAUC(prediction, labels, allLabels = NULL)
}
\arguments{
\item{prediction}{prediction results in the form of decision values as
returned by \code{\link{predict}} for predictionType="decision".}

\item{labels}{label vector of same length as parameter 'prediction'.}

\item{allLabels}{vector containing all occuring labels once. This parameter
is required only if the labels parameter is not a factor. Default=NULL}
}
\value{
On successful completion the function returns an object of class
\code{\linkS4class{ROCData}} containing the AUC, a numeric vector of
TPR values and a numeric vector containing the FPR values. If the ROC and
AUC cannot be computed because of missing positive or negative samples the
function returns 3 NA values.
}
\description{
Compute the receiver operating characteristic (ROC) and
area under the ROC curve (AUC) as performance measure for binary
classification
}
\details{
For binary classfication this function computes the receiver operating
curve (ROC) and the area under the ROC curve (AUC).
}
\examples{
## load transcription factor binding site data
data(TFBS)
enhancerFB
## select 70\% of the samples for training and the rest for test
train <- sample(1:length(enhancerFB), length(enhancerFB) * 0.7)
test <- c(1:length(enhancerFB))[-train]
## create the kernel object for gappy pair kernel with normalization
gappy <- gappyPairKernel(k=1, m=3)
## show details of kernel object
gappy

## run training with explicit representation
model <- kbsvm(x=enhancerFB[train], y=yFB[train], kernel=gappy,
               pkg="LiblineaR", svm="C-svc", cost=80, explicit="yes",
               featureWeights="no")

## predict the test sequences
pred <- predict(model, enhancerFB[test])
## print prediction performance
evaluatePrediction(pred, yFB[test], allLabels=unique(yFB))

## compute ROC and AUC
preddec <- predict(model, enhancerFB[test], predictionType="decision")
rocdata <- computeROCandAUC(preddec, yFB[test], allLabels=unique(yFB))

## show AUC value
rocdata

\dontrun{
## plot ROC
plot(rocdata)
}
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
\seealso{
\code{\link{predict}}, \code{\linkS4class{ROCData}}
}
\keyword{methods}
\keyword{performance}
\keyword{prediction}

