% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/heatmap-methods.R
\docType{methods}
\name{heatmap,PredictionProfile,missing-method}
\alias{heatmap}
\alias{heatmap,PredictionProfile,missing-method}
\alias{heatmap,PredictionProfile-method}
\title{Heatmap Methods}
\usage{
\S4method{heatmap}{PredictionProfile,missing}(x, Rowv = TRUE, add.expr,
  margins = c(5, 5), RowSideColors = NULL,
  cexRow = max(min(35/nrow(x@profiles), 1), 0.1),
  cexCol = max(min(35/ncol(x@profiles), 1), 0.1), main = NULL,
  dendScale = 1, barScale = 1, startPos = 1, endPos = ncol(x@profiles),
  labels = NULL, windowSize = 1, ...)
}
\arguments{
\item{x}{prediction profile of class
\code{\linkS4class{PredictionProfile}}.}

\item{Rowv}{determines the row order of the plot. When set to \code{TRUE}
the profile rows are clustered via hierarchical clustering and a row
dendrogram is plotted. When set to \code{FALSE, NA or NULL} the order is
corresponds to the order of the sequences in the profile. If this parameter
has a value of \code{random} rows are ordered randomly, for \code{decision}
the ordering is according to decreasing decision values. A user-defined
order can be specified through a numeric vector of indices. Default=TRUE}

\item{add.expr}{largely analogous to the standard
\code{\link[stats:heatmap]{heatmap}} function.}

\item{margins}{largely analogous to the standard
\code{\link[stats:heatmap]{heatmap}} function. Default=c(5,5)}

\item{RowSideColors}{a vector of color values specifying the colors for
the side bar. Default=NULL}

\item{cexRow}{largely analogous to the standard
\code{\link[stats:heatmap]{heatmap}} function. When set to 0 the row
labels are suppressed. Default=defined dependent on number of
profile rows}

\item{cexCol}{largely analogous to the standard
\code{\link[stats:heatmap]{heatmap}} function. When set to 0 the column
labels are suppressed. Default=defined dependent on number of profile
columns}

\item{main}{largely analogous to the standard
\code{\link[stats:heatmap]{heatmap}} function.}

\item{dendScale}{factor scaling the width of the row dendrogram; values
have to be larger than 0 and not larger than 2. Default=1}

\item{barScale}{factor scaling the width of the label color bar. Values
have to be larger than 0 and not larger than 4. Default=1}

\item{startPos}{start sequence position. Together with the
parameter \code{endPos} a subset of sequence positions can be selected
for the heatmap. Default=1}

\item{endPos}{end sequence position (see also \code{startPos}).
Default=maximum sequence length in the profile.}

\item{labels}{a numeric vector, character vector or factor specifying
the labels for the sequences in the profile. If this parameter is
different from NULL the labels are plotted as side bar using the
colors specified in the parameter \code{RowSideColors}. Default=NULL}

\item{windowSize}{numerical value specifying the window size of an optional
sliding window averaging of the prediction profiles. The value must be
larger than 0. Even values are changed internally to odd values by adding
1. Default=1}

\item{...}{additional parameters which are passed to the \code{image}
method transparently.}
}
\value{
Invisibly, a cluster dendrogram.
}
\description{
Create a heat map of prediction profiles
}
\details{
The \code{heatmap} function provides plotting of heatmaps from prediction
profiles with various possibilities for sample (=row) ordering (see
parameter \code{Rowv}). The heatmap is shown together with an optional
color sidebar showing the labels and an optional row cluster dendrogram
when hierarchical clustering defines the row order. For long sequences the
heatmap can be restricted to a subset of positions. Additionally smoothing
can be applied to the prediction profiles through sliding window averaging.
Through smoothing important regions can become better visible.
}
\examples{
## load coiled coil data
data(CCoil)

## define annotation specific gappy pair kernel
gappya <- gappyPairKernel(k=1,m=11, annSpec=TRUE)

## train model
model <- kbsvm(x=ccseq, y=as.numeric(yCC), kernel=gappya,
               pkg="e1071", svm="C-svc", cost=15)

## generate prediction profiles
predProf <- getPredictionProfile(ccseq, gappya,
                       featureWeights(model), modelOffset(model))

## show prediction profiles
predProf

\dontrun{
## plot heatmap for the prediction profiles - random ordering of samples
heatmap(predProf, Rowv="random", main="Prediction Profiles", labels=yCC,
RowSideColors=c("blue", "red"), cexRow=0.15, cexCol=0.3)

## plot heatmap for the prediction profiles - ordering by decision values
heatmap(predProf, Rowv="decision", main="Prediction Profiles", labels=yCC,
RowSideColors=c("blue", "red"), cexRow=0.15, cexCol=0.3)

## plot heatmap for the prediction profiles - with hierarchical clustering
heatmap(predProf, Rowv=TRUE, main="Prediction Profiles", labels=yCC,
RowSideColors=c("blue", "red"), cexRow=0.15, cexCol=0.3)
}
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
(Bodenhofer, 2009) -- U. Bodenhofer, K. Schwarzbauer, M. Ionescu and
S. Hochreiter. Modelling position specificity in sequence kernels by fuzzy
equivalence relations. \cr\cr
(Mahrenholz, 2011) -- C.C. Mahrenholz, I.G. Abfalter, U. Bodenhofer, R. Volkmer
and S. Hochreiter. Complex networks govern coiled-coil oligomerizations -
predicting and profiling by means of a machine learning approach.\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
\seealso{
\code{\link{getPredictionProfile}}
}
\keyword{prediction}
\keyword{profiles}

