% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlshrink_demo.R
\name{nlshrink_demo}
\alias{nlshrink_demo}
\title{Demonstration of non-linear shrinkage estimator of population eigenvalues}
\usage{
nlshrink_demo(tau = NULL, n = 300, p = 300, method = "nlminb",
  control = list())
}
\arguments{
\item{tau}{(Optional) Input population eigenvalues. Non-negative Numeric
vector of length \code{p}.}

\item{n}{(Optional) Number of rows in simulated data matrix (Default 300).}

\item{p}{(Optional) Number of columns in simulated data matrix (Default 300).}

\item{method}{(Optional) The optimization routine called in
\code{\link{tau_estimate}}. Choices are \code{nlminb} (default) and
\code{nloptr}.}

\item{control}{(Optional) A list of control parameters. Must correspond to
the selected optimization method. See \code{\link[stats]{nlminb}},
\code{\link[nloptr]{nloptr}} for details.}
}
\description{
This is a demonstration of the non-linear shrinkage method for
  estimating population eigenvalues. The inputted population eigenvalues are
  used to simulate a matrix of multivariate normal random variates with
  covariance matrix \code{diag(tau)}. This data matrix is then used to
  estimate the input population eigenvalues using the non-linear shrinkage
  method. The output plot shows the comparison of the various estimators
  (sample eigenvalues, linear shrinkage, non-linear shrinkage) to the true
  population eigenvalues.
}
\section{NOTE}{
 \code{nlminb} is usually robust and accurate, but does not
  allow equality constraints, so the sum of the estimated population
  eigenvalues is in general not equal to the sum of the sample eigenvalues.
  \code{nloptr} enforces an equality constraint to preserve the trace, but is
  substantially slower than \code{nlminb}. The default optimizer used for
  \code{nloptr} is the Augmented Lagrangian method with local optimization
  using LBFGS. These can be modified using the control parameter.
  \code{Rcgmin} does not enforce equality constraints, but may be more
  efficient for certain higher dimensional problems. The ideal optimization
  routine depends on the underlying structure of the population eigenvalues.
}
\references{
\itemize{\item Ledoit, O. and Wolf, M. (2015). Spectrum
  estimation: a unified framework for covariance matrix estimation and PCA in
  large dimensions. Journal of Multivariate Analysis, 139(2) \item Ledoit, O.
  and Wolf, M. (2016). Numerical Implementation of the QuEST function.
  arXiv:1601.05870 [stat.CO]}
}

