% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_sdPrior.r
\name{DesignM}
\alias{DesignM}
\title{Computing Designmatrix for Splines}
\usage{
DesignM(x, degree = 3, m = 20, min_x = min(x), max_x = max(x))
}
\arguments{
\item{x}{the covariate vector.}

\item{degree}{of the B-splines, default is 3.}

\item{m}{number of knots, default is 20.}

\item{min_x}{the left interval boundary, default is min(x).}

\item{max_x}{the right interval boundary, defalut is max(x).}
}
\value{
a list with design matrix at distinct covariates, design matrix at all observations, 
 index of sorted observations, the difference matrix, precision matrix and the knots used.
}
\description{
This function computes the design matrix for Bayesian P-splines as it would be done in 
BayesX. The implementation currently on works properly for default values (knots=20, degree=3).
}
\references{
Stefan Lang and Andy Brezger (2004). Bayesian P-Splines.
\emph{Journal of Computational and Graphical Statistics}, \bold{13}, 183--212.

Belitz, C., Brezger, A., Klein, N., Kneib, T., Lang, S., Umlauf, N. (2015): BayesX - Software for Bayesian inference in structured additive regression models.
Version 3.0.1. Available from http://www.bayesx.org.
}
\author{
Nadja Klein
}
