% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexahedron.R
\name{makeHexahedron}
\alias{makeHexahedron}
\title{Make hexahedron}
\usage{
makeHexahedron(p0, p1, p2, p3, p4, p5, p6, p7)
}
\arguments{
\item{p0, p1, p2, p3, p4, p5, p6, p7}{the eight vertices of the hexahedron, as in 
the figure shown below}
}
\value{
A matrix with eight columns, the vertices.
}
\description{
Make a hexahedron for usage in 
  \code{\link{runif_in_hexahedron}} and other functions.
}
\details{
A hexahedron is a polyhedron having six quad faces. Its eight vertices 
  must be placed as in the figure below.
  
\if{html}{
  \figure{hexahedron.png}{options: style="max-width:75\%;" alt="hexahedron"}
}
\if{latex}{
  \out{\begin{center}}\figure{hexahedron.png}\out{\end{center}}
}
}
\examples{
library(uniformly)
# a non-convex hexahedron
hexahedron <- makeHexahedron(
  p0 = c(1.5, 1.5, 0),
  p1 = c(2, 0, 0),
  p2 = c(2, 2, 0),
  p3 = c(0, 2, 0),
  p4 = c(0, 2, 2),
  p5 = c(0, 0, 2),
  p6 = c(2, 0, 2),
  p7 = c(2, 2, 2)
)
plotHexahedron(hexahedron)
}
\seealso{
The function \code{\link{plotHexahedron}} is useful to check the 
  hexahedron.
}
