/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.map.TrieUpdate;
import org.basex.util.TokenBuilder;

final class TrieBranch
extends TrieNode {
    private final TrieNode[] kids;
    final int used;
    private static final String[] ENDS = new String[]{"|-- ", "|   ", "`-- ", "    "};

    TrieBranch(TrieNode[] kids, int used, int size) {
        super(size);
        this.kids = kids;
        this.used = used;
    }

    @Override
    TrieNode put(int hs, int lv, TrieUpdate update) throws QueryException {
        int rem;
        int bs;
        TrieNode nsub;
        int k = TrieBranch.hashKey(hs, lv);
        TrieNode sub = this.kids[k];
        if (sub != null) {
            TrieNode sb = sub.put(hs, lv + 1, update);
            if (sb == sub) {
                return this;
            }
            nsub = sb;
            bs = this.used;
            rem = sub.size;
        } else {
            update.add();
            nsub = new TrieLeaf(hs, update.key, update.value);
            bs = this.used | 1 << k;
            rem = 0;
        }
        TrieNode[] ks = (TrieNode[])this.kids.clone();
        ks[k] = nsub;
        return new TrieBranch(ks, bs, this.size - rem + nsub.size);
    }

    @Override
    TrieNode remove(int hs, int lv, TrieUpdate update) throws QueryException {
        int nu;
        int k = TrieBranch.hashKey(hs, lv);
        TrieNode sub = this.kids[k];
        if (sub == null) {
            return this;
        }
        TrieNode nsub = sub.remove(hs, lv + 1, update);
        if (nsub == sub) {
            return this;
        }
        if (nsub == null) {
            TrieNode single;
            nu = this.used ^ 1 << k;
            if (Integer.bitCount(nu) == 1 && !((single = this.kids[Integer.numberOfTrailingZeros(nu)]) instanceof TrieBranch)) {
                return single;
            }
        } else {
            nu = this.used;
        }
        TrieNode[] ks = (TrieNode[])this.kids.clone();
        ks[k] = nsub;
        return new TrieBranch(ks, nu, this.size - 1);
    }

    @Override
    Value get(int hs, Item ky, int lv) throws QueryException {
        int k = TrieBranch.hashKey(hs, lv);
        TrieNode sub = this.kids[k];
        return sub == null ? null : sub.get(hs, ky, lv + 1);
    }

    @Override
    void add(TokenBuilder tb, String indent) {
        int s = Integer.bitCount(this.used);
        int i = 0;
        int j = 0;
        while (i < s) {
            while ((this.used & 1 << j) == 0) {
                ++j;
            }
            int e = i == s - 1 ? 2 : 0;
            tb.add(indent).add(ENDS[e]).add(String.format("%x", j)).add(10);
            this.kids[j].add(tb, indent + ENDS[e + 1]);
            ++i;
            ++j;
        }
    }
}

