/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.Blitz;
import de.bottlecaps.markup.blitz.Parser;
import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.Range;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import de.bottlecaps.markup.blitz.codepoints.UnicodeCategory;
import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Insertion;
import de.bottlecaps.markup.blitz.grammar.Mark;
import de.bottlecaps.markup.blitz.grammar.Node;
import de.bottlecaps.markup.blitz.grammar.Nonterminal;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.item.TokenSet;
import de.bottlecaps.markup.blitz.parser.Action;
import de.bottlecaps.markup.blitz.parser.ReduceArgument;
import de.bottlecaps.markup.blitz.transform.CompressedMap;
import de.bottlecaps.markup.blitz.transform.Map2D;
import de.bottlecaps.markup.blitz.transform.TileIterator;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Generator {
    private static final int EPSILON = -1;
    private Grammar grammar;
    private Map<String, Integer> nonterminalCode;
    private String[] nonterminal;
    private Map<RangeSet, Integer> terminalCode;
    private RangeSet[] terminal;
    private NavigableMap<Range, Integer> terminalCodeByRange;
    private Map<Node, TokenSet> first = new IdentityHashMap<Node, TokenSet>();
    private Map<State, State> states = new LinkedHashMap<State, State>();
    private Set<State> statesTodo = new LinkedHashSet<State>();
    private Map<Integer, Integer> forkId;
    private int[] forks;
    private ReduceArgument[] reduceArguments;
    private Map2D terminalTransitionData;
    private Map2D nonterminalTransitionData;
    private boolean verbose;

    private Generator() {
    }

    public static Parser generate(Grammar g) {
        return Generator.generate(g, Collections.emptySet());
    }

    public static Parser generate(Grammar g, Set<Blitz.Option> options) {
        Generator ci = new Generator();
        ci.verbose = options.contains((Object)Blitz.Option.VERBOSE);
        ci.grammar = g;
        if (ci.verbose) {
            System.err.println();
            System.err.println("BNF grammar:");
            System.err.println("------------");
            System.err.println(g);
        }
        ci.new SymbolCodeAssigner().visit(g);
        if (options.contains((Object)Blitz.Option.VERBOSE)) {
            System.err.println();
            System.err.println("Number of charClasses: " + ci.terminalCode.size());
            System.err.println("----------------------");
            ci.terminalCode.forEach((k, v) -> System.err.println(v + ": " + k));
        }
        ci.reduceArguments = ci.reduceArguments();
        ci.collectFirst();
        Term startNode = g.getRules().values().iterator().next().getAlts().getAlts().get(0).getTerms().get(0);
        Integer endToken = ci.terminalCode.get(Charset.END.getRangeSet());
        State initialState = ci.new State();
        initialState.put(startNode, new TokenSet(endToken));
        initialState.id = 0;
        ci.states.put(initialState, initialState);
        ci.statesTodo.add(initialState);
        ci.forks = new int[32];
        Comparator forkComparator = (lhs, rhs) -> Arrays.compare(ci.forks, 2 * lhs, 2 * lhs + 2, ci.forks, 2 * rhs, 2 * rhs + 2);
        ci.forkId = new TreeMap<Integer, Integer>(forkComparator);
        while (!ci.statesTodo.isEmpty()) {
            State s = ci.statesTodo.iterator().next();
            ci.statesTodo.remove(s);
            s.close();
            s.transitions();
        }
        ci.forks = Arrays.copyOf(ci.forks, 2 * ci.forkId.size());
        ci.parserData();
        if (ci.verbose) {
            System.err.println();
            System.err.println(ci.states.size() + " states (not counting LR(0) reduce states)");
            System.err.println(ci.reduceArguments.length + " reduce arguments");
            System.err.println(ci.forks.length / 2 + " forks");
            for (int i = 0; i < ci.forks.length / 2; ++i) {
                System.err.println("\nfork " + i + ":");
                for (int j = 0; j < 2; ++j) {
                    int code = ci.forks[2 * i + j];
                    Action action = Action.of(code);
                    System.err.print(action);
                    if (action.getType() == Action.Type.REDUCE || action.getType() == Action.Type.SHIFT_REDUCE) {
                        System.err.print(" (");
                        System.err.print(ci.toString(ci.reduceArguments[action.getArgument()]));
                        System.err.print(")");
                    }
                    System.err.println();
                }
            }
            for (State state : ci.states.keySet()) {
                System.err.println("\nstate " + state.id + ":\n" + state);
            }
        }
        BitSet[] expectedTokens = new BitSet[ci.states.size()];
        for (State state : ci.states.keySet()) {
            expectedTokens[state.id] = new BitSet(ci.terminalCode.size());
            state.terminalTransitions.keySet().forEach(expectedTokens[state.id]::set);
            state.reductions.keySet().forEach(expectedTokens[state.id]::set);
        }
        int bmpMapEnd = 55296;
        Function<Integer, TileIterator> tokenMapIterator = bits -> TileIterator.of(ci.terminalCodeByRange, 55296, (int)bits, 0);
        CompressedMap bmpMap = new CompressedMap(tokenMapIterator, 3);
        int[] asciiMap = ci.asciiMap(bmpMap);
        int[] smpMap = ci.supplementaryMap(55296);
        Function<Integer, TileIterator> terminalTransitionIterator = bits -> TileIterator.of(ci.terminalTransitionData, bits, 0);
        CompressedMap terminalTransitions = new CompressedMap(terminalTransitionIterator, 3);
        Function<Integer, TileIterator> nonterminalTransitionIterator = bits -> TileIterator.of(ci.nonterminalTransitionData, bits, 0);
        CompressedMap nonterminalTransitions = new CompressedMap(nonterminalTransitionIterator, 3);
        if (ci.verbose) {
            System.err.println();
            System.err.println("size of token code map: " + bmpMap.data().length + ", shift: " + Arrays.toString(bmpMap.shift()));
            System.err.println("size of terminal transition map: " + terminalTransitions.data().length + ", shift: " + Arrays.toString(terminalTransitions.shift()));
            System.err.println("size of nonterminal transition map: " + nonterminalTransitions.data().length + ", shift: " + Arrays.toString(nonterminalTransitions.shift()));
            System.err.println();
        }
        return new Parser(options, asciiMap, bmpMap, smpMap, terminalTransitions, ci.terminalTransitionData.getEndY(), nonterminalTransitions, ci.nonterminalTransitionData.getEndY(), ci.reduceArguments, ci.nonterminal, ci.terminal, ci.forks, expectedTokens, ci.grammar.isMismatch(), ci.grammar.getVersion().isAtLeast(Grammar.Version.V1_1));
    }

    private int[] asciiMap(CompressedMap bmpMap) {
        int[] asciiMap = new int[128];
        for (int i = 0; i < asciiMap.length; ++i) {
            asciiMap[i] = bmpMap.get(i);
        }
        return asciiMap;
    }

    private int[] supplementaryMap(int firstValue) {
        Range value = new Range(firstValue);
        Range firstKey = this.terminalCodeByRange.floorKey(value);
        if (firstKey == null || firstValue > firstKey.getLastCodepoint()) {
            firstKey = this.terminalCodeByRange.higherKey(value);
        }
        if (firstKey == null) {
            return new int[]{firstValue, 0x10FFFF, -1};
        }
        SortedMap<Range, Integer> tailMap = this.terminalCodeByRange.tailMap(firstKey);
        int count = tailMap.size();
        int[] rangeMap = new int[3 * count];
        int i = 0;
        for (Map.Entry<Range, Integer> entry : tailMap.entrySet()) {
            Range range = entry.getKey();
            rangeMap[i] = Math.max(firstValue, range.getFirstCodepoint());
            rangeMap[count + i] = range.getLastCodepoint();
            rangeMap[count + count + i] = entry.getValue();
            ++i;
        }
        return rangeMap;
    }

    private String toString(ReduceArgument reduceArgument) {
        int nonterminalId = reduceArgument.getNonterminalId();
        Mark[] marks = reduceArgument.getMarks();
        int[] insertion = reduceArgument.getInsertion();
        return "pop " + marks.length + ", id " + nonterminalId + ", nonterminal " + this.nonterminal[nonterminalId] + (String)(marks.length == 0 ? "" : ", marks " + Arrays.stream(marks).map(Mark::toString).collect(Collectors.joining())) + (String)(insertion == null ? "" : ", insert " + new Insertion(insertion));
    }

    private TokenSet first(Node node, TokenSet lookahead) {
        if (node == null || node instanceof Insertion) {
            return lookahead;
        }
        TokenSet tokens = this.first.get(node);
        if (!tokens.contains(-1)) {
            return tokens;
        }
        TokenSet nonNullTokens = new TokenSet();
        nonNullTokens.addAll(tokens);
        nonNullTokens.remove(-1);
        nonNullTokens.addAll(lookahead);
        return nonNullTokens;
    }

    private void collectFirst() {
        boolean initial = true;
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Rule r : this.grammar.getRules().values()) {
                for (Alt a : r.getAlts().getAlts()) {
                    if (a.getTerms().isEmpty() || a.getTerms().get(0) instanceof Insertion) {
                        if (!initial) continue;
                        changed = true;
                        this.first.put(a, new TokenSet(-1));
                        continue;
                    }
                    ArrayList<Term> terms = new ArrayList<Term>(a.getTerms());
                    for (int i = terms.size() - 1; i >= 0; --i) {
                        TokenSet f;
                        Term t = (Term)terms.get(i);
                        if (t instanceof Charset) {
                            if (!initial) continue;
                            changed = true;
                            this.first.put(t, new TokenSet(this.terminalCode.get(((Charset)t).getRangeSet())));
                            continue;
                        }
                        if (!(t instanceof Nonterminal)) continue;
                        Rule rule = this.grammar.getRule(((Nonterminal)t).getName());
                        TokenSet firstOfRule = this.first.get(rule);
                        TokenSet tokens = new TokenSet();
                        if (firstOfRule != null) {
                            tokens.addAll(firstOfRule);
                            if (tokens.contains(-1) && i + 1 != terms.size() && !(terms.get(i + 1) instanceof Insertion)) {
                                tokens.remove(-1);
                                f = this.first.get(terms.get(i + 1));
                                tokens.addAll(f);
                            }
                        }
                        if (initial) {
                            changed = true;
                            this.first.put(t, tokens);
                            continue;
                        }
                        f = this.first.get(t);
                        if (f.containsAll(tokens)) continue;
                        f.addAll(tokens);
                        changed = true;
                    }
                    this.first.put(a, this.first.get(a.getTerms().iterator().next()));
                }
                TokenSet tokens = new TokenSet();
                for (Alt a : r.getAlts().getAlts()) {
                    tokens.addAll(this.first.get(a));
                }
                this.first.put(r, tokens);
            }
            initial = false;
        }
    }

    private void parserData() {
        this.terminalTransitionData = new Map2D(this.states.size(), this.terminal.length);
        this.nonterminalTransitionData = new Map2D(this.states.size(), this.grammar.getRules().size());
        this.nonterminalTransitionData.put(new Map2D.Index(0, 0), Action.code(Action.Type.ACCEPT, 0));
        this.states.keySet().forEach(State::parserData);
    }

    private ReduceArgument[] reduceArguments() {
        LinkedHashMap<ReduceArgument, Integer> reductionId = new LinkedHashMap<ReduceArgument, Integer>();
        for (Rule rule : this.grammar.getRules().values()) {
            int code = this.nonterminalCode.get(rule.getName());
            for (Alt alt : rule.getAlts().getAlts()) {
                int newId;
                ArrayList<Mark> marks = new ArrayList<Mark>();
                ArrayList<Integer> aliases = new ArrayList<Integer>();
                int[] insertion = null;
                for (Term term : alt.getTerms()) {
                    if (term instanceof Insertion) {
                        insertion = ((Insertion)term).getCodepoints();
                        continue;
                    }
                    if (term instanceof Nonterminal) {
                        Nonterminal n = (Nonterminal)term;
                        marks.add(n.getMark());
                        aliases.add(n.getAlias() == null || n.getName().equals(n.getAlias()) ? -1 : this.nonterminalCode.get(n.getAlias()));
                        continue;
                    }
                    if (!(term instanceof Charset)) {
                        throw new IllegalStateException();
                    }
                    if (((Charset)term).isDeleted()) {
                        marks.add(Mark.DELETE);
                        aliases.add(-1);
                        continue;
                    }
                    marks.add(Mark.NODE);
                    aliases.add(-1);
                }
                ReduceArgument reduction = new ReduceArgument((Mark[])marks.toArray(Mark[]::new), aliases.stream().mapToInt(Integer::intValue).toArray(), insertion, code);
                Integer id = reductionId.putIfAbsent(reduction, newId = reductionId.size());
                alt.setReductionId(id == null ? newId : id);
            }
        }
        return (ReduceArgument[])reductionId.keySet().toArray(ReduceArgument[]::new);
    }

    private class SymbolCodeAssigner
    extends Visitor {
        private SymbolCodeAssigner() {
        }

        @Override
        public void visit(Grammar g) {
            Generator.this.nonterminalCode = new LinkedHashMap<String, Integer>();
            Generator.this.terminalCode = new LinkedHashMap<RangeSet, Integer>();
            Generator.this.terminalCodeByRange = new TreeMap<Range, Integer>();
            g.getRules().keySet().forEach(name -> Generator.this.nonterminalCode.put((String)name, Generator.this.nonterminalCode.size()));
            Generator.this.terminalCode.put(Charset.END.getRangeSet(), Generator.this.terminalCode.size());
            super.visit(g);
            Generator.this.nonterminal = (String[])Generator.this.nonterminalCode.keySet().stream().map(name -> UnicodeCategory.isXmlName(name) ? name : " " + name).toArray(String[]::new);
            Generator.this.terminal = (RangeSet[])Generator.this.terminalCode.keySet().toArray(RangeSet[]::new);
        }

        @Override
        public void visit(Nonterminal n) {
            if (n.getAlias() != null && !Generator.this.nonterminalCode.containsKey(n.getAlias())) {
                int code = Generator.this.nonterminalCode.size();
                Generator.this.nonterminalCode.put(n.getAlias(), code);
            }
        }

        @Override
        public void visit(Charset c) {
            RangeSet r = c.getRangeSet();
            if (!Generator.this.terminalCode.containsKey(r)) {
                int code = Generator.this.terminalCode.size();
                Generator.this.terminalCode.put(r, code);
                for (Range range : r) {
                    Generator.this.terminalCodeByRange.put(range, code);
                }
            }
        }
    }

    private class State {
        private int id;
        private Map<Node, TokenSet> kernel = new IdentityHashMap<Node, TokenSet>();
        private Map<Node, TokenSet> closure;
        private Map<Integer, State> terminalTransitions;
        private Map<Integer, State> nonterminalTransitions;
        private Map<Integer, List<Alt>> reductions;
        private Map<Integer, Integer> conflicts;

        public boolean isLr0ReduceState() {
            if (this.kernel.size() != 1) {
                return false;
            }
            Node node = this.kernel.keySet().iterator().next();
            if (!(node instanceof Alt) && !(node instanceof Insertion)) {
                return false;
            }
            Alt alt = node instanceof Alt ? (Alt)node : (Alt)node.getParent();
            return Generator.this.reduceArguments[alt.getReductionId()].getNonterminalId() != 0;
        }

        public void close() {
            Map.Entry item;
            this.closure = new IdentityHashMap<Node, TokenSet>();
            Deque todo = this.kernel.entrySet().stream().filter(e -> e.getKey() instanceof Nonterminal).collect(Collectors.toCollection(LinkedList::new));
            while (null != (item = (Map.Entry)todo.poll())) {
                Nonterminal nonterminal = (Nonterminal)item.getKey();
                TokenSet lookahead = (TokenSet)item.getValue();
                Node next = nonterminal.getNext();
                if (next != null) {
                    lookahead = Generator.this.first(next, lookahead);
                }
                for (Alt alt : nonterminal.getGrammar().getRule(nonterminal.getName()).getAlts().getAlts()) {
                    Node closureItemNode = alt.getTerms().isEmpty() ? alt : (Node)alt.getTerms().get(0);
                    TokenSet closureLookahead = this.closure.get(closureItemNode);
                    if (closureLookahead != null) {
                        if (closureLookahead.containsAll(lookahead)) continue;
                        closureLookahead.addAll(lookahead);
                        if (!(closureItemNode instanceof Nonterminal)) continue;
                        todo.add(Map.entry(closureItemNode, lookahead));
                        continue;
                    }
                    if (closureItemNode == alt) {
                        this.closure.put(alt, new TokenSet(lookahead));
                        continue;
                    }
                    this.closure.put(closureItemNode, new TokenSet(lookahead));
                    if (!(closureItemNode instanceof Nonterminal)) continue;
                    todo.add(Map.entry(closureItemNode, new TokenSet(lookahead)));
                }
            }
        }

        public void transitions() {
            this.terminalTransitions = new HashMap<Integer, State>();
            this.nonterminalTransitions = new HashMap<Integer, State>();
            this.reductions = new HashMap<Integer, List<Alt>>();
            Stream.concat(this.kernel.entrySet().stream(), this.closure.entrySet().stream()).forEach(e -> {
                Node node = (Node)e.getKey();
                TokenSet lookahead = (TokenSet)e.getValue();
                if (node instanceof Alt || node instanceof Insertion) {
                    Alt alt = node instanceof Alt ? (Alt)node : (Alt)node.getParent();
                    int token = lookahead.nextToken(-1);
                    while (token >= -1) {
                        this.reductions.compute(token, (k, v) -> {
                            if (v == null) {
                                v = new ArrayList<Alt>();
                            }
                            v.add(alt);
                            return v;
                        });
                        token = lookahead.nextToken(token + 1);
                    }
                } else {
                    Map<Integer, State> transitions;
                    Integer code;
                    Node next;
                    Node node2 = next = node.getNext() != null ? node.getNext() : node.getParent();
                    if (node instanceof Nonterminal) {
                        code = Generator.this.nonterminalCode.get(((Nonterminal)node).getName());
                        transitions = this.nonterminalTransitions;
                    } else if (node instanceof Charset) {
                        code = Generator.this.terminalCode.get(((Charset)node).getRangeSet());
                        transitions = this.terminalTransitions;
                    } else {
                        throw new IllegalStateException("Unexpected type: " + node.getClass().getSimpleName());
                    }
                    transitions.compute(code, (k, v) -> {
                        if (v == null) {
                            v = new State();
                            v.put(next, new TokenSet(lookahead));
                        } else {
                            TokenSet tokenSet = v.kernel.get(next);
                            if (tokenSet == null) {
                                v.put(next, new TokenSet(lookahead));
                            } else {
                                tokenSet.addAll(lookahead);
                            }
                        }
                        return v;
                    });
                }
            });
            for (Map transitions : Arrays.asList(this.nonterminalTransitions, this.terminalTransitions)) {
                for (Map.Entry e2 : transitions.entrySet()) {
                    State newState = (State)e2.getValue();
                    if (newState.isLr0ReduceState()) continue;
                    State state = Generator.this.states.putIfAbsent(newState, newState);
                    if (state == null) {
                        newState.id = Generator.this.states.size() - 1;
                        Generator.this.statesTodo.add(newState);
                        continue;
                    }
                    Integer code = (Integer)e2.getKey();
                    transitions.put(code, state);
                    for (Map.Entry<Node, TokenSet> k2 : newState.kernel.entrySet()) {
                        TokenSet lookahead = state.kernel.get(k2.getKey());
                        if (lookahead.containsAll(k2.getValue())) continue;
                        lookahead.addAll(k2.getValue());
                        Generator.this.statesTodo.add(state);
                    }
                }
            }
            this.conflicts = new LinkedHashMap<Integer, Integer>();
            HashSet<Integer> conflictTokens = new HashSet<Integer>(this.terminalTransitions.keySet());
            conflictTokens.retainAll(this.reductions.keySet());
            this.reductions.forEach((k, v) -> {
                if (v.size() > 1) {
                    conflictTokens.add((Integer)k);
                }
            });
            Iterator iterator = conflictTokens.iterator();
            while (iterator.hasNext()) {
                int conflictToken = (Integer)iterator.next();
                ArrayList<Integer> forkList = new ArrayList<Integer>();
                State state = this.terminalTransitions.get(conflictToken);
                if (this.terminalTransitions.containsKey(conflictToken)) {
                    if (state.isLr0ReduceState()) {
                        int argument = ((Alt)state.kernel.keySet().iterator().next()).getReductionId();
                        forkList.add(Action.code(Action.Type.SHIFT_REDUCE, argument));
                    } else {
                        forkList.add(Action.code(Action.Type.SHIFT, state.id));
                    }
                }
                for (Alt alt : this.reductions.get(conflictToken)) {
                    forkList.add(Action.code(Action.Type.REDUCE, alt.getReductionId()));
                }
                Integer id = -1;
                for (int i = forkList.size() - 2; i >= 0; --i) {
                    int newId = Generator.this.forkId.size();
                    if (newId << 3 > Generator.this.forks.length) {
                        Generator.this.forks = Arrays.copyOf(Generator.this.forks, Generator.this.forks.length << 1);
                    }
                    Generator.this.forks[2 * newId] = (Integer)forkList.get(i);
                    Generator.this.forks[2 * newId + 1] = id < 0 ? (Integer)forkList.get(i + 1) : Action.code(Action.Type.FORK, id);
                    id = Generator.this.forkId.putIfAbsent(newId, newId);
                    id = id != null ? id : newId;
                }
                this.conflicts.put(conflictToken, id);
            }
        }

        void put(Node node, TokenSet lookahead) {
            this.kernel.put(node, lookahead);
        }

        void parserData() {
            this.conflicts.forEach((terminalId, forkId) -> {
                int code = Action.code(Action.Type.FORK, forkId);
                Generator.this.terminalTransitionData.put(new Map2D.Index(this.id, (int)terminalId), code);
            });
            this.terminalTransitions.forEach((terminalId, state) -> {
                if (!this.conflicts.containsKey(terminalId)) {
                    int code;
                    if (state.isLr0ReduceState()) {
                        Node node = state.kernel.keySet().iterator().next();
                        Alt alt = node instanceof Alt ? (Alt)node : (Alt)node.getParent();
                        code = Action.code(Action.Type.SHIFT_REDUCE, alt.getReductionId());
                    } else {
                        code = Action.code(Action.Type.SHIFT, state.id);
                    }
                    Generator.this.terminalTransitionData.put(new Map2D.Index(this.id, (int)terminalId), code);
                }
            });
            this.nonterminalTransitions.forEach((nonterminalId, state) -> {
                int code;
                if (state.isLr0ReduceState()) {
                    Node node = state.kernel.keySet().iterator().next();
                    Alt alt = (Alt)(node instanceof Alt ? node : node.getParent());
                    int argument = alt.getReductionId();
                    code = Action.code(Action.Type.SHIFT_REDUCE, argument);
                } else {
                    code = Action.code(Action.Type.SHIFT, state.id);
                }
                Generator.this.nonterminalTransitionData.put(new Map2D.Index(this.id, (int)nonterminalId), code);
            });
            this.reductions.forEach((terminalId, alts) -> {
                if (!this.conflicts.containsKey(terminalId)) {
                    if (alts.size() != 1) {
                        throw new IllegalStateException();
                    }
                    int reductionId = ((Alt)alts.get(0)).getReductionId();
                    int code = Action.code(Action.Type.REDUCE, reductionId);
                    Generator.this.terminalTransitionData.put(new Map2D.Index(this.id, (int)terminalId), code);
                }
            });
        }

        public int hashCode() {
            return this.kernel.keySet().hashCode();
        }

        public boolean equals(Object other) {
            return this.kernel.keySet().equals(((State)other).kernel.keySet());
        }

        public String toString() {
            String itemsString = Stream.concat(this.kernel.entrySet().stream(), this.closure == null ? Stream.empty() : this.closure.entrySet().stream()).map(item -> this.toString((Map.Entry<Node, TokenSet>)item)).collect(Collectors.joining("\n"));
            String conflictsString = this.conflicts.entrySet().stream().map(e -> {
                int t = (Integer)e.getKey();
                StringBuilder sb = new StringBuilder("\n");
                if (this.terminalTransitions.containsKey(t)) {
                    sb.append("shift");
                } else {
                    sb.append("reduce");
                }
                sb.append("-reduce conflict on ");
                sb.append(this.toString(t));
                sb.append(" fork ");
                sb.append(e.getValue());
                return sb.toString();
            }).collect(Collectors.joining());
            return itemsString + conflictsString;
        }

        private Action action(Node node) {
            State toState;
            Alt alt;
            Alt alt2 = alt = node instanceof Alt ? (Alt)node : (Alt)node.getParent();
            if (node instanceof Alt || node instanceof Insertion) {
                return new Action(Action.Type.REDUCE, alt.getReductionId());
            }
            if (node instanceof Nonterminal) {
                int code = Generator.this.nonterminalCode.get(((Nonterminal)node).getName());
                toState = this.nonterminalTransitions.get(code);
            } else if (node instanceof Charset) {
                int code = Generator.this.terminalCode.get(((Charset)node).getRangeSet());
                toState = this.terminalTransitions.get(code);
            } else {
                throw new IllegalStateException("Unexpected type: " + node.getClass().getSimpleName());
            }
            if (toState.isLr0ReduceState()) {
                return new Action(Action.Type.SHIFT_REDUCE, alt.getReductionId());
            }
            return new Action(Action.Type.SHIFT, toState.id);
        }

        private String toString(Map.Entry<Node, TokenSet> item) {
            StringBuilder sb = new StringBuilder();
            Node node = item.getKey();
            TokenSet lookahead = item.getValue();
            sb.append("[").append((Object)node.getRule().getMark()).append(node.getRule().getName()).append(":");
            Alt alt = (Alt)(node instanceof Alt ? node : node.getParent());
            for (Term term : alt.getTerms()) {
                if (term == node) {
                    sb.append(" ").append(".");
                }
                sb.append(" ").append(term);
            }
            if (alt == node) {
                sb.append(" ").append(".");
            }
            sb.append(" | {");
            String delimiter = "";
            int token = lookahead.nextToken(-1);
            while (token >= -1) {
                sb.append(delimiter).append(this.toString(token));
                delimiter = ", ";
                token = lookahead.nextToken(token + 1);
            }
            sb.append("}] ");
            if (this.nonterminalTransitions != null && this.terminalTransitions != null) {
                Action action = this.action(node);
                sb.append(action);
                if (action.getType() == Action.Type.REDUCE || action.getType() == Action.Type.SHIFT_REDUCE) {
                    sb.append(" (").append(Generator.this.toString(Generator.this.reduceArguments[action.getArgument()])).append(")");
                }
            }
            return sb.toString();
        }

        private String toString(Integer token) {
            if (token == 0) {
                return Codepoint.toString(Integer.MAX_VALUE);
            }
            if (Generator.this.terminal == null) {
                return Integer.toString(token);
            }
            return Generator.this.terminal[token].shortName();
        }
    }
}

