/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ArithSimple;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CalcOpt;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.Unary;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public class Arith
extends Arr {
    public final Calc calc;
    CalcOpt calcOpt;

    public Arith(InputInfo info, Expr expr1, Expr expr2, Calc calc) {
        super(info, Types.ANY_ATOMIC_TYPE_ZO, expr1, expr2);
        this.calc = calc;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.exprs = this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
        if (this.values(false, cc)) {
            return cc.preEval(this);
        }
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if ((this.calc == Calc.ADD || this.calc == Calc.MULTIPLY) && expr1 instanceof Value && !(expr2 instanceof Value)) {
            cc.info("swap operands: %", this);
            this.exprs[0] = expr2;
            this.exprs[1] = expr1;
            expr1 = this.exprs[0];
            expr2 = this.exprs[1];
        }
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        Type type1 = st1.type;
        Type type2 = st2.type;
        boolean numbers = type1.isNumberOrUntyped() && type2.isNumberOrUntyped();
        Type type = this.calc.type(type1, type2);
        boolean noArray = !st1.mayBeArray() && !st2.mayBeArray();
        boolean oneOrMore = noArray && st1.oneOrMore() && st2.oneOrMore();
        this.exprType.assign(type, oneOrMore ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE);
        Expr expr = this.emptyExpr();
        if (expr == this && expr1 == Itr.ZERO && this.calc == Calc.SUBTRACT) {
            expr = new Unary(this.info, expr2, true).optimize(cc);
        }
        if (expr == this && Function.COUNT.is(expr1) && this.calc == Calc.ADD && Function.COUNT.is(expr2)) {
            expr = cc.function(Function.COUNT, this.info, List.get(cc, this.info, expr1.arg(0), expr2.arg(0)));
        }
        if (expr == this && numbers && noArray && st1.one() && st2.one()) {
            ANum num;
            Expr ex = this.calc.optimize(expr1, expr2, this.info, cc);
            if (ex != null) {
                expr = ex;
            } else if (expr1 instanceof Arith) {
                Arith arth1 = (Arith)expr1;
                Calc acalc = arth1.calc;
                boolean add = acalc.oneOf(Calc.ADD, Calc.MULTIPLY);
                boolean sub = acalc.oneOf(Calc.SUBTRACT, Calc.DIVIDE);
                boolean inverse = acalc == this.calc.invert();
                Expr arg1 = arth1.arg(0);
                Expr arg2 = arth1.arg(1);
                if (arg2 instanceof ANum && expr2 instanceof ANum && (acalc == this.calc || inverse)) {
                    Calc ncalc;
                    Calc calc = add ? this.calc : (ncalc = sub ? this.calc.invert() : null);
                    if (ncalc != null) {
                        expr = new Arith(this.info, arg1, new Arith(this.info, arg2, expr2, ncalc).optimize(cc), acalc).optimize(cc);
                    }
                } else if (inverse) {
                    Expr expr3 = arg2.equals(expr2) ? arg1 : (expr = arg1.equals(expr2) && add ? arg2 : this);
                    if (expr != this) {
                        expr = new Cast(this.info, expr, Types.NUMERIC_O).optimize(cc);
                    }
                }
            } else if (this.calc.oneOf(Calc.ADD, Calc.SUBTRACT) && expr2 instanceof ANum && (num = (ANum)expr2).dbl() < 0.0) {
                Expr inv2 = new Unary(this.info, (Expr)num, true).optimize(cc);
                expr = new Arith(this.info, expr1, inv2, this.calc.invert()).optimize(cc);
            }
        }
        if (expr == this && this.calcOpt == null && !(expr instanceof ArithSimple)) {
            this.calcOpt = CalcOpt.get(st1, st2, this.calc);
            if (this.calcOpt != null && st1.zeroOrOne() && st2.zeroOrOne()) {
                expr = new ArithSimple(this.info, expr1, expr2, this.calc, this.calcOpt);
            }
        }
        return cc.replaceWith(this, expr);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1.isEmpty()) {
            return Empty.VALUE;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        if (item2.isEmpty()) {
            return Empty.VALUE;
        }
        return this.calcOpt != null ? this.calcOpt.eval(item1, item2, this.info) : this.calc.eval(item1, item2, this.info);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr;
        Expr expr2 = this;
        if (mode == CompileContext.Simplify.PREDICATE && Function.LAST.is(this.exprs[0]) && (expr = this.exprs[1]) instanceof ANum) {
            ANum num = (ANum)expr;
            double d = num.dbl();
            if (this.calc == Calc.ADD && d > 0.0 || this.calc == Calc.SUBTRACT && d < 0.0 || this.calc == Calc.MULTIPLY && d > 1.0 || this.calc == Calc.DIVIDE && d < 1.0) {
                expr2 = Bln.FALSE;
            }
        }
        return cc.simplify(this, expr2, mode);
    }

    @Override
    public Arith copy(CompileContext cc, IntObjectMap<Var> vm) {
        Arith arith = new Arith(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.calc);
        arith.calcOpt = this.calcOpt;
        return this.copyType(arith);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Arith)) return false;
        Arith arth = (Arith)obj;
        if (this.calc != arth.calc) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return "'" + this.calc.name + "' calculation";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.calc.name), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + this.calc.name + " ", true);
    }
}

