/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.bin.Bit;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

abstract class BinFn
extends StandardFunc {
    private static final byte[][] BIG = Token.tokens("most-significant-first", "big-endian", "BE");
    private static final byte[][] LITTLE = Token.tokens("least-significant-first", "little-endian", "LE");

    BinFn() {
    }

    final ByteBuffer unpack(QueryContext qc, long len) throws QueryException {
        Bin binary = this.toBin(this.arg(0), qc);
        long offset = this.toLong(this.arg(1), qc);
        ByteOrder order = this.order(this.arg(2), qc);
        byte[] bytes = binary.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(offset, len, bl);
        ByteBuffer bb = ByteBuffer.allocate(bounds[1]).order(order);
        bb.put(bytes, bounds[0], bounds[1]).position(0);
        return bb;
    }

    final Itr unpackInteger(QueryContext qc, boolean signed) throws QueryException {
        BigInteger bi;
        long v;
        Bin binary = this.toBin(this.arg(0), qc);
        long offset = this.toLong(this.arg(1), qc);
        long size = this.toLong(this.arg(2), qc);
        ByteOrder order = this.order(this.arg(3), qc);
        byte[] bytes = binary.binary(this.info);
        int[] bounds = this.bounds(offset, size, bytes.length);
        int o = bounds[0];
        int l = bounds[1];
        if (l == 0) {
            return Itr.ZERO;
        }
        byte[] result = new byte[l];
        ByteBuffer.wrap(bytes, o, l).order(order).get(result);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            int i = 0;
            for (int j = l - 1; i < j; ++i, --j) {
                byte tmp = result[i];
                result[i] = result[j];
                result[j] = tmp;
            }
        }
        if (BigInteger.valueOf(v = (bi = signed ? new BigInteger(result) : new BigInteger(1, result)).longValue()).equals(bi)) {
            return Itr.get(v);
        }
        throw QueryError.BIN_ITL_X_X.get(this.info, bi);
    }

    final Item bit(Bit op, QueryContext qc) throws QueryException {
        byte[] bytes2;
        int bl2;
        Bin binary1 = this.toBinOrNull(this.arg(0), qc);
        Bin binary2 = this.toBinOrNull(this.arg(1), qc);
        if (binary1 == null || binary2 == null) {
            return Empty.VALUE;
        }
        byte[] bytes1 = binary1.binary(this.info);
        int bl1 = bytes1.length;
        if (bl1 != (bl2 = (bytes2 = binary2.binary(this.info)).length)) {
            throw QueryError.BIN_DLA_X_X.get(this.info, bl1, bl2);
        }
        if (bl1 == 1) {
            return B64.get(op.eval(bytes1[0], bytes2[0]));
        }
        byte[] tmp = new byte[bl1];
        for (int b = 0; b < bl1; ++b) {
            tmp[b] = op.eval(bytes1[b], bytes2[b]);
        }
        return B64.get(tmp);
    }

    final Item pad(QueryContext qc, boolean left) throws QueryException {
        long oct;
        Bin binary = this.toBinOrNull(this.arg(0), qc);
        long size = this.toLong(this.arg(1), qc);
        Long octet = this.toLongOrNull(this.arg(2), qc);
        if (binary == null) {
            return Empty.VALUE;
        }
        byte[] bytes = binary.binary(this.info);
        int bl = bytes.length;
        if (size < 0L) {
            throw QueryError.BIN_NS_X.get(this.info, size);
        }
        long l = oct = octet != null ? octet : 0L;
        if (oct < 0L || oct > 255L) {
            throw QueryError.BIN_OOR_X.get(this.info, octet);
        }
        byte[] tmp = new byte[(int)((long)bl + size)];
        if (left) {
            Arrays.fill(tmp, 0, (int)size, (byte)oct);
            Array.copyFromStart(bytes, bl, tmp, (int)size);
        } else {
            Array.copy(bytes, bl, tmp);
            Arrays.fill(tmp, bl, tmp.length, (byte)oct);
        }
        return B64.get(tmp);
    }

    final ByteOrder order(Expr expr, QueryContext qc) throws QueryException {
        byte[] order = this.toTokenOrNull(expr, qc);
        if (order == null || Token.eq(order, BIG)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (Token.eq(order, LITTLE)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw QueryError.BIN_USO_X.get(this.info, new Object[]{order});
    }

    final int[] bounds(Long offset, Long length, int size) throws QueryException {
        int sz;
        int of = 0;
        if (offset != null) {
            if (offset < 0L || offset > (long)size) {
                throw QueryError.BIN_IOOR_X_X.get(this.info, offset, size);
            }
            of = (int)offset.longValue();
        }
        if (length != null) {
            if (length < 0L) {
                throw QueryError.BIN_NS_X.get(this.info, offset);
            }
            if ((long)of + length > (long)size || length > Integer.MAX_VALUE) {
                throw QueryError.BIN_IOOR_X_X.get(this.info, (long)of + length, size);
            }
            sz = (int)length.longValue();
        } else {
            sz = size - of;
        }
        return new int[]{of, sz};
    }

    final byte[] toDigits(QueryContext qc) throws QueryException {
        byte[] string = this.toTokenOrNull(this.arg(0), qc);
        if (string == null) {
            return null;
        }
        ByteList bl = new ByteList(string.length);
        for (byte b : string) {
            if (b == 95 || Token.ws(b)) continue;
            bl.add(b);
        }
        return bl.finish();
    }

    final byte[] binary2bytes(byte[] bytes) throws QueryException {
        int bl = bytes.length;
        int r = bl & 7;
        int l = 8 - r & 7;
        int s = bl + 7 >>> 3;
        byte[] tmp = new byte[s];
        for (int i = 0; i < bl; ++i) {
            byte b = bytes[i];
            if (b == 49) {
                int n = l + i >>> 3;
                tmp[n] = (byte)(tmp[n] | 128 >>> (i - r & 7));
                continue;
            }
            if (b == 48) continue;
            throw QueryError.BIN_NNC.get(this.info, new Object[0]);
        }
        return tmp;
    }
}

