/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryString;
import org.basex.query.expr.AFilter;
import org.basex.query.expr.Arith;
import org.basex.query.expr.CachedFilter;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpOp;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.List;
import org.basex.query.expr.MixedPos;
import org.basex.query.expr.Pos;
import org.basex.query.expr.Range;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.SimplePos;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Itr;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public abstract class Filter
extends AFilter {
    protected Filter(InputInfo info, Expr root, Expr ... preds) {
        super(info, Types.ITEM_ZM, root, preds);
    }

    public static Expr get(CompileContext cc, InputInfo info, Expr root, Expr ... preds) throws QueryException {
        return preds.length == 0 ? root : new CachedFilter(info, root, preds).optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        Expr expr2 = this.root;
        if (expr2 instanceof Filter) {
            Filter filter = (Filter)expr2;
            this.root = filter.root;
            this.exprs = ExprList.concat(filter.exprs, this.exprs);
        }
        if (this.root.seqType().zero()) {
            return cc.replaceWith(this, this.root);
        }
        if (this.optimize(cc, this.root)) {
            return cc.emptySeq(this);
        }
        if (this.exprs.length == 0) {
            return this.root;
        }
        if (!this.mayBePositional()) {
            if (this.root instanceof ContextValue && this.root.ddo()) {
                return Path.get(cc, this.info, null, Step.self(cc, this.root, this.info, this.exprs));
            }
            expr2 = this.root;
            if (expr2 instanceof AxisPath) {
                AxisPath path = (AxisPath)expr2;
                return path.addPredicates(cc, this.exprs);
            }
            if (this.root.seqType().type == NodeType.DOCUMENT_NODE && this.root.ddo()) {
                Expr step = Step.self(cc, this.root, this.info, this.exprs);
                return cc.replaceWith(this, Path.get(cc, this.info, this.root, step));
            }
            expr = this.exprs[0];
            if (this.exprs.length == 1 && expr.isSimple() && !expr.seqType().mayBeNumber()) {
                Expr iff = new If(this.info, expr, this.root).optimize(cc);
                return cc.replaceWith(this, iff);
            }
            ExprList unroll = cc.unroll(this.root, false);
            if (unroll != null) {
                long last = this.root.size() - 1L;
                ExprList results = new ExprList(unroll.size());
                for (Expr ex : unroll) {
                    results.add(Filter.get(cc, this.info, ex, (long)results.size() == last ? this.exprs : Filter.copyAll((CompileContext)cc, new IntObjectMap(), (Expr[])this.exprs)));
                }
                return List.get(cc, this.info, (Expr[])results.finish());
            }
            return this.copyType(new IterFilter(this.info, this.root, this.exprs));
        }
        expr = this.root;
        boolean opt = false;
        ExprList preds = new ExprList(this.exprs.length);
        QueryFunction<Expr, Expr> add = e -> preds.isEmpty() ? e : Filter.get(cc, this.info, e, (Expr[])preds.next());
        Predicate<Expr> simpleInt = e -> e.seqType().eq(Types.INTEGER_O) && e.isSimple();
        for (Expr pred : this.exprs) {
            Expr ex = null;
            if (pred instanceof IntPos) {
                IntPos pos = (IntPos)pred;
                ex = cc.function(Function._UTIL_RANGE, this.info, add.apply(expr), Itr.get(pos.min), Itr.get(pos.max));
            } else if (pred instanceof SimplePos) {
                SimplePos pos = (SimplePos)pred;
                ex = pos.exact() ? cc.function(Function.ITEMS_AT, this.info, add.apply(expr), pred.arg(0)) : cc.function(Function._UTIL_RANGE, this.info, add.apply(expr), pred.arg(0), pred.arg(1));
            } else if (pred instanceof Pos) {
                Arith arth;
                Pos pos = (Pos)pred;
                posExpr = pos.expr;
                if (posExpr instanceof Range) {
                    Arith arth1;
                    Arith arth2;
                    Expr arg1 = posExpr.arg(0);
                    Expr arg2 = posExpr.arg(1);
                    if (simpleInt.test(arg1) && Function.LAST.is(arg2)) {
                        ex = cc.function(Function._UTIL_RANGE, this.info, add.apply(expr), arg1);
                    } else if (arg1 == Itr.ONE && arg2 instanceof Arith && Function.LAST.is((arth2 = (Arith)arg2).arg(0)) && arth2.calc == Calc.SUBTRACT && arth2.arg(1) == Itr.ONE) {
                        ex = cc.function(Function.TRUNK, this.info, add.apply(expr));
                    } else if (arg1 instanceof Arith && Function.LAST.is((arth1 = (Arith)arg1).arg(0)) && arth1.calc == Calc.SUBTRACT && simpleInt.test(arth1.arg(1)) && arg2 == Itr.MAX) {
                        ex = cc.function(Function.REVERSE, this.info, cc.function(Function.SUBSEQUENCE, this.info, cc.function(Function.REVERSE, this.info, add.apply(expr)), Itr.ONE, new Arith(this.info, arg1.arg(1), (Expr)Itr.ONE, Calc.ADD).optimize(cc)));
                    }
                } else if (Function.LAST.is(posExpr)) {
                    ex = cc.function(Function.FOOT, this.info, add.apply(expr));
                } else if (posExpr instanceof Arith && Function.LAST.is((arth = (Arith)posExpr).arg(0)) && arth.calc == Calc.SUBTRACT && simpleInt.test(arth.arg(1))) {
                    ex = cc.function(Function.ITEMS_AT, this.info, cc.function(Function.REVERSE, this.info, add.apply(expr)), new Arith(this.info, posExpr.arg(1), (Expr)Itr.ONE, Calc.ADD).optimize(cc));
                }
            } else if (pred instanceof MixedPos) {
                MixedPos pos = (MixedPos)pred;
                posExpr = pos.expr;
                boolean sorted = posExpr instanceof Value;
                ex = cc.function(Function.ITEMS_AT, this.info, add.apply(expr), sorted ? posExpr : cc.function(Function.SORT, this.info, cc.function(Function.DISTINCT_VALUES, this.info, posExpr)), Bln.get(sorted));
            } else if (pred instanceof CmpG) {
                CmpG cmp = (CmpG)pred;
                Expr op1 = pred.arg(0);
                Expr op2 = pred.arg(1);
                if (Function.POSITION.is(op1) && cmp.op == CmpOp.NE && op2.isSimple() && op2.seqType().instanceOf(Types.INTEGER_O)) {
                    ex = cc.function(Function.REMOVE, this.info, add.apply(expr), op2);
                }
            }
            if (ex != null) {
                expr = ex;
                opt = true;
                continue;
            }
            preds.add(pred);
        }
        return opt ? cc.replaceWith(this, add.apply(expr)) : this.copyType(new CachedFilter(this.info, this.root, this.exprs));
    }

    @Override
    protected final Expr type(Expr expr, boolean optimize) {
        this.exprType.assign(this.root.seqType().union(Occ.ZERO)).data(this.root);
        return this.root;
    }

    public final Expr addPredicate(CompileContext cc, Expr pred) throws QueryException {
        return this.copyType(Filter.get(cc, this.info, this.root, ExprList.concat(this.exprs, pred)));
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE)) {
            expr = this.flattenEbv(this.root, true, cc);
        } else if (mode == CompileContext.Simplify.DISTINCT && !this.mayBePositional()) {
            Expr ex = this.root.simplifyFor(mode, cc);
            if (ex != this.root) {
                expr = Filter.get(cc, this.info, ex, this.exprs);
            }
        } else if (mode == CompileContext.Simplify.COUNT && this.exprs.length == 1 && this.exprs[0].seqType().instanceOf(Types.NODE_ZO)) {
            expr = SimpleMap.get(cc, this.info, this.root, this.exprs[0]);
        }
        return cc.simplify(this, expr, mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Filter)) return false;
        Filter fltr = (Filter)obj;
        if (!this.root.equals(fltr.root)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token(this.root);
        super.toString(qs);
    }
}

