/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MapEntries
implements IdentifiedDataSerializable,
Iterable<Map.Entry<Data, Data>> {
    private List<Map.Entry<Data, Data>> entries;

    public MapEntries() {
    }

    public MapEntries(Collection<Map.Entry<Data, Data>> entries) {
        this.entries = new ArrayList<Map.Entry<Data, Data>>(entries);
    }

    public Collection<Map.Entry<Data, Data>> entries() {
        this.ensureEntriesCreated();
        return this.entries;
    }

    public void add(Map.Entry<Data, Data> entry) {
        this.ensureEntriesCreated();
        this.entries.add(entry);
    }

    public void add(Data key, Data value) {
        this.ensureEntriesCreated();
        this.entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value));
    }

    public int size() {
        return this.entries == null ? 0 : this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Map.Entry<Data, Data>> iterator() {
        this.ensureEntriesCreated();
        return this.entries.iterator();
    }

    private void ensureEntriesCreated() {
        if (this.entries == null) {
            this.entries = new ArrayList<Map.Entry<Data, Data>>();
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int size = this.entries == null ? 0 : this.entries.size();
        out.writeInt(size);
        if (size > 0) {
            for (Map.Entry<Data, Data> o : this.entries) {
                out.writeData(o.getKey());
                out.writeData(o.getValue());
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Data value = in.readData();
            AbstractMap.SimpleImmutableEntry<Data, Data> entry = new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value);
            this.entries.add(entry);
        }
    }
}

