/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.MapListenerAdapter;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableEntryEvent;

public class ClientMapListener
extends MapListenerAdapter<Object, Object> {
    private final long callId;
    private final ClientEndpoint endpoint;

    public ClientMapListener(ClientEndpoint endpoint, long callId) {
        this.endpoint = endpoint;
        this.callId = callId;
    }

    @Override
    public void onEntryEvent(EntryEvent<Object, Object> event) {
        if (this.endpoint.isAlive()) {
            if (!(event instanceof DataAwareEntryEvent)) {
                throw new IllegalArgumentException("Expecting: DataAwareEntryEvent, Found: " + event.getClass().getSimpleName());
            }
            DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
            Data key = dataAwareEntryEvent.getKeyData();
            Data value = dataAwareEntryEvent.getNewValueData();
            Data oldValue = dataAwareEntryEvent.getOldValueData();
            Data mergingValue = dataAwareEntryEvent.getMergingValueData();
            PortableEntryEvent portableEntryEvent = new PortableEntryEvent(key, value, oldValue, mergingValue, event.getEventType(), event.getMember().getUuid());
            this.endpoint.sendEvent(key, portableEntryEvent, this.callId);
        }
    }

    @Override
    public void onMapEvent(MapEvent event) {
        if (this.endpoint.isAlive()) {
            EntryEventType type = event.getEventType();
            String uuid = event.getMember().getUuid();
            PortableEntryEvent portableEntryEvent = new PortableEntryEvent(type, uuid, event.getNumberOfEntriesAffected());
            this.endpoint.sendEvent(null, portableEntryEvent, this.callId);
        }
    }
}

