/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.ringbuffer.impl.client.RingbufferRequest;
import com.hazelcast.ringbuffer.impl.operations.ReadOneOperation;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class ReadOneRequest
extends RingbufferRequest {
    private long sequence;

    public ReadOneRequest() {
    }

    public ReadOneRequest(String name, long sequence) {
        super(name);
        this.sequence = sequence;
    }

    @Override
    protected Operation prepareOperation() {
        return new ReadOneOperation(this.name, this.sequence);
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeLong("s", this.sequence);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.sequence = reader.readLong("s");
    }

    @Override
    public Permission getRequiredPermission() {
        return new RingBufferPermission(this.name, "read");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.sequence};
    }

    @Override
    public String getMethodName() {
        return "readOne";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

