/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ArgumentChangeFinder;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.CreatesDuplicateCallHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.InvocationInfo;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Matchers;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Parameter;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.function.Function;

@BugPattern(name="AutoValueConstructorOrderChecker", summary="Arguments to AutoValue constructor are in the wrong order", explanation="AutoValue constructors are synthesized with their parameters in the same order as the abstract accessor methods. Calls to the constructor need to match this ordering.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR)
public class AutoValueConstructorOrderChecker
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private ArgumentChangeFinder argumentChangeFinder = ArgumentChangeFinder.builder().setDistanceFunction(AutoValueConstructorOrderChecker.buildDistanceFunction()).addHeuristic(AutoValueConstructorOrderChecker.allArgumentsMustMatch()).addHeuristic(new CreatesDuplicateCallHeuristic()).build();

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!Matchers.AUTOVALUE_CONSTRUCTOR.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        InvocationInfo invocationInfo = InvocationInfo.createFromNewClass(tree, ASTHelpers.getSymbol((NewClassTree)tree), state);
        Changes changes = this.argumentChangeFinder.findChanges(invocationInfo);
        if (changes.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(invocationInfo.tree()).addFix((Fix)changes.buildPermuteArgumentsFix(invocationInfo)).build();
    }

    private static Function<ParameterPair, Double> buildDistanceFunction() {
        return new Function<ParameterPair, Double>(){

            @Override
            public Double apply(ParameterPair parameterPair) {
                Parameter formal = parameterPair.formal();
                Parameter actual = parameterPair.actual();
                if (formal.isUnknownName() || actual.isUnknownName()) {
                    return formal.index() == actual.index() ? 0.0 : 1.0;
                }
                return formal.name().equals(actual.name()) ? 0.0 : 1.0;
            }
        };
    }

    private static Heuristic allArgumentsMustMatch() {
        return (changes, node, sym, state) -> changes.assignmentCost().stream().allMatch(c -> c < 1.0);
    }
}

