/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

class TypeArgOfMethodArgMatcher
extends AbstractCollectionIncompatibleTypeMatcher {
    private final Matcher<ExpressionTree> methodMatcher;
    private final String receiverTypeName;
    private final int receiverTypeArgIndex;
    private final int methodArgIndex;
    private final String methodArgTypeName;
    private final int methodArgTypeArgIndex;

    public TypeArgOfMethodArgMatcher(String receiverTypeName, String signature, int receiverTypeArgIndex, int methodArgIndex, String methodArgTypeName, int methodArgTypeArgIndex) {
        this.methodMatcher = MethodMatchers.instanceMethod().onDescendantOf(receiverTypeName).withSignature(signature);
        this.receiverTypeName = receiverTypeName;
        this.receiverTypeArgIndex = receiverTypeArgIndex;
        this.methodArgIndex = methodArgIndex;
        this.methodArgTypeName = methodArgTypeName;
        this.methodArgTypeArgIndex = methodArgTypeArgIndex;
    }

    @Override
    Matcher<ExpressionTree> methodMatcher() {
        return this.methodMatcher;
    }

    @Override
    ExpressionTree extractSourceTree(MethodInvocationTree tree, VisitorState state) {
        return (ExpressionTree)Iterables.get(tree.getArguments(), (int)this.methodArgIndex);
    }

    @Override
    Type extractSourceType(MethodInvocationTree tree, VisitorState state) {
        return TypeArgOfMethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)((Tree)Iterables.get(tree.getArguments(), (int)this.methodArgIndex))), state.getSymbolFromString(this.methodArgTypeName), this.methodArgTypeArgIndex, state.getTypes());
    }

    @Override
    Type extractTargetType(MethodInvocationTree tree, VisitorState state) {
        return TypeArgOfMethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getReceiverType((ExpressionTree)tree), state.getSymbolFromString(this.receiverTypeName), this.receiverTypeArgIndex, state.getTypes());
    }

    String getMethodArgTypeName() {
        return this.methodArgTypeName;
    }
}

