/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_ImmutableAnalysis_Violation;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.Name;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import org.pcollections.ConsPStack;

public class ImmutableAnalysis {
    private final BugChecker bugChecker;
    private final VisitorState state;
    private final WellKnownMutability wellKnownMutability;
    private final String nonFinalFieldMessage;
    private final String mutableFieldMessage;

    public ImmutableAnalysis(BugChecker bugChecker, VisitorState state, WellKnownMutability wellKnownMutability, String nonFinalFieldMessage, String mutableFieldMessage) {
        this.bugChecker = bugChecker;
        this.state = state;
        this.wellKnownMutability = wellKnownMutability;
        this.nonFinalFieldMessage = nonFinalFieldMessage;
        this.mutableFieldMessage = mutableFieldMessage;
    }

    Violation checkForImmutability(Optional<ClassTree> tree, ImmutableSet<String> immutableTyParams, Type.ClassType type) {
        Violation info = this.areFieldsImmutable(tree, immutableTyParams, type);
        if (info.isPresent()) {
            return info;
        }
        for (Type interfaceType : this.state.getTypes().interfaces(type)) {
            AnnotationInfo interfaceAnnotation = this.getImmutableAnnotation(interfaceType.tsym, this.state);
            if (interfaceAnnotation == null || !(info = this.immutableInstantiation(immutableTyParams, interfaceAnnotation, interfaceType)).isPresent()) continue;
            return info.plus(String.format("'%s' extends '%s'", this.getPrettyName(type.tsym), this.getPrettyName(interfaceType.tsym)));
        }
        info = this.checkSuper(immutableTyParams, type);
        if (info.isPresent()) {
            return info;
        }
        Type mutableEnclosing = this.mutableEnclosingInstance(tree, type);
        if (mutableEnclosing != null) {
            return info.plus(String.format("'%s' has mutable enclosing instance '%s'", this.getPrettyName(type.tsym), mutableEnclosing));
        }
        return Violation.absent();
    }

    private Type mutableEnclosingInstance(Optional<ClassTree> tree, Type.ClassType type) {
        if (tree.isPresent() && !CanBeStaticAnalyzer.referencesOuter(tree.get(), ASTHelpers.getSymbol((ClassTree)tree.get()), this.state)) {
            return null;
        }
        Type enclosing = type.getEnclosingType();
        while (!Type.noType.equals(enclosing)) {
            if (this.getImmutableAnnotation(enclosing.tsym, this.state) == null && this.isImmutableType((ImmutableSet<String>)ImmutableSet.of(), enclosing).isPresent()) {
                return enclosing;
            }
            enclosing = enclosing.getEnclosingType();
        }
        return null;
    }

    private Violation checkSuper(ImmutableSet<String> immutableTyParams, Type.ClassType type) {
        Type.ClassType superType = (Type.ClassType)this.state.getTypes().supertype(type);
        if (superType.getKind() == TypeKind.NONE || this.state.getTypes().isSameType(this.state.getSymtab().objectType, superType)) {
            return Violation.absent();
        }
        if (WellKnownMutability.isAnnotation(this.state, type)) {
            return Violation.absent();
        }
        AnnotationInfo superannotation = this.getImmutableAnnotation(superType.tsym, this.state);
        if (superannotation != null) {
            Violation info = this.immutableInstantiation(immutableTyParams, superannotation, superType);
            if (!info.isPresent()) {
                return Violation.absent();
            }
            return info.plus(String.format("'%s' extends '%s'", this.getPrettyName(type.tsym), this.getPrettyName(superType.tsym)));
        }
        Violation info = this.checkForImmutability(Optional.empty(), immutableTyParams, superType);
        if (!info.isPresent()) {
            return Violation.absent();
        }
        return info.plus(String.format("'%s' extends '%s'", this.getPrettyName(type.tsym), this.getPrettyName(superType.tsym)));
    }

    Violation areFieldsImmutable(Optional<ClassTree> tree, ImmutableSet<String> immutableTyParams, Type.ClassType classType) {
        Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)classType.tsym;
        if (classSym.members() == null) {
            return Violation.absent();
        }
        Filter<Symbol> instanceFieldFilter = new Filter<Symbol>(){

            public boolean accepts(Symbol symbol) {
                return symbol.getKind() == ElementKind.FIELD && !symbol.isStatic();
            }
        };
        HashMap<Symbol, Tree> declarations = new HashMap<Symbol, Tree>();
        if (tree.isPresent()) {
            for (Tree tree2 : tree.get().getMembers()) {
                Symbol sym = ASTHelpers.getSymbol((Tree)tree2);
                if (sym == null) continue;
                declarations.put(sym, tree2);
            }
        }
        ImmutableList members = ImmutableList.copyOf((Iterable)classSym.members().getSymbols((Filter)instanceFieldFilter)).reverse();
        for (Symbol member : members) {
            Optional<Tree> memberTree = Optional.ofNullable(declarations.get(member));
            Violation info = this.isFieldImmutable(memberTree, immutableTyParams, classSym, classType, (Symbol.VarSymbol)member);
            if (!info.isPresent()) continue;
            return info;
        }
        return Violation.absent();
    }

    private Violation isFieldImmutable(Optional<Tree> tree, ImmutableSet<String> immutableTyParams, Symbol.ClassSymbol classSym, Type.ClassType classType, Symbol.VarSymbol var) {
        if (this.bugChecker.isSuppressed((Symbol)var)) {
            return Violation.absent();
        }
        if (ASTHelpers.hasAnnotation((Symbol)var, LazyInit.class, (VisitorState)this.state)) {
            return Violation.absent();
        }
        if (!var.getModifiers().contains((Object)Modifier.FINAL)) {
            if (tree.isPresent()) {
                this.state.reportMatch(BugChecker.buildDescriptionFromChecker((Tree)tree.get(), (BugChecker)this.bugChecker).setMessage(this.nonFinalFieldMessage).addFix((Fix)SuggestedFixes.addModifiers((Tree)tree.get(), (VisitorState)this.state, (Modifier[])new Modifier[]{Modifier.FINAL})).build());
                return Violation.absent();
            }
            return Violation.of(String.format("'%s' has non-final field '%s'", this.getPrettyName(classSym), var.getSimpleName()));
        }
        Type varType = this.state.getTypes().memberType(classType, var);
        Violation info = this.isImmutableType(immutableTyParams, varType);
        if (info.isPresent()) {
            if (tree.isPresent()) {
                this.state.reportMatch(BugChecker.buildDescriptionFromChecker((Tree)tree.get(), (BugChecker)this.bugChecker).setMessage(info.plus(this.mutableFieldMessage).message()).build());
                return Violation.absent();
            }
            return info.plus(String.format("'%s' has field '%s' of type '%s'", this.getPrettyName(classSym), var.getSimpleName(), varType));
        }
        return Violation.absent();
    }

    Violation immutableInstantiation(ImmutableSet<String> immutableTyParams, AnnotationInfo annotation, Type type) {
        if (!annotation.containerOf().isEmpty() && type.tsym.getTypeParameters().size() != type.getTypeArguments().size()) {
            return Violation.of(String.format("'%s' required immutable instantiation of '%s', but was raw", this.getPrettyName(type.tsym), Joiner.on((String)", ").join(annotation.containerOf())));
        }
        for (int i = 0; i < type.tsym.getTypeParameters().size(); ++i) {
            Type tyarg;
            Violation info;
            Symbol.TypeVariableSymbol typaram = type.tsym.getTypeParameters().get(i);
            if (!annotation.containerOf().contains(((Name)typaram.getSimpleName()).toString()) || !(info = this.isImmutableType(immutableTyParams, tyarg = type.getTypeArguments().get(i))).isPresent()) continue;
            return info.plus(String.format("'%s' was instantiated with mutable type for '%s'", this.getPrettyName(type.tsym), typaram.getSimpleName()));
        }
        return Violation.absent();
    }

    Violation isImmutableType(ImmutableSet<String> immutableTyParams, Type type) {
        return type.accept(new ImmutableTypeVisitor(immutableTyParams), null);
    }

    AnnotationInfo getImmutableAnnotation(Symbol sym, VisitorState state) {
        String nameStr = sym.flatName().toString();
        AnnotationInfo known = this.wellKnownMutability.getKnownImmutableClasses().get(nameStr);
        if (known != null) {
            return known;
        }
        return ImmutableAnalysis.getInheritedAnnotation(sym, state);
    }

    static AnnotationInfo getInheritedAnnotation(Symbol sym, VisitorState state) {
        if (!(sym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Attribute.Compound attr = sym.attribute(state.getSymbolFromString(Immutable.class.getName()));
        if (attr != null) {
            return AnnotationInfo.create(sym.getQualifiedName().toString(), ImmutableAnalysis.containerOf(state, attr));
        }
        Type superClass = ((Symbol.ClassSymbol)sym).getSuperclass();
        AnnotationInfo superAnnotation = ImmutableAnalysis.getInheritedAnnotation(superClass.asElement(), state);
        if (superAnnotation == null) {
            return null;
        }
        ImmutableList.Builder containerOf = ImmutableList.builder();
        for (int i = 0; i < superClass.getTypeArguments().size(); ++i) {
            Type arg = superClass.getTypeArguments().get(i);
            Symbol.TypeVariableSymbol formal = superClass.asElement().getTypeParameters().get(i);
            if (!arg.hasTag(TypeTag.TYPEVAR)) continue;
            Symbol.TypeSymbol argSym = arg.asElement();
            if (argSym.owner != sym || !superAnnotation.containerOf().contains(((Name)formal.getSimpleName()).toString())) continue;
            containerOf.add((Object)((Name)argSym.getSimpleName()).toString());
        }
        return AnnotationInfo.create(sym.getQualifiedName().toString(), (Iterable<String>)containerOf.build());
    }

    private static ImmutableList<String> containerOf(VisitorState state, Attribute.Compound attr) {
        Attribute m = attr.member(state.getName("containerOf"));
        if (m == null) {
            return ImmutableList.of();
        }
        final ImmutableList.Builder containerOf = ImmutableList.builder();
        m.accept(new SimpleAnnotationValueVisitor8<Void, Void>(){

            @Override
            public Void visitString(String s, Void unused) {
                containerOf.add((Object)s);
                return null;
            }

            @Override
            public Void visitArray(List<? extends AnnotationValue> list, Void unused) {
                for (AnnotationValue annotationValue : list) {
                    annotationValue.accept(this, null);
                }
                return null;
            }
        }, null);
        return containerOf.build();
    }

    AnnotationInfo getImmutableAnnotation(Tree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        return sym == null ? null : this.getImmutableAnnotation(sym, state);
    }

    private String getPrettyName(Symbol sym) {
        if (!sym.getSimpleName().isEmpty()) {
            return sym.getSimpleName().toString();
        }
        if (sym.getKind() == ElementKind.ENUM) {
            return sym.owner.getSimpleName().toString();
        }
        Type superType = this.state.getTypes().supertype(sym.type);
        if (this.state.getTypes().isSameType(superType, this.state.getSymtab().objectType)) {
            superType = (Type)Iterables.getFirst(this.state.getTypes().interfaces(sym.type), (Object)superType);
        }
        return ((Name)superType.tsym.getSimpleName()).toString();
    }

    private class ImmutableTypeVisitor
    extends Types.SimpleVisitor<Violation, Void> {
        private final ImmutableSet<String> immutableTyParams;

        private ImmutableTypeVisitor(ImmutableSet<String> immutableTyParams) {
            this.immutableTyParams = immutableTyParams;
        }

        @Override
        public Violation visitWildcardType(Type.WildcardType type, Void s) {
            return ImmutableAnalysis.this.state.getTypes().wildUpperBound(type).accept(this, null);
        }

        @Override
        public Violation visitArrayType(Type.ArrayType t, Void s) {
            return Violation.of("arrays are mutable");
        }

        @Override
        public Violation visitTypeVar(Type.TypeVar type, Void s) {
            Symbol.TypeVariableSymbol tyvar = (Symbol.TypeVariableSymbol)type.tsym;
            if (this.immutableTyParams != null && this.immutableTyParams.contains((Object)((Name)tyvar.getSimpleName()).toString())) {
                return Violation.absent();
            }
            String message = this.immutableTyParams.isEmpty() ? String.format("'%s' is a mutable type variable", tyvar.getSimpleName()) : String.format("'%s' is a mutable type variable (not in '%s')", tyvar.getSimpleName(), Joiner.on((String)", ").join(this.immutableTyParams));
            return Violation.of(message);
        }

        @Override
        public Violation visitType(Type type, Void s) {
            switch (type.tsym.getKind()) {
                case ANNOTATION_TYPE: {
                    return Violation.absent();
                }
                case ENUM: {
                    return Violation.absent();
                }
                case INTERFACE: 
                case CLASS: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unexpected type kind %s", new Object[]{type.tsym.getKind()}));
                }
            }
            if (WellKnownMutability.isAnnotation(ImmutableAnalysis.this.state, type)) {
                return Violation.absent();
            }
            AnnotationInfo annotation = ImmutableAnalysis.this.getImmutableAnnotation(type.tsym, ImmutableAnalysis.this.state);
            if (annotation != null) {
                return ImmutableAnalysis.this.immutableInstantiation(this.immutableTyParams, annotation, type);
            }
            String nameStr = type.tsym.flatName().toString();
            if (ImmutableAnalysis.this.wellKnownMutability.getKnownUnsafeClasses().contains(nameStr)) {
                return Violation.of(String.format("'%s' is mutable", type.tsym.getSimpleName()));
            }
            if (WellKnownMutability.isProto2MessageClass(ImmutableAnalysis.this.state, type)) {
                if (WellKnownMutability.isProto2MutableMessageClass(ImmutableAnalysis.this.state, type)) {
                    return Violation.of(String.format("'%s' is a mutable proto message", type.tsym.getSimpleName()));
                }
                return Violation.absent();
            }
            return Violation.of(String.format("the declaration of type '%s' is not annotated @Immutable", type));
        }
    }

    static abstract class Violation {
        Violation() {
        }

        private static Violation create(ConsPStack<String> path) {
            return new AutoValue_ImmutableAnalysis_Violation(path);
        }

        boolean isPresent() {
            return !this.path().isEmpty();
        }

        String message() {
            return Joiner.on((String)", ").join(this.path());
        }

        abstract ConsPStack<String> path();

        Violation plus(String edge) {
            return Violation.create((ConsPStack<String>)this.path().plus((Object)edge));
        }

        static Violation of(String reason) {
            return Violation.create((ConsPStack<String>)ConsPStack.singleton((Object)reason));
        }

        static Violation absent() {
            return Violation.create((ConsPStack<String>)ConsPStack.empty());
        }
    }
}

