/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.errorprone.refaster.AutoValue_UBlank;
import com.google.errorprone.refaster.Bindings;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.ControlFlowVisitor;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.PlaceholderUnificationVisitor;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.UUID;

abstract class UBlank
implements UStatement {
    private static final TreeScanner<Boolean, Unifier> FORBIDDEN_REFERENCE_SCANNER = new TreeScanner<Boolean, Unifier>(){

        @Override
        public Boolean reduce(Boolean l, Boolean r) {
            return (Boolean)MoreObjects.firstNonNull((Object)l, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)r, (Object)false) != false;
        }

        @Override
        public Boolean scan(Tree t, Unifier unifier) {
            if (t != null) {
                Boolean forbidden = t.accept(PlaceholderUnificationVisitor.FORBIDDEN_REFERENCE_VISITOR, unifier);
                return (Boolean)MoreObjects.firstNonNull((Object)forbidden, (Object)false) != false || (Boolean)MoreObjects.firstNonNull(super.scan(t, unifier), (Object)false) != false;
            }
            return false;
        }
    };

    UBlank() {
    }

    static UBlank create() {
        return new AutoValue_UBlank(UUID.randomUUID());
    }

    abstract UUID unique();

    Key key() {
        return new Key(this.unique());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OTHER;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitOther(this, data);
    }

    public Choice<UStatement.UnifierWithUnconsumedStatements> apply(UStatement.UnifierWithUnconsumedStatements state) {
        StatementTree stmt;
        int goodIndex;
        for (goodIndex = 0; !(goodIndex >= state.unconsumedStatements().size() || ((Boolean)MoreObjects.firstNonNull((Object)FORBIDDEN_REFERENCE_SCANNER.scan(stmt = state.unconsumedStatements().get(goodIndex), state.unifier()), (Object)false)).booleanValue() && ControlFlowVisitor.INSTANCE.visitStatement(stmt) == ControlFlowVisitor.Result.NEVER_EXITS); ++goodIndex) {
        }
        ContiguousSet breakPoints = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(goodIndex)), (DiscreteDomain)DiscreteDomain.integers());
        return Choice.from(breakPoints).transform(k -> {
            Unifier unifier = state.unifier().fork();
            unifier.putBinding(this.key(), state.unconsumedStatements().subList(0, (int)k));
            java.util.List<? extends StatementTree> remaining = state.unconsumedStatements().subList((int)k, state.unconsumedStatements().size());
            return UStatement.UnifierWithUnconsumedStatements.create(unifier, remaining);
        });
    }

    @Override
    public List<JCTree.JCStatement> inlineStatements(Inliner inliner) {
        ListBuffer<JCTree.JCStatement> buffer = new ListBuffer<JCTree.JCStatement>();
        for (StatementTree stmt : (java.util.List)inliner.getOptionalBinding(this.key()).or((Object)ImmutableList.of())) {
            buffer.add((JCTree.JCStatement)stmt);
        }
        return buffer.toList();
    }

    static class Key
    extends Bindings.Key<java.util.List<? extends StatementTree>> {
        Key(UUID k) {
            super(k.toString());
        }
    }
}

