/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_ULambda;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UTree;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;

abstract class ULambda
extends UExpression
implements LambdaExpressionTree {
    ULambda() {
    }

    public static ULambda create(JCTree.JCLambda.ParameterKind parameterKind, Iterable<UVariableDecl> parameters, UTree<?> body) {
        return new AutoValue_ULambda(parameterKind, (ImmutableList<UVariableDecl>)ImmutableList.copyOf(parameters), body);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LAMBDA_EXPRESSION;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitLambdaExpression(this, data);
    }

    @Override
    public Choice<Unifier> visitLambdaExpression(LambdaExpressionTree node, Unifier unifier) {
        return Unifier.unifyList(unifier, this.getParameters(), node.getParameters()).thenChoose(Unifier.unifications(this.getBody(), node.getBody()));
    }

    @Override
    public JCTree.JCLambda inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Lambda(this.inlineParams(inliner), this.inlineBody(inliner));
    }

    public List<JCTree.JCVariableDecl> inlineParams(Inliner inliner) throws CouldNotResolveImportException {
        if (this.parameterKind() == JCTree.JCLambda.ParameterKind.EXPLICIT) {
            return List.convert(JCTree.JCVariableDecl.class, inliner.inlineList(this.getParameters()));
        }
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        for (UVariableDecl param : this.getParameters()) {
            params.add(param.inlineImplicitType(inliner));
        }
        return params.toList();
    }

    JCTree inlineBody(Inliner inliner) throws CouldNotResolveImportException {
        UPlaceholderExpression body;
        Optional<List<JCTree.JCStatement>> blockBinding;
        if (this.getBody() instanceof UPlaceholderExpression && (blockBinding = inliner.getOptionalBinding((body = (UPlaceholderExpression)this.getBody()).placeholder().blockKey())).isPresent()) {
            List<JCTree.JCStatement> blockInlined = UPlaceholderExpression.copier(body.arguments(), inliner).copy((List)blockBinding.get(), inliner);
            if (blockInlined.size() == 1) {
                if (blockInlined.get(0) instanceof JCTree.JCReturn) {
                    return ((JCTree.JCReturn)blockInlined.get(0)).getExpression();
                }
                if (blockInlined.get(0) instanceof JCTree.JCExpressionStatement) {
                    return ((JCTree.JCExpressionStatement)blockInlined.get(0)).getExpression();
                }
            }
            return inliner.maker().Block(0L, blockInlined);
        }
        return (JCTree)this.getBody().inline(inliner);
    }

    abstract JCTree.JCLambda.ParameterKind parameterKind();

    public abstract ImmutableList<UVariableDecl> getParameters();

    @Override
    public abstract UTree<?> getBody();

    @Override
    public LambdaExpressionTree.BodyKind getBodyKind() {
        return this.getBody().getKind() == Tree.Kind.BLOCK ? LambdaExpressionTree.BodyKind.STATEMENT : LambdaExpressionTree.BodyKind.EXPRESSION;
    }
}

