/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Source
implements Comparable<Source> {
    private Package pkg;
    private String name;
    private String suffix;
    private long lastModified;
    private File file;
    private File root;
    private boolean isGenerated;
    private boolean linkedOnly;

    public boolean equals(Object o) {
        return o instanceof Source && this.name.equals(((Source)o).name);
    }

    @Override
    public int compareTo(Source o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Source(Module m, String n, File f, File r) {
        this.name = n;
        int dp = n.lastIndexOf(".");
        this.suffix = dp != -1 ? n.substring(dp) : "";
        this.file = f;
        this.root = r;
        this.lastModified = f.lastModified();
        this.linkedOnly = false;
    }

    public Source(Package p, String n, long lm) {
        this.pkg = p;
        this.name = n;
        int dp = n.lastIndexOf(".");
        this.suffix = dp != -1 ? n.substring(dp) : "";
        this.file = null;
        this.root = null;
        this.lastModified = lm;
        this.linkedOnly = false;
        int ls = n.lastIndexOf(47);
    }

    public String name() {
        return this.name;
    }

    public String suffix() {
        return this.suffix;
    }

    public Package pkg() {
        return this.pkg;
    }

    public File file() {
        return this.file;
    }

    public File root() {
        return this.root;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setPackage(Package p) {
        this.pkg = p;
    }

    public void markAsGenerated() {
        this.isGenerated = true;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void markAsLinkedOnly() {
        this.linkedOnly = true;
    }

    public boolean isLinkedOnly() {
        return this.linkedOnly;
    }

    private void save(StringBuilder b) {
        String CL = this.linkedOnly ? "L" : "C";
        String GS = this.isGenerated ? "G" : "S";
        b.append(GS + " " + CL + " " + this.name + " " + this.file.lastModified() + "\n");
    }

    public static Source load(Package lastPackage, String l, boolean isGenerated) {
        int sp = l.indexOf(32, 4);
        if (sp == -1) {
            return null;
        }
        String name = l.substring(4, sp);
        long last_modified = Long.parseLong(l.substring(sp + 1));
        boolean isLinkedOnly = false;
        if (l.charAt(2) == 'L') {
            isLinkedOnly = true;
        } else if (l.charAt(2) == 'C') {
            isLinkedOnly = false;
        } else {
            return null;
        }
        Source s = new Source(lastPackage, name, last_modified);
        s.file = new File(name);
        if (isGenerated) {
            s.markAsGenerated();
        }
        if (isLinkedOnly) {
            s.markAsLinkedOnly();
        }
        return s;
    }

    public static void saveSources(Map<String, Source> sources, StringBuilder b) {
        ArrayList<String> sorted_sources = new ArrayList<String>();
        for (String key : sources.keySet()) {
            sorted_sources.add(key);
        }
        Collections.sort(sorted_sources);
        for (String key : sorted_sources) {
            Source s = sources.get(key);
            s.save(b);
        }
    }

    public static void scanRoot(File root, Set<String> suffixes, List<String> excludes, List<String> includes, List<String> excludeFiles, List<String> includeFiles, Map<String, Source> foundFiles, Map<String, Module> foundModules, Module currentModule, boolean permitSourcesWithoutPackage, boolean inGensrc, boolean inLinksrc) throws ProblemException {
        File[] dirfiles;
        if (root == null) {
            return;
        }
        int root_prefix = root.getPath().length() + 1;
        currentModule = Source.addFilesInDir(root, root_prefix, root, suffixes, permitSourcesWithoutPackage, excludeFiles, includeFiles, foundFiles, foundModules, currentModule, inGensrc, inLinksrc);
        for (File d : dirfiles = root.listFiles()) {
            if (!d.isDirectory()) continue;
            Source.scanDirectory(d, root_prefix, root, suffixes, excludes, includes, excludeFiles, includeFiles, foundFiles, foundModules, currentModule, inGensrc, inLinksrc);
        }
    }

    private static boolean hasMatch(String path, List<String> patterns) {
        path = path.replace(File.separatorChar, '/');
        for (String p : patterns) {
            String patprefix;
            if (p.equals(path)) {
                return true;
            }
            if (!p.endsWith("/*") || !path.startsWith(patprefix = p.substring(0, p.length() - 2)) || path.length() != patprefix.length() && path.charAt(patprefix.length()) != '/') continue;
            return true;
        }
        return false;
    }

    private static boolean hasFileMatch(String path, List<String> patterns) {
        path = path.replace(File.separatorChar, '/');
        path = Util.normalizeDriveLetter(path);
        for (String p : patterns) {
            String patsuffix;
            if (p.equals(path)) {
                return true;
            }
            if (!p.startsWith("*") || !path.endsWith(patsuffix = p.substring(1))) continue;
            return true;
        }
        return false;
    }

    private static Module addFilesInDir(File dir, int rootPrefix, File root, Set<String> suffixes, boolean allow_javas, List<String> excludeFiles, List<String> includeFiles, Map<String, Source> foundFiles, Map<String, Module> foundModules, Module currentModule, boolean inGensrc, boolean inLinksrc) throws ProblemException {
        for (File f : dir.listFiles()) {
            boolean should_add;
            if (!f.isFile()) continue;
            boolean bl = should_add = !(excludeFiles != null && !excludeFiles.isEmpty() && Source.hasFileMatch(f.getPath(), excludeFiles) || includeFiles != null && !includeFiles.isEmpty() && !Source.hasFileMatch(f.getPath(), includeFiles));
            if (!should_add) continue;
            if (!allow_javas && f.getName().endsWith(".java")) {
                throw new ProblemException("No .java files are allowed in the source root " + dir.getPath() + ", please remove " + f.getName());
            }
            String fn = f.getPath().substring(rootPrefix);
            int sp = fn.lastIndexOf(File.separatorChar);
            String pkg = "";
            if (sp != -1) {
                pkg = fn.substring(0, sp).replace(File.separatorChar, '.');
            }
            if (fn.endsWith("module-info.java")) {
                if (!currentModule.name().equals("")) {
                    throw new ProblemException("You have an extra module-info.java inside a module! Please remove " + fn);
                }
                String module_name = fn.substring(0, fn.length() - 16);
                currentModule = new Module(module_name, f.getPath());
                foundModules.put(module_name, currentModule);
            }
            int dp = fn.lastIndexOf(".");
            String suffix = "";
            if (dp > 0) {
                suffix = fn.substring(dp);
            }
            if (!suffixes.contains(suffix)) continue;
            Source of = foundFiles.get(f.getPath());
            if (of != null) {
                throw new ProblemException("You have already added the file " + fn + " from " + of.file().getPath());
            }
            of = currentModule.lookupSource(f.getPath());
            if (of != null) {
                if (inLinksrc) {
                    if (of.isLinkedOnly()) {
                        throw new ProblemException("You have already added the link only file " + fn + " from " + of.file().getPath());
                    }
                    foundFiles.put(f.getPath(), of);
                    continue;
                }
                throw new ProblemException("Internal error: Double add of file " + fn + " from " + of.file().getPath());
            }
            Source s = new Source(currentModule, f.getPath(), f, root);
            if (inGensrc) {
                s.markAsGenerated();
            }
            if (inLinksrc) {
                s.markAsLinkedOnly();
            }
            pkg = currentModule.name() + ":" + pkg;
            foundFiles.put(f.getPath(), s);
            currentModule.addSource(pkg, s);
        }
        return currentModule;
    }

    private static void scanDirectory(File dir, int rootPrefix, File root, Set<String> suffixes, List<String> excludes, List<String> includes, List<String> excludeFiles, List<String> includeFiles, Map<String, Source> foundFiles, Map<String, Module> foundModules, Module currentModule, boolean inGensrc, boolean inLinksrc) throws ProblemException {
        String path = "";
        if (dir.getPath().length() > rootPrefix) {
            path = dir.getPath().substring(rootPrefix);
        }
        if ((includes == null || includes.isEmpty() || Source.hasMatch(path, includes)) && (excludes == null || excludes.isEmpty() || !Source.hasMatch(path, excludes))) {
            currentModule = Source.addFilesInDir(dir, rootPrefix, root, suffixes, true, excludeFiles, includeFiles, foundFiles, foundModules, currentModule, inGensrc, inLinksrc);
        }
        for (File d : dir.listFiles()) {
            if (!d.isDirectory()) continue;
            Source.scanDirectory(d, rootPrefix, root, suffixes, excludes, includes, excludeFiles, includeFiles, foundFiles, foundModules, currentModule, inGensrc, inLinksrc);
        }
    }
}

