/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.MethodNode;

public final class EnumEmptyConstructorFilter
implements IFilter {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CONSTRUCTOR_DESC = "(Ljava/lang/String;I)V";
    private static final String ENUM_TYPE = "java/lang/Enum";

    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (ENUM_TYPE.equals(context.getSuperClassName()) && CONSTRUCTOR_NAME.equals(methodNode.name) && CONSTRUCTOR_DESC.equals(methodNode.desc) && new Matcher().match(methodNode)) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        private boolean match(MethodNode methodNode) {
            this.firstIsALoad0(methodNode);
            this.nextIs(25);
            this.nextIs(21);
            this.nextIsInvoke(183, EnumEmptyConstructorFilter.ENUM_TYPE, EnumEmptyConstructorFilter.CONSTRUCTOR_NAME, EnumEmptyConstructorFilter.CONSTRUCTOR_DESC);
            this.nextIs(177);
            return this.cursor != null;
        }
    }
}

