/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Optional;

@BugPattern(name="MixedDescriptors", summary="The field number passed into #getFieldByNumber belongs to a different proto to the Descriptor.", severity=BugPattern.SeverityLevel.ERROR)
public final class MixedDescriptors
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_DESCRIPTOR = MethodMatchers.staticMethod().onDescendantOf("com.google.protobuf.Message").named("getDescriptor");
    private static final Matcher<ExpressionTree> FIND_FIELD = MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.Descriptors.Descriptor").named("findFieldByNumber");
    private static final Supplier<Type> MESSAGE = Suppliers.typeFromString((String)"com.google.protobuf.Message");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FIND_FIELD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!GET_DESCRIPTOR.matches((Tree)receiver, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() != 1) {
            return Description.NO_MATCH;
        }
        Symbol argumentSymbol = ASTHelpers.getSymbol((Tree)((Tree)Iterables.getOnlyElement(arguments)));
        if (!(argumentSymbol instanceof Symbol.VarSymbol) || !argumentSymbol.getSimpleName().toString().endsWith("_FIELD_NUMBER")) {
            return Description.NO_MATCH;
        }
        Optional<Symbol.TypeSymbol> descriptorType = MixedDescriptors.protoType((Tree)Iterables.getOnlyElement(arguments), state);
        Optional<Symbol.TypeSymbol> receiverType = MixedDescriptors.protoType(receiver, state);
        return MixedDescriptors.typesDiffer(descriptorType.filter(MixedDescriptors::shouldConsider), receiverType.filter(MixedDescriptors::shouldConsider)) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    private static boolean shouldConsider(Symbol.TypeSymbol symbol) {
        String packge = symbol.packge().toString();
        return !packge.contains(".proto1api") && !packge.contains(".proto2api");
    }

    private static boolean typesDiffer(Optional<Symbol.TypeSymbol> a, Optional<Symbol.TypeSymbol> b) {
        return a.isPresent() && b.isPresent() && !a.get().equals(b.get());
    }

    private static Optional<Symbol.TypeSymbol> protoType(Tree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol != null && symbol.owner instanceof Symbol.ClassSymbol && ASTHelpers.isSubtype((Type)symbol.owner.type, (Type)((Type)MESSAGE.get(state)), (VisitorState)state)) {
            return Optional.of(symbol.owner.type.tsym);
        }
        return Optional.empty();
    }
}

