/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.io.Serializable;

@BugPattern(name="RxReturnValueIgnored", summary="Returned Rx objects must be checked. Ignoring a returned Rx value means it is never scheduled for execution", explanation="Methods that return an ignored [Observable | Single | Flowable | Maybe ] generally indicate errors.\n\nIf you don\u2019t check the return value of these methods, the observables may never execute. It also means the error case is not being handled", severity=BugPattern.SeverityLevel.WARNING)
public final class RxReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.METHOD_INVOCATION), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf((String)"io.reactivex.Observable"), Matchers.isSubtypeOf((String)"io.reactivex.Flowable"), Matchers.isSubtypeOf((String)"io.reactivex.Single"), Matchers.isSubtypeOf((String)"io.reactivex.Maybe"), Matchers.isSubtypeOf((String)"io.reactivex.Completable"), Matchers.isSubtypeOf((String)"rx.Observable"), Matchers.isSubtypeOf((String)"rx.Single"), Matchers.isSubtypeOf((String)"rx.Completable")}), Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{RxReturnValueIgnored::hasCirvAnnotation, RxReturnValueIgnored::isExemptedMethod}))});
    private static final Supplier<Type> JAVA_UTIL_MAP = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.util.Map"));

    private static boolean hasCirvAnnotation(ExpressionTree tree, VisitorState state) {
        Symbol untypedSymbol = ASTHelpers.getSymbol((Tree)tree);
        if (!(untypedSymbol instanceof Symbol.MethodSymbol)) {
            return false;
        }
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)untypedSymbol;
        if (ASTHelpers.hasAnnotation((Symbol)sym, CanIgnoreReturnValue.class, (VisitorState)state)) {
            return true;
        }
        return ASTHelpers.findSuperMethods((Symbol.MethodSymbol)sym, (Types)state.getTypes()).stream().anyMatch(superSym -> ASTHelpers.hasAnnotation((Symbol)superSym, CanIgnoreReturnValue.class, (VisitorState)state) && superSym.getReturnType().tsym.equals(sym.getReturnType().tsym));
    }

    private static boolean isExemptedMethod(ExpressionTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (!(sym instanceof Symbol.MethodSymbol)) {
            return false;
        }
        return ASTHelpers.isSubtype((Type)sym.owner.type, (Type)((Type)JAVA_UTIL_MAP.get(state)), (VisitorState)state) && sym.name.contentEquals("put");
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Description description = super.matchMethodInvocation(tree, state);
        return description.equals(Description.NO_MATCH) ? Description.NO_MATCH : this.describeMatch(tree);
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Description description = super.matchMemberReference(tree, state);
        return description.equals(Description.NO_MATCH) ? Description.NO_MATCH : this.describeMatch(tree);
    }

    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return MATCHER;
    }
}

