/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.lang.reflect.Constructor;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="UnsafeReflectiveConstructionCast", summary="Prefer `asSubclass` instead of casting the result of `newInstance`, to detect classes of incorrect type before invoking their constructors.This way, if the class is of the incorrect type,it will throw an exception before invoking its constructor.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class UnsafeReflectiveConstructionCast
extends BugChecker
implements BugChecker.TypeCastTreeMatcher {
    private static final Matcher<ExpressionTree> CLASS_FOR_NAME = MethodMatchers.staticMethod().onClass(Class.class.getName()).named("forName");
    private static final Matcher<ExpressionTree> CLASS_GET_DECLARED_CTOR = MethodMatchers.instanceMethod().onExactClass(Class.class.getName()).named("getDeclaredConstructor");
    private static final Matcher<ExpressionTree> CTOR_NEW_INSTANCE = MethodMatchers.instanceMethod().onExactClass(Constructor.class.getName()).named("newInstance");

    public Description matchTypeCast(TypeCastTree typeCastTree, VisitorState state) {
        Type typeCastTreeType;
        ExpressionTree newInstanceTree = ASTHelpers.stripParentheses((ExpressionTree)typeCastTree.getExpression());
        if (!CTOR_NEW_INSTANCE.matches((Tree)newInstanceTree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree treeReceiver = ASTHelpers.getReceiver((ExpressionTree)newInstanceTree);
        if (!CLASS_GET_DECLARED_CTOR.matches((Tree)treeReceiver, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree classForName = ASTHelpers.getReceiver((ExpressionTree)treeReceiver);
        if (!CLASS_FOR_NAME.matches((Tree)classForName, state)) {
            return Description.NO_MATCH;
        }
        Symbol typeSym = ASTHelpers.getSymbol((Tree)typeCastTree.getType());
        if (typeSym == null) {
            return Description.NO_MATCH;
        }
        Types types = state.getTypes();
        Type erasedType = types.erasure(typeCastTreeType = ASTHelpers.getType((Tree)typeCastTree.getType()));
        if (ASTHelpers.isSameType((Type)erasedType, (Type)state.getSymtab().objectType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String typeSource = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)erasedType);
        fix.postfixWith((Tree)classForName, ".asSubclass(" + typeSource + ".class)");
        if (types.isSameType(typeCastTreeType, erasedType)) {
            fix.replace(ASTHelpers.getStartPosition((Tree)typeCastTree), ASTHelpers.getStartPosition((Tree)typeCastTree.getExpression()), "");
        }
        return this.describeMatch(classForName, (Fix)fix.build());
    }
}

