/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Beta
public final class Issue
implements Comparable<Issue> {
    private final String mId;
    private final String mBriefDescription;
    private final String mExplanation;
    private final Category mCategory;
    private final int mPriority;
    private final Severity mSeverity;
    private Object mMoreInfoUrls;
    private boolean mEnabledByDefault = true;
    private Implementation mImplementation;

    private Issue(String id, String shortDescription, String explanation, Category category, int priority, Severity severity, Implementation implementation) {
        assert (!shortDescription.isEmpty());
        assert (!explanation.isEmpty());
        this.mId = id;
        this.mBriefDescription = shortDescription;
        this.mExplanation = explanation;
        this.mCategory = category;
        this.mPriority = priority;
        this.mSeverity = severity;
        this.mImplementation = implementation;
    }

    public static Issue create(String id, String briefDescription, String explanation, Category category, int priority, Severity severity, Implementation implementation) {
        return new Issue(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    @Deprecated
    public static Issue create(String id, String briefDescription, String description, String explanation, Category category, int priority, Severity severity, Implementation implementation) {
        return new Issue(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    public String getId() {
        return this.mId;
    }

    public String getBriefDescription(TextFormat format) {
        return TextFormat.RAW.convertTo(this.mBriefDescription, format);
    }

    public String getExplanation(TextFormat format) {
        return TextFormat.RAW.convertTo(this.mExplanation, format);
    }

    public Category getCategory() {
        return this.mCategory;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public Severity getDefaultSeverity() {
        return this.mSeverity;
    }

    public List<String> getMoreInfo() {
        if (this.mMoreInfoUrls == null) {
            return Collections.emptyList();
        }
        if (this.mMoreInfoUrls instanceof String) {
            return Collections.singletonList((String)this.mMoreInfoUrls);
        }
        assert (this.mMoreInfoUrls instanceof List);
        return (List)this.mMoreInfoUrls;
    }

    public Issue addMoreInfo(String moreInfoUrl) {
        if (this.mMoreInfoUrls == null) {
            this.mMoreInfoUrls = moreInfoUrl;
        } else if (this.mMoreInfoUrls instanceof String) {
            String existing = (String)this.mMoreInfoUrls;
            ArrayList<String> list = new ArrayList<String>(2);
            list.add(existing);
            list.add(moreInfoUrl);
            this.mMoreInfoUrls = list;
        } else {
            assert (this.mMoreInfoUrls instanceof List);
            ((List)this.mMoreInfoUrls).add(moreInfoUrl);
        }
        return this;
    }

    public boolean isEnabledByDefault() {
        return this.mEnabledByDefault;
    }

    public Implementation getImplementation() {
        return this.mImplementation;
    }

    public void setImplementation(Implementation implementation) {
        this.mImplementation = implementation;
    }

    @Override
    public int compareTo(Issue other) {
        return this.getId().compareTo(other.getId());
    }

    public Issue setEnabledByDefault(boolean enabledByDefault) {
        this.mEnabledByDefault = enabledByDefault;
        return this;
    }

    public String toString() {
        return this.mId;
    }
}

