/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableBiMap;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ImmutableMapCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class ImmutableBiMapCodec<K, V>
implements ObjectCodec<ImmutableBiMap<K, V>> {
    ImmutableBiMapCodec() {
    }

    @Override
    public Class<ImmutableBiMap<K, V>> getEncodedClass() {
        return ImmutableBiMap.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableBiMap<K, V> map, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(map.size());
        ImmutableMapCodec.serializeEntries(context, map.entrySet(), codedOut);
    }

    @Override
    public ImmutableBiMap<K, V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int length = codedIn.readInt32();
        if (length < 0) {
            throw new SerializationException("Expected non-negative length: " + length);
        }
        ImmutableBiMap.Builder builder = ImmutableMapCodec.deserializeEntries(ImmutableBiMap.builderWithExpectedSize((int)length), length, context, codedIn);
        try {
            return builder.buildOrThrow();
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("Duplicate keys during ImmutableBiMapCodec deserialization", e);
        }
    }
}

