BT=${BT-../../bin/bedtools}

check()
{
	if diff $1 $2; then
    	echo ok
	else
    	echo fail
	fi
}

###########################################################
###########################################################
#                       BAM files                         #
###########################################################
###########################################################
samtools view -Sb one_block.sam > one_block.bam 2>/dev/null
samtools view -Sb two_blocks.sam > two_blocks.bam 2>/dev/null
samtools view -Sb three_blocks.sam > three_blocks.bam 2>/dev/null
samtools view -Sb sam-w-del.sam > sam-w-del.bam 2>/dev/null



##################################################################
#  Test three blocks without -split
##################################################################
echo "    coverage.t1...\c"
echo \
"chr1	0	50	three_blocks	40	-	0	50	0,0,0	3	10,10,10,	0,20,40,	1	40	50	0.8000000" > exp
$BT coverage -abam three_blocks.bam -b three_blocks_nomatch.bed > obs
check obs exp
rm obs exp


rm *.bam


##################################################################
#  Test default
##################################################################
echo "    coverage.t2...\c"
echo \
"chr1	20	70	6	25	+	2	50	50	1.0000000
chr1	50	100	1	25	-	2	50	50	1.0000000
chr1	200	250	3	25	+	1	50	50	1.0000000
chr2	80	130	5	25	-	1	50	50	1.0000000
chr2	150	200	4	25	+	2	50	50	1.0000000
chr2	180	230	2	25	-	2	50	50	1.0000000" > exp
$BT coverage -a a.bed -b a.bed > obs
check exp obs
rm exp obs


##################################################################
#  Test counts
##################################################################
echo "    coverage.t3...\c"
echo \
"chr1	20	70	6	25	+	2
chr1	50	100	1	25	-	2
chr1	200	250	3	25	+	1
chr2	80	130	5	25	-	1
chr2	150	200	4	25	+	2
chr2	180	230	2	25	-	2" > exp
$BT coverage -a a.bed -b a.bed -counts > obs
check exp obs
rm exp obs



##################################################################
#  Test -hist
##################################################################
echo "    coverage.t4...\c"
echo \
"chr1	20	70	6	25	+	1	30	50	0.6000000
chr1	20	70	6	25	+	2	20	50	0.4000000
chr1	50	100	1	25	-	1	30	50	0.6000000
chr1	50	100	1	25	-	2	20	50	0.4000000
chr1	200	250	3	25	+	1	50	50	1.0000000
chr2	80	130	5	25	-	1	50	50	1.0000000
chr2	150	200	4	25	+	1	30	50	0.6000000
chr2	150	200	4	25	+	2	20	50	0.4000000
chr2	180	230	2	25	-	1	30	50	0.6000000
chr2	180	230	2	25	-	2	20	50	0.4000000
all	1	220	300	0.7333333
all	2	80	300	0.2666667" > exp
$BT coverage -a a.bed -b a.bed -hist > obs
check exp obs
rm exp obs

##################################################################
#  Test -d
##################################################################
echo "    coverage.t5...\c"
echo \
"chr1	20	70	6	25	+	1	1
chr1	20	70	6	25	+	2	1
chr1	20	70	6	25	+	3	1
chr1	20	70	6	25	+	4	1
chr1	20	70	6	25	+	5	1
chr1	20	70	6	25	+	6	1
chr1	20	70	6	25	+	7	1
chr1	20	70	6	25	+	8	1
chr1	20	70	6	25	+	9	1
chr1	20	70	6	25	+	10	1
chr1	20	70	6	25	+	11	1
chr1	20	70	6	25	+	12	1
chr1	20	70	6	25	+	13	1
chr1	20	70	6	25	+	14	1
chr1	20	70	6	25	+	15	1
chr1	20	70	6	25	+	16	1
chr1	20	70	6	25	+	17	1
chr1	20	70	6	25	+	18	1
chr1	20	70	6	25	+	19	1
chr1	20	70	6	25	+	20	1
chr1	20	70	6	25	+	21	1
chr1	20	70	6	25	+	22	1
chr1	20	70	6	25	+	23	1
chr1	20	70	6	25	+	24	1
chr1	20	70	6	25	+	25	1
chr1	20	70	6	25	+	26	1
chr1	20	70	6	25	+	27	1
chr1	20	70	6	25	+	28	1
chr1	20	70	6	25	+	29	1
chr1	20	70	6	25	+	30	1
chr1	20	70	6	25	+	31	2
chr1	20	70	6	25	+	32	2
chr1	20	70	6	25	+	33	2
chr1	20	70	6	25	+	34	2
chr1	20	70	6	25	+	35	2
chr1	20	70	6	25	+	36	2
chr1	20	70	6	25	+	37	2
chr1	20	70	6	25	+	38	2
chr1	20	70	6	25	+	39	2
chr1	20	70	6	25	+	40	2
chr1	20	70	6	25	+	41	2
chr1	20	70	6	25	+	42	2
chr1	20	70	6	25	+	43	2
chr1	20	70	6	25	+	44	2
chr1	20	70	6	25	+	45	2
chr1	20	70	6	25	+	46	2
chr1	20	70	6	25	+	47	2
chr1	20	70	6	25	+	48	2
chr1	20	70	6	25	+	49	2
chr1	20	70	6	25	+	50	2
chr1	50	100	1	25	-	1	2
chr1	50	100	1	25	-	2	2
chr1	50	100	1	25	-	3	2
chr1	50	100	1	25	-	4	2
chr1	50	100	1	25	-	5	2
chr1	50	100	1	25	-	6	2
chr1	50	100	1	25	-	7	2
chr1	50	100	1	25	-	8	2
chr1	50	100	1	25	-	9	2
chr1	50	100	1	25	-	10	2
chr1	50	100	1	25	-	11	2
chr1	50	100	1	25	-	12	2
chr1	50	100	1	25	-	13	2
chr1	50	100	1	25	-	14	2
chr1	50	100	1	25	-	15	2
chr1	50	100	1	25	-	16	2
chr1	50	100	1	25	-	17	2
chr1	50	100	1	25	-	18	2
chr1	50	100	1	25	-	19	2
chr1	50	100	1	25	-	20	2
chr1	50	100	1	25	-	21	1
chr1	50	100	1	25	-	22	1
chr1	50	100	1	25	-	23	1
chr1	50	100	1	25	-	24	1
chr1	50	100	1	25	-	25	1
chr1	50	100	1	25	-	26	1
chr1	50	100	1	25	-	27	1
chr1	50	100	1	25	-	28	1
chr1	50	100	1	25	-	29	1
chr1	50	100	1	25	-	30	1
chr1	50	100	1	25	-	31	1
chr1	50	100	1	25	-	32	1
chr1	50	100	1	25	-	33	1
chr1	50	100	1	25	-	34	1
chr1	50	100	1	25	-	35	1
chr1	50	100	1	25	-	36	1
chr1	50	100	1	25	-	37	1
chr1	50	100	1	25	-	38	1
chr1	50	100	1	25	-	39	1
chr1	50	100	1	25	-	40	1
chr1	50	100	1	25	-	41	1
chr1	50	100	1	25	-	42	1
chr1	50	100	1	25	-	43	1
chr1	50	100	1	25	-	44	1
chr1	50	100	1	25	-	45	1
chr1	50	100	1	25	-	46	1
chr1	50	100	1	25	-	47	1
chr1	50	100	1	25	-	48	1
chr1	50	100	1	25	-	49	1
chr1	50	100	1	25	-	50	1
chr1	200	250	3	25	+	1	1
chr1	200	250	3	25	+	2	1
chr1	200	250	3	25	+	3	1
chr1	200	250	3	25	+	4	1
chr1	200	250	3	25	+	5	1
chr1	200	250	3	25	+	6	1
chr1	200	250	3	25	+	7	1
chr1	200	250	3	25	+	8	1
chr1	200	250	3	25	+	9	1
chr1	200	250	3	25	+	10	1
chr1	200	250	3	25	+	11	1
chr1	200	250	3	25	+	12	1
chr1	200	250	3	25	+	13	1
chr1	200	250	3	25	+	14	1
chr1	200	250	3	25	+	15	1
chr1	200	250	3	25	+	16	1
chr1	200	250	3	25	+	17	1
chr1	200	250	3	25	+	18	1
chr1	200	250	3	25	+	19	1
chr1	200	250	3	25	+	20	1
chr1	200	250	3	25	+	21	1
chr1	200	250	3	25	+	22	1
chr1	200	250	3	25	+	23	1
chr1	200	250	3	25	+	24	1
chr1	200	250	3	25	+	25	1
chr1	200	250	3	25	+	26	1
chr1	200	250	3	25	+	27	1
chr1	200	250	3	25	+	28	1
chr1	200	250	3	25	+	29	1
chr1	200	250	3	25	+	30	1
chr1	200	250	3	25	+	31	1
chr1	200	250	3	25	+	32	1
chr1	200	250	3	25	+	33	1
chr1	200	250	3	25	+	34	1
chr1	200	250	3	25	+	35	1
chr1	200	250	3	25	+	36	1
chr1	200	250	3	25	+	37	1
chr1	200	250	3	25	+	38	1
chr1	200	250	3	25	+	39	1
chr1	200	250	3	25	+	40	1
chr1	200	250	3	25	+	41	1
chr1	200	250	3	25	+	42	1
chr1	200	250	3	25	+	43	1
chr1	200	250	3	25	+	44	1
chr1	200	250	3	25	+	45	1
chr1	200	250	3	25	+	46	1
chr1	200	250	3	25	+	47	1
chr1	200	250	3	25	+	48	1
chr1	200	250	3	25	+	49	1
chr1	200	250	3	25	+	50	1
chr2	80	130	5	25	-	1	1
chr2	80	130	5	25	-	2	1
chr2	80	130	5	25	-	3	1
chr2	80	130	5	25	-	4	1
chr2	80	130	5	25	-	5	1
chr2	80	130	5	25	-	6	1
chr2	80	130	5	25	-	7	1
chr2	80	130	5	25	-	8	1
chr2	80	130	5	25	-	9	1
chr2	80	130	5	25	-	10	1
chr2	80	130	5	25	-	11	1
chr2	80	130	5	25	-	12	1
chr2	80	130	5	25	-	13	1
chr2	80	130	5	25	-	14	1
chr2	80	130	5	25	-	15	1
chr2	80	130	5	25	-	16	1
chr2	80	130	5	25	-	17	1
chr2	80	130	5	25	-	18	1
chr2	80	130	5	25	-	19	1
chr2	80	130	5	25	-	20	1
chr2	80	130	5	25	-	21	1
chr2	80	130	5	25	-	22	1
chr2	80	130	5	25	-	23	1
chr2	80	130	5	25	-	24	1
chr2	80	130	5	25	-	25	1
chr2	80	130	5	25	-	26	1
chr2	80	130	5	25	-	27	1
chr2	80	130	5	25	-	28	1
chr2	80	130	5	25	-	29	1
chr2	80	130	5	25	-	30	1
chr2	80	130	5	25	-	31	1
chr2	80	130	5	25	-	32	1
chr2	80	130	5	25	-	33	1
chr2	80	130	5	25	-	34	1
chr2	80	130	5	25	-	35	1
chr2	80	130	5	25	-	36	1
chr2	80	130	5	25	-	37	1
chr2	80	130	5	25	-	38	1
chr2	80	130	5	25	-	39	1
chr2	80	130	5	25	-	40	1
chr2	80	130	5	25	-	41	1
chr2	80	130	5	25	-	42	1
chr2	80	130	5	25	-	43	1
chr2	80	130	5	25	-	44	1
chr2	80	130	5	25	-	45	1
chr2	80	130	5	25	-	46	1
chr2	80	130	5	25	-	47	1
chr2	80	130	5	25	-	48	1
chr2	80	130	5	25	-	49	1
chr2	80	130	5	25	-	50	1
chr2	150	200	4	25	+	1	1
chr2	150	200	4	25	+	2	1
chr2	150	200	4	25	+	3	1
chr2	150	200	4	25	+	4	1
chr2	150	200	4	25	+	5	1
chr2	150	200	4	25	+	6	1
chr2	150	200	4	25	+	7	1
chr2	150	200	4	25	+	8	1
chr2	150	200	4	25	+	9	1
chr2	150	200	4	25	+	10	1
chr2	150	200	4	25	+	11	1
chr2	150	200	4	25	+	12	1
chr2	150	200	4	25	+	13	1
chr2	150	200	4	25	+	14	1
chr2	150	200	4	25	+	15	1
chr2	150	200	4	25	+	16	1
chr2	150	200	4	25	+	17	1
chr2	150	200	4	25	+	18	1
chr2	150	200	4	25	+	19	1
chr2	150	200	4	25	+	20	1
chr2	150	200	4	25	+	21	1
chr2	150	200	4	25	+	22	1
chr2	150	200	4	25	+	23	1
chr2	150	200	4	25	+	24	1
chr2	150	200	4	25	+	25	1
chr2	150	200	4	25	+	26	1
chr2	150	200	4	25	+	27	1
chr2	150	200	4	25	+	28	1
chr2	150	200	4	25	+	29	1
chr2	150	200	4	25	+	30	1
chr2	150	200	4	25	+	31	2
chr2	150	200	4	25	+	32	2
chr2	150	200	4	25	+	33	2
chr2	150	200	4	25	+	34	2
chr2	150	200	4	25	+	35	2
chr2	150	200	4	25	+	36	2
chr2	150	200	4	25	+	37	2
chr2	150	200	4	25	+	38	2
chr2	150	200	4	25	+	39	2
chr2	150	200	4	25	+	40	2
chr2	150	200	4	25	+	41	2
chr2	150	200	4	25	+	42	2
chr2	150	200	4	25	+	43	2
chr2	150	200	4	25	+	44	2
chr2	150	200	4	25	+	45	2
chr2	150	200	4	25	+	46	2
chr2	150	200	4	25	+	47	2
chr2	150	200	4	25	+	48	2
chr2	150	200	4	25	+	49	2
chr2	150	200	4	25	+	50	2
chr2	180	230	2	25	-	1	2
chr2	180	230	2	25	-	2	2
chr2	180	230	2	25	-	3	2
chr2	180	230	2	25	-	4	2
chr2	180	230	2	25	-	5	2
chr2	180	230	2	25	-	6	2
chr2	180	230	2	25	-	7	2
chr2	180	230	2	25	-	8	2
chr2	180	230	2	25	-	9	2
chr2	180	230	2	25	-	10	2
chr2	180	230	2	25	-	11	2
chr2	180	230	2	25	-	12	2
chr2	180	230	2	25	-	13	2
chr2	180	230	2	25	-	14	2
chr2	180	230	2	25	-	15	2
chr2	180	230	2	25	-	16	2
chr2	180	230	2	25	-	17	2
chr2	180	230	2	25	-	18	2
chr2	180	230	2	25	-	19	2
chr2	180	230	2	25	-	20	2
chr2	180	230	2	25	-	21	1
chr2	180	230	2	25	-	22	1
chr2	180	230	2	25	-	23	1
chr2	180	230	2	25	-	24	1
chr2	180	230	2	25	-	25	1
chr2	180	230	2	25	-	26	1
chr2	180	230	2	25	-	27	1
chr2	180	230	2	25	-	28	1
chr2	180	230	2	25	-	29	1
chr2	180	230	2	25	-	30	1
chr2	180	230	2	25	-	31	1
chr2	180	230	2	25	-	32	1
chr2	180	230	2	25	-	33	1
chr2	180	230	2	25	-	34	1
chr2	180	230	2	25	-	35	1
chr2	180	230	2	25	-	36	1
chr2	180	230	2	25	-	37	1
chr2	180	230	2	25	-	38	1
chr2	180	230	2	25	-	39	1
chr2	180	230	2	25	-	40	1
chr2	180	230	2	25	-	41	1
chr2	180	230	2	25	-	42	1
chr2	180	230	2	25	-	43	1
chr2	180	230	2	25	-	44	1
chr2	180	230	2	25	-	45	1
chr2	180	230	2	25	-	46	1
chr2	180	230	2	25	-	47	1
chr2	180	230	2	25	-	48	1
chr2	180	230	2	25	-	49	1
chr2	180	230	2	25	-	50	1" > exp
$BT coverage -a a.bed -b a.bed -d > obs
check exp obs
rm exp obs



##################################################################
#  Test -s
##################################################################
echo "    coverage.t6...\c"
echo \
"chr1	20	70	6	25	+	1	50	50	1.0000000
chr1	50	100	1	25	-	1	50	50	1.0000000
chr1	200	250	3	25	+	1	50	50	1.0000000
chr2	80	130	5	25	-	1	50	50	1.0000000
chr2	150	200	4	25	+	1	50	50	1.0000000
chr2	180	230	2	25	-	1	50	50	1.0000000" > exp
$BT coverage -a a.bed -b a.bed -s > obs
check exp obs
rm exp obs


##################################################################
#  Test -S
##################################################################
echo "    coverage.t7...\c"
echo \
"chr1	20	70	6	25	+	1	20	50	0.4000000
chr1	50	100	1	25	-	1	20	50	0.4000000
chr1	200	250	3	25	+	0	0	50	0.0000000
chr2	80	130	5	25	-	0	0	50	0.0000000
chr2	150	200	4	25	+	1	20	50	0.4000000
chr2	180	230	2	25	-	1	20	50	0.4000000" > exp
$BT coverage -a a.bed -b a.bed -S > obs
check exp obs
rm exp obs


##################################################################
#  Test that -counts, -hist are mutually exclusive options
##################################################################
echo "    coverage.t8...\c"
echo \
"***** ERROR: -counts, -d, and -hist are mutually exclusive options. *****" > exp
$BT coverage -a a.bed -b b.bed -counts -hist 2>&1 > /dev/null | head -2 | tail -1 | cat - > obs
check exp obs
rm exp obs

##################################################################
#  Test that -counts, -d are mutually exclusive options
##################################################################
echo "    coverage.t9...\c"
echo \
"***** ERROR: -counts, -d, and -hist are mutually exclusive options. *****" > exp
$BT coverage -a a.bed -b b.bed -counts -d 2>&1 > /dev/null | head -2 | tail -1 | cat - > obs
check exp obs
rm exp obs

##################################################################
#  Test that -hist, -d are mutually exclusive options
##################################################################
echo "    coverage.t10...\c"
echo \
"***** ERROR: -counts, -d, and -hist are mutually exclusive options. *****" > exp
$BT coverage -a a.bed -b b.bed -hist -d 2>&1 > /dev/null | head -2 | tail -1 | cat - > obs
check exp obs
rm exp obs
