Very much like in the past month, this month once again has nothing I could proudly share, at least not based on my own work.
Fortunately, there were lots of contributions, particularly by [Eliah Kagan](https://github.com/EliahKagan) and [Christoph Rüßler](https://github.com/cruessler). 
Plentiful were also the bug reports, many with started, yet unfinished fixes.

## What's going on?

[GitButler](https://gitbutler.com) is still taking most of every day, then there were 7 days of basically not using the computer (something my inbox still is a proof of nearly two weeks later), single-dad trials keep me busy with childcare once kindergarden is out, and then there is dealing with everything that needs to be cared for in Germany while I am in China. Simple as that 😁.
On the bright side, I of course also enjoy getting to work significantly less, getting a taste of a normal 9-5 working day, something that's going to be over soon enough as I do plan to take it into the other direction as soon as I get the chance. In theory, from mid of April I should be able to ramp up my worktime again, even though it's still unclear how much of that can go into `gitoxide` features, or into all the half-finished PRs I have currently open.

I will do my best to work it all off to even be in a state to think about new features, with candidates being a `git2`-style commit-walk and a proper `gix reset`.

Part of me thinks that in theory, even when working significantly more, it's likely that there will be ore months without anything significant to share, a state that might not change until the next major iteration GitButler see the light of the day *and* has all the features. Only then I'd think it will be possible to make the improvements that `gitoxide` needs to be able to fully remove `git2` there, the final boss if you will.

## Community

### Various infrastructure and portability improvements

It is thanks to [Eliah Kagan](https://github.com/EliahKagan) `gitoxide` is tested on more and more platforms, while also running better on the Windows platform. Anything related to CI infrastructure and developer tooling by now has been thoroughly revised, and I am happily taking the back-seat to enjoy the ride.

A notable workstream that was also concluded recently is a greatly improved algorithm to find the correct Git shell on Windows - what sounds trivial is full of gotchas and required a huge amount of testing to get it to the point where it arguably is the most portable and compatible implementation.

### `jj` puts in its weight

One major source of issue reports now seems to be the fantasic [`jj`](https://github.com/jj-vcs/jj), a tool I always abbreviate because I can't remember how to spell `jujitsu` (this is probably wrong).
It's made by Google, and it really is great to see its influence on `gitoxide` - each report leads to betterment, and I can't have enough of that.
On another note, I am a great fan of the look & feel of the `jj` codebase, and kind of wish `gitoxide` could be like that.

For fun, let me finish with a confession: despite having seen intriguing demos, talks, screen-recordings and documentation I still didn't dare to simply try it out. And all that despite thinking that it could make a huge difference for my workflow. It's the "I can't really have a disturbance in my workflow right now" phenomenon, but I keep hoping I will one day find myself in the right mood to just give it a go.

### `gix blame` with experimental cache

Thanks to Christoph we now have `gix diff file` to use, producing unified diff of anything currently stored in Git. And I hope that future upgrades will enable it to also be able to read from the worktree, making it a driver of the `gix::diff:blob::Platform`, effectively.

In other news…

#### `gix-blame` will be used in `helix`

It's fantastic to see that despite `blame` being relatively early in `gitoxide`, it's already deemed good enough to power [inline-blame in `helix`](https://github.com/helix-editor/helix/pull/13133).
This might be the first third-party integration, and hopefully not the last either.

### Gix in Cargo

With `gix status` now available, the plan still stands to bring it into `cargo`. Before that, there is a huge stack of unfinished PRs to wrap up though, so it's unlikely to happen anytime soon.

Cheers
Sebastian

PS: The latest timesheets can be found [here (2025)](https://github.com/Byron/byron/blob/main/timesheets/2025.csv). 