I have been busy, just not in `gitoxide` directly. Yet, there is one related topic I am very excited to share!

### Hide…

Ominous, isn't it? What the title is referring to is a long-absent feature which is absolutely critical for commit-graph traversals of the sort
`this..that`, including all of `that` without any of `this`.
Previously, we would only support traversals with a `boundary()` condition, which just says that if you run over `that`, do not continue in that direction. However, this would also mean that one could easily get past the boundary by finding other paths to the history of `that`, leading to longer-than-wanted traversals. This made `boundary()` quite useless outside of traversals on well-known graphs.

Now with `hide()`, we can finally assure that we see none of the commits reachable by hidden tips in the traversal. Of course, this means that the traversal is a little more costly when hidden tips are involved, but it's the price to pay for this extremely relevant feature.

You can try it yourself with the likes of `gix commit-graph list main~10..origin/main`.

### GitButler - The Graph

Most of my time went into working on the foundations of the new GitButler, a Butler which is able to act more like a normal Git client without forcing the user into the `gitbutler/workspace` branch.

For this to work, one will need to be able to express any starting point in terms of stacks with segments.
My initial attempt to do that failed as I started out with the 'quick' version that is just a more flexible variant of the code that existed before, i.e. code that fiddles with merge-bases and linear single-parent traversals to synthesize stacks from a graph. It just wouldn't work right and admittedly, I stopped being able to understand it well enough to get it right, discarding it as impossible. After all, stacks with segments are an oversimplification which cannot represent the underlying commit-graph, how is one supposed to be able to have algorithms making reliable decisions on top of that?

Thus, "The Graph" was born, as a simplified, but not over-simplified, representation of the underlying commit-graph which can tell GitButler all it needs to know, concisely, and in a data structure that is easy to traverse both backwards and forwards. From there, stacks and branches are merely a mapping for the sole purpose of being viewed by the user.

Now the traversal of the graph is completed, and it seems to work well *and* fast even in the toughest repositories I could find.

Next up is to generate the mapping of the graph to stacks, which will enable GitButler to see the world from any starting point, making it a 'normal' Git client that can show whatever you throw at it.

## Community

### Gix in Cargo

Now it has already been more than 4 weeks since [the PR](https://github.com/rust-lang/cargo/pull/15534) to use `gitoxide` for `cargo package` was opened. Since then, it was decided that the `git2` version of it can be removed entirely, bringing the benefits of the new implementation to everyone soon. 

However, I didn't get to work on it since (despite wanting to today) but plan to do it in one of the coming weekends.

Cheers
Sebastian

PS: The latest timesheets can be found [here (2025)](https://github.com/Byron/byron/blob/main/timesheets/2025.csv). 