"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Mon Mar  2 17:26:11 2015
  from data model element ccp.lims.Sample revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Sample.py: python API for CCPN data model, MetaPackage ccp.lims.Sample

Copyright (C) 2007 Anne Pajon (MSD group, EBI)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- PIMS website (http://www.pims-lims.org)

- email: Anne Pajon, pajon@ebi.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
A. Pajon, J. Ionides, J. Diprose, J. Fillon, R. Fogh, A.W. Ashton,
H. Berman, W. Boucher, M. Cygler, E. Deleury, R. Esnouf, J. Janin, R. Kim,
I. Krimm, C.L. Lawson, E. Oeuillet, A. Poupon, S. Raymond, T. Stevens,
H. van Tilbeurgh, J. Westbrook, P. Wood, E. Ulrich, W. Vranken, L. Xueli,
E. Laue, D.I. Stuart, and K. Henrick (2005). Design of a Data Model for
Developing Laboratory Information Management and Analysis Systems for
Protein Production. Proteins: Structure, Function and Bioinformatics 58,
278-284.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.Affiliation
import ccp.api.general.Method
import ccp.api.lims.Classification
import ccp.api.lims.Holder
import ccp.api.lims.RefSampleComponent
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.lims.Sample')

###############################################################################
class AbstractSample(memops.api.Implementation.DataObject):
  r"""General information on the sample or reagent.
  """
  #   from data model element ccp.lims.Sample.AbstractSample revision ?
  _metaclass = metaPackage.getElement('AbstractSample')
  _packageName = 'ccp.lims.Sample'
  _packageShortName = 'SAM'
  _fieldNames = ('applicationData', 'className', 'details', 'fieldNames', 'inConstructor', 'ionicStrength', 'isActive', 'isDeleted', 'isHazard', 'metaclass', 'name', 'packageName', 'packageShortName', 'ph', 'qualifiedName', 'solvent', 'access', 'activeAccess', 'hazardPhrases', 'localRiskPhrases', 'parent', 'rPhrases', 'root', 'sPhrases', 'sampleCategories', 'sampleComponents', 'sampleStore', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addHazardPhrase(self, value):
    """
    Add for ccp.lims.Sample.AbstractSample.hazardPhrases
    """
    dataDict = self.__dict__
    from ccp.api.lims.Classification import HazardPhrase as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addHazardPhrase:
       value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('hazardPhrases')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addHazardPhrase:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addHazardPhrase:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addHazardPhrase:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addHazardPhrase:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addHazardPhrase:
           Link hazardPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addHazardPhrase')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addSampleCategory(self, value):
    """
    Add for ccp.lims.Sample.AbstractSample.sampleCategories
    """
    dataDict = self.__dict__
    from ccp.api.lims.Classification import SampleCategory as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addSampleCategory:
       value is not of class ccp.lims.Classification.SampleCategory""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('sampleCategories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addSampleCategory:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addSampleCategory:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addSampleCategory:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addSampleCategory:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addSampleCategory:
           Link sampleCategories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('abstractSamples')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addSampleCategory')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllHazardPhrases(self, **conditions):
    """
    FindAll for ccp.lims.Sample.AbstractSample.hazardPhrases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('hazardPhrases')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('hazardPhrases')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'phrase', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllLocalRiskPhrases(self, **conditions):
    """
    FindAll for ccp.lims.Sample.AbstractSample.localRiskPhrases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getLocalRiskPhrases()
      result = set(currentValues)

    else:
      currentValues = self.getLocalRiskPhrases()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'phrase', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRPhrases(self, **conditions):
    """
    FindAll for ccp.lims.Sample.AbstractSample.rPhrases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getRPhrases()
      result = set(currentValues)

    else:
      currentValues = self.getRPhrases()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'phrase', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSPhrases(self, **conditions):
    """
    FindAll for ccp.lims.Sample.AbstractSample.sPhrases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getSPhrases()
      result = set(currentValues)

    else:
      currentValues = self.getSPhrases()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'phrase', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSampleCategories(self, **conditions):
    """
    FindAll for ccp.lims.Sample.AbstractSample.sampleCategories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('sampleCategories')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('sampleCategories')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSampleComponents(self, **conditions):
    """
    FindAll for ccp.lims.Sample.AbstractSample.sampleComponents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('sampleComponents').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('sampleComponents').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('concDisplayUnit', 'concentration', 'concentrationError', 'concentrationUnit', 'details', 'purity', 'serial', 'abstractSample', 'access', 'blueprintComponent', 'container', 'refComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstHazardPhrase(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.AbstractSample.hazardPhrases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('hazardPhrases')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('hazardPhrases')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'phrase', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstLocalRiskPhrase(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.AbstractSample.localRiskPhrases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getLocalRiskPhrases()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getLocalRiskPhrases()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'phrase', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRPhrase(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.AbstractSample.rPhrases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getRPhrases()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getRPhrases()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'phrase', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSPhrase(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.AbstractSample.sPhrases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getSPhrases()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getSPhrases()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'phrase', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSampleCategory(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.AbstractSample.sampleCategories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('sampleCategories')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('sampleCategories')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSampleComponent(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.AbstractSample.sampleComponents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('sampleComponents').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('sampleComponents').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('sampleComponents').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('concDisplayUnit', 'concentration', 'concentrationError', 'concentrationUnit', 'details', 'purity', 'serial', 'abstractSample', 'access', 'blueprintComponent', 'container', 'refComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.Sample.AbstractSample
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.AbstractSample'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('sampleStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.Sample')
        obj1 = obj0.__dict__.get('sampleStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.AbstractSample'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('abstractSamples').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDetails(self):
    """
    Get for ccp.lims.Sample.AbstractSample.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.Sample.AbstractSample
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('sampleStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('name'))

    return result
  
  def getHazardPhrases(self):
    """
    Get for ccp.lims.Sample.AbstractSample.hazardPhrases
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('hazardPhrases')
    result = frozenset(tempVar)
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIonicStrength(self):
    """
    Get for ccp.lims.Sample.AbstractSample.ionicStrength
    """
    dataDict = self.__dict__
    result = dataDict.get('ionicStrength')
    return result
  
  def getIsActive(self):
    """
    Get for ccp.lims.Sample.AbstractSample.isActive
    """
    dataDict = self.__dict__
    result = dataDict.get('isActive')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsHazard(self):
    """
    Get for ccp.lims.Sample.AbstractSample.isHazard
    """
    dataDict = self.__dict__
    result = dataDict.get('isHazard')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.Sample.AbstractSample
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getLocalRiskPhrases(self):
    """
    getter for derived link localRiskPhrases
    """
    dataDict = self.__dict__
    result = frozenset(x for x in self.hazardPhrases if x.classification.namingSystem == 'local' )
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.lims.Sample.AbstractSample.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.Sample.AbstractSample.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('sampleStore')
    return result
  
  def getPh(self):
    """
    Get for ccp.lims.Sample.AbstractSample.ph
    """
    dataDict = self.__dict__
    result = dataDict.get('ph')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRPhrases(self):
    """
    getter for derived link rPhrases
    """
    dataDict = self.__dict__
    result = frozenset(x for x in self.findAllHazardPhrases(classification='MSDS') if x.code[0] == 'R')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSPhrases(self):
    """
    getter for derived link sPhrases
    """
    dataDict = self.__dict__
    result = frozenset(x for x in self.hazardPhrases if x.classification.namingSystem == 'MSDS' and  x.name[0] == 'S')
    return result
  
  def getSampleCategories(self):
    """
    Get for ccp.lims.Sample.AbstractSample.sampleCategories
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('sampleCategories')
    result = frozenset(tempVar)
    return result
  
  def getSampleComponents(self):
    """
    Get for ccp.lims.Sample.AbstractSample.sampleComponents
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('sampleComponents').values()
    result = frozenset(tempVar)
    return result
  
  def getSampleStore(self):
    """
    Get for ccp.lims.Sample.AbstractSample.sampleStore
    """
    dataDict = self.__dict__
    result = dataDict.get('sampleStore')
    return result
  
  def getSolvent(self):
    """
    Get for ccp.lims.Sample.AbstractSample.solvent
    """
    dataDict = self.__dict__
    result = dataDict.get('solvent')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newSampleComponent(self, **attrlinks):
    """
    Factory function to create ccp.lims.Sample.SampleComponent
    """
    return SampleComponent(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeHazardPhrase(self, value):
    """
    Remove for ccp.lims.Sample.AbstractSample.hazardPhrases
    """
    dataDict = self.__dict__
    from ccp.api.lims.Classification import HazardPhrase as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeHazardPhrase:
       value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('hazardPhrases')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeHazardPhrase:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeHazardPhrase:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeHazardPhrase:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeHazardPhrase:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeHazardPhrase')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeSampleCategory(self, value):
    """
    Remove for ccp.lims.Sample.AbstractSample.sampleCategories
    """
    dataDict = self.__dict__
    from ccp.api.lims.Classification import SampleCategory as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeSampleCategory:
       value is not of class ccp.lims.Classification.SampleCategory""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('sampleCategories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeSampleCategory:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeSampleCategory:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeSampleCategory:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeSampleCategory:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('abstractSamples')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeSampleCategory')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDetails(self, value):
    """
    Set for ccp.lims.Sample.AbstractSample.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setHazardPhrases(self, values):
    """
    Set for ccp.lims.Sample.AbstractSample.hazardPhrases
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setHazardPhrases:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Classification import HazardPhrase as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setHazardPhrases:
         value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('hazardPhrases')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setHazardPhrases:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setHazardPhrases:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setHazardPhrases:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setHazardPhrases:
           Link hazardPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['hazardPhrases'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setHazardPhrases')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIonicStrength(self, value):
    """
    Set for ccp.lims.Sample.AbstractSample.ionicStrength
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setIonicStrength:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setIonicStrength:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ionicStrength')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIonicStrength:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIonicStrength:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['ionicStrength'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIonicStrength')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsActive(self, value):
    """
    Set for ccp.lims.Sample.AbstractSample.isActive
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setIsActive:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isActive')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsActive:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsActive:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['isActive'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsActive')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsHazard(self, value):
    """
    Set for ccp.lims.Sample.AbstractSample.isHazard
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setIsHazard:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isHazard')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsHazard:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsHazard:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['isHazard'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsHazard')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.lims.Sample.AbstractSample.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setPh(self, value):
    """
    Set for ccp.lims.Sample.AbstractSample.ph
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setPh:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setPh:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ph')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPh:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPh:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['ph'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPh')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSampleCategories(self, values):
    """
    Set for ccp.lims.Sample.AbstractSample.sampleCategories
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setSampleCategories:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Classification import SampleCategory as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setSampleCategories:
         value is not of class ccp.lims.Classification.SampleCategory""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('sampleCategories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSampleCategories:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSampleCategories:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSampleCategories:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setSampleCategories:
           Link sampleCategories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('abstractSamples')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('abstractSamples')
        oldSelves.add(self)

    dataDict['sampleCategories'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSampleCategories')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSolvent(self, value):
    """
    Set for ccp.lims.Sample.AbstractSample.solvent
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSolvent:
         ccp.lims.Sample.Solvent input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setSolvent:
         ccp.lims.Sample.Solvent maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSolvent:
         ccp.lims.Sample.Solvent: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setSolvent:
         Solvent constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('solvent')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSolvent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSolvent:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['solvent'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSolvent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedHazardPhrases(self):
    """
    Sorted for ccp.lims.Sample.AbstractSample.hazardPhrases
    """
    dataDict = self.__dict__
    ll = dataDict.get('hazardPhrases')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedLocalRiskPhrases(self):
    """
    Sorted for ccp.lims.Sample.AbstractSample.localRiskPhrases
    """
    dataDict = self.__dict__
    ll = self.getLocalRiskPhrases()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedRPhrases(self):
    """
    Sorted for ccp.lims.Sample.AbstractSample.rPhrases
    """
    dataDict = self.__dict__
    ll = self.getRPhrases()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedSPhrases(self):
    """
    Sorted for ccp.lims.Sample.AbstractSample.sPhrases
    """
    dataDict = self.__dict__
    ll = self.getSPhrases()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedSampleCategories(self):
    """
    Sorted for ccp.lims.Sample.AbstractSample.sampleCategories
    """
    dataDict = self.__dict__
    ll = dataDict.get('sampleCategories')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedSampleComponents(self):
    """
    Sorted for ccp.lims.Sample.AbstractSample.sampleComponents
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('sampleComponents')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  ionicStrength = property(getIonicStrength, setIonicStrength, None,
  r"""The ionic strength (dimensionless quantity).
  """)
  
  isActive = property(getIsActive, setIsActive, None,
  r"""True if the sample is active.
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isHazard = property(getIsHazard, setIsHazard, None,
  r"""Is the sample hazard?
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""The name of the sample or the code to identify it. It is the unique 
  identifier.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  ph = property(getPh, setPh, None,
  r"""The pH.
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  solvent = property(getSolvent, setSolvent, None,
  r"""Solvent used for sample
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  hazardPhrases = property(getHazardPhrases, setHazardPhrases, None,
  r"""List of all hazard pharses associated to a particular sample.
  """)
  
  localRiskPhrases = property(getLocalRiskPhrases, None, None,
  r"""Local risk phrases that are specific to a certain laboratory.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for sampleStore
  """)
  
  rPhrases = property(getRPhrases, None, None,
  r"""Risk Phrases (R-phrases) that are associated to a sample.
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  sPhrases = property(getSPhrases, None, None,
  r"""Safety Phrases (S-phrases) that are associated to a sample.
  """)
  
  sampleCategories = property(getSampleCategories, setSampleCategories, None,
  r"""List of sample category associated to a sample.
  """)
  
  sampleComponents = property(getSampleComponents,  None, None,
  r"""child link to class SampleComponent
  """)
  
  sampleStore = property(getSampleStore,  None, None,
  r"""parent link
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class RefSampleSource(memops.api.Implementation.DataObject):
  r"""Defines examples of supplier details for this particular reagent to 
allow a link to be created to the product data page.
  """
  #   from data model element ccp.lims.Sample.RefSampleSource revision ?
  _metaclass = metaPackage.getElement('RefSampleSource')
  _packageName = 'ccp.lims.Sample'
  _packageShortName = 'SAM'
  _fieldNames = ('applicationData', 'catalogNum', 'className', 'dataPageUrl', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'parent', 'refSample', 'root', 'supplier', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.Sample.RefSampleSource
    """
    dataDict = self.__dict__
    dataDict['refSample'] = parent
    if (not isinstance(parent, RefSample)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.Sample.RefSample""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['catalogNum'] = None
      dataDict['dataPageUrl'] = None
      dataDict['access'] = None
      dataDict['supplier'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.Sample.RefSampleSource.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('refSampleSources')
        objKey = dataDict.get('catalogNum')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['catalogNum'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.Sample.RefSampleSource:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.Sample.RefSampleSource:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    refSample = dataDict.get('refSample')
    if (not (refSample in objsToBeDeleted)):
      objKey = dataDict.get('catalogNum')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = refSample.__dict__.get('refSampleSources')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.Sample.RefSampleSource
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.Sample.RefSampleSource
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('catalogNum')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('refSample')
        dd = value.__dict__.get('refSampleSources')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'refSample' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('catalogNum')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: catalogNum:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: catalogNum:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: catalogNum:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: catalogNum:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('dataPageUrl')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: dataPageUrl:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: dataPageUrl:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: dataPageUrl:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSample')
      if (not isinstance(value, RefSample)):
        raise ApiError("""%s.checkValid: refSample:
         value is not of class ccp.lims.Sample.RefSample""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('supplier')
      from ccp.api.general.Affiliation import Organisation as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: supplier:
         value is not of class ccp.general.Affiliation.Organisation""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: supplier:
         Link supplier between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('catalogNum')
    if (value is None):
      raise ApiError("""%s.checkValid: catalogNum:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('dataPageUrl')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('refSample')
    if (value is None):
      raise ApiError("""%s.checkValid: refSample:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('supplier')
    if (value is None):
      raise ApiError("""%s.checkValid: supplier:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.lims.Sample.RefSampleSource
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.Sample.RefSampleSource
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.RefSampleSource'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('sampleStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.Sample')
        obj1 = obj0.__dict__.get('sampleStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.RefSampleSource'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('abstractSamples').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('refSampleSources').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCatalogNum(self):
    """
    Get for ccp.lims.Sample.RefSampleSource.catalogNum
    """
    dataDict = self.__dict__
    result = dataDict.get('catalogNum')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDataPageUrl(self):
    """
    Get for ccp.lims.Sample.RefSampleSource.dataPageUrl
    """
    dataDict = self.__dict__
    result = dataDict.get('dataPageUrl')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.Sample.RefSampleSource
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('refSample')
    obj1 = obj2.__dict__.get('sampleStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('catalogNum'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.Sample.RefSampleSource
    """
    dataDict = self.__dict__
    result = dataDict.get('catalogNum')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.Sample.RefSampleSource.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('refSample')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefSample(self):
    """
    Get for ccp.lims.Sample.RefSampleSource.refSample
    """
    dataDict = self.__dict__
    result = dataDict.get('refSample')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSupplier(self):
    """
    Get for ccp.lims.Sample.RefSampleSource.supplier
    """
    dataDict = self.__dict__
    result = dataDict.get('supplier')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.Sample.RefSampleSource
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCatalogNum(self, value):
    """
    Set for ccp.lims.Sample.RefSampleSource.catalogNum
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCatalogNum:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCatalogNum:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCatalogNum:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setCatalogNum:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('catalogNum')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCatalogNum:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCatalogNum:
         cannot set catalogNum, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCatalogNum:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['catalogNum'] = value

    # doNotifies
  
  def setDataPageUrl(self, value):
    """
    Set for ccp.lims.Sample.RefSampleSource.dataPageUrl
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDataPageUrl:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDataPageUrl:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDataPageUrl:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dataPageUrl')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataPageUrl:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataPageUrl:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dataPageUrl'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDataPageUrl')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSupplier(self, value):
    """
    Set for ccp.lims.Sample.RefSampleSource.supplier
    """
    dataDict = self.__dict__
    from ccp.api.general.Affiliation import Organisation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setSupplier:
       value is not of class ccp.general.Affiliation.Organisation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('supplier')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSupplier:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSupplier:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSupplier:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSupplier:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setSupplier:
         Link supplier between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    dataDict['supplier'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSupplier')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  catalogNum = property(getCatalogNum, setCatalogNum, None,
  r"""The catalog number.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  dataPageUrl = property(getDataPageUrl, setDataPageUrl, None,
  r"""The url for the product data page
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for refSample
  """)
  
  refSample = property(getRefSample,  None, None,
  r"""parent link
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  supplier = property(getSupplier, setSupplier, None,
  r"""The name of the laboratory if it is 'Home made' or the name of the 
  company who provides the component.
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class SampleComponent(memops.api.Implementation.DataObject):
  r"""The information on the sample component. One component is one element of 
the contents of the sample.
  """
  #   from data model element ccp.lims.Sample.SampleComponent revision ?
  _metaclass = metaPackage.getElement('SampleComponent')
  _packageName = 'ccp.lims.Sample'
  _packageShortName = 'SAM'
  _fieldNames = ('applicationData', 'className', 'concDisplayUnit', 'concentration', 'concentrationError', 'concentrationUnit', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'purity', 'qualifiedName', 'serial', 'abstractSample', 'access', 'activeAccess', 'blueprintComponent', 'container', 'contents', 'parent', 'refComponent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.Sample.SampleComponent
    """
    dataDict = self.__dict__
    dataDict['abstractSample'] = parent
    if (not isinstance(parent, AbstractSample)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.Sample.AbstractSample""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['concDisplayUnit'] = None
      dataDict['concentration'] = None
      dataDict['concentrationError'] = None
      dataDict['concentrationUnit'] = None
      dataDict['details'] = None
      dataDict['purity'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['blueprintComponent'] = None
      dataDict['container'] = None
      dataDict['contents'] = set()
      dataDict['refComponent'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.Sample.SampleComponent.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.lims.Sample.SampleComponent')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('sampleComponents')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.Sample.SampleComponent:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    if (dataDict.get('blueprintComponent') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    blueprintComponent = dataDict.get('blueprintComponent')
    if (blueprintComponent is not None):
      topObject = blueprintComponent.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.Sample.SampleComponent:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    blueprintComponent = dataDict.get('blueprintComponent')
    if ((blueprintComponent is not None and not (blueprintComponent in objsToBeDeleted))):
      sampleComponents = blueprintComponent.__dict__.get('sampleComponents')
      sampleComponents.remove(self)

    container = dataDict.get('container')
    if ((container is not None and not (container in objsToBeDeleted))):
      contents = container.__dict__.get('contents')
      contents.remove(self)

    for content in dataDict.get('contents'):
      if (not (content in objsToBeDeleted)):
        content.__dict__['container'] = None

    abstractSample = dataDict.get('abstractSample')
    if (not (abstractSample in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = abstractSample.__dict__.get('sampleComponents')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addContent(self, value):
    """
    Add for ccp.lims.Sample.SampleComponent.contents
    """
    dataDict = self.__dict__
    if (not isinstance(value, SampleComponent)):
      raise ApiError("""%s.addContent:
       value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('contents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addContent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addContent:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addContent:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addContent:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addContent:
           Link contents between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('container')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('contents')
      siblingValues.remove(value)

    value.__dict__['container'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addContent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.Sample.SampleComponent
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.Sample.SampleComponent
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('abstractSample')
        dd = value.__dict__.get('sampleComponents')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'abstractSample' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('concDisplayUnit')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: concDisplayUnit:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: concDisplayUnit:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: concDisplayUnit:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: concDisplayUnit:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('concentration')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: concentration:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: concentration:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('concentrationError')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: concentrationError:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: concentrationError:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('concentrationUnit')
      if (value is not None):
        if (not (value in ['kg/m3', 'M', 'm3/m3', 'mol/mol', 'kg/kg'])):
          raise ApiError("""%s.checkValid: concentrationUnit:
           ccp.lims.Sample.ConcentrationUnit input is not in enumeration ['kg/m3', 'M', 'm3/m3', 'mol/mol', 'kg/kg']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: concentrationUnit:
           ConcentrationUnit constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('purity')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: purity:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: purity:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      value = dataDict.get('abstractSample')
      if (not isinstance(value, AbstractSample)):
        raise ApiError("""%s.checkValid: abstractSample:
         value is not of class ccp.lims.Sample.AbstractSample""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (dataDict.get('blueprintComponent') is None):
        root = dataDict.get('topObject').__dict__.get('memopsRoot')
        root.refreshTopObjects('ccp.lims.ExpBlueprint')
        tobjList = root.__dict__.get('expBlueprintStores').values()
        for tobj in tobjList:
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      value = dataDict.get('blueprintComponent')
      if (value is not None):
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: blueprintComponent:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('sampleComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: blueprintComponent:
           non-reciprocal link blueprintComponent from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('container')
      if (value is not None):
        if (not isinstance(value, SampleComponent)):
          raise ApiError("""%s.checkValid: container:
           value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('contents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: container:
           non-reciprocal link container from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('contents')
      for value in values:
        if (not isinstance(value, SampleComponent)):
          raise ApiError("""%s.checkValid: contents:
           value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('container')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: contents:
           non-reciprocal link contents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: contents:
           Link contents between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refComponent')
      from ccp.api.lims.RefSampleComponent import AbstractComponent as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: refComponent:
         value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: refComponent:
         Link refComponent between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('concDisplayUnit')
    value = dataDict.get('concentration')
    value = dataDict.get('concentrationError')
    value = dataDict.get('concentrationUnit')
    value = dataDict.get('details')
    value = dataDict.get('purity')
    # check roles
    value = dataDict.get('abstractSample')
    if (value is None):
      raise ApiError("""%s.checkValid: abstractSample:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('access')
    value = dataDict.get('blueprintComponent')
    value = dataDict.get('container')
    values = dataDict.get('contents')
    value = dataDict.get('refComponent')
    if (value is None):
      raise ApiError("""%s.checkValid: refComponent:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllContents(self, **conditions):
    """
    FindAll for ccp.lims.Sample.SampleComponent.contents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('contents')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('contents')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('concDisplayUnit', 'concentration', 'concentrationError', 'concentrationUnit', 'details', 'purity', 'serial', 'abstractSample', 'access', 'blueprintComponent', 'container', 'refComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstContent(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.SampleComponent.contents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('contents')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('contents')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('concDisplayUnit', 'concentration', 'concentrationError', 'concentrationUnit', 'details', 'purity', 'serial', 'abstractSample', 'access', 'blueprintComponent', 'container', 'refComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.lims.Sample.SampleComponent
    """
    dataDict = self.__dict__
    return getattr(self, name)
  
  def getAbstractSample(self):
    """
    Get for ccp.lims.Sample.SampleComponent.abstractSample
    """
    dataDict = self.__dict__
    result = dataDict.get('abstractSample')
    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBlueprintComponent(self):
    """
    Get for ccp.lims.Sample.SampleComponent.blueprintComponent
    """
    dataDict = self.__dict__
    if (dataDict.get('blueprintComponent') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    result = dataDict.get('blueprintComponent')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.Sample.SampleComponent
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.SampleComponent'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('sampleStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.Sample')
        obj1 = obj0.__dict__.get('sampleStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.SampleComponent'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('abstractSamples').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('sampleComponents').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getConcDisplayUnit(self):
    """
    Get for ccp.lims.Sample.SampleComponent.concDisplayUnit
    """
    dataDict = self.__dict__
    result = dataDict.get('concDisplayUnit')
    return result
  
  def getConcentration(self):
    """
    Get for ccp.lims.Sample.SampleComponent.concentration
    """
    dataDict = self.__dict__
    result = dataDict.get('concentration')
    return result
  
  def getConcentrationError(self):
    """
    Get for ccp.lims.Sample.SampleComponent.concentrationError
    """
    dataDict = self.__dict__
    result = dataDict.get('concentrationError')
    return result
  
  def getConcentrationUnit(self):
    """
    Get for ccp.lims.Sample.SampleComponent.concentrationUnit
    """
    dataDict = self.__dict__
    result = dataDict.get('concentrationUnit')
    return result
  
  def getContainer(self):
    """
    Get for ccp.lims.Sample.SampleComponent.container
    """
    dataDict = self.__dict__
    result = dataDict.get('container')
    return result
  
  def getContents(self):
    """
    Get for ccp.lims.Sample.SampleComponent.contents
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('contents')
    result = frozenset(tempVar)
    return result
  
  def getDetails(self):
    """
    Get for ccp.lims.Sample.SampleComponent.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.Sample.SampleComponent
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('abstractSample')
    obj1 = obj2.__dict__.get('sampleStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.Sample.SampleComponent
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.Sample.SampleComponent.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('abstractSample')
    return result
  
  def getPurity(self):
    """
    Get for ccp.lims.Sample.SampleComponent.purity
    """
    dataDict = self.__dict__
    result = dataDict.get('purity')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefComponent(self):
    """
    Get for ccp.lims.Sample.SampleComponent.refComponent
    """
    dataDict = self.__dict__
    result = dataDict.get('refComponent')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.lims.Sample.SampleComponent.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeContent(self, value):
    """
    Remove for ccp.lims.Sample.SampleComponent.contents
    """
    dataDict = self.__dict__
    if (not isinstance(value, SampleComponent)):
      raise ApiError("""%s.removeContent:
       value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('contents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeContent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeContent:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeContent:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeContent:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['container'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeContent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.lims.Sample.SampleComponent
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBlueprintComponent(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.blueprintComponent
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setBlueprintComponent:
         value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (dataDict.get('blueprintComponent') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    currentValue = dataDict.get('blueprintComponent')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBlueprintComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBlueprintComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setBlueprintComponent:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setBlueprintComponent:
           Link blueprintComponent between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('sampleComponents')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setBlueprintComponent:
         Read link 'blueprintComponent' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('sampleComponents')
      newSelves.add(self)

    dataDict['blueprintComponent'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBlueprintComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setConcDisplayUnit(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.concDisplayUnit
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setConcDisplayUnit:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setConcDisplayUnit:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setConcDisplayUnit:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setConcDisplayUnit:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('concDisplayUnit')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConcDisplayUnit:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConcDisplayUnit:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['concDisplayUnit'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConcDisplayUnit')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setConcentration(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.concentration
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setConcentration:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setConcentration:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('concentration')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConcentration:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConcentration:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['concentration'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConcentration')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setConcentrationError(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.concentrationError
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setConcentrationError:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setConcentrationError:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('concentrationError')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConcentrationError:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConcentrationError:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['concentrationError'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConcentrationError')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setConcentrationUnit(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.concentrationUnit
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in ['kg/m3', 'M', 'm3/m3', 'mol/mol', 'kg/kg'])):
        raise ApiError("""%s.setConcentrationUnit:
         ccp.lims.Sample.ConcentrationUnit input is not in enumeration ['kg/m3', 'M', 'm3/m3', 'mol/mol', 'kg/kg']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setConcentrationUnit:
         ConcentrationUnit constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('concentrationUnit')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConcentrationUnit:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConcentrationUnit:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['concentrationUnit'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConcentrationUnit')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setContainer(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.container
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, SampleComponent)):
        raise ApiError("""%s.setContainer:
         value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('container')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setContainer:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setContainer:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setContainer:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setContainer:
           Link container between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('contents')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setContainer:
         Read link 'container' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('contents')
      newSelves.add(self)

    dataDict['container'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setContainer')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setContents(self, values):
    """
    Set for ccp.lims.Sample.SampleComponent.contents
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setContents:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, SampleComponent)):
        raise ApiError("""%s.setContents:
         value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('contents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setContents:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setContents:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setContents:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setContents:
           Link contents between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['container'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('container')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('contents')
          vv.remove(cv)

      cv.__dict__['container'] = self

    dataDict['contents'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setContents')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setPurity(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.purity
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setPurity:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setPurity:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('purity')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPurity:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPurity:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['purity'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPurity')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefComponent(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.refComponent
    """
    dataDict = self.__dict__
    from ccp.api.lims.RefSampleComponent import AbstractComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setRefComponent:
       value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('refComponent')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefComponent:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRefComponent:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setRefComponent:
         Link refComponent between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    dataDict['refComponent'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.lims.Sample.SampleComponent.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('abstractSample')
    oldSerial = parent.__dict__.get('_serialDict').get('sampleComponents')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['sampleComponents'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['sampleComponents'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedContents(self):
    """
    Sorted for ccp.lims.Sample.SampleComponent.contents
    """
    dataDict = self.__dict__
    ll = dataDict.get('contents')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  concDisplayUnit = property(getConcDisplayUnit, setConcDisplayUnit, None,
  r"""This is the unit entered by user and used for display.
  """)
  
  concentration = property(getConcentration, setConcentration, None,
  r"""Concentration of the component in the sample.
  """)
  
  concentrationError = property(getConcentrationError, setConcentrationError, None,
  r"""The concentration error.
  """)
  
  concentrationUnit = property(getConcentrationUnit, setConcentrationUnit, None,
  r"""The concentration unit that should be one of these units: kg/m3 for mass 
  density, mol/L (M) for amount-of-substance concentration, m3/m3 for 
  volume fraction, mol/mol for amount of substance fraction and kg/kg for 
  mass fraction.
  """)
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  purity = property(getPurity, setPurity, None,
  r"""The value of the sample component purity.
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  abstractSample = property(getAbstractSample,  None, None,
  r"""parent link
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  blueprintComponent = property(getBlueprintComponent, setBlueprintComponent, None,
  r"""
  """)
  
  container = property(getContainer, setContainer, None,
  r"""The container component to which the sub components belong.
  """)
  
  contents = property(getContents, setContents, None,
  r"""List of sub component contained in another component. This is the 
  contents of a component.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for abstractSample
  """)
  
  refComponent = property(getRefComponent, setRefComponent, None,
  r"""The component used as a reference associated to a SampleComponent.
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class SampleStore(memops.api.Implementation.TopObject):
  r"""TopObject for package Sample
  """
  #   from data model element ccp.lims.Sample.SampleStore revision ?
  _metaclass = metaPackage.getElement('SampleStore')
  _packageName = 'ccp.lims.Sample'
  _packageShortName = 'SAM'
  _fieldNames = ('applicationData', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'abstractSamples', 'access', 'activeAccess', 'activeRepositories', 'memopsRoot', 'packageLocator', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.Sample.SampleStore
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.lims.Sample')

      dataDict['applicationData'] = list()
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['abstractSamples'] = {}
      dataDict['access'] = None
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.Sample.SampleStore.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('sampleStores')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentSampleStore') is None)):
        root.__dict__['currentSampleStore'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.Sample.SampleStore:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    abstractSamples = dataDict.get('abstractSamples').values()
    for abstractSample in abstractSamples:
      if (not (abstractSample in objsToBeDeleted)):
        objsToBeDeleted.add(abstractSample)
        objsToBeChecked.append(abstractSample)

    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.Sample.SampleStore:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentSampleStore')):
      memopsRoot.__dict__['currentSampleStore'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('sampleStores')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['abstractSamples'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.Sample.SampleStore
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('abstractSamples').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.Sample.SampleStore
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('sampleStores')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      values = dataDict.get('abstractSamples').values()
      for value in values:
        if (not isinstance(value, AbstractSample)):
          raise ApiError("""%s.checkValid: abstractSamples:
           value is not of class ccp.lims.Sample.AbstractSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sampleStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: abstractSamples:
           non-reciprocal link abstractSamples from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      values = dataDict.get('abstractSamples').values()
      value = dataDict.get('access')
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete
  
  def findAllAbstractSamples(self, **conditions):
    """
    FindAll for ccp.lims.Sample.SampleStore.abstractSamples
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('abstractSamples').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('abstractSamples').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'ionicStrength', 'isActive', 'isHazard', 'name', 'ph', 'solvent', 'access', 'sampleStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findFirstAbstractSample(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.SampleStore.abstractSamples
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('abstractSamples').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('abstractSamples').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('abstractSamples').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'ionicStrength', 'isActive', 'isHazard', 'name', 'ph', 'solvent', 'access', 'sampleStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.lims.Sample.SampleStore
    """
    dataDict = self.__dict__
    return getattr(self, name)
  
  def getAbstractSamples(self):
    """
    Get for ccp.lims.Sample.SampleStore.abstractSamples
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('abstractSamples').values()
    result = frozenset(tempVar)
    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.Sample.SampleStore
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccp.lims.Sample.SampleStore'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('sampleStores').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.lims.Sample')
      obj1 = startObj.__dict__.get('sampleStores').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.Sample.SampleStore
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.Sample.SampleStore
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.lims.Sample.SampleStore.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.lims.Sample.SampleStore.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.Sample.SampleStore.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newCrystalSample(self, **attrlinks):
    """
    Factory function to create ccp.lims.Sample.CrystalSample
    """
    return CrystalSample(self, **attrlinks)
  
  def newRefSample(self, **attrlinks):
    """
    Factory function to create ccp.lims.Sample.RefSample
    """
    return RefSample(self, **attrlinks)
  
  def newSample(self, **attrlinks):
    """
    Factory function to create ccp.lims.Sample.Sample
    """
    return Sample(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.Sample.SampleStore
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setName(self, value):
    """
    Set for ccp.lims.Sample.SampleStore.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def sortedAbstractSamples(self):
    """
    Sorted for ccp.lims.Sample.SampleStore.abstractSamples
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('abstractSamples')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of SampleStore
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  abstractSamples = property(getAbstractSamples,  None, None,
  r"""child link to class AbstractSample
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class RefSample(AbstractSample):
  r"""Reference data to which a 'real' sample conforms. This is a means to 
store details which are shared by instances of the same reagent but are 
supplier and batch independant.
  """
  #   from data model element ccp.lims.Sample.RefSample revision ?
  _metaclass = metaPackage.getElement('RefSample')
  _packageName = 'ccp.lims.Sample'
  _packageShortName = 'SAM'
  _fieldNames = ('applicationData', 'className', 'details', 'fieldNames', 'inConstructor', 'ionicStrength', 'isActive', 'isDeleted', 'isHazard', 'metaclass', 'name', 'packageName', 'packageShortName', 'ph', 'qualifiedName', 'solvent', 'access', 'activeAccess', 'conformings', 'hazardPhrases', 'localRiskPhrases', 'parent', 'rPhrases', 'refInputSamples', 'refOutputSamples', 'refSamplePositions', 'refSampleSources', 'root', 'sPhrases', 'sampleCategories', 'sampleComponents', 'sampleStore', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.Sample.RefSample
    """
    dataDict = self.__dict__
    dataDict['sampleStore'] = parent
    if (not isinstance(parent, SampleStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['ionicStrength'] = None
      dataDict['isActive'] = None
      dataDict['isHazard'] = None
      dataDict['name'] = None
      dataDict['ph'] = None
      dataDict['solvent'] = None
      dataDict['access'] = None
      dataDict['conformings'] = set()
      dataDict['hazardPhrases'] = set()
      dataDict['refInputSamples'] = set()
      dataDict['refOutputSamples'] = set()
      dataDict['refSamplePositions'] = set()
      dataDict['refSampleSources'] = {}
      dataDict['sampleCategories'] = set()
      dataDict['sampleComponents'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.Sample.RefSample.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['sampleComponents'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('abstractSamples')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.Sample.RefSample:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    refInputSamples = dataDict.get('refInputSamples')
    pass
    for refInputSample in refInputSamples:
      topObject = refInputSample.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    refOutputSamples = dataDict.get('refOutputSamples')
    pass
    for refOutputSample in refOutputSamples:
      topObject = refOutputSample.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    refSamplePositions = dataDict.get('refSamplePositions')
    pass
    for refSamplePosition in refSamplePositions:
      topObject = refSamplePosition.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    refSampleSources = dataDict.get('refSampleSources').values()
    for refSampleSource in refSampleSources:
      if (not (refSampleSource in objsToBeDeleted)):
        objsToBeDeleted.add(refSampleSource)
        objsToBeChecked.append(refSampleSource)

    sampleCategories = dataDict.get('sampleCategories')
    pass
    for sampleCategory in sampleCategories:
      topObject = sampleCategory.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    sampleComponents = dataDict.get('sampleComponents').values()
    for sampleComponent in sampleComponents:
      if (not (sampleComponent in objsToBeDeleted)):
        objsToBeDeleted.add(sampleComponent)
        objsToBeChecked.append(sampleComponent)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.Sample.RefSample:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for conforming in dataDict.get('conformings'):
      if (not (conforming in objsToBeDeleted)):
        conforming.__dict__['refSample'] = None

    for refInputSample in dataDict.get('refInputSamples'):
      if (not (refInputSample in objsToBeDeleted)):
        refInputSample.__dict__['refSample'] = None

    for refOutputSample in dataDict.get('refOutputSamples'):
      if (not (refOutputSample in objsToBeDeleted)):
        refOutputSample.__dict__['refSample'] = None

    for refSamplePosition in dataDict.get('refSamplePositions'):
      if (not (refSamplePosition in objsToBeDeleted)):
        refSamplePosition.__dict__['refSample'] = None

    for sampleCategory in dataDict.get('sampleCategories'):
      if (not (sampleCategory in objsToBeDeleted)):
        abstractSamples = sampleCategory.__dict__.get('abstractSamples')
        abstractSamples.remove(self)

    sampleStore = dataDict.get('sampleStore')
    if (not (sampleStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = sampleStore.__dict__.get('abstractSamples')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addConforming(self, value):
    """
    Add for ccp.lims.Sample.RefSample.conformings
    """
    dataDict = self.__dict__
    if (not isinstance(value, Sample)):
      raise ApiError("""%s.addConforming:
       value is not of class ccp.lims.Sample.Sample""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('conformings')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addConforming:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addConforming:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addConforming:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addConforming:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addConforming:
           Link conformings between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('refSample')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('conformings')
      siblingValues.remove(value)

    value.__dict__['refSample'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addConforming')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addHazardPhrase = AbstractSample.addHazardPhrase
  
  def addRefInputSample(self, value):
    """
    Add for ccp.lims.Sample.RefSample.refInputSamples
    """
    dataDict = self.__dict__
    from ccp.api.lims.Protocol import RefInputSample as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addRefInputSample:
       value is not of class ccp.lims.Protocol.RefInputSample""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('refInputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('refSample')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRefInputSample:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRefInputSample:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addRefInputSample:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addRefInputSample:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addRefInputSample:
           Link refInputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('refSample')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('refInputSamples')
      siblingValues.remove(value)

    value.__dict__['refSample'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRefInputSample')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addRefOutputSample(self, value):
    """
    Add for ccp.lims.Sample.RefSample.refOutputSamples
    """
    dataDict = self.__dict__
    from ccp.api.lims.Protocol import RefOutputSample as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addRefOutputSample:
       value is not of class ccp.lims.Protocol.RefOutputSample""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('refOutputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('refSample')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRefOutputSample:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRefOutputSample:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addRefOutputSample:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addRefOutputSample:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addRefOutputSample:
           Link refOutputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('refSample')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('refOutputSamples')
      siblingValues.remove(value)

    value.__dict__['refSample'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRefOutputSample')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addRefSamplePosition(self, value):
    """
    Add for ccp.lims.Sample.RefSample.refSamplePositions
    """
    dataDict = self.__dict__
    from ccp.api.lims.Holder import RefSamplePosition as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addRefSamplePosition:
       value is not of class ccp.lims.Holder.RefSamplePosition""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refSamplePositions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      if (value.__dict__.get('refSample') is None):
        root = dataDict.get('topObject').__dict__.get('memopsRoot')
        root.refreshTopObjects('ccp.lims.Sample')
        tobjList = root.__dict__.get('sampleStores').values()
        for tobj in tobjList:
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      oldSelf = value.__dict__.get('refSample')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRefSamplePosition:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRefSamplePosition:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addRefSamplePosition:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addRefSamplePosition:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addRefSamplePosition:
           Link refSamplePositions between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('refSample')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('refSamplePositions')
      siblingValues.remove(value)

    value.__dict__['refSample'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRefSamplePosition')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addSampleCategory = AbstractSample.addSampleCategory
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.Sample.RefSample
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('refSampleSources').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('sampleComponents').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.Sample.RefSample
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('sampleStore')
        dd = value.__dict__.get('abstractSamples')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'sampleStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ionicStrength')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: ionicStrength:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: ionicStrength:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isActive')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isActive:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isHazard')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isHazard:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('ph')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: ph:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: ph:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('solvent')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: solvent:
           Solvent constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('conformings')
      for value in values:
        if (not isinstance(value, Sample)):
          raise ApiError("""%s.checkValid: conformings:
           value is not of class ccp.lims.Sample.Sample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refSample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: conformings:
           non-reciprocal link conformings from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: conformings:
           Link conformings between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('hazardPhrases')
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: hazardPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: hazardPhrases:
           Link hazardPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getLocalRiskPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: localRiskPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: localRiskPhrases:
           Link localRiskPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getRPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: rPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: rPhrases:
           Link rPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('refInputSamples')
      for value in values:
        from ccp.api.lims.Protocol import RefInputSample as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: refInputSamples:
           value is not of class ccp.lims.Protocol.RefInputSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refSample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refInputSamples:
           non-reciprocal link refInputSamples from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refInputSamples:
           Link refInputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('refOutputSamples')
      for value in values:
        from ccp.api.lims.Protocol import RefOutputSample as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: refOutputSamples:
           value is not of class ccp.lims.Protocol.RefOutputSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refSample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refOutputSamples:
           non-reciprocal link refOutputSamples from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refOutputSamples:
           Link refOutputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('refSamplePositions')
      for value in values:
        from ccp.api.lims.Holder import RefSamplePosition as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: refSamplePositions:
           value is not of class ccp.lims.Holder.RefSamplePosition""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refSample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refSamplePositions:
           non-reciprocal link refSamplePositions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refSamplePositions:
           Link refSamplePositions between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('refSampleSources').values()
      for value in values:
        if (not isinstance(value, RefSampleSource)):
          raise ApiError("""%s.checkValid: refSampleSources:
           value is not of class ccp.lims.Sample.RefSampleSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refSample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refSampleSources:
           non-reciprocal link refSampleSources from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = self.getSPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: sPhrases:
           Link sPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('sampleCategories')
      for value in values:
        from ccp.api.lims.Classification import SampleCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sampleCategories:
           value is not of class ccp.lims.Classification.SampleCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('abstractSamples')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: sampleCategories:
           non-reciprocal link sampleCategories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('sampleComponents').values()
      for value in values:
        if (not isinstance(value, SampleComponent)):
          raise ApiError("""%s.checkValid: sampleComponents:
           value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('abstractSample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: sampleComponents:
           non-reciprocal link sampleComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('sampleStore')
      if (not isinstance(value, SampleStore)):
        raise ApiError("""%s.checkValid: sampleStore:
         value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('ionicStrength')
    value = dataDict.get('isActive')
    value = dataDict.get('isHazard')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('ph')
    value = dataDict.get('solvent')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('conformings')
    values = dataDict.get('hazardPhrases')
    values = dataDict.get('refInputSamples')
    values = dataDict.get('refOutputSamples')
    values = dataDict.get('refSamplePositions')
    values = dataDict.get('refSampleSources').values()
    values = dataDict.get('sampleCategories')
    values = dataDict.get('sampleComponents').values()
    value = dataDict.get('sampleStore')
    if (value is None):
      raise ApiError("""%s.checkValid: sampleStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllConformings(self, **conditions):
    """
    FindAll for ccp.lims.Sample.RefSample.conformings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('conformings')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('conformings')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('amountDisplayUnit', 'amountUnit', 'batchNum', 'colPosition', 'currentAmount', 'currentAmountFlag', 'details', 'initialAmount', 'ionicStrength', 'isActive', 'isHazard', 'name', 'ph', 'rowPosition', 'solvent', 'subPosition', 'access', 'holder', 'outputSample', 'refSample', 'sampleStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllHazardPhrases = AbstractSample.findAllHazardPhrases

  findAllLocalRiskPhrases = AbstractSample.findAllLocalRiskPhrases

  findAllRPhrases = AbstractSample.findAllRPhrases
  
  def findAllRefInputSamples(self, **conditions):
    """
    FindAll for ccp.lims.Sample.RefSample.refInputSamples
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('refInputSamples')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('refInputSamples')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('amount', 'displayUnit', 'name', 'serial', 'unit', 'access', 'protocol', 'refSample', 'step',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRefOutputSamples(self, **conditions):
    """
    FindAll for ccp.lims.Sample.RefSample.refOutputSamples
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('refOutputSamples')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('refOutputSamples')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('amount', 'displayUnit', 'name', 'serial', 'unit', 'access', 'protocol', 'refSample', 'step',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRefSamplePositions(self, **conditions):
    """
    FindAll for ccp.lims.Sample.RefSample.refSamplePositions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('refSamplePositions')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('refSamplePositions')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('colPosition', 'rowPosition', 'serial', 'subPosition', 'access', 'holder', 'refSample',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRefSampleSources(self, **conditions):
    """
    FindAll for ccp.lims.Sample.RefSample.refSampleSources
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('refSampleSources').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('refSampleSources').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('catalogNum', 'dataPageUrl', 'access', 'refSample', 'supplier',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllSPhrases = AbstractSample.findAllSPhrases

  findAllSampleCategories = AbstractSample.findAllSampleCategories

  findAllSampleComponents = AbstractSample.findAllSampleComponents

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstConforming(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.RefSample.conformings
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('conformings')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('conformings')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('amountDisplayUnit', 'amountUnit', 'batchNum', 'colPosition', 'currentAmount', 'currentAmountFlag', 'details', 'initialAmount', 'ionicStrength', 'isActive', 'isHazard', 'name', 'ph', 'rowPosition', 'solvent', 'subPosition', 'access', 'holder', 'outputSample', 'refSample', 'sampleStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstHazardPhrase = AbstractSample.findFirstHazardPhrase

  findFirstLocalRiskPhrase = AbstractSample.findFirstLocalRiskPhrase

  findFirstRPhrase = AbstractSample.findFirstRPhrase
  
  def findFirstRefInputSample(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.RefSample.refInputSamples
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('refInputSamples')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('refInputSamples')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('amount', 'displayUnit', 'name', 'serial', 'unit', 'access', 'protocol', 'refSample', 'step',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRefOutputSample(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.RefSample.refOutputSamples
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('refOutputSamples')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Protocol')
      tobjList = root.__dict__.get('protocolStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('refOutputSamples')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('amount', 'displayUnit', 'name', 'serial', 'unit', 'access', 'protocol', 'refSample', 'step',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRefSamplePosition(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.RefSample.refSamplePositions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('refSamplePositions')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('refSamplePositions')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('colPosition', 'rowPosition', 'serial', 'subPosition', 'access', 'holder', 'refSample',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRefSampleSource(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.RefSample.refSampleSources
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('refSampleSources').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('catalogNum')
      if (objKey is not None):
        result = dataDict.get('refSampleSources').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('refSampleSources').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('catalogNum', 'dataPageUrl', 'access', 'refSample', 'supplier',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstSPhrase = AbstractSample.findFirstSPhrase

  findFirstSampleCategory = AbstractSample.findFirstSampleCategory

  findFirstSampleComponent = AbstractSample.findFirstSampleComponent
  
  def get(self, name):
    """
    GetAttr for ccp.lims.Sample.RefSample
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.Sample.RefSample
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.RefSample'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('sampleStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.Sample')
        obj1 = obj0.__dict__.get('sampleStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.RefSample'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('abstractSamples').get(objKey)
      if (isinstance(obj2, RefSample)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getConformings(self):
    """
    Get for ccp.lims.Sample.RefSample.conformings
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('conformings')
    result = frozenset(tempVar)
    return result

  getDetails = AbstractSample.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractSample.getFullKey

  getHazardPhrases = AbstractSample.getHazardPhrases

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIonicStrength = AbstractSample.getIonicStrength

  getIsActive = AbstractSample.getIsActive

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsHazard = AbstractSample.getIsHazard

  getLocalKey = AbstractSample.getLocalKey

  getLocalRiskPhrases = AbstractSample.getLocalRiskPhrases

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = AbstractSample.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractSample.getParent

  getPh = AbstractSample.getPh

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRPhrases = AbstractSample.getRPhrases
  
  def getRefInputSamples(self):
    """
    Get for ccp.lims.Sample.RefSample.refInputSamples
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('refInputSamples')
    result = frozenset(tempVar)
    return result
  
  def getRefOutputSamples(self):
    """
    Get for ccp.lims.Sample.RefSample.refOutputSamples
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('refOutputSamples')
    result = frozenset(tempVar)
    return result
  
  def getRefSamplePositions(self):
    """
    Get for ccp.lims.Sample.RefSample.refSamplePositions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('refSamplePositions')
    result = frozenset(tempVar)
    return result
  
  def getRefSampleSources(self):
    """
    Get for ccp.lims.Sample.RefSample.refSampleSources
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('refSampleSources').values()
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSPhrases = AbstractSample.getSPhrases

  getSampleCategories = AbstractSample.getSampleCategories

  getSampleComponents = AbstractSample.getSampleComponents

  getSampleStore = AbstractSample.getSampleStore

  getSolvent = AbstractSample.getSolvent

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newRefSampleSource(self, **attrlinks):
    """
    Factory function to create ccp.lims.Sample.RefSampleSource
    """
    return RefSampleSource(self, **attrlinks)

  newSampleComponent = AbstractSample.newSampleComponent

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeConforming(self, value):
    """
    Remove for ccp.lims.Sample.RefSample.conformings
    """
    dataDict = self.__dict__
    if (not isinstance(value, Sample)):
      raise ApiError("""%s.removeConforming:
       value is not of class ccp.lims.Sample.Sample""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('conformings')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeConforming:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeConforming:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeConforming:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeConforming:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['refSample'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeConforming')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeHazardPhrase = AbstractSample.removeHazardPhrase
  
  def removeRefInputSample(self, value):
    """
    Remove for ccp.lims.Sample.RefSample.refInputSamples
    """
    dataDict = self.__dict__
    from ccp.api.lims.Protocol import RefInputSample as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeRefInputSample:
       value is not of class ccp.lims.Protocol.RefInputSample""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('refInputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRefInputSample:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRefInputSample:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeRefInputSample:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRefInputSample:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['refSample'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRefInputSample')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeRefOutputSample(self, value):
    """
    Remove for ccp.lims.Sample.RefSample.refOutputSamples
    """
    dataDict = self.__dict__
    from ccp.api.lims.Protocol import RefOutputSample as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeRefOutputSample:
       value is not of class ccp.lims.Protocol.RefOutputSample""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('refOutputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRefOutputSample:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRefOutputSample:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeRefOutputSample:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRefOutputSample:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['refSample'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRefOutputSample')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeRefSamplePosition(self, value):
    """
    Remove for ccp.lims.Sample.RefSample.refSamplePositions
    """
    dataDict = self.__dict__
    from ccp.api.lims.Holder import RefSamplePosition as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeRefSamplePosition:
       value is not of class ccp.lims.Holder.RefSamplePosition""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refSamplePositions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRefSamplePosition:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRefSamplePosition:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeRefSamplePosition:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRefSamplePosition:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['refSample'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRefSamplePosition')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeSampleCategory = AbstractSample.removeSampleCategory
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.Sample.RefSample
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setConformings(self, values):
    """
    Set for ccp.lims.Sample.RefSample.conformings
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setConformings:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Sample)):
        raise ApiError("""%s.setConformings:
         value is not of class ccp.lims.Sample.Sample""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('conformings')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConformings:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConformings:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setConformings:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setConformings:
           Link conformings between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['refSample'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('refSample')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('conformings')
          vv.remove(cv)

      cv.__dict__['refSample'] = self

    dataDict['conformings'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConformings')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = AbstractSample.setDetails

  setHazardPhrases = AbstractSample.setHazardPhrases

  setIonicStrength = AbstractSample.setIonicStrength

  setIsActive = AbstractSample.setIsActive

  setIsHazard = AbstractSample.setIsHazard

  setName = AbstractSample.setName

  setPh = AbstractSample.setPh
  
  def setRefInputSamples(self, values):
    """
    Set for ccp.lims.Sample.RefSample.refInputSamples
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRefInputSamples:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Protocol import RefInputSample as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setRefInputSamples:
         value is not of class ccp.lims.Protocol.RefInputSample""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('refInputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('refSample')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setRefInputSamples:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefInputSamples:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefInputSamples:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefInputSamples:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRefInputSamples:
           Link refInputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['refSample'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('refSample')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('refInputSamples')
          vv.remove(cv)

      cv.__dict__['refSample'] = self

    dataDict['refInputSamples'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefInputSamples')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefOutputSamples(self, values):
    """
    Set for ccp.lims.Sample.RefSample.refOutputSamples
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRefOutputSamples:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Protocol import RefOutputSample as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setRefOutputSamples:
         value is not of class ccp.lims.Protocol.RefOutputSample""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('refOutputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('refSample')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setRefOutputSamples:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefOutputSamples:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefOutputSamples:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefOutputSamples:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRefOutputSamples:
           Link refOutputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['refSample'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('refSample')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('refOutputSamples')
          vv.remove(cv)

      cv.__dict__['refSample'] = self

    dataDict['refOutputSamples'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefOutputSamples')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefSamplePositions(self, values):
    """
    Set for ccp.lims.Sample.RefSample.refSamplePositions
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRefSamplePositions:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Holder import RefSamplePosition as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setRefSamplePositions:
         value is not of class ccp.lims.Holder.RefSamplePosition""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refSamplePositions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Sample')
      tobjList = set(root.__dict__.get('sampleStores').values())
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('refSample')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setRefSamplePositions:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefSamplePositions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefSamplePositions:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefSamplePositions:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRefSamplePositions:
           Link refSamplePositions between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['refSample'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('refSample')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('refSamplePositions')
          vv.remove(cv)

      cv.__dict__['refSample'] = self

    dataDict['refSamplePositions'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefSamplePositions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setSampleCategories = AbstractSample.setSampleCategories

  setSolvent = AbstractSample.setSolvent
  
  def sortedConformings(self):
    """
    Sorted for ccp.lims.Sample.RefSample.conformings
    """
    dataDict = self.__dict__
    ll = dataDict.get('conformings')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedHazardPhrases = AbstractSample.sortedHazardPhrases

  sortedLocalRiskPhrases = AbstractSample.sortedLocalRiskPhrases

  sortedRPhrases = AbstractSample.sortedRPhrases
  
  def sortedRefInputSamples(self):
    """
    Sorted for ccp.lims.Sample.RefSample.refInputSamples
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('refInputSamples')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedRefOutputSamples(self):
    """
    Sorted for ccp.lims.Sample.RefSample.refOutputSamples
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Protocol')
    tobjList = root.__dict__.get('protocolStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('refOutputSamples')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedRefSamplePositions(self):
    """
    Sorted for ccp.lims.Sample.RefSample.refSamplePositions
    """
    dataDict = self.__dict__
    ll = dataDict.get('refSamplePositions')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedRefSampleSources(self):
    """
    Sorted for ccp.lims.Sample.RefSample.refSampleSources
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('refSampleSources')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  sortedSPhrases = AbstractSample.sortedSPhrases

  sortedSampleCategories = AbstractSample.sortedSampleCategories

  sortedSampleComponents = AbstractSample.sortedSampleComponents

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  details = AbstractSample.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ionicStrength = AbstractSample.ionicStrength

  isActive = AbstractSample.isActive

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isHazard = AbstractSample.isHazard

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = AbstractSample.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  ph = AbstractSample.ph

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  solvent = AbstractSample.solvent

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  conformings = property(getConformings, setConformings, None,
  r"""List of samples that are conforming to the RefSample.
  """)

  hazardPhrases = AbstractSample.hazardPhrases

  localRiskPhrases = AbstractSample.localRiskPhrases

  parent = AbstractSample.parent

  rPhrases = AbstractSample.rPhrases
  
  refInputSamples = property(getRefInputSamples, setRefInputSamples, None,
  r"""
  """)
  
  refOutputSamples = property(getRefOutputSamples, setRefOutputSamples, None,
  r"""
  """)
  
  refSamplePositions = property(getRefSamplePositions, setRefSamplePositions, None,
  r"""
  """)
  
  refSampleSources = property(getRefSampleSources,  None, None,
  r"""child link to class RefSampleSource
  """)

  root = memops.api.Implementation.MemopsObject.root

  sPhrases = AbstractSample.sPhrases

  sampleCategories = AbstractSample.sampleCategories

  sampleComponents = AbstractSample.sampleComponents

  sampleStore = AbstractSample.sampleStore

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Sample(AbstractSample):
  r"""The information on the sample. The sample conforms to a particular 
sample reference information. The sample is the contents that has been 
used during an experiment that contains the sample components which is 
located in an Holder.
  """
  #   from data model element ccp.lims.Sample.Sample revision ?
  _metaclass = metaPackage.getElement('Sample')
  _packageName = 'ccp.lims.Sample'
  _packageShortName = 'SAM'
  _fieldNames = ('amountDisplayUnit', 'amountUnit', 'applicationData', 'batchNum', 'className', 'colPosition', 'creationDate', 'currentAmount', 'currentAmountFlag', 'details', 'fieldNames', 'inConstructor', 'initialAmount', 'ionicStrength', 'isActive', 'isDeleted', 'isHazard', 'metaclass', 'name', 'packageName', 'packageShortName', 'ph', 'qualifiedName', 'rowPosition', 'solvent', 'subPosition', 'access', 'activeAccess', 'dropAnnotations', 'hazardPhrases', 'holder', 'inputSamples', 'localRiskPhrases', 'mixtures', 'nmrExperiments', 'outputSample', 'parent', 'rPhrases', 'refSample', 'root', 'sPhrases', 'sampleCategories', 'sampleComponents', 'sampleStore', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.Sample.Sample
    """
    dataDict = self.__dict__
    dataDict['sampleStore'] = parent
    if (not isinstance(parent, SampleStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['amountDisplayUnit'] = None
      dataDict['amountUnit'] = None
      dataDict['applicationData'] = list()
      dataDict['batchNum'] = None
      dataDict['colPosition'] = None
      dataDict['currentAmount'] = None
      dataDict['currentAmountFlag'] = None
      dataDict['details'] = None
      dataDict['initialAmount'] = None
      dataDict['ionicStrength'] = None
      dataDict['isActive'] = None
      dataDict['isHazard'] = None
      dataDict['name'] = None
      dataDict['ph'] = None
      dataDict['rowPosition'] = None
      dataDict['solvent'] = None
      dataDict['subPosition'] = None
      dataDict['access'] = None
      dataDict['dropAnnotations'] = set()
      dataDict['hazardPhrases'] = set()
      dataDict['holder'] = None
      dataDict['inputSamples'] = set()
      dataDict['mixtures'] = set()
      dataDict['nmrExperiments'] = set()
      dataDict['outputSample'] = None
      dataDict['refSample'] = None
      dataDict['sampleCategories'] = set()
      dataDict['sampleComponents'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.Sample.Sample.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['sampleComponents'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('abstractSamples')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.Sample.Sample:
       determines cascading deletes 
    to follow from delete of object.
       *Implementation function* - should 
    be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Crystallization')
    tobjList = root.__dict__.get('crystallizationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    dropAnnotations = dataDict.get('dropAnnotations')
    pass
    for dropAnnotation in dropAnnotations:
      topObject = dropAnnotation.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    holder = dataDict.get('holder')
    if (holder is not None):
      topObject = holder.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Experiment')
    tobjList = root.__dict__.get('experimentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    inputSamples = dataDict.get('inputSamples')
    pass
    for inputSample in inputSamples:
      topObject = inputSample.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tobjList = root.__dict__.get('nmrScreens').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    mixtures = dataDict.get('mixtures')
    pass
    for mixture in mixtures:
      topObject = mixture.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrExperiments = dataDict.get('nmrExperiments')
    pass
    for nmrExperiment in nmrExperiments:
      topObject = nmrExperiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    if (dataDict.get('outputSample') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    outputSample = dataDict.get('outputSample')
    if (outputSample is not None):
      topObject = outputSample.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    sampleCategories = dataDict.get('sampleCategories')
    pass
    for sampleCategory in sampleCategories:
      topObject = sampleCategory.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    sampleComponents = dataDict.get('sampleComponents').values()
    for sampleComponent in sampleComponents:
      if (not (sampleComponent in objsToBeDeleted)):
        objsToBeDeleted.add(sampleComponent)
        objsToBeChecked.append(sampleComponent)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.Sample.Sample:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for dropAnnotation in dataDict.get('dropAnnotations'):
      if (not (dropAnnotation in objsToBeDeleted)):
        dropAnnotation.__dict__['sample'] = None

    holder = dataDict.get('holder')
    if ((holder is not None and not (holder in objsToBeDeleted))):
      samples = holder.__dict__.get('samples')
      samples.remove(self)

    for inputSample in dataDict.get('inputSamples'):
      if (not (inputSample in objsToBeDeleted)):
        inputSample.__dict__['sample'] = None

    for mixture in dataDict.get('mixtures'):
      if (not (mixture in objsToBeDeleted)):
        mixture.__dict__['sample'] = None

    for nmrExperiment in dataDict.get('nmrExperiments'):
      if (not (nmrExperiment in objsToBeDeleted)):
        nmrExperiment.__dict__['sample'] = None

    outputSample = dataDict.get('outputSample')
    if ((outputSample is not None and not (outputSample in objsToBeDeleted))):
      outputSample.__dict__['sample'] = None

    refSample = dataDict.get('refSample')
    if ((refSample is not None and not (refSample in objsToBeDeleted))):
      conformings = refSample.__dict__.get('conformings')
      conformings.remove(self)

    for sampleCategory in dataDict.get('sampleCategories'):
      if (not (sampleCategory in objsToBeDeleted)):
        abstractSamples = sampleCategory.__dict__.get('abstractSamples')
        abstractSamples.remove(self)

    sampleStore = dataDict.get('sampleStore')
    if (not (sampleStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = sampleStore.__dict__.get('abstractSamples')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addDropAnnotation(self, value):
    """
    Add for ccp.lims.Sample.Sample.dropAnnotations
    """
    dataDict = self.__dict__
    from ccp.api.lims.Crystallization import DropAnnotation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addDropAnnotation:
       value is not of class ccp.lims.Crystallization.DropAnnotation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Crystallization')
    tobjList = root.__dict__.get('crystallizationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('dropAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('sample')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addDropAnnotation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addDropAnnotation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addDropAnnotation:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addDropAnnotation:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addDropAnnotation:
           Link dropAnnotations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('sample')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Crystallization')
      tobjList = root.__dict__.get('crystallizationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('dropAnnotations')
      siblingValues.remove(value)

    value.__dict__['sample'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addDropAnnotation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addHazardPhrase = AbstractSample.addHazardPhrase
  
  def addInputSample(self, value):
    """
    Add for ccp.lims.Sample.Sample.inputSamples
    """
    dataDict = self.__dict__
    from ccp.api.lims.Experiment import InputSample as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addInputSample:
       value is not of class ccp.lims.Experiment.InputSample""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Experiment')
    tobjList = root.__dict__.get('experimentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('inputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('sample')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addInputSample:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addInputSample:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addInputSample:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addInputSample:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addInputSample:
           Link inputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('sample')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('inputSamples')
      siblingValues.remove(value)

    value.__dict__['sample'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addInputSample')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addMixture(self, value):
    """
    Add for ccp.lims.Sample.Sample.mixtures
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrScreen import Mixture as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMixture:
       value is not of class ccp.nmr.NmrScreen.Mixture""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tobjList = root.__dict__.get('nmrScreens').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('mixtures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('sample')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMixture:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMixture:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMixture:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMixture:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMixture:
           Link mixtures between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('sample')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      tobjList = root.__dict__.get('nmrScreens').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('mixtures')
      siblingValues.remove(value)

    value.__dict__['sample'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMixture')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addNmrExperiment(self, value):
    """
    Add for ccp.lims.Sample.Sample.nmrExperiments
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import Experiment as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addNmrExperiment:
       value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrExperiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('sample')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNmrExperiment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNmrExperiment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addNmrExperiment:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addNmrExperiment:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addNmrExperiment:
           Link nmrExperiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('sample')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('nmrExperiments')
      siblingValues.remove(value)

    value.__dict__['sample'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNmrExperiment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addSampleCategory = AbstractSample.addSampleCategory
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.Sample.Sample
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('sampleComponents').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.Sample.Sample
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('sampleStore')
        dd = value.__dict__.get('abstractSamples')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'sampleStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('amountDisplayUnit')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: amountDisplayUnit:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: amountDisplayUnit:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: amountDisplayUnit:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: amountDisplayUnit:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('amountUnit')
      if (value is not None):
        if (not (value in ['kg', 'L', 'number'])):
          raise ApiError("""%s.checkValid: amountUnit:
           ccp.lims.Sample.AmountUnit input is not in enumeration ['kg', 'L', 'number']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: amountUnit:
           AmountUnit constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('batchNum')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: batchNum:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: batchNum:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: batchNum:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: batchNum:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('colPosition')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: colPosition:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getCreationDate()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: creationDate:
           memops.Implementation.DateTime input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('currentAmount')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: currentAmount:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: currentAmount:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('currentAmountFlag')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: currentAmountFlag:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('initialAmount')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: initialAmount:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: initialAmount:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ionicStrength')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: ionicStrength:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: ionicStrength:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isActive')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isActive:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isHazard')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isHazard:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('ph')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: ph:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: ph:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('rowPosition')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: rowPosition:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('solvent')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: solvent:
           Solvent constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('subPosition')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: subPosition:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Crystallization')
      tobjList = root.__dict__.get('crystallizationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('dropAnnotations')
      for value in values:
        from ccp.api.lims.Crystallization import DropAnnotation as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dropAnnotations:
           value is not of class ccp.lims.Crystallization.DropAnnotation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: dropAnnotations:
           non-reciprocal link dropAnnotations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: dropAnnotations:
           Link dropAnnotations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('hazardPhrases')
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: hazardPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: hazardPhrases:
           Link hazardPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('holder')
      if (value is not None):
        from ccp.api.lims.Holder import Holder as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: holder:
           value is not of class ccp.lims.Holder.Holder""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('samples')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: holder:
           non-reciprocal link holder from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('inputSamples')
      for value in values:
        from ccp.api.lims.Experiment import InputSample as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: inputSamples:
           value is not of class ccp.lims.Experiment.InputSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: inputSamples:
           non-reciprocal link inputSamples from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: inputSamples:
           Link inputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getLocalRiskPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: localRiskPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: localRiskPhrases:
           Link localRiskPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      tobjList = root.__dict__.get('nmrScreens').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('mixtures')
      for value in values:
        from ccp.api.nmr.NmrScreen import Mixture as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: mixtures:
           value is not of class ccp.nmr.NmrScreen.Mixture""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: mixtures:
           non-reciprocal link mixtures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: mixtures:
           Link mixtures between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrExperiments')
      for value in values:
        from ccp.api.nmr.Nmr import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrExperiments:
           value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrExperiments:
           non-reciprocal link nmrExperiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrExperiments:
           Link nmrExperiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (dataDict.get('outputSample') is None):
        root = dataDict.get('topObject').__dict__.get('memopsRoot')
        root.refreshTopObjects('ccp.lims.Experiment')
        tobjList = root.__dict__.get('experimentStores').values()
        for tobj in tobjList:
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      value = dataDict.get('outputSample')
      if (value is not None):
        from ccp.api.lims.Experiment import OutputSample as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: outputSample:
           value is not of class ccp.lims.Experiment.OutputSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: outputSample:
           non-reciprocal link outputSample from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: outputSample:
           Link outputSample between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getRPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: rPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: rPhrases:
           Link rPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSample')
      if (value is not None):
        if (not isinstance(value, RefSample)):
          raise ApiError("""%s.checkValid: refSample:
           value is not of class ccp.lims.Sample.RefSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('conformings')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: refSample:
           non-reciprocal link refSample from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = self.getSPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: sPhrases:
           Link sPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('sampleCategories')
      for value in values:
        from ccp.api.lims.Classification import SampleCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sampleCategories:
           value is not of class ccp.lims.Classification.SampleCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('abstractSamples')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: sampleCategories:
           non-reciprocal link sampleCategories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('sampleComponents').values()
      for value in values:
        if (not isinstance(value, SampleComponent)):
          raise ApiError("""%s.checkValid: sampleComponents:
           value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('abstractSample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: sampleComponents:
           non-reciprocal link sampleComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('sampleStore')
      if (not isinstance(value, SampleStore)):
        raise ApiError("""%s.checkValid: sampleStore:
         value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('amountDisplayUnit')
    value = dataDict.get('amountUnit')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('batchNum')
    value = dataDict.get('colPosition')
    value = dataDict.get('currentAmount')
    value = dataDict.get('currentAmountFlag')
    value = dataDict.get('details')
    value = dataDict.get('initialAmount')
    value = dataDict.get('ionicStrength')
    value = dataDict.get('isActive')
    value = dataDict.get('isHazard')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('ph')
    value = dataDict.get('rowPosition')
    value = dataDict.get('solvent')
    value = dataDict.get('subPosition')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('dropAnnotations')
    values = dataDict.get('hazardPhrases')
    value = dataDict.get('holder')
    values = dataDict.get('inputSamples')
    values = dataDict.get('mixtures')
    values = dataDict.get('nmrExperiments')
    value = dataDict.get('outputSample')
    value = dataDict.get('refSample')
    values = dataDict.get('sampleCategories')
    values = dataDict.get('sampleComponents').values()
    value = dataDict.get('sampleStore')
    if (value is None):
      raise ApiError("""%s.checkValid: sampleStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllDropAnnotations(self, **conditions):
    """
    FindAll for ccp.lims.Sample.Sample.dropAnnotations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Crystallization')
      tobjList = root.__dict__.get('crystallizationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dropAnnotations')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Crystallization')
      tobjList = root.__dict__.get('crystallizationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dropAnnotations')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('cmdLineParam', 'scoreDate', 'serial', 'access', 'annotator', 'crystallizationStore', 'image', 'sample', 'score', 'software',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllHazardPhrases = AbstractSample.findAllHazardPhrases
  
  def findAllInputSamples(self, **conditions):
    """
    FindAll for ccp.lims.Sample.Sample.inputSamples
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('inputSamples')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('inputSamples')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('amount', 'amountDisplayUnit', 'amountUnit', 'name', 'role', 'serial', 'access', 'experiment', 'refInputSample', 'sample',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllLocalRiskPhrases = AbstractSample.findAllLocalRiskPhrases
  
  def findAllMixtures(self, **conditions):
    """
    FindAll for ccp.lims.Sample.Sample.mixtures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      tobjList = root.__dict__.get('nmrScreens').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('mixtures')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      tobjList = root.__dict__.get('nmrScreens').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('mixtures')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'serial', 'access', 'nmrScreen', 'sample',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrExperiments(self, **conditions):
    """
    FindAll for ccp.lims.Sample.Sample.nmrExperiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrExperiments')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrExperiments')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'details', 'name', 'nmrTubeType', 'numDim', 'numScans', 'sampleState', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'userExpCode', 'volumeUnit', 'access', 'derivationMethod', 'dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'nmrProject', 'noeList', 'pkaList', 'probe', 'rawData', 'rdcList', 'refExperiment', 'sample', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 'spectrometer', 't1List', 't1RhoList', 't2List',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllRPhrases = AbstractSample.findAllRPhrases

  findAllSPhrases = AbstractSample.findAllSPhrases

  findAllSampleCategories = AbstractSample.findAllSampleCategories

  findAllSampleComponents = AbstractSample.findAllSampleComponents

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstDropAnnotation(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.Sample.dropAnnotations
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Crystallization')
      tobjList = root.__dict__.get('crystallizationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dropAnnotations')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Crystallization')
      tobjList = root.__dict__.get('crystallizationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('dropAnnotations')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('cmdLineParam', 'scoreDate', 'serial', 'access', 'annotator', 'crystallizationStore', 'image', 'sample', 'score', 'software',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstHazardPhrase = AbstractSample.findFirstHazardPhrase
  
  def findFirstInputSample(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.Sample.inputSamples
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('inputSamples')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('inputSamples')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('amount', 'amountDisplayUnit', 'amountUnit', 'name', 'role', 'serial', 'access', 'experiment', 'refInputSample', 'sample',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstLocalRiskPhrase = AbstractSample.findFirstLocalRiskPhrase
  
  def findFirstMixture(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.Sample.mixtures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      tobjList = root.__dict__.get('nmrScreens').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('mixtures')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      tobjList = root.__dict__.get('nmrScreens').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('mixtures')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'serial', 'access', 'nmrScreen', 'sample',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrExperiment(self, **conditions):
    """
    FindFirst for ccp.lims.Sample.Sample.nmrExperiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrExperiments')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nmrExperiments')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'details', 'name', 'nmrTubeType', 'numDim', 'numScans', 'sampleState', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'userExpCode', 'volumeUnit', 'access', 'derivationMethod', 'dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'nmrProject', 'noeList', 'pkaList', 'probe', 'rawData', 'rdcList', 'refExperiment', 'sample', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 'spectrometer', 't1List', 't1RhoList', 't2List',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstRPhrase = AbstractSample.findFirstRPhrase

  findFirstSPhrase = AbstractSample.findFirstSPhrase

  findFirstSampleCategory = AbstractSample.findFirstSampleCategory

  findFirstSampleComponent = AbstractSample.findFirstSampleComponent
  
  def get(self, name):
    """
    GetAttr for ccp.lims.Sample.Sample
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAmountDisplayUnit(self):
    """
    Get for ccp.lims.Sample.Sample.amountDisplayUnit
    """
    dataDict = self.__dict__
    result = dataDict.get('amountDisplayUnit')
    return result
  
  def getAmountUnit(self):
    """
    Get for ccp.lims.Sample.Sample.amountUnit
    """
    dataDict = self.__dict__
    result = dataDict.get('amountUnit')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBatchNum(self):
    """
    Get for ccp.lims.Sample.Sample.batchNum
    """
    dataDict = self.__dict__
    result = dataDict.get('batchNum')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.Sample.Sample
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.Sample'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('sampleStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.Sample')
        obj1 = obj0.__dict__.get('sampleStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.Sample'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('abstractSamples').get(objKey)
      if (isinstance(obj2, Sample)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getColPosition(self):
    """
    Get for ccp.lims.Sample.Sample.colPosition
    """
    dataDict = self.__dict__
    result = dataDict.get('colPosition')
    return result
  
  def getCreationDate(self):
    """
    getter for derived attribute creationDate
    """
    dataDict = self.__dict__
    result = None
    # Removed 20/12/07 because it breaks the import relationship NBNB TBD 
    #os = self.outputSample
    #if os == None:
    #  result = None
    #else:
    #  exp = os.experiment
    #  if exp == None:
    #    result = None
    #  else:
    #    result = exp.endDate
    return result
  
  def getCurrentAmount(self):
    """
    Get for ccp.lims.Sample.Sample.currentAmount
    """
    dataDict = self.__dict__
    result = dataDict.get('currentAmount')
    return result
  
  def getCurrentAmountFlag(self):
    """
    Get for ccp.lims.Sample.Sample.currentAmountFlag
    """
    dataDict = self.__dict__
    result = dataDict.get('currentAmountFlag')
    return result

  getDetails = AbstractSample.getDetails
  
  def getDropAnnotations(self):
    """
    Get for ccp.lims.Sample.Sample.dropAnnotations
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Crystallization')
    tobjList = root.__dict__.get('crystallizationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('dropAnnotations')
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractSample.getFullKey

  getHazardPhrases = AbstractSample.getHazardPhrases
  
  def getHolder(self):
    """
    Get for ccp.lims.Sample.Sample.holder
    """
    dataDict = self.__dict__
    result = dataDict.get('holder')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInitialAmount(self):
    """
    Get for ccp.lims.Sample.Sample.initialAmount
    """
    dataDict = self.__dict__
    result = dataDict.get('initialAmount')
    return result
  
  def getInputSamples(self):
    """
    Get for ccp.lims.Sample.Sample.inputSamples
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Experiment')
    tobjList = root.__dict__.get('experimentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('inputSamples')
    result = frozenset(tempVar)
    return result

  getIonicStrength = AbstractSample.getIonicStrength

  getIsActive = AbstractSample.getIsActive

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsHazard = AbstractSample.getIsHazard

  getLocalKey = AbstractSample.getLocalKey

  getLocalRiskPhrases = AbstractSample.getLocalRiskPhrases

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMixtures(self):
    """
    Get for ccp.lims.Sample.Sample.mixtures
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tobjList = root.__dict__.get('nmrScreens').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('mixtures')
    result = frozenset(tempVar)
    return result

  getName = AbstractSample.getName
  
  def getNmrExperiments(self):
    """
    Get for ccp.lims.Sample.Sample.nmrExperiments
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('nmrExperiments')
    result = frozenset(tempVar)
    return result
  
  def getOutputSample(self):
    """
    Get for ccp.lims.Sample.Sample.outputSample
    """
    dataDict = self.__dict__
    if (dataDict.get('outputSample') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    result = dataDict.get('outputSample')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractSample.getParent

  getPh = AbstractSample.getPh

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRPhrases = AbstractSample.getRPhrases
  
  def getRefSample(self):
    """
    Get for ccp.lims.Sample.Sample.refSample
    """
    dataDict = self.__dict__
    result = dataDict.get('refSample')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRowPosition(self):
    """
    Get for ccp.lims.Sample.Sample.rowPosition
    """
    dataDict = self.__dict__
    result = dataDict.get('rowPosition')
    return result

  getSPhrases = AbstractSample.getSPhrases

  getSampleCategories = AbstractSample.getSampleCategories

  getSampleComponents = AbstractSample.getSampleComponents

  getSampleStore = AbstractSample.getSampleStore

  getSolvent = AbstractSample.getSolvent
  
  def getSubPosition(self):
    """
    Get for ccp.lims.Sample.Sample.subPosition
    """
    dataDict = self.__dict__
    result = dataDict.get('subPosition')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  newSampleComponent = AbstractSample.newSampleComponent

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeDropAnnotation(self, value):
    """
    Remove for ccp.lims.Sample.Sample.dropAnnotations
    """
    dataDict = self.__dict__
    from ccp.api.lims.Crystallization import DropAnnotation as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeDropAnnotation:
       value is not of class ccp.lims.Crystallization.DropAnnotation""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Crystallization')
    tobjList = root.__dict__.get('crystallizationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('dropAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeDropAnnotation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeDropAnnotation:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeDropAnnotation:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeDropAnnotation:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['sample'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeDropAnnotation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeHazardPhrase = AbstractSample.removeHazardPhrase
  
  def removeInputSample(self, value):
    """
    Remove for ccp.lims.Sample.Sample.inputSamples
    """
    dataDict = self.__dict__
    from ccp.api.lims.Experiment import InputSample as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeInputSample:
       value is not of class ccp.lims.Experiment.InputSample""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Experiment')
    tobjList = root.__dict__.get('experimentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('inputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeInputSample:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeInputSample:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeInputSample:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeInputSample:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['sample'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeInputSample')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeMixture(self, value):
    """
    Remove for ccp.lims.Sample.Sample.mixtures
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrScreen import Mixture as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMixture:
       value is not of class ccp.nmr.NmrScreen.Mixture""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tobjList = root.__dict__.get('nmrScreens').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('mixtures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMixture:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMixture:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMixture:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMixture:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['sample'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMixture')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeNmrExperiment(self, value):
    """
    Remove for ccp.lims.Sample.Sample.nmrExperiments
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import Experiment as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeNmrExperiment:
       value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrExperiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNmrExperiment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNmrExperiment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeNmrExperiment:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNmrExperiment:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['sample'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNmrExperiment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeSampleCategory = AbstractSample.removeSampleCategory
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.Sample.Sample
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAmountDisplayUnit(self, value):
    """
    Set for ccp.lims.Sample.Sample.amountDisplayUnit
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAmountDisplayUnit:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setAmountDisplayUnit:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAmountDisplayUnit:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setAmountDisplayUnit:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('amountDisplayUnit')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAmountDisplayUnit:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAmountDisplayUnit:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['amountDisplayUnit'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAmountDisplayUnit')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAmountUnit(self, value):
    """
    Set for ccp.lims.Sample.Sample.amountUnit
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in ['kg', 'L', 'number'])):
        raise ApiError("""%s.setAmountUnit:
         ccp.lims.Sample.AmountUnit input is not in enumeration ['kg', 'L', 'number']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setAmountUnit:
         AmountUnit constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('amountUnit')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAmountUnit:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAmountUnit:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['amountUnit'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAmountUnit')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBatchNum(self, value):
    """
    Set for ccp.lims.Sample.Sample.batchNum
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setBatchNum:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setBatchNum:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setBatchNum:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setBatchNum:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('batchNum')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBatchNum:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBatchNum:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['batchNum'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBatchNum')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setColPosition(self, value):
    """
    Set for ccp.lims.Sample.Sample.colPosition
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setColPosition:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('colPosition')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setColPosition:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setColPosition:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['colPosition'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setColPosition')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentAmount(self, value):
    """
    Set for ccp.lims.Sample.Sample.currentAmount
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setCurrentAmount:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setCurrentAmount:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentAmount')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentAmount:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentAmount:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['currentAmount'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentAmount')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentAmountFlag(self, value):
    """
    Set for ccp.lims.Sample.Sample.currentAmountFlag
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setCurrentAmountFlag:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentAmountFlag')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentAmountFlag:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentAmountFlag:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['currentAmountFlag'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentAmountFlag')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = AbstractSample.setDetails
  
  def setDropAnnotations(self, values):
    """
    Set for ccp.lims.Sample.Sample.dropAnnotations
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setDropAnnotations:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Crystallization import DropAnnotation as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setDropAnnotations:
         value is not of class ccp.lims.Crystallization.DropAnnotation""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Crystallization')
    tobjList = root.__dict__.get('crystallizationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('dropAnnotations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('sample')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setDropAnnotations:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDropAnnotations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDropAnnotations:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDropAnnotations:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setDropAnnotations:
           Link dropAnnotations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['sample'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('sample')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('dropAnnotations')
          vv.remove(cv)

      cv.__dict__['sample'] = self

    dataDict['dropAnnotations'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDropAnnotations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setHazardPhrases = AbstractSample.setHazardPhrases
  
  def setHolder(self, value):
    """
    Set for ccp.lims.Sample.Sample.holder
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Holder import Holder as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setHolder:
         value is not of class ccp.lims.Holder.Holder""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('holder')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setHolder:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setHolder:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setHolder:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setHolder:
           Link holder between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('samples')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setHolder:
         Read link 'holder' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('samples')
      newSelves.add(self)

    dataDict['holder'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setHolder')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setInitialAmount(self, value):
    """
    Set for ccp.lims.Sample.Sample.initialAmount
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setInitialAmount:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setInitialAmount:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('initialAmount')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setInitialAmount:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setInitialAmount:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['initialAmount'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setInitialAmount')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setInputSamples(self, values):
    """
    Set for ccp.lims.Sample.Sample.inputSamples
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setInputSamples:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Experiment import InputSample as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setInputSamples:
         value is not of class ccp.lims.Experiment.InputSample""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Experiment')
    tobjList = root.__dict__.get('experimentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('inputSamples')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('sample')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setInputSamples:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setInputSamples:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setInputSamples:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setInputSamples:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setInputSamples:
           Link inputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['sample'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('sample')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('inputSamples')
          vv.remove(cv)

      cv.__dict__['sample'] = self

    dataDict['inputSamples'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setInputSamples')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setIonicStrength = AbstractSample.setIonicStrength

  setIsActive = AbstractSample.setIsActive

  setIsHazard = AbstractSample.setIsHazard
  
  def setMixtures(self, values):
    """
    Set for ccp.lims.Sample.Sample.mixtures
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMixtures:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrScreen import Mixture as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMixtures:
         value is not of class ccp.nmr.NmrScreen.Mixture""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tobjList = root.__dict__.get('nmrScreens').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('mixtures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('sample')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setMixtures:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMixtures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMixtures:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMixtures:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMixtures:
           Link mixtures between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['sample'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('sample')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('mixtures')
          vv.remove(cv)

      cv.__dict__['sample'] = self

    dataDict['mixtures'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMixtures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = AbstractSample.setName
  
  def setNmrExperiments(self, values):
    """
    Set for ccp.lims.Sample.Sample.nmrExperiments
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNmrExperiments:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import Experiment as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrExperiments:
         value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nmrExperiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('sample')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setNmrExperiments:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrExperiments:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrExperiments:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrExperiments:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNmrExperiments:
           Link nmrExperiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['sample'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('sample')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('nmrExperiments')
          vv.remove(cv)

      cv.__dict__['sample'] = self

    dataDict['nmrExperiments'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNmrExperiments')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setOutputSample(self, value):
    """
    Set for ccp.lims.Sample.Sample.outputSample
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Experiment import OutputSample as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setOutputSample:
         value is not of class ccp.lims.Experiment.OutputSample""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (dataDict.get('outputSample') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    currentValue = dataDict.get('outputSample')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)
        oldSelf = value.__dict__.get('sample')
        if (oldSelf is not None):
          if (notIsReading):
            topObject = oldSelf.__dict__.get('topObject')
            topObjectsToCheck.add(topObject)
          else:
            raise ApiError("""%s.setOutputSample:
             Read link incompatible with pre-existing link""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setOutputSample:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setOutputSample:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setOutputSample:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setOutputSample:
           Link outputSample between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      currentValue.__dict__['sample'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('sample')
      if (oldSelf is not None):
        oldSelf.__dict__['outputSample'] = None

      value.__dict__['sample'] = self

    dataDict['outputSample'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setOutputSample')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setPh = AbstractSample.setPh
  
  def setRefSample(self, value):
    """
    Set for ccp.lims.Sample.Sample.refSample
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, RefSample)):
        raise ApiError("""%s.setRefSample:
         value is not of class ccp.lims.Sample.RefSample""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('refSample')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefSample:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefSample:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefSample:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRefSample:
           Link refSample between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('conformings')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setRefSample:
         Read link 'refSample' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('conformings')
      newSelves.add(self)

    dataDict['refSample'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefSample')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRowPosition(self, value):
    """
    Set for ccp.lims.Sample.Sample.rowPosition
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setRowPosition:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('rowPosition')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRowPosition:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRowPosition:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['rowPosition'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRowPosition')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setSampleCategories = AbstractSample.setSampleCategories

  setSolvent = AbstractSample.setSolvent
  
  def setSubPosition(self, value):
    """
    Set for ccp.lims.Sample.Sample.subPosition
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setSubPosition:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('subPosition')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSubPosition:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSubPosition:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['subPosition'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSubPosition')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedDropAnnotations(self):
    """
    Sorted for ccp.lims.Sample.Sample.dropAnnotations
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Crystallization')
    tobjList = root.__dict__.get('crystallizationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('dropAnnotations')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedHazardPhrases = AbstractSample.sortedHazardPhrases
  
  def sortedInputSamples(self):
    """
    Sorted for ccp.lims.Sample.Sample.inputSamples
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Experiment')
    tobjList = root.__dict__.get('experimentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('inputSamples')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedLocalRiskPhrases = AbstractSample.sortedLocalRiskPhrases
  
  def sortedMixtures(self):
    """
    Sorted for ccp.lims.Sample.Sample.mixtures
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tobjList = root.__dict__.get('nmrScreens').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('mixtures')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedNmrExperiments(self):
    """
    Sorted for ccp.lims.Sample.Sample.nmrExperiments
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('nmrExperiments')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedRPhrases = AbstractSample.sortedRPhrases

  sortedSPhrases = AbstractSample.sortedSPhrases

  sortedSampleCategories = AbstractSample.sortedSampleCategories

  sortedSampleComponents = AbstractSample.sortedSampleComponents

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  amountDisplayUnit = property(getAmountDisplayUnit, setAmountDisplayUnit, None,
  r"""This is the unit entered by user and used for display.
  """)
  
  amountUnit = property(getAmountUnit, setAmountUnit, None,
  r"""One of the three possible units: kg, L or number.
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  batchNum = property(getBatchNum, setBatchNum, None,
  r"""This is the batch or lot number of the sample.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  colPosition = property(getColPosition, setColPosition, None,
  r"""The column position of the sample in the holder.
  """)
  
  creationDate = property(getCreationDate, None, None,
  r"""The creation date is derived from the endDate of the Experiment which 
  creates it.
  """)
  
  currentAmount = property(getCurrentAmount, setCurrentAmount, None,
  r"""The current amount of the sample. Can be deduced by a subtraction 
  between the initial amount and all the amount which are implied in 
  experiments.
  """)
  
  currentAmountFlag = property(getCurrentAmountFlag, setCurrentAmountFlag, None,
  r"""Was current amount validated?
  """)

  details = AbstractSample.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  initialAmount = property(getInitialAmount, setInitialAmount, None,
  r"""The initial amount of the sample at the creation date.
  """)

  ionicStrength = AbstractSample.ionicStrength

  isActive = AbstractSample.isActive

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isHazard = AbstractSample.isHazard

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = AbstractSample.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  ph = AbstractSample.ph

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  rowPosition = property(getRowPosition, setRowPosition, None,
  r"""The row position of the sample in the holder.
  """)

  solvent = AbstractSample.solvent
  
  subPosition = property(getSubPosition, setSubPosition, None,
  r"""The sub-position of the sample in the holder.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  dropAnnotations = property(getDropAnnotations, setDropAnnotations, None,
  r"""
  """)

  hazardPhrases = AbstractSample.hazardPhrases
  
  holder = property(getHolder, setHolder, None,
  r"""The holder to which the samples belong.
  """)
  
  inputSamples = property(getInputSamples, setInputSamples, None,
  r"""Input sample list that describes the amount of sample used per 
  experiment for a given sample.
  """)

  localRiskPhrases = AbstractSample.localRiskPhrases
  
  mixtures = property(getMixtures, setMixtures, None,
  r"""
  """)
  
  nmrExperiments = property(getNmrExperiments, setNmrExperiments, None,
  r"""Nmrr experiments carried out on Sample
  """)
  
  outputSample = property(getOutputSample, setOutputSample, None,
  r"""Output sample list that describes the amount of sample created by that 
  experiment for a given sample.
  """)

  parent = AbstractSample.parent

  rPhrases = AbstractSample.rPhrases
  
  refSample = property(getRefSample, setRefSample, None,
  r"""The RefSample that conforms to the Sample.
  """)

  root = memops.api.Implementation.MemopsObject.root

  sPhrases = AbstractSample.sPhrases

  sampleCategories = AbstractSample.sampleCategories

  sampleComponents = AbstractSample.sampleComponents

  sampleStore = AbstractSample.sampleStore

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class CrystalSample(Sample):
  r"""The CrystalSample contains information about an individual Crystal and 
its  physical properties : dimensions, color,...
  """
  #   from data model element ccp.lims.Sample.CrystalSample revision ?
  _metaclass = metaPackage.getElement('CrystalSample')
  _packageName = 'ccp.lims.Sample'
  _packageShortName = 'SAM'
  _fieldNames = ('a', 'alpha', 'amountDisplayUnit', 'amountUnit', 'applicationData', 'b', 'batchNum', 'beta', 'c', 'className', 'colPosition', 'colour', 'creationDate', 'crystalType', 'currentAmount', 'currentAmountFlag', 'details', 'fieldNames', 'gamma', 'inConstructor', 'initialAmount', 'ionicStrength', 'isActive', 'isDeleted', 'isHazard', 'metaclass', 'morphology', 'name', 'packageName', 'packageShortName', 'ph', 'qualifiedName', 'rowPosition', 'solvent', 'spaceGroup', 'subPosition', 'x', 'y', 'z', 'access', 'activeAccess', 'dropAnnotations', 'hazardPhrases', 'holder', 'inputSamples', 'localRiskPhrases', 'mixtures', 'nmrExperiments', 'outputSample', 'parent', 'rPhrases', 'refSample', 'root', 'sPhrases', 'sampleCategories', 'sampleComponents', 'sampleStore', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.Sample.CrystalSample
    """
    dataDict = self.__dict__
    dataDict['sampleStore'] = parent
    if (not isinstance(parent, SampleStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['a'] = None
      dataDict['alpha'] = None
      dataDict['amountDisplayUnit'] = None
      dataDict['amountUnit'] = None
      dataDict['applicationData'] = list()
      dataDict['b'] = None
      dataDict['batchNum'] = None
      dataDict['beta'] = None
      dataDict['c'] = None
      dataDict['colPosition'] = None
      dataDict['colour'] = None
      dataDict['crystalType'] = None
      dataDict['currentAmount'] = None
      dataDict['currentAmountFlag'] = None
      dataDict['details'] = None
      dataDict['gamma'] = None
      dataDict['initialAmount'] = None
      dataDict['ionicStrength'] = None
      dataDict['isActive'] = None
      dataDict['isHazard'] = None
      dataDict['morphology'] = None
      dataDict['name'] = None
      dataDict['ph'] = None
      dataDict['rowPosition'] = None
      dataDict['solvent'] = None
      dataDict['spaceGroup'] = None
      dataDict['subPosition'] = None
      dataDict['x'] = None
      dataDict['y'] = None
      dataDict['z'] = None
      dataDict['access'] = None
      dataDict['dropAnnotations'] = set()
      dataDict['hazardPhrases'] = set()
      dataDict['holder'] = None
      dataDict['inputSamples'] = set()
      dataDict['mixtures'] = set()
      dataDict['nmrExperiments'] = set()
      dataDict['outputSample'] = None
      dataDict['refSample'] = None
      dataDict['sampleCategories'] = set()
      dataDict['sampleComponents'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.Sample.CrystalSample.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['sampleComponents'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('abstractSamples')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.Sample.CrystalSample:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Crystallization')
    tobjList = root.__dict__.get('crystallizationStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    dropAnnotations = dataDict.get('dropAnnotations')
    pass
    for dropAnnotation in dropAnnotations:
      topObject = dropAnnotation.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    holder = dataDict.get('holder')
    if (holder is not None):
      topObject = holder.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Experiment')
    tobjList = root.__dict__.get('experimentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    inputSamples = dataDict.get('inputSamples')
    pass
    for inputSample in inputSamples:
      topObject = inputSample.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tobjList = root.__dict__.get('nmrScreens').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    mixtures = dataDict.get('mixtures')
    pass
    for mixture in mixtures:
      topObject = mixture.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nmrExperiments = dataDict.get('nmrExperiments')
    pass
    for nmrExperiment in nmrExperiments:
      topObject = nmrExperiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    if (dataDict.get('outputSample') is None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

    outputSample = dataDict.get('outputSample')
    if (outputSample is not None):
      topObject = outputSample.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    sampleCategories = dataDict.get('sampleCategories')
    pass
    for sampleCategory in sampleCategories:
      topObject = sampleCategory.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    sampleComponents = dataDict.get('sampleComponents').values()
    for sampleComponent in sampleComponents:
      if (not (sampleComponent in objsToBeDeleted)):
        objsToBeDeleted.add(sampleComponent)
        objsToBeChecked.append(sampleComponent)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.Sample.CrystalSample:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for dropAnnotation in dataDict.get('dropAnnotations'):
      if (not (dropAnnotation in objsToBeDeleted)):
        dropAnnotation.__dict__['sample'] = None

    holder = dataDict.get('holder')
    if ((holder is not None and not (holder in objsToBeDeleted))):
      samples = holder.__dict__.get('samples')
      samples.remove(self)

    for inputSample in dataDict.get('inputSamples'):
      if (not (inputSample in objsToBeDeleted)):
        inputSample.__dict__['sample'] = None

    for mixture in dataDict.get('mixtures'):
      if (not (mixture in objsToBeDeleted)):
        mixture.__dict__['sample'] = None

    for nmrExperiment in dataDict.get('nmrExperiments'):
      if (not (nmrExperiment in objsToBeDeleted)):
        nmrExperiment.__dict__['sample'] = None

    outputSample = dataDict.get('outputSample')
    if ((outputSample is not None and not (outputSample in objsToBeDeleted))):
      outputSample.__dict__['sample'] = None

    refSample = dataDict.get('refSample')
    if ((refSample is not None and not (refSample in objsToBeDeleted))):
      conformings = refSample.__dict__.get('conformings')
      conformings.remove(self)

    for sampleCategory in dataDict.get('sampleCategories'):
      if (not (sampleCategory in objsToBeDeleted)):
        abstractSamples = sampleCategory.__dict__.get('abstractSamples')
        abstractSamples.remove(self)

    sampleStore = dataDict.get('sampleStore')
    if (not (sampleStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = sampleStore.__dict__.get('abstractSamples')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addDropAnnotation = Sample.addDropAnnotation

  addHazardPhrase = AbstractSample.addHazardPhrase

  addInputSample = Sample.addInputSample

  addMixture = Sample.addMixture

  addNmrExperiment = Sample.addNmrExperiment

  addSampleCategory = AbstractSample.addSampleCategory
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.Sample.CrystalSample
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('sampleComponents').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.Sample.CrystalSample
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('sampleStore')
        dd = value.__dict__.get('abstractSamples')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'sampleStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('a')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: a:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: a:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('alpha')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: alpha:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: alpha:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('amountDisplayUnit')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: amountDisplayUnit:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: amountDisplayUnit:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: amountDisplayUnit:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: amountDisplayUnit:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('amountUnit')
      if (value is not None):
        if (not (value in ['kg', 'L', 'number'])):
          raise ApiError("""%s.checkValid: amountUnit:
           ccp.lims.Sample.AmountUnit input is not in enumeration ['kg', 'L', 'number']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: amountUnit:
           AmountUnit constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('b')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: b:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: b:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('batchNum')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: batchNum:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: batchNum:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: batchNum:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: batchNum:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('beta')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: beta:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: beta:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('c')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: c:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: c:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('colPosition')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: colPosition:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('colour')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: colour:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: colour:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: colour:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getCreationDate()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: creationDate:
           memops.Implementation.DateTime input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('crystalType')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: crystalType:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: crystalType:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: crystalType:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('currentAmount')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: currentAmount:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: currentAmount:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('currentAmountFlag')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: currentAmountFlag:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('gamma')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: gamma:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: gamma:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('initialAmount')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: initialAmount:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: initialAmount:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ionicStrength')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: ionicStrength:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: ionicStrength:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isActive')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isActive:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isHazard')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isHazard:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('morphology')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: morphology:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: morphology:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: morphology:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('ph')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: ph:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: ph:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('rowPosition')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: rowPosition:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('solvent')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: solvent:
           ccp.lims.Sample.Solvent: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: solvent:
           Solvent constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('spaceGroup')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: spaceGroup:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: spaceGroup:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: spaceGroup:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: spaceGroup:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('subPosition')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: subPosition:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('x')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: x:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: x:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('y')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: y:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: y:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('z')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: z:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: z:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Crystallization')
      tobjList = root.__dict__.get('crystallizationStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('dropAnnotations')
      for value in values:
        from ccp.api.lims.Crystallization import DropAnnotation as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dropAnnotations:
           value is not of class ccp.lims.Crystallization.DropAnnotation""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: dropAnnotations:
           non-reciprocal link dropAnnotations from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: dropAnnotations:
           Link dropAnnotations between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('hazardPhrases')
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: hazardPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: hazardPhrases:
           Link hazardPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('holder')
      if (value is not None):
        from ccp.api.lims.Holder import Holder as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: holder:
           value is not of class ccp.lims.Holder.Holder""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('samples')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: holder:
           non-reciprocal link holder from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Experiment')
      tobjList = root.__dict__.get('experimentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('inputSamples')
      for value in values:
        from ccp.api.lims.Experiment import InputSample as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: inputSamples:
           value is not of class ccp.lims.Experiment.InputSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: inputSamples:
           non-reciprocal link inputSamples from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: inputSamples:
           Link inputSamples between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getLocalRiskPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: localRiskPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: localRiskPhrases:
           Link localRiskPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      tobjList = root.__dict__.get('nmrScreens').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('mixtures')
      for value in values:
        from ccp.api.nmr.NmrScreen import Mixture as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: mixtures:
           value is not of class ccp.nmr.NmrScreen.Mixture""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: mixtures:
           non-reciprocal link mixtures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: mixtures:
           Link mixtures between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nmrExperiments')
      for value in values:
        from ccp.api.nmr.Nmr import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrExperiments:
           value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrExperiments:
           non-reciprocal link nmrExperiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrExperiments:
           Link nmrExperiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (dataDict.get('outputSample') is None):
        root = dataDict.get('topObject').__dict__.get('memopsRoot')
        root.refreshTopObjects('ccp.lims.Experiment')
        tobjList = root.__dict__.get('experimentStores').values()
        for tobj in tobjList:
          if (not (tobj.__dict__.get('isLoaded'))):
            tobj.load()

      value = dataDict.get('outputSample')
      if (value is not None):
        from ccp.api.lims.Experiment import OutputSample as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: outputSample:
           value is not of class ccp.lims.Experiment.OutputSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('sample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: outputSample:
           non-reciprocal link outputSample from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: outputSample:
           Link outputSample between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getRPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: rPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: rPhrases:
           Link rPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSample')
      if (value is not None):
        if (not isinstance(value, RefSample)):
          raise ApiError("""%s.checkValid: refSample:
           value is not of class ccp.lims.Sample.RefSample""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('conformings')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: refSample:
           non-reciprocal link refSample from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = self.getSPhrases()
      for value in values:
        from ccp.api.lims.Classification import HazardPhrase as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sPhrases:
           value is not of class ccp.lims.Classification.HazardPhrase""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: sPhrases:
           Link sPhrases between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('sampleCategories')
      for value in values:
        from ccp.api.lims.Classification import SampleCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sampleCategories:
           value is not of class ccp.lims.Classification.SampleCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('abstractSamples')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: sampleCategories:
           non-reciprocal link sampleCategories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('sampleComponents').values()
      for value in values:
        if (not isinstance(value, SampleComponent)):
          raise ApiError("""%s.checkValid: sampleComponents:
           value is not of class ccp.lims.Sample.SampleComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('abstractSample')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: sampleComponents:
           non-reciprocal link sampleComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('sampleStore')
      if (not isinstance(value, SampleStore)):
        raise ApiError("""%s.checkValid: sampleStore:
         value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('a')
    value = dataDict.get('alpha')
    value = dataDict.get('amountDisplayUnit')
    value = dataDict.get('amountUnit')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('b')
    value = dataDict.get('batchNum')
    value = dataDict.get('beta')
    value = dataDict.get('c')
    value = dataDict.get('colPosition')
    value = dataDict.get('colour')
    value = dataDict.get('crystalType')
    value = dataDict.get('currentAmount')
    value = dataDict.get('currentAmountFlag')
    value = dataDict.get('details')
    value = dataDict.get('gamma')
    value = dataDict.get('initialAmount')
    value = dataDict.get('ionicStrength')
    value = dataDict.get('isActive')
    value = dataDict.get('isHazard')
    value = dataDict.get('morphology')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('ph')
    value = dataDict.get('rowPosition')
    value = dataDict.get('solvent')
    value = dataDict.get('spaceGroup')
    value = dataDict.get('subPosition')
    value = dataDict.get('x')
    value = dataDict.get('y')
    value = dataDict.get('z')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('dropAnnotations')
    values = dataDict.get('hazardPhrases')
    value = dataDict.get('holder')
    values = dataDict.get('inputSamples')
    values = dataDict.get('mixtures')
    values = dataDict.get('nmrExperiments')
    value = dataDict.get('outputSample')
    value = dataDict.get('refSample')
    values = dataDict.get('sampleCategories')
    values = dataDict.get('sampleComponents').values()
    value = dataDict.get('sampleStore')
    if (value is None):
      raise ApiError("""%s.checkValid: sampleStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllDropAnnotations = Sample.findAllDropAnnotations

  findAllHazardPhrases = AbstractSample.findAllHazardPhrases

  findAllInputSamples = Sample.findAllInputSamples

  findAllLocalRiskPhrases = AbstractSample.findAllLocalRiskPhrases

  findAllMixtures = Sample.findAllMixtures

  findAllNmrExperiments = Sample.findAllNmrExperiments

  findAllRPhrases = AbstractSample.findAllRPhrases

  findAllSPhrases = AbstractSample.findAllSPhrases

  findAllSampleCategories = AbstractSample.findAllSampleCategories

  findAllSampleComponents = AbstractSample.findAllSampleComponents

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstDropAnnotation = Sample.findFirstDropAnnotation

  findFirstHazardPhrase = AbstractSample.findFirstHazardPhrase

  findFirstInputSample = Sample.findFirstInputSample

  findFirstLocalRiskPhrase = AbstractSample.findFirstLocalRiskPhrase

  findFirstMixture = Sample.findFirstMixture

  findFirstNmrExperiment = Sample.findFirstNmrExperiment

  findFirstRPhrase = AbstractSample.findFirstRPhrase

  findFirstSPhrase = AbstractSample.findFirstSPhrase

  findFirstSampleCategory = AbstractSample.findFirstSampleCategory

  findFirstSampleComponent = AbstractSample.findFirstSampleComponent
  
  def get(self, name):
    """
    GetAttr for ccp.lims.Sample.CrystalSample
    """
    dataDict = self.__dict__
    return getattr(self, name)
  
  def getA(self):
    """
    Get for ccp.lims.Sample.CrystalSample.a
    """
    dataDict = self.__dict__
    result = dataDict.get('a')
    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAlpha(self):
    """
    Get for ccp.lims.Sample.CrystalSample.alpha
    """
    dataDict = self.__dict__
    result = dataDict.get('alpha')
    return result

  getAmountDisplayUnit = Sample.getAmountDisplayUnit

  getAmountUnit = Sample.getAmountUnit

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getB(self):
    """
    Get for ccp.lims.Sample.CrystalSample.b
    """
    dataDict = self.__dict__
    result = dataDict.get('b')
    return result

  getBatchNum = Sample.getBatchNum
  
  def getBeta(self):
    """
    Get for ccp.lims.Sample.CrystalSample.beta
    """
    dataDict = self.__dict__
    result = dataDict.get('beta')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.Sample.CrystalSample
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.CrystalSample'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('sampleStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.Sample')
        obj1 = obj0.__dict__.get('sampleStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.Sample.CrystalSample'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('abstractSamples').get(objKey)
      if (isinstance(obj2, CrystalSample)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getC(self):
    """
    Get for ccp.lims.Sample.CrystalSample.c
    """
    dataDict = self.__dict__
    result = dataDict.get('c')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getColPosition = Sample.getColPosition
  
  def getColour(self):
    """
    Get for ccp.lims.Sample.CrystalSample.colour
    """
    dataDict = self.__dict__
    result = dataDict.get('colour')
    return result

  getCreationDate = Sample.getCreationDate
  
  def getCrystalType(self):
    """
    Get for ccp.lims.Sample.CrystalSample.crystalType
    """
    dataDict = self.__dict__
    result = dataDict.get('crystalType')
    return result

  getCurrentAmount = Sample.getCurrentAmount

  getCurrentAmountFlag = Sample.getCurrentAmountFlag

  getDetails = AbstractSample.getDetails

  getDropAnnotations = Sample.getDropAnnotations

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractSample.getFullKey
  
  def getGamma(self):
    """
    Get for ccp.lims.Sample.CrystalSample.gamma
    """
    dataDict = self.__dict__
    result = dataDict.get('gamma')
    return result

  getHazardPhrases = AbstractSample.getHazardPhrases

  getHolder = Sample.getHolder

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getInitialAmount = Sample.getInitialAmount

  getInputSamples = Sample.getInputSamples

  getIonicStrength = AbstractSample.getIonicStrength

  getIsActive = AbstractSample.getIsActive

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsHazard = AbstractSample.getIsHazard

  getLocalKey = AbstractSample.getLocalKey

  getLocalRiskPhrases = AbstractSample.getLocalRiskPhrases

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMixtures = Sample.getMixtures
  
  def getMorphology(self):
    """
    Get for ccp.lims.Sample.CrystalSample.morphology
    """
    dataDict = self.__dict__
    result = dataDict.get('morphology')
    return result

  getName = AbstractSample.getName

  getNmrExperiments = Sample.getNmrExperiments

  getOutputSample = Sample.getOutputSample

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractSample.getParent

  getPh = AbstractSample.getPh

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRPhrases = AbstractSample.getRPhrases

  getRefSample = Sample.getRefSample

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRowPosition = Sample.getRowPosition

  getSPhrases = AbstractSample.getSPhrases

  getSampleCategories = AbstractSample.getSampleCategories

  getSampleComponents = AbstractSample.getSampleComponents

  getSampleStore = AbstractSample.getSampleStore

  getSolvent = AbstractSample.getSolvent
  
  def getSpaceGroup(self):
    """
    Get for ccp.lims.Sample.CrystalSample.spaceGroup
    """
    dataDict = self.__dict__
    result = dataDict.get('spaceGroup')
    return result

  getSubPosition = Sample.getSubPosition

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getX(self):
    """
    Get for ccp.lims.Sample.CrystalSample.x
    """
    dataDict = self.__dict__
    result = dataDict.get('x')
    return result
  
  def getY(self):
    """
    Get for ccp.lims.Sample.CrystalSample.y
    """
    dataDict = self.__dict__
    result = dataDict.get('y')
    return result
  
  def getZ(self):
    """
    Get for ccp.lims.Sample.CrystalSample.z
    """
    dataDict = self.__dict__
    result = dataDict.get('z')
    return result

  newSampleComponent = AbstractSample.newSampleComponent

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeDropAnnotation = Sample.removeDropAnnotation

  removeHazardPhrase = AbstractSample.removeHazardPhrase

  removeInputSample = Sample.removeInputSample

  removeMixture = Sample.removeMixture

  removeNmrExperiment = Sample.removeNmrExperiment

  removeSampleCategory = AbstractSample.removeSampleCategory
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.Sample.CrystalSample
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setA(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.a
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setA:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setA:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('a')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setA:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setA:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['a'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setA')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAlpha(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.alpha
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setAlpha:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setAlpha:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('alpha')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAlpha:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAlpha:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['alpha'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAlpha')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAmountDisplayUnit = Sample.setAmountDisplayUnit

  setAmountUnit = Sample.setAmountUnit

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setB(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.b
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setB:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setB:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('b')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setB:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setB:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['b'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setB')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setBatchNum = Sample.setBatchNum
  
  def setBeta(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.beta
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setBeta:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setBeta:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('beta')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBeta:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBeta:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['beta'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBeta')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setC(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.c
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setC:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setC:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('c')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setC:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setC:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['c'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setC')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setColPosition = Sample.setColPosition
  
  def setColour(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.colour
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setColour:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setColour:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setColour:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('colour')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setColour:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setColour:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['colour'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setColour')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCrystalType(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.crystalType
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCrystalType:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setCrystalType:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCrystalType:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('crystalType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCrystalType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCrystalType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['crystalType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCrystalType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCurrentAmount = Sample.setCurrentAmount

  setCurrentAmountFlag = Sample.setCurrentAmountFlag

  setDetails = AbstractSample.setDetails

  setDropAnnotations = Sample.setDropAnnotations
  
  def setGamma(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.gamma
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setGamma:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setGamma:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('gamma')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setGamma:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setGamma:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['gamma'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setGamma')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setHazardPhrases = AbstractSample.setHazardPhrases

  setHolder = Sample.setHolder

  setInitialAmount = Sample.setInitialAmount

  setInputSamples = Sample.setInputSamples

  setIonicStrength = AbstractSample.setIonicStrength

  setIsActive = AbstractSample.setIsActive

  setIsHazard = AbstractSample.setIsHazard

  setMixtures = Sample.setMixtures
  
  def setMorphology(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.morphology
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMorphology:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setMorphology:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMorphology:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('morphology')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMorphology:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMorphology:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['morphology'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMorphology')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = AbstractSample.setName

  setNmrExperiments = Sample.setNmrExperiments

  setOutputSample = Sample.setOutputSample

  setPh = AbstractSample.setPh

  setRefSample = Sample.setRefSample

  setRowPosition = Sample.setRowPosition

  setSampleCategories = AbstractSample.setSampleCategories

  setSolvent = AbstractSample.setSolvent
  
  def setSpaceGroup(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.spaceGroup
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSpaceGroup:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setSpaceGroup:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSpaceGroup:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setSpaceGroup:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('spaceGroup')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSpaceGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSpaceGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['spaceGroup'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSpaceGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setSubPosition = Sample.setSubPosition
  
  def setX(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.x
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setX:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setX:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('x')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setX:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setX:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['x'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setX')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setY(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.y
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setY:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setY:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('y')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setY:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setY:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['y'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setY')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setZ(self, value):
    """
    Set for ccp.lims.Sample.CrystalSample.z
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setZ:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setZ:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('z')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setZ:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setZ:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['z'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setZ')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  sortedDropAnnotations = Sample.sortedDropAnnotations

  sortedHazardPhrases = AbstractSample.sortedHazardPhrases

  sortedInputSamples = Sample.sortedInputSamples

  sortedLocalRiskPhrases = AbstractSample.sortedLocalRiskPhrases

  sortedMixtures = Sample.sortedMixtures

  sortedNmrExperiments = Sample.sortedNmrExperiments

  sortedRPhrases = AbstractSample.sortedRPhrases

  sortedSPhrases = AbstractSample.sortedSPhrases

  sortedSampleCategories = AbstractSample.sortedSampleCategories

  sortedSampleComponents = AbstractSample.sortedSampleComponents

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  a = property(getA, setA, None,
  r"""Length of Cell axis a in angstrom.
  """)
  
  alpha = property(getAlpha, setAlpha, None,
  r"""Angle between Cell axis b and c in degrees.
  """)

  amountDisplayUnit = Sample.amountDisplayUnit

  amountUnit = Sample.amountUnit

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  b = property(getB, setB, None,
  r"""Length of Cell axis b in angstrom.
  """)

  batchNum = Sample.batchNum
  
  beta = property(getBeta, setBeta, None,
  r"""Angle between Cell axis a and c in degrees.
  """)
  
  c = property(getC, setC, None,
  r"""Length of Cell axis c in angstrom.
  """)

  className = memops.api.Implementation.ComplexDataType.className

  colPosition = Sample.colPosition
  
  colour = property(getColour, setColour, None,
  r"""Description of the colour of the crystal.
  """)

  creationDate = Sample.creationDate
  
  crystalType = property(getCrystalType, setCrystalType, None,
  r"""The type of the crystal.
  """)

  currentAmount = Sample.currentAmount

  currentAmountFlag = Sample.currentAmountFlag

  details = AbstractSample.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  gamma = property(getGamma, setGamma, None,
  r"""Angle between Cell axis a and b in degrees.
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  initialAmount = Sample.initialAmount

  ionicStrength = AbstractSample.ionicStrength

  isActive = AbstractSample.isActive

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isHazard = AbstractSample.isHazard

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  morphology = property(getMorphology, setMorphology, None,
  r"""Description of the shape of the crystal.
  """)

  name = AbstractSample.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  ph = AbstractSample.ph

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  rowPosition = Sample.rowPosition

  solvent = AbstractSample.solvent
  
  spaceGroup = property(getSpaceGroup, setSpaceGroup, None,
  r"""The spacegroup name.
  """)

  subPosition = Sample.subPosition
  
  x = property(getX, setX, None,
  r"""Length of x dimension of crystal in millimeter (mm).
  """)
  
  y = property(getY, setY, None,
  r"""Length of y dimension of crystal in millimeter (mm).
  """)
  
  z = property(getZ, setZ, None,
  r"""Length of z dimension of crystal in millimeter (mm).
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  dropAnnotations = Sample.dropAnnotations

  hazardPhrases = AbstractSample.hazardPhrases

  holder = Sample.holder

  inputSamples = Sample.inputSamples

  localRiskPhrases = AbstractSample.localRiskPhrases

  mixtures = Sample.mixtures

  nmrExperiments = Sample.nmrExperiments

  outputSample = Sample.outputSample

  parent = AbstractSample.parent

  rPhrases = AbstractSample.rPhrases

  refSample = Sample.refSample

  root = memops.api.Implementation.MemopsObject.root

  sPhrases = AbstractSample.sPhrases

  sampleCategories = AbstractSample.sampleCategories

  sampleComponents = AbstractSample.sampleComponents

  sampleStore = AbstractSample.sampleStore

  topObject = memops.api.Implementation.DataObject.topObject
