"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyXmlMapWrite revision 1.29 on Mon Mar  2 17:24:13 2015
  from data model element ccpnmr.Analysis revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Analysis.py: python XML-I/O-mapping for CCPN data model, MetaPackage ccpnmr.Analysis

Copyright (C) 2007 Rasmus Fogh (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Wim F. Vranken, Wayne Boucher, Tim J. Stevens, Rasmus
H. Fogh, Anne Pajon, Miguel Llinas, Eldon L. Ulrich, John L. Markley, John
Ionides and Ernest D. Laue (2005). The CCPN Data Model for NMR Spectroscopy:
Development of a Software Pipeline. Proteins 59, 687 - 696.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""
from memops.general.Constants import baseDataTypeModule as basicDataTypes
# 
#  Current package api
import ccpnmr.api.Analysis

def makeMapping(globalMap):
  """
  generates XML I/O mapping for package ANAL, adding it to globalMap
  """
  
  from memops.xml.Implementation import bool2str, str2bool

  # Set up top level dictionaries
  loadMaps = globalMap.get('loadMaps')
  mapsByGuid = globalMap.get('mapsByGuid')

  abstractTypes = globalMap.get('ANAL').get('abstractTypes')
  exolinks = globalMap.get('ANAL').get('exolinks')

  # DataType AutoLevelMode
  currentMap = {}
  abstractTypes['AutoLevelMode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:12_00002'] = currentMap
  loadMaps['ANAL.AutoLevelMode'] = currentMap
  currentMap['tag'] = 'ANAL.AutoLevelMode'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:12_00002'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType AxisLabel
  currentMap = {}
  abstractTypes['AxisLabel'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00009'] = currentMap
  loadMaps['ANAL.AxisLabel'] = currentMap
  currentMap['tag'] = 'ANAL.AxisLabel'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00009'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType AxisXyLabel
  currentMap = {}
  abstractTypes['AxisXyLabel'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-31-14:10:40_00001'] = currentMap
  loadMaps['ANAL.AxisXyLabel'] = currentMap
  currentMap['tag'] = 'ANAL.AxisXyLabel'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-31-14:10:40_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType MappingType
  currentMap = {}
  abstractTypes['MappingType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00018'] = currentMap
  loadMaps['ANAL.MappingType'] = currentMap
  currentMap['tag'] = 'ANAL.MappingType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00018'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType PeakDrawMethod
  currentMap = {}
  abstractTypes['PeakDrawMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00002'] = currentMap
  loadMaps['ANAL.PeakDrawMethod'] = currentMap
  currentMap['tag'] = 'ANAL.PeakDrawMethod'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00002'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType PeakFindVolumeMethod
  currentMap = {}
  abstractTypes['PeakFindVolumeMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00003'] = currentMap
  loadMaps['ANAL.PeakFindVolumeMethod'] = currentMap
  currentMap['tag'] = 'ANAL.PeakFindVolumeMethod'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType SpectrumFileType
  currentMap = {}
  abstractTypes['SpectrumFileType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00004'] = currentMap
  loadMaps['ANAL.SpectrumFileType'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumFileType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00004'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType SymbolStyle
  currentMap = {}
  abstractTypes['SymbolStyle'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00002'] = currentMap
  loadMaps['ANAL.SymbolStyle'] = currentMap
  currentMap['tag'] = 'ANAL.SymbolStyle'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00002'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # Class AbstractMark
  currentMap = {}
  abstractTypes['AbstractMark'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00016'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00016'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AbstractMark
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AbstractMark.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AbstractMark.dashLength
  currentMap = {}
  contentMap['dashLength'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00010'] = currentMap
  loadMaps['ANAL.AbstractMark.dashLength'] = currentMap
  currentMap['tag'] = 'ANAL.AbstractMark.dashLength'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00010'
  currentMap['name'] = 'dashLength'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AbstractMark.gapLength
  currentMap = {}
  contentMap['gapLength'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00011'] = currentMap
  loadMaps['ANAL.AbstractMark.gapLength'] = currentMap
  currentMap['tag'] = 'ANAL.AbstractMark.gapLength'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00011'
  currentMap['name'] = 'gapLength'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AbstractMark.lineWidth
  currentMap = {}
  contentMap['lineWidth'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00012'] = currentMap
  loadMaps['ANAL.AbstractMark.lineWidth'] = currentMap
  currentMap['tag'] = 'ANAL.AbstractMark.lineWidth'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00012'
  currentMap['name'] = 'lineWidth'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role AbstractMark.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of AbstractMark

  currentMap = abstractTypes.get('AbstractMark')
  aList = ['dashLength', 'gapLength', 'lineWidth']
  currentMap['headerAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AnalysisDataDim
  currentMap = {}
  abstractTypes['AnalysisDataDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00003'] = currentMap
  loadMaps['ANAL.AnalysisDataDim'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00003'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'analysisDataDims'
  currentMap['objkey'] = 'dataDim'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisDataDim
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AnalysisDataDim.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AnalysisDataDim.assignTolerance
  currentMap = {}
  contentMap['assignTolerance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00003'] = currentMap
  loadMaps['ANAL.AnalysisDataDim.assignTolerance'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim.assignTolerance'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00003'
  currentMap['name'] = 'assignTolerance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute AnalysisDataDim.chemShiftWeight
  currentMap = {}
  contentMap['chemShiftWeight'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00007'] = currentMap
  loadMaps['ANAL.AnalysisDataDim.chemShiftWeight'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim.chemShiftWeight'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00007'
  currentMap['name'] = 'chemShiftWeight'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute AnalysisDataDim.noeTolerance
  currentMap = {}
  contentMap['noeTolerance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00004'] = currentMap
  loadMaps['ANAL.AnalysisDataDim.noeTolerance'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim.noeTolerance'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00004'
  currentMap['name'] = 'noeTolerance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute AnalysisDataDim.peakFindBoxWidth
  currentMap = {}
  contentMap['peakFindBoxWidth'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00006'] = currentMap
  loadMaps['ANAL.AnalysisDataDim.peakFindBoxWidth'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim.peakFindBoxWidth'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00006'
  currentMap['name'] = 'peakFindBoxWidth'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute AnalysisDataDim.peakFindMinLineWidth
  currentMap = {}
  contentMap['peakFindMinLineWidth'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00005'] = currentMap
  loadMaps['ANAL.AnalysisDataDim.peakFindMinLineWidth'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim.peakFindMinLineWidth'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00005'
  currentMap['name'] = 'peakFindMinLineWidth'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute AnalysisDataDim.refSamplePlane
  currentMap = {}
  contentMap['refSamplePlane'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00008'] = currentMap
  loadMaps['ANAL.AnalysisDataDim.refSamplePlane'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim.refSamplePlane'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00008'
  currentMap['name'] = 'refSamplePlane'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Role AnalysisDataDim.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AnalysisDataDim.axisMappings
  currentMap = {}
  contentMap['axisMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00002'] = currentMap
  loadMaps['ANAL.AnalysisDataDim.axisMappings'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim.axisMappings'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00002'
  currentMap['name'] = 'axisMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role AnalysisDataDim.dataDim
  currentMap = {}
  contentMap['dataDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:56_00001'] = currentMap
  loadMaps['ANAL.AnalysisDataDim.dataDim'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisDataDim.dataDim'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:56_00001'
  currentMap['name'] = 'dataDim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('NMR').get('exolinks')
  # End of AnalysisDataDim

  currentMap = abstractTypes.get('AnalysisDataDim')
  aList = ['assignTolerance', 'chemShiftWeight', 'noeTolerance', 'peakFindBoxWidth', 'peakFindMinLineWidth', 'refSamplePlane']
  currentMap['headerAttrs'] = aList
  aList = ['axisMappings']
  currentMap['simpleAttrs'] = aList
  aList = ['dataDim', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AnalysisPeakList
  currentMap = {}
  abstractTypes['AnalysisPeakList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00001'] = currentMap
  loadMaps['ANAL.AnalysisPeakList'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'analysisPeakLists'
  currentMap['objkey'] = 'peakList'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisPeakList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AnalysisPeakList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AnalysisPeakList.noeIntensityType
  currentMap = {}
  contentMap['noeIntensityType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00016'] = currentMap
  loadMaps['ANAL.AnalysisPeakList.noeIntensityType'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList.noeIntensityType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00016'
  currentMap['name'] = 'noeIntensityType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['default'] = 'height'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AnalysisPeakList.noeRefDistance
  currentMap = {}
  contentMap['noeRefDistance'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00017'] = currentMap
  loadMaps['ANAL.AnalysisPeakList.noeRefDistance'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList.noeRefDistance'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00017'
  currentMap['name'] = 'noeRefDistance'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 3.2
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisPeakList.noeRefIntensity
  currentMap = {}
  contentMap['noeRefIntensity'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00018'] = currentMap
  loadMaps['ANAL.AnalysisPeakList.noeRefIntensity'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList.noeRefIntensity'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00018'
  currentMap['name'] = 'noeRefIntensity'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisPeakList.symbolColor
  currentMap = {}
  contentMap['symbolColor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00013'] = currentMap
  loadMaps['ANAL.AnalysisPeakList.symbolColor'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList.symbolColor'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00013'
  currentMap['name'] = 'symbolColor'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = '#000000'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007')

  # Attribute AnalysisPeakList.symbolStyle
  currentMap = {}
  contentMap['symbolStyle'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00015'] = currentMap
  loadMaps['ANAL.AnalysisPeakList.symbolStyle'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList.symbolStyle'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00015'
  currentMap['name'] = 'symbolStyle'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'x'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00002')

  # Attribute AnalysisPeakList.textColor
  currentMap = {}
  contentMap['textColor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00014'] = currentMap
  loadMaps['ANAL.AnalysisPeakList.textColor'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList.textColor'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00014'
  currentMap['name'] = 'textColor'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = '#000000'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007')

  # Role AnalysisPeakList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AnalysisPeakList.peakList
  currentMap = {}
  contentMap['peakList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00010'] = currentMap
  loadMaps['ANAL.AnalysisPeakList.peakList'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList.peakList'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00010'
  currentMap['name'] = 'peakList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('NMR').get('exolinks')

  # Role AnalysisPeakList.windowPeakLists
  currentMap = {}
  contentMap['windowPeakLists'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00012'] = currentMap
  loadMaps['ANAL.AnalysisPeakList.windowPeakLists'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPeakList.windowPeakLists'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00012'
  currentMap['name'] = 'windowPeakLists'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of AnalysisPeakList

  currentMap = abstractTypes.get('AnalysisPeakList')
  aList = ['noeIntensityType', 'noeRefDistance', 'noeRefIntensity', 'symbolStyle']
  currentMap['headerAttrs'] = aList
  aList = ['symbolColor', 'textColor', 'windowPeakLists']
  currentMap['simpleAttrs'] = aList
  aList = ['peakList', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AnalysisPopup
  currentMap = {}
  abstractTypes['AnalysisPopup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00001'] = currentMap
  loadMaps['ANAL.AnalysisPopup'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'analysisPopups'
  currentMap['objkey'] = 'name'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisPopup
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AnalysisPopup.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AnalysisPopup.height
  currentMap = {}
  contentMap['height'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00008'] = currentMap
  loadMaps['ANAL.AnalysisPopup.height'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup.height'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00008'
  currentMap['name'] = 'height'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 500
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute AnalysisPopup.isOpen
  currentMap = {}
  contentMap['isOpen'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00009'] = currentMap
  loadMaps['ANAL.AnalysisPopup.isOpen'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup.isOpen'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00009'
  currentMap['name'] = 'isOpen'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisPopup.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00003'] = currentMap
  loadMaps['ANAL.AnalysisPopup.name'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00003'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AnalysisPopup.screenX
  currentMap = {}
  contentMap['screenX'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00005'] = currentMap
  loadMaps['ANAL.AnalysisPopup.screenX'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup.screenX'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00005'
  currentMap['name'] = 'screenX'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AnalysisPopup.screenY
  currentMap = {}
  contentMap['screenY'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00006'] = currentMap
  loadMaps['ANAL.AnalysisPopup.screenY'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup.screenY'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00006'
  currentMap['name'] = 'screenY'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AnalysisPopup.title
  currentMap = {}
  contentMap['title'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00004'] = currentMap
  loadMaps['ANAL.AnalysisPopup.title'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup.title'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00004'
  currentMap['name'] = 'title'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AnalysisPopup.width
  currentMap = {}
  contentMap['width'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00007'] = currentMap
  loadMaps['ANAL.AnalysisPopup.width'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup.width'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00007'
  currentMap['name'] = 'width'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 500
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Role AnalysisPopup.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AnalysisPopup.popupOptions
  currentMap = {}
  contentMap['popupOptions'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00002'] = currentMap
  loadMaps['ANAL.AnalysisPopup.popupOptions'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisPopup.popupOptions'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00002'
  currentMap['name'] = 'popupOptions'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of AnalysisPopup

  currentMap = abstractTypes.get('AnalysisPopup')
  aList = ['height', 'isOpen', 'name', 'screenX', 'screenY', 'width']
  currentMap['headerAttrs'] = aList
  aList = ['title']
  currentMap['simpleAttrs'] = aList
  aList = ['popupOptions', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['popupOptions']
  currentMap['children'] = aList

  # Class AnalysisProject
  currentMap = {}
  abstractTypes['AnalysisProject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00003'] = currentMap
  loadMaps['ANAL.AnalysisProject'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00003'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'analysisProjects'
  currentMap['isTop'] = True
  currentMap['objkey'] = 'name'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisProject
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AnalysisProject.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AnalysisProject.autoBackupFreq
  currentMap = {}
  contentMap['autoBackupFreq'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00013'] = currentMap
  loadMaps['ANAL.AnalysisProject.autoBackupFreq'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.autoBackupFreq'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00013'
  currentMap['name'] = 'autoBackupFreq'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 30
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute AnalysisProject.contourToUnaliased
  currentMap = {}
  contentMap['contourToUnaliased'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:43:02_00008'] = currentMap
  loadMaps['ANAL.AnalysisProject.contourToUnaliased'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.contourToUnaliased'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:43:02_00008'
  currentMap['name'] = 'contourToUnaliased'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.createdBy
  contentMap['createdBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute AnalysisProject.defaultSpectrumFileType
  currentMap = {}
  contentMap['defaultSpectrumFileType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00010'] = currentMap
  loadMaps['ANAL.AnalysisProject.defaultSpectrumFileType'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.defaultSpectrumFileType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00010'
  currentMap['name'] = 'defaultSpectrumFileType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'Azara'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00004')

  # Attribute AnalysisProject.doAssignmentAnnotations
  currentMap = {}
  contentMap['doAssignmentAnnotations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00007'] = currentMap
  loadMaps['ANAL.AnalysisProject.doAssignmentAnnotations'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.doAssignmentAnnotations'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00007'
  currentMap['name'] = 'doAssignmentAnnotations'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.doAutoBackup
  currentMap = {}
  contentMap['doAutoBackup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00012'] = currentMap
  loadMaps['ANAL.AnalysisProject.doAutoBackup'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.doAutoBackup'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00012'
  currentMap['name'] = 'doAutoBackup'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.doChainAnnotations
  currentMap = {}
  contentMap['doChainAnnotations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00009'] = currentMap
  loadMaps['ANAL.AnalysisProject.doChainAnnotations'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.doChainAnnotations'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00009'
  currentMap['name'] = 'doChainAnnotations'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.doDetailAnnotations
  currentMap = {}
  contentMap['doDetailAnnotations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00011'] = currentMap
  loadMaps['ANAL.AnalysisProject.doDetailAnnotations'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.doDetailAnnotations'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00011'
  currentMap['name'] = 'doDetailAnnotations'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.doMeritAnnotations
  currentMap = {}
  contentMap['doMeritAnnotations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00010'] = currentMap
  loadMaps['ANAL.AnalysisProject.doMeritAnnotations'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.doMeritAnnotations'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00010'
  currentMap['name'] = 'doMeritAnnotations'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.doMinimalAnnotations
  currentMap = {}
  contentMap['doMinimalAnnotations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-02-19-14:29:53_00001'] = currentMap
  loadMaps['ANAL.AnalysisProject.doMinimalAnnotations'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.doMinimalAnnotations'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-02-19-14:29:53_00001'
  currentMap['name'] = 'doMinimalAnnotations'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.doMolSysAnnotations
  currentMap = {}
  contentMap['doMolSysAnnotations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00008'] = currentMap
  loadMaps['ANAL.AnalysisProject.doMolSysAnnotations'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.doMolSysAnnotations'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00008'
  currentMap['name'] = 'doMolSysAnnotations'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.doSpinSystemAnnotations
  currentMap = {}
  contentMap['doSpinSystemAnnotations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00006'] = currentMap
  loadMaps['ANAL.AnalysisProject.doSpinSystemAnnotations'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.doSpinSystemAnnotations'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00006'
  currentMap['name'] = 'doSpinSystemAnnotations'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.globalContourScale
  currentMap = {}
  contentMap['globalContourScale'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00002'] = currentMap
  loadMaps['ANAL.AnalysisProject.globalContourScale'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.globalContourScale'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00002'
  currentMap['name'] = 'globalContourScale'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 10000.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisProject.guid
  contentMap['guid'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002')

  # Attribute AnalysisProject.isModifiable
  contentMap['isModifiable'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute AnalysisProject.isThreadingAllowed
  currentMap = {}
  contentMap['isThreadingAllowed'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-02-19-15:50:14_00001'] = currentMap
  loadMaps['ANAL.AnalysisProject.isThreadingAllowed'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.isThreadingAllowed'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-02-19-15:50:14_00001'
  currentMap['name'] = 'isThreadingAllowed'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.lastUnlockedBy
  contentMap['lastUnlockedBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute AnalysisProject.linkPeakListsData
  currentMap = {}
  contentMap['linkPeakListsData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00008'] = currentMap
  loadMaps['ANAL.AnalysisProject.linkPeakListsData'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.linkPeakListsData'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00008'
  currentMap['name'] = 'linkPeakListsData'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute AnalysisProject.linkSeqSpinSystemsData
  currentMap = {}
  contentMap['linkSeqSpinSystemsData'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00009'] = currentMap
  loadMaps['ANAL.AnalysisProject.linkSeqSpinSystemsData'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.linkSeqSpinSystemsData'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00009'
  currentMap['name'] = 'linkSeqSpinSystemsData'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035')

  # Attribute AnalysisProject.maxMarks
  currentMap = {}
  contentMap['maxMarks'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00012'] = currentMap
  loadMaps['ANAL.AnalysisProject.maxMarks'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.maxMarks'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00012'
  currentMap['name'] = 'maxMarks'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute AnalysisProject.maxRulers
  currentMap = {}
  contentMap['maxRulers'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00013'] = currentMap
  loadMaps['ANAL.AnalysisProject.maxRulers'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.maxRulers'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00013'
  currentMap['name'] = 'maxRulers'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute AnalysisProject.meritAnnotationBad
  currentMap = {}
  contentMap['meritAnnotationBad'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00005'] = currentMap
  loadMaps['ANAL.AnalysisProject.meritAnnotationBad'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.meritAnnotationBad'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00005'
  currentMap['name'] = 'meritAnnotationBad'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AnalysisProject.meritAnnotationGood
  currentMap = {}
  contentMap['meritAnnotationGood'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00003'] = currentMap
  loadMaps['ANAL.AnalysisProject.meritAnnotationGood'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.meritAnnotationGood'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00003'
  currentMap['name'] = 'meritAnnotationGood'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AnalysisProject.meritAnnotationMediocre
  currentMap = {}
  contentMap['meritAnnotationMediocre'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00004'] = currentMap
  loadMaps['ANAL.AnalysisProject.meritAnnotationMediocre'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.meritAnnotationMediocre'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00004'
  currentMap['name'] = 'meritAnnotationMediocre'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AnalysisProject.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:15_00011'] = currentMap
  loadMaps['ANAL.AnalysisProject.name'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:15_00011'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AnalysisProject.peakDrawMethod
  currentMap = {}
  contentMap['peakDrawMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00014'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakDrawMethod'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakDrawMethod'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00014'
  currentMap['name'] = 'peakDrawMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = 'uniform in pixels'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00002')

  # Attribute AnalysisProject.peakFindBuffer
  currentMap = {}
  contentMap['peakFindBuffer'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00003'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakFindBuffer'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakFindBuffer'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00003'
  currentMap['name'] = 'peakFindBuffer'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute AnalysisProject.peakFindDrop
  currentMap = {}
  contentMap['peakFindDrop'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00005'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakFindDrop'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakFindDrop'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00005'
  currentMap['name'] = 'peakFindDrop'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Attribute AnalysisProject.peakFindHaveHigh
  currentMap = {}
  contentMap['peakFindHaveHigh'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00007'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakFindHaveHigh'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakFindHaveHigh'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00007'
  currentMap['name'] = 'peakFindHaveHigh'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.peakFindHaveLow
  currentMap = {}
  contentMap['peakFindHaveLow'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00008'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakFindHaveLow'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakFindHaveLow'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00008'
  currentMap['name'] = 'peakFindHaveLow'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.peakFindNonadjacent
  currentMap = {}
  contentMap['peakFindNonadjacent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00006'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakFindNonadjacent'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakFindNonadjacent'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00006'
  currentMap['name'] = 'peakFindNonadjacent'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.peakFindScale
  currentMap = {}
  contentMap['peakFindScale'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00002'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakFindScale'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakFindScale'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00002'
  currentMap['name'] = 'peakFindScale'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisProject.peakFindThickness
  currentMap = {}
  contentMap['peakFindThickness'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00004'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakFindThickness'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakFindThickness'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00004'
  currentMap['name'] = 'peakFindThickness'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute AnalysisProject.peakFindVolumeMethod
  currentMap = {}
  contentMap['peakFindVolumeMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00009'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakFindVolumeMethod'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakFindVolumeMethod'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00009'
  currentMap['name'] = 'peakFindVolumeMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = 'box sum'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00003')

  # Attribute AnalysisProject.peakIntensityScale
  currentMap = {}
  contentMap['peakIntensityScale'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00001'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakIntensityScale'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakIntensityScale'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:15_00001'
  currentMap['name'] = 'peakIntensityScale'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1000000.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisProject.peakPixelSize
  currentMap = {}
  contentMap['peakPixelSize'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00015'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakPixelSize'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakPixelSize'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00015'
  currentMap['name'] = 'peakPixelSize'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 10
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute AnalysisProject.peakVolumeScale
  currentMap = {}
  contentMap['peakVolumeScale'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-03-11:26:05_00001'] = currentMap
  loadMaps['ANAL.AnalysisProject.peakVolumeScale'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.peakVolumeScale'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:05_00001'
  currentMap['name'] = 'peakVolumeScale'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1000000.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisProject.printWinFileName
  currentMap = {}
  contentMap['printWinFileName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00015'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinFileName'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinFileName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00015'
  currentMap['name'] = 'printWinFileName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003')

  # Attribute AnalysisProject.printWinInColor
  currentMap = {}
  contentMap['printWinInColor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00007'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinInColor'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinInColor'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00007'
  currentMap['name'] = 'printWinInColor'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.printWinOrientation
  currentMap = {}
  contentMap['printWinOrientation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00006'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinOrientation'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinOrientation'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00006'
  currentMap['name'] = 'printWinOrientation'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = 'Portrait'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00013')

  # Attribute AnalysisProject.printWinOtherHeight
  currentMap = {}
  contentMap['printWinOtherHeight'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00004'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinOtherHeight'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinOtherHeight'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00004'
  currentMap['name'] = 'printWinOtherHeight'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisProject.printWinOtherUnit
  currentMap = {}
  contentMap['printWinOtherUnit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00005'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinOtherUnit'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinOtherUnit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00005'
  currentMap['name'] = 'printWinOtherUnit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = 'cm'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00011')

  # Attribute AnalysisProject.printWinOtherWidth
  currentMap = {}
  contentMap['printWinOtherWidth'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00003'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinOtherWidth'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinOtherWidth'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00003'
  currentMap['name'] = 'printWinOtherWidth'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisProject.printWinOutputFormat
  currentMap = {}
  contentMap['printWinOutputFormat'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00008'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinOutputFormat'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinOutputFormat'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00008'
  currentMap['name'] = 'printWinOutputFormat'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = 'PS'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00012')

  # Attribute AnalysisProject.printWinPaperSize
  currentMap = {}
  contentMap['printWinPaperSize'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00002'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinPaperSize'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinPaperSize'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00002'
  currentMap['name'] = 'printWinPaperSize'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['proc'] = 'direct'
  currentMap['default'] = 'A4'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00010')

  # Attribute AnalysisProject.printWinScaling
  currentMap = {}
  contentMap['printWinScaling'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00013'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinScaling'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinScaling'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00013'
  currentMap['name'] = 'printWinScaling'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.7
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisProject.printWinShowsDateTime
  currentMap = {}
  contentMap['printWinShowsDateTime'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00011'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinShowsDateTime'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinShowsDateTime'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00011'
  currentMap['name'] = 'printWinShowsDateTime'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.printWinShowsFileName
  currentMap = {}
  contentMap['printWinShowsFileName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00012'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinShowsFileName'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinShowsFileName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00012'
  currentMap['name'] = 'printWinShowsFileName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.printWinTickOutside
  currentMap = {}
  contentMap['printWinTickOutside'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00009'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinTickOutside'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinTickOutside'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00009'
  currentMap['name'] = 'printWinTickOutside'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisProject.printWinTickPlacement
  currentMap = {}
  contentMap['printWinTickPlacement'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00010'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinTickPlacement'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinTickPlacement'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00010'
  currentMap['name'] = 'printWinTickPlacement'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['default'] = 'nsew'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AnalysisProject.printWinTitle
  currentMap = {}
  contentMap['printWinTitle'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00001'] = currentMap
  loadMaps['ANAL.AnalysisProject.printWinTitle'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.printWinTitle'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00001'
  currentMap['name'] = 'printWinTitle'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AnalysisProject.spectrumFont
  currentMap = {}
  contentMap['spectrumFont'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00014'] = currentMap
  loadMaps['ANAL.AnalysisProject.spectrumFont'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.spectrumFont'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00014'
  currentMap['name'] = 'spectrumFont'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AnalysisProject.useBootstrap
  currentMap = {}
  contentMap['useBootstrap'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00001'] = currentMap
  loadMaps['ANAL.AnalysisProject.useBootstrap'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.useBootstrap'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:54:14_00001'
  currentMap['name'] = 'useBootstrap'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Role AnalysisProject.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AnalysisProject.activeWindowGroup
  currentMap = {}
  contentMap['activeWindowGroup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-27-18:43:02_00002'] = currentMap
  loadMaps['ANAL.AnalysisProject.activeWindowGroup'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.activeWindowGroup'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-27-18:43:02_00002'
  currentMap['name'] = 'activeWindowGroup'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['implSkip'] = True
  currentMap['copyOverride'] = True

  # Role AnalysisProject.analysisPopups
  currentMap = {}
  contentMap['analysisPopups'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00011'] = currentMap
  loadMaps['ANAL.AnalysisProject.analysisPopups'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.analysisPopups'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00011'
  currentMap['name'] = 'analysisPopups'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.analysisSpectra
  currentMap = {}
  contentMap['analysisSpectra'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00002'] = currentMap
  loadMaps['ANAL.AnalysisProject.analysisSpectra'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.analysisSpectra'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00002'
  currentMap['name'] = 'analysisSpectra'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.axisRegionGroups
  currentMap = {}
  contentMap['axisRegionGroups'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00015'] = currentMap
  loadMaps['ANAL.AnalysisProject.axisRegionGroups'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.axisRegionGroups'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00015'
  currentMap['name'] = 'axisRegionGroups'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.axisTypes
  currentMap = {}
  contentMap['axisTypes'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00007'] = currentMap
  loadMaps['ANAL.AnalysisProject.axisTypes'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.axisTypes'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00007'
  currentMap['name'] = 'axisTypes'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.axisUnits
  currentMap = {}
  contentMap['axisUnits'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00009'] = currentMap
  loadMaps['ANAL.AnalysisProject.axisUnits'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.axisUnits'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00009'
  currentMap['name'] = 'axisUnits'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.chainMappings
  currentMap = {}
  contentMap['chainMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00013'] = currentMap
  loadMaps['ANAL.AnalysisProject.chainMappings'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.chainMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00013'
  currentMap['name'] = 'chainMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.marks
  currentMap = {}
  contentMap['marks'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00005'] = currentMap
  loadMaps['ANAL.AnalysisProject.marks'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.marks'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00005'
  currentMap['name'] = 'marks'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.nmrProject
  currentMap = {}
  contentMap['nmrProject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-24-15:51:19_00001'] = currentMap
  loadMaps['ANAL.AnalysisProject.nmrProject'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.nmrProject'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-24-15:51:19_00001'
  currentMap['name'] = 'nmrProject'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('NMR').get('exolinks')

  # Role AnalysisProject.panelTypes
  currentMap = {}
  contentMap['panelTypes'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00001'] = currentMap
  loadMaps['ANAL.AnalysisProject.panelTypes'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.panelTypes'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00001'
  currentMap['name'] = 'panelTypes'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.rulers
  currentMap = {}
  contentMap['rulers'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00003'] = currentMap
  loadMaps['ANAL.AnalysisProject.rulers'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.rulers'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:14_00003'
  currentMap['name'] = 'rulers'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.spectrumWindowGroups
  currentMap = {}
  contentMap['spectrumWindowGroups'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:15_00002'] = currentMap
  loadMaps['ANAL.AnalysisProject.spectrumWindowGroups'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.spectrumWindowGroups'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:15_00002'
  currentMap['name'] = 'spectrumWindowGroups'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisProject.spectrumWindows
  currentMap = {}
  contentMap['spectrumWindows'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:15_00004'] = currentMap
  loadMaps['ANAL.AnalysisProject.spectrumWindows'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisProject.spectrumWindows'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:15_00004'
  currentMap['name'] = 'spectrumWindows'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of AnalysisProject

  currentMap = abstractTypes.get('AnalysisProject')
  aList = ['autoBackupFreq', 'contourToUnaliased', 'createdBy', 'defaultSpectrumFileType', 'doAssignmentAnnotations', 'doAutoBackup', 'doChainAnnotations', 'doDetailAnnotations', 'doMeritAnnotations', 'doMinimalAnnotations', 'doMolSysAnnotations', 'doSpinSystemAnnotations', 'globalContourScale', 'guid', 'isModifiable', 'isThreadingAllowed', 'lastUnlockedBy', 'maxMarks', 'maxRulers', 'meritAnnotationBad', 'meritAnnotationGood', 'meritAnnotationMediocre', 'peakFindBuffer', 'peakFindDrop', 'peakFindHaveHigh', 'peakFindHaveLow', 'peakFindNonadjacent', 'peakFindScale', 'peakFindThickness', 'peakIntensityScale', 'peakPixelSize', 'peakVolumeScale', 'printWinInColor', 'printWinOtherHeight', 'printWinOtherWidth', 'printWinScaling', 'printWinShowsDateTime', 'printWinShowsFileName', 'printWinTickOutside', 'printWinTickPlacement', 'useBootstrap']
  currentMap['headerAttrs'] = aList
  aList = ['linkPeakListsData', 'linkSeqSpinSystemsData', 'name', 'peakDrawMethod', 'peakFindVolumeMethod', 'printWinFileName', 'printWinOrientation', 'printWinOtherUnit', 'printWinOutputFormat', 'printWinPaperSize', 'printWinTitle', 'spectrumFont', 'activeWindowGroup']
  currentMap['simpleAttrs'] = aList
  aList = ['spectrumWindows', 'spectrumWindowGroups', 'rulers', 'panelTypes', 'marks', 'chainMappings', 'axisUnits', 'axisTypes', 'axisRegionGroups', 'analysisSpectra', 'analysisPopups', 'nmrProject', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['analysisPopups', 'analysisSpectra', 'axisRegionGroups', 'axisTypes', 'axisUnits', 'chainMappings', 'marks', 'panelTypes', 'rulers', 'spectrumWindowGroups', 'spectrumWindows']
  currentMap['children'] = aList

  # Class AnalysisSpectrum
  currentMap = {}
  abstractTypes['AnalysisSpectrum'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:12_00001'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:12_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'analysisSpectra'
  currentMap['objkey'] = 'dataSource'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisSpectrum
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AnalysisSpectrum.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AnalysisSpectrum.autoBaseLevel
  currentMap = {}
  contentMap['autoBaseLevel'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00017'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.autoBaseLevel'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.autoBaseLevel'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00017'
  currentMap['name'] = 'autoBaseLevel'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute AnalysisSpectrum.autoLevelChanger
  currentMap = {}
  contentMap['autoLevelChanger'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00014'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.autoLevelChanger'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.autoLevelChanger'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00014'
  currentMap['name'] = 'autoLevelChanger'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.5
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute AnalysisSpectrum.autoLevelMode
  currentMap = {}
  contentMap['autoLevelMode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00015'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.autoLevelMode'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.autoLevelMode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00015'
  currentMap['name'] = 'autoLevelMode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'multiply'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-17:24:12_00002')

  # Attribute AnalysisSpectrum.autoNumLevels
  currentMap = {}
  contentMap['autoNumLevels'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00016'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.autoNumLevels'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.autoNumLevels'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00016'
  currentMap['name'] = 'autoNumLevels'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Attribute AnalysisSpectrum.contourDir
  currentMap = {}
  contentMap['contourDir'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00021'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.contourDir'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.contourDir'
  currentMap['type'] = 'dobj'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00021'
  currentMap['name'] = 'contourDir'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('IMPL').get('abstractTypes')

  # Attribute AnalysisSpectrum.font
  currentMap = {}
  contentMap['font'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-27-17:28:44_00002'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.font'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.font'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-27-17:28:44_00002'
  currentMap['name'] = 'font'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute AnalysisSpectrum.multipletPattern
  currentMap = {}
  contentMap['multipletPattern'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00023'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.multipletPattern'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.multipletPattern'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00023'
  currentMap['name'] = 'multipletPattern'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AnalysisSpectrum.negColors
  currentMap = {}
  contentMap['negColors'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-27-17:28:44_00001'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.negColors'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.negColors'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-27-17:28:44_00001'
  currentMap['name'] = 'negColors'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007')

  # Attribute AnalysisSpectrum.negLevels
  currentMap = {}
  contentMap['negLevels'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00013'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.negLevels'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.negLevels'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00013'
  currentMap['name'] = 'negLevels'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-29-14:27:55_00001')

  # Attribute AnalysisSpectrum.posColors
  currentMap = {}
  contentMap['posColors'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-27-16:59:47_00001'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.posColors'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.posColors'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-27-16:59:47_00001'
  currentMap['name'] = 'posColors'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007')

  # Attribute AnalysisSpectrum.posLevels
  currentMap = {}
  contentMap['posLevels'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00012'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.posLevels'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.posLevels'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00012'
  currentMap['name'] = 'posLevels'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute AnalysisSpectrum.rank
  currentMap = {}
  contentMap['rank'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00024'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.rank'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.rank'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00024'
  currentMap['name'] = 'rank'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AnalysisSpectrum.shortcut
  currentMap = {}
  contentMap['shortcut'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00011'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.shortcut'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.shortcut'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00011'
  currentMap['name'] = 'shortcut'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AnalysisSpectrum.sliceColor
  currentMap = {}
  contentMap['sliceColor'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00018'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.sliceColor'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.sliceColor'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00018'
  currentMap['name'] = 'sliceColor'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = '#000080'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007')

  # Attribute AnalysisSpectrum.useBoundingBox
  currentMap = {}
  contentMap['useBoundingBox'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00019'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.useBoundingBox'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.useBoundingBox'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00019'
  currentMap['name'] = 'useBoundingBox'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisSpectrum.usePeakArrow
  currentMap = {}
  contentMap['usePeakArrow'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00020'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.usePeakArrow'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.usePeakArrow'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00020'
  currentMap['name'] = 'usePeakArrow'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AnalysisSpectrum.usePrecalculated
  currentMap = {}
  contentMap['usePrecalculated'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00022'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.usePrecalculated'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.usePrecalculated'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00022'
  currentMap['name'] = 'usePrecalculated'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Role AnalysisSpectrum.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AnalysisSpectrum.analysisDataDims
  currentMap = {}
  contentMap['analysisDataDims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00022'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.analysisDataDims'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.analysisDataDims'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00022'
  currentMap['name'] = 'analysisDataDims'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisSpectrum.analysisPeakLists
  currentMap = {}
  contentMap['analysisPeakLists'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00020'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.analysisPeakLists'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.analysisPeakLists'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00020'
  currentMap['name'] = 'analysisPeakLists'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AnalysisSpectrum.dataSource
  currentMap = {}
  contentMap['dataSource'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00010'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.dataSource'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.dataSource'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00010'
  currentMap['name'] = 'dataSource'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = False
  currentMap['content'] = globalMap.get('NMR').get('exolinks')

  # Role AnalysisSpectrum.spectrumWindowViews
  currentMap = {}
  contentMap['spectrumWindowViews'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00006'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.spectrumWindowViews'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.spectrumWindowViews'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00006'
  currentMap['name'] = 'spectrumWindowViews'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False

  # Role AnalysisSpectrum.storedContours
  currentMap = {}
  contentMap['storedContours'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00008'] = currentMap
  loadMaps['ANAL.AnalysisSpectrum.storedContours'] = currentMap
  currentMap['tag'] = 'ANAL.AnalysisSpectrum.storedContours'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00008'
  currentMap['name'] = 'storedContours'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of AnalysisSpectrum

  currentMap = abstractTypes.get('AnalysisSpectrum')
  aList = ['autoBaseLevel', 'autoLevelChanger', 'autoLevelMode', 'autoNumLevels', 'multipletPattern', 'rank', 'shortcut', 'useBoundingBox', 'usePeakArrow', 'usePrecalculated']
  currentMap['headerAttrs'] = aList
  aList = ['font', 'negColors', 'negLevels', 'posColors', 'posLevels', 'sliceColor', 'spectrumWindowViews']
  currentMap['simpleAttrs'] = aList
  aList = ['storedContours', 'analysisPeakLists', 'analysisDataDims', 'dataSource', 'access', 'contourDir', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['analysisDataDims', 'analysisPeakLists', 'storedContours']
  currentMap['children'] = aList

  # Class AtomSetMapping
  currentMap = {}
  abstractTypes['AtomSetMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00014'] = currentMap
  loadMaps['ANAL.AtomSetMapping'] = currentMap
  currentMap['tag'] = 'ANAL.AtomSetMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00014'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'atomSetMappings'
  currentMap['objkey'] = 'name'
  currentMap['class'] = ccpnmr.api.Analysis.AtomSetMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AtomSetMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AtomSetMapping.atomSetSerials
  currentMap = {}
  contentMap['atomSetSerials'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00001'] = currentMap
  loadMaps['ANAL.AtomSetMapping.atomSetSerials'] = currentMap
  currentMap['tag'] = 'ANAL.AtomSetMapping.atomSetSerials'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00001'
  currentMap['name'] = 'atomSetSerials'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AtomSetMapping.elementSymbol
  currentMap = {}
  contentMap['elementSymbol'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00004'] = currentMap
  loadMaps['ANAL.AtomSetMapping.elementSymbol'] = currentMap
  currentMap['tag'] = 'ANAL.AtomSetMapping.elementSymbol'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00004'
  currentMap['name'] = 'elementSymbol'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AtomSetMapping.mappingType
  currentMap = {}
  contentMap['mappingType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00003'] = currentMap
  loadMaps['ANAL.AtomSetMapping.mappingType'] = currentMap
  currentMap['tag'] = 'ANAL.AtomSetMapping.mappingType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00003'
  currentMap['name'] = 'mappingType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'simple'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00018')

  # Attribute AtomSetMapping.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:05_00003'] = currentMap
  loadMaps['ANAL.AtomSetMapping.name'] = currentMap
  currentMap['tag'] = 'ANAL.AtomSetMapping.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:05_00003'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AtomSetMapping.resonanceSerials
  currentMap = {}
  contentMap['resonanceSerials'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00002'] = currentMap
  loadMaps['ANAL.AtomSetMapping.resonanceSerials'] = currentMap
  currentMap['tag'] = 'ANAL.AtomSetMapping.resonanceSerials'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00002'
  currentMap['name'] = 'resonanceSerials'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AtomSetMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AtomSetMapping.atomSetMappings
  currentMap = {}
  contentMap['atomSetMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:10:57_00001'] = currentMap
  loadMaps['ANAL.AtomSetMapping.atomSetMappings'] = currentMap
  currentMap['tag'] = 'ANAL.AtomSetMapping.atomSetMappings'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:10:57_00001'
  currentMap['name'] = 'atomSetMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role AtomSetMapping.chemAtomSet
  currentMap = {}
  contentMap['chemAtomSet'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:05_00002'] = currentMap
  loadMaps['ANAL.AtomSetMapping.chemAtomSet'] = currentMap
  currentMap['tag'] = 'ANAL.AtomSetMapping.chemAtomSet'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:05_00002'
  currentMap['name'] = 'chemAtomSet'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('CHEM').get('exolinks')
  # End of AtomSetMapping

  currentMap = abstractTypes.get('AtomSetMapping')
  aList = ['elementSymbol', 'mappingType', 'name']
  currentMap['headerAttrs'] = aList
  aList = ['atomSetSerials', 'resonanceSerials', 'atomSetMappings']
  currentMap['simpleAttrs'] = aList
  aList = ['chemAtomSet', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AxisMapping
  currentMap = {}
  abstractTypes['AxisMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00010'] = currentMap
  loadMaps['ANAL.AxisMapping'] = currentMap
  currentMap['tag'] = 'ANAL.AxisMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00010'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'axisMappings'
  currentMap['objkey'] = 'label'
  currentMap['class'] = ccpnmr.api.Analysis.AxisMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AxisMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AxisMapping.label
  currentMap = {}
  contentMap['label'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:28_00011'] = currentMap
  loadMaps['ANAL.AxisMapping.label'] = currentMap
  currentMap['tag'] = 'ANAL.AxisMapping.label'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:28_00011'
  currentMap['name'] = 'label'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00009')

  # Role AxisMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AxisMapping.analysisDataDim
  currentMap = {}
  contentMap['analysisDataDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00001'] = currentMap
  loadMaps['ANAL.AxisMapping.analysisDataDim'] = currentMap
  currentMap['tag'] = 'ANAL.AxisMapping.analysisDataDim'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00001'
  currentMap['name'] = 'analysisDataDim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of AxisMapping

  currentMap = abstractTypes.get('AxisMapping')
  aList = ['label']
  currentMap['headerAttrs'] = aList
  aList = ['analysisDataDim']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AxisRegion
  currentMap = {}
  abstractTypes['AxisRegion'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00006'] = currentMap
  loadMaps['ANAL.AxisRegion'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegion'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00006'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'axisRegions'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.AxisRegion
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AxisRegion.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AxisRegion.isActive
  currentMap = {}
  contentMap['isActive'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00050'] = currentMap
  loadMaps['ANAL.AxisRegion.isActive'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegion.isActive'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00050'
  currentMap['name'] = 'isActive'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AxisRegion.overrideRegion
  currentMap = {}
  contentMap['overrideRegion'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-02-19-14:29:53_00003'] = currentMap
  loadMaps['ANAL.AxisRegion.overrideRegion'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegion.overrideRegion'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-02-19-14:29:53_00003'
  currentMap['name'] = 'overrideRegion'
  currentMap['hicard'] = 2
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute AxisRegion.region
  currentMap = {}
  contentMap['region'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00048'] = currentMap
  loadMaps['ANAL.AxisRegion.region'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegion.region'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00048'
  currentMap['name'] = 'region'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['default'] = [0.0, 1.0]
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute AxisRegion.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00047'] = currentMap
  loadMaps['ANAL.AxisRegion.serial'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegion.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00047'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AxisRegion.size
  currentMap = {}
  contentMap['size'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00049'] = currentMap
  loadMaps['ANAL.AxisRegion.size'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegion.size'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00049'
  currentMap['name'] = 'size'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 500
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AxisRegion.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AxisRegion.axisRegionGroup
  currentMap = {}
  contentMap['axisRegionGroup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00013'] = currentMap
  loadMaps['ANAL.AxisRegion.axisRegionGroup'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegion.axisRegionGroup'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00013'
  currentMap['name'] = 'axisRegionGroup'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of AxisRegion

  currentMap = abstractTypes.get('AxisRegion')
  aList = ['isActive', 'serial', 'size']
  currentMap['headerAttrs'] = aList
  aList = ['overrideRegion', 'region']
  currentMap['simpleAttrs'] = aList
  aList = ['axisRegionGroup']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AxisRegionGroup
  currentMap = {}
  abstractTypes['AxisRegionGroup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00024'] = currentMap
  loadMaps['ANAL.AxisRegionGroup'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegionGroup'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00024'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'axisRegionGroups'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.AxisRegionGroup
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AxisRegionGroup.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AxisRegionGroup.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00017'] = currentMap
  loadMaps['ANAL.AxisRegionGroup.name'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegionGroup.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00017'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AxisRegionGroup.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00016'] = currentMap
  loadMaps['ANAL.AxisRegionGroup.serial'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegionGroup.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00016'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role AxisRegionGroup.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AxisRegionGroup.axisRegions
  currentMap = {}
  contentMap['axisRegions'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00014'] = currentMap
  loadMaps['ANAL.AxisRegionGroup.axisRegions'] = currentMap
  currentMap['tag'] = 'ANAL.AxisRegionGroup.axisRegions'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00014'
  currentMap['name'] = 'axisRegions'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = False
  # End of AxisRegionGroup

  currentMap = abstractTypes.get('AxisRegionGroup')
  aList = ['name', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['axisRegions']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AxisType
  currentMap = {}
  abstractTypes['AxisType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00011'] = currentMap
  loadMaps['ANAL.AxisType'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00011'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'axisTypes'
  currentMap['objkey'] = 'name'
  currentMap['class'] = ccpnmr.api.Analysis.AxisType
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AxisType.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AxisType.diagonalExclusion
  currentMap = {}
  contentMap['diagonalExclusion'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00004'] = currentMap
  loadMaps['ANAL.AxisType.diagonalExclusion'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.diagonalExclusion'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00004'
  currentMap['name'] = 'diagonalExclusion'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute AxisType.isSampled
  currentMap = {}
  contentMap['isSampled'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00007'] = currentMap
  loadMaps['ANAL.AxisType.isSampled'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.isSampled'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00007'
  currentMap['name'] = 'isSampled'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AxisType.isotopeCodes
  currentMap = {}
  contentMap['isotopeCodes'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00005'] = currentMap
  loadMaps['ANAL.AxisType.isotopeCodes'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.isotopeCodes'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00005'
  currentMap['name'] = 'isotopeCodes'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AxisType.measurementType
  currentMap = {}
  contentMap['measurementType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00004'] = currentMap
  loadMaps['ANAL.AxisType.measurementType'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.measurementType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00004'
  currentMap['name'] = 'measurementType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = 'Shift'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:45_00030')

  # Attribute AxisType.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00003'] = currentMap
  loadMaps['ANAL.AxisType.name'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00003'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute AxisType.numDecimals
  currentMap = {}
  contentMap['numDecimals'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00008'] = currentMap
  loadMaps['ANAL.AxisType.numDecimals'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.numDecimals'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00008'
  currentMap['name'] = 'numDecimals'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute AxisType.peakSize
  currentMap = {}
  contentMap['peakSize'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00009'] = currentMap
  loadMaps['ANAL.AxisType.peakSize'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.peakSize'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00009'
  currentMap['name'] = 'peakSize'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute AxisType.region
  currentMap = {}
  contentMap['region'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00006'] = currentMap
  loadMaps['ANAL.AxisType.region'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.region'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00006'
  currentMap['name'] = 'region'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['default'] = [0.0, 1.0]
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role AxisType.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AxisType.axisUnits
  currentMap = {}
  contentMap['axisUnits'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:28_00016'] = currentMap
  loadMaps['ANAL.AxisType.axisUnits'] = currentMap
  currentMap['tag'] = 'ANAL.AxisType.axisUnits'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:28_00016'
  currentMap['name'] = 'axisUnits'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of AxisType

  currentMap = abstractTypes.get('AxisType')
  aList = ['diagonalExclusion', 'isSampled', 'name', 'numDecimals', 'peakSize']
  currentMap['headerAttrs'] = aList
  aList = ['isotopeCodes', 'measurementType', 'region', 'axisUnits']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class AxisUnit
  currentMap = {}
  abstractTypes['AxisUnit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00004'] = currentMap
  loadMaps['ANAL.AxisUnit'] = currentMap
  currentMap['tag'] = 'ANAL.AxisUnit'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00004'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'axisUnits'
  currentMap['objkey'] = 'unit'
  currentMap['class'] = ccpnmr.api.Analysis.AxisUnit
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AxisUnit.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AxisUnit.isBackwards
  currentMap = {}
  contentMap['isBackwards'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00043'] = currentMap
  loadMaps['ANAL.AxisUnit.isBackwards'] = currentMap
  currentMap['tag'] = 'ANAL.AxisUnit.isBackwards'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00043'
  currentMap['name'] = 'isBackwards'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute AxisUnit.unit
  currentMap = {}
  contentMap['unit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00042'] = currentMap
  loadMaps['ANAL.AxisUnit.unit'] = currentMap
  currentMap['tag'] = 'ANAL.AxisUnit.unit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00042'
  currentMap['name'] = 'unit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role AxisUnit.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of AxisUnit

  currentMap = abstractTypes.get('AxisUnit')
  aList = ['isBackwards', 'unit']
  currentMap['headerAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ChainMapping
  currentMap = {}
  abstractTypes['ChainMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00026'] = currentMap
  loadMaps['ANAL.ChainMapping'] = currentMap
  currentMap['tag'] = 'ANAL.ChainMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00026'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chainMappings'
  currentMap['class'] = ccpnmr.api.Analysis.ChainMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ChainMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ChainMapping.chainCode
  currentMap = {}
  contentMap['chainCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00003'] = currentMap
  loadMaps['ANAL.ChainMapping.chainCode'] = currentMap
  currentMap['tag'] = 'ANAL.ChainMapping.chainCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00003'
  currentMap['name'] = 'chainCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute ChainMapping.molSystemCode
  currentMap = {}
  contentMap['molSystemCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00002'] = currentMap
  loadMaps['ANAL.ChainMapping.molSystemCode'] = currentMap
  currentMap['tag'] = 'ANAL.ChainMapping.molSystemCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00002'
  currentMap['name'] = 'molSystemCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role ChainMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ChainMapping.residueMappings
  currentMap = {}
  contentMap['residueMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00021'] = currentMap
  loadMaps['ANAL.ChainMapping.residueMappings'] = currentMap
  currentMap['tag'] = 'ANAL.ChainMapping.residueMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00021'
  currentMap['name'] = 'residueMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of ChainMapping

  currentMap = abstractTypes.get('ChainMapping')
  aList = ['molSystemCode']
  currentMap['headerAttrs'] = aList
  aList = ['chainCode']
  currentMap['simpleAttrs'] = aList
  aList = ['residueMappings', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['residueMappings']
  currentMap['children'] = aList

  # Class MarkDim
  currentMap = {}
  abstractTypes['MarkDim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00017'] = currentMap
  loadMaps['ANAL.MarkDim'] = currentMap
  currentMap['tag'] = 'ANAL.MarkDim'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00017'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'markDims'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.MarkDim
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute MarkDim.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute MarkDim.position
  currentMap = {}
  contentMap['position'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00002'] = currentMap
  loadMaps['ANAL.MarkDim.position'] = currentMap
  currentMap['tag'] = 'ANAL.MarkDim.position'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00002'
  currentMap['name'] = 'position'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute MarkDim.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00001'] = currentMap
  loadMaps['ANAL.MarkDim.serial'] = currentMap
  currentMap['tag'] = 'ANAL.MarkDim.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00001'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role MarkDim.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role MarkDim.axisType
  currentMap = {}
  contentMap['axisType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00013'] = currentMap
  loadMaps['ANAL.MarkDim.axisType'] = currentMap
  currentMap['tag'] = 'ANAL.MarkDim.axisType'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00013'
  currentMap['name'] = 'axisType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of MarkDim

  currentMap = abstractTypes.get('MarkDim')
  aList = ['position', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['axisType']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class PanelType
  currentMap = {}
  abstractTypes['PanelType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00013'] = currentMap
  loadMaps['ANAL.PanelType'] = currentMap
  currentMap['tag'] = 'ANAL.PanelType'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00013'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'panelTypes'
  currentMap['objkey'] = 'name'
  currentMap['class'] = ccpnmr.api.Analysis.PanelType
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PanelType.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PanelType.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:32:45_00007'] = currentMap
  loadMaps['ANAL.PanelType.name'] = currentMap
  currentMap['tag'] = 'ANAL.PanelType.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:32:45_00007'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role PanelType.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role PanelType.axisType
  currentMap = {}
  contentMap['axisType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00001'] = currentMap
  loadMaps['ANAL.PanelType.axisType'] = currentMap
  currentMap['tag'] = 'ANAL.PanelType.axisType'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:31:49_00001'
  currentMap['name'] = 'axisType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of PanelType

  currentMap = abstractTypes.get('PanelType')
  aList = ['name']
  currentMap['headerAttrs'] = aList
  aList = ['axisType']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class PopupOption
  currentMap = {}
  abstractTypes['PopupOption'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00002'] = currentMap
  loadMaps['ANAL.PopupOption'] = currentMap
  currentMap['tag'] = 'ANAL.PopupOption'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'popupOptions'
  currentMap['objkey'] = 'keyword'
  currentMap['class'] = ccpnmr.api.Analysis.PopupOption
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute PopupOption.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute PopupOption.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00017'] = currentMap
  loadMaps['ANAL.PopupOption.details'] = currentMap
  currentMap['tag'] = 'ANAL.PopupOption.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00017'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute PopupOption.keyword
  currentMap = {}
  contentMap['keyword'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00016'] = currentMap
  loadMaps['ANAL.PopupOption.keyword'] = currentMap
  currentMap['tag'] = 'ANAL.PopupOption.keyword'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00016'
  currentMap['name'] = 'keyword'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Role PopupOption.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of PopupOption

  currentMap = abstractTypes.get('PopupOption')
  aList = ['keyword']
  currentMap['headerAttrs'] = aList
  aList = ['details']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class ResidueMapping
  currentMap = {}
  abstractTypes['ResidueMapping'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00001'] = currentMap
  loadMaps['ANAL.ResidueMapping'] = currentMap
  currentMap['tag'] = 'ANAL.ResidueMapping'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'residueMappings'
  currentMap['objkey'] = 'seqId'
  currentMap['class'] = ccpnmr.api.Analysis.ResidueMapping
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ResidueMapping.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ResidueMapping.seqId
  currentMap = {}
  contentMap['seqId'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00009'] = currentMap
  loadMaps['ANAL.ResidueMapping.seqId'] = currentMap
  currentMap['tag'] = 'ANAL.ResidueMapping.seqId'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00009'
  currentMap['name'] = 'seqId'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role ResidueMapping.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role ResidueMapping.atomSetMappings
  currentMap = {}
  contentMap['atomSetMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00007'] = currentMap
  loadMaps['ANAL.ResidueMapping.atomSetMappings'] = currentMap
  currentMap['tag'] = 'ANAL.ResidueMapping.atomSetMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00007'
  currentMap['name'] = 'atomSetMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of ResidueMapping

  currentMap = abstractTypes.get('ResidueMapping')
  aList = ['seqId']
  currentMap['headerAttrs'] = aList
  aList = ['atomSetMappings', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['atomSetMappings']
  currentMap['children'] = aList

  # Class SidePanel
  currentMap = {}
  abstractTypes['SidePanel'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00005'] = currentMap
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00005'
  currentMap['eType'] = 'cplx'
  currentMap['objkey'] = 'label'
  currentMap['class'] = ccpnmr.api.Analysis.SidePanel
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SidePanel.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SidePanel.isVisible
  currentMap = {}
  contentMap['isVisible'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00045'] = currentMap
  loadMaps['ANAL.SidePanel.isVisible'] = currentMap
  currentMap['tag'] = 'ANAL.SidePanel.isVisible'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00045'
  currentMap['name'] = 'isVisible'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SidePanel.label
  currentMap = {}
  contentMap['label'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00044'] = currentMap
  loadMaps['ANAL.SidePanel.label'] = currentMap
  currentMap['tag'] = 'ANAL.SidePanel.label'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00044'
  currentMap['name'] = 'label'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00009')

  # Attribute SidePanel.thickness
  currentMap = {}
  contentMap['thickness'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00046'] = currentMap
  loadMaps['ANAL.SidePanel.thickness'] = currentMap
  currentMap['tag'] = 'ANAL.SidePanel.thickness'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00046'
  currentMap['name'] = 'thickness'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 10
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role SidePanel.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of SidePanel

  currentMap = abstractTypes.get('SidePanel')
  aList = ['isVisible', 'label', 'thickness']
  currentMap['headerAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class SpectrumWindow
  currentMap = {}
  abstractTypes['SpectrumWindow'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00002'] = currentMap
  loadMaps['ANAL.SpectrumWindow'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'spectrumWindows'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.SpectrumWindow
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SpectrumWindow.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SpectrumWindow.isCanvasLabelShown
  currentMap = {}
  contentMap['isCanvasLabelShown'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00002'] = currentMap
  loadMaps['ANAL.SpectrumWindow.isCanvasLabelShown'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.isCanvasLabelShown'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00002'
  currentMap['name'] = 'isCanvasLabelShown'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.isCanvasMidpointShown
  currentMap = {}
  contentMap['isCanvasMidpointShown'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00003'] = currentMap
  loadMaps['ANAL.SpectrumWindow.isCanvasMidpointShown'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.isCanvasMidpointShown'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-09-29-13:48:16_00003'
  currentMap['name'] = 'isCanvasMidpointShown'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.isIconified
  currentMap = {}
  contentMap['isIconified'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00024'] = currentMap
  loadMaps['ANAL.SpectrumWindow.isIconified'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.isIconified'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00024'
  currentMap['name'] = 'isIconified'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.isXSliceDrawn
  currentMap = {}
  contentMap['isXSliceDrawn'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-11-18:00:17_00001'] = currentMap
  loadMaps['ANAL.SpectrumWindow.isXSliceDrawn'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.isXSliceDrawn'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-11-18:00:17_00001'
  currentMap['name'] = 'isXSliceDrawn'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.isXTickShown
  currentMap = {}
  contentMap['isXTickShown'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00026'] = currentMap
  loadMaps['ANAL.SpectrumWindow.isXTickShown'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.isXTickShown'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00026'
  currentMap['name'] = 'isXTickShown'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.isYSliceDrawn
  currentMap = {}
  contentMap['isYSliceDrawn'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-12-11-18:00:20_00001'] = currentMap
  loadMaps['ANAL.SpectrumWindow.isYSliceDrawn'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.isYSliceDrawn'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-12-11-18:00:20_00001'
  currentMap['name'] = 'isYSliceDrawn'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.isYTickShown
  currentMap = {}
  contentMap['isYTickShown'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00027'] = currentMap
  loadMaps['ANAL.SpectrumWindow.isYTickShown'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.isYTickShown'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00027'
  currentMap['name'] = 'isYTickShown'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.isZeroLineShown
  currentMap = {}
  contentMap['isZeroLineShown'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2013-05-03-11:50:01_00001'] = currentMap
  loadMaps['ANAL.SpectrumWindow.isZeroLineShown'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.isZeroLineShown'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2013-05-03-11:50:01_00001'
  currentMap['name'] = 'isZeroLineShown'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.location
  currentMap = {}
  contentMap['location'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00023'] = currentMap
  loadMaps['ANAL.SpectrumWindow.location'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.location'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00023'
  currentMap['name'] = 'location'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['default'] = [0, 0]
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute SpectrumWindow.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00022'] = currentMap
  loadMaps['ANAL.SpectrumWindow.name'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00022'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute SpectrumWindow.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00021'] = currentMap
  loadMaps['ANAL.SpectrumWindow.serial'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00021'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute SpectrumWindow.stripAxis
  currentMap = {}
  contentMap['stripAxis'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-31-14:12:27_00001'] = currentMap
  loadMaps['ANAL.SpectrumWindow.stripAxis'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.stripAxis'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-31-14:12:27_00001'
  currentMap['name'] = 'stripAxis'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'x'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-10-31-14:10:40_00001')

  # Attribute SpectrumWindow.useMultiplePeakLists
  currentMap = {}
  contentMap['useMultiplePeakLists'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-11-23-13:22:08_00001'] = currentMap
  loadMaps['ANAL.SpectrumWindow.useMultiplePeakLists'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.useMultiplePeakLists'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-11-23-13:22:08_00001'
  currentMap['name'] = 'useMultiplePeakLists'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindow.useOverrideRegion
  currentMap = {}
  contentMap['useOverrideRegion'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-02-19-14:31:05_00001'] = currentMap
  loadMaps['ANAL.SpectrumWindow.useOverrideRegion'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.useOverrideRegion'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-02-19-14:31:05_00001'
  currentMap['name'] = 'useOverrideRegion'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Role SpectrumWindow.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SpectrumWindow.spectrumWindowGroups
  currentMap = {}
  contentMap['spectrumWindowGroups'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00020'] = currentMap
  loadMaps['ANAL.SpectrumWindow.spectrumWindowGroups'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.spectrumWindowGroups'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00020'
  currentMap['name'] = 'spectrumWindowGroups'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role SpectrumWindow.spectrumWindowPanes
  currentMap = {}
  contentMap['spectrumWindowPanes'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00002'] = currentMap
  loadMaps['ANAL.SpectrumWindow.spectrumWindowPanes'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindow.spectrumWindowPanes'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00002'
  currentMap['name'] = 'spectrumWindowPanes'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of SpectrumWindow

  currentMap = abstractTypes.get('SpectrumWindow')
  aList = ['isCanvasLabelShown', 'isCanvasMidpointShown', 'isIconified', 'isXSliceDrawn', 'isXTickShown', 'isYSliceDrawn', 'isYTickShown', 'isZeroLineShown', 'serial', 'stripAxis', 'useMultiplePeakLists', 'useOverrideRegion']
  currentMap['headerAttrs'] = aList
  aList = ['location', 'name', 'spectrumWindowGroups']
  currentMap['simpleAttrs'] = aList
  aList = ['spectrumWindowPanes', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['spectrumWindowPanes']
  currentMap['children'] = aList

  # Class SpectrumWindowGroup
  currentMap = {}
  abstractTypes['SpectrumWindowGroup'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00023'] = currentMap
  loadMaps['ANAL.SpectrumWindowGroup'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowGroup'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00023'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'spectrumWindowGroups'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.SpectrumWindowGroup
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SpectrumWindowGroup.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SpectrumWindowGroup.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00012'] = currentMap
  loadMaps['ANAL.SpectrumWindowGroup.name'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowGroup.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00012'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute SpectrumWindowGroup.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00011'] = currentMap
  loadMaps['ANAL.SpectrumWindowGroup.serial'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowGroup.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00011'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role SpectrumWindowGroup.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SpectrumWindowGroup.spectrumWindows
  currentMap = {}
  contentMap['spectrumWindows'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00019'] = currentMap
  loadMaps['ANAL.SpectrumWindowGroup.spectrumWindows'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowGroup.spectrumWindows'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00019'
  currentMap['name'] = 'spectrumWindows'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of SpectrumWindowGroup

  currentMap = abstractTypes.get('SpectrumWindowGroup')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['name', 'spectrumWindows']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class SpectrumWindowPane
  currentMap = {}
  abstractTypes['SpectrumWindowPane'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-09-24-15:20:49_00001'] = currentMap
  loadMaps['ANAL.SpectrumWindowPane'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowPane'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-24-15:20:49_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'spectrumWindowPanes'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.SpectrumWindowPane
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SpectrumWindowPane.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SpectrumWindowPane.aspectRatio
  currentMap = {}
  contentMap['aspectRatio'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00025'] = currentMap
  loadMaps['ANAL.SpectrumWindowPane.aspectRatio'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowPane.aspectRatio'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00025'
  currentMap['name'] = 'aspectRatio'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute SpectrumWindowPane.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00010'] = currentMap
  loadMaps['ANAL.SpectrumWindowPane.name'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowPane.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00010'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute SpectrumWindowPane.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00009'] = currentMap
  loadMaps['ANAL.SpectrumWindowPane.serial'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowPane.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00009'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute SpectrumWindowPane.sliceRange
  currentMap = {}
  contentMap['sliceRange'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00028'] = currentMap
  loadMaps['ANAL.SpectrumWindowPane.sliceRange'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowPane.sliceRange'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00028'
  currentMap['name'] = 'sliceRange'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['default'] = [-100000.0, 100000.0]
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role SpectrumWindowPane.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SpectrumWindowPane.axisPanels
  currentMap = {}
  contentMap['axisPanels'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00008'] = currentMap
  loadMaps['ANAL.SpectrumWindowPane.axisPanels'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowPane.axisPanels'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00008'
  currentMap['name'] = 'axisPanels'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role SpectrumWindowPane.slicePanels
  currentMap = {}
  contentMap['slicePanels'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00006'] = currentMap
  loadMaps['ANAL.SpectrumWindowPane.slicePanels'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowPane.slicePanels'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00006'
  currentMap['name'] = 'slicePanels'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role SpectrumWindowPane.spectrumWindowViews
  currentMap = {}
  contentMap['spectrumWindowViews'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00004'] = currentMap
  loadMaps['ANAL.SpectrumWindowPane.spectrumWindowViews'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowPane.spectrumWindowViews'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-24-15:20:52_00004'
  currentMap['name'] = 'spectrumWindowViews'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of SpectrumWindowPane

  currentMap = abstractTypes.get('SpectrumWindowPane')
  aList = ['aspectRatio', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['name', 'sliceRange']
  currentMap['simpleAttrs'] = aList
  aList = ['spectrumWindowViews', 'slicePanels', 'axisPanels', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['axisPanels', 'slicePanels', 'spectrumWindowViews']
  currentMap['children'] = aList

  # Class SpectrumWindowView
  currentMap = {}
  abstractTypes['SpectrumWindowView'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00003'] = currentMap
  loadMaps['ANAL.SpectrumWindowView'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00003'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'spectrumWindowViews'
  currentMap['objkey'] = 'analysisSpectrum'
  currentMap['class'] = ccpnmr.api.Analysis.SpectrumWindowView
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SpectrumWindowView.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SpectrumWindowView.isContourLineVisible
  currentMap = {}
  contentMap['isContourLineVisible'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2013-05-07-17:07:06_00001'] = currentMap
  loadMaps['ANAL.SpectrumWindowView.isContourLineVisible'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView.isContourLineVisible'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2013-05-07-17:07:06_00001'
  currentMap['name'] = 'isContourLineVisible'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindowView.isInToolbar
  currentMap = {}
  contentMap['isInToolbar'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00039'] = currentMap
  loadMaps['ANAL.SpectrumWindowView.isInToolbar'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView.isInToolbar'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00039'
  currentMap['name'] = 'isInToolbar'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindowView.isNegVisible
  currentMap = {}
  contentMap['isNegVisible'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00035'] = currentMap
  loadMaps['ANAL.SpectrumWindowView.isNegVisible'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView.isNegVisible'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00035'
  currentMap['name'] = 'isNegVisible'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindowView.isPosVisible
  currentMap = {}
  contentMap['isPosVisible'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00034'] = currentMap
  loadMaps['ANAL.SpectrumWindowView.isPosVisible'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView.isPosVisible'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00034'
  currentMap['name'] = 'isPosVisible'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute SpectrumWindowView.isSliceVisible
  currentMap = {}
  contentMap['isSliceVisible'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00038'] = currentMap
  loadMaps['ANAL.SpectrumWindowView.isSliceVisible'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView.isSliceVisible'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00038'
  currentMap['name'] = 'isSliceVisible'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Role SpectrumWindowView.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role SpectrumWindowView.analysisSpectrum
  currentMap = {}
  contentMap['analysisSpectrum'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00005'] = currentMap
  loadMaps['ANAL.SpectrumWindowView.analysisSpectrum'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView.analysisSpectrum'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:14_00005'
  currentMap['name'] = 'analysisSpectrum'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True

  # Role SpectrumWindowView.axisMappings
  currentMap = {}
  contentMap['axisMappings'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00031'] = currentMap
  loadMaps['ANAL.SpectrumWindowView.axisMappings'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView.axisMappings'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00031'
  currentMap['name'] = 'axisMappings'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role SpectrumWindowView.windowPeakLists
  currentMap = {}
  contentMap['windowPeakLists'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00033'] = currentMap
  loadMaps['ANAL.SpectrumWindowView.windowPeakLists'] = currentMap
  currentMap['tag'] = 'ANAL.SpectrumWindowView.windowPeakLists'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00033'
  currentMap['name'] = 'windowPeakLists'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of SpectrumWindowView

  currentMap = abstractTypes.get('SpectrumWindowView')
  aList = ['isContourLineVisible', 'isInToolbar', 'isNegVisible', 'isPosVisible', 'isSliceVisible']
  currentMap['headerAttrs'] = aList
  aList = ['analysisSpectrum']
  currentMap['optLinks'] = aList
  aList = ['windowPeakLists', 'axisMappings', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['axisMappings', 'windowPeakLists']
  currentMap['children'] = aList

  # Class StoredContour
  currentMap = {}
  abstractTypes['StoredContour'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00002'] = currentMap
  loadMaps['ANAL.StoredContour'] = currentMap
  currentMap['tag'] = 'ANAL.StoredContour'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'storedContours'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.StoredContour
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute StoredContour.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute StoredContour.dims
  currentMap = {}
  contentMap['dims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00013'] = currentMap
  loadMaps['ANAL.StoredContour.dims'] = currentMap
  currentMap['tag'] = 'ANAL.StoredContour.dims'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00013'
  currentMap['name'] = 'dims'
  currentMap['hicard'] = 2
  currentMap['locard'] = 2
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute StoredContour.path
  currentMap = {}
  contentMap['path'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00014'] = currentMap
  loadMaps['ANAL.StoredContour.path'] = currentMap
  currentMap['tag'] = 'ANAL.StoredContour.path'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00014'
  currentMap['name'] = 'path'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003')

  # Attribute StoredContour.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00012'] = currentMap
  loadMaps['ANAL.StoredContour.serial'] = currentMap
  currentMap['tag'] = 'ANAL.StoredContour.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:13_00012'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role StoredContour.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of StoredContour

  currentMap = abstractTypes.get('StoredContour')
  aList = ['serial']
  currentMap['headerAttrs'] = aList
  aList = ['dims', 'path']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class WindowPeakList
  currentMap = {}
  abstractTypes['WindowPeakList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00012'] = currentMap
  loadMaps['ANAL.WindowPeakList'] = currentMap
  currentMap['tag'] = 'ANAL.WindowPeakList'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00012'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'windowPeakLists'
  currentMap['objkey'] = 'analysisPeakList'
  currentMap['class'] = ccpnmr.api.Analysis.WindowPeakList
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute WindowPeakList.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute WindowPeakList.isAnnotationDrawn
  currentMap = {}
  contentMap['isAnnotationDrawn'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:32:45_00003'] = currentMap
  loadMaps['ANAL.WindowPeakList.isAnnotationDrawn'] = currentMap
  currentMap['tag'] = 'ANAL.WindowPeakList.isAnnotationDrawn'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:32:45_00003'
  currentMap['name'] = 'isAnnotationDrawn'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute WindowPeakList.isSymbolDrawn
  currentMap = {}
  contentMap['isSymbolDrawn'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:32:45_00002'] = currentMap
  loadMaps['ANAL.WindowPeakList.isSymbolDrawn'] = currentMap
  currentMap['tag'] = 'ANAL.WindowPeakList.isSymbolDrawn'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:32:45_00002'
  currentMap['name'] = 'isSymbolDrawn'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Role WindowPeakList.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role WindowPeakList.analysisPeakList
  currentMap = {}
  contentMap['analysisPeakList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00011'] = currentMap
  loadMaps['ANAL.WindowPeakList.analysisPeakList'] = currentMap
  currentMap['tag'] = 'ANAL.WindowPeakList.analysisPeakList'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:55_00011'
  currentMap['name'] = 'analysisPeakList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of WindowPeakList

  currentMap = abstractTypes.get('WindowPeakList')
  aList = ['isAnnotationDrawn', 'isSymbolDrawn']
  currentMap['headerAttrs'] = aList
  aList = ['analysisPeakList']
  currentMap['optLinks'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Ruler
  currentMap = {}
  abstractTypes['Ruler'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00020'] = currentMap
  loadMaps['ANAL.Ruler'] = currentMap
  currentMap['tag'] = 'ANAL.Ruler'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00020'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'rulers'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.Ruler
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Ruler.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Ruler.color
  currentMap = {}
  contentMap['color'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00018'] = currentMap
  loadMaps['ANAL.Ruler.color'] = currentMap
  currentMap['tag'] = 'ANAL.Ruler.color'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00018'
  currentMap['name'] = 'color'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = '#808080'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007')

  # Attribute Ruler.dashLength
  contentMap['dashLength'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00010')

  # Attribute Ruler.gapLength
  contentMap['gapLength'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00011')

  # Attribute Ruler.lineWidth
  contentMap['lineWidth'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00012')

  # Attribute Ruler.position
  currentMap = {}
  contentMap['position'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00008'] = currentMap
  loadMaps['ANAL.Ruler.position'] = currentMap
  currentMap['tag'] = 'ANAL.Ruler.position'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00008'
  currentMap['name'] = 'position'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Ruler.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00007'] = currentMap
  loadMaps['ANAL.Ruler.serial'] = currentMap
  currentMap['tag'] = 'ANAL.Ruler.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00007'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role Ruler.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Ruler.panelType
  currentMap = {}
  contentMap['panelType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00006'] = currentMap
  loadMaps['ANAL.Ruler.panelType'] = currentMap
  currentMap['tag'] = 'ANAL.Ruler.panelType'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00006'
  currentMap['name'] = 'panelType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['copyOverride'] = True
  # End of Ruler

  currentMap = abstractTypes.get('Ruler')
  aList = ['dashLength', 'gapLength', 'lineWidth', 'position', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['color', 'panelType']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Mark
  currentMap = {}
  abstractTypes['Mark'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00019'] = currentMap
  loadMaps['ANAL.Mark'] = currentMap
  currentMap['tag'] = 'ANAL.Mark'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00019'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'marks'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = ccpnmr.api.Analysis.Mark
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Mark.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Mark.color
  currentMap = {}
  contentMap['color'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00015'] = currentMap
  loadMaps['ANAL.Mark.color'] = currentMap
  currentMap['tag'] = 'ANAL.Mark.color'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00015'
  currentMap['name'] = 'color'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = '#808080'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007')

  # Attribute Mark.dashLength
  contentMap['dashLength'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00010')

  # Attribute Mark.gapLength
  contentMap['gapLength'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00011')

  # Attribute Mark.lineWidth
  contentMap['lineWidth'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-15:11:06_00012')

  # Attribute Mark.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00005'] = currentMap
  loadMaps['ANAL.Mark.serial'] = currentMap
  currentMap['tag'] = 'ANAL.Mark.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00005'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Role Mark.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Mark.markDims
  currentMap = {}
  contentMap['markDims'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00004'] = currentMap
  loadMaps['ANAL.Mark.markDims'] = currentMap
  currentMap['tag'] = 'ANAL.Mark.markDims'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:08_00004'
  currentMap['name'] = 'markDims'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')
  # End of Mark

  currentMap = abstractTypes.get('Mark')
  aList = ['dashLength', 'gapLength', 'lineWidth', 'serial']
  currentMap['headerAttrs'] = aList
  aList = ['color']
  currentMap['simpleAttrs'] = aList
  aList = ['markDims', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['markDims']
  currentMap['children'] = aList

  # Class AxisPanel
  currentMap = {}
  abstractTypes['AxisPanel'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00007'] = currentMap
  loadMaps['ANAL.AxisPanel'] = currentMap
  currentMap['tag'] = 'ANAL.AxisPanel'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00007'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'axisPanels'
  currentMap['objkey'] = 'label'
  currentMap['class'] = ccpnmr.api.Analysis.AxisPanel
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute AxisPanel.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute AxisPanel.isVisible
  contentMap['isVisible'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00045')

  # Attribute AxisPanel.label
  contentMap['label'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00044')

  # Attribute AxisPanel.thickness
  contentMap['thickness'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00046')

  # Role AxisPanel.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role AxisPanel.axisRegions
  currentMap = {}
  contentMap['axisRegions'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:28_00003'] = currentMap
  loadMaps['ANAL.AxisPanel.axisRegions'] = currentMap
  currentMap['tag'] = 'ANAL.AxisPanel.axisRegions'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:28_00003'
  currentMap['name'] = 'axisRegions'
  currentMap['hicard'] = -1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('ANAL').get('abstractTypes')

  # Role AxisPanel.axisUnit
  currentMap = {}
  contentMap['axisUnit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00051'] = currentMap
  loadMaps['ANAL.AxisPanel.axisUnit'] = currentMap
  currentMap['tag'] = 'ANAL.AxisPanel.axisUnit'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00051'
  currentMap['name'] = 'axisUnit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True

  # Role AxisPanel.panelType
  currentMap = {}
  contentMap['panelType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00054'] = currentMap
  loadMaps['ANAL.AxisPanel.panelType'] = currentMap
  currentMap['tag'] = 'ANAL.AxisPanel.panelType'
  currentMap['type'] = 'link'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00054'
  currentMap['name'] = 'panelType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['copyOverride'] = True
  # End of AxisPanel

  currentMap = abstractTypes.get('AxisPanel')
  aList = ['isVisible', 'label', 'thickness']
  currentMap['headerAttrs'] = aList
  aList = ['axisUnit', 'panelType']
  currentMap['simpleAttrs'] = aList
  aList = ['axisRegions', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['axisRegions']
  currentMap['children'] = aList

  # Class SlicePanel
  currentMap = {}
  abstractTypes['SlicePanel'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00008'] = currentMap
  loadMaps['ANAL.SlicePanel'] = currentMap
  currentMap['tag'] = 'ANAL.SlicePanel'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00008'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'slicePanels'
  currentMap['objkey'] = 'label'
  currentMap['class'] = ccpnmr.api.Analysis.SlicePanel
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute SlicePanel.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute SlicePanel.isVisible
  contentMap['isVisible'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00045')

  # Attribute SlicePanel.label
  contentMap['label'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00044')

  # Attribute SlicePanel.thickness
  contentMap['thickness'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:27_00046')

  # Role SlicePanel.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of SlicePanel

  currentMap = abstractTypes.get('SlicePanel')
  aList = ['isVisible', 'label', 'thickness']
  currentMap['headerAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Out-of-package link to AnalysisDataDim
  currentMap = {}
  exolinks['AnalysisDataDim'] = currentMap
  loadMaps['ANAL.exo-AnalysisDataDim'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AnalysisDataDim'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00003'
  currentMap['name'] = 'AnalysisDataDim'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisDataDim
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(globalMap.get('NMR').get('exolinks'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to AnalysisPeakList
  currentMap = {}
  exolinks['AnalysisPeakList'] = currentMap
  loadMaps['ANAL.exo-AnalysisPeakList'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AnalysisPeakList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-18:37:53_00001'
  currentMap['name'] = 'AnalysisPeakList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisPeakList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(globalMap.get('NMR').get('exolinks'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to AnalysisPopup
  currentMap = {}
  exolinks['AnalysisPopup'] = currentMap
  loadMaps['ANAL.exo-AnalysisPopup'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AnalysisPopup'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00001'
  currentMap['name'] = 'AnalysisPopup'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisPopup
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to AnalysisProject
  currentMap = {}
  exolinks['AnalysisProject'] = currentMap
  loadMaps['ANAL.exo-AnalysisProject'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AnalysisProject'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00003'
  currentMap['name'] = 'AnalysisProject'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisProject
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))

  # Out-of-package link to AnalysisSpectrum
  currentMap = {}
  exolinks['AnalysisSpectrum'] = currentMap
  loadMaps['ANAL.exo-AnalysisSpectrum'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AnalysisSpectrum'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-17:24:12_00001'
  currentMap['name'] = 'AnalysisSpectrum'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AnalysisSpectrum
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(globalMap.get('NMR').get('exolinks'))

  # Out-of-package link to AtomSetMapping
  currentMap = {}
  exolinks['AtomSetMapping'] = currentMap
  loadMaps['ANAL.exo-AtomSetMapping'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AtomSetMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00014'
  currentMap['name'] = 'AtomSetMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AtomSetMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to AxisMapping
  currentMap = {}
  exolinks['AxisMapping'] = currentMap
  loadMaps['ANAL.exo-AxisMapping'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AxisMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00010'
  currentMap['name'] = 'AxisMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AxisMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('ANAL').get('exolinks'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00009'))

  # Out-of-package link to AxisRegion
  currentMap = {}
  exolinks['AxisRegion'] = currentMap
  loadMaps['ANAL.exo-AxisRegion'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AxisRegion'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00006'
  currentMap['name'] = 'AxisRegion'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AxisRegion
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00009'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to AxisRegionGroup
  currentMap = {}
  exolinks['AxisRegionGroup'] = currentMap
  loadMaps['ANAL.exo-AxisRegionGroup'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AxisRegionGroup'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00024'
  currentMap['name'] = 'AxisRegionGroup'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AxisRegionGroup
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to AxisType
  currentMap = {}
  exolinks['AxisType'] = currentMap
  loadMaps['ANAL.exo-AxisType'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AxisType'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00011'
  currentMap['name'] = 'AxisType'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AxisType
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to AxisUnit
  currentMap = {}
  exolinks['AxisUnit'] = currentMap
  loadMaps['ANAL.exo-AxisUnit'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AxisUnit'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00004'
  currentMap['name'] = 'AxisUnit'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AxisUnit
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to ChainMapping
  currentMap = {}
  exolinks['ChainMapping'] = currentMap
  loadMaps['ANAL.exo-ChainMapping'] = currentMap
  currentMap['tag'] = 'ANAL.exo-ChainMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00026'
  currentMap['name'] = 'ChainMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.ChainMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'))

  # Out-of-package link to MarkDim
  currentMap = {}
  exolinks['MarkDim'] = currentMap
  loadMaps['ANAL.exo-MarkDim'] = currentMap
  currentMap['tag'] = 'ANAL.exo-MarkDim'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00017'
  currentMap['name'] = 'MarkDim'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.MarkDim
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to PanelType
  currentMap = {}
  exolinks['PanelType'] = currentMap
  loadMaps['ANAL.exo-PanelType'] = currentMap
  currentMap['tag'] = 'ANAL.exo-PanelType'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00013'
  currentMap['name'] = 'PanelType'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.PanelType
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to PopupOption
  currentMap = {}
  exolinks['PopupOption'] = currentMap
  loadMaps['ANAL.exo-PopupOption'] = currentMap
  currentMap['tag'] = 'ANAL.exo-PopupOption'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00002'
  currentMap['name'] = 'PopupOption'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.PopupOption
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to ResidueMapping
  currentMap = {}
  exolinks['ResidueMapping'] = currentMap
  loadMaps['ANAL.exo-ResidueMapping'] = currentMap
  currentMap['tag'] = 'ANAL.exo-ResidueMapping'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00001'
  currentMap['name'] = 'ResidueMapping'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.ResidueMapping
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SpectrumWindow
  currentMap = {}
  exolinks['SpectrumWindow'] = currentMap
  loadMaps['ANAL.exo-SpectrumWindow'] = currentMap
  currentMap['tag'] = 'ANAL.exo-SpectrumWindow'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00002'
  currentMap['name'] = 'SpectrumWindow'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.SpectrumWindow
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SpectrumWindowGroup
  currentMap = {}
  exolinks['SpectrumWindowGroup'] = currentMap
  loadMaps['ANAL.exo-SpectrumWindowGroup'] = currentMap
  currentMap['tag'] = 'ANAL.exo-SpectrumWindowGroup'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00023'
  currentMap['name'] = 'SpectrumWindowGroup'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.SpectrumWindowGroup
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SpectrumWindowPane
  currentMap = {}
  exolinks['SpectrumWindowPane'] = currentMap
  loadMaps['ANAL.exo-SpectrumWindowPane'] = currentMap
  currentMap['tag'] = 'ANAL.exo-SpectrumWindowPane'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-09-24-15:20:49_00001'
  currentMap['name'] = 'SpectrumWindowPane'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.SpectrumWindowPane
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to SpectrumWindowView
  currentMap = {}
  exolinks['SpectrumWindowView'] = currentMap
  loadMaps['ANAL.exo-SpectrumWindowView'] = currentMap
  currentMap['tag'] = 'ANAL.exo-SpectrumWindowView'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00003'
  currentMap['name'] = 'SpectrumWindowView'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.SpectrumWindowView
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('ANAL').get('exolinks'))

  # Out-of-package link to StoredContour
  currentMap = {}
  exolinks['StoredContour'] = currentMap
  loadMaps['ANAL.exo-StoredContour'] = currentMap
  currentMap['tag'] = 'ANAL.exo-StoredContour'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:23_00002'
  currentMap['name'] = 'StoredContour'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.StoredContour
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(globalMap.get('NMR').get('exolinks'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to WindowPeakList
  currentMap = {}
  exolinks['WindowPeakList'] = currentMap
  loadMaps['ANAL.exo-WindowPeakList'] = currentMap
  currentMap['tag'] = 'ANAL.exo-WindowPeakList'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00012'
  currentMap['name'] = 'WindowPeakList'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.WindowPeakList
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(globalMap.get('ANAL').get('exolinks'))
  aList.append(globalMap.get('ANAL').get('exolinks'))

  # Out-of-package link to Ruler
  currentMap = {}
  exolinks['Ruler'] = currentMap
  loadMaps['ANAL.exo-Ruler'] = currentMap
  currentMap['tag'] = 'ANAL.exo-Ruler'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00020'
  currentMap['name'] = 'Ruler'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.Ruler
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to Mark
  currentMap = {}
  exolinks['Mark'] = currentMap
  loadMaps['ANAL.exo-Mark'] = currentMap
  currentMap['tag'] = 'ANAL.exo-Mark'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00019'
  currentMap['name'] = 'Mark'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.Mark
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to AxisPanel
  currentMap = {}
  exolinks['AxisPanel'] = currentMap
  loadMaps['ANAL.exo-AxisPanel'] = currentMap
  currentMap['tag'] = 'ANAL.exo-AxisPanel'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00007'
  currentMap['name'] = 'AxisPanel'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.AxisPanel
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00009'))

  # Out-of-package link to SlicePanel
  currentMap = {}
  exolinks['SlicePanel'] = currentMap
  loadMaps['ANAL.exo-SlicePanel'] = currentMap
  currentMap['tag'] = 'ANAL.exo-SlicePanel'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00008'
  currentMap['name'] = 'SlicePanel'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = ccpnmr.api.Analysis.SlicePanel
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:22_00009'))
