from cing.core.database import MolDef
from cing.Libs.AwkLike import AwkLike #@UnusedImport
from cing.Libs.AwkLike import AwkLikeS
from cing.Libs.NTutils import * #@UnusedWildImport

cyanaLib = """
# RESIDUE resName Number_of_dihedral_defs number_of_atom_defs start_atom_of_residue stop_atom_of_residue
# gv: connected pseudo's of Protein residues to carbon, but not carbon to pseudo as this is done indirectly
# inserted one-letter code into residue field
RESIDUE   ALA  A    4   14    3   13
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   12    0
   3 CHI1     1    3    1.3500    3    5    8    9   11
   4 PSI      0    0    0.0000    3    5   12   14    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    8   12    0
   6 HA   H_ALI    0    0.3677    1.7849   -0.4925    0.9140    5    0    0    0    0
   7 QB   PSEUD    0    0.0000    2.0850   -0.9858   -1.4878    8    0    0    0    0
   8 CB   C_ALI    3   -1.6546    1.9637   -0.7966   -1.2023    5    9   10   11    0
   9 HB1  H_ALI    0    0.7354    3.0537   -0.7963   -1.2019    8    0    0    0    7
  10 HB2  H_ALI    0    0.7354    1.6006   -1.8224   -1.1392    8    0    0    0    7
  11 HB3  H_ALI    0    0.7354    1.6006   -0.3386   -2.1223    8    0    0    0    7
  12 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   13   14    0    0
  13 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   12    0    0    0    0
  14 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   12    0    0    0    0
RESIDUE   ARG  R    7   30    3   29
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   28    0
   3 CHI1     1    3    1.3500    3    5    7   11   27
   4 CHI2     1    3    1.3500    5    7   11   15   27
   5 CHI3     1    3    1.3500    7   11   15   19   27
   6 CHI4     0    0    0.0000   11   15   19   21   27
   7 PSI      0    0    0.0000    3    5   28   30    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   28    0
   6 HA   H_ALI    0    0.3677    1.7317   -0.5213    0.9158    5    0    0    0    0
   7 CB   C_ALI    3   -0.5515    2.0038   -0.7402   -1.2205    5    8    9   11    0
   8 HB2  H_ALI    0    0.2687    1.6375   -1.7668   -1.2235    7    0    0    0   10
   9 HB3  H_ALI    0    0.2687    1.6375   -0.2685   -2.1323    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6375   -1.0177   -1.6779    7    0    0    0    0
  11 CG   C_ALI    3   -0.5515    3.5338   -0.7388   -1.2182    7   12   13   15    0
  12 HG2  H_ALI    0    0.5515    3.9001    0.2878   -1.2152   11    0    0    0   14
  13 HG3  H_ALI    0    0.5515    3.9001   -1.2106   -0.3064   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    3.9001   -0.4614   -0.7608   11    0    0    0    0
  15 CD   C_ALI    3    1.8243    4.0846   -1.4791   -2.4387   11   16   17   19    0
  16 HD2  H_ALI    0    0.1838    3.7230   -2.5073   -2.4444   15    0    0    0   18
  17 HD3  H_ALI    0    0.1838    3.7230   -1.0090   -3.3532   15    0    0    0   18
  18 QD   PSEUD    0    0.0000    3.7230   -1.7581   -2.8988   15    0    0    0    0
  19 NE   N_AMI    2   -6.3781    5.5643   -1.4643   -2.4144   15   20   21    0    0
  20 HE   H_AMI    0    3.0971    6.0160   -1.0017   -1.6515   19    0    0    0    0
  21 CZ   C_VIN    2    8.7540    6.3425   -2.0364   -3.3576   19   22   24    0    0
  22 NH1  N_AMI    2   -7.6509    7.6548   -1.9625   -3.2357   21   23    0    0    0
  23 HH1  H_AMI    0    1.6405    8.3002   -2.3586   -3.8888   22    0    0    0    0
  24 NH2  N_AMI    2   -7.4670    5.7870   -2.6745   -4.4096   21   25   26    0    0
  25 HH21 H_AMI    0    2.9133    6.3705   -3.0956   -5.1040   24    0    0    0   27
  26 HH22 H_AMI    0    2.9133    4.7919   -2.7260   -4.4945   24    0    0    0   27
  27 QH2  PSEUD    0    0.0000    5.5812   -2.9108   -4.7993   24    0    0    0    0
  28 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   29   30    0    0
  29 O    O_BYL    2   -7.0004    1.2064    2.3881    0.0000   28    0    0    0    0
  30 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   28    0    0    0    0
RESIDUE   ARG+ R    7   32    3   31
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   30    0
   3 CHI1     1    3    1.3500    3    5    7   11   29
   4 CHI2     1    3    1.3500    5    7   11   15   29
   5 CHI3     1    3    1.3500    7   11   15   19   29
   6 CHI4     0    0    0.0000   11   15   19   21   29
   7 PSI      0    0    0.0000    3    5   30   32    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   30    0
   6 HA   H_ALI    0    0.3677    1.7317   -0.5213    0.9158    5    0    0    0    0
   7 CB   C_ALI    3   -0.5515    2.0038   -0.7402   -1.2205    5    8    9   11    0
   8 HB2  H_ALI    0    0.2687    1.6375   -1.7668   -1.2235    7    0    0    0   10
   9 HB3  H_ALI    0    0.2687    1.6375   -0.2685   -2.1323    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6375   -1.0177   -1.6779    7    0    0    0    0
  11 CG   C_ALI    3   -0.5515    3.5338   -0.7388   -1.2182    7   12   13   15    0
  12 HG2  H_ALI    0    0.5515    3.9001    0.2878   -1.2152   11    0    0    0   14
  13 HG3  H_ALI    0    0.5515    3.9001   -1.2106   -0.3064   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    3.9001   -0.4614   -0.7608   11    0    0    0    0
  15 CD   C_ALI    3    2.2062    4.0846   -1.4791   -2.4387   11   16   17   19    0
  16 HD2  H_ALI    0    0.1980    3.7230   -2.5073   -2.4444   15    0    0    0   18
  17 HD3  H_ALI    0    0.1980    3.7230   -1.0090   -3.3532   15    0    0    0   18
  18 QD   PSEUD    0    0.0000    3.7230   -1.7581   -2.8988   15    0    0    0    0
  19 NE   N_AMI    2   -5.4589    5.5643   -1.4643   -2.4144   15   20   21    0    0
  20 HE   H_AMI    0    4.1861    6.0160   -1.0017   -1.6515   19    0    0    0    0
  21 CZ   C_VIN    2   10.5783    6.3367   -2.0321   -3.3506   19   22   26    0    0
  22 NH1  N_AMO    2   -7.0852    7.6712   -1.9691   -3.2468   21   23   24    0    0
  23 HH11 H_AMI    0    5.1195    8.2477   -2.3929   -3.9454   22    0    0    0   25
  24 HH12 H_AMI    0    5.1195    8.0907   -1.4983   -2.4706   22    0    0    0   25
  25 QH1  PSEUD    0    0.0000    8.1692   -1.9456   -3.2080   22    0    0    0    0
  26 NH2  N_AMO    2   -7.0852    5.7747   -2.6630   -4.3906   21   27   28    0    0
  27 HH21 H_AMI    0    5.1195    6.3512   -3.0868   -5.0893   26    0    0    0   29
  28 HH22 H_AMI    0    5.1195    4.7788   -2.7101   -4.4681   26    0    0    0   29
  29 QH2  PSEUD    0    0.0000    5.5650   -2.8985   -4.7787   26    0    0    0    0
  30 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   31   32    0    0
  31 O    O_BYL    2   -7.0004    1.2064    2.3881    0.0000   30    0    0    0    0
  32 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   30    0    0    0    0
RESIDUE   ASN  N    5   19    3   18
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   17    0
   3 CHI1     1    3    1.3500    3    5    7   11   16
   4 CHI2     0    0    0.0000    5    7   11   12   16
   5 PSI      0    0    0.0000    3    5   17   19    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   17    0
   6 HA   H_ALI    0    0.3677    1.7394   -0.5422    0.9011    5    0    0    0    0
   7 CB   C_ALI    3   -2.1920    2.0038   -0.6938   -1.2474    5    8    9   11    0
   8 HB2  H_ALI    0    1.0041    1.6375   -1.7196   -1.2891    7    0    0    0   10
   9 HB3  H_ALI    0    1.0041    1.6375   -0.1881   -2.1409    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6375   -0.9538   -1.7150    7    0    0    0    0
  11 CG   C_BYL    2    8.3721    3.5338   -0.6925   -1.2451    7   12   13    0    0
  12 OD1  O_BYL    2   -6.8307    4.1821   -1.1949   -2.1483   11    0    0    0    0
  13 ND2  N_AMI    2   -8.1034    4.0726   -0.1015   -0.1825   11   14   15    0    0
  14 HD21 H_AMI    0    3.6487    3.4834    0.2913    0.5236   13    0    0    0   16
  15 HD22 H_AMI    0    3.6487    5.0670   -0.0498   -0.0896   13    0    0    0   16
  16 QD2  PSEUD    0    0.0000    4.2752    0.1208    0.2170   13    0    0    0    0
  17 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   18   19    0    0
  18 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   17    0    0    0    0
  19 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   17    0    0    0    0
RESIDUE   ASP- D    5   16    3   15
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   14    0
   3 CHI1     1    3    1.3500    3    5    7   11   13
   4 CHI2     0    0    0.0000    5    7   11   12   13
   5 PSI      0    0    0.0000    3    5   14   16    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3   -1.0904    1.4530    0.0000    0.0000    3    6    7   14    0
   6 HA   H_ALI    0    0.4384    1.7394   -0.5422    0.9011    5    0    0    0    0
   7 CB   C_ALI    3   -3.0971    2.0038   -0.6938   -1.2474    5    8    9   11    0
   8 HB2  H_ALI    0   -0.3677    1.6190   -1.7132   -1.2776    7    0    0    0   10
   9 HB3  H_ALI    0   -0.3677    1.6190   -0.1818   -2.1294    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6190   -0.9475   -1.7035    7    0    0    0    0
  11 CG   C_BYL    2    9.1075    3.5302   -0.7444   -1.3384    7   12   13    0    0
  12 OD1  O_BYL    2  -10.3803    4.0206   -1.3033   -2.3432   11    0    0    0    0
  13 OD2  O_BYL    2  -10.3803    4.1722   -0.2231   -0.4011   11    0    0    0    0
  14 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   15   16    0    0
  15 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   14    0    0    0    0
  16 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   14    0    0    0    0
RESIDUE   ASP  D    6   17    3   16
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   15    0
   3 CHI1     1    3    1.3500    3    5    7   11   14
   4 CHI2     0    0    0.0000    5    7   11   12   14
   5 CHI32   -1    2    4.0000    7   11   13   14   14
   6 PSI      0    0    0.0000    3    5   15   17    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   15    0
   6 HA   H_ALI    0    0.3677    1.7394   -0.5422    0.9011    5    0    0    0    0
   7 CB   C_ALI    3   -1.8243    2.0038   -0.6938   -1.2474    5    8    9   11    0
   8 HB2  H_ALI    0    1.1031    1.6190   -1.7132   -1.2776    7    0    0    0   10
   9 HB3  H_ALI    0    1.1031    1.6190   -0.1818   -2.1294    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6190   -0.9475   -1.7035    7    0    0    0    0
  11 CG   C_BYL    2    9.1075    3.5302   -0.7444   -1.3384    7   12   13    0    0
  12 OD1  O_BYL    2   -6.5620    4.0951   -1.2810   -2.3031   11    0    0    0    0
  13 OD2  O_HYD    2   -6.3781    4.1537   -0.1955   -0.3514   11   14    0    0    0
  14 HD2  H_OXY    0    4.0022    5.1416   -0.2707   -0.4866   13    0    0    0    0
  15 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   16   17    0    0
  16 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   15    0    0    0    0
  17 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   15    0    0    0    0
RESIDUE   CYSS CS    4   14    3   13
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   12    0
   3 CHI1     1    3    1.3500    3    5    7   11   11
   4 PSI      0    0    0.0000    3    5   12   14    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   12    0
   6 HA   H_ALI    0    0.3677    1.7661   -0.5112    0.9103    5    0    0    0    0
   7 CB   C_ALI    3   -1.6405    2.0187   -0.7882   -1.1831    5    8    9   11    0
   8 HB2  H_ALI    0    1.0041    1.6404   -1.8093   -1.1355    7    0    0    0   10
   9 HB3  H_ALI    0    1.0041    1.6404   -0.3509   -2.1071    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6404   -1.0801   -1.6213    7    0    0    0    0
  11 SG   S_OXY    3    0.1838    3.8460   -0.8430   -1.2654    7    0    0    0    0
  12 C    C_BYL    2    8.2024    1.9334    1.4526    0.0000    5   13   14    0    0
  13 O    O_BYL    2   -7.0004    1.1232    2.3781    0.0000   12    0    0    0    0
  14 N    N_AMI    2   -6.4912    3.2494    1.6072    0.0000   12    0    0    0    0
RESIDUE   CYS  C    5   15    3   14
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   13    0
   3 CHI1     1    3    1.3500    3    5    7   11   12
   4 CHI2     1    3    0.7500    5    7   11   12   12
   5 PSI      0    0    0.0000    3    5   13   15    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   13    0
   6 HA   H_ALI    0    0.3677    1.7661   -0.5112    0.9103    5    0    0    0    0
   7 CB   C_ALI    3   -1.9092    2.0187   -0.7882   -1.1831    5    8    9   11    0
   8 HB2  H_ALI    0    1.0041    1.6627   -1.8178   -1.1483    7    0    0    0   10
   9 HB3  H_ALI    0    1.0041    1.6627   -0.3594   -2.1199    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6627   -1.0886   -1.6341    7    0    0    0    0
  11 SG   S_RED    3    0.2687    3.8479   -0.7581   -1.1379    7   12    0    0    0
  12 HG   H_SUL    0    0.1838    4.0261   -1.4888   -2.2348   11    0    0    0    0
  13 C    C_BYL    2    8.2024    1.9334    1.4526    0.0000    5   14   15    0    0
  14 O    O_BYL    2   -7.0004    1.1232    2.3781    0.0000   13    0    0    0    0
  15 N    N_AMI    2   -6.4912    3.2494    1.6072    0.0000   13    0    0    0    0
RESIDUE   GLN  Q    6   23    3   22
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   21    0
   3 CHI1     1    3    1.3500    3    5    7   11   20
   4 CHI2     1    3    1.3500    5    7   11   15   20
   5 CHI3     0    0    0.0000    7   11   15   16   20
   6 PSI      0    0    0.0000    3    5   21   23    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   21    0
   6 HA   H_ALI    0    0.3677    1.7427   -0.5017    0.9233    5    0    0    0    0
   7 CB   C_ALI    3   -0.5374    2.0013   -0.7874   -1.1917    5    8    9   11    0
   8 HB2  H_ALI    0    0.3677    1.6341   -1.8130   -1.1545    7    0    0    0   10
   9 HB3  H_ALI    0    0.3677    1.6341   -0.3510   -2.1206    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6341   -1.0820   -1.6375    7    0    0    0    0
  11 CG   C_ALI    3   -2.0082    3.5313   -0.7874   -1.1917    7   12   13   15    0
  12 HG2  H_ALI    0    0.9051    3.8985    0.2382   -1.2290   11    0    0    0   14
  13 HG3  H_ALI    0    0.9051    3.8985   -1.2239   -0.2629   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    3.8985   -0.4928   -0.7459   11    0    0    0    0
  15 CD   C_BYL    2    8.5701    4.0796   -1.5749   -2.3835   11   16   17    0    0
  16 OE1  O_BYL    2   -6.9155    5.2772   -1.7032   -2.5777   15    0    0    0    0
  17 NE2  N_AMI    2   -7.8347    3.1391   -2.0933   -3.1681   15   18   19    0    0
  18 HE21 H_AMI    0    3.3658    2.1732   -1.9506   -2.9521   17    0    0    0   20
  19 HE22 H_AMI    0    3.3658    3.3980   -2.6258   -3.9740   17    0    0    0   20
  20 QE2  PSEUD    0    0.0000    2.7856   -2.2882   -3.4631   17    0    0    0    0
  21 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   22   23    0    0
  22 O    O_BYL    2   -7.0004    1.2064    2.3882    0.0000   21    0    0    0    0
  23 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   21    0    0    0    0
RESIDUE   GLU- E    6   20    3   19
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   18    0
   3 CHI1     1    3    1.3500    3    5    7   11   17
   4 CHI2     1    3    1.3500    5    7   11   15   17
   5 CHI3     0    0    0.0000    7   11   15   16   17
   6 PSI      0    0    0.0000    3    5   18   20    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   18    0
   6 HA   H_ALI    0    0.3677    1.7427   -0.5017    0.9233    5    0    0    0    0
   7 CB   C_ALI    3   -2.1779    2.0013   -0.7874   -1.1917    5    8    9   11    0
   8 HB2  H_ALI    0    0.3677    1.6341   -1.8130   -1.1545    7    0    0    0   10
   9 HB3  H_ALI    0    0.3677    1.6341   -0.3510   -2.1206    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6341   -1.0820   -1.6375    7    0    0    0    0
  11 CG   C_ALI    3   -3.0971    3.5313   -0.7874   -1.1917    7   12   13   15    0
  12 HG2  H_ALI    0   -0.7354    3.8985    0.2382   -1.2290   11    0    0    0   14
  13 HG3  H_ALI    0   -0.7354    3.8985   -1.2239   -0.2629   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    3.8985   -0.4928   -0.7459   11    0    0    0    0
  15 CD   C_BYL    2    9.1075    4.0796   -1.5749   -2.3835   11   16   17    0    0
  16 OE1  O_BYL    2  -10.3803    5.3227   -1.6469   -2.4925   15    0    0    0    0
  17 OE2  O_BYL    2  -10.3803    3.2432   -2.0870   -3.1585   15    0    0    0    0
  18 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   19   20    0    0
  19 O    O_BYL    2   -7.0004    1.2064    2.3882    0.0000   18    0    0    0    0
  20 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   18    0    0    0    0
RESIDUE   GLU  E    7   21    3   20
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   19    0
   3 CHI1     1    3    1.3500    3    5    7   11   18
   4 CHI2     1    3    1.3500    5    7   11   15   18
   5 CHI3     0    0    0.0000    7   11   15   16   18
   6 CHI42   -1    2    4.0000   11   15   17   18   18
   7 PSI      0    0    0.0000    3    5   19   21    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   19    0
   6 HA   H_ALI    0    0.3677    1.7427   -0.5017    0.9233    5    0    0    0    0
   7 CB   C_ALI    3   -0.5515    2.0013   -0.7874   -1.1917    5    8    9   11    0
   8 HB2  H_ALI    0    0.5515    1.6341   -1.8130   -1.1545    7    0    0    0   10
   9 HB3  H_ALI    0    0.5515    1.6341   -0.3510   -2.1206    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6341   -1.0820   -1.6375    7    0    0    0    0
  11 CG   C_ALI    3   -2.0082    3.5313   -0.7874   -1.1917    7   12   13   15    0
  12 HG2  H_ALI    0    1.0041    3.8985    0.2382   -1.2290   11    0    0    0   14
  13 HG3  H_ALI    0    1.0041    3.8985   -1.2239   -0.2629   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    3.8985   -0.4928   -0.7459   11    0    0    0    0
  15 CD   C_BYL    2    9.1075    4.0796   -1.5749   -2.3835   11   16   17    0    0
  16 OE1  O_BYL    2   -6.5620    5.3043   -1.6818   -2.5453   15    0    0    0    0
  17 OE2  O_HYD    2   -6.3781    3.1835   -2.0873   -3.1571   15   18    0    0    0
  18 HE2  H_OXY    0    3.8325    3.6219   -2.5827   -3.9070   17    0    0    0    0
  19 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   20   21    0    0
  20 O    O_BYL    2   -7.0004    1.2064    2.3882    0.0000   19    0    0    0    0
  21 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   19    0    0    0    0
RESIDUE   GLY  G    3   11    3   10
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5    9    0
   3 PSI      0    0    0.0000    3    5    9   11    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.2650    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3   -0.1556    1.4530    0.0000    0.0000    3    6    7    9    0
   6 HA1  H_ALI    0    1.0041    1.8202   -0.5343    0.8762    5    0    0    0    8
   7 HA2  H_ALI    0    1.0041    1.8202   -0.5343   -0.8762    5    0    0    0    8
   8 QA   PSEUD    0    0.0000    1.8202   -0.5343    0.0000    5    0    0    0    0
   9 C    C_BYL    2    8.2024    2.0013    1.4284    0.0000    5   10   11    0    0
  10 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000    9    0    0    0    0
  11 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000    9    0    0    0    0
RESIDUE   HIST H    5   21    3   20
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   19    0
   3 CHI1     1    3    1.3500    3    5    7   11   18
   4 CHI2     0    0    0.0000    5    7   11   12   18
   5 PSI      0    0    0.0000    3    5   19   21    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   19    0
   6 HA   H_ALI    0    0.3677    1.7658   -0.4880    0.9231    5    0    0    0    0
   7 CB   C_ALI    3   -1.3718    1.9963   -0.8228   -1.1699    5    8    9   11    0
   8 HB2  H_ALI    0    0.7495    1.6134   -1.8405   -1.0938    7    0    0    0   10
   9 HB3  H_ALI    0    0.7495    1.6134   -0.4071   -2.1019    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6134   -1.1238   -1.5979    7    0    0    0    0
  11 CG   C_VIN    2    1.8243    3.5040   -0.8713   -1.2388    7   12   13    0    0
  12 ND1  N_AMI    2   -4.2002    4.1876   -1.5636   -2.2231   11   16    0    0    0
  13 CD2  C_ARO    2    0.9758    4.4515   -0.3061   -0.4368   11   14   15    0    0
  14 HD2  H_ARO    0    0.3253    4.2578    0.3120    0.4399   13    0    0    0    0
  15 NE2  N_AMI    2   -4.6386    5.6488   -0.6364   -0.9048   13   16   18    0    0
  16 CE1  C_ARO    2    3.3234    5.4873   -1.4156   -2.0126   12   15   17    0    0
  17 HE1  H_ARO    0    0.1980    6.2871   -1.8416   -2.6184   16    0    0    0    0
  18 HE2  H_AMI    0    2.6163    6.5236   -0.3132   -0.5438   15    0    0    0    0
  19 C    C_BYL    2    8.2024    1.9662    1.4413    0.0000    5   20   21    0    0
  20 O    O_BYL    2   -7.0004    1.1773    2.3850    0.0000   19    0    0    0    0
  21 N    N_AMI    2   -6.4912    3.2853    1.5659    0.0000   19    0    0    0    0
RESIDUE   HIS+ H    5   22    3   21
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   20    0
   3 CHI1     1    3    1.3500    3    5    7   11   19
   4 CHI2     0    0    0.0000    5    7   11   12   19
   5 PSI      0    0    0.0000    3    5   20   22    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   20    0
   6 HA   H_ALI    0    0.3677    1.7658   -0.4880    0.9231    5    0    0    0    0
   7 CB   C_ALI    3   -0.9051    1.9963   -0.8228   -1.1699    5    8    9   11    0
   8 HB2  H_ALI    0    1.1879    1.6134   -1.8405   -1.0938    7    0    0    0   10
   9 HB3  H_ALI    0    1.1879    1.6134   -0.4071   -2.1019    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6134   -1.1238   -1.5979    7    0    0    0    0
  11 CG   C_VIN    2    2.7294    3.5040   -0.8713   -1.2388    7   12   13    0    0
  12 ND1  N_AMO    2   -3.6487    4.1876   -1.5636   -2.2231   11   14   15    0    0
  13 CD2  C_ARO    2    1.8243    4.4515   -0.3061   -0.4368   11   16   17    0    0
  14 HD1  H_AMI    0    5.0063    3.7713   -2.0867   -2.9668   12    0    0    0    0
  15 CE1  C_ARO    2    5.0063    5.4873   -1.4156   -2.0126   12   16   18    0    0
  16 NE2  N_AMO    2   -3.6487    5.6488   -0.6364   -0.9048   13   15   19    0    0
  17 HD2  H_ARO    0    2.4607    4.2578    0.3120    0.4399   13    0    0    0    0
  18 HE1  H_ARO    0    2.7294    6.2871   -1.8416   -2.6184   15    0    0    0    0
  19 HE2  H_AMI    0    4.8366    6.5236   -0.3132   -0.5438   16    0    0    0    0
  20 C    C_BYL    2    8.2024    1.9662    1.4413    0.0000    5   21   22    0    0
  21 O    O_BYL    2   -7.0004    1.1773    2.3850    0.0000   20    0    0    0    0
  22 N    N_AMI    2   -6.4912    3.2853    1.5659    0.0000   20    0    0    0    0
RESIDUE   HIS  H    5   21    3   20
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   19    0
   3 CHI1     1    3    1.3500    3    5    7   11   18
   4 CHI2     0    0    0.0000    5    7   11   12   18
   5 PSI      0    0    0.0000    3    5   19   21    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   19    0
   6 HA   H_ALI    0    0.3677    1.7658   -0.4880    0.9231    5    0    0    0    0
   7 CB   C_ALI    3   -0.7212    1.9963   -0.8228   -1.1699    5    8    9   11    0
   8 HB2  H_ALI    0    0.2687    1.6134   -1.8405   -1.0938    7    0    0    0   10
   9 HB3  H_ALI    0    0.2687    1.6134   -0.4071   -2.1019    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6134   -1.1238   -1.5979    7    0    0    0    0
  11 CG   C_VIN    2    1.0041    3.5040   -0.8713   -1.2388    7   12   13    0    0
  12 ND1  N_AMI    2   -4.5538    4.1876   -1.5636   -2.2231   11   14   15    0    0
  13 CD2  C_ARO    2    1.4566    4.4515   -0.3061   -0.4368   11   16   17    0    0
  14 HD1  H_AMI    0    2.7294    3.7713   -2.0867   -2.9668   12    0    0    0    0
  15 CE1  C_ARO    2    3.4648    5.4873   -1.4156   -2.0126   12   16   18    0    0
  16 NE2  N_AMI    2   -4.3699    5.6488   -0.6364   -0.9048   13   15    0    0    0
  17 HD2  H_ARO    0    0.6364    4.2578    0.3120    0.4399   13    0    0    0    0
  18 HE1  H_ARO    0    0.3677    6.2871   -1.8416   -2.6184   15    0    0    0    0
  19 C    C_BYL    2    8.2024    1.9662    1.4413    0.0000    5   20   21    0    0
  20 O    O_BYL    2   -7.0004    1.1773    2.3850    0.0000   19    0    0    0    0
  21 N    N_AMI    2   -6.4912    3.2853    1.5659    0.0000   19    0    0    0    0
RESIDUE   ILE  I    7   25    3   24
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   23    0
   3 CHI1     1    3    1.3500    3    5    7   14   22
   4 CHI22    1    3    1.3500    5    7   10   11   13
   5 CHI21    1    3    1.3500    5    7   14   19   22
   6 CHI31    1    3    1.3500    7   14   19   20   22
   7 PSI      0    0    0.0000    3    5   23   25    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   23    0
   6 HA   H_ALI    0    0.3677    1.7797   -0.4805    0.9222    5    0    0    0    0
   7 CB   C_ALI    3   -0.0849    1.9888   -0.8392   -1.1617    5    8   10   14    0
   8 HB   H_ALI    0    0.4525    1.6625   -1.8692   -1.0179    7    0    0    0    0
   9 QG2  PSEUD    0    0.0000    1.2708   -0.2506   -2.8117   10    0    0    0    0
  10 CG2  C_ALI    3   -1.3576    1.4086   -0.3635   -2.4951    7   11   12   13    0
  11 HG21 H_ALI    0    0.4525    1.8059   -0.9770   -3.3037   10    0    0    0    9
  12 HG22 H_ALI    0    0.4525    0.3225   -0.4528   -2.4713   10    0    0    0    9
  13 HG23 H_ALI    0    0.4525    1.6840    0.6781   -2.6602   10    0    0    0    9
  14 CG1  C_ALI    3   -0.3536    3.5188   -0.8471   -1.1725    7   15   16   19    0
  15 HG12 H_ALI    0    0.2687    3.8906    0.1742   -1.2551   14    0    0    0   17
  16 HG13 H_ALI    0    0.2687    3.8906   -1.2463   -0.2289   14    0    0    0   17
  17 QG1  PSEUD    0    0.0000    3.8906   -0.5361   -0.7420   14    0    0    0    0
  18 QD1  PSEUD    0    0.0000    4.1818   -1.8856   -2.6101   19    0    0    0    0
  19 CD1  C_ALI    3   -1.3576    4.0546   -1.6863   -2.3342   14   20   21   22    0
  20 HD11 H_ALI    0    0.4525    5.1444   -1.6749   -2.3183   19    0    0    0   18
  21 HD12 H_ALI    0    0.4525    3.7005   -2.7124   -2.2348   19    0    0    0   18
  22 HD13 H_ALI    0    0.4525    3.7005   -1.2695   -3.2771   19    0    0    0   18
  23 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   24   25    0    0
  24 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   23    0    0    0    0
  25 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   23    0    0    0    0
RESIDUE   LEU  L    7   26    3   25
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   24    0
   3 CHI1     1    3    1.3500    3    5    7   11   23
   4 CHI2     1    3    1.3500    5    7   11   15   23
   5 CHI31    1    3    1.3500    7   11   15   16   18
   6 CHI32    1    3    1.3500    7   11   19   20   22
   7 PSI      0    0    0.0000    3    5   24   26    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   24    0
   6 HA   H_ALI    0    0.3677    1.7797   -0.4805    0.9222    5    0    0    0    0
   7 CB   C_ALI    3   -0.5374    1.9888   -0.8392   -1.1617    5    8    9   11    0
   8 HB2  H_ALI    0    0.3960    1.5941   -1.8507   -1.0656    7    0    0    0   10
   9 HB3  H_ALI    0    0.3960    1.5941   -0.4301   -2.0917    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.5941   -1.1404   -1.5787    7    0    0    0    0
  11 CG   C_ALI    3   -0.1838    3.5118   -0.9251   -1.2806    7   12   15   19    0
  12 HG   H_ALI    0    0.4525    3.8975   -1.4120   -0.3849   11    0    0    0    0
  13 QD1  PSEUD    0    0.0000    4.0177   -1.9934   -2.7595   15    0    0    0   23
  14 QD2  PSEUD    0    0.0000    4.2850    0.8015   -1.3553   19    0    0    0   23
  15 CD1  C_ALI    3   -1.3435    3.9206   -1.7884   -2.4757   11   16   17   18    0
  16 HD11 H_ALI    0    0.4525    5.0080   -1.8326   -2.5369   15    0    0    0   13
  17 HD12 H_ALI    0    0.4525    3.5225   -2.7953   -2.3497   15    0    0    0   13
  18 HD13 H_ALI    0    0.4525    3.5225   -1.3524   -3.3920   15    0    0    0   13
  19 CD2  C_ALI    3   -1.3435    4.1366    0.4702   -1.3410   11   20   21   22    0
  20 HD21 H_ALI    0    0.4525    5.2196    0.3800   -1.4253   19    0    0    0   14
  21 HD22 H_ALI    0    0.4525    3.7480    1.0051   -2.2076   19    0    0    0   14
  22 HD23 H_ALI    0    0.4525    3.8873    1.0195   -0.4331   19    0    0    0   14
  23 QQD  PSEUD    0    0.0000    4.1513   -0.5960   -2.0574   15   19    0    0    0
  24 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   25   26    0    0
  25 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   24    0    0    0    0
  26 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   24    0    0    0    0
RESIDUE   LYS+ K    8   30    3   29
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   28    0
   3 CHI1     1    3    1.3500    3    5    7   11   27
   4 CHI2     1    3    1.3500    5    7   11   15   27
   5 CHI3     1    3    1.3500    7   11   15   19   27
   6 CHI4     1    3    1.3500   11   15   19   23   27
   7 CHI5     1    3    0.9000   15   19   23   24   27
   8 PSI      0    0    0.0000    3    5   28   30    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   28    0
   6 HA   H_ALI    0    0.3677    1.7797   -0.4805    0.9222    5    0    0    0    0
   7 CB   C_ALI    3   -0.5515    1.9888   -0.8392   -1.1617    5    8    9   11    0
   8 HB2  H_ALI    0    0.2687    1.6169   -1.8605   -1.0798    7    0    0    0   10
   9 HB3  H_ALI    0    0.2687    1.6169   -0.4400   -2.1053    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6169   -1.1502   -1.5926    7    0    0    0    0
  11 CG   C_ALI    3   -0.4525    3.5188   -0.8471   -1.1725    7   12   13   15    0
  12 HG2  H_ALI    0    0.3677    3.8906    0.1742   -1.2551   11    0    0    0   14
  13 HG3  H_ALI    0    0.3677    3.8906   -1.2463   -0.2289   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    3.8906   -0.5361   -0.7420   11    0    0    0    0
  15 CD   C_ALI    3   -2.0930    4.0546   -1.6863   -2.3342   11   16   17   19    0
  16 HD2  H_ALI    0    1.8243    3.6827   -2.7076   -2.2516   15    0    0    0   18
  17 HD3  H_ALI    0    1.8243    3.6827   -1.2871   -3.2778   15    0    0    0   18
  18 QD   PSEUD    0    0.0000    3.6827   -1.9974   -2.7647   15    0    0    0    0
  19 CE   C_ALI    3    0.9051    5.5845   -1.6941   -2.3450   15   20   21   23    0
  20 HE2  H_ALI    0    2.1920    5.9587   -0.6738   -2.4289   19    0    0    0   22
  21 HE3  H_ALI    0    2.1920    5.9587   -2.0943   -1.4027   19    0    0    0   22
  22 QE   PSEUD    0    0.0000    5.9587   -1.3841   -1.9158   19    0    0    0    0
  23 NZ   N_AMO    3   -5.8266    6.0907   -2.5086   -3.4723   19   24   25   26    0
  24 HZ1  H_AMI    0    5.8266    7.0907   -2.5032   -3.4648   23    0    0    0   27
  25 HZ2  H_AMI    0    5.8266    5.7617   -3.4483   -3.3787   23    0    0    0   27
  26 HZ3  H_AMI    0    5.8266    5.7617   -2.1246   -4.3351   23    0    0    0   27
  27 QZ   PSEUD    0    0.0000    6.2047   -2.6920   -3.7262   23    0    0    0    0
  28 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   29   30    0    0
  29 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   28    0    0    0    0
  30 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   28    0    0    0    0
RESIDUE   LYS  K    8   29    3   28
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   27    0
   3 CHI1     1    3    1.3500    3    5    7   11   26
   4 CHI2     1    3    1.3500    5    7   11   15   26
   5 CHI3     1    3    1.3500    7   11   15   19   26
   6 CHI4     1    3    1.3500   11   15   19   23   26
   7 CHI5     1    3    0.9000   15   19   23   24   26
   8 PSI      0    0    0.0000    3    5   27   29    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   27    0
   6 HA   H_ALI    0    0.3677    1.7797   -0.4805    0.9222    5    0    0    0    0
   7 CB   C_ALI    3   -0.5515    1.9888   -0.8392   -1.1617    5    8    9   11    0
   8 HB2  H_ALI    0    0.2687    1.6169   -1.8605   -1.0798    7    0    0    0   10
   9 HB3  H_ALI    0    0.2687    1.6169   -0.4400   -2.1053    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6169   -1.1502   -1.5926    7    0    0    0    0
  11 CG   C_ALI    3   -0.4525    3.5188   -0.8471   -1.1725    7   12   13   15    0
  12 HG2  H_ALI    0    0.3677    3.8906    0.1742   -1.2551   11    0    0    0   14
  13 HG3  H_ALI    0    0.3677    3.8906   -1.2463   -0.2289   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    3.8906   -0.5361   -0.7420   11    0    0    0    0
  15 CD   C_ALI    3   -0.5515    4.0546   -1.6863   -2.3342   11   16   17   19    0
  16 HD2  H_ALI    0    0.3677    3.6827   -2.7076   -2.2516   15    0    0    0   18
  17 HD3  H_ALI    0    0.3677    3.6827   -1.2871   -3.2778   15    0    0    0   18
  18 QD   PSEUD    0    0.0000    3.6827   -1.9974   -2.7647   15    0    0    0    0
  19 CE   C_ALI    3    2.0082    5.5845   -1.6941   -2.3450   15   20   21   23    0
  20 HE2  H_ALI    0   -0.0849    5.9587   -0.6738   -2.4289   19    0    0    0   22
  21 HE3  H_ALI    0   -0.0849    5.9587   -2.0943   -1.4027   19    0    0    0   22
  22 QE   PSEUD    0    0.0000    5.9587   -1.3841   -1.9158   19    0    0    0    0
  23 NZ   N_AMI    3   -7.1983    6.0907   -2.5086   -3.4723   19   24   25    0    0
  24 HZ1  H_AMI    0    2.7294    7.1041   -2.5293   -3.5010   23    0    0    0   26
  25 HZ2  H_AMI    0    2.7294    5.7789   -3.4718   -3.4151   23    0    0    0   26
  26 QZ   PSEUD    0    0.0000    6.4415   -3.0006   -3.4581   23    0    0    0    0
  27 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   28   29    0    0
  28 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   27    0    0    0    0
  29 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   27    0    0    0    0
RESIDUE   MET  M    7   23    3   22
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   21    0
   3 CHI1     1    3    1.3500    3    5    7   11   20
   4 CHI2     1    3    1.3500    5    7   11   15   20
   5 CHI3     1    3    1.0000    7   11   15   17   20
   6 CHI4     1    3    1.0000   11   15   17   18   20
   7 PSI      0    0    0.0000    3    5   21   23    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   21    0
   6 HA   H_ALI    0    0.3677    1.7457   -0.5091    0.9183    5    0    0    0    0
   7 CB   C_ALI    3   -0.1838    1.9637   -0.7431   -1.2361    5    8    9   11    0
   8 HB2  H_ALI    0    0.5515    1.5826   -1.7643   -1.2341    7    0    0    0   10
   9 HB3  H_ALI    0    0.5515    1.5826   -0.2624   -2.1371    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.5826   -1.0134   -1.6856    7    0    0    0    0
  11 CG   C_ALI    3   -2.1920    3.4932   -0.7637   -1.2704    7   12   13   15    0
  12 HG2  H_ALI    0    0.8202    3.8789    0.2557   -1.2752   11    0    0    0   14
  13 HG3  H_ALI    0    0.8202    3.8789   -1.2461   -0.3722   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    3.8789   -0.4952   -0.8237   11    0    0    0    0
  15 SD   S_RED    3    0.6364    4.0596   -1.6359   -2.7211   11   17    0    0    0
  16 QE   PSEUD    0    0.0000    6.1844   -1.4722   -2.4490   15    0    0    0    0
  17 CE   C_ALI    3   -3.4648    5.8250   -1.4999   -2.4950   15   18   19   20    0
  18 HE1  H_ALI    0    1.0041    6.3363   -1.9959   -3.3200   17    0    0    0   16
  19 HE2  H_ALI    0    1.0041    6.1084   -0.4476   -2.4720   17    0    0    0   16
  20 HE3  H_ALI    0    1.0041    6.1084   -1.9731   -1.5549   17    0    0    0   16
  21 C    C_BYL    2    8.2024    2.0013    1.4284    0.0000    5   22   23    0    0
  22 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000   21    0    0    0    0
  23 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000   21    0    0    0    0
RESIDUE   PHE  F    5   27    3   26
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   25    0
   3 CHI1     1    3    1.3500    3    5    7   14   24
   4 CHI2     0    0    0.0000    5    7   14   15   24
   5 PSI      0    0    0.0000    3    5   25   27    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   25    0
   6 HA   H_ALI    0    0.3677    1.7765   -0.5114    0.9066    5    0    0    0    0
   7 CB   C_ALI    3   -0.7354    1.9003   -0.7053   -1.2819    5    8    9   14    0
   8 HB2  H_ALI    0    0.4525    1.4836   -1.7124   -1.2948    7    0    0    0   10
   9 HB3  H_ALI    0    0.4525    1.4836   -0.1770   -2.1395    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.4836   -0.9447   -1.7171    7    0    0    0    0
  11 QD   PSEUD    0    0.0000    3.5529   -0.8031   -1.4598   15   23    0    0   13
  12 QE   PSEUD    0    0.0000    6.0442   -0.9505   -1.7278   17   21    0    0   13
  13 QR   PSEUD    0    0.0000    4.7986   -0.8768   -1.5938   15   17   21   23    0
  14 CG   C_VIN    2    0.3677    3.4189   -0.7951   -1.4453    7   15   23    0    0
  15 CD1  C_ARO    2   -0.2687    3.9503   -1.3986   -2.5422   14   16   17    0    0
  16 HD1  H_ARO    0    0.1838    3.2943   -1.8182   -3.3049   15    0    0    0   11
  17 CE1  C_ARO    2   -0.2687    5.3597   -1.4820   -2.6938   15   18   19    0    0
  18 HE1  H_ARO    0    0.1838    5.7856   -1.9656   -3.5729   17    0    0    0   12
  19 CZ   C_ARO    2    0.2687    6.1782   -0.9585   -1.7422   17   20   21    0    0
  20 HZ   H_ARO    0    0.0849    7.2601   -1.0225   -1.8585   19    0    0    0   13
  21 CE2  C_ARO    2   -0.2687    5.6468   -0.3550   -0.6453   19   22   23    0    0
  22 HE2  H_ARO    0    0.1838    6.3028    0.0646    0.1174   21    0    0    0   12
  23 CD2  C_ARO    2   -0.2687    4.2374   -0.2716   -0.4937   14   21   24    0    0
  24 HD2  H_ARO    0    0.1838    3.8115    0.2120    0.3854   23    0    0    0   11
  25 C    C_BYL    2    8.2024    2.0013    1.4284    0.0000    5   26   27    0    0
  26 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000   25    0    0    0    0
  27 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000   25    0    0    0    0
RESIDUE   PRO  P    2   20    3   19
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PSI      0    0    0.0000    3    5   18   20    0
   1 C    C_BYL    2    8.2024   -0.7005    0.3017    1.1260    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1904    0.5914    2.2071    1    0    0    0    0
   3 N    N_AMI    2   -5.1902    0.0000    0.0000    0.0000    1    4    5    0    0
   4 CD   C_ALI    3    1.8243   -0.5705   -0.3478   -1.2981    3   11   15   16    0
   5 CA   C_ALI    3    0.9051    1.4530    0.0000    0.0000    3    6    7   18    0
   6 HA   H_ALI    0    0.7212    1.8001   -0.4260    0.8355    5    0    0    0    0
   7 CB   C_ALI    3   -0.4525    1.8464   -0.7872   -1.2393    5    8    9   11    0
   8 HB2  H_ALI    0    0.2687    2.6920   -0.3217   -1.7456    7    0    0    0   10
   9 HB3  H_ALI    0    0.2687    2.1502   -1.8009   -0.9780    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    2.4211   -1.0613   -1.3618    7    0    0    0    0
  11 CG   C_ALI    3   -0.9051    0.6166   -0.8003   -2.1326    4    7   12   13    0
  12 HG2  H_ALI    0    0.4525    0.7579   -0.1376   -2.9864   11    0    0    0   14
  13 HG3  H_ALI    0    0.4525    0.4445   -1.8004   -2.5305   11    0    0    0   14
  14 QG   PSEUD    0    0.0000    0.6012   -0.9690   -2.7585   11    0    0    0    0
  15 HD2  H_ALI    0    0.1838   -1.0711    0.5072   -1.7525    4    0    0    0   17
  16 HD3  H_ALI    0    0.1838   -1.3137   -1.1396   -1.2047    4    0    0    0   17
  17 QD   PSEUD    0    0.0000   -1.1924   -0.3162   -1.4786    4    0    0    0    0
  18 C    C_BYL    2    8.2873    2.0013    1.4284    0.0000    5   19   20    0    0
  19 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000   18    0    0    0    0
  20 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000   18    0    0    0    0
RESIDUE   SER  S    5   15    3   14
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   13    0
   3 CHI1     1    3    1.3500    3    5    7   11   12
   4 CHI2     1    3    0.3000    5    7   11   12   12
   5 PSI      0    0    0.0000    3    5   13   15    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   13    0
   6 HA   H_ALI    0    0.3677    1.7416   -0.5122    0.9178    5    0    0    0    0
   7 CB   C_ALI    3    2.3617    2.0038   -0.7653   -1.2049    5    8    9   11    0
   8 HB2  H_ALI    0    0.3677    1.6328   -1.7901   -1.1839    7    0    0    0   10
   9 HB3  H_ALI    0    0.3677    1.6328   -0.3109   -2.1235    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6328   -1.0505   -1.6537    7    0    0    0    0
  11 OG   O_HYD    3   -5.6427    3.4286   -0.7774   -1.2238    7   12    0    0    0
  12 HG   H_OXY    0    3.0971    3.7558   -1.2840   -2.0214   11    0    0    0    0
  13 C    C_BYL    2    8.2024    1.9763    1.4377    0.0000    5   14   15    0    0
  14 O    O_BYL    2   -7.0004    1.1939    2.3868    0.0000   13    0    0    0    0
  15 N    N_AMI    2   -6.4912    3.2963    1.5532    0.0000   13    0    0    0    0
RESIDUE   THR  T    6   18    3   17
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   16    0
   3 CHI1     1    3    1.3500    3    5    7   10   15
   4 CHI21    1    3    0.3000    5    7   10   11   11
   5 CHI22    1    3    1.3500    5    7   12   13   15
   6 PSI      0    0    0.0000    3    5   16   18    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   16    0
   6 HA   H_ALI    0    0.3677    1.7966   -0.4689    0.9220    5    0    0    0    0
   7 CB   C_ALI    3    2.9133    1.9258   -0.8241   -1.1992    5    8   10   12    0
   8 HB   H_ALI    0    0.2687    1.5187   -1.8345   -1.1619    7    0    0    0    0
   9 QG2  PSEUD    0    0.0000    1.5244    0.0064   -2.8527   12    0    0    0    0
  10 OG1  O_HYD    3   -5.6569    3.3475   -0.7692   -1.1194    7   11    0    0    0
  11 HG1  H_OXY    0    3.0971    3.7526   -1.2870   -1.8728   10    0    0    0    0
  12 CG2  C_ALI    3   -1.7253    1.6014   -0.1530   -2.5354    7   13   14   15    0
  13 HG21 H_ALI    0    0.5515    1.9584   -0.7795   -3.3528   12    0    0    0    9
  14 HG22 H_ALI    0    0.5515    0.5230   -0.0208   -2.6232   12    0    0    0    9
  15 HG23 H_ALI    0    0.5515    2.0917    0.8194   -2.5821   12    0    0    0    9
  16 C    C_BYL    2    8.2024    1.9863    1.4340    0.0000    5   17   18    0    0
  17 O    O_BYL    2   -7.0004    1.2106    2.3886    0.0000   16    0    0    0    0
  18 N    N_AMI    2   -6.4912    3.3070    1.5402    0.0000   16    0    0    0    0
RESIDUE   TRP  W    5   28    3   27
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   26    0
   3 CHI1     1    3    1.3500    3    5    7   11   25
   4 CHI2     0    0    0.0000    5    7   11   12   25
   5 PSI      0    0    0.0000    3    5   26   28    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   26    0
   6 HA   H_ALI    0    0.3677    1.7862   -0.5002    0.9093    5    0    0    0    0
   7 CB   C_ALI    3   -0.5515    2.0013   -0.8067   -1.1787    5    8    9   11    0
   8 HB2  H_ALI    0    0.2687    1.6202   -1.8261   -1.1167    7    0    0    0   10
   9 HB3  H_ALI    0    0.2687    1.6202   -0.3799   -2.1065    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.6202   -1.1030   -1.6116    7    0    0    0    0
  11 CG   C_VIN    2   -0.4525    3.5292   -0.8520   -1.2448    7   12   13    0    0
  12 CD1  C_ARO    2    1.5556    4.2978   -1.4719   -2.1507   11   16   17    0    0
  13 CD2  C_VIN    2    0.0849    4.4485   -0.2236   -0.3267   11   14   15    0    0
  14 CE3  C_ARO    2   -1.4566    4.2018    0.5582    0.8155   13   18   19    0    0
  15 CE2  C_VIN    2    2.7294    5.7342   -0.5067   -0.7404   13   16   20    0    0
  16 NE1  N_AMI    2   -5.1053    5.6397   -1.2900   -1.8848   12   15   21    0    0
  17 HD1  H_ARO    0    0.0000    3.9116   -2.0476   -2.9918   12    0    0    0    0
  18 HE3  H_ARO    0    1.4566    3.1962    0.7957    1.1626   14    0    0    0    0
  19 CZ3  C_ARO    2   -0.3677    5.3514    1.0094    1.4749   14   22   23    0    0
  20 CZ2  C_ARO    2   -1.0889    6.8740   -0.0475   -0.0695   15   23   24    0    0
  21 HE1  H_AMI    0    2.3759    6.4722   -1.6873   -2.4654   16    0    0    0    0
  22 HZ3  H_ARO    0    0.1838    5.2167    1.6203    2.3675   19    0    0    0    0
  23 CH2  C_ARO    2   -0.0849    6.6525    0.7332    1.0713   19   20   25    0    0
  24 HZ2  H_ARO    0    0.5515    7.8795   -0.2851   -0.4166   20    0    0    0    0
  25 HH2  H_ARO    0    0.1838    7.4966    1.1227    1.6404   23    0    0    0    0
  26 C    C_BYL    2    8.2024    1.9258    1.4551    0.0000    5   27   28    0    0
  27 O    O_BYL    2   -7.0004    1.1108    2.3763    0.0000   26    0    0    0    0
  28 N    N_AMI    2   -6.4912    3.2409    1.6166    0.0000   26    0    0    0    0
RESIDUE   TYR  Y    6   28    3   27
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   26    0
   3 CHI1     1    3    1.3500    3    5    7   14   25
   4 CHI2     0    0    0.0000    5    7   14   15   25
   5 CHI6    -1    2    1.7500   17   19   24   25   25
   6 PSI      0    0    0.0000    3    5   26   28    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   26    0
   6 HA   H_ALI    0    0.3677    1.7894   -0.5104    0.9024    5    0    0    0    0
   7 CB   C_ALI    3   -0.7354    1.8747   -0.6954   -1.2959    5    8    9   14    0
   8 HB2  H_ALI    0    0.4525    1.4494   -1.6989   -1.3128    7    0    0    0   10
   9 HB3  H_ALI    0    0.4525    1.4494   -0.1548   -2.1414    7    0    0    0   10
  10 QB   PSEUD    0    0.0000    1.4494   -0.9269   -1.7271    7    0    0    0    0
  11 QD   PSEUD    0    0.0000    3.5334   -0.8057   -1.5014   15   22    0    0   13
  12 QE   PSEUD    0    0.0000    6.0510   -0.9730   -1.8132   17   20    0    0   13
  13 QR   PSEUD    0    0.0000    4.7922   -0.8893   -1.6572   15   17   20   22    0
  14 CG   C_VIN    2    0.3677    3.3898   -0.7961   -1.4835    7   15   22    0    0
  15 CD1  C_ARO    2   -0.1838    3.9068   -1.4012   -2.6111   14   16   17    0    0
  16 HD1  H_ARO    0    0.1838    3.2356   -1.8074   -3.3679   15    0    0    0   11
  17 CE1  C_ARO    2   -1.0889    5.3328   -1.4960   -2.7877   15   18   19    0    0
  18 HE1  H_ARO    0    0.5515    5.7543   -1.9713   -3.6734   17    0    0    0   12
  19 CZ   C_VIN    2    4.1012    6.1417   -0.9790   -1.8244   17   20   24    0    0
  20 CE2  C_ARO    2   -1.0889    5.6654   -0.3767   -0.7019   19   21   22    0    0
  21 HE2  H_ARO    0    0.5515    6.3477    0.0253    0.0471   20    0    0    0   12
  22 CD2  C_ARO    2   -0.1838    4.2394   -0.2819   -0.5253   14   20   23    0    0
  23 HD2  H_ARO    0    0.1838    3.8311    0.1960    0.3652   22    0    0    0   11
  24 OH   O_HYD    3   -6.0100    7.4885   -1.0685   -1.9912   19   25    0    0    0
  25 HH   H_OXY    0    2.9981    7.9579   -0.6510   -1.2132   24    0    0    0    0
  26 C    C_BYL    2    8.2024    2.0013    1.4284    0.0000    5   27   28    0    0
  27 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000   26    0    0    0    0
  28 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000   26    0    0    0    0
RESIDUE   VAL  V    6   22    3   21
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5   20    0
   3 CHI1     1    3    1.3500    3    5    7   11   19
   4 CHI21    1    3    1.3500    5    7   11   12   14
   5 CHI22    1    3    1.3500    5    7   15   16   18
   6 PSI      0    0    0.0000    3    5   20   22    0
   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   20    0
   6 HA   H_ALI    0    0.3677    1.7819   -0.4870    0.9180    5    0    0    0    0
   7 CB   C_ALI    3    0.1414    1.9763   -0.8167   -1.1833    5    8   11   15    0
   8 HB   H_ALI    0    0.2970    1.6329   -0.3367   -2.0997    7    0    0    0    0
   9 QG1  PSEUD    0    0.0000    3.8693   -0.8354   -1.2105   11    0    0    0   19
  10 QG2  PSEUD    0    0.0000    1.2807   -2.5773   -1.1531   15    0    0    0   19
  11 CG1  C_ALI    3   -1.3011    3.5061   -0.8318   -1.2052    7   12   13   14    0
  12 HG11 H_ALI    0    0.4525    3.8514   -1.4191   -2.0561   11    0    0    0    9
  13 HG12 H_ALI    0    0.4525    3.8783    0.1889   -1.2932   11    0    0    0    9
  14 HG13 H_ALI    0    0.4525    3.8783   -1.2761   -0.2821   11    0    0    0    9
  15 CG2  C_ALI    3   -1.3011    1.4141   -2.2394   -1.1589    7   16   17   18    0
  16 HG21 H_ALI    0    0.4525    1.8021   -2.7980   -2.0107   15    0    0    0   10
  17 HG22 H_ALI    0    0.4525    1.7137   -2.7326   -0.2341   15    0    0    0   10
  18 HG23 H_ALI    0    0.4525    0.3262   -2.2013   -1.2144   15    0    0    0   10
  19 QQG  PSEUD    0    0.0000    2.5750   -1.7064   -1.1818   11   15    0    0    0
  20 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   21   22    0    0
  21 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   20    0    0    0    0
  22 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   20    0    0    0    0
RESIDUE   ADE  a    9   38    3   37
   1 ZETA     0    0    0.0000    1    2    3    6    0
   2 ALPHA    0    0    0.0000    2    3    6    7    0
   3 BETA     0    0    0.0000    3    6    7   11    0
   4 GAMMA    0    0    0.0000    6    7   11   13    0
   5 DELTA    0    0    0.0000    7   11   13   37    0
   6 NU2      0    0    0.0000   11   13   15   19   36
   7 NU1      0    0    0.0000   13   15   19   21   36
   8 CHI      0    0    0.0000   21   19   22   23   36
   9 EPSI     0    0    0.0000   11   13   37   38    0
   1 C3'  C_ALI    0    0.2330   -0.9681   -5.8551    2.5577    2    0    0    0    0
   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
   7 C5'  C_ALI    0    0.1180    1.4216   -1.4863    1.2135    6    8    9   11    0
   8 H5'  H_ALI    0    0.0210    2.4568   -1.8260    1.2707    7    0    0    0   10
   9 H5"  H_ALI    0    0.0210    1.2157   -0.8907    2.1041    7    0    0    0   10
  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
  11 C4'  C_ALI    0    0.0360    1.2779   -0.5959    0.0000    7   12   21   13    0
  12 H4'  H_ALI    0    0.0560    1.5099   -1.1747   -0.8952   11    0    0    0    0
  13 C3'  C_ALI    0    0.2330    2.1963    0.6228    0.0000   11   15   14   37    0
  14 H3'  H_ALI    0    0.0250    3.1027    0.4293    0.5756   13    0    0    0    0
  15 C2'  C_ALI    0   -0.3070    1.3731    1.7403    0.5780   19   16   17   13    0
  16 H2'  H_ALI    0    0.0810    1.4019    1.6718    1.6635   15    0    0    0   18
  17 H2"  H_ALI    0    0.0810    1.7912    2.6897    0.2499   15    0    0    0   18
  18 Q2'  PSEUD    0    0.0000    1.5965    2.1808    0.9567    0    0    0    0    0
  19 C1'  C_ALI    0    0.3760    0.0000    1.4100    0.0000   21   20   22   15    0
  20 H1'  H_ALI    0    0.0090   -0.0659    1.7932   -1.0183   19    0    0    0    0
  21 O4'  O_EST    0   -0.3680    0.0000    0.0000    0.0000   11   19    0    0    0
  22 N9   N_AMI    0   -0.0730   -1.1209    1.9441    0.8017   19   23   35    0    0
  23 C4   C_ARO    0    0.5460   -2.3784    2.2371    0.3436   22   24   33    0    0
  24 N3   N_AMI    0   -0.7280   -2.8170    2.0867   -0.9370   23   25    0    0    0
  25 C2   C_ARO    0    0.6610   -4.1036    2.4736   -1.0196   24   26   27    0    0
  26 H2   H_ARO    0   -0.0320   -4.6227    2.4240   -1.9654   25    0    0    0    0
  27 N1   N_AMI    0   -0.7740   -4.9152    2.9484   -0.0482   25   28    0    0    0
  28 C6   C_ARO    0    0.7690   -4.4155    3.0749    1.2114   27   29   33    0    0
  29 N6   N_AMI    0   -0.7680   -5.2378    3.5526    2.1808   28   30   31    0    0
  30 H61  H_AMI    0    0.3350   -6.1905    3.8024    1.9570   29    0    0    0   32
  31 H62  H_AMI    0    0.3240   -4.8967    3.6581    3.1256   29    0    0    0   32
  32 Q6   PSEUD    0    0.0000   -5.5436    3.7303    2.5413    0    0    0    0    0
  33 C5   C_ARO    0   -0.0970   -3.0716    2.6978    1.4177   23   28   34    0    0
  34 N7   N_AMI    0   -0.5430   -2.2897    2.7047    2.5414   33   35    0    0    0
  35 C8   C_ARO    0    0.2630   -1.1186    2.2402    2.1184   22   34   36    0    0
  36 H8   H_ARO    0    0.0620   -0.2357    2.0985    2.7240   35    0    0    0    0
  37 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   38    0    0    0
  38 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   37    0    0    0    0
RESIDUE   RADE ra   10   38    3   37
   1 ZETA     0    0    0.00      1    2    3    6    0
   2 ALPHA    0    0    0.00      2    3    6    7    0
   3 BETA     0    0    0.00      3    6    7   11    0
   4 GAMMA    0    0    0.00      6    7   11   13    0
   5 DELTA    0    0    0.00      7   11   13   37    0
   6 NU2      0    0    0.00     11   13   15   19   36
   7 HOXI     0    0    0.00     13   15   17   18   18
   8 NU1      0    0    0.00     13   15   19   21   36
   9 CHI      0    0    0.00     21   19   22   23   36
  10 EPSI     0    0    0.00     11   13   37   38    0
   1 C3'  C_ALI    0    0.3030   -0.9681   -5.8551    2.5577    2    0    0    0    0
   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
   7 C5'  C_ALI    0    0.1800    1.4216   -1.4863    1.2135    6    8    9   11    0
   8 H5'  H_ALI    0    0.0080    2.4568   -1.8260    1.2707    7    0    0    0   10
   9 H5"  H_ALI    0    0.0080    1.2157   -0.8907    2.1041    7    0    0    0   10
  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
  11 C4'  C_ALI    0    0.1000    1.2779   -0.5959    0.0000    7   12   13   21    0
  12 H4'  H_ALI    0    0.0610    1.5099   -1.1747   -0.8952   11    0    0    0    0
  13 C3'  C_ALI    0    0.3030    2.1963    0.6228    0.0000   11   14   15   37    0
  14 H3'  H_ALI    0    0.0070    3.1027    0.4293    0.5756   13    0    0    0    0
  15 C2'  C_ALI    0    0.1010    1.3731    1.7403    0.5780   13   16   17   19    0
  16 H2'  H_ALI    0    0.0080    1.4019    1.6718    1.6635   15    0    0    0    0
  17 O2'  O_HYD    0   -0.5460    1.9936    2.8894    0.0464   15   18    0    0    0
  18 HO2' H_OXY    0    0.3240    2.1370    3.5157    0.7597   17    0    0    0    0
  19 C1'  C_ALI    0    0.1170    0.0000    1.4100    0.0000   15   20   21   22    0
  20 H1'  H_ALI    0    0.0540   -0.0659    1.7932   -1.0183   19    0    0    0    0
  21 O4'  O_EST    0   -0.3430    0.0000    0.0000    0.0000   11   19    0    0    0
  22 N9   N_AMI    0   -0.0730   -1.1209    1.9441    0.8017   19   23   35    0    0
  23 C4   C_ARO    0    0.5460   -2.3784    2.2371    0.3436   22   24   33    0    0
  24 N3   N_AMI    0   -0.7280   -2.8170    2.0867   -0.9370   23   25    0    0    0
  25 C2   C_ARO    0    0.6610   -4.1036    2.4736   -1.0196   24   26   27    0    0
  26 H2   H_ARO    0   -0.0320   -4.6227    2.4240   -1.9654   25    0    0    0    0
  27 N1   N_AMI    0   -0.7740   -4.9152    2.9484   -0.0482   25   28    0    0    0
  28 C6   C_ARO    0    0.7690   -4.4155    3.0749    1.2114   27   29   33    0    0
  29 N6   N_AMI    0   -0.7680   -5.2378    3.5526    2.1808   28   30   31    0    0
  30 H61  H_AMI    0    0.3350   -6.1905    3.8024    1.9570   29    0    0    0   32
  31 H62  H_AMI    0    0.3240   -4.8967    3.6581    3.1256   29    0    0    0   32
  32 Q6   PSEUD    0    0.0000   -5.5436    3.7303    2.5413    0    0    0    0    0
  33 C5   C_ARO    0   -0.0970   -3.0716    2.6978    1.4177   23   28   34    0    0
  34 N7   N_AMI    0   -0.5430   -2.2897    2.7047    2.5414   33   35    0    0    0
  35 C8   C_ARO    0    0.2630   -1.1186    2.2402    2.1184   22   34   36    0    0
  36 H8   H_ARO    0    0.0620   -0.2357    2.0985    2.7240   35    0    0    0    0
  37 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   38    0    0    0
  38 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   37    0    0    0    0
RESIDUE   CYT  c    9   36    3   35
   1 ZETA     0    0    0.00      1    2    3    6    0
   2 ALPHA    0    0    0.00      2    3    6    7    0
   3 BETA     0    0    0.00      3    6    7   11    0
   4 GAMMA    0    0    0.00      6    7   11   13    0
   5 DELTA    0    0    0.0000    7   11   13   35    0
   6 NU2      0    0    0.0000   11   13   15   19   34
   7 NU1      0    0    0.0000   13   15   19   21   34
   8 CHI      0    0    0.0000   21   19   22   23   34
   9 EPSI     0    0    0.0000   11   13   35   36    0
   1 C3'  C_ALI    0    0.2330   -0.9681   -5.8551    2.5577    2    0    0    0    0
   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
   7 C5'  C_ALI    0    0.1180    1.4216   -1.4863    1.2135    6    8    9   11    0
   8 H5'  H_ALI    0    0.0210    2.4568   -1.8260    1.2707    7    0    0    0   10
   9 H5"  H_ALI    0    0.0210    1.2157   -0.8907    2.1041    7    0    0    0   10
  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
  11 C4'  C_ALI    0    0.0360    1.2779   -0.5959    0.0000    7   12   21   13    0
  12 H4'  H_ALI    0    0.0560    1.5099   -1.1747   -0.8952   11    0    0    0    0
  13 C3'  C_ALI    0    0.2330    2.1963    0.6228    0.0000   11   15   14   35    0
  14 H3'  H_ALI    0    0.0250    3.1027    0.4293    0.5756   13    0    0    0    0
  15 C2'  C_ALI    0   -0.3070    1.3731    1.7403    0.5780   19   16   17   13    0
  16 H2'  H_ALI    0    0.0810    1.4019    1.6718    1.6635   15    0    0    0   18
  17 H2"  H_ALI    0    0.0810    1.7912    2.6897    0.2499   15    0    0    0   18
  18 Q2'  PSEUD    0    0.0000    1.5965    2.1808    0.9567    0    0    0    0    0
  19 C1'  C_ALI    0    0.3760    0.0000    1.4100    0.0000   21   20   22   15    0
  20 H1'  H_ALI    0    0.0090   -0.0659    1.7932   -1.0183   19    0    0    0    0
  21 O4'  O_EST    0   -0.3680    0.0000    0.0000    0.0000   11   19    0    0    0
  22 N1   N_AMI    0   -0.1870   -1.1209    1.9441    0.8017   19   23   33    0    0
  23 C2   C_ARO    0    0.8590   -2.3304    2.1782    0.1493   22   24   25    0    0
  24 O2   O_BYL    0   -0.5080   -2.4085    1.9304   -1.0590   23    0    0    0    0
  25 N3   N_AMI    0   -0.8600   -3.3653    2.6642    0.8578   23   26    0    0    0
  26 C4   C_ARO    0    0.9350   -3.2644    2.9228    2.1462   25   27   31    0    0
  27 N4   N_AMI    0   -0.8340   -4.2972    3.4021    2.8279   26   28   29    0    0
  28 H41  H_AMI    0    0.3510   -5.1756    3.5735    2.3597   27    0    0    0   30
  29 H42  H_AMI    0    0.3290   -4.2049    3.5955    3.8149   27    0    0    0   30
  30 Q4   PSEUD    0    0.0000   -4.6903    3.5845    3.0873    0    0    0    0    0
  31 C5   C_ARO    0   -0.5760   -2.0221    2.6890    2.8462   26   32   33    0    0
  32 H5   H_ARO    0    0.1530   -1.9484    2.9039    3.9020   31    0    0    0    0
  33 C6   C_ARO    0    0.1850   -0.9996    2.2045    2.1264   22   31   34    0    0
  34 H6   H_ARO    0    0.0980   -0.0488    2.0117    2.6008   33    0    0    0    0
  35 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   36    0    0    0
  36 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   35    0    0    0    0
RESIDUE   RCYT rc   10   36    3   35
   1 ZETA     0    0    0.00      1    2    3    6    0
   2 ALPHA    0    0    0.00      2    3    6    7    0
   3 BETA     0    0    0.00      3    6    7   11    0
   4 GAMMA    0    0    0.00      6    7   11   13    0
   5 DELTA    0    0    0.00      7   11   13   35    0
   6 NU2      0    0    0.00     11   13   15   19   34
   7 HOXI     0    0    0.00     13   15   17   18   18
   8 NU1      0    0    0.00     13   15   19   21   34
   9 CHI      0    0    0.00     21   19   22   23   34
  10 EPSI     0    0    0.00     11   13   35   36    0
   1 C3'  C_ALI    0    0.3030   -0.9681   -5.8551    2.5577    2    0    0    0    0
   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
   7 C5'  C_ALI    0    0.1800    1.4216   -1.4863    1.2135    6    8    9   11    0
   8 H5'  H_ALI    0    0.0080    2.4568   -1.8260    1.2707    7    0    0    0   10
   9 H5"  H_ALI    0    0.0080    1.2157   -0.8907    2.1041    7    0    0    0   10
  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
  11 C4'  C_ALI    0    0.1000    1.2779   -0.5959    0.0000    7   12   13   21    0
  12 H4'  H_ALI    0    0.0610    1.5099   -1.1747   -0.8952   11    0    0    0    0
  13 C3'  C_ALI    0    0.3030    2.1963    0.6228    0.0000   11   14   15   35    0
  14 H3'  H_ALI    0    0.0070    3.1027    0.4293    0.5756   13    0    0    0    0
  15 C2'  C_ALI    0    0.1010    1.3731    1.7403    0.5780   13   16   17   19    0
  16 H2'  H_ALI    0    0.0080    1.4019    1.6718    1.6635   15    0    0    0    0
  17 O2'  O_HYD    0   -0.5460    1.9936    2.8894    0.0464   15   18    0    0    0
  18 HO2' H_OXY    0    0.3240    2.1370    3.5157    0.7597   17    0    0    0    0
  19 C1'  C_ALI    0    0.1170    0.0000    1.4100    0.0000   15   20   21   22    0
  20 H1'  H_ALI    0    0.0540   -0.0659    1.7932   -1.0183   19    0    0    0    0
  21 O4'  O_EST    0   -0.3430    0.0000    0.0000    0.0000   11   19    0    0    0
  22 N1   N_AMI    0   -0.1870   -1.1209    1.9441    0.8017   19   23   33    0    0
  23 C2   C_ARO    0    0.8590   -2.3304    2.1782    0.1493   22   24   25    0    0
  24 O2   O_BYL    0   -0.5080   -2.4085    1.9304   -1.0590   23    0    0    0    0
  25 N3   N_AMI    0   -0.8600   -3.3653    2.6642    0.8578   23   26    0    0    0
  26 C4   C_ARO    0    0.9350   -3.2644    2.9228    2.1462   25   27   31    0    0
  27 N4   N_AMI    0   -0.8340   -4.2972    3.4021    2.8279   26   28   29    0    0
  28 H41  H_AMI    0    0.3510   -5.1756    3.5735    2.3597   27    0    0    0   30
  29 H42  H_AMI    0    0.3290   -4.2049    3.5955    3.8149   27    0    0    0   30
  30 Q4   PSEUD    0    0.0000   -4.6903    3.5845    3.0873    0    0    0    0    0
  31 C5   C_ARO    0   -0.5760   -2.0221    2.6890    2.8462   26   32   33    0    0
  32 H5   H_ARO    0    0.1530   -1.9484    2.9039    3.9020   31    0    0    0    0
  33 C6   C_ARO    0    0.1850   -0.9996    2.2045    2.1264   22   31   34    0    0
  34 H6   H_ARO    0    0.0980   -0.0488    2.0117    2.6008   33    0    0    0    0
  35 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   36    0    0    0
  36 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   35    0    0    0    0
RESIDUE   GUA  g    9   39    3   38
   1 ZETA     0    0    0.0000    1    2    3    6    0
   2 ALPHA    0    0    0.0000    2    3    6    7    0
   3 BETA     0    0    0.0000    3    6    7   11    0
   4 GAMMA    0    0    0.0000    6    7   11   13    0
   5 DELTA    0    0    0.0000    7   11   13   38    0
   6 NU2      0    0    0.0000   11   13   15   19   37
   7 NU1      0    0    0.0000   13   15   19   21   37
   8 CHI      0    0    0.0000   21   19   22   23   37
   9 EPSI     0    0    0.0000   11   13   38   39    0
   1 C3'  C_ALI    0    0.2330   -0.9681   -5.8551    2.5577    2    0    0    0    0
   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
   7 C5'  C_ALI    0    0.1180    1.4216   -1.4863    1.2135    6    8    9   11    0
   8 H5'  H_ALI    0    0.0210    2.4568   -1.8260    1.2707    7    0    0    0   10
   9 H5"  H_ALI    0    0.0210    1.2157   -0.8907    2.1041    7    0    0    0   10
  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
  11 C4'  C_ALI    0    0.0360    1.2779   -0.5959    0.0000    7   12   21   13    0
  12 H4'  H_ALI    0    0.0560    1.5099   -1.1747   -0.8952   11    0    0    0    0
  13 C3'  C_ALI    0    0.2330    2.1963    0.6228    0.0000   11   15   14   38    0
  14 H3'  H_ALI    0    0.0250    3.1027    0.4293    0.5756   13    0    0    0    0
  15 C2'  C_ALI    0   -0.3070    1.3731    1.7403    0.5780   19   16   17   13    0
  16 H2'  H_ALI    0    0.0810    1.4019    1.6718    1.6635   15    0    0    0   18
  17 H2"  H_ALI    0    0.0810    1.7912    2.6897    0.2499   15    0    0    0   18
  18 Q2'  PSEUD    0    0.0000    1.5965    2.1808    0.9567    0    0    0    0    0
  19 C1'  C_ALI    0    0.3760    0.0000    1.4100    0.0000   21   20   22   15    0
  20 H1'  H_ALI    0    0.0090   -0.0659    1.7932   -1.0183   19    0    0    0    0
  21 O4'  O_EST    0   -0.3680    0.0000    0.0000    0.0000   11   19    0    0    0
  22 N9   N_AMI    0   -0.0420   -1.1209    1.9441    0.8017   19   23   36    0    0
  23 C4   C_ARO    0    0.3910   -2.3784    2.2371    0.3436   22   24   34    0    0
  24 N3   N_AMI    0   -0.7090   -2.8170    2.0867   -0.9370   23   25    0    0    0
  25 C2   C_ARO    0    0.8710   -4.1036    2.4736   -1.0196   24   26   30    0    0
  26 N2   N_AMI    0   -0.7780   -4.7356    2.4092   -2.1892   25   27   28    0    0
  27 H21  H_AMI    0    0.3250   -5.7010    2.6979   -2.2581   26    0    0    0   29
  28 H22  H_AMI    0    0.3390   -4.2498    2.0716   -3.0078   26    0    0    0   29
  29 Q2   PSEUD    0    0.0000   -4.9754    2.3848   -2.6330    0    0    0    0    0
  30 N1   N_AMI    0   -0.7290   -4.9152    2.9484   -0.0482   25   31   32    0    0
  31 H1   H_AMI    0    0.3360   -5.8690    3.2001   -0.2652   30    0    0    0    0
  32 C6   C_ARO    0    0.6900   -4.4155    3.0749    1.2114   30   33   34    0    0
  33 O6   O_BYL    0   -0.4580   -5.1745    3.5092    2.0764   32    0    0    0    0
  34 C5   C_ARO    0   -0.0600   -3.0716    2.6978    1.4177   23   32   35    0    0
  35 N7   N_AMI    0   -0.5430   -2.2897    2.7047    2.5414   34   36    0    0    0
  36 C8   C_ARO    0    0.2660   -1.1186    2.2402    2.1184   22   35   37    0    0
  37 H8   H_ARO    0    0.0460   -0.2357    2.0985    2.7240   36    0    0    0    0
  38 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   39    0    0    0
  39 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   38    0    0    0    0
RESIDUE   RGUA rg   10   39    3   38
   1 ZETA     0    0    0.00      1    2    3    6    0
   2 ALPHA    0    0    0.00      2    3    6    7    0
   3 BETA     0    0    0.00      3    6    7   11    0
   4 GAMMA    0    0    0.00      6    7   11   13    0
   5 DELTA    0    0    0.00      7   11   13   38    0
   6 NU2      0    0    0.00     11   13   15   19   37
   7 HOXI     0    0    0.00     13   15   17   18   18
   8 NU1      0    0    0.00     13   15   19   21   37
   9 CHI      0    0    0.00     21   19   22   23   37
  10 EPSI     0    0    0.00     11   13   38   39    0
   1 C3'  C_ALI    0    0.3030   -0.9681   -5.8551    2.5577    2    0    0    0    0
   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
   7 C5'  C_ALI    0    0.1800    1.4216   -1.4863    1.2135    6    8    9   11    0
   8 H5'  H_ALI    0    0.0080    2.4568   -1.8260    1.2707    7    0    0    0   10
   9 H5"  H_ALI    0    0.0080    1.2157   -0.8907    2.1041    7    0    0    0   10
  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
  11 C4'  C_ALI    0    0.1000    1.2779   -0.5959    0.0000    7   12   13   21    0
  12 H4'  H_ALI    0    0.0610    1.5099   -1.1747   -0.8952   11    0    0    0    0
  13 C3'  C_ALI    0    0.3030    2.1963    0.6228    0.0000   11   14   15   38    0
  14 H3'  H_ALI    0    0.0070    3.1027    0.4293    0.5756   13    0    0    0    0
  15 C2'  C_ALI    0    0.1010    1.3731    1.7403    0.5780   13   16   17   19    0
  16 H2'  H_ALI    0    0.0080    1.4019    1.6718    1.6635   15    0    0    0    0
  17 O2'  O_HYD    0   -0.5460    1.9936    2.8894    0.0464   15   18    0    0    0
  18 HO2' H_OXY    0    0.3240    2.1370    3.5157    0.7597   17    0    0    0    0
  19 C1'  C_ALI    0    0.1170    0.0000    1.4100    0.0000   15   20   21   22    0
  20 H1'  H_ALI    0    0.0540   -0.0659    1.7932   -1.0183   19    0    0    0    0
  21 O4'  O_EST    0   -0.3430    0.0000    0.0000    0.0000   11   19    0    0    0
  22 N9   N_AMI    0   -0.0420   -1.1209    1.9441    0.8017   19   23   36    0    0
  23 C4   C_ARO    0    0.3910   -2.3784    2.2371    0.3436   22   24   34    0    0
  24 N3   N_AMI    0   -0.7090   -2.8170    2.0867   -0.9370   23   25    0    0    0
  25 C2   C_ARO    0    0.8710   -4.1036    2.4736   -1.0196   24   26   30    0    0
  26 N2   N_AMI    0   -0.7780   -4.7356    2.4092   -2.1892   25   27   28    0    0
  27 H21  H_AMI    0    0.3250   -5.7010    2.6979   -2.2581   26    0    0    0   29
  28 H22  H_AMI    0    0.3390   -4.2498    2.0716   -3.0078   26    0    0    0   29
  29 Q2   PSEUD    0    0.0000   -4.9754    2.3848   -2.6330    0    0    0    0    0
  30 N1   N_AMI    0   -0.7290   -4.9152    2.9484   -0.0482   25   31   32    0    0
  31 H1   H_AMI    0    0.3360   -5.8690    3.2001   -0.2652   30    0    0    0    0
  32 C6   C_ARO    0    0.6900   -4.4155    3.0749    1.2114   30   33   34    0    0
  33 O6   O_BYL    0   -0.4580   -5.1745    3.5092    2.0764   32    0    0    0    0
  34 C5   C_ARO    0   -0.0600   -3.0716    2.6978    1.4177   23   32   35    0    0
  35 N7   N_AMI    0   -0.5430   -2.2897    2.7047    2.5414   34   36    0    0    0
  36 C8   C_ARO    0    0.2660   -1.1186    2.2402    2.1184   22   35   37    0    0
  37 H8   H_ARO    0    0.0460   -0.2357    2.0985    2.7240   36    0    0    0    0
  38 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   36   39    0    0    0
  39 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   38    0    0    0    0
RESIDUE   THY  t   10   38    3   37
   1 ZETA     0    0    0.00      1    2    3    6    0
   2 ALPHA    0    0    0.00      2    3    6    7    0
   3 BETA     0    0    0.00      3    6    7   11    0
   4 GAMMA    0    0    0.00      6    7   11   13    0
   5 DELTA    0    0    0.0000    7   11   13   37    0
   6 NU2      0    0    0.0000   11   13   15   19   36
   7 NU1      0    0    0.0000   13   15   19   21   36
   8 CHI      0    0    0.0000   21   19   22   23   36
   9 CHI2     0    0    0.00     27   29   30   31   33
  10 EPSI     0    0    0.00     11   13   37   38    0
   1 C3'  C_ALI    0    0.2330   -0.9681   -5.8551    2.5577    2    0    0    0    0
   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
   7 C5'  C_ALI    0    0.1180    1.4216   -1.4863    1.2135    6    8    9   11    0
   8 H5'  H_ALI    0    0.0210    2.4568   -1.8260    1.2707    7    0    0    0   10
   9 H5"  H_ALI    0    0.0210    1.2157   -0.8907    2.1041    7    0    0    0   10
  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
  11 C4'  C_ALI    0    0.0360    1.2779   -0.5959    0.0000    7   12   21   13    0
  12 H4'  H_ALI    0    0.0560    1.5099   -1.1747   -0.8952   11    0    0    0    0
  13 C3'  C_ALI    0    0.2330    2.1963    0.6228    0.0000   11   15   14   37    0
  14 H3'  H_ALI    0    0.0250    3.1027    0.4293    0.5756   13    0    0    0    0
  15 C2'  C_ALI    0   -0.3070    1.3731    1.7403    0.5780   19   16   17   13    0
  16 H2'  H_ALI    0    0.0810    1.4019    1.6718    1.6635   15    0    0    0   18
  17 H2"  H_ALI    0    0.0810    1.7912    2.6897    0.2499   15    0    0    0   18
  18 Q2'  PSEUD    0    0.0000    1.5965    2.1808    0.9567    0    0    0    0    0
  19 C1'  C_ALI    0    0.3760    0.0000    1.4100    0.0000   21   20   22   15    0
  20 H1'  H_ALI    0    0.0090   -0.0659    1.7932   -1.0183   19    0    0    0    0
  21 O4'  O_EST    0   -0.3680    0.0000    0.0000    0.0000   11   19    0    0    0
  22 N1   N_AMI    0   -0.2170   -1.1209    1.9441    0.8017   19   23   35    0    0
  23 C2   C_ARO    0    0.8490   -2.2881    2.1620    0.1364   22   24   25    0    0
  24 O2   O_BYL    0   -0.4880   -2.4402    1.9414   -1.0548   23    0    0    0    0
  25 N3   N_AMI    0   -0.8510   -3.3338    2.6596    0.8814   23   26   27    0    0
  26 H3   H_AMI    0    0.3550   -4.2250    2.8415    0.4424   25    0    0    0    0
  27 C4   C_ARO    0    0.8090   -3.2471    2.9346    2.2228   25   28   29    0    0
  28 O4   O_BYL    0   -0.4640   -4.2464    3.3768    2.7874   27    0    0    0    0
  29 C5   C_ARO    0   -0.1760   -2.0063    2.6890    2.8681   27   30   35    0    0
  30 C7   C_ALI    0   -0.3820   -1.8531    2.9733    4.3432   29   31   32   33    0
  31 H71  H_ALI    0    0.1140   -0.8409    2.7265    4.6636   30    0    0    0   34
  32 H72  H_ALI    0    0.1140   -2.5641    2.3728    4.9107   30    0    0    0   34
  33 H73  H_ALI    0    0.1140   -2.0420    4.0291    4.5373   30    0    0    0   34
  34 Q7   PSEUD    0    0.0000   -1.8157    3.0428    4.7039    0    0    0    0    0
  35 C6   C_ARO    0    0.0340   -1.0061    2.2067    2.1270   22   29   36    0    0
  36 H6   H_ARO    0    0.1340   -0.0464    2.0062    2.5799   35    0    0    0    0
  37 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   38    0    0    0
  38 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   37    0    0    0    0
RESIDUE   URA  u   10   34    3   33
   1 ZETA     0    0    0.00      1    2    3    6    0
   2 ALPHA    0    0    0.00      2    3    6    7    0
   3 BETA     0    0    0.00      3    6    7   11    0
   4 GAMMA    0    0    0.00      6    7   11   13    0
   5 DELTA    0    0    0.00      7   11   13   33    0
   6 NU2      0    0    0.00     11   13   15   19   32
   7 HOXI     0    0    0.00     13   15   17   18   18
   8 NU1      0    0    0.00     13   15   19   21   32
   9 CHI      0    0    0.00     21   19   22   23   32
  10 EPSI     0    0    0.00     11   13   33   34    0
   1 C3'  C_ALI    0    0.3030   -0.9681   -5.8551    2.5577    2    0    0    0    0
   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
   7 C5'  C_ALI    0    0.1800    1.4216   -1.4863    1.2135    6    8    9   11    0
   8 H5'  H_ALI    0    0.0080    2.4568   -1.8260    1.2707    7    0    0    0   10
   9 H5"  H_ALI    0    0.0080    1.2157   -0.8907    2.1041    7    0    0    0   10
  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
  11 C4'  C_ALI    0    0.1000    1.2779   -0.5959    0.0000    7   12   13   21    0
  12 H4'  H_ALI    0    0.0610    1.5099   -1.1747   -0.8952   11    0    0    0    0
  13 C3'  C_ALI    0    0.3030    2.1963    0.6228    0.0000   11   14   15   33    0
  14 H3'  H_ALI    0    0.0070    3.1027    0.4293    0.5756   13    0    0    0    0
  15 C2'  C_ALI    0    0.1010    1.3731    1.7403    0.5780   13   16   17   19    0
  16 H2'  H_ALI    0    0.0080    1.4019    1.6718    1.6635   15    0    0    0    0
  17 O2'  O_HYD    0   -0.5460    1.9936    2.8894    0.0464   15   18    0    0    0
  18 HO2' H_OXY    0    0.3240    2.1370    3.5157    0.7597   17    0    0    0    0
  19 C1'  C_ALI    0    0.1170    0.0000    1.4100    0.0000   15   20   21   22    0
  20 H1'  H_ALI    0    0.0540   -0.0659    1.7932   -1.0183   19    0    0    0    0
  21 O4'  O_EST    0   -0.3430    0.0000    0.0000    0.0000   11   19    0    0    0
  22 N1   N_AMI    0   -0.1590   -1.1209    1.9441    0.8017   19   23   31    0    0
  23 C2   C_ARO    0    0.7750   -2.2881    2.1620    0.1364   22   24   25    0    0
  24 O2   O_BYL    0   -0.4720   -2.4402    1.9414   -1.0548   23    0    0    0    0
  25 N3   N_AMI    0   -0.7680   -3.3338    2.6596    0.8814   23   26   27    0    0
  26 H3   H_AMI    0    0.3340   -4.2250    2.8415    0.4424   25    0    0    0    0
  27 C4   C_ARO    0    0.8340   -3.2471    2.9346    2.2228   25   28   29    0    0
  28 O4   O_BYL    0   -0.4740   -4.2464    3.3768    2.7874   27    0    0    0    0
  29 C5   C_ARO    0   -0.5290   -2.0063    2.6890    2.8681   27   30   31    0    0
  30 H5   C_ALI    0    0.1460   -1.8967    2.8923    3.9231   29    0    0    0    0
  31 C6   C_ARO    0    0.1600   -1.0061    2.2067    2.1270   22   29   32    0    0
  32 H6   H_ARO    0    0.0980   -0.0464    2.0062    2.5799   31    0    0    0    0
  33 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   34    0    0    0
  34 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   33    0    0    0    0

RESIDUE   PL   PL    1    6    3    5
   1 LB       0    0    0.00      2    3    4    5    0
   1 C    PSEUD    0    0.0000   -0.6824   -1.1357    0.0000    0    0    0    0    0
   2 O    PSEUD    0    0.0000   -0.1723   -2.2550    0.0000    0    0    0    0    0
   3 N    PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   4 Q1   PSEUD    0    0.0000    0.9971   -0.0762    0.0000    0    0    0    0    0
   5 Q2   PSEUD    0    0.0000    1.0733    0.9209    0.0000    0    0    0    0    0
   6 Q3   PSEUD    0    0.0000    2.0704    0.8447    0.0000    0    0    0    0    0
RESIDUE   NL   NL    1    6    3    5
   1 LB       0    0    0.00      2    3    4    5    0
   1 C3'  PSEUD    0    0.0000   -0.9681   -5.8551    2.5577    0    0    0    0    0
   2 O3'  PSEUD    0    0.0000   -0.6348   -4.7127    1.7719    0    0    0    0    0
   3 P    PSEUD    0    0.0000    0.4817   -3.6875    2.2842    0    0    0    0    0
   4 Q1   PSEUD    0    0.0000    0.3487   -3.1324    1.4631    0    0    0    0    0
   5 Q2   PSEUD    0    0.0000    1.0465   -2.4917    1.7833    0    0    0    0    0
   6 Q3   PSEUD    0    0.0000    0.9136   -1.9366    0.9622    0    0    0    0    0
RESIDUE   LL   LL    1    6    3    5
   1 LB       0    0    0.00      2    3    4    5    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
   4 Q1   PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
   5 Q2   PSEUD    0    0.0000    2.0000    0.0000    0.0000    0    0    0    0    0
   6 Q3   PSEUD    0    0.0000    3.0000    0.0000    0.0000    0    0    0    0    0
RESIDUE   LL2  LL2    1    6    3    5
   1 LB       0    0    0.00      2    3    4    5    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    2.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    2.0000    2.0000    0.0000    0    0    0    0    0
   4 Q1   PSEUD    0    0.0000    4.0000    2.0000    0.0000    0    0    0    0    0
   5 Q2   PSEUD    0    0.0000    4.0000    0.0000    0.0000    0    0    0    0    0
   6 Q3   PSEUD    0    0.0000    6.0000    0.0000    0.0000    0    0    0    0    0
RESIDUE   LL5  LL5    1    6    3    5
   1 LB       0    0    0.00      2    3    4    5    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    5.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    5.0000    5.0000    0.0000    0    0    0    0    0
   4 Q1   PSEUD    0    0.0000   10.0000    5.0000    0.0000    0    0    0    0    0
   5 Q2   PSEUD    0    0.0000   10.0000    0.0000    0.0000    0    0    0    0    0
   6 Q3   PSEUD    0    0.0000   15.0000    0.0000    0.0000    0    0    0    0    0
RESIDUE   LP   LP    1    6    3    5
   1 LB       0    0    0.00      2    3    4    5    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
   4 C    PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
   5 O    PSEUD    0    0.0000    2.0000   -0.2300    0.0000    0    0    0    0    0
   6 N    PSEUD    0    0.0000    3.0920    1.7505    0.0000    0    0    0    0    0
RESIDUE   LN   LN    1    6    3    5
   1 LB       0    0    0.00      2    3    4    5    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
   4 C3'  PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
   5 O3'  PSEUD    0    0.0000    2.0000   -0.4260    0.0000    0    0    0    0    0
   6 P    PSEUD    0    0.0000    3.3856   -1.2260    0.0000    0    0    0    0    0

RESIDUE   PLM  PLM    1    8    3    7
   1 LB       0    0    0.00      2    3    4    6    0
   1 C    PSEUD    0    0.0000   -0.6824   -1.1357    0.0000    0    0    0    0    0
   2 O    PSEUD    0    0.0000   -0.1723   -2.2550    0.0000    0    0    0    0    0
   3 N    PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   4 Q1   PSEUD    0    0.0000    0.9971   -0.0762    0.0000    0    0    0    0    0
   5 Q1'  PSEUD    0    0.0000    0.9971   -0.0762   10.0000    0    0    0    0    0
   6 Q2   PSEUD    0    0.0000    1.0733    0.9209    0.0000    0    0    0    0    0
   7 Q2'  PSEUD    0    0.0000    1.0733    0.9209   10.0000    0    0    0    0    0
   8 Q3   PSEUD    0    0.0000    2.0704    0.8447    0.0000    0    0    0    0    0
RESIDUE   NLM  NLM    1    8    3    7
   1 LB       0    0    0.00      2    3    4    6    0
   1 C3'  PSEUD    0    0.0000   -0.9681   -5.8551    2.5577    0    0    0    0    0
   2 O3'  PSEUD    0    0.0000   -0.6348   -4.7127    1.7719    0    0    0    0    0
   3 P    PSEUD    0    0.0000    0.4817   -3.6875    2.2842    0    0    0    0    0
   4 Q1   PSEUD    0    0.0000    0.3487   -3.1324    1.4631    0    0    0    0    0
   5 Q1'  PSEUD    0    0.0000    0.3487   -3.1324   10.0000    0    0    0    0    0
   6 Q2   PSEUD    0    0.0000    1.0465   -2.4917    1.7833    0    0    0    0    0
   7 Q2'  PSEUD    0    0.0000    1.0465   -2.4917   10.0000    0    0    0    0    0
   8 Q3   PSEUD    0    0.0000    0.9136   -1.9366    0.9622    0    0    0    0    0
RESIDUE   LLM  LLM    1    9    3    8
   1 LB       0    0    0.00      2    3    5    7    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
   4 Q3'  PSEUD    0    0.0000    1.0000    1.0000   10.0000    0    0    0    0    0
   5 Q1   PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
   6 Q1'  PSEUD    0    0.0000    2.0000    1.0000   10.0000    0    0    0    0    0
   7 Q2   PSEUD    0    0.0000    2.0000    0.0000    0.0000    0    0    0    0    0
   8 Q2'  PSEUD    0    0.0000    2.0000    0.0000   10.0000    0    0    0    0    0
   9 Q3   PSEUD    0    0.0000    3.0000    0.0000    0.0000    0    0    0    0    0
RESIDUE   LLM2 LLM2    1    9    3    8
   1 LB       0    0    0.00      2    3    5    7    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    2.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    2.0000    2.0000    0.0000    0    0    0    0    0
   4 Q3'  PSEUD    0    0.0000    2.0000    2.0000   10.0000    0    0    0    0    0
   5 Q1   PSEUD    0    0.0000    4.0000    2.0000    0.0000    0    0    0    0    0
   6 Q1'  PSEUD    0    0.0000    4.0000    2.0000   10.0000    0    0    0    0    0
   7 Q2   PSEUD    0    0.0000    4.0000    0.0000    0.0000    0    0    0    0    0
   8 Q2'  PSEUD    0    0.0000    4.0000    0.0000   10.0000    0    0    0    0    0
   9 Q3   PSEUD    0    0.0000    6.0000    0.0000    0.0000    0    0    0    0    0
RESIDUE   LLM5 LLM5    1    9    3    8
   1 LB       0    0    0.00      2    3    5    7    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    5.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    5.0000    5.0000    0.0000    0    0    0    0    0
   4 Q3'  PSEUD    0    0.0000    5.0000    5.0000   10.0000    0    0    0    0    0
   5 Q1   PSEUD    0    0.0000   10.0000    5.0000    0.0000    0    0    0    0    0
   6 Q1'  PSEUD    0    0.0000   10.0000    5.0000   10.0000    0    0    0    0    0
   7 Q2   PSEUD    0    0.0000   10.0000    0.0000    0.0000    0    0    0    0    0
   8 Q2'  PSEUD    0    0.0000   10.0000    0.0000   10.0000    0    0    0    0    0
   9 Q3   PSEUD    0    0.0000   15.0000    0.0000    0.0000    0    0    0    0    0
RESIDUE   LPM  LPM    1    7    3    6
   1 LB       0    0    0.00      2    3    5    6    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
   4 Q3'  PSEUD    0    0.0000    1.0000    1.0000   10.0000    0    0    0    0    0
   5 C    PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
   6 O    PSEUD    0    0.0000    2.0000   -0.2300    0.0000    0    0    0    0    0
   7 N    PSEUD    0    0.0000    3.0920    1.7505    0.0000    0    0    0    0    0
RESIDUE   LNM  LNM    1    7    3    6
   1 LB       0    0    0.00      2    3    5    6    0
   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
   4 Q3'  PSEUD    0    0.0000    1.0000    1.0000   10.0000    0    0    0    0    0
   5 C3'  PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
   6 O3'  PSEUD    0    0.0000    2.0000   -0.4260    0.0000    0    0    0    0    0
   7 P    PSEUD    0    0.0000    3.3856   -1.2260    0.0000    0    0    0    0    0

RESIDUE   LGLY LGLY    3   11    3   10
   1 OMEGA   -1    2   10.0000    2    1    3    4    0
   2 PHI      0    0    0.0000    1    3    5    9    0
   3 PSI      0    0    0.0000    3    5    9   11    0
   1 C    PSEUD    2    8.2024   -0.6824   -1.1357    0.0000    0    0    0    0    0
   2 O    PSEUD    2   -7.0004   -0.1723   -2.2550    0.0000    0    0    0    0    0
   3 N    PSEUD    2   -6.2650    0.0000    0.0000    0.0000    0    0    0    0    0
   4 Q1   PSEUD    0    3.2103   -0.4226    0.9063    0.0000    0    0    0    0    0
   5 Q2   PSEUD    3   -0.1556    1.4530    0.0000    0.0000    0    0    0    0    0
   6 Q21  PSEUD    0    1.0041    1.8202   -0.5343    0.8762    0    0    0    0    0
   7 Q22  PSEUD    0    1.0041    1.8202   -0.5343   -0.8762    0    0    0    0    0
   8 Q3   PSEUD    0    0.0000    1.8202   -0.5343    0.0000    0    0    0    0    0
   9 C    PSEUD    2    8.2024    2.0013    1.4284    0.0000    0    0    0    0    0
  10 O    PSEUD    2   -7.0004    1.2356    2.3910    0.0000    0    0    0    0    0
  11 N    PSEUD    2   -6.4912    3.3231    1.5208    0.0000    0    0    0    0    0
"""

at = dict(
          H = '1H',
          Q = '1H',
          M = '1H',
          C = '13C',
          N = '15N',
          O = '16O',
          S = '32S',
          P = '31P'
         )


#-----------------------------------------------------------------------
# create the residue definitions from atomTable.def
#-----------------------------------------------------------------------

residueDefs = MolDef( name='residueDefs' )

for r in AwkLike( 'atomTable.def' ):
#    print '>', doresidue,'<',r.dollar[0]
    if (r.isComment() or r.isEmpty()):
        pass
    elif (r.dollar[1] == 'RESIDUE'):
#       Too many positional arguments for function call # pylint: disable=E1121
        res = residueDefs.appendResidueDef( r.dollar[2], r.dollar[3] )
    elif (r.dollar[1] == 'END_RESIDUE'):
        pass
    else:
        aname = r.dollar[1]
        res.appendAtom( aname, spinType = at[aname[0]] )
# now update the table using the internal routine
residueDefs.importNameDefs( 'atomTable.def' )

#-----------------------------------------------------------------------
# parse the cyanaLib file for topology and dihedral info
#-----------------------------------------------------------------------
for r in AwkLikeS( cyanaLib ):
    if ((not r.isComment()) and r.NF == 7 and r.dollar[1] == 'RESIDUE'):
        resname = r.dollar[2]
        shortName = r.dollar[3]
        if resname in residueDefs:
            res = residueDefs[resname]
            ndihed = r.int(4)
            natom = r.int(5)
            astart = r.int(6)
            astop = r.int(7)
            # temporarily store data from the dihedrals lines
            tmp2 = {}
            for i in range(0, ndihed):
                r.next()
                tmp2[r.dollar[2]] = [r.int(6), r.int(7), r.int(8), r.int(9)]

            # print '>>>', tmp2

            # temporarily store data from the atom lines
            tmp = {}
            for i in range(0, natom):
                r.next()
                idx = r.int(1)
                aname = r.dollar[2]
                tmp[idx] = (idx, aname, r.dollar[3], [r.int(9), r.int(10), r.int(11),r.int(12)], r.int(13) )

            # process the dihedral lines
            for name, atoms in tmp2.iteritems():
                dihedralDef = []
                for a in atoms:
                    if a==0:
                        pass
                    elif a<astart:
                        dihedralDef.append( (-1,tmp[a][1]) )
                    elif a>astop:
                        dihedralDef.append( ( 1,tmp[a][1]) )
                    else:
                        dihedralDef.append( ( 0,tmp[a][1]) )
                res.appendDihedral( name, atoms=dihedralDef )

            # process the atom lines
            for idx, aname, type, topol, pseudo in tmp.itervalues():
                if idx >= astart and idx <= astop and (aname in res):
                    #print idx, atm, topol
                    atm = res[aname]
                    atm.type = type
                    for t in topol:
                        if t==0:
                            pass
                        elif t<astart:
                            atm.topology.append( (-1,tmp[t][1]) )
                        elif t>astop:
                            atm.topology.append( (1,tmp[t][1]) )
                        else:
                            atm.topology.append( (0,tmp[t][1]) )

                    if pseudo==0:
                        pass
                    else:
                        pseudoName = tmp[pseudo][1]
                        atm.pseudo = pseudoName
                        res[pseudoName].real.append( aname )



def saveDefs( stream = sys.stdout ):

    fprintf( stream, 'from NTutils   import *\n')
    fprintf( stream, 'from classes   import *\n')
    fprintf( stream, 'from constants import *\n\n')

    residueDefs.printit()
#        residueDefs[key].printit( stream )
#-----------------------------------------------------------------------
# main
#-----------------------------------------------------------------------

if __name__ == '__main__':
#    residueDefs['GLU'].printAttr()
#    for aname in residueDefs.GLU.atoms:
#        residueDefs.GLU[aname].printAttr()


#    residueDefs['GLU'].printit()

#    residueDefs.VAL.printit()
    saveDefs()