{-# LANGUAGE MagicHash, UnboxedTuples, ExtendedLiterals #-}
import GHC.Int
import GHC.Prim

test :: (Int, Int, Int, Int) -> (Int32X4# -> Int32X4# -> Int32X4#) -> IO ()
test t shuffle = do
  let a = packInt32X4# (# 0#Int32, 11#Int32, 22#Int32, 33#Int32 #)
      b = packInt32X4# (# 44#Int32, 55#Int32, 66#Int32, 77#Int32 #)
      c = shuffle a b
      (# x0, x1, x2, x3 #) = unpackInt32X4# c
  putStrLn $ show t ++ ": " ++ show (I32# x0, I32# x1, I32# x2, I32# x3)
{-# NOINLINE test #-}

test0x :: (Int, Int, Int, Int) -> (Int32X4# -> Int32X4#) -> IO ()
test0x t shuffle = do
  let b = packInt32X4# (# 104#Int32, 105#Int32, 106#Int32, 107#Int32 #)
      c = shuffle b
      (# x0, x1, x2, x3 #) = unpackInt32X4# c
  putStrLn $ show t ++ ": " ++ show (I32# x0, I32# x1, I32# x2, I32# x3)
{-# NOINLINE test0x #-}

testx0 :: (Int, Int, Int, Int) -> (Int32X4# -> Int32X4#) -> IO ()
testx0 t shuffle = do
  let a = packInt32X4# (# 100#Int32, 101#Int32, 102#Int32, 103#Int32 #)
      c = shuffle a
      (# x0, x1, x2, x3 #) = unpackInt32X4# c
  putStrLn $ show t ++ ": " ++ show (I32# x0, I32# x1, I32# x2, I32# x3)
{-# NOINLINE testx0 #-}

main :: IO ()
main = do
  test (0, 0, 0, 0) $ \a b -> shuffleInt32X4# a b (# 0#, 0#, 0#, 0# #)
  test (0, 1, 2, 3) $ \a b -> shuffleInt32X4# a b (# 0#, 1#, 2#, 3# #)
  test (0, 1, 3, 2) $ \a b -> shuffleInt32X4# a b (# 0#, 1#, 3#, 2# #)
  test (0, 1, 4, 5) $ \a b -> shuffleInt32X4# a b (# 0#, 1#, 4#, 5# #)
  test (0, 1, 5, 4) $ \a b -> shuffleInt32X4# a b (# 0#, 1#, 5#, 4# #)
  test (0, 2, 0, 6) $ \a b -> shuffleInt32X4# a b (# 0#, 2#, 0#, 6# #)
  test (0, 2, 1, 3) $ \a b -> shuffleInt32X4# a b (# 0#, 2#, 1#, 3# #)
  test (0, 2, 1, 7) $ \a b -> shuffleInt32X4# a b (# 0#, 2#, 1#, 7# #)
  test (0, 2, 3, 1) $ \a b -> shuffleInt32X4# a b (# 0#, 2#, 3#, 1# #)
  test (0, 2, 4, 6) $ \a b -> shuffleInt32X4# a b (# 0#, 2#, 4#, 6# #)
  test (0, 2, 6, 4) $ \a b -> shuffleInt32X4# a b (# 0#, 2#, 6#, 4# #)
  test (0, 2, 7, 6) $ \a b -> shuffleInt32X4# a b (# 0#, 2#, 7#, 6# #)
  test (0, 3, 0, 5) $ \a b -> shuffleInt32X4# a b (# 0#, 3#, 0#, 5# #)
  test (0, 3, 1, 2) $ \a b -> shuffleInt32X4# a b (# 0#, 3#, 1#, 2# #)
  test (0, 3, 2, 1) $ \a b -> shuffleInt32X4# a b (# 0#, 3#, 2#, 1# #)
  test (0, 4, 0, 4) $ \a b -> shuffleInt32X4# a b (# 0#, 4#, 0#, 4# #)
  test (0, 4, 1, 5) $ \a b -> shuffleInt32X4# a b (# 0#, 4#, 1#, 5# #)
  test (0, 4, 1, 6) $ \a b -> shuffleInt32X4# a b (# 0#, 4#, 1#, 6# #)
  test (0, 4, 2, 6) $ \a b -> shuffleInt32X4# a b (# 0#, 4#, 2#, 6# #)
  test (0, 4, 5, 1) $ \a b -> shuffleInt32X4# a b (# 0#, 4#, 5#, 1# #)
  test (0, 4, 5, 3) $ \a b -> shuffleInt32X4# a b (# 0#, 4#, 5#, 3# #)
  test (0, 4, 6, 2) $ \a b -> shuffleInt32X4# a b (# 0#, 4#, 6#, 2# #)
  test (0, 4, 7, 5) $ \a b -> shuffleInt32X4# a b (# 0#, 4#, 7#, 5# #)
  test (0, 5, 1, 4) $ \a b -> shuffleInt32X4# a b (# 0#, 5#, 1#, 4# #)
  test (0, 5, 4, 1) $ \a b -> shuffleInt32X4# a b (# 0#, 5#, 4#, 1# #)
  test (0, 5, 5, 1) $ \a b -> shuffleInt32X4# a b (# 0#, 5#, 5#, 1# #)
  test (0, 5, 6, 1) $ \a b -> shuffleInt32X4# a b (# 0#, 5#, 6#, 1# #)
  test (0, 5, 6, 3) $ \a b -> shuffleInt32X4# a b (# 0#, 5#, 6#, 3# #)
  test (0, 6, 2, 4) $ \a b -> shuffleInt32X4# a b (# 0#, 6#, 2#, 4# #)
  test (0, 6, 3, 6) $ \a b -> shuffleInt32X4# a b (# 0#, 6#, 3#, 6# #)
  test (0, 6, 4, 2) $ \a b -> shuffleInt32X4# a b (# 0#, 6#, 4#, 2# #)
  test (0, 6, 4, 3) $ \a b -> shuffleInt32X4# a b (# 0#, 6#, 4#, 3# #)
  test (0, 6, 5, 1) $ \a b -> shuffleInt32X4# a b (# 0#, 6#, 5#, 1# #)
  test (0, 6, 6, 5) $ \a b -> shuffleInt32X4# a b (# 0#, 6#, 6#, 5# #)
  test (0, 7, 6, 6) $ \a b -> shuffleInt32X4# a b (# 0#, 7#, 6#, 6# #)
  test (0, 7, 7, 7) $ \a b -> shuffleInt32X4# a b (# 0#, 7#, 7#, 7# #)
  test (1, 0, 2, 2) $ \a b -> shuffleInt32X4# a b (# 1#, 0#, 2#, 2# #)
  test (1, 0, 2, 3) $ \a b -> shuffleInt32X4# a b (# 1#, 0#, 2#, 3# #)
  test (1, 0, 2, 6) $ \a b -> shuffleInt32X4# a b (# 1#, 0#, 2#, 6# #)
  test (1, 0, 3, 2) $ \a b -> shuffleInt32X4# a b (# 1#, 0#, 3#, 2# #)
  test (1, 0, 4, 5) $ \a b -> shuffleInt32X4# a b (# 1#, 0#, 4#, 5# #)
  test (1, 0, 5, 4) $ \a b -> shuffleInt32X4# a b (# 1#, 0#, 5#, 4# #)
  test (1, 1, 1, 1) $ \a b -> shuffleInt32X4# a b (# 1#, 1#, 1#, 1# #)
  test (1, 1, 7, 3) $ \a b -> shuffleInt32X4# a b (# 1#, 1#, 7#, 3# #)
  test (1, 2, 0, 3) $ \a b -> shuffleInt32X4# a b (# 1#, 2#, 0#, 3# #)
  test (1, 2, 3, 0) $ \a b -> shuffleInt32X4# a b (# 1#, 2#, 3#, 0# #)
  test (1, 2, 3, 4) $ \a b -> shuffleInt32X4# a b (# 1#, 2#, 3#, 4# #)
  test (1, 3, 0, 2) $ \a b -> shuffleInt32X4# a b (# 1#, 3#, 0#, 2# #)
  test (1, 3, 2, 0) $ \a b -> shuffleInt32X4# a b (# 1#, 3#, 2#, 0# #)
  test (1, 3, 3, 1) $ \a b -> shuffleInt32X4# a b (# 1#, 3#, 3#, 1# #)
  test (1, 3, 4, 4) $ \a b -> shuffleInt32X4# a b (# 1#, 3#, 4#, 4# #)
  test (1, 3, 5, 7) $ \a b -> shuffleInt32X4# a b (# 1#, 3#, 5#, 7# #)
  test (1, 3, 6, 6) $ \a b -> shuffleInt32X4# a b (# 1#, 3#, 6#, 6# #)
  test (1, 3, 7, 5) $ \a b -> shuffleInt32X4# a b (# 1#, 3#, 7#, 5# #)
  test (1, 4, 0, 5) $ \a b -> shuffleInt32X4# a b (# 1#, 4#, 0#, 5# #)
  test (1, 4, 2, 1) $ \a b -> shuffleInt32X4# a b (# 1#, 4#, 2#, 1# #)
  test (1, 4, 3, 5) $ \a b -> shuffleInt32X4# a b (# 1#, 4#, 3#, 5# #)
  test (1, 4, 5, 0) $ \a b -> shuffleInt32X4# a b (# 1#, 4#, 5#, 0# #)
  test (1, 4, 7, 4) $ \a b -> shuffleInt32X4# a b (# 1#, 4#, 7#, 4# #)
  test (1, 5, 0, 4) $ \a b -> shuffleInt32X4# a b (# 1#, 5#, 0#, 4# #)
  test (1, 5, 1, 1) $ \a b -> shuffleInt32X4# a b (# 1#, 5#, 1#, 1# #)
  test (1, 5, 3, 7) $ \a b -> shuffleInt32X4# a b (# 1#, 5#, 3#, 7# #)
  test (1, 5, 4, 0) $ \a b -> shuffleInt32X4# a b (# 1#, 5#, 4#, 0# #)
  test (1, 5, 6, 4) $ \a b -> shuffleInt32X4# a b (# 1#, 5#, 6#, 4# #)
  test (1, 5, 7, 3) $ \a b -> shuffleInt32X4# a b (# 1#, 5#, 7#, 3# #)
  test (1, 6, 0, 2) $ \a b -> shuffleInt32X4# a b (# 1#, 6#, 0#, 2# #)
  test (1, 6, 5, 0) $ \a b -> shuffleInt32X4# a b (# 1#, 6#, 5#, 0# #)
  test (1, 7, 0, 2) $ \a b -> shuffleInt32X4# a b (# 1#, 7#, 0#, 2# #)
  test (1, 7, 2, 6) $ \a b -> shuffleInt32X4# a b (# 1#, 7#, 2#, 6# #)
  test (1, 7, 3, 5) $ \a b -> shuffleInt32X4# a b (# 1#, 7#, 3#, 5# #)
  test (1, 7, 5, 3) $ \a b -> shuffleInt32X4# a b (# 1#, 7#, 5#, 3# #)
  test (1, 7, 7, 7) $ \a b -> shuffleInt32X4# a b (# 1#, 7#, 7#, 7# #)
  test (2, 0, 1, 3) $ \a b -> shuffleInt32X4# a b (# 2#, 0#, 1#, 3# #)
  test (2, 0, 3, 1) $ \a b -> shuffleInt32X4# a b (# 2#, 0#, 3#, 1# #)
  test (2, 0, 4, 6) $ \a b -> shuffleInt32X4# a b (# 2#, 0#, 4#, 6# #)
  test (2, 0, 6, 4) $ \a b -> shuffleInt32X4# a b (# 2#, 0#, 6#, 4# #)
  test (2, 1, 0, 1) $ \a b -> shuffleInt32X4# a b (# 2#, 1#, 0#, 1# #)
  test (2, 1, 0, 3) $ \a b -> shuffleInt32X4# a b (# 2#, 1#, 0#, 3# #)
  test (2, 1, 2, 2) $ \a b -> shuffleInt32X4# a b (# 2#, 1#, 2#, 2# #)
  test (2, 1, 3, 0) $ \a b -> shuffleInt32X4# a b (# 2#, 1#, 3#, 0# #)
  test (2, 1, 5, 3) $ \a b -> shuffleInt32X4# a b (# 2#, 1#, 5#, 3# #)
  test (2, 2, 2, 2) $ \a b -> shuffleInt32X4# a b (# 2#, 2#, 2#, 2# #)
  test (2, 2, 3, 7) $ \a b -> shuffleInt32X4# a b (# 2#, 2#, 3#, 7# #)
  test (2, 2, 5, 0) $ \a b -> shuffleInt32X4# a b (# 2#, 2#, 5#, 0# #)
  test (2, 3, 0, 1) $ \a b -> shuffleInt32X4# a b (# 2#, 3#, 0#, 1# #)
  test (2, 3, 1, 0) $ \a b -> shuffleInt32X4# a b (# 2#, 3#, 1#, 0# #)
  test (2, 3, 4, 5) $ \a b -> shuffleInt32X4# a b (# 2#, 3#, 4#, 5# #)
  test (2, 3, 6, 7) $ \a b -> shuffleInt32X4# a b (# 2#, 3#, 6#, 7# #)
  test (2, 3, 7, 0) $ \a b -> shuffleInt32X4# a b (# 2#, 3#, 7#, 0# #)
  test (2, 3, 7, 6) $ \a b -> shuffleInt32X4# a b (# 2#, 3#, 7#, 6# #)
  test (2, 4, 0, 6) $ \a b -> shuffleInt32X4# a b (# 2#, 4#, 0#, 6# #)
  test (2, 4, 3, 6) $ \a b -> shuffleInt32X4# a b (# 2#, 4#, 3#, 6# #)
  test (2, 4, 5, 2) $ \a b -> shuffleInt32X4# a b (# 2#, 4#, 5#, 2# #)
  test (2, 4, 6, 0) $ \a b -> shuffleInt32X4# a b (# 2#, 4#, 6#, 0# #)
  test (2, 4, 7, 1) $ \a b -> shuffleInt32X4# a b (# 2#, 4#, 7#, 1# #)
  test (2, 5, 6, 0) $ \a b -> shuffleInt32X4# a b (# 2#, 5#, 6#, 0# #)
  test (2, 6, 0, 4) $ \a b -> shuffleInt32X4# a b (# 2#, 6#, 0#, 4# #)
  test (2, 6, 3, 7) $ \a b -> shuffleInt32X4# a b (# 2#, 6#, 3#, 7# #)
  test (2, 6, 4, 0) $ \a b -> shuffleInt32X4# a b (# 2#, 6#, 4#, 0# #)
  test (2, 6, 5, 3) $ \a b -> shuffleInt32X4# a b (# 2#, 6#, 5#, 3# #)
  test (2, 6, 7, 3) $ \a b -> shuffleInt32X4# a b (# 2#, 6#, 7#, 3# #)
  test (2, 7, 3, 6) $ \a b -> shuffleInt32X4# a b (# 2#, 7#, 3#, 6# #)
  test (2, 7, 6, 3) $ \a b -> shuffleInt32X4# a b (# 2#, 7#, 6#, 3# #)
  test (3, 0, 1, 2) $ \a b -> shuffleInt32X4# a b (# 3#, 0#, 1#, 2# #)
  test (3, 0, 2, 1) $ \a b -> shuffleInt32X4# a b (# 3#, 0#, 2#, 1# #)
  test (3, 0, 2, 4) $ \a b -> shuffleInt32X4# a b (# 3#, 0#, 2#, 4# #)
  test (3, 0, 4, 4) $ \a b -> shuffleInt32X4# a b (# 3#, 0#, 4#, 4# #)
  test (3, 1, 0, 2) $ \a b -> shuffleInt32X4# a b (# 3#, 1#, 0#, 2# #)
  test (3, 1, 0, 4) $ \a b -> shuffleInt32X4# a b (# 3#, 1#, 0#, 4# #)
  test (3, 1, 2, 0) $ \a b -> shuffleInt32X4# a b (# 3#, 1#, 2#, 0# #)
  test (3, 1, 5, 7) $ \a b -> shuffleInt32X4# a b (# 3#, 1#, 5#, 7# #)
  test (3, 1, 7, 5) $ \a b -> shuffleInt32X4# a b (# 3#, 1#, 7#, 5# #)
  test (3, 2, 0, 1) $ \a b -> shuffleInt32X4# a b (# 3#, 2#, 0#, 1# #)
  test (3, 2, 1, 0) $ \a b -> shuffleInt32X4# a b (# 3#, 2#, 1#, 0# #)
  test (3, 2, 2, 5) $ \a b -> shuffleInt32X4# a b (# 3#, 2#, 2#, 5# #)
  test (3, 2, 3, 5) $ \a b -> shuffleInt32X4# a b (# 3#, 2#, 3#, 5# #)
  test (3, 2, 6, 7) $ \a b -> shuffleInt32X4# a b (# 3#, 2#, 6#, 7# #)
  test (3, 2, 7, 6) $ \a b -> shuffleInt32X4# a b (# 3#, 2#, 7#, 6# #)
  test (3, 3, 2, 0) $ \a b -> shuffleInt32X4# a b (# 3#, 3#, 2#, 0# #)
  test (3, 3, 3, 3) $ \a b -> shuffleInt32X4# a b (# 3#, 3#, 3#, 3# #)
  test (3, 3, 6, 7) $ \a b -> shuffleInt32X4# a b (# 3#, 3#, 6#, 7# #)
  test (3, 4, 5, 6) $ \a b -> shuffleInt32X4# a b (# 3#, 4#, 5#, 6# #)
  test (3, 5, 1, 3) $ \a b -> shuffleInt32X4# a b (# 3#, 5#, 1#, 3# #)
  test (3, 5, 1, 7) $ \a b -> shuffleInt32X4# a b (# 3#, 5#, 1#, 7# #)
  test (3, 5, 2, 7) $ \a b -> shuffleInt32X4# a b (# 3#, 5#, 2#, 7# #)
  test (3, 5, 6, 1) $ \a b -> shuffleInt32X4# a b (# 3#, 5#, 6#, 1# #)
  test (3, 5, 7, 1) $ \a b -> shuffleInt32X4# a b (# 3#, 5#, 7#, 1# #)
  test (3, 6, 2, 7) $ \a b -> shuffleInt32X4# a b (# 3#, 6#, 2#, 7# #)
  test (3, 6, 7, 2) $ \a b -> shuffleInt32X4# a b (# 3#, 6#, 7#, 2# #)
  test (3, 7, 1, 5) $ \a b -> shuffleInt32X4# a b (# 3#, 7#, 1#, 5# #)
  test (3, 7, 2, 6) $ \a b -> shuffleInt32X4# a b (# 3#, 7#, 2#, 6# #)
  test (3, 7, 4, 1) $ \a b -> shuffleInt32X4# a b (# 3#, 7#, 4#, 1# #)
  test (3, 7, 4, 2) $ \a b -> shuffleInt32X4# a b (# 3#, 7#, 4#, 2# #)
  test (3, 7, 5, 1) $ \a b -> shuffleInt32X4# a b (# 3#, 7#, 5#, 1# #)
  test (3, 7, 6, 2) $ \a b -> shuffleInt32X4# a b (# 3#, 7#, 6#, 2# #)
  test (4, 0, 0, 3) $ \a b -> shuffleInt32X4# a b (# 4#, 0#, 0#, 3# #)
  test (4, 0, 1, 5) $ \a b -> shuffleInt32X4# a b (# 4#, 0#, 1#, 5# #)
  test (4, 0, 2, 5) $ \a b -> shuffleInt32X4# a b (# 4#, 0#, 2#, 5# #)
  test (4, 0, 2, 6) $ \a b -> shuffleInt32X4# a b (# 4#, 0#, 2#, 6# #)
  test (4, 0, 5, 1) $ \a b -> shuffleInt32X4# a b (# 4#, 0#, 5#, 1# #)
  test (4, 0, 5, 7) $ \a b -> shuffleInt32X4# a b (# 4#, 0#, 5#, 7# #)
  test (4, 0, 6, 2) $ \a b -> shuffleInt32X4# a b (# 4#, 0#, 6#, 2# #)
  test (4, 1, 0, 1) $ \a b -> shuffleInt32X4# a b (# 4#, 1#, 0#, 1# #)
  test (4, 1, 0, 5) $ \a b -> shuffleInt32X4# a b (# 4#, 1#, 0#, 5# #)
  test (4, 1, 2, 3) $ \a b -> shuffleInt32X4# a b (# 4#, 1#, 2#, 3# #)
  test (4, 1, 2, 7) $ \a b -> shuffleInt32X4# a b (# 4#, 1#, 2#, 7# #)
  test (4, 1, 5, 0) $ \a b -> shuffleInt32X4# a b (# 4#, 1#, 5#, 0# #)
  test (4, 1, 6, 3) $ \a b -> shuffleInt32X4# a b (# 4#, 1#, 6#, 3# #)
  test (4, 1, 6, 7) $ \a b -> shuffleInt32X4# a b (# 4#, 1#, 6#, 7# #)
  test (4, 2, 0, 6) $ \a b -> shuffleInt32X4# a b (# 4#, 2#, 0#, 6# #)
  test (4, 2, 6, 0) $ \a b -> shuffleInt32X4# a b (# 4#, 2#, 6#, 0# #)
  test (4, 4, 2, 2) $ \a b -> shuffleInt32X4# a b (# 4#, 4#, 2#, 2# #)
  test (4, 4, 3, 3) $ \a b -> shuffleInt32X4# a b (# 4#, 4#, 3#, 3# #)
  test (4, 4, 4, 4) $ \a b -> shuffleInt32X4# a b (# 4#, 4#, 4#, 4# #)
  test (4, 5, 0, 1) $ \a b -> shuffleInt32X4# a b (# 4#, 5#, 0#, 1# #)
  test (4, 5, 1, 0) $ \a b -> shuffleInt32X4# a b (# 4#, 5#, 1#, 0# #)
  test (4, 5, 6, 3) $ \a b -> shuffleInt32X4# a b (# 4#, 5#, 6#, 3# #)
  test (4, 5, 6, 7) $ \a b -> shuffleInt32X4# a b (# 4#, 5#, 6#, 7# #)
  test (4, 5, 7, 2) $ \a b -> shuffleInt32X4# a b (# 4#, 5#, 7#, 2# #)
  test (4, 5, 7, 6) $ \a b -> shuffleInt32X4# a b (# 4#, 5#, 7#, 6# #)
  test (4, 6, 0, 2) $ \a b -> shuffleInt32X4# a b (# 4#, 6#, 0#, 2# #)
  test (4, 6, 2, 0) $ \a b -> shuffleInt32X4# a b (# 4#, 6#, 2#, 0# #)
  test (4, 6, 4, 3) $ \a b -> shuffleInt32X4# a b (# 4#, 6#, 4#, 3# #)
  test (4, 6, 5, 7) $ \a b -> shuffleInt32X4# a b (# 4#, 6#, 5#, 7# #)
  test (4, 6, 7, 5) $ \a b -> shuffleInt32X4# a b (# 4#, 6#, 7#, 5# #)
  test (4, 7, 5, 6) $ \a b -> shuffleInt32X4# a b (# 4#, 7#, 5#, 6# #)
  test (4, 7, 6, 5) $ \a b -> shuffleInt32X4# a b (# 4#, 7#, 6#, 5# #)
  test (4, 7, 7, 4) $ \a b -> shuffleInt32X4# a b (# 4#, 7#, 7#, 4# #)
  test (4, 7, 7, 7) $ \a b -> shuffleInt32X4# a b (# 4#, 7#, 7#, 7# #)
  test (5, 0, 1, 4) $ \a b -> shuffleInt32X4# a b (# 5#, 0#, 1#, 4# #)
  test (5, 0, 4, 1) $ \a b -> shuffleInt32X4# a b (# 5#, 0#, 4#, 1# #)
  test (5, 0, 4, 3) $ \a b -> shuffleInt32X4# a b (# 5#, 0#, 4#, 3# #)
  test (5, 1, 0, 4) $ \a b -> shuffleInt32X4# a b (# 5#, 1#, 0#, 4# #)
  test (5, 1, 3, 7) $ \a b -> shuffleInt32X4# a b (# 5#, 1#, 3#, 7# #)
  test (5, 1, 4, 0) $ \a b -> shuffleInt32X4# a b (# 5#, 1#, 4#, 0# #)
  test (5, 1, 7, 3) $ \a b -> shuffleInt32X4# a b (# 5#, 1#, 7#, 3# #)
  test (5, 2, 0, 2) $ \a b -> shuffleInt32X4# a b (# 5#, 2#, 0#, 2# #)
  test (5, 2, 3, 3) $ \a b -> shuffleInt32X4# a b (# 5#, 2#, 3#, 3# #)
  test (5, 2, 6, 3) $ \a b -> shuffleInt32X4# a b (# 5#, 2#, 6#, 3# #)
  test (5, 2, 7, 5) $ \a b -> shuffleInt32X4# a b (# 5#, 2#, 7#, 5# #)
  test (5, 3, 1, 7) $ \a b -> shuffleInt32X4# a b (# 5#, 3#, 1#, 7# #)
  test (5, 3, 7, 1) $ \a b -> shuffleInt32X4# a b (# 5#, 3#, 7#, 1# #)
  test (5, 4, 0, 1) $ \a b -> shuffleInt32X4# a b (# 5#, 4#, 0#, 1# #)
  test (5, 4, 1, 0) $ \a b -> shuffleInt32X4# a b (# 5#, 4#, 1#, 0# #)
  test (5, 4, 2, 5) $ \a b -> shuffleInt32X4# a b (# 5#, 4#, 2#, 5# #)
  test (5, 4, 6, 7) $ \a b -> shuffleInt32X4# a b (# 5#, 4#, 6#, 7# #)
  test (5, 4, 7, 6) $ \a b -> shuffleInt32X4# a b (# 5#, 4#, 7#, 6# #)
  test (5, 5, 5, 5) $ \a b -> shuffleInt32X4# a b (# 5#, 5#, 5#, 5# #)
  test (5, 6, 1, 2) $ \a b -> shuffleInt32X4# a b (# 5#, 6#, 1#, 2# #)
  test (5, 6, 4, 7) $ \a b -> shuffleInt32X4# a b (# 5#, 6#, 4#, 7# #)
  test (5, 6, 6, 3) $ \a b -> shuffleInt32X4# a b (# 5#, 6#, 6#, 3# #)
  test (5, 6, 7, 0) $ \a b -> shuffleInt32X4# a b (# 5#, 6#, 7#, 0# #)
  test (5, 6, 7, 4) $ \a b -> shuffleInt32X4# a b (# 5#, 6#, 7#, 4# #)
  test (5, 7, 1, 3) $ \a b -> shuffleInt32X4# a b (# 5#, 7#, 1#, 3# #)
  test (5, 7, 2, 1) $ \a b -> shuffleInt32X4# a b (# 5#, 7#, 2#, 1# #)
  test (5, 7, 3, 1) $ \a b -> shuffleInt32X4# a b (# 5#, 7#, 3#, 1# #)
  test (5, 7, 4, 6) $ \a b -> shuffleInt32X4# a b (# 5#, 7#, 4#, 6# #)
  test (5, 7, 6, 4) $ \a b -> shuffleInt32X4# a b (# 5#, 7#, 6#, 4# #)
  test (5, 7, 6, 5) $ \a b -> shuffleInt32X4# a b (# 5#, 7#, 6#, 5# #)
  test (6, 0, 2, 4) $ \a b -> shuffleInt32X4# a b (# 6#, 0#, 2#, 4# #)
  test (6, 0, 4, 2) $ \a b -> shuffleInt32X4# a b (# 6#, 0#, 4#, 2# #)
  test (6, 0, 7, 7) $ \a b -> shuffleInt32X4# a b (# 6#, 0#, 7#, 7# #)
  test (6, 1, 0, 1) $ \a b -> shuffleInt32X4# a b (# 6#, 1#, 0#, 1# #)
  test (6, 1, 6, 4) $ \a b -> shuffleInt32X4# a b (# 6#, 1#, 6#, 4# #)
  test (6, 2, 0, 4) $ \a b -> shuffleInt32X4# a b (# 6#, 2#, 0#, 4# #)
  test (6, 2, 3, 2) $ \a b -> shuffleInt32X4# a b (# 6#, 2#, 3#, 2# #)
  test (6, 2, 3, 7) $ \a b -> shuffleInt32X4# a b (# 6#, 2#, 3#, 7# #)
  test (6, 2, 4, 0) $ \a b -> shuffleInt32X4# a b (# 6#, 2#, 4#, 0# #)
  test (6, 2, 7, 3) $ \a b -> shuffleInt32X4# a b (# 6#, 2#, 7#, 3# #)
  test (6, 3, 1, 3) $ \a b -> shuffleInt32X4# a b (# 6#, 3#, 1#, 3# #)
  test (6, 3, 2, 7) $ \a b -> shuffleInt32X4# a b (# 6#, 3#, 2#, 7# #)
  test (6, 3, 3, 2) $ \a b -> shuffleInt32X4# a b (# 6#, 3#, 3#, 2# #)
  test (6, 3, 4, 4) $ \a b -> shuffleInt32X4# a b (# 6#, 3#, 4#, 4# #)
  test (6, 3, 7, 2) $ \a b -> shuffleInt32X4# a b (# 6#, 3#, 7#, 2# #)
  test (6, 4, 0, 2) $ \a b -> shuffleInt32X4# a b (# 6#, 4#, 0#, 2# #)
  test (6, 4, 2, 0) $ \a b -> shuffleInt32X4# a b (# 6#, 4#, 2#, 0# #)
  test (6, 4, 5, 7) $ \a b -> shuffleInt32X4# a b (# 6#, 4#, 5#, 7# #)
  test (6, 4, 7, 5) $ \a b -> shuffleInt32X4# a b (# 6#, 4#, 7#, 5# #)
  test (6, 5, 4, 7) $ \a b -> shuffleInt32X4# a b (# 6#, 5#, 4#, 7# #)
  test (6, 5, 7, 4) $ \a b -> shuffleInt32X4# a b (# 6#, 5#, 7#, 4# #)
  test (6, 6, 5, 7) $ \a b -> shuffleInt32X4# a b (# 6#, 6#, 5#, 7# #)
  test (6, 6, 6, 6) $ \a b -> shuffleInt32X4# a b (# 6#, 6#, 6#, 6# #)
  test (6, 7, 0, 1) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 0#, 1# #)
  test (6, 7, 2, 3) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 2#, 3# #)
  test (6, 7, 3, 0) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 3#, 0# #)
  test (6, 7, 3, 2) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 3#, 2# #)
  test (6, 7, 4, 5) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 4#, 5# #)
  test (6, 7, 5, 3) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 5#, 3# #)
  test (6, 7, 5, 4) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 5#, 4# #)
  test (6, 7, 6, 7) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 6#, 7# #)
  test (6, 7, 7, 1) $ \a b -> shuffleInt32X4# a b (# 6#, 7#, 7#, 1# #)
  test (7, 0, 1, 1) $ \a b -> shuffleInt32X4# a b (# 7#, 0#, 1#, 1# #)
  test (7, 0, 1, 2) $ \a b -> shuffleInt32X4# a b (# 7#, 0#, 1#, 2# #)
  test (7, 1, 2, 0) $ \a b -> shuffleInt32X4# a b (# 7#, 1#, 2#, 0# #)
  test (7, 1, 2, 4) $ \a b -> shuffleInt32X4# a b (# 7#, 1#, 2#, 4# #)
  test (7, 1, 3, 5) $ \a b -> shuffleInt32X4# a b (# 7#, 1#, 3#, 5# #)
  test (7, 1, 5, 3) $ \a b -> shuffleInt32X4# a b (# 7#, 1#, 5#, 3# #)
  test (7, 2, 3, 6) $ \a b -> shuffleInt32X4# a b (# 7#, 2#, 3#, 6# #)
  test (7, 2, 6, 3) $ \a b -> shuffleInt32X4# a b (# 7#, 2#, 6#, 3# #)
  test (7, 3, 0, 3) $ \a b -> shuffleInt32X4# a b (# 7#, 3#, 0#, 3# #)
  test (7, 3, 1, 5) $ \a b -> shuffleInt32X4# a b (# 7#, 3#, 1#, 5# #)
  test (7, 3, 2, 6) $ \a b -> shuffleInt32X4# a b (# 7#, 3#, 2#, 6# #)
  test (7, 3, 5, 1) $ \a b -> shuffleInt32X4# a b (# 7#, 3#, 5#, 1# #)
  test (7, 3, 6, 2) $ \a b -> shuffleInt32X4# a b (# 7#, 3#, 6#, 2# #)
  test (7, 4, 1, 1) $ \a b -> shuffleInt32X4# a b (# 7#, 4#, 1#, 1# #)
  test (7, 4, 5, 6) $ \a b -> shuffleInt32X4# a b (# 7#, 4#, 5#, 6# #)
  test (7, 4, 6, 5) $ \a b -> shuffleInt32X4# a b (# 7#, 4#, 6#, 5# #)
  test (7, 5, 1, 3) $ \a b -> shuffleInt32X4# a b (# 7#, 5#, 1#, 3# #)
  test (7, 5, 2, 1) $ \a b -> shuffleInt32X4# a b (# 7#, 5#, 2#, 1# #)
  test (7, 5, 3, 1) $ \a b -> shuffleInt32X4# a b (# 7#, 5#, 3#, 1# #)
  test (7, 5, 4, 6) $ \a b -> shuffleInt32X4# a b (# 7#, 5#, 4#, 6# #)
  test (7, 5, 6, 4) $ \a b -> shuffleInt32X4# a b (# 7#, 5#, 6#, 4# #)
  test (7, 6, 1, 2) $ \a b -> shuffleInt32X4# a b (# 7#, 6#, 1#, 2# #)
  test (7, 6, 2, 3) $ \a b -> shuffleInt32X4# a b (# 7#, 6#, 2#, 3# #)
  test (7, 6, 3, 2) $ \a b -> shuffleInt32X4# a b (# 7#, 6#, 3#, 2# #)
  test (7, 6, 4, 5) $ \a b -> shuffleInt32X4# a b (# 7#, 6#, 4#, 5# #)
  test (7, 6, 5, 4) $ \a b -> shuffleInt32X4# a b (# 7#, 6#, 5#, 4# #)
  test (7, 6, 6, 4) $ \a b -> shuffleInt32X4# a b (# 7#, 6#, 6#, 4# #)
  test (7, 7, 6, 7) $ \a b -> shuffleInt32X4# a b (# 7#, 7#, 6#, 7# #)
  test (7, 7, 7, 7) $ \a b -> shuffleInt32X4# a b (# 7#, 7#, 7#, 7# #)
  test0x (4, 0, 1, 2) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 4#, 0#, 1#, 2# #)
  test0x (4, 4, 0, 1) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 4#, 4#, 0#, 1# #)
  test0x (4, 4, 4, 0) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 4#, 4#, 4#, 0# #)
  test0x (4, 4, 4, 4) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 4#, 4#, 4#, 4# #)
  test0x (0, 4, 5, 6) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 0#, 4#, 5#, 6# #)
  test0x (0, 0, 4, 5) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 0#, 0#, 4#, 5# #)
  test0x (0, 0, 0, 4) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 0#, 0#, 0#, 4# #)
  test0x (0, 0, 0, 0) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 0#, 0#, 0#, 0# #)
  test0x (1, 2, 3, 4) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 1#, 2#, 3#, 4# #)
  test0x (2, 3, 4, 4) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 2#, 3#, 4#, 4# #)
  test0x (3, 4, 4, 4) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 3#, 4#, 4#, 4# #)
  test0x (4, 4, 4, 4) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 4#, 4#, 4#, 4# #)
  test0x (5, 6, 7, 0) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 5#, 6#, 7#, 0# #)
  test0x (6, 7, 0, 0) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 6#, 7#, 0#, 0# #)
  test0x (7, 0, 0, 0) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 7#, 0#, 0#, 0# #)
  test0x (0, 0, 0, 0) $ \b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# 0#, 0#, 0#, 0# #)
  testx0 (4, 0, 1, 2) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 4#, 0#, 1#, 2# #)
  testx0 (4, 4, 0, 1) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 4#, 4#, 0#, 1# #)
  testx0 (4, 4, 4, 0) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 4#, 4#, 4#, 0# #)
  testx0 (4, 4, 4, 4) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 4#, 4#, 4#, 4# #)
  testx0 (0, 4, 5, 6) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 0#, 4#, 5#, 6# #)
  testx0 (0, 0, 4, 5) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 0#, 0#, 4#, 5# #)
  testx0 (0, 0, 0, 4) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 0#, 0#, 0#, 4# #)
  testx0 (0, 0, 0, 0) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 0#, 0#, 0#, 0# #)
  testx0 (1, 2, 3, 4) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 1#, 2#, 3#, 4# #)
  testx0 (2, 3, 4, 4) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 2#, 3#, 4#, 4# #)
  testx0 (3, 4, 4, 4) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 3#, 4#, 4#, 4# #)
  testx0 (4, 4, 4, 4) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 4#, 4#, 4#, 4# #)
  testx0 (5, 6, 7, 0) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 5#, 6#, 7#, 0# #)
  testx0 (6, 7, 0, 0) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 6#, 7#, 0#, 0# #)
  testx0 (7, 0, 0, 0) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 7#, 0#, 0#, 0# #)
  testx0 (0, 0, 0, 0) $ \a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# 0#, 0#, 0#, 0# #)

{- Generated by:
{- cabal:
build-depends: base, random
-}
import System.Random.Stateful
import qualified Data.List as List
import Control.Monad

main :: IO ()
main = do
  let rollM :: StatefulGen g m => g -> m Int
      rollM = uniformRM (0, 7)
      genShuffle = replicateM 4 . rollM
      pureGen = mkStdGen 42
      randomCases = runStateGen_ pureGen $ \g -> do
        randomCases <- replicateM 100 (genShuffle g)
        blend <- replicateM 10 $ replicateM 4 (uniformRM (0, 1) g)
        let blendCases = [[4 * i + j | (i,j) <- zip is [0..]] | is <- blend]
        return $ randomCases ++ blendCases
      fixedCases = [[i,i,i,i] | i <- [0..7]]
        ++ List.permutations [0,1,2,3]
        ++ List.permutations [4,5,6,7]
        ++ List.permutations [0,2,4,6]
        ++ List.permutations [1,3,5,7]
        ++ List.permutations [0,1,4,5]
        ++ List.permutations [2,3,6,7]
        ++ [take 4 (drop i [0..7]) | i <- [0..4]] -- PALIGNR
        ++ [take 4 (drop i ([4..7] ++ [0..3])) | i <- [0..4]] -- PALIGNR
      cases = List.nub $ List.sort $ fixedCases ++ randomCases
  forM_ cases $ \xs -> do
    putStrLn $ "  test (" ++ List.intercalate ", " (map show xs) ++ ") $ \\a b -> shuffleInt32X4# a b (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
  let shiftCases = concat
        [[replicate i 4 ++ [0..3-i] | i <- [1..4]] -- PSLLDQ
        ,[replicate i 0 ++ [4..7-i] | i <- [1..4]] -- PSLLDQ
        ,[[i..3] ++ replicate i 4 | i <- [1..4]] -- PSRLDQ
        ,[[4+i..7] ++ replicate i 0 | i <- [1..4]] -- PSRLDQ
        ]
  forM_ shiftCases $ \xs -> do
    putStrLn $ "  test0x (" ++ List.intercalate ", " (map show xs) ++ ") $ \\b -> shuffleInt32X4# (broadcastInt32X4# 0#Int32) b (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
  forM_ shiftCases $ \xs -> do
    putStrLn $ "  testx0 (" ++ List.intercalate ", " (map show xs) ++ ") $ \\a -> shuffleInt32X4# a (broadcastInt32X4# 0#Int32) (# " ++ List.intercalate ", " (map (\i -> show i ++ "#") xs) ++ " #)"
-}
