/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import org.catacombae.hfsexplorer.BasicExtractProgressMonitor;
import org.catacombae.hfsexplorer.ExtractProgressMonitor;

public class SimpleGUIProgressMonitor
extends BasicExtractProgressMonitor {
    private final Component parentComponent;
    private final ExtractProgressMonitor.ExtractProperties extractProperties = new ExtractProgressMonitor.ExtractProperties();

    public SimpleGUIProgressMonitor(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public ExtractProgressMonitor.ExtractProperties getExtractProperties() {
        return this.extractProperties;
    }

    public ExtractProgressMonitor.CreateDirectoryFailedAction createDirectoryFailed(String dirname, File parentDirectory) {
        return SimpleGUIProgressMonitor.createDirectoryFailed(this.parentComponent, dirname, parentDirectory);
    }

    public ExtractProgressMonitor.CreateFileFailedAction createFileFailed(String filename, File parentDirectory) {
        return SimpleGUIProgressMonitor.createFileFailed(this.parentComponent, filename, parentDirectory);
    }

    public ExtractProgressMonitor.DirectoryExistsAction directoryExists(File directory) {
        return SimpleGUIProgressMonitor.directoryExists(this.parentComponent, directory);
    }

    public ExtractProgressMonitor.FileExistsAction fileExists(File file) {
        return SimpleGUIProgressMonitor.fileExists(this.parentComponent, file);
    }

    public String displayRenamePrompt(String currentName, File outDir) {
        return SimpleGUIProgressMonitor.displayRenamePrompt(this.parentComponent, currentName, outDir);
    }

    public static ExtractProgressMonitor.CreateDirectoryFailedAction createDirectoryFailed(Component parentComponent, String dirname, File parentDirectory) {
        Object[] options = new String[]{"Rename", "Skip directory", "Auto-rename", "Cancel"};
        int reply = JOptionPane.showOptionDialog(parentComponent, "Could not create directory \"" + dirname + "\" in:\n    \"" + parentDirectory.getAbsolutePath() + "\"", "Error", 1, 0, null, options, options[0]);
        switch (reply) {
            case 0: {
                return ExtractProgressMonitor.CreateDirectoryFailedAction.RENAME;
            }
            case 1: {
                return ExtractProgressMonitor.CreateDirectoryFailedAction.SKIP_DIRECTORY;
            }
            case 2: {
                return ExtractProgressMonitor.CreateDirectoryFailedAction.AUTO_RENAME;
            }
        }
        return ExtractProgressMonitor.CreateDirectoryFailedAction.CANCEL;
    }

    public static ExtractProgressMonitor.CreateFileFailedAction createFileFailed(Component parentComponent, String filename, File parentDirectory) {
        Object[] options = new String[]{"Rename", "Skip file", "Skip directory", "Auto-rename", "Cancel"};
        int reply = JOptionPane.showOptionDialog(parentComponent, "Could not create file \"" + filename + "\" in:\n    \"" + parentDirectory.getAbsolutePath() + "\"", "Error", 1, 0, null, options, options[0]);
        switch (reply) {
            case 0: {
                return ExtractProgressMonitor.CreateFileFailedAction.RENAME;
            }
            case 1: {
                return ExtractProgressMonitor.CreateFileFailedAction.SKIP_FILE;
            }
            case 2: {
                return ExtractProgressMonitor.CreateFileFailedAction.SKIP_DIRECTORY;
            }
            case 3: {
                return ExtractProgressMonitor.CreateFileFailedAction.AUTO_RENAME;
            }
        }
        return ExtractProgressMonitor.CreateFileFailedAction.CANCEL;
    }

    public static ExtractProgressMonitor.DirectoryExistsAction directoryExists(Component parentComponent, File directory) {
        Object[] options = new String[]{"Continue", "Rename", "Skip directory", "Auto-rename", "Cancel"};
        int reply = JOptionPane.showOptionDialog(parentComponent, "Warning! Directory:\n    \"" + directory.getAbsolutePath() + "\"\n" + "already exists.", "Warning", 1, 2, null, options, options[0]);
        switch (reply) {
            case 0: {
                return ExtractProgressMonitor.DirectoryExistsAction.CONTINUE;
            }
            case 1: {
                return ExtractProgressMonitor.DirectoryExistsAction.RENAME;
            }
            case 2: {
                return ExtractProgressMonitor.DirectoryExistsAction.SKIP_DIRECTORY;
            }
            case 3: {
                return ExtractProgressMonitor.DirectoryExistsAction.AUTO_RENAME;
            }
        }
        return ExtractProgressMonitor.DirectoryExistsAction.CANCEL;
    }

    public static ExtractProgressMonitor.FileExistsAction fileExists(Component parentComponent, File file) {
        Object[] options = new String[]{"Overwrite", "Overwrite all", "Rename", "Skip file", "Skip directory", "Auto-rename", "Cancel"};
        int reply = JOptionPane.showOptionDialog(parentComponent, "Warning! File:\n    \"" + file.getAbsolutePath() + "\"\n" + "already exists.", "Warning", 1, 2, null, options, options[0]);
        switch (reply) {
            case 0: {
                return ExtractProgressMonitor.FileExistsAction.OVERWRITE;
            }
            case 1: {
                return ExtractProgressMonitor.FileExistsAction.OVERWRITE_ALL;
            }
            case 2: {
                return ExtractProgressMonitor.FileExistsAction.RENAME;
            }
            case 3: {
                return ExtractProgressMonitor.FileExistsAction.SKIP_FILE;
            }
            case 4: {
                return ExtractProgressMonitor.FileExistsAction.SKIP_DIRECTORY;
            }
            case 5: {
                return ExtractProgressMonitor.FileExistsAction.AUTO_RENAME;
            }
        }
        return ExtractProgressMonitor.FileExistsAction.CANCEL;
    }

    public static String displayRenamePrompt(Component parentComponent, String currentName, File outDir) {
        Object selection = JOptionPane.showInputDialog(parentComponent, "Enter new name:", "Rename", -1, null, null, currentName);
        if (selection != null) {
            return selection.toString();
        }
        return null;
    }
}

