import { ThemeType } from '@ui-kitten/components'
import palette from 'google-palette'
import { SHA3 } from 'sha3'

import beapi from '@berty/api'
import { ParsedInteraction } from '@berty/utils/api'
import { pbDateToNum } from '@berty/utils/convert/time'

const pal = palette('tol-rainbow', 256)

export const getUserMessageState = (
	inte: ParsedInteraction,
	members: { [key: string]: beapi.messenger.IMember | undefined } | undefined,
	convKind: beapi.messenger.Conversation.Type,
	previousMessage: ParsedInteraction | undefined,
	nextMessage: ParsedInteraction | undefined,
	colors: ThemeType,
) => {
	const sentDate = pbDateToNum(inte?.sentDate)

	let name = ''
	let baseColor = colors['background-header']
	let isFollowupMessage: boolean | undefined = false
	let isFollowedMessage: boolean | undefined = false
	let isWithinCollapseDuration: number | boolean | null | undefined = false
	let msgTextColor, msgBackgroundColor, msgBorderColor, msgSenderColor

	const cmd = null /*messenger.message.isCommandMessage(payload.body)*/
	if (convKind === beapi.messenger.Conversation.Type.ContactType) {
		// State of OneToOne conversation

		// TODO: tmp comment to don't have user frustration when a message is not received
		// msgTextColor = inte.isMine
		// 	? inte.acknowledged
		// 		? colors['reverted-main-text']
		// 		: colors['background-header']
		// 	: colors['background-header']
		msgTextColor = inte.isMine ? colors['reverted-main-text'] : colors['background-header']

		// TODO: tmp comment to don't have user frustration when a message is not received
		// msgBackgroundColor = inte.isMine
		// 	? inte.acknowledged
		// 		? colors['background-header']
		// 		: colors['reverted-main-text']
		// 	: colors['input-background']
		msgBackgroundColor = inte.isMine ? colors['background-header'] : colors['input-background']

		msgBorderColor =
			inte.isMine &&
			(cmd
				? { borderColor: colors['secondary-text'] }
				: { borderColor: colors['background-header'] })

		isWithinCollapseDuration =
			nextMessage &&
			inte.isMine === nextMessage?.isMine &&
			sentDate &&
			nextMessage.sentDate &&
			(parseInt(nextMessage?.sentDate.toString(), 10) || 0) - (sentDate || 0) < 60000 // one minute
	} else {
		// State for MultiMember conversation
		if (inte.memberPublicKey && members && members[inte.memberPublicKey]) {
			name = members[inte.memberPublicKey]?.displayName || ''
		}
		isFollowupMessage =
			previousMessage && !inte.isMine && inte.memberPublicKey === previousMessage.memberPublicKey
		isFollowedMessage =
			nextMessage && !inte.isMine && inte.memberPublicKey === nextMessage.memberPublicKey

		isWithinCollapseDuration =
			nextMessage &&
			inte?.memberPublicKey === nextMessage?.memberPublicKey &&
			sentDate &&
			nextMessage.sentDate &&
			(parseInt(nextMessage?.sentDate.toString(), 10) || 0) - (sentDate || 0) < 60000 // one minute

		if (!inte.isMine && inte.memberPublicKey) {
			const h = new SHA3(256).update(inte.memberPublicKey).digest()
			baseColor = '#' + pal[h[0]]
		}
		// TODO: tmp comment to don't have user frustration when a message is not received
		// msgTextColor = inte.isMine
		// 	? inte.acknowledged
		// 		? colors['reverted-main-text']
		// 		: cmd
		// 		? colors['secondary-text']
		// 		: baseColor
		// 	: colors['reverted-main-text']
		// msgTextColor = inte.isMine
		// 	? inte.acknowledged
		// 		? colors['reverted-main-text']
		// 		: baseColor
		// 	: colors['reverted-main-text']
		msgTextColor = colors['reverted-main-text']
		// TODO: tmp comment to don't have user frustration when a message is not received
		// msgBackgroundColor = inte.isMine
		// 	? inte.acknowledged
		// 		? baseColor
		// 		: colors['reverted-main-text']
		// 	: baseColor
		msgBackgroundColor = baseColor
		msgBorderColor =
			inte.isMine && (cmd ? { borderColor: colors['secondary-text'] } : { borderColor: baseColor })
		msgSenderColor = inte.isMine ? colors['warning-asset'] : baseColor
	}

	return {
		name,
		isFollowupMessage,
		isFollowedMessage,
		isWithinCollapseDuration,
		msgTextColor,
		msgBackgroundColor,
		msgBorderColor,
		msgSenderColor,
		cmd,
	}
}
