import * as C from '@/constants'
import * as React from 'react'
import * as Kb from '@/common-adapters'
import UserNotice from '../user-notice'

const LeftContainer = React.memo(function LeftContainer() {
  const meta = C.useChatContext(s => s.meta)
  const {channelname, teamType, teamname} = meta
  const isBigTeam = teamType === 'big'

  return (
    <UserNotice>
      <Kb.Text type="BodySmall">{`left ${isBigTeam ? `#${channelname}` : teamname}.`}</Kb.Text>
    </UserNotice>
  )
})

export default LeftContainer
