<?php
{{ $config := . }}

/**
 * @file
 * This is a Drupal 7 settings.ddev.php file automatically generated by DDEV.
 * {{ $config.Signature }}: Automatically generated Drupal settings file.
 * ddev manages this file and may delete or overwrite the file unless this
 * comment is removed.
 */

$host = "{{ $config.DatabaseHost }}";
$port = {{ $config.DatabasePort }};
$driver = "{{ $config.DatabaseDriver }}";

// If DDEV_PHP_VERSION is not set but IS_DDEV_PROJECT *is*, it means we're running (drush) on the host,
// so use the host-side bind port on docker IP
if (empty(getenv('DDEV_PHP_VERSION') && getenv('IS_DDEV_PROJECT') == 'true')) {
  $host = "{{ $config.DockerIP }}";
  $port = {{ $config.DBPublishedPort }};
}

$databases['default']['default']['database'] = "{{ $config.DatabaseName }}";
$databases['default']['default']['username'] = "{{ $config.DatabaseUsername }}";
$databases['default']['default']['password'] = "{{ $config.DatabasePassword }}";
$databases['default']['default']['host'] = $host;
$databases['default']['default']['driver'] = $driver;
$databases['default']['default']['port'] = $port;

$drupal_hash_salt = '{{ $config.HashSalt }}';

// This will prevent Drupal from setting read-only permissions on sites/default.
$conf['skip_permissions_hardening'] = TRUE;

// This will ensure the site can only be accessed through the intended host
// names. Additional host patterns can be added for custom configurations.
$conf['trusted_host_patterns'] = ['.*'];

// Enable verbose logging for errors.
// https://www.drupal.org/docs/7/creating-custom-modules/show-all-errors-while-developing
$conf['error_level'] = 2;
