Feature: merging a branch verbosely

  Background:
    Given a Git repo with origin
    And the branches
      | NAME  | TYPE    | PARENT | LOCATIONS     |
      | alpha | feature | main   | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE      | FILE NAME  | FILE CONTENT  |
      | alpha  | local, origin | alpha commit | alpha-file | alpha content |
    And the branches
      | NAME | TYPE    | PARENT | LOCATIONS     |
      | beta | feature | alpha  | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE     | FILE NAME | FILE CONTENT |
      | beta   | local, origin | beta commit | beta-file | beta content |
    And Git setting "git-town.sync-feature-strategy" is "merge"
    And the current branch is "beta"
    When I run "git-town merge -v"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | git remote                                                                                                                                                                                                                                                                                                                                       |
      |        | git branch --show-current                                                                                                                                                                                                                                                                                                                        |
      | beta   | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |        | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |        | git log --no-merges --format=%H refs/heads/alpha ^refs/heads/beta                                                                                                                                                                                                                                                                                |
      |        | git checkout alpha                                                                                                                                                                                                                                                                                                                               |
      | alpha  | git reset --hard {{ sha 'beta commit' }}                                                                                                                                                                                                                                                                                                         |
      |        | git config --unset git-town-branch.beta.parent                                                                                                                                                                                                                                                                                                   |
      |        | git branch -D beta                                                                                                                                                                                                                                                                                                                               |
      |        | git rev-parse alpha origin/alpha                                                                                                                                                                                                                                                                                                                 |
      |        | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |        | git push origin :beta                                                                                                                                                                                                                                                                                                                            |
      |        | git config --unset git-town-branch.beta.branchtype                                                                                                                                                                                                                                                                                               |
      |        | git rev-parse --verify -q refs/heads/beta                                                                                                                                                                                                                                                                                                        |
      |        | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 29 shell commands.
      """

  Scenario: undo
    When I run "git-town undo -v"
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | git remote                                                                                                                                                                                                                                                                                                                                       |
      |        | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |        | git rev-parse HEAD                                                                                                                                                                                                                                                                                                                               |
      | alpha  | git reset --hard {{ sha 'alpha commit' }}                                                                                                                                                                                                                                                                                                        |
      |        | git rev-parse alpha origin/alpha                                                                                                                                                                                                                                                                                                                 |
      |        | git push --force-with-lease --force-if-includes                                                                                                                                                                                                                                                                                                  |
      |        | git branch beta {{ sha 'beta commit' }}                                                                                                                                                                                                                                                                                                          |
      |        | git push -u origin beta                                                                                                                                                                                                                                                                                                                          |
      |        | git rev-parse --verify -q refs/heads/beta                                                                                                                                                                                                                                                                                                        |
      |        | git checkout beta                                                                                                                                                                                                                                                                                                                                |
      |        | git config git-town-branch.beta.branchtype feature                                                                                                                                                                                                                                                                                               |
      |        | git config git-town-branch.beta.parent alpha                                                                                                                                                                                                                                                                                                     |
    And the initial lineage exists now
    And the initial commits exist now
