// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/audit/audit_log.proto

package audit

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	attribute_context "google.golang.org/genproto/googleapis/rpc/context/attribute_context"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Policy Type enum
type ViolationInfo_PolicyType int32

const (
	// Default value. This value should not be used.
	ViolationInfo_POLICY_TYPE_UNSPECIFIED ViolationInfo_PolicyType = 0
	// Indicates boolean policy constraint
	ViolationInfo_BOOLEAN_CONSTRAINT ViolationInfo_PolicyType = 1
	// Indicates list policy constraint
	ViolationInfo_LIST_CONSTRAINT ViolationInfo_PolicyType = 2
	// Indicates custom policy constraint
	ViolationInfo_CUSTOM_CONSTRAINT ViolationInfo_PolicyType = 3
)

// Enum value maps for ViolationInfo_PolicyType.
var (
	ViolationInfo_PolicyType_name = map[int32]string{
		0: "POLICY_TYPE_UNSPECIFIED",
		1: "BOOLEAN_CONSTRAINT",
		2: "LIST_CONSTRAINT",
		3: "CUSTOM_CONSTRAINT",
	}
	ViolationInfo_PolicyType_value = map[string]int32{
		"POLICY_TYPE_UNSPECIFIED": 0,
		"BOOLEAN_CONSTRAINT":      1,
		"LIST_CONSTRAINT":         2,
		"CUSTOM_CONSTRAINT":       3,
	}
)

func (x ViolationInfo_PolicyType) Enum() *ViolationInfo_PolicyType {
	p := new(ViolationInfo_PolicyType)
	*p = x
	return p
}

func (x ViolationInfo_PolicyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ViolationInfo_PolicyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_audit_log_proto_enumTypes[0].Descriptor()
}

func (ViolationInfo_PolicyType) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_audit_log_proto_enumTypes[0]
}

func (x ViolationInfo_PolicyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ViolationInfo_PolicyType.Descriptor instead.
func (ViolationInfo_PolicyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{8, 0}
}

// Common audit log format for Google Cloud Platform API operations.
type AuditLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the API service performing the operation. For example,
	// `"compute.googleapis.com"`.
	ServiceName string `protobuf:"bytes,7,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The name of the service method or operation.
	// For API calls, this should be the name of the API method.
	// For example,
	//
	//	"google.cloud.bigquery.v2.TableService.InsertTable"
	//	"google.logging.v2.ConfigServiceV2.CreateSink"
	MethodName string `protobuf:"bytes,8,opt,name=method_name,json=methodName,proto3" json:"method_name,omitempty"`
	// The resource or collection that is the target of the operation.
	// The name is a scheme-less URI, not including the API service name.
	// For example:
	//
	//	"projects/PROJECT_ID/zones/us-central1-a/instances"
	//	"projects/PROJECT_ID/datasets/DATASET_ID"
	ResourceName string `protobuf:"bytes,11,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The resource location information.
	ResourceLocation *ResourceLocation `protobuf:"bytes,20,opt,name=resource_location,json=resourceLocation,proto3" json:"resource_location,omitempty"`
	// The resource's original state before mutation. Present only for
	// operations which have successfully modified the targeted resource(s).
	// In general, this field should contain all changed fields, except those
	// that are already been included in `request`, `response`, `metadata` or
	// `service_data` fields.
	// When the JSON object represented here has a proto equivalent,
	// the proto name will be indicated in the `@type` property.
	ResourceOriginalState *structpb.Struct `protobuf:"bytes,19,opt,name=resource_original_state,json=resourceOriginalState,proto3" json:"resource_original_state,omitempty"`
	// The number of items returned from a List or Query API method,
	// if applicable.
	NumResponseItems int64 `protobuf:"varint,12,opt,name=num_response_items,json=numResponseItems,proto3" json:"num_response_items,omitempty"`
	// The status of the overall operation.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// Authentication information.
	AuthenticationInfo *AuthenticationInfo `protobuf:"bytes,3,opt,name=authentication_info,json=authenticationInfo,proto3" json:"authentication_info,omitempty"`
	// Authorization information. If there are multiple
	// resources or permissions involved, then there is
	// one AuthorizationInfo element for each {resource, permission} tuple.
	AuthorizationInfo []*AuthorizationInfo `protobuf:"bytes,9,rep,name=authorization_info,json=authorizationInfo,proto3" json:"authorization_info,omitempty"`
	// Indicates the policy violations for this request. If the request
	// is denied by the policy, violation information will be logged
	// here.
	PolicyViolationInfo *PolicyViolationInfo `protobuf:"bytes,25,opt,name=policy_violation_info,json=policyViolationInfo,proto3" json:"policy_violation_info,omitempty"`
	// Metadata about the operation.
	RequestMetadata *RequestMetadata `protobuf:"bytes,4,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
	// The operation request. This may not include all request parameters,
	// such as those that are too large, privacy-sensitive, or duplicated
	// elsewhere in the log record.
	// It should never include user-generated data, such as file contents.
	// When the JSON object represented here has a proto equivalent, the proto
	// name will be indicated in the `@type` property.
	Request *structpb.Struct `protobuf:"bytes,16,opt,name=request,proto3" json:"request,omitempty"`
	// The operation response. This may not include all response elements,
	// such as those that are too large, privacy-sensitive, or duplicated
	// elsewhere in the log record.
	// It should never include user-generated data, such as file contents.
	// When the JSON object represented here has a proto equivalent, the proto
	// name will be indicated in the `@type` property.
	Response *structpb.Struct `protobuf:"bytes,17,opt,name=response,proto3" json:"response,omitempty"`
	// Other service-specific data about the request, response, and other
	// information associated with the current audited event.
	Metadata *structpb.Struct `protobuf:"bytes,18,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Deprecated. Use the `metadata` field instead.
	// Other service-specific data about the request, response, and other
	// activities.
	//
	// Deprecated: Do not use.
	ServiceData *anypb.Any `protobuf:"bytes,15,opt,name=service_data,json=serviceData,proto3" json:"service_data,omitempty"`
}

func (x *AuditLog) Reset() {
	*x = AuditLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditLog) ProtoMessage() {}

func (x *AuditLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditLog.ProtoReflect.Descriptor instead.
func (*AuditLog) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{0}
}

func (x *AuditLog) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *AuditLog) GetMethodName() string {
	if x != nil {
		return x.MethodName
	}
	return ""
}

func (x *AuditLog) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *AuditLog) GetResourceLocation() *ResourceLocation {
	if x != nil {
		return x.ResourceLocation
	}
	return nil
}

func (x *AuditLog) GetResourceOriginalState() *structpb.Struct {
	if x != nil {
		return x.ResourceOriginalState
	}
	return nil
}

func (x *AuditLog) GetNumResponseItems() int64 {
	if x != nil {
		return x.NumResponseItems
	}
	return 0
}

func (x *AuditLog) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *AuditLog) GetAuthenticationInfo() *AuthenticationInfo {
	if x != nil {
		return x.AuthenticationInfo
	}
	return nil
}

func (x *AuditLog) GetAuthorizationInfo() []*AuthorizationInfo {
	if x != nil {
		return x.AuthorizationInfo
	}
	return nil
}

func (x *AuditLog) GetPolicyViolationInfo() *PolicyViolationInfo {
	if x != nil {
		return x.PolicyViolationInfo
	}
	return nil
}

func (x *AuditLog) GetRequestMetadata() *RequestMetadata {
	if x != nil {
		return x.RequestMetadata
	}
	return nil
}

func (x *AuditLog) GetRequest() *structpb.Struct {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *AuditLog) GetResponse() *structpb.Struct {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *AuditLog) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Deprecated: Do not use.
func (x *AuditLog) GetServiceData() *anypb.Any {
	if x != nil {
		return x.ServiceData
	}
	return nil
}

// Authentication information for the operation.
type AuthenticationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The email address of the authenticated user (or service account on behalf
	// of third party principal) making the request. For third party identity
	// callers, the `principal_subject` field is populated instead of this field.
	// For privacy reasons, the principal email address is sometimes redacted.
	// For more information, see [Caller identities in audit
	// logs](https://cloud.google.com/logging/docs/audit#user-id).
	PrincipalEmail string `protobuf:"bytes,1,opt,name=principal_email,json=principalEmail,proto3" json:"principal_email,omitempty"`
	// The authority selector specified by the requestor, if any.
	// It is not guaranteed that the principal was allowed to use this authority.
	AuthoritySelector string `protobuf:"bytes,2,opt,name=authority_selector,json=authoritySelector,proto3" json:"authority_selector,omitempty"`
	// The third party identification (if any) of the authenticated user making
	// the request.
	// When the JSON object represented here has a proto equivalent, the proto
	// name will be indicated in the `@type` property.
	ThirdPartyPrincipal *structpb.Struct `protobuf:"bytes,4,opt,name=third_party_principal,json=thirdPartyPrincipal,proto3" json:"third_party_principal,omitempty"`
	// The name of the service account key used to create or exchange
	// credentials for authenticating the service account making the request.
	// This is a scheme-less URI full resource name. For example:
	//
	// "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
	ServiceAccountKeyName string `protobuf:"bytes,5,opt,name=service_account_key_name,json=serviceAccountKeyName,proto3" json:"service_account_key_name,omitempty"`
	// Identity delegation history of an authenticated service account that makes
	// the request. It contains information on the real authorities that try to
	// access GCP resources by delegating on a service account. When multiple
	// authorities present, they are guaranteed to be sorted based on the original
	// ordering of the identity delegation events.
	ServiceAccountDelegationInfo []*ServiceAccountDelegationInfo `protobuf:"bytes,6,rep,name=service_account_delegation_info,json=serviceAccountDelegationInfo,proto3" json:"service_account_delegation_info,omitempty"`
	// String representation of identity of requesting party.
	// Populated for both first and third party identities.
	PrincipalSubject string `protobuf:"bytes,8,opt,name=principal_subject,json=principalSubject,proto3" json:"principal_subject,omitempty"`
}

func (x *AuthenticationInfo) Reset() {
	*x = AuthenticationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticationInfo) ProtoMessage() {}

func (x *AuthenticationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticationInfo.ProtoReflect.Descriptor instead.
func (*AuthenticationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{1}
}

func (x *AuthenticationInfo) GetPrincipalEmail() string {
	if x != nil {
		return x.PrincipalEmail
	}
	return ""
}

func (x *AuthenticationInfo) GetAuthoritySelector() string {
	if x != nil {
		return x.AuthoritySelector
	}
	return ""
}

func (x *AuthenticationInfo) GetThirdPartyPrincipal() *structpb.Struct {
	if x != nil {
		return x.ThirdPartyPrincipal
	}
	return nil
}

func (x *AuthenticationInfo) GetServiceAccountKeyName() string {
	if x != nil {
		return x.ServiceAccountKeyName
	}
	return ""
}

func (x *AuthenticationInfo) GetServiceAccountDelegationInfo() []*ServiceAccountDelegationInfo {
	if x != nil {
		return x.ServiceAccountDelegationInfo
	}
	return nil
}

func (x *AuthenticationInfo) GetPrincipalSubject() string {
	if x != nil {
		return x.PrincipalSubject
	}
	return ""
}

// Authorization information for the operation.
type AuthorizationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource being accessed, as a REST-style or cloud resource string.
	// For example:
	//
	//	bigquery.googleapis.com/projects/PROJECTID/datasets/DATASETID
	//
	// or
	//
	//	projects/PROJECTID/datasets/DATASETID
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The required IAM permission.
	Permission string `protobuf:"bytes,2,opt,name=permission,proto3" json:"permission,omitempty"`
	// Whether or not authorization for `resource` and `permission`
	// was granted.
	Granted bool `protobuf:"varint,3,opt,name=granted,proto3" json:"granted,omitempty"`
	// Resource attributes used in IAM condition evaluation. This field contains
	// resource attributes like resource type and resource name.
	//
	// To get the whole view of the attributes used in IAM
	// condition evaluation, the user must also look into
	// `AuditLog.request_metadata.request_attributes`.
	ResourceAttributes *attribute_context.AttributeContext_Resource `protobuf:"bytes,5,opt,name=resource_attributes,json=resourceAttributes,proto3" json:"resource_attributes,omitempty"`
}

func (x *AuthorizationInfo) Reset() {
	*x = AuthorizationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationInfo) ProtoMessage() {}

func (x *AuthorizationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationInfo.ProtoReflect.Descriptor instead.
func (*AuthorizationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{2}
}

func (x *AuthorizationInfo) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *AuthorizationInfo) GetPermission() string {
	if x != nil {
		return x.Permission
	}
	return ""
}

func (x *AuthorizationInfo) GetGranted() bool {
	if x != nil {
		return x.Granted
	}
	return false
}

func (x *AuthorizationInfo) GetResourceAttributes() *attribute_context.AttributeContext_Resource {
	if x != nil {
		return x.ResourceAttributes
	}
	return nil
}

// Metadata about the request.
type RequestMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP address of the caller.
	// For a caller from the internet, this will be the public IPv4 or IPv6
	// address. For calls made from inside Google's internal production network
	// from one GCP service to another, `caller_ip` will be redacted to "private".
	// For a caller from a Compute Engine VM with a external IP address,
	// `caller_ip` will be the VM's external IP address. For a caller from a
	// Compute Engine VM without a external IP address, if the VM is in the same
	// organization (or project) as the accessed resource, `caller_ip` will be the
	// VM's internal IPv4 address, otherwise `caller_ip` will be redacted to
	// "gce-internal-ip". See https://cloud.google.com/compute/docs/vpc/ for more
	// information.
	CallerIp string `protobuf:"bytes,1,opt,name=caller_ip,json=callerIp,proto3" json:"caller_ip,omitempty"`
	// The user agent of the caller.
	// This information is not authenticated and should be treated accordingly.
	// For example:
	//
	//   - `google-api-python-client/1.4.0`:
	//     The request was made by the Google API client for Python.
	//   - `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
	//     The request was made by the Google Cloud SDK CLI (gcloud).
	//   - `AppEngine-Google; (+http://code.google.com/appengine; appid:
	//
	// s~my-project`:
	//
	//	The request was made from the `my-project` App Engine app.
	CallerSuppliedUserAgent string `protobuf:"bytes,2,opt,name=caller_supplied_user_agent,json=callerSuppliedUserAgent,proto3" json:"caller_supplied_user_agent,omitempty"`
	// The network of the caller.
	// Set only if the network host project is part of the same GCP organization
	// (or project) as the accessed resource.
	// See https://cloud.google.com/compute/docs/vpc/ for more information.
	// This is a scheme-less URI full resource name. For example:
	//
	//	"//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
	CallerNetwork string `protobuf:"bytes,3,opt,name=caller_network,json=callerNetwork,proto3" json:"caller_network,omitempty"`
	// Request attributes used in IAM condition evaluation. This field contains
	// request attributes like request time and access levels associated with
	// the request.
	//
	// To get the whole view of the attributes used in IAM
	// condition evaluation, the user must also look into
	// `AuditLog.authentication_info.resource_attributes`.
	RequestAttributes *attribute_context.AttributeContext_Request `protobuf:"bytes,7,opt,name=request_attributes,json=requestAttributes,proto3" json:"request_attributes,omitempty"`
	// The destination of a network activity, such as accepting a TCP connection.
	// In a multi hop network activity, the destination represents the receiver of
	// the last hop. Only two fields are used in this message, Peer.port and
	// Peer.ip. These fields are optionally populated by those services utilizing
	// the IAM condition feature.
	DestinationAttributes *attribute_context.AttributeContext_Peer `protobuf:"bytes,8,opt,name=destination_attributes,json=destinationAttributes,proto3" json:"destination_attributes,omitempty"`
}

func (x *RequestMetadata) Reset() {
	*x = RequestMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestMetadata) ProtoMessage() {}

func (x *RequestMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestMetadata.ProtoReflect.Descriptor instead.
func (*RequestMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{3}
}

func (x *RequestMetadata) GetCallerIp() string {
	if x != nil {
		return x.CallerIp
	}
	return ""
}

func (x *RequestMetadata) GetCallerSuppliedUserAgent() string {
	if x != nil {
		return x.CallerSuppliedUserAgent
	}
	return ""
}

func (x *RequestMetadata) GetCallerNetwork() string {
	if x != nil {
		return x.CallerNetwork
	}
	return ""
}

func (x *RequestMetadata) GetRequestAttributes() *attribute_context.AttributeContext_Request {
	if x != nil {
		return x.RequestAttributes
	}
	return nil
}

func (x *RequestMetadata) GetDestinationAttributes() *attribute_context.AttributeContext_Peer {
	if x != nil {
		return x.DestinationAttributes
	}
	return nil
}

// Location information about a resource.
type ResourceLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The locations of a resource after the execution of the operation.
	// Requests to create or delete a location based resource must populate
	// the 'current_locations' field and not the 'original_locations' field.
	// For example:
	//
	//	"europe-west1-a"
	//	"us-east1"
	//	"nam3"
	CurrentLocations []string `protobuf:"bytes,1,rep,name=current_locations,json=currentLocations,proto3" json:"current_locations,omitempty"`
	// The locations of a resource prior to the execution of the operation.
	// Requests that mutate the resource's location must populate both the
	// 'original_locations' as well as the 'current_locations' fields.
	// For example:
	//
	//	"europe-west1-a"
	//	"us-east1"
	//	"nam3"
	OriginalLocations []string `protobuf:"bytes,2,rep,name=original_locations,json=originalLocations,proto3" json:"original_locations,omitempty"`
}

func (x *ResourceLocation) Reset() {
	*x = ResourceLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceLocation) ProtoMessage() {}

func (x *ResourceLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceLocation.ProtoReflect.Descriptor instead.
func (*ResourceLocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{4}
}

func (x *ResourceLocation) GetCurrentLocations() []string {
	if x != nil {
		return x.CurrentLocations
	}
	return nil
}

func (x *ResourceLocation) GetOriginalLocations() []string {
	if x != nil {
		return x.OriginalLocations
	}
	return nil
}

// Identity delegation history of an authenticated service account.
type ServiceAccountDelegationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A string representing the principal_subject associated with the identity.
	// For most identities, the format will be
	// `principal://iam.googleapis.com/{identity pool name}/subject/{subject)`
	// except for some GKE identities (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD)
	// that are still in the legacy format `serviceAccount:{identity pool
	// name}[{subject}]`
	PrincipalSubject string `protobuf:"bytes,3,opt,name=principal_subject,json=principalSubject,proto3" json:"principal_subject,omitempty"`
	// Entity that creates credentials for service account and assumes its
	// identity for authentication.
	//
	// Types that are assignable to Authority:
	//
	//	*ServiceAccountDelegationInfo_FirstPartyPrincipal_
	//	*ServiceAccountDelegationInfo_ThirdPartyPrincipal_
	Authority isServiceAccountDelegationInfo_Authority `protobuf_oneof:"Authority"`
}

func (x *ServiceAccountDelegationInfo) Reset() {
	*x = ServiceAccountDelegationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccountDelegationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountDelegationInfo) ProtoMessage() {}

func (x *ServiceAccountDelegationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountDelegationInfo.ProtoReflect.Descriptor instead.
func (*ServiceAccountDelegationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{5}
}

func (x *ServiceAccountDelegationInfo) GetPrincipalSubject() string {
	if x != nil {
		return x.PrincipalSubject
	}
	return ""
}

func (m *ServiceAccountDelegationInfo) GetAuthority() isServiceAccountDelegationInfo_Authority {
	if m != nil {
		return m.Authority
	}
	return nil
}

func (x *ServiceAccountDelegationInfo) GetFirstPartyPrincipal() *ServiceAccountDelegationInfo_FirstPartyPrincipal {
	if x, ok := x.GetAuthority().(*ServiceAccountDelegationInfo_FirstPartyPrincipal_); ok {
		return x.FirstPartyPrincipal
	}
	return nil
}

func (x *ServiceAccountDelegationInfo) GetThirdPartyPrincipal() *ServiceAccountDelegationInfo_ThirdPartyPrincipal {
	if x, ok := x.GetAuthority().(*ServiceAccountDelegationInfo_ThirdPartyPrincipal_); ok {
		return x.ThirdPartyPrincipal
	}
	return nil
}

type isServiceAccountDelegationInfo_Authority interface {
	isServiceAccountDelegationInfo_Authority()
}

type ServiceAccountDelegationInfo_FirstPartyPrincipal_ struct {
	// First party (Google) identity as the real authority.
	FirstPartyPrincipal *ServiceAccountDelegationInfo_FirstPartyPrincipal `protobuf:"bytes,1,opt,name=first_party_principal,json=firstPartyPrincipal,proto3,oneof"`
}

type ServiceAccountDelegationInfo_ThirdPartyPrincipal_ struct {
	// Third party identity as the real authority.
	ThirdPartyPrincipal *ServiceAccountDelegationInfo_ThirdPartyPrincipal `protobuf:"bytes,2,opt,name=third_party_principal,json=thirdPartyPrincipal,proto3,oneof"`
}

func (*ServiceAccountDelegationInfo_FirstPartyPrincipal_) isServiceAccountDelegationInfo_Authority() {
}

func (*ServiceAccountDelegationInfo_ThirdPartyPrincipal_) isServiceAccountDelegationInfo_Authority() {
}

// Information related to policy violations for this request.
type PolicyViolationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the orgpolicy violations for this resource.
	OrgPolicyViolationInfo *OrgPolicyViolationInfo `protobuf:"bytes,1,opt,name=org_policy_violation_info,json=orgPolicyViolationInfo,proto3" json:"org_policy_violation_info,omitempty"`
}

func (x *PolicyViolationInfo) Reset() {
	*x = PolicyViolationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyViolationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyViolationInfo) ProtoMessage() {}

func (x *PolicyViolationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyViolationInfo.ProtoReflect.Descriptor instead.
func (*PolicyViolationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{6}
}

func (x *PolicyViolationInfo) GetOrgPolicyViolationInfo() *OrgPolicyViolationInfo {
	if x != nil {
		return x.OrgPolicyViolationInfo
	}
	return nil
}

// Represents OrgPolicy Violation information.
type OrgPolicyViolationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource payload that is currently in scope and is subjected to orgpolicy
	// conditions. This payload may be the subset of the actual Resource that may
	// come in the request. This payload should not contain any core content.
	Payload *structpb.Struct `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// Optional. Resource type that the orgpolicy is checked against.
	// Example: compute.googleapis.com/Instance, store.googleapis.com/bucket
	ResourceType string `protobuf:"bytes,2,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Optional. Tags referenced on the resource at the time of evaluation. These also
	// include the federated tags, if they are supplied in the CheckOrgPolicy
	// or CheckCustomConstraints Requests.
	//
	// Optional field as of now. These tags are the Cloud tags that are
	// available on the resource during the policy evaluation and will
	// be available as part of the OrgPolicy check response for logging purposes.
	ResourceTags map[string]string `protobuf:"bytes,3,rep,name=resource_tags,json=resourceTags,proto3" json:"resource_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Policy violations
	ViolationInfo []*ViolationInfo `protobuf:"bytes,4,rep,name=violation_info,json=violationInfo,proto3" json:"violation_info,omitempty"`
}

func (x *OrgPolicyViolationInfo) Reset() {
	*x = OrgPolicyViolationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrgPolicyViolationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrgPolicyViolationInfo) ProtoMessage() {}

func (x *OrgPolicyViolationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrgPolicyViolationInfo.ProtoReflect.Descriptor instead.
func (*OrgPolicyViolationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{7}
}

func (x *OrgPolicyViolationInfo) GetPayload() *structpb.Struct {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *OrgPolicyViolationInfo) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *OrgPolicyViolationInfo) GetResourceTags() map[string]string {
	if x != nil {
		return x.ResourceTags
	}
	return nil
}

func (x *OrgPolicyViolationInfo) GetViolationInfo() []*ViolationInfo {
	if x != nil {
		return x.ViolationInfo
	}
	return nil
}

// Provides information about the Policy violation info for this request.
type ViolationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Constraint name
	Constraint string `protobuf:"bytes,1,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// Optional. Error message that policy is indicating.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Optional. Value that is being checked for the policy.
	// This could be in encrypted form (if pii sensitive).
	// This field will only be emitted in LIST_POLICY types
	CheckedValue string `protobuf:"bytes,3,opt,name=checked_value,json=checkedValue,proto3" json:"checked_value,omitempty"`
	// Optional. Indicates the type of the policy.
	PolicyType ViolationInfo_PolicyType `protobuf:"varint,4,opt,name=policy_type,json=policyType,proto3,enum=google.cloud.audit.ViolationInfo_PolicyType" json:"policy_type,omitempty"`
}

func (x *ViolationInfo) Reset() {
	*x = ViolationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ViolationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ViolationInfo) ProtoMessage() {}

func (x *ViolationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ViolationInfo.ProtoReflect.Descriptor instead.
func (*ViolationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{8}
}

func (x *ViolationInfo) GetConstraint() string {
	if x != nil {
		return x.Constraint
	}
	return ""
}

func (x *ViolationInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *ViolationInfo) GetCheckedValue() string {
	if x != nil {
		return x.CheckedValue
	}
	return ""
}

func (x *ViolationInfo) GetPolicyType() ViolationInfo_PolicyType {
	if x != nil {
		return x.PolicyType
	}
	return ViolationInfo_POLICY_TYPE_UNSPECIFIED
}

// First party identity principal.
type ServiceAccountDelegationInfo_FirstPartyPrincipal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The email address of a Google account.
	PrincipalEmail string `protobuf:"bytes,1,opt,name=principal_email,json=principalEmail,proto3" json:"principal_email,omitempty"`
	// Metadata about the service that uses the service account.
	ServiceMetadata *structpb.Struct `protobuf:"bytes,2,opt,name=service_metadata,json=serviceMetadata,proto3" json:"service_metadata,omitempty"`
}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) Reset() {
	*x = ServiceAccountDelegationInfo_FirstPartyPrincipal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountDelegationInfo_FirstPartyPrincipal) ProtoMessage() {}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountDelegationInfo_FirstPartyPrincipal.ProtoReflect.Descriptor instead.
func (*ServiceAccountDelegationInfo_FirstPartyPrincipal) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) GetPrincipalEmail() string {
	if x != nil {
		return x.PrincipalEmail
	}
	return ""
}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) GetServiceMetadata() *structpb.Struct {
	if x != nil {
		return x.ServiceMetadata
	}
	return nil
}

// Third party identity principal.
type ServiceAccountDelegationInfo_ThirdPartyPrincipal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata about third party identity.
	ThirdPartyClaims *structpb.Struct `protobuf:"bytes,1,opt,name=third_party_claims,json=thirdPartyClaims,proto3" json:"third_party_claims,omitempty"`
}

func (x *ServiceAccountDelegationInfo_ThirdPartyPrincipal) Reset() {
	*x = ServiceAccountDelegationInfo_ThirdPartyPrincipal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccountDelegationInfo_ThirdPartyPrincipal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountDelegationInfo_ThirdPartyPrincipal) ProtoMessage() {}

func (x *ServiceAccountDelegationInfo_ThirdPartyPrincipal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountDelegationInfo_ThirdPartyPrincipal.ProtoReflect.Descriptor instead.
func (*ServiceAccountDelegationInfo_ThirdPartyPrincipal) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{5, 1}
}

func (x *ServiceAccountDelegationInfo_ThirdPartyPrincipal) GetThirdPartyClaims() *structpb.Struct {
	if x != nil {
		return x.ThirdPartyClaims
	}
	return nil
}

var File_google_cloud_audit_audit_log_proto protoreflect.FileDescriptor

var file_google_cloud_audit_audit_log_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa7, 0x07, 0x0a, 0x08, 0x41, 0x75, 0x64, 0x69,
	0x74, 0x4c, 0x6f, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a,
	0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4f, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x15, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6e,
	0x75, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12,
	0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x57, 0x0a, 0x13, 0x61,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x54, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x11, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5b, 0x0a, 0x15, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x13, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4e, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x33, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x22, 0x98, 0x03, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x12, 0x4b, 0x0a, 0x15, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f,
	0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x13, 0x74, 0x68, 0x69, 0x72, 0x64, 0x50,
	0x61, 0x72, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x37, 0x0a,
	0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b,
	0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x77, 0x0a, 0x1f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x1c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x2b, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x73, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xc9, 0x01, 0x0a,
	0x11, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x12, 0x5e, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22, 0xd1, 0x02, 0x0a, 0x0f, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x09,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x70, 0x12, 0x3b, 0x0a, 0x1a, 0x63, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x53, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x55, 0x73, 0x65,
	0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5b, 0x0a,
	0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x16, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x50, 0x65, 0x65, 0x72, 0x52, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22, 0x6e, 0x0a, 0x10,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2b, 0x0a, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d, 0x0a,
	0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb3, 0x04, 0x0a,
	0x1c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44,
	0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a,
	0x11, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x73, 0x75, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x7a, 0x0a, 0x15, 0x66, 0x69,
	0x72, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x6c,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x46, 0x69, 0x72, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x48,
	0x00, 0x52, 0x13, 0x66, 0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x79, 0x50, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x7a, 0x0a, 0x15, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72,
	0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x13, 0x74,
	0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70,
	0x61, 0x6c, 0x1a, 0x82, 0x01, 0x0a, 0x13, 0x46, 0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x45, 0x6d,
	0x61, 0x69, 0x6c, 0x12, 0x42, 0x0a, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x5c, 0x0a, 0x13, 0x54, 0x68, 0x69, 0x72, 0x64,
	0x50, 0x61, 0x72, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x45,
	0x0a, 0x12, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x10, 0x74, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x43,
	0x6c, 0x61, 0x69, 0x6d, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x22, 0x7c, 0x0a, 0x13, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x65, 0x0a, 0x19, 0x6f, 0x72, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x16, 0x6f, 0x72, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x22, 0xf2, 0x02, 0x0a, 0x16, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x69,
	0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x36, 0x0a, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x66, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x54, 0x61, 0x67, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x3f, 0x0a, 0x11, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcb, 0x02, 0x0a, 0x0d, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65,
	0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x52, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x22, 0x6d, 0x0a, 0x0a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x16, 0x0a, 0x12, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x54,
	0x52, 0x41, 0x49, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x49, 0x53, 0x54, 0x5f,
	0x43, 0x4f, 0x4e, 0x53, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11,
	0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x52, 0x41, 0x49, 0x4e,
	0x54, 0x10, 0x03, 0x42, 0x65, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x42, 0x0d, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x3b, 0x61, 0x75, 0x64, 0x69, 0x74, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_audit_audit_log_proto_rawDescOnce sync.Once
	file_google_cloud_audit_audit_log_proto_rawDescData = file_google_cloud_audit_audit_log_proto_rawDesc
)

func file_google_cloud_audit_audit_log_proto_rawDescGZIP() []byte {
	file_google_cloud_audit_audit_log_proto_rawDescOnce.Do(func() {
		file_google_cloud_audit_audit_log_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_audit_audit_log_proto_rawDescData)
	})
	return file_google_cloud_audit_audit_log_proto_rawDescData
}

var file_google_cloud_audit_audit_log_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_audit_audit_log_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_audit_audit_log_proto_goTypes = []interface{}{
	(ViolationInfo_PolicyType)(0),                            // 0: google.cloud.audit.ViolationInfo.PolicyType
	(*AuditLog)(nil),                                         // 1: google.cloud.audit.AuditLog
	(*AuthenticationInfo)(nil),                               // 2: google.cloud.audit.AuthenticationInfo
	(*AuthorizationInfo)(nil),                                // 3: google.cloud.audit.AuthorizationInfo
	(*RequestMetadata)(nil),                                  // 4: google.cloud.audit.RequestMetadata
	(*ResourceLocation)(nil),                                 // 5: google.cloud.audit.ResourceLocation
	(*ServiceAccountDelegationInfo)(nil),                     // 6: google.cloud.audit.ServiceAccountDelegationInfo
	(*PolicyViolationInfo)(nil),                              // 7: google.cloud.audit.PolicyViolationInfo
	(*OrgPolicyViolationInfo)(nil),                           // 8: google.cloud.audit.OrgPolicyViolationInfo
	(*ViolationInfo)(nil),                                    // 9: google.cloud.audit.ViolationInfo
	(*ServiceAccountDelegationInfo_FirstPartyPrincipal)(nil), // 10: google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
	(*ServiceAccountDelegationInfo_ThirdPartyPrincipal)(nil), // 11: google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
	nil,                     // 12: google.cloud.audit.OrgPolicyViolationInfo.ResourceTagsEntry
	(*structpb.Struct)(nil), // 13: google.protobuf.Struct
	(*status.Status)(nil),   // 14: google.rpc.Status
	(*anypb.Any)(nil),       // 15: google.protobuf.Any
	(*attribute_context.AttributeContext_Resource)(nil), // 16: google.rpc.context.AttributeContext.Resource
	(*attribute_context.AttributeContext_Request)(nil),  // 17: google.rpc.context.AttributeContext.Request
	(*attribute_context.AttributeContext_Peer)(nil),     // 18: google.rpc.context.AttributeContext.Peer
}
var file_google_cloud_audit_audit_log_proto_depIdxs = []int32{
	5,  // 0: google.cloud.audit.AuditLog.resource_location:type_name -> google.cloud.audit.ResourceLocation
	13, // 1: google.cloud.audit.AuditLog.resource_original_state:type_name -> google.protobuf.Struct
	14, // 2: google.cloud.audit.AuditLog.status:type_name -> google.rpc.Status
	2,  // 3: google.cloud.audit.AuditLog.authentication_info:type_name -> google.cloud.audit.AuthenticationInfo
	3,  // 4: google.cloud.audit.AuditLog.authorization_info:type_name -> google.cloud.audit.AuthorizationInfo
	7,  // 5: google.cloud.audit.AuditLog.policy_violation_info:type_name -> google.cloud.audit.PolicyViolationInfo
	4,  // 6: google.cloud.audit.AuditLog.request_metadata:type_name -> google.cloud.audit.RequestMetadata
	13, // 7: google.cloud.audit.AuditLog.request:type_name -> google.protobuf.Struct
	13, // 8: google.cloud.audit.AuditLog.response:type_name -> google.protobuf.Struct
	13, // 9: google.cloud.audit.AuditLog.metadata:type_name -> google.protobuf.Struct
	15, // 10: google.cloud.audit.AuditLog.service_data:type_name -> google.protobuf.Any
	13, // 11: google.cloud.audit.AuthenticationInfo.third_party_principal:type_name -> google.protobuf.Struct
	6,  // 12: google.cloud.audit.AuthenticationInfo.service_account_delegation_info:type_name -> google.cloud.audit.ServiceAccountDelegationInfo
	16, // 13: google.cloud.audit.AuthorizationInfo.resource_attributes:type_name -> google.rpc.context.AttributeContext.Resource
	17, // 14: google.cloud.audit.RequestMetadata.request_attributes:type_name -> google.rpc.context.AttributeContext.Request
	18, // 15: google.cloud.audit.RequestMetadata.destination_attributes:type_name -> google.rpc.context.AttributeContext.Peer
	10, // 16: google.cloud.audit.ServiceAccountDelegationInfo.first_party_principal:type_name -> google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
	11, // 17: google.cloud.audit.ServiceAccountDelegationInfo.third_party_principal:type_name -> google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
	8,  // 18: google.cloud.audit.PolicyViolationInfo.org_policy_violation_info:type_name -> google.cloud.audit.OrgPolicyViolationInfo
	13, // 19: google.cloud.audit.OrgPolicyViolationInfo.payload:type_name -> google.protobuf.Struct
	12, // 20: google.cloud.audit.OrgPolicyViolationInfo.resource_tags:type_name -> google.cloud.audit.OrgPolicyViolationInfo.ResourceTagsEntry
	9,  // 21: google.cloud.audit.OrgPolicyViolationInfo.violation_info:type_name -> google.cloud.audit.ViolationInfo
	0,  // 22: google.cloud.audit.ViolationInfo.policy_type:type_name -> google.cloud.audit.ViolationInfo.PolicyType
	13, // 23: google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.service_metadata:type_name -> google.protobuf.Struct
	13, // 24: google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.third_party_claims:type_name -> google.protobuf.Struct
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_audit_audit_log_proto_init() }
func file_google_cloud_audit_audit_log_proto_init() {
	if File_google_cloud_audit_audit_log_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_audit_audit_log_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccountDelegationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyViolationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrgPolicyViolationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ViolationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccountDelegationInfo_FirstPartyPrincipal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccountDelegationInfo_ThirdPartyPrincipal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_audit_audit_log_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ServiceAccountDelegationInfo_FirstPartyPrincipal_)(nil),
		(*ServiceAccountDelegationInfo_ThirdPartyPrincipal_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_audit_audit_log_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_audit_audit_log_proto_goTypes,
		DependencyIndexes: file_google_cloud_audit_audit_log_proto_depIdxs,
		EnumInfos:         file_google_cloud_audit_audit_log_proto_enumTypes,
		MessageInfos:      file_google_cloud_audit_audit_log_proto_msgTypes,
	}.Build()
	File_google_cloud_audit_audit_log_proto = out.File
	file_google_cloud_audit_audit_log_proto_rawDesc = nil
	file_google_cloud_audit_audit_log_proto_goTypes = nil
	file_google_cloud_audit_audit_log_proto_depIdxs = nil
}
