// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package aiplatform

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"

	aiplatformpb "cloud.google.com/go/aiplatform/apiv1/aiplatformpb"
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/proto"
)

var newFeatureRegistryClientHook clientHook

// FeatureRegistryCallOptions contains the retry settings for each method of FeatureRegistryClient.
type FeatureRegistryCallOptions struct {
	CreateFeatureGroup  []gax.CallOption
	GetFeatureGroup     []gax.CallOption
	ListFeatureGroups   []gax.CallOption
	UpdateFeatureGroup  []gax.CallOption
	DeleteFeatureGroup  []gax.CallOption
	CreateFeature       []gax.CallOption
	BatchCreateFeatures []gax.CallOption
	GetFeature          []gax.CallOption
	ListFeatures        []gax.CallOption
	UpdateFeature       []gax.CallOption
	DeleteFeature       []gax.CallOption
	GetLocation         []gax.CallOption
	ListLocations       []gax.CallOption
	GetIamPolicy        []gax.CallOption
	SetIamPolicy        []gax.CallOption
	TestIamPermissions  []gax.CallOption
	CancelOperation     []gax.CallOption
	DeleteOperation     []gax.CallOption
	GetOperation        []gax.CallOption
	ListOperations      []gax.CallOption
	WaitOperation       []gax.CallOption
}

func defaultFeatureRegistryGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("aiplatform.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("aiplatform.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("aiplatform.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://aiplatform.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultFeatureRegistryCallOptions() *FeatureRegistryCallOptions {
	return &FeatureRegistryCallOptions{
		CreateFeatureGroup:  []gax.CallOption{},
		GetFeatureGroup:     []gax.CallOption{},
		ListFeatureGroups:   []gax.CallOption{},
		UpdateFeatureGroup:  []gax.CallOption{},
		DeleteFeatureGroup:  []gax.CallOption{},
		CreateFeature:       []gax.CallOption{},
		BatchCreateFeatures: []gax.CallOption{},
		GetFeature:          []gax.CallOption{},
		ListFeatures:        []gax.CallOption{},
		UpdateFeature:       []gax.CallOption{},
		DeleteFeature:       []gax.CallOption{},
		GetLocation:         []gax.CallOption{},
		ListLocations:       []gax.CallOption{},
		GetIamPolicy:        []gax.CallOption{},
		SetIamPolicy:        []gax.CallOption{},
		TestIamPermissions:  []gax.CallOption{},
		CancelOperation:     []gax.CallOption{},
		DeleteOperation:     []gax.CallOption{},
		GetOperation:        []gax.CallOption{},
		ListOperations:      []gax.CallOption{},
		WaitOperation:       []gax.CallOption{},
	}
}

// internalFeatureRegistryClient is an interface that defines the methods available from Vertex AI API.
type internalFeatureRegistryClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateFeatureGroup(context.Context, *aiplatformpb.CreateFeatureGroupRequest, ...gax.CallOption) (*CreateFeatureGroupOperation, error)
	CreateFeatureGroupOperation(name string) *CreateFeatureGroupOperation
	GetFeatureGroup(context.Context, *aiplatformpb.GetFeatureGroupRequest, ...gax.CallOption) (*aiplatformpb.FeatureGroup, error)
	ListFeatureGroups(context.Context, *aiplatformpb.ListFeatureGroupsRequest, ...gax.CallOption) *FeatureGroupIterator
	UpdateFeatureGroup(context.Context, *aiplatformpb.UpdateFeatureGroupRequest, ...gax.CallOption) (*UpdateFeatureGroupOperation, error)
	UpdateFeatureGroupOperation(name string) *UpdateFeatureGroupOperation
	DeleteFeatureGroup(context.Context, *aiplatformpb.DeleteFeatureGroupRequest, ...gax.CallOption) (*DeleteFeatureGroupOperation, error)
	DeleteFeatureGroupOperation(name string) *DeleteFeatureGroupOperation
	CreateFeature(context.Context, *aiplatformpb.CreateFeatureRequest, ...gax.CallOption) (*CreateFeatureOperation, error)
	CreateFeatureOperation(name string) *CreateFeatureOperation
	BatchCreateFeatures(context.Context, *aiplatformpb.BatchCreateFeaturesRequest, ...gax.CallOption) (*BatchCreateFeaturesOperation, error)
	BatchCreateFeaturesOperation(name string) *BatchCreateFeaturesOperation
	GetFeature(context.Context, *aiplatformpb.GetFeatureRequest, ...gax.CallOption) (*aiplatformpb.Feature, error)
	ListFeatures(context.Context, *aiplatformpb.ListFeaturesRequest, ...gax.CallOption) *FeatureIterator
	UpdateFeature(context.Context, *aiplatformpb.UpdateFeatureRequest, ...gax.CallOption) (*UpdateFeatureOperation, error)
	UpdateFeatureOperation(name string) *UpdateFeatureOperation
	DeleteFeature(context.Context, *aiplatformpb.DeleteFeatureRequest, ...gax.CallOption) (*DeleteFeatureOperation, error)
	DeleteFeatureOperation(name string) *DeleteFeatureOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
	WaitOperation(context.Context, *longrunningpb.WaitOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
}

// FeatureRegistryClient is a client for interacting with Vertex AI API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The service that handles CRUD and List for resources for
// FeatureRegistry.
type FeatureRegistryClient struct {
	// The internal transport-dependent client.
	internalClient internalFeatureRegistryClient

	// The call options for this service.
	CallOptions *FeatureRegistryCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *FeatureRegistryClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *FeatureRegistryClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *FeatureRegistryClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateFeatureGroup creates a new FeatureGroup in a given project and location.
func (c *FeatureRegistryClient) CreateFeatureGroup(ctx context.Context, req *aiplatformpb.CreateFeatureGroupRequest, opts ...gax.CallOption) (*CreateFeatureGroupOperation, error) {
	return c.internalClient.CreateFeatureGroup(ctx, req, opts...)
}

// CreateFeatureGroupOperation returns a new CreateFeatureGroupOperation from a given name.
// The name must be that of a previously created CreateFeatureGroupOperation, possibly from a different process.
func (c *FeatureRegistryClient) CreateFeatureGroupOperation(name string) *CreateFeatureGroupOperation {
	return c.internalClient.CreateFeatureGroupOperation(name)
}

// GetFeatureGroup gets details of a single FeatureGroup.
func (c *FeatureRegistryClient) GetFeatureGroup(ctx context.Context, req *aiplatformpb.GetFeatureGroupRequest, opts ...gax.CallOption) (*aiplatformpb.FeatureGroup, error) {
	return c.internalClient.GetFeatureGroup(ctx, req, opts...)
}

// ListFeatureGroups lists FeatureGroups in a given project and location.
func (c *FeatureRegistryClient) ListFeatureGroups(ctx context.Context, req *aiplatformpb.ListFeatureGroupsRequest, opts ...gax.CallOption) *FeatureGroupIterator {
	return c.internalClient.ListFeatureGroups(ctx, req, opts...)
}

// UpdateFeatureGroup updates the parameters of a single FeatureGroup.
func (c *FeatureRegistryClient) UpdateFeatureGroup(ctx context.Context, req *aiplatformpb.UpdateFeatureGroupRequest, opts ...gax.CallOption) (*UpdateFeatureGroupOperation, error) {
	return c.internalClient.UpdateFeatureGroup(ctx, req, opts...)
}

// UpdateFeatureGroupOperation returns a new UpdateFeatureGroupOperation from a given name.
// The name must be that of a previously created UpdateFeatureGroupOperation, possibly from a different process.
func (c *FeatureRegistryClient) UpdateFeatureGroupOperation(name string) *UpdateFeatureGroupOperation {
	return c.internalClient.UpdateFeatureGroupOperation(name)
}

// DeleteFeatureGroup deletes a single FeatureGroup.
func (c *FeatureRegistryClient) DeleteFeatureGroup(ctx context.Context, req *aiplatformpb.DeleteFeatureGroupRequest, opts ...gax.CallOption) (*DeleteFeatureGroupOperation, error) {
	return c.internalClient.DeleteFeatureGroup(ctx, req, opts...)
}

// DeleteFeatureGroupOperation returns a new DeleteFeatureGroupOperation from a given name.
// The name must be that of a previously created DeleteFeatureGroupOperation, possibly from a different process.
func (c *FeatureRegistryClient) DeleteFeatureGroupOperation(name string) *DeleteFeatureGroupOperation {
	return c.internalClient.DeleteFeatureGroupOperation(name)
}

// CreateFeature creates a new Feature in a given FeatureGroup.
func (c *FeatureRegistryClient) CreateFeature(ctx context.Context, req *aiplatformpb.CreateFeatureRequest, opts ...gax.CallOption) (*CreateFeatureOperation, error) {
	return c.internalClient.CreateFeature(ctx, req, opts...)
}

// CreateFeatureOperation returns a new CreateFeatureOperation from a given name.
// The name must be that of a previously created CreateFeatureOperation, possibly from a different process.
func (c *FeatureRegistryClient) CreateFeatureOperation(name string) *CreateFeatureOperation {
	return c.internalClient.CreateFeatureOperation(name)
}

// BatchCreateFeatures creates a batch of Features in a given FeatureGroup.
func (c *FeatureRegistryClient) BatchCreateFeatures(ctx context.Context, req *aiplatformpb.BatchCreateFeaturesRequest, opts ...gax.CallOption) (*BatchCreateFeaturesOperation, error) {
	return c.internalClient.BatchCreateFeatures(ctx, req, opts...)
}

// BatchCreateFeaturesOperation returns a new BatchCreateFeaturesOperation from a given name.
// The name must be that of a previously created BatchCreateFeaturesOperation, possibly from a different process.
func (c *FeatureRegistryClient) BatchCreateFeaturesOperation(name string) *BatchCreateFeaturesOperation {
	return c.internalClient.BatchCreateFeaturesOperation(name)
}

// GetFeature gets details of a single Feature.
func (c *FeatureRegistryClient) GetFeature(ctx context.Context, req *aiplatformpb.GetFeatureRequest, opts ...gax.CallOption) (*aiplatformpb.Feature, error) {
	return c.internalClient.GetFeature(ctx, req, opts...)
}

// ListFeatures lists Features in a given FeatureGroup.
func (c *FeatureRegistryClient) ListFeatures(ctx context.Context, req *aiplatformpb.ListFeaturesRequest, opts ...gax.CallOption) *FeatureIterator {
	return c.internalClient.ListFeatures(ctx, req, opts...)
}

// UpdateFeature updates the parameters of a single Feature.
func (c *FeatureRegistryClient) UpdateFeature(ctx context.Context, req *aiplatformpb.UpdateFeatureRequest, opts ...gax.CallOption) (*UpdateFeatureOperation, error) {
	return c.internalClient.UpdateFeature(ctx, req, opts...)
}

// UpdateFeatureOperation returns a new UpdateFeatureOperation from a given name.
// The name must be that of a previously created UpdateFeatureOperation, possibly from a different process.
func (c *FeatureRegistryClient) UpdateFeatureOperation(name string) *UpdateFeatureOperation {
	return c.internalClient.UpdateFeatureOperation(name)
}

// DeleteFeature deletes a single Feature.
func (c *FeatureRegistryClient) DeleteFeature(ctx context.Context, req *aiplatformpb.DeleteFeatureRequest, opts ...gax.CallOption) (*DeleteFeatureOperation, error) {
	return c.internalClient.DeleteFeature(ctx, req, opts...)
}

// DeleteFeatureOperation returns a new DeleteFeatureOperation from a given name.
// The name must be that of a previously created DeleteFeatureOperation, possibly from a different process.
func (c *FeatureRegistryClient) DeleteFeatureOperation(name string) *DeleteFeatureOperation {
	return c.internalClient.DeleteFeatureOperation(name)
}

// GetLocation gets information about a location.
func (c *FeatureRegistryClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *FeatureRegistryClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *FeatureRegistryClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *FeatureRegistryClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *FeatureRegistryClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *FeatureRegistryClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *FeatureRegistryClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *FeatureRegistryClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *FeatureRegistryClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// WaitOperation is a utility method from google.longrunning.Operations.
func (c *FeatureRegistryClient) WaitOperation(ctx context.Context, req *longrunningpb.WaitOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.WaitOperation(ctx, req, opts...)
}

// featureRegistryGRPCClient is a client for interacting with Vertex AI API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type featureRegistryGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing FeatureRegistryClient
	CallOptions **FeatureRegistryCallOptions

	// The gRPC API client.
	featureRegistryClient aiplatformpb.FeatureRegistryServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewFeatureRegistryClient creates a new feature registry service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The service that handles CRUD and List for resources for
// FeatureRegistry.
func NewFeatureRegistryClient(ctx context.Context, opts ...option.ClientOption) (*FeatureRegistryClient, error) {
	clientOpts := defaultFeatureRegistryGRPCClientOptions()
	if newFeatureRegistryClientHook != nil {
		hookOpts, err := newFeatureRegistryClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := FeatureRegistryClient{CallOptions: defaultFeatureRegistryCallOptions()}

	c := &featureRegistryGRPCClient{
		connPool:              connPool,
		featureRegistryClient: aiplatformpb.NewFeatureRegistryServiceClient(connPool),
		CallOptions:           &client.CallOptions,
		logger:                internaloption.GetLogger(opts),
		operationsClient:      longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:       iampb.NewIAMPolicyClient(connPool),
		locationsClient:       locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *featureRegistryGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *featureRegistryGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *featureRegistryGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *featureRegistryGRPCClient) CreateFeatureGroup(ctx context.Context, req *aiplatformpb.CreateFeatureGroupRequest, opts ...gax.CallOption) (*CreateFeatureGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateFeatureGroup[0:len((*c.CallOptions).CreateFeatureGroup):len((*c.CallOptions).CreateFeatureGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.CreateFeatureGroup, req, settings.GRPC, c.logger, "CreateFeatureGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateFeatureGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *featureRegistryGRPCClient) GetFeatureGroup(ctx context.Context, req *aiplatformpb.GetFeatureGroupRequest, opts ...gax.CallOption) (*aiplatformpb.FeatureGroup, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetFeatureGroup[0:len((*c.CallOptions).GetFeatureGroup):len((*c.CallOptions).GetFeatureGroup)], opts...)
	var resp *aiplatformpb.FeatureGroup
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.GetFeatureGroup, req, settings.GRPC, c.logger, "GetFeatureGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *featureRegistryGRPCClient) ListFeatureGroups(ctx context.Context, req *aiplatformpb.ListFeatureGroupsRequest, opts ...gax.CallOption) *FeatureGroupIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListFeatureGroups[0:len((*c.CallOptions).ListFeatureGroups):len((*c.CallOptions).ListFeatureGroups)], opts...)
	it := &FeatureGroupIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListFeatureGroupsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.FeatureGroup, string, error) {
		resp := &aiplatformpb.ListFeatureGroupsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.featureRegistryClient.ListFeatureGroups, req, settings.GRPC, c.logger, "ListFeatureGroups")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetFeatureGroups(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *featureRegistryGRPCClient) UpdateFeatureGroup(ctx context.Context, req *aiplatformpb.UpdateFeatureGroupRequest, opts ...gax.CallOption) (*UpdateFeatureGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "feature_group.name", url.QueryEscape(req.GetFeatureGroup().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateFeatureGroup[0:len((*c.CallOptions).UpdateFeatureGroup):len((*c.CallOptions).UpdateFeatureGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.UpdateFeatureGroup, req, settings.GRPC, c.logger, "UpdateFeatureGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateFeatureGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *featureRegistryGRPCClient) DeleteFeatureGroup(ctx context.Context, req *aiplatformpb.DeleteFeatureGroupRequest, opts ...gax.CallOption) (*DeleteFeatureGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteFeatureGroup[0:len((*c.CallOptions).DeleteFeatureGroup):len((*c.CallOptions).DeleteFeatureGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.DeleteFeatureGroup, req, settings.GRPC, c.logger, "DeleteFeatureGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteFeatureGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *featureRegistryGRPCClient) CreateFeature(ctx context.Context, req *aiplatformpb.CreateFeatureRequest, opts ...gax.CallOption) (*CreateFeatureOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateFeature[0:len((*c.CallOptions).CreateFeature):len((*c.CallOptions).CreateFeature)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.CreateFeature, req, settings.GRPC, c.logger, "CreateFeature")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateFeatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *featureRegistryGRPCClient) BatchCreateFeatures(ctx context.Context, req *aiplatformpb.BatchCreateFeaturesRequest, opts ...gax.CallOption) (*BatchCreateFeaturesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).BatchCreateFeatures[0:len((*c.CallOptions).BatchCreateFeatures):len((*c.CallOptions).BatchCreateFeatures)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.BatchCreateFeatures, req, settings.GRPC, c.logger, "BatchCreateFeatures")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &BatchCreateFeaturesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *featureRegistryGRPCClient) GetFeature(ctx context.Context, req *aiplatformpb.GetFeatureRequest, opts ...gax.CallOption) (*aiplatformpb.Feature, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetFeature[0:len((*c.CallOptions).GetFeature):len((*c.CallOptions).GetFeature)], opts...)
	var resp *aiplatformpb.Feature
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.GetFeature, req, settings.GRPC, c.logger, "GetFeature")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *featureRegistryGRPCClient) ListFeatures(ctx context.Context, req *aiplatformpb.ListFeaturesRequest, opts ...gax.CallOption) *FeatureIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListFeatures[0:len((*c.CallOptions).ListFeatures):len((*c.CallOptions).ListFeatures)], opts...)
	it := &FeatureIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListFeaturesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.Feature, string, error) {
		resp := &aiplatformpb.ListFeaturesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.featureRegistryClient.ListFeatures, req, settings.GRPC, c.logger, "ListFeatures")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetFeatures(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *featureRegistryGRPCClient) UpdateFeature(ctx context.Context, req *aiplatformpb.UpdateFeatureRequest, opts ...gax.CallOption) (*UpdateFeatureOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "feature.name", url.QueryEscape(req.GetFeature().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateFeature[0:len((*c.CallOptions).UpdateFeature):len((*c.CallOptions).UpdateFeature)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.UpdateFeature, req, settings.GRPC, c.logger, "UpdateFeature")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateFeatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *featureRegistryGRPCClient) DeleteFeature(ctx context.Context, req *aiplatformpb.DeleteFeatureRequest, opts ...gax.CallOption) (*DeleteFeatureOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteFeature[0:len((*c.CallOptions).DeleteFeature):len((*c.CallOptions).DeleteFeature)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.featureRegistryClient.DeleteFeature, req, settings.GRPC, c.logger, "DeleteFeature")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteFeatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *featureRegistryGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *featureRegistryGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *featureRegistryGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.GetIamPolicy, req, settings.GRPC, c.logger, "GetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *featureRegistryGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.SetIamPolicy, req, settings.GRPC, c.logger, "SetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *featureRegistryGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.TestIamPermissions, req, settings.GRPC, c.logger, "TestIamPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *featureRegistryGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *featureRegistryGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *featureRegistryGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *featureRegistryGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *featureRegistryGRPCClient) WaitOperation(ctx context.Context, req *longrunningpb.WaitOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).WaitOperation[0:len((*c.CallOptions).WaitOperation):len((*c.CallOptions).WaitOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.WaitOperation, req, settings.GRPC, c.logger, "WaitOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// BatchCreateFeaturesOperation returns a new BatchCreateFeaturesOperation from a given name.
// The name must be that of a previously created BatchCreateFeaturesOperation, possibly from a different process.
func (c *featureRegistryGRPCClient) BatchCreateFeaturesOperation(name string) *BatchCreateFeaturesOperation {
	return &BatchCreateFeaturesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateFeatureOperation returns a new CreateFeatureOperation from a given name.
// The name must be that of a previously created CreateFeatureOperation, possibly from a different process.
func (c *featureRegistryGRPCClient) CreateFeatureOperation(name string) *CreateFeatureOperation {
	return &CreateFeatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateFeatureGroupOperation returns a new CreateFeatureGroupOperation from a given name.
// The name must be that of a previously created CreateFeatureGroupOperation, possibly from a different process.
func (c *featureRegistryGRPCClient) CreateFeatureGroupOperation(name string) *CreateFeatureGroupOperation {
	return &CreateFeatureGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteFeatureOperation returns a new DeleteFeatureOperation from a given name.
// The name must be that of a previously created DeleteFeatureOperation, possibly from a different process.
func (c *featureRegistryGRPCClient) DeleteFeatureOperation(name string) *DeleteFeatureOperation {
	return &DeleteFeatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteFeatureGroupOperation returns a new DeleteFeatureGroupOperation from a given name.
// The name must be that of a previously created DeleteFeatureGroupOperation, possibly from a different process.
func (c *featureRegistryGRPCClient) DeleteFeatureGroupOperation(name string) *DeleteFeatureGroupOperation {
	return &DeleteFeatureGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateFeatureOperation returns a new UpdateFeatureOperation from a given name.
// The name must be that of a previously created UpdateFeatureOperation, possibly from a different process.
func (c *featureRegistryGRPCClient) UpdateFeatureOperation(name string) *UpdateFeatureOperation {
	return &UpdateFeatureOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateFeatureGroupOperation returns a new UpdateFeatureGroupOperation from a given name.
// The name must be that of a previously created UpdateFeatureGroupOperation, possibly from a different process.
func (c *featureRegistryGRPCClient) UpdateFeatureGroupOperation(name string) *UpdateFeatureGroupOperation {
	return &UpdateFeatureGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
