// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/backupdr/v1/backupvault.proto

package backupdrpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Backup configuration state. Is the resource configured for backup?
type BackupConfigState int32

const (
	// The possible states of backup configuration.
	// Status not set.
	BackupConfigState_BACKUP_CONFIG_STATE_UNSPECIFIED BackupConfigState = 0
	// The data source is actively protected (i.e. there is a
	// BackupPlanAssociation or Appliance SLA pointing to it)
	BackupConfigState_ACTIVE BackupConfigState = 1
	// The data source is no longer protected (but may have backups under it)
	BackupConfigState_PASSIVE BackupConfigState = 2
)

// Enum value maps for BackupConfigState.
var (
	BackupConfigState_name = map[int32]string{
		0: "BACKUP_CONFIG_STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "PASSIVE",
	}
	BackupConfigState_value = map[string]int32{
		"BACKUP_CONFIG_STATE_UNSPECIFIED": 0,
		"ACTIVE":                          1,
		"PASSIVE":                         2,
	}
)

func (x BackupConfigState) Enum() *BackupConfigState {
	p := new(BackupConfigState)
	*p = x
	return p
}

func (x BackupConfigState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupConfigState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[0].Descriptor()
}

func (BackupConfigState) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[0]
}

func (x BackupConfigState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupConfigState.Descriptor instead.
func (BackupConfigState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{0}
}

// BackupView contains enum options for Partial and Full view.
type BackupView int32

const (
	// If the value is not set, the default 'FULL' view is used.
	BackupView_BACKUP_VIEW_UNSPECIFIED BackupView = 0
	// Includes basic data about the Backup, but not the full contents.
	BackupView_BACKUP_VIEW_BASIC BackupView = 1
	// Includes all data about the Backup.
	// This is the default value (for both ListBackups and GetBackup).
	BackupView_BACKUP_VIEW_FULL BackupView = 2
)

// Enum value maps for BackupView.
var (
	BackupView_name = map[int32]string{
		0: "BACKUP_VIEW_UNSPECIFIED",
		1: "BACKUP_VIEW_BASIC",
		2: "BACKUP_VIEW_FULL",
	}
	BackupView_value = map[string]int32{
		"BACKUP_VIEW_UNSPECIFIED": 0,
		"BACKUP_VIEW_BASIC":       1,
		"BACKUP_VIEW_FULL":        2,
	}
)

func (x BackupView) Enum() *BackupView {
	p := new(BackupView)
	*p = x
	return p
}

func (x BackupView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[1].Descriptor()
}

func (BackupView) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[1]
}

func (x BackupView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupView.Descriptor instead.
func (BackupView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{1}
}

// BackupVaultView contains enum options for Partial and Full view.
type BackupVaultView int32

const (
	// If the value is not set, the default 'FULL' view is used.
	BackupVaultView_BACKUP_VAULT_VIEW_UNSPECIFIED BackupVaultView = 0
	// Includes basic data about the Backup Vault, but not the full contents.
	BackupVaultView_BACKUP_VAULT_VIEW_BASIC BackupVaultView = 1
	// Includes all data about the Backup Vault.
	// This is the default value (for both ListBackupVaults and GetBackupVault).
	BackupVaultView_BACKUP_VAULT_VIEW_FULL BackupVaultView = 2
)

// Enum value maps for BackupVaultView.
var (
	BackupVaultView_name = map[int32]string{
		0: "BACKUP_VAULT_VIEW_UNSPECIFIED",
		1: "BACKUP_VAULT_VIEW_BASIC",
		2: "BACKUP_VAULT_VIEW_FULL",
	}
	BackupVaultView_value = map[string]int32{
		"BACKUP_VAULT_VIEW_UNSPECIFIED": 0,
		"BACKUP_VAULT_VIEW_BASIC":       1,
		"BACKUP_VAULT_VIEW_FULL":        2,
	}
)

func (x BackupVaultView) Enum() *BackupVaultView {
	p := new(BackupVaultView)
	*p = x
	return p
}

func (x BackupVaultView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupVaultView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[2].Descriptor()
}

func (BackupVaultView) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[2]
}

func (x BackupVaultView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupVaultView.Descriptor instead.
func (BackupVaultView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{2}
}

// Holds the state of the backup vault resource.
type BackupVault_State int32

const (
	// State not set.
	BackupVault_STATE_UNSPECIFIED BackupVault_State = 0
	// The backup vault is being created.
	BackupVault_CREATING BackupVault_State = 1
	// The backup vault has been created and is fully usable.
	BackupVault_ACTIVE BackupVault_State = 2
	// The backup vault is being deleted.
	BackupVault_DELETING BackupVault_State = 3
	// The backup vault is experiencing an issue and might be unusable.
	BackupVault_ERROR BackupVault_State = 4
)

// Enum value maps for BackupVault_State.
var (
	BackupVault_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "ERROR",
	}
	BackupVault_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"ERROR":             4,
	}
)

func (x BackupVault_State) Enum() *BackupVault_State {
	p := new(BackupVault_State)
	*p = x
	return p
}

func (x BackupVault_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupVault_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[3].Descriptor()
}

func (BackupVault_State) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[3]
}

func (x BackupVault_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupVault_State.Descriptor instead.
func (BackupVault_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{0, 0}
}

// Holds the access restriction for the backup vault.
type BackupVault_AccessRestriction int32

const (
	// Access restriction not set. If user does not provide any value or pass
	// this value, it will be changed to WITHIN_ORGANIZATION.
	BackupVault_ACCESS_RESTRICTION_UNSPECIFIED BackupVault_AccessRestriction = 0
	// Access to or from resources outside your current project will be denied.
	BackupVault_WITHIN_PROJECT BackupVault_AccessRestriction = 1
	// Access to or from resources outside your current organization will be
	// denied.
	BackupVault_WITHIN_ORGANIZATION BackupVault_AccessRestriction = 2
	// No access restriction.
	BackupVault_UNRESTRICTED BackupVault_AccessRestriction = 3
	// Access to or from resources outside your current organization will be
	// denied except for backup appliance.
	BackupVault_WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA BackupVault_AccessRestriction = 4
)

// Enum value maps for BackupVault_AccessRestriction.
var (
	BackupVault_AccessRestriction_name = map[int32]string{
		0: "ACCESS_RESTRICTION_UNSPECIFIED",
		1: "WITHIN_PROJECT",
		2: "WITHIN_ORGANIZATION",
		3: "UNRESTRICTED",
		4: "WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA",
	}
	BackupVault_AccessRestriction_value = map[string]int32{
		"ACCESS_RESTRICTION_UNSPECIFIED":     0,
		"WITHIN_PROJECT":                     1,
		"WITHIN_ORGANIZATION":                2,
		"UNRESTRICTED":                       3,
		"WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA": 4,
	}
)

func (x BackupVault_AccessRestriction) Enum() *BackupVault_AccessRestriction {
	p := new(BackupVault_AccessRestriction)
	*p = x
	return p
}

func (x BackupVault_AccessRestriction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupVault_AccessRestriction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[4].Descriptor()
}

func (BackupVault_AccessRestriction) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[4]
}

func (x BackupVault_AccessRestriction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupVault_AccessRestriction.Descriptor instead.
func (BackupVault_AccessRestriction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{0, 1}
}

// Holds the state of the data source resource.
type DataSource_State int32

const (
	// State not set.
	DataSource_STATE_UNSPECIFIED DataSource_State = 0
	// The data source is being created.
	DataSource_CREATING DataSource_State = 1
	// The data source has been created and is fully usable.
	DataSource_ACTIVE DataSource_State = 2
	// The data source is being deleted.
	DataSource_DELETING DataSource_State = 3
	// The data source is experiencing an issue and might be unusable.
	DataSource_ERROR DataSource_State = 4
)

// Enum value maps for DataSource_State.
var (
	DataSource_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "ERROR",
	}
	DataSource_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"ERROR":             4,
	}
)

func (x DataSource_State) Enum() *DataSource_State {
	p := new(DataSource_State)
	*p = x
	return p
}

func (x DataSource_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSource_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[5].Descriptor()
}

func (DataSource_State) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[5]
}

func (x DataSource_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSource_State.Descriptor instead.
func (DataSource_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{1, 0}
}

// LastBackupstate tracks whether the last backup was not yet started,
// successful, failed, or could not be run because of the lack of permissions.
type BackupConfigInfo_LastBackupState int32

const (
	// Status not set.
	BackupConfigInfo_LAST_BACKUP_STATE_UNSPECIFIED BackupConfigInfo_LastBackupState = 0
	// The first backup has not yet completed
	BackupConfigInfo_FIRST_BACKUP_PENDING BackupConfigInfo_LastBackupState = 1
	// The most recent backup was successful
	BackupConfigInfo_SUCCEEDED BackupConfigInfo_LastBackupState = 2
	// The most recent backup failed
	BackupConfigInfo_FAILED BackupConfigInfo_LastBackupState = 3
	// The most recent backup could not be run/failed because of the lack of
	// permissions
	BackupConfigInfo_PERMISSION_DENIED BackupConfigInfo_LastBackupState = 4
)

// Enum value maps for BackupConfigInfo_LastBackupState.
var (
	BackupConfigInfo_LastBackupState_name = map[int32]string{
		0: "LAST_BACKUP_STATE_UNSPECIFIED",
		1: "FIRST_BACKUP_PENDING",
		2: "SUCCEEDED",
		3: "FAILED",
		4: "PERMISSION_DENIED",
	}
	BackupConfigInfo_LastBackupState_value = map[string]int32{
		"LAST_BACKUP_STATE_UNSPECIFIED": 0,
		"FIRST_BACKUP_PENDING":          1,
		"SUCCEEDED":                     2,
		"FAILED":                        3,
		"PERMISSION_DENIED":             4,
	}
)

func (x BackupConfigInfo_LastBackupState) Enum() *BackupConfigInfo_LastBackupState {
	p := new(BackupConfigInfo_LastBackupState)
	*p = x
	return p
}

func (x BackupConfigInfo_LastBackupState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupConfigInfo_LastBackupState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[6].Descriptor()
}

func (BackupConfigInfo_LastBackupState) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[6]
}

func (x BackupConfigInfo_LastBackupState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupConfigInfo_LastBackupState.Descriptor instead.
func (BackupConfigInfo_LastBackupState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{2, 0}
}

// Holds the state of the backup resource.
type Backup_State int32

const (
	// State not set.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// The backup is being created.
	Backup_CREATING Backup_State = 1
	// The backup has been created and is fully usable.
	Backup_ACTIVE Backup_State = 2
	// The backup is being deleted.
	Backup_DELETING Backup_State = 3
	// The backup is experiencing an issue and might be unusable.
	Backup_ERROR Backup_State = 4
)

// Enum value maps for Backup_State.
var (
	Backup_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "ERROR",
	}
	Backup_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"ERROR":             4,
	}
)

func (x Backup_State) Enum() *Backup_State {
	p := new(Backup_State)
	*p = x
	return p
}

func (x Backup_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[7].Descriptor()
}

func (Backup_State) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[7]
}

func (x Backup_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_State.Descriptor instead.
func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{10, 0}
}

// Type of the backup, scheduled or ondemand.
type Backup_BackupType int32

const (
	// Backup type is unspecified.
	Backup_BACKUP_TYPE_UNSPECIFIED Backup_BackupType = 0
	// Scheduled backup.
	Backup_SCHEDULED Backup_BackupType = 1
	// On demand backup.
	Backup_ON_DEMAND Backup_BackupType = 2
)

// Enum value maps for Backup_BackupType.
var (
	Backup_BackupType_name = map[int32]string{
		0: "BACKUP_TYPE_UNSPECIFIED",
		1: "SCHEDULED",
		2: "ON_DEMAND",
	}
	Backup_BackupType_value = map[string]int32{
		"BACKUP_TYPE_UNSPECIFIED": 0,
		"SCHEDULED":               1,
		"ON_DEMAND":               2,
	}
)

func (x Backup_BackupType) Enum() *Backup_BackupType {
	p := new(Backup_BackupType)
	*p = x
	return p
}

func (x Backup_BackupType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_BackupType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[8].Descriptor()
}

func (Backup_BackupType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupvault_proto_enumTypes[8]
}

func (x Backup_BackupType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_BackupType.Descriptor instead.
func (Backup_BackupType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{10, 1}
}

// Message describing a BackupVault object.
type BackupVault struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. Name of the backup vault to create. It must have
	// the
	// format`"projects/{project}/locations/{location}/backupVaults/{backupvault}"`.
	// `{backupvault}` cannot be changed after creation. It must be between 3-63
	// characters long and must be unique within the project and location.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The description of the BackupVault instance (2048 characters or
	// less).
	Description *string `protobuf:"bytes,2,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Optional. Resource labels to represent user provided metadata.
	// No labels currently defined:
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The time when the instance was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3,oneof" json:"create_time,omitempty"`
	// Output only. The time when the instance was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3,oneof" json:"update_time,omitempty"`
	// Required. The default and minimum enforced retention for each backup within
	// the backup vault.  The enforced retention for each backup can be extended.
	BackupMinimumEnforcedRetentionDuration *durationpb.Duration `protobuf:"bytes,20,opt,name=backup_minimum_enforced_retention_duration,json=backupMinimumEnforcedRetentionDuration,proto3,oneof" json:"backup_minimum_enforced_retention_duration,omitempty"`
	// Output only. Set to true when there are no backups nested under this
	// resource.
	Deletable *bool `protobuf:"varint,8,opt,name=deletable,proto3,oneof" json:"deletable,omitempty"`
	// Optional. Server specified ETag for the backup vault resource to
	// prevent simultaneous updates from overwiting each other.
	Etag *string `protobuf:"bytes,9,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
	// Output only. The BackupVault resource instance state.
	State BackupVault_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.backupdr.v1.BackupVault_State" json:"state,omitempty"`
	// Optional. Time after which the BackupVault resource is locked.
	EffectiveTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=effective_time,json=effectiveTime,proto3,oneof" json:"effective_time,omitempty"`
	// Output only. The number of backups in this backup vault.
	BackupCount int64 `protobuf:"varint,17,opt,name=backup_count,json=backupCount,proto3" json:"backup_count,omitempty"`
	// Output only. Service account used by the BackupVault Service for this
	// BackupVault.  The user should grant this account permissions in their
	// workload project to enable the service to run backups and restores there.
	ServiceAccount string `protobuf:"bytes,18,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. Total size of the storage used by all backup resources.
	TotalStoredBytes int64 `protobuf:"varint,19,opt,name=total_stored_bytes,json=totalStoredBytes,proto3" json:"total_stored_bytes,omitempty"`
	// Output only. Immutable after resource creation until resource deletion.
	Uid string `protobuf:"bytes,21,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. User annotations. See https://google.aip.dev/128#annotations
	// Stores small amounts of arbitrary data.
	Annotations map[string]string `protobuf:"bytes,22,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Note: This field is added for future use case and will not be
	// supported in the current release.
	//
	// Access restriction for the backup vault.
	// Default value is WITHIN_ORGANIZATION if not provided during creation.
	AccessRestriction BackupVault_AccessRestriction `protobuf:"varint,24,opt,name=access_restriction,json=accessRestriction,proto3,enum=google.cloud.backupdr.v1.BackupVault_AccessRestriction" json:"access_restriction,omitempty"`
}

func (x *BackupVault) Reset() {
	*x = BackupVault{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupVault) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupVault) ProtoMessage() {}

func (x *BackupVault) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupVault.ProtoReflect.Descriptor instead.
func (*BackupVault) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{0}
}

func (x *BackupVault) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackupVault) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *BackupVault) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *BackupVault) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BackupVault) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BackupVault) GetBackupMinimumEnforcedRetentionDuration() *durationpb.Duration {
	if x != nil {
		return x.BackupMinimumEnforcedRetentionDuration
	}
	return nil
}

func (x *BackupVault) GetDeletable() bool {
	if x != nil && x.Deletable != nil {
		return *x.Deletable
	}
	return false
}

func (x *BackupVault) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

func (x *BackupVault) GetState() BackupVault_State {
	if x != nil {
		return x.State
	}
	return BackupVault_STATE_UNSPECIFIED
}

func (x *BackupVault) GetEffectiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EffectiveTime
	}
	return nil
}

func (x *BackupVault) GetBackupCount() int64 {
	if x != nil {
		return x.BackupCount
	}
	return 0
}

func (x *BackupVault) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *BackupVault) GetTotalStoredBytes() int64 {
	if x != nil {
		return x.TotalStoredBytes
	}
	return 0
}

func (x *BackupVault) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *BackupVault) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *BackupVault) GetAccessRestriction() BackupVault_AccessRestriction {
	if x != nil {
		return x.AccessRestriction
	}
	return BackupVault_ACCESS_RESTRICTION_UNSPECIFIED
}

// Message describing a DataSource object.
// Datasource object used to represent Datasource details for both admin and
// basic view.
type DataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. Name of the datasource to create.
	// It must have the
	// format`"projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}"`.
	// `{datasource}` cannot be changed after creation. It must be between 3-63
	// characters long and must be unique within the backup vault.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The DataSource resource instance state.
	State DataSource_State `protobuf:"varint,21,opt,name=state,proto3,enum=google.cloud.backupdr.v1.DataSource_State" json:"state,omitempty"`
	// Optional. Resource labels to represent user provided metadata.
	// No labels currently defined:
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The time when the instance was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3,oneof" json:"create_time,omitempty"`
	// Output only. The time when the instance was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3,oneof" json:"update_time,omitempty"`
	// Number of backups in the data source.
	BackupCount *int64 `protobuf:"varint,7,opt,name=backup_count,json=backupCount,proto3,oneof" json:"backup_count,omitempty"`
	// Server specified ETag for the ManagementServer resource to prevent
	// simultaneous updates from overwiting each other.
	Etag *string `protobuf:"bytes,14,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
	// The number of bytes (metadata and data) stored in this datasource.
	TotalStoredBytes *int64 `protobuf:"varint,23,opt,name=total_stored_bytes,json=totalStoredBytes,proto3,oneof" json:"total_stored_bytes,omitempty"`
	// Output only. The backup configuration state.
	ConfigState BackupConfigState `protobuf:"varint,24,opt,name=config_state,json=configState,proto3,enum=google.cloud.backupdr.v1.BackupConfigState" json:"config_state,omitempty"`
	// Output only. Details of how the resource is configured for backup.
	BackupConfigInfo *BackupConfigInfo `protobuf:"bytes,25,opt,name=backup_config_info,json=backupConfigInfo,proto3" json:"backup_config_info,omitempty"`
	// The source resource that is represented by this DataSource. It can be a
	// Google Cloud resource, or one backed up by a Backup Appliance.
	//
	// Types that are assignable to SourceResource:
	//
	//	*DataSource_DataSourceGcpResource
	//	*DataSource_DataSourceBackupApplianceApplication
	SourceResource isDataSource_SourceResource `protobuf_oneof:"source_resource"`
}

func (x *DataSource) Reset() {
	*x = DataSource{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSource) ProtoMessage() {}

func (x *DataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSource.ProtoReflect.Descriptor instead.
func (*DataSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{1}
}

func (x *DataSource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataSource) GetState() DataSource_State {
	if x != nil {
		return x.State
	}
	return DataSource_STATE_UNSPECIFIED
}

func (x *DataSource) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DataSource) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DataSource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DataSource) GetBackupCount() int64 {
	if x != nil && x.BackupCount != nil {
		return *x.BackupCount
	}
	return 0
}

func (x *DataSource) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

func (x *DataSource) GetTotalStoredBytes() int64 {
	if x != nil && x.TotalStoredBytes != nil {
		return *x.TotalStoredBytes
	}
	return 0
}

func (x *DataSource) GetConfigState() BackupConfigState {
	if x != nil {
		return x.ConfigState
	}
	return BackupConfigState_BACKUP_CONFIG_STATE_UNSPECIFIED
}

func (x *DataSource) GetBackupConfigInfo() *BackupConfigInfo {
	if x != nil {
		return x.BackupConfigInfo
	}
	return nil
}

func (m *DataSource) GetSourceResource() isDataSource_SourceResource {
	if m != nil {
		return m.SourceResource
	}
	return nil
}

func (x *DataSource) GetDataSourceGcpResource() *DataSourceGcpResource {
	if x, ok := x.GetSourceResource().(*DataSource_DataSourceGcpResource); ok {
		return x.DataSourceGcpResource
	}
	return nil
}

func (x *DataSource) GetDataSourceBackupApplianceApplication() *DataSourceBackupApplianceApplication {
	if x, ok := x.GetSourceResource().(*DataSource_DataSourceBackupApplianceApplication); ok {
		return x.DataSourceBackupApplianceApplication
	}
	return nil
}

type isDataSource_SourceResource interface {
	isDataSource_SourceResource()
}

type DataSource_DataSourceGcpResource struct {
	// The backed up resource is a Google Cloud resource.
	// The word 'DataSource' was included in the names to indicate that this is
	// the representation of the Google Cloud resource used within the
	// DataSource object.
	DataSourceGcpResource *DataSourceGcpResource `protobuf:"bytes,26,opt,name=data_source_gcp_resource,json=dataSourceGcpResource,proto3,oneof"`
}

type DataSource_DataSourceBackupApplianceApplication struct {
	// The backed up resource is a backup appliance application.
	DataSourceBackupApplianceApplication *DataSourceBackupApplianceApplication `protobuf:"bytes,27,opt,name=data_source_backup_appliance_application,json=dataSourceBackupApplianceApplication,proto3,oneof"`
}

func (*DataSource_DataSourceGcpResource) isDataSource_SourceResource() {}

func (*DataSource_DataSourceBackupApplianceApplication) isDataSource_SourceResource() {}

// BackupConfigInfo has information about how the resource is configured
// for Backup and about the most recent backup to this vault.
type BackupConfigInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The status of the last backup to this BackupVault
	LastBackupState BackupConfigInfo_LastBackupState `protobuf:"varint,1,opt,name=last_backup_state,json=lastBackupState,proto3,enum=google.cloud.backupdr.v1.BackupConfigInfo_LastBackupState" json:"last_backup_state,omitempty"`
	// Output only. If the last backup were successful, this field has the
	// consistency date.
	LastSuccessfulBackupConsistencyTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_successful_backup_consistency_time,json=lastSuccessfulBackupConsistencyTime,proto3" json:"last_successful_backup_consistency_time,omitempty"`
	// Output only. If the last backup failed, this field has the error message.
	LastBackupError *status.Status `protobuf:"bytes,3,opt,name=last_backup_error,json=lastBackupError,proto3" json:"last_backup_error,omitempty"`
	// Configuration Info has the resource format-specific configuration.
	//
	// Types that are assignable to BackupConfig:
	//
	//	*BackupConfigInfo_GcpBackupConfig
	//	*BackupConfigInfo_BackupApplianceBackupConfig
	BackupConfig isBackupConfigInfo_BackupConfig `protobuf_oneof:"backup_config"`
}

func (x *BackupConfigInfo) Reset() {
	*x = BackupConfigInfo{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupConfigInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupConfigInfo) ProtoMessage() {}

func (x *BackupConfigInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupConfigInfo.ProtoReflect.Descriptor instead.
func (*BackupConfigInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{2}
}

func (x *BackupConfigInfo) GetLastBackupState() BackupConfigInfo_LastBackupState {
	if x != nil {
		return x.LastBackupState
	}
	return BackupConfigInfo_LAST_BACKUP_STATE_UNSPECIFIED
}

func (x *BackupConfigInfo) GetLastSuccessfulBackupConsistencyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSuccessfulBackupConsistencyTime
	}
	return nil
}

func (x *BackupConfigInfo) GetLastBackupError() *status.Status {
	if x != nil {
		return x.LastBackupError
	}
	return nil
}

func (m *BackupConfigInfo) GetBackupConfig() isBackupConfigInfo_BackupConfig {
	if m != nil {
		return m.BackupConfig
	}
	return nil
}

func (x *BackupConfigInfo) GetGcpBackupConfig() *GcpBackupConfig {
	if x, ok := x.GetBackupConfig().(*BackupConfigInfo_GcpBackupConfig); ok {
		return x.GcpBackupConfig
	}
	return nil
}

func (x *BackupConfigInfo) GetBackupApplianceBackupConfig() *BackupApplianceBackupConfig {
	if x, ok := x.GetBackupConfig().(*BackupConfigInfo_BackupApplianceBackupConfig); ok {
		return x.BackupApplianceBackupConfig
	}
	return nil
}

type isBackupConfigInfo_BackupConfig interface {
	isBackupConfigInfo_BackupConfig()
}

type BackupConfigInfo_GcpBackupConfig struct {
	// Configuration for a Google Cloud resource.
	GcpBackupConfig *GcpBackupConfig `protobuf:"bytes,4,opt,name=gcp_backup_config,json=gcpBackupConfig,proto3,oneof"`
}

type BackupConfigInfo_BackupApplianceBackupConfig struct {
	// Configuration for an application backed up by a Backup Appliance.
	BackupApplianceBackupConfig *BackupApplianceBackupConfig `protobuf:"bytes,5,opt,name=backup_appliance_backup_config,json=backupApplianceBackupConfig,proto3,oneof"`
}

func (*BackupConfigInfo_GcpBackupConfig) isBackupConfigInfo_BackupConfig() {}

func (*BackupConfigInfo_BackupApplianceBackupConfig) isBackupConfigInfo_BackupConfig() {}

// GcpBackupConfig captures the Backup configuration details for Google Cloud
// resources. All Google Cloud resources regardless of type are protected with
// backup plan associations.
type GcpBackupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the backup plan.
	BackupPlan string `protobuf:"bytes,1,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// The description of the backup plan.
	BackupPlanDescription string `protobuf:"bytes,2,opt,name=backup_plan_description,json=backupPlanDescription,proto3" json:"backup_plan_description,omitempty"`
	// The name of the backup plan association.
	BackupPlanAssociation string `protobuf:"bytes,3,opt,name=backup_plan_association,json=backupPlanAssociation,proto3" json:"backup_plan_association,omitempty"`
	// The names of the backup plan rules which point to this backupvault
	BackupPlanRules []string `protobuf:"bytes,4,rep,name=backup_plan_rules,json=backupPlanRules,proto3" json:"backup_plan_rules,omitempty"`
}

func (x *GcpBackupConfig) Reset() {
	*x = GcpBackupConfig{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcpBackupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcpBackupConfig) ProtoMessage() {}

func (x *GcpBackupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcpBackupConfig.ProtoReflect.Descriptor instead.
func (*GcpBackupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{3}
}

func (x *GcpBackupConfig) GetBackupPlan() string {
	if x != nil {
		return x.BackupPlan
	}
	return ""
}

func (x *GcpBackupConfig) GetBackupPlanDescription() string {
	if x != nil {
		return x.BackupPlanDescription
	}
	return ""
}

func (x *GcpBackupConfig) GetBackupPlanAssociation() string {
	if x != nil {
		return x.BackupPlanAssociation
	}
	return ""
}

func (x *GcpBackupConfig) GetBackupPlanRules() []string {
	if x != nil {
		return x.BackupPlanRules
	}
	return nil
}

// BackupApplianceBackupConfig captures the backup configuration for
// applications that are protected by Backup Appliances.
type BackupApplianceBackupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the backup appliance.
	BackupApplianceName string `protobuf:"bytes,1,opt,name=backup_appliance_name,json=backupApplianceName,proto3" json:"backup_appliance_name,omitempty"`
	// The ID of the backup appliance.
	BackupApplianceId int64 `protobuf:"varint,2,opt,name=backup_appliance_id,json=backupApplianceId,proto3" json:"backup_appliance_id,omitempty"`
	// The ID of the SLA of this application.
	SlaId int64 `protobuf:"varint,3,opt,name=sla_id,json=slaId,proto3" json:"sla_id,omitempty"`
	// The name of the application.
	ApplicationName string `protobuf:"bytes,4,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// The name of the host where the application is running.
	HostName string `protobuf:"bytes,5,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	// The name of the SLT associated with the application.
	SltName string `protobuf:"bytes,6,opt,name=slt_name,json=sltName,proto3" json:"slt_name,omitempty"`
	// The name of the SLP associated with the application.
	SlpName string `protobuf:"bytes,7,opt,name=slp_name,json=slpName,proto3" json:"slp_name,omitempty"`
}

func (x *BackupApplianceBackupConfig) Reset() {
	*x = BackupApplianceBackupConfig{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupApplianceBackupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupApplianceBackupConfig) ProtoMessage() {}

func (x *BackupApplianceBackupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupApplianceBackupConfig.ProtoReflect.Descriptor instead.
func (*BackupApplianceBackupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{4}
}

func (x *BackupApplianceBackupConfig) GetBackupApplianceName() string {
	if x != nil {
		return x.BackupApplianceName
	}
	return ""
}

func (x *BackupApplianceBackupConfig) GetBackupApplianceId() int64 {
	if x != nil {
		return x.BackupApplianceId
	}
	return 0
}

func (x *BackupApplianceBackupConfig) GetSlaId() int64 {
	if x != nil {
		return x.SlaId
	}
	return 0
}

func (x *BackupApplianceBackupConfig) GetApplicationName() string {
	if x != nil {
		return x.ApplicationName
	}
	return ""
}

func (x *BackupApplianceBackupConfig) GetHostName() string {
	if x != nil {
		return x.HostName
	}
	return ""
}

func (x *BackupApplianceBackupConfig) GetSltName() string {
	if x != nil {
		return x.SltName
	}
	return ""
}

func (x *BackupApplianceBackupConfig) GetSlpName() string {
	if x != nil {
		return x.SlpName
	}
	return ""
}

// DataSourceGcpResource is used for protected resources that are Google Cloud
// Resources. This name is easeier to understand than GcpResourceDataSource or
// GcpDataSourceResource
type DataSourceGcpResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Full resource pathname URL of the source Google Cloud
	// resource.
	GcpResourcename string `protobuf:"bytes,1,opt,name=gcp_resourcename,json=gcpResourcename,proto3" json:"gcp_resourcename,omitempty"`
	// Location of the resource: <region>/<zone>/"global"/"unspecified".
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// The type of the Google Cloud resource. Use the Unified Resource Type,
	// eg. compute.googleapis.com/Instance.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// gcp_Properties has properties of the Google Cloud Resource.
	//
	// Types that are assignable to GcpResourceProperties:
	//
	//	*DataSourceGcpResource_ComputeInstanceDatasourceProperties
	GcpResourceProperties isDataSourceGcpResource_GcpResourceProperties `protobuf_oneof:"gcp_resource_properties"`
}

func (x *DataSourceGcpResource) Reset() {
	*x = DataSourceGcpResource{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataSourceGcpResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSourceGcpResource) ProtoMessage() {}

func (x *DataSourceGcpResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSourceGcpResource.ProtoReflect.Descriptor instead.
func (*DataSourceGcpResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{5}
}

func (x *DataSourceGcpResource) GetGcpResourcename() string {
	if x != nil {
		return x.GcpResourcename
	}
	return ""
}

func (x *DataSourceGcpResource) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *DataSourceGcpResource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *DataSourceGcpResource) GetGcpResourceProperties() isDataSourceGcpResource_GcpResourceProperties {
	if m != nil {
		return m.GcpResourceProperties
	}
	return nil
}

func (x *DataSourceGcpResource) GetComputeInstanceDatasourceProperties() *ComputeInstanceDataSourceProperties {
	if x, ok := x.GetGcpResourceProperties().(*DataSourceGcpResource_ComputeInstanceDatasourceProperties); ok {
		return x.ComputeInstanceDatasourceProperties
	}
	return nil
}

type isDataSourceGcpResource_GcpResourceProperties interface {
	isDataSourceGcpResource_GcpResourceProperties()
}

type DataSourceGcpResource_ComputeInstanceDatasourceProperties struct {
	// ComputeInstanceDataSourceProperties has a subset of Compute Instance
	// properties that are useful at the Datasource level.
	ComputeInstanceDatasourceProperties *ComputeInstanceDataSourceProperties `protobuf:"bytes,4,opt,name=compute_instance_datasource_properties,json=computeInstanceDatasourceProperties,proto3,oneof"`
}

func (*DataSourceGcpResource_ComputeInstanceDatasourceProperties) isDataSourceGcpResource_GcpResourceProperties() {
}

// BackupApplianceApplication describes a Source Resource when it is an
// application backed up by a BackupAppliance.
type DataSourceBackupApplianceApplication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Application as known to the Backup Appliance.
	ApplicationName string `protobuf:"bytes,1,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// Appliance name.
	BackupAppliance string `protobuf:"bytes,2,opt,name=backup_appliance,json=backupAppliance,proto3" json:"backup_appliance,omitempty"`
	// Appliance Id of the Backup Appliance.
	ApplianceId int64 `protobuf:"varint,3,opt,name=appliance_id,json=applianceId,proto3" json:"appliance_id,omitempty"`
	// The type of the application. e.g. VMBackup
	Type string `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	// The appid field of the application within the Backup Appliance.
	ApplicationId int64 `protobuf:"varint,8,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// Hostname of the host where the application is running.
	Hostname string `protobuf:"bytes,6,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Hostid of the application host.
	HostId int64 `protobuf:"varint,7,opt,name=host_id,json=hostId,proto3" json:"host_id,omitempty"`
}

func (x *DataSourceBackupApplianceApplication) Reset() {
	*x = DataSourceBackupApplianceApplication{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataSourceBackupApplianceApplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSourceBackupApplianceApplication) ProtoMessage() {}

func (x *DataSourceBackupApplianceApplication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSourceBackupApplianceApplication.ProtoReflect.Descriptor instead.
func (*DataSourceBackupApplianceApplication) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{6}
}

func (x *DataSourceBackupApplianceApplication) GetApplicationName() string {
	if x != nil {
		return x.ApplicationName
	}
	return ""
}

func (x *DataSourceBackupApplianceApplication) GetBackupAppliance() string {
	if x != nil {
		return x.BackupAppliance
	}
	return ""
}

func (x *DataSourceBackupApplianceApplication) GetApplianceId() int64 {
	if x != nil {
		return x.ApplianceId
	}
	return 0
}

func (x *DataSourceBackupApplianceApplication) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *DataSourceBackupApplianceApplication) GetApplicationId() int64 {
	if x != nil {
		return x.ApplicationId
	}
	return 0
}

func (x *DataSourceBackupApplianceApplication) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *DataSourceBackupApplianceApplication) GetHostId() int64 {
	if x != nil {
		return x.HostId
	}
	return 0
}

// ServiceLockInfo represents the details of a lock taken by the service on a
// Backup resource.
type ServiceLockInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the operation that created this lock.
	// The lock will automatically be released when the operation completes.
	Operation string `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
}

func (x *ServiceLockInfo) Reset() {
	*x = ServiceLockInfo{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceLockInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceLockInfo) ProtoMessage() {}

func (x *ServiceLockInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceLockInfo.ProtoReflect.Descriptor instead.
func (*ServiceLockInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{7}
}

func (x *ServiceLockInfo) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

// BackupApplianceLockInfo contains metadata about the backupappliance that
// created the lock.
type BackupApplianceLockInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the backup/recovery appliance that created this lock.
	BackupApplianceId int64 `protobuf:"varint,1,opt,name=backup_appliance_id,json=backupApplianceId,proto3" json:"backup_appliance_id,omitempty"`
	// Required. The name of the backup/recovery appliance that created this lock.
	BackupApplianceName string `protobuf:"bytes,2,opt,name=backup_appliance_name,json=backupApplianceName,proto3" json:"backup_appliance_name,omitempty"`
	// Required. The reason for the lock: e.g. MOUNT/RESTORE/BACKUP/etc.  The
	// value of this string is only meaningful to the client and it is not
	// interpreted by the BackupVault service.
	LockReason string `protobuf:"bytes,5,opt,name=lock_reason,json=lockReason,proto3" json:"lock_reason,omitempty"`
	// The information about this lock.
	//
	// Types that are assignable to LockSource:
	//
	//	*BackupApplianceLockInfo_JobName
	//	*BackupApplianceLockInfo_BackupImage
	//	*BackupApplianceLockInfo_SlaId
	LockSource isBackupApplianceLockInfo_LockSource `protobuf_oneof:"lock_source"`
}

func (x *BackupApplianceLockInfo) Reset() {
	*x = BackupApplianceLockInfo{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupApplianceLockInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupApplianceLockInfo) ProtoMessage() {}

func (x *BackupApplianceLockInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupApplianceLockInfo.ProtoReflect.Descriptor instead.
func (*BackupApplianceLockInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{8}
}

func (x *BackupApplianceLockInfo) GetBackupApplianceId() int64 {
	if x != nil {
		return x.BackupApplianceId
	}
	return 0
}

func (x *BackupApplianceLockInfo) GetBackupApplianceName() string {
	if x != nil {
		return x.BackupApplianceName
	}
	return ""
}

func (x *BackupApplianceLockInfo) GetLockReason() string {
	if x != nil {
		return x.LockReason
	}
	return ""
}

func (m *BackupApplianceLockInfo) GetLockSource() isBackupApplianceLockInfo_LockSource {
	if m != nil {
		return m.LockSource
	}
	return nil
}

func (x *BackupApplianceLockInfo) GetJobName() string {
	if x, ok := x.GetLockSource().(*BackupApplianceLockInfo_JobName); ok {
		return x.JobName
	}
	return ""
}

func (x *BackupApplianceLockInfo) GetBackupImage() string {
	if x, ok := x.GetLockSource().(*BackupApplianceLockInfo_BackupImage); ok {
		return x.BackupImage
	}
	return ""
}

func (x *BackupApplianceLockInfo) GetSlaId() int64 {
	if x, ok := x.GetLockSource().(*BackupApplianceLockInfo_SlaId); ok {
		return x.SlaId
	}
	return 0
}

type isBackupApplianceLockInfo_LockSource interface {
	isBackupApplianceLockInfo_LockSource()
}

type BackupApplianceLockInfo_JobName struct {
	// The job name on the backup/recovery appliance that created this lock.
	JobName string `protobuf:"bytes,6,opt,name=job_name,json=jobName,proto3,oneof"`
}

type BackupApplianceLockInfo_BackupImage struct {
	// The image name that depends on this Backup.
	BackupImage string `protobuf:"bytes,7,opt,name=backup_image,json=backupImage,proto3,oneof"`
}

type BackupApplianceLockInfo_SlaId struct {
	// The SLA on the backup/recovery appliance that owns the lock.
	SlaId int64 `protobuf:"varint,8,opt,name=sla_id,json=slaId,proto3,oneof"`
}

func (*BackupApplianceLockInfo_JobName) isBackupApplianceLockInfo_LockSource() {}

func (*BackupApplianceLockInfo_BackupImage) isBackupApplianceLockInfo_LockSource() {}

func (*BackupApplianceLockInfo_SlaId) isBackupApplianceLockInfo_LockSource() {}

// BackupLock represents a single lock on a Backup resource.  An unexpired
// lock on a Backup prevents the Backup from being deleted.
type BackupLock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The time after which this lock is not considered valid and will
	// no longer protect the Backup from deletion.
	LockUntilTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=lock_until_time,json=lockUntilTime,proto3" json:"lock_until_time,omitempty"`
	// Metadata about the owner and reason for the lock.
	//
	// Types that are assignable to ClientLockInfo:
	//
	//	*BackupLock_BackupApplianceLockInfo
	//	*BackupLock_ServiceLockInfo
	ClientLockInfo isBackupLock_ClientLockInfo `protobuf_oneof:"ClientLockInfo"`
}

func (x *BackupLock) Reset() {
	*x = BackupLock{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupLock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupLock) ProtoMessage() {}

func (x *BackupLock) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupLock.ProtoReflect.Descriptor instead.
func (*BackupLock) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{9}
}

func (x *BackupLock) GetLockUntilTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LockUntilTime
	}
	return nil
}

func (m *BackupLock) GetClientLockInfo() isBackupLock_ClientLockInfo {
	if m != nil {
		return m.ClientLockInfo
	}
	return nil
}

func (x *BackupLock) GetBackupApplianceLockInfo() *BackupApplianceLockInfo {
	if x, ok := x.GetClientLockInfo().(*BackupLock_BackupApplianceLockInfo); ok {
		return x.BackupApplianceLockInfo
	}
	return nil
}

func (x *BackupLock) GetServiceLockInfo() *ServiceLockInfo {
	if x, ok := x.GetClientLockInfo().(*BackupLock_ServiceLockInfo); ok {
		return x.ServiceLockInfo
	}
	return nil
}

type isBackupLock_ClientLockInfo interface {
	isBackupLock_ClientLockInfo()
}

type BackupLock_BackupApplianceLockInfo struct {
	// If the client is a backup and recovery appliance, this
	// contains metadata about why the lock exists.
	BackupApplianceLockInfo *BackupApplianceLockInfo `protobuf:"bytes,3,opt,name=backup_appliance_lock_info,json=backupApplianceLockInfo,proto3,oneof"`
}

type BackupLock_ServiceLockInfo struct {
	// Output only. Contains metadata about the lock exist for Google Cloud
	// native backups.
	ServiceLockInfo *ServiceLockInfo `protobuf:"bytes,4,opt,name=service_lock_info,json=serviceLockInfo,proto3,oneof"`
}

func (*BackupLock_BackupApplianceLockInfo) isBackupLock_ClientLockInfo() {}

func (*BackupLock_ServiceLockInfo) isBackupLock_ClientLockInfo() {}

// Message describing a Backup object.
type Backup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. Name of the backup to create. It must have the
	// format`"projects/<project>/locations/<location>/backupVaults/<backupvault>/dataSources/{datasource}/backups/{backup}"`.
	// `{backup}` cannot be changed after creation. It must be between 3-63
	// characters long and must be unique within the datasource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The description of the Backup instance (2048 characters or
	// less).
	Description *string `protobuf:"bytes,2,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Output only. The time when the instance was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3,oneof" json:"create_time,omitempty"`
	// Output only. The time when the instance was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3,oneof" json:"update_time,omitempty"`
	// Optional. Resource labels to represent user provided metadata.
	// No labels currently defined.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The backup can not be deleted before this time.
	EnforcedRetentionEndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=enforced_retention_end_time,json=enforcedRetentionEndTime,proto3,oneof" json:"enforced_retention_end_time,omitempty"`
	// Optional. When this backup is automatically expired.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=expire_time,json=expireTime,proto3,oneof" json:"expire_time,omitempty"`
	// Output only. The point in time when this backup was captured from the
	// source.
	ConsistencyTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=consistency_time,json=consistencyTime,proto3,oneof" json:"consistency_time,omitempty"`
	// Optional. Server specified ETag to prevent updates from overwriting each
	// other.
	Etag *string `protobuf:"bytes,11,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
	// Output only. The Backup resource instance state.
	State Backup_State `protobuf:"varint,15,opt,name=state,proto3,enum=google.cloud.backupdr.v1.Backup_State" json:"state,omitempty"`
	// Output only. The list of BackupLocks taken by the service to prevent the
	// deletion of the backup.
	ServiceLocks []*BackupLock `protobuf:"bytes,17,rep,name=service_locks,json=serviceLocks,proto3" json:"service_locks,omitempty"`
	// Optional. The list of BackupLocks taken by the accessor Backup Appliance.
	BackupApplianceLocks []*BackupLock `protobuf:"bytes,18,rep,name=backup_appliance_locks,json=backupApplianceLocks,proto3" json:"backup_appliance_locks,omitempty"`
	// Workload specific backup properties.
	//
	// Types that are assignable to BackupProperties:
	//
	//	*Backup_ComputeInstanceBackupProperties
	//	*Backup_BackupApplianceBackupProperties
	BackupProperties isBackup_BackupProperties `protobuf_oneof:"backup_properties"`
	// Output only. Type of the backup, unspecified, scheduled or ondemand.
	BackupType Backup_BackupType `protobuf:"varint,20,opt,name=backup_type,json=backupType,proto3,enum=google.cloud.backupdr.v1.Backup_BackupType" json:"backup_type,omitempty"`
	// Configuration Info has the resource format-specific configuration.
	//
	// Types that are assignable to PlanInfo:
	//
	//	*Backup_GcpBackupPlanInfo
	PlanInfo isBackup_PlanInfo `protobuf_oneof:"plan_info"`
	// Output only. source resource size in bytes at the time of the backup.
	ResourceSizeBytes int64 `protobuf:"varint,23,opt,name=resource_size_bytes,json=resourceSizeBytes,proto3" json:"resource_size_bytes,omitempty"`
}

func (x *Backup) Reset() {
	*x = Backup{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Backup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup) ProtoMessage() {}

func (x *Backup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup.ProtoReflect.Descriptor instead.
func (*Backup) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{10}
}

func (x *Backup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Backup) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Backup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Backup) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Backup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Backup) GetEnforcedRetentionEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EnforcedRetentionEndTime
	}
	return nil
}

func (x *Backup) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Backup) GetConsistencyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ConsistencyTime
	}
	return nil
}

func (x *Backup) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

func (x *Backup) GetState() Backup_State {
	if x != nil {
		return x.State
	}
	return Backup_STATE_UNSPECIFIED
}

func (x *Backup) GetServiceLocks() []*BackupLock {
	if x != nil {
		return x.ServiceLocks
	}
	return nil
}

func (x *Backup) GetBackupApplianceLocks() []*BackupLock {
	if x != nil {
		return x.BackupApplianceLocks
	}
	return nil
}

func (m *Backup) GetBackupProperties() isBackup_BackupProperties {
	if m != nil {
		return m.BackupProperties
	}
	return nil
}

func (x *Backup) GetComputeInstanceBackupProperties() *ComputeInstanceBackupProperties {
	if x, ok := x.GetBackupProperties().(*Backup_ComputeInstanceBackupProperties); ok {
		return x.ComputeInstanceBackupProperties
	}
	return nil
}

func (x *Backup) GetBackupApplianceBackupProperties() *BackupApplianceBackupProperties {
	if x, ok := x.GetBackupProperties().(*Backup_BackupApplianceBackupProperties); ok {
		return x.BackupApplianceBackupProperties
	}
	return nil
}

func (x *Backup) GetBackupType() Backup_BackupType {
	if x != nil {
		return x.BackupType
	}
	return Backup_BACKUP_TYPE_UNSPECIFIED
}

func (m *Backup) GetPlanInfo() isBackup_PlanInfo {
	if m != nil {
		return m.PlanInfo
	}
	return nil
}

func (x *Backup) GetGcpBackupPlanInfo() *Backup_GCPBackupPlanInfo {
	if x, ok := x.GetPlanInfo().(*Backup_GcpBackupPlanInfo); ok {
		return x.GcpBackupPlanInfo
	}
	return nil
}

func (x *Backup) GetResourceSizeBytes() int64 {
	if x != nil {
		return x.ResourceSizeBytes
	}
	return 0
}

type isBackup_BackupProperties interface {
	isBackup_BackupProperties()
}

type Backup_ComputeInstanceBackupProperties struct {
	// Output only. Compute Engine specific backup properties.
	ComputeInstanceBackupProperties *ComputeInstanceBackupProperties `protobuf:"bytes,19,opt,name=compute_instance_backup_properties,json=computeInstanceBackupProperties,proto3,oneof"`
}

type Backup_BackupApplianceBackupProperties struct {
	// Output only. Backup Appliance specific backup properties.
	BackupApplianceBackupProperties *BackupApplianceBackupProperties `protobuf:"bytes,21,opt,name=backup_appliance_backup_properties,json=backupApplianceBackupProperties,proto3,oneof"`
}

func (*Backup_ComputeInstanceBackupProperties) isBackup_BackupProperties() {}

func (*Backup_BackupApplianceBackupProperties) isBackup_BackupProperties() {}

type isBackup_PlanInfo interface {
	isBackup_PlanInfo()
}

type Backup_GcpBackupPlanInfo struct {
	// Output only. Configuration for a Google Cloud resource.
	GcpBackupPlanInfo *Backup_GCPBackupPlanInfo `protobuf:"bytes,22,opt,name=gcp_backup_plan_info,json=gcpBackupPlanInfo,proto3,oneof"`
}

func (*Backup_GcpBackupPlanInfo) isBackup_PlanInfo() {}

// Message for creating a BackupVault.
type CreateBackupVaultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the requesting object
	// If auto-generating ID server-side, remove this field and
	// backup_vault_id from the method_signature of Create RPC
	BackupVaultId string `protobuf:"bytes,2,opt,name=backup_vault_id,json=backupVaultId,proto3" json:"backup_vault_id,omitempty"`
	// Required. The resource being created
	BackupVault *BackupVault `protobuf:"bytes,3,opt,name=backup_vault,json=backupVault,proto3" json:"backup_vault,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is 'false'.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateBackupVaultRequest) Reset() {
	*x = CreateBackupVaultRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBackupVaultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupVaultRequest) ProtoMessage() {}

func (x *CreateBackupVaultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupVaultRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupVaultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{11}
}

func (x *CreateBackupVaultRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupVaultRequest) GetBackupVaultId() string {
	if x != nil {
		return x.BackupVaultId
	}
	return ""
}

func (x *CreateBackupVaultRequest) GetBackupVault() *BackupVault {
	if x != nil {
		return x.BackupVault
	}
	return nil
}

func (x *CreateBackupVaultRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateBackupVaultRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for listing backupvault stores.
type ListBackupVaultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve backupvault stores
	// information, in the format 'projects/{project_id}/locations/{location}'. In
	// Cloud Backup and DR, locations map to Google Cloud regions, for example
	// **us-central1**.
	// To retrieve backupvault stores for all locations, use "-" for the
	// '{location}' value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. Reserved for future use to provide a BASIC & FULL view of Backup
	// Vault.
	View BackupVaultView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.backupdr.v1.BackupVaultView" json:"view,omitempty"`
}

func (x *ListBackupVaultsRequest) Reset() {
	*x = ListBackupVaultsRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupVaultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupVaultsRequest) ProtoMessage() {}

func (x *ListBackupVaultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupVaultsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupVaultsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{12}
}

func (x *ListBackupVaultsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupVaultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupVaultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupVaultsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupVaultsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListBackupVaultsRequest) GetView() BackupVaultView {
	if x != nil {
		return x.View
	}
	return BackupVaultView_BACKUP_VAULT_VIEW_UNSPECIFIED
}

// Response message for listing BackupVaults.
type ListBackupVaultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of BackupVault instances in the project for the specified
	// location.
	//
	// If the '{location}' value in the request is "-", the response contains a
	// list of instances from all locations. In case any location is unreachable,
	// the response will only return backup vaults in reachable locations and
	// the 'unreachable' field will be populated with a list of unreachable
	// locations.
	BackupVaults []*BackupVault `protobuf:"bytes,1,rep,name=backup_vaults,json=backupVaults,proto3" json:"backup_vaults,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupVaultsResponse) Reset() {
	*x = ListBackupVaultsResponse{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupVaultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupVaultsResponse) ProtoMessage() {}

func (x *ListBackupVaultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupVaultsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupVaultsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{13}
}

func (x *ListBackupVaultsResponse) GetBackupVaults() []*BackupVault {
	if x != nil {
		return x.BackupVaults
	}
	return nil
}

func (x *ListBackupVaultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupVaultsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for fetching usable BackupVaults.
type FetchUsableBackupVaultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve backupvault stores
	// information, in the format 'projects/{project_id}/locations/{location}'. In
	// Cloud Backup and DR, locations map to Google Cloud regions, for example
	// **us-central1**.
	// To retrieve backupvault stores for all locations, use "-" for the
	// '{location}' value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *FetchUsableBackupVaultsRequest) Reset() {
	*x = FetchUsableBackupVaultsRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchUsableBackupVaultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchUsableBackupVaultsRequest) ProtoMessage() {}

func (x *FetchUsableBackupVaultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchUsableBackupVaultsRequest.ProtoReflect.Descriptor instead.
func (*FetchUsableBackupVaultsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{14}
}

func (x *FetchUsableBackupVaultsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *FetchUsableBackupVaultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchUsableBackupVaultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *FetchUsableBackupVaultsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *FetchUsableBackupVaultsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for fetching usable BackupVaults.
type FetchUsableBackupVaultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of BackupVault instances in the project for the specified
	// location.
	//
	// If the '{location}' value in the request is "-", the response contains a
	// list of instances from all locations. In case any location is unreachable,
	// the response will only return backup vaults in reachable locations and
	// the 'unreachable' field will be populated with a list of unreachable
	// locations.
	BackupVaults []*BackupVault `protobuf:"bytes,1,rep,name=backup_vaults,json=backupVaults,proto3" json:"backup_vaults,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *FetchUsableBackupVaultsResponse) Reset() {
	*x = FetchUsableBackupVaultsResponse{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchUsableBackupVaultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchUsableBackupVaultsResponse) ProtoMessage() {}

func (x *FetchUsableBackupVaultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchUsableBackupVaultsResponse.ProtoReflect.Descriptor instead.
func (*FetchUsableBackupVaultsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{15}
}

func (x *FetchUsableBackupVaultsResponse) GetBackupVaults() []*BackupVault {
	if x != nil {
		return x.BackupVaults
	}
	return nil
}

func (x *FetchUsableBackupVaultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *FetchUsableBackupVaultsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for getting a BackupVault.
type GetBackupVaultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the backupvault store resource name, in the format
	// 'projects/{project_id}/locations/{location}/backupVaults/{resource_name}'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Reserved for future use to provide a BASIC & FULL view of Backup
	// Vault
	View BackupVaultView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.backupdr.v1.BackupVaultView" json:"view,omitempty"`
}

func (x *GetBackupVaultRequest) Reset() {
	*x = GetBackupVaultRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupVaultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupVaultRequest) ProtoMessage() {}

func (x *GetBackupVaultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupVaultRequest.ProtoReflect.Descriptor instead.
func (*GetBackupVaultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{16}
}

func (x *GetBackupVaultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetBackupVaultRequest) GetView() BackupVaultView {
	if x != nil {
		return x.View
	}
	return BackupVaultView_BACKUP_VAULT_VIEW_UNSPECIFIED
}

// Request message for updating a BackupVault.
type UpdateBackupVaultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// BackupVault resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then the request will fail.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	BackupVault *BackupVault `protobuf:"bytes,2,opt,name=backup_vault,json=backupVault,proto3" json:"backup_vault,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is 'false'.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. If set to true, will not check plan duration against backup vault
	// enforcement duration.
	Force bool `protobuf:"varint,5,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *UpdateBackupVaultRequest) Reset() {
	*x = UpdateBackupVaultRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBackupVaultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupVaultRequest) ProtoMessage() {}

func (x *UpdateBackupVaultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupVaultRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupVaultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{17}
}

func (x *UpdateBackupVaultRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateBackupVaultRequest) GetBackupVault() *BackupVault {
	if x != nil {
		return x.BackupVault
	}
	return nil
}

func (x *UpdateBackupVaultRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateBackupVaultRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateBackupVaultRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Message for deleting a BackupVault.
type DeleteBackupVaultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, any data source from this backup vault will also
	// be deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// The current etag of the backup vault.
	// If an etag is provided and does not match the current etag of the
	// connection, deletion will be blocked.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is 'false'.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. If true and the BackupVault is not found, the request will
	// succeed but no action will be taken.
	AllowMissing bool `protobuf:"varint,6,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, backupvault deletion will proceed even if there
	// are backup plans referencing the backupvault. The default is 'false'.
	IgnoreBackupPlanReferences bool `protobuf:"varint,7,opt,name=ignore_backup_plan_references,json=ignoreBackupPlanReferences,proto3" json:"ignore_backup_plan_references,omitempty"`
}

func (x *DeleteBackupVaultRequest) Reset() {
	*x = DeleteBackupVaultRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupVaultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupVaultRequest) ProtoMessage() {}

func (x *DeleteBackupVaultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupVaultRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupVaultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteBackupVaultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupVaultRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteBackupVaultRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeleteBackupVaultRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteBackupVaultRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteBackupVaultRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteBackupVaultRequest) GetIgnoreBackupPlanReferences() bool {
	if x != nil {
		return x.IgnoreBackupPlanReferences
	}
	return false
}

// Request message for listing DataSources.
type ListDataSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve data
	// sources information, in the format
	// 'projects/{project_id}/locations/{location}'. In Cloud Backup and DR,
	// locations map to Google Cloud regions, for example **us-central1**.
	// To retrieve data sources for all locations, use "-" for the
	// '{location}' value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDataSourcesRequest) Reset() {
	*x = ListDataSourcesRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSourcesRequest) ProtoMessage() {}

func (x *ListDataSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListDataSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{19}
}

func (x *ListDataSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDataSourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDataSourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for listing DataSources.
type ListDataSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of DataSource instances in the project for the specified
	// location.
	//
	// If the '{location}' value in the request is "-", the response contains a
	// list of instances from all locations. In case any location is unreachable,
	// the response will only return data sources in reachable locations
	// and the 'unreachable' field will be populated with a list of unreachable
	// locations.
	DataSources []*DataSource `protobuf:"bytes,1,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDataSourcesResponse) Reset() {
	*x = ListDataSourcesResponse{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSourcesResponse) ProtoMessage() {}

func (x *ListDataSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListDataSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{20}
}

func (x *ListDataSourcesResponse) GetDataSources() []*DataSource {
	if x != nil {
		return x.DataSources
	}
	return nil
}

func (x *ListDataSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDataSourcesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for getting a DataSource instance.
type GetDataSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the data source resource name, in the format
	// 'projects/{project_id}/locations/{location}/backupVaults/{resource_name}/dataSource/{resource_name}'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataSourceRequest) Reset() {
	*x = GetDataSourceRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDataSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataSourceRequest) ProtoMessage() {}

func (x *GetDataSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataSourceRequest.ProtoReflect.Descriptor instead.
func (*GetDataSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{21}
}

func (x *GetDataSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for updating a data source instance.
type UpdateDataSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// DataSource resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then the request will fail.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	DataSource *DataSource `protobuf:"bytes,2,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Enable upsert.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateDataSourceRequest) Reset() {
	*x = UpdateDataSourceRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDataSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataSourceRequest) ProtoMessage() {}

func (x *UpdateDataSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataSourceRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateDataSourceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDataSourceRequest) GetDataSource() *DataSource {
	if x != nil {
		return x.DataSource
	}
	return nil
}

func (x *UpdateDataSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateDataSourceRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for listing Backups.
type ListBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve backup
	// information, in the format
	// 'projects/{project_id}/locations/{location}'. In Cloud Backup and DR,
	// locations map to Google Cloud regions, for example **us-central1**.
	// To retrieve data sources for all locations, use "-" for the
	// '{location}' value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. Reserved for future use to provide a BASIC & FULL view of Backup
	// resource.
	View BackupView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.backupdr.v1.BackupView" json:"view,omitempty"`
}

func (x *ListBackupsRequest) Reset() {
	*x = ListBackupsRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsRequest) ProtoMessage() {}

func (x *ListBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{23}
}

func (x *ListBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListBackupsRequest) GetView() BackupView {
	if x != nil {
		return x.View
	}
	return BackupView_BACKUP_VIEW_UNSPECIFIED
}

// Response message for listing Backups.
type ListBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Backup instances in the project for the specified
	// location.
	//
	// If the '{location}' value in the request is "-", the response contains a
	// list of instances from all locations. In case any location is unreachable,
	// the response will only return data sources in reachable locations
	// and the 'unreachable' field will be populated with a list of unreachable
	// locations.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupsResponse) Reset() {
	*x = ListBackupsResponse{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsResponse) ProtoMessage() {}

func (x *ListBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{24}
}

func (x *ListBackupsResponse) GetBackups() []*Backup {
	if x != nil {
		return x.Backups
	}
	return nil
}

func (x *ListBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for getting a Backup.
type GetBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the data source resource name, in the format
	// 'projects/{project_id}/locations/{location}/backupVaults/{backupVault}/dataSources/{datasource}/backups/{backup}'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Reserved for future use to provide a BASIC & FULL view of Backup
	// resource.
	View BackupView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.backupdr.v1.BackupView" json:"view,omitempty"`
}

func (x *GetBackupRequest) Reset() {
	*x = GetBackupRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupRequest) ProtoMessage() {}

func (x *GetBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupRequest.ProtoReflect.Descriptor instead.
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{25}
}

func (x *GetBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetBackupRequest) GetView() BackupView {
	if x != nil {
		return x.View
	}
	return BackupView_BACKUP_VIEW_UNSPECIFIED
}

// Request message for updating a Backup.
type UpdateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Backup resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then the request will fail.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	Backup *Backup `protobuf:"bytes,2,opt,name=backup,proto3" json:"backup,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateBackupRequest) Reset() {
	*x = UpdateBackupRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupRequest) ProtoMessage() {}

func (x *UpdateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{26}
}

func (x *UpdateBackupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *UpdateBackupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a Backup.
type DeleteBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteBackupRequest) Reset() {
	*x = DeleteBackupRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupRequest) ProtoMessage() {}

func (x *DeleteBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for restoring from a Backup.
type RestoreBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Backup instance, in the format
	// 'projects/*/locations/*/backupVaults/*/dataSources/*/backups/'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The target environment for the restore operation.
	//
	// Types that are assignable to TargetEnvironment:
	//
	//	*RestoreBackupRequest_ComputeInstanceTargetEnvironment
	TargetEnvironment isRestoreBackupRequest_TargetEnvironment `protobuf_oneof:"target_environment"`
	// The property overrides for the instance being restored.
	//
	// Types that are assignable to InstanceProperties:
	//
	//	*RestoreBackupRequest_ComputeInstanceRestoreProperties
	InstanceProperties isRestoreBackupRequest_InstanceProperties `protobuf_oneof:"instance_properties"`
}

func (x *RestoreBackupRequest) Reset() {
	*x = RestoreBackupRequest{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreBackupRequest) ProtoMessage() {}

func (x *RestoreBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreBackupRequest.ProtoReflect.Descriptor instead.
func (*RestoreBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{28}
}

func (x *RestoreBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RestoreBackupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (m *RestoreBackupRequest) GetTargetEnvironment() isRestoreBackupRequest_TargetEnvironment {
	if m != nil {
		return m.TargetEnvironment
	}
	return nil
}

func (x *RestoreBackupRequest) GetComputeInstanceTargetEnvironment() *ComputeInstanceTargetEnvironment {
	if x, ok := x.GetTargetEnvironment().(*RestoreBackupRequest_ComputeInstanceTargetEnvironment); ok {
		return x.ComputeInstanceTargetEnvironment
	}
	return nil
}

func (m *RestoreBackupRequest) GetInstanceProperties() isRestoreBackupRequest_InstanceProperties {
	if m != nil {
		return m.InstanceProperties
	}
	return nil
}

func (x *RestoreBackupRequest) GetComputeInstanceRestoreProperties() *ComputeInstanceRestoreProperties {
	if x, ok := x.GetInstanceProperties().(*RestoreBackupRequest_ComputeInstanceRestoreProperties); ok {
		return x.ComputeInstanceRestoreProperties
	}
	return nil
}

type isRestoreBackupRequest_TargetEnvironment interface {
	isRestoreBackupRequest_TargetEnvironment()
}

type RestoreBackupRequest_ComputeInstanceTargetEnvironment struct {
	// Compute Engine target environment to be used during restore.
	ComputeInstanceTargetEnvironment *ComputeInstanceTargetEnvironment `protobuf:"bytes,3,opt,name=compute_instance_target_environment,json=computeInstanceTargetEnvironment,proto3,oneof"`
}

func (*RestoreBackupRequest_ComputeInstanceTargetEnvironment) isRestoreBackupRequest_TargetEnvironment() {
}

type isRestoreBackupRequest_InstanceProperties interface {
	isRestoreBackupRequest_InstanceProperties()
}

type RestoreBackupRequest_ComputeInstanceRestoreProperties struct {
	// Compute Engine instance properties to be overridden during restore.
	ComputeInstanceRestoreProperties *ComputeInstanceRestoreProperties `protobuf:"bytes,4,opt,name=compute_instance_restore_properties,json=computeInstanceRestoreProperties,proto3,oneof"`
}

func (*RestoreBackupRequest_ComputeInstanceRestoreProperties) isRestoreBackupRequest_InstanceProperties() {
}

// Response message for restoring from a Backup.
type RestoreBackupResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the target resource created/modified as part of restore.
	TargetResource *TargetResource `protobuf:"bytes,1,opt,name=target_resource,json=targetResource,proto3" json:"target_resource,omitempty"`
}

func (x *RestoreBackupResponse) Reset() {
	*x = RestoreBackupResponse{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreBackupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreBackupResponse) ProtoMessage() {}

func (x *RestoreBackupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreBackupResponse.ProtoReflect.Descriptor instead.
func (*RestoreBackupResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{29}
}

func (x *RestoreBackupResponse) GetTargetResource() *TargetResource {
	if x != nil {
		return x.TargetResource
	}
	return nil
}

// Details of the target resource created/modified as part of restore.
type TargetResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum details to identify the restored resource.
	//
	// Types that are assignable to TargetResourceInfo:
	//
	//	*TargetResource_GcpResource
	TargetResourceInfo isTargetResource_TargetResourceInfo `protobuf_oneof:"target_resource_info"`
}

func (x *TargetResource) Reset() {
	*x = TargetResource{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TargetResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetResource) ProtoMessage() {}

func (x *TargetResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetResource.ProtoReflect.Descriptor instead.
func (*TargetResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{30}
}

func (m *TargetResource) GetTargetResourceInfo() isTargetResource_TargetResourceInfo {
	if m != nil {
		return m.TargetResourceInfo
	}
	return nil
}

func (x *TargetResource) GetGcpResource() *GcpResource {
	if x, ok := x.GetTargetResourceInfo().(*TargetResource_GcpResource); ok {
		return x.GcpResource
	}
	return nil
}

type isTargetResource_TargetResourceInfo interface {
	isTargetResource_TargetResourceInfo()
}

type TargetResource_GcpResource struct {
	// Details of the native Google Cloud resource created as part of restore.
	GcpResource *GcpResource `protobuf:"bytes,1,opt,name=gcp_resource,json=gcpResource,proto3,oneof"`
}

func (*TargetResource_GcpResource) isTargetResource_TargetResourceInfo() {}

// Minimum details to identify a Google Cloud resource
type GcpResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Google Cloud resource.
	GcpResourcename string `protobuf:"bytes,1,opt,name=gcp_resourcename,json=gcpResourcename,proto3" json:"gcp_resourcename,omitempty"`
	// Location of the resource: <region>/<zone>/"global"/"unspecified".
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Type of the resource. Use the Unified Resource Type,
	// eg. compute.googleapis.com/Instance.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *GcpResource) Reset() {
	*x = GcpResource{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcpResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcpResource) ProtoMessage() {}

func (x *GcpResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcpResource.ProtoReflect.Descriptor instead.
func (*GcpResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{31}
}

func (x *GcpResource) GetGcpResourcename() string {
	if x != nil {
		return x.GcpResourcename
	}
	return ""
}

func (x *GcpResource) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *GcpResource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// GCPBackupPlanInfo captures the plan configuration details of Google Cloud
// resources at the time of backup.
type Backup_GCPBackupPlanInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of backup plan by which workload is protected at the time
	// of the backup.
	// Format:
	// projects/{project}/locations/{location}/backupPlans/{backupPlanId}
	BackupPlan string `protobuf:"bytes,1,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// The rule id of the backup plan which triggered this backup in case of
	// scheduled backup or used for
	BackupPlanRuleId string `protobuf:"bytes,2,opt,name=backup_plan_rule_id,json=backupPlanRuleId,proto3" json:"backup_plan_rule_id,omitempty"`
}

func (x *Backup_GCPBackupPlanInfo) Reset() {
	*x = Backup_GCPBackupPlanInfo{}
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Backup_GCPBackupPlanInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup_GCPBackupPlanInfo) ProtoMessage() {}

func (x *Backup_GCPBackupPlanInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup_GCPBackupPlanInfo.ProtoReflect.Descriptor instead.
func (*Backup_GCPBackupPlanInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP(), []int{10, 0}
}

func (x *Backup_GCPBackupPlanInfo) GetBackupPlan() string {
	if x != nil {
		return x.BackupPlan
	}
	return ""
}

func (x *Backup_GCPBackupPlanInfo) GetBackupPlanRuleId() string {
	if x != nil {
		return x.BackupPlanRuleId
	}
	return ""
}

var File_google_cloud_backupdr_v1_backupvault_proto protoreflect.FileDescriptor

var file_google_cloud_backupdr_v1_backupvault_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x76, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x76,
	0x61, 0x75, 0x6c, 0x74, 0x5f, 0x67, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x86, 0x0d, 0x0a, 0x0b, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88,
	0x01, 0x01, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x45, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x7f, 0x0a, 0x2a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d,
	0x75, 0x6d, 0x5f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52, 0x26, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4d, 0x69,
	0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x52, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01,
	0x01, 0x12, 0x26, 0x0a, 0x09, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x04, 0x52, 0x09, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x4b, 0x0a, 0x0e, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x0d, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x31, 0x0a, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52,
	0x03, 0x75, 0x69, 0x64, 0x12, 0x5d, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x6b, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x22, 0x9e,
	0x01, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x52,
	0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x57, 0x49, 0x54, 0x48,
	0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13,
	0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x4e, 0x52, 0x45, 0x53, 0x54, 0x52,
	0x49, 0x43, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x26, 0x0a, 0x22, 0x57, 0x49, 0x54, 0x48, 0x49,
	0x4e, 0x5f, 0x4f, 0x52, 0x47, 0x5f, 0x42, 0x55, 0x54, 0x5f, 0x55, 0x4e, 0x52, 0x45, 0x53, 0x54,
	0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x42, 0x41, 0x10, 0x04, 0x3a,
	0x88, 0x01, 0xea, 0x41, 0x84, 0x01, 0x0a, 0x23, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x42, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74,
	0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x7d, 0x2a,
	0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x32, 0x0b, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x65, 0x6e,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67,
	0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0x8e, 0x0a, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x05, 0x52, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49,
	0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x6a, 0x0a, 0x18, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x63, 0x70, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x47, 0x63, 0x70, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x15, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x63, 0x70, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x98, 0x01, 0x0a, 0x28, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x24, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x3a,
	0x9e, 0x01, 0xea, 0x41, 0x9a, 0x01, 0x0a, 0x22, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x32, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x11, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x42, 0x15, 0x0a,
	0x13, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x22, 0xa6, 0x05, 0x0a, 0x10, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x6b, 0x0a, 0x11, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x4c, 0x61, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x75, 0x0a, 0x27, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x23, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f,
	0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a,
	0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x57, 0x0a, 0x11, 0x67, 0x63, 0x70, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x70, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x67, 0x63, 0x70, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7c, 0x0a, 0x1e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1b, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x80, 0x01, 0x0a, 0x0f, 0x4c, 0x61,
	0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a,
	0x1d, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50,
	0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x04, 0x42, 0x0f, 0x0a, 0x0d,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xab, 0x02,
	0x0a, 0x0f, 0x47, 0x63, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x48, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73,
	0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2a, 0x0a, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x96, 0x02, 0x0a, 0x1b,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x32, 0x0a, 0x15, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x2e, 0x0a, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x15, 0x0a, 0x06, 0x73, 0x6c, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x73, 0x6c, 0x61, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19,
	0x0a, 0x08, 0x73, 0x6c, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x73, 0x6c, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x6c, 0x70,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x6c, 0x70,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x02, 0x0a, 0x15, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x47, 0x63, 0x70, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2e,
	0x0a, 0x10, 0x67, 0x63, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x67,
	0x63, 0x70, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x94,
	0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00,
	0x52, 0x23, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x67, 0x63, 0x70, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x22, 0x8f, 0x02, 0x0a, 0x24, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x68, 0x6f, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x68, 0x6f, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x34, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x6f, 0x63,
	0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x02, 0x0a, 0x17, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x6b,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x33, 0x0a, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x37, 0x0a, 0x15, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6c, 0x6f,
	0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x6a, 0x6f,
	0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x06, 0x73, 0x6c,
	0x61, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x6c,
	0x61, 0x49, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0xb7, 0x02, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4c, 0x6f, 0x63,
	0x6b, 0x12, 0x47, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6c, 0x6f, 0x63,
	0x6b, 0x55, 0x6e, 0x74, 0x69, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x70, 0x0a, 0x1a, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6c,
	0x6f, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x66,
	0x6f, 0x48, 0x00, 0x52, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5c, 0x0a, 0x11,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e,
	0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x10, 0x0a, 0x0e, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xf8, 0x0f, 0x0a,
	0x06, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x02, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x45, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x04, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x63, 0x0a, 0x1b, 0x65, 0x6e, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05,
	0x52, 0x18, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a,
	0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x07, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69,
	0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x08, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4c,
	0x6f, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x5f, 0x0a, 0x16, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x73,
	0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4c, 0x6f, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x14, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x22, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x6a, 0x0a, 0x14, 0x67, 0x63,
	0x70, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x47, 0x43, 0x50, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x01, 0x52, 0x11, 0x67, 0x63, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x33, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x17, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x8c, 0x01, 0x0a, 0x11,
	0x47, 0x43, 0x50, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x48, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x2d, 0x0a, 0x13, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x22, 0x47, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10,
	0x02, 0x3a, 0xa3, 0x01, 0xea, 0x41, 0x9f, 0x01, 0x0a, 0x1e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x6c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x7d, 0x2a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x32,
	0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x13, 0x0a, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x0b, 0x0a, 0x09,
	0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x65, 0x6e,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x63, 0x6f,
	0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x07,
	0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x22, 0xb1, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56,
	0x61, 0x75, 0x6c, 0x74, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61,
	0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x56, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c,
	0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xa5, 0x02, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12,
	0x23, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56,
	0x61, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x42, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56,
	0x61, 0x75, 0x6c, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x22, 0xb0, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4a, 0x0a, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x76, 0x61, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x0c,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xe8, 0x01, 0x0a, 0x1e, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x12, 0x23, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xb7, 0x01, 0x0a, 0x1f, 0x46, 0x65, 0x74, 0x63, 0x68, 0x55, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x76, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61,
	0x75, 0x6c, 0x74, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x9c, 0x02, 0x0a, 0x18, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4d, 0x0a, 0x0c, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41,
	0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x19,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xd2, 0x02, 0x0a, 0x18, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x28, 0x0a, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x46, 0x0a, 0x1d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x1a, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0xdf,
	0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x12, 0x22, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xac, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0c,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4a, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02,
	0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x96, 0x02, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x12, 0x3d, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x22, 0x9b, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x07, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x8d,
	0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x3d, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56,
	0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xc2,
	0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3d, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0x7d, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2,
	0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0xc7, 0x03, 0x0a, 0x14, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x12, 0x8b, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x8b, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x48, 0x01, 0x52, 0x20, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42,
	0x14, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x15, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0x6a, 0x0a, 0x15,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x74, 0x0a, 0x0e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x0c, 0x67, 0x63,
	0x70, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x70, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x63, 0x70, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x68,
	0x0a, 0x0b, 0x47, 0x63, 0x70, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x29, 0x0a,
	0x10, 0x67, 0x63, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x67, 0x63, 0x70, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x2a, 0x51, 0x0a, 0x11, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a,
	0x1f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x41, 0x53, 0x53, 0x49, 0x56, 0x45, 0x10, 0x02, 0x2a, 0x56, 0x0a, 0x0a, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x41, 0x43,
	0x4b, 0x55, 0x50, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50,
	0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x14, 0x0a,
	0x10, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c,
	0x4c, 0x10, 0x02, 0x2a, 0x6d, 0x0a, 0x0f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75,
	0x6c, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x21, 0x0a, 0x1d, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50,
	0x5f, 0x56, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x41, 0x43,
	0x4b, 0x55, 0x50, 0x5f, 0x56, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42,
	0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50,
	0x5f, 0x56, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c,
	0x10, 0x02, 0x42, 0xc0, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x42, 0x10, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0x3b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x70,
	0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x44, 0x52, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44,
	0x52, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_backupdr_v1_backupvault_proto_rawDescOnce sync.Once
	file_google_cloud_backupdr_v1_backupvault_proto_rawDescData = file_google_cloud_backupdr_v1_backupvault_proto_rawDesc
)

func file_google_cloud_backupdr_v1_backupvault_proto_rawDescGZIP() []byte {
	file_google_cloud_backupdr_v1_backupvault_proto_rawDescOnce.Do(func() {
		file_google_cloud_backupdr_v1_backupvault_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_backupdr_v1_backupvault_proto_rawDescData)
	})
	return file_google_cloud_backupdr_v1_backupvault_proto_rawDescData
}

var file_google_cloud_backupdr_v1_backupvault_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_backupdr_v1_backupvault_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_google_cloud_backupdr_v1_backupvault_proto_goTypes = []any{
	(BackupConfigState)(0),                       // 0: google.cloud.backupdr.v1.BackupConfigState
	(BackupView)(0),                              // 1: google.cloud.backupdr.v1.BackupView
	(BackupVaultView)(0),                         // 2: google.cloud.backupdr.v1.BackupVaultView
	(BackupVault_State)(0),                       // 3: google.cloud.backupdr.v1.BackupVault.State
	(BackupVault_AccessRestriction)(0),           // 4: google.cloud.backupdr.v1.BackupVault.AccessRestriction
	(DataSource_State)(0),                        // 5: google.cloud.backupdr.v1.DataSource.State
	(BackupConfigInfo_LastBackupState)(0),        // 6: google.cloud.backupdr.v1.BackupConfigInfo.LastBackupState
	(Backup_State)(0),                            // 7: google.cloud.backupdr.v1.Backup.State
	(Backup_BackupType)(0),                       // 8: google.cloud.backupdr.v1.Backup.BackupType
	(*BackupVault)(nil),                          // 9: google.cloud.backupdr.v1.BackupVault
	(*DataSource)(nil),                           // 10: google.cloud.backupdr.v1.DataSource
	(*BackupConfigInfo)(nil),                     // 11: google.cloud.backupdr.v1.BackupConfigInfo
	(*GcpBackupConfig)(nil),                      // 12: google.cloud.backupdr.v1.GcpBackupConfig
	(*BackupApplianceBackupConfig)(nil),          // 13: google.cloud.backupdr.v1.BackupApplianceBackupConfig
	(*DataSourceGcpResource)(nil),                // 14: google.cloud.backupdr.v1.DataSourceGcpResource
	(*DataSourceBackupApplianceApplication)(nil), // 15: google.cloud.backupdr.v1.DataSourceBackupApplianceApplication
	(*ServiceLockInfo)(nil),                      // 16: google.cloud.backupdr.v1.ServiceLockInfo
	(*BackupApplianceLockInfo)(nil),              // 17: google.cloud.backupdr.v1.BackupApplianceLockInfo
	(*BackupLock)(nil),                           // 18: google.cloud.backupdr.v1.BackupLock
	(*Backup)(nil),                               // 19: google.cloud.backupdr.v1.Backup
	(*CreateBackupVaultRequest)(nil),             // 20: google.cloud.backupdr.v1.CreateBackupVaultRequest
	(*ListBackupVaultsRequest)(nil),              // 21: google.cloud.backupdr.v1.ListBackupVaultsRequest
	(*ListBackupVaultsResponse)(nil),             // 22: google.cloud.backupdr.v1.ListBackupVaultsResponse
	(*FetchUsableBackupVaultsRequest)(nil),       // 23: google.cloud.backupdr.v1.FetchUsableBackupVaultsRequest
	(*FetchUsableBackupVaultsResponse)(nil),      // 24: google.cloud.backupdr.v1.FetchUsableBackupVaultsResponse
	(*GetBackupVaultRequest)(nil),                // 25: google.cloud.backupdr.v1.GetBackupVaultRequest
	(*UpdateBackupVaultRequest)(nil),             // 26: google.cloud.backupdr.v1.UpdateBackupVaultRequest
	(*DeleteBackupVaultRequest)(nil),             // 27: google.cloud.backupdr.v1.DeleteBackupVaultRequest
	(*ListDataSourcesRequest)(nil),               // 28: google.cloud.backupdr.v1.ListDataSourcesRequest
	(*ListDataSourcesResponse)(nil),              // 29: google.cloud.backupdr.v1.ListDataSourcesResponse
	(*GetDataSourceRequest)(nil),                 // 30: google.cloud.backupdr.v1.GetDataSourceRequest
	(*UpdateDataSourceRequest)(nil),              // 31: google.cloud.backupdr.v1.UpdateDataSourceRequest
	(*ListBackupsRequest)(nil),                   // 32: google.cloud.backupdr.v1.ListBackupsRequest
	(*ListBackupsResponse)(nil),                  // 33: google.cloud.backupdr.v1.ListBackupsResponse
	(*GetBackupRequest)(nil),                     // 34: google.cloud.backupdr.v1.GetBackupRequest
	(*UpdateBackupRequest)(nil),                  // 35: google.cloud.backupdr.v1.UpdateBackupRequest
	(*DeleteBackupRequest)(nil),                  // 36: google.cloud.backupdr.v1.DeleteBackupRequest
	(*RestoreBackupRequest)(nil),                 // 37: google.cloud.backupdr.v1.RestoreBackupRequest
	(*RestoreBackupResponse)(nil),                // 38: google.cloud.backupdr.v1.RestoreBackupResponse
	(*TargetResource)(nil),                       // 39: google.cloud.backupdr.v1.TargetResource
	(*GcpResource)(nil),                          // 40: google.cloud.backupdr.v1.GcpResource
	nil,                                          // 41: google.cloud.backupdr.v1.BackupVault.LabelsEntry
	nil,                                          // 42: google.cloud.backupdr.v1.BackupVault.AnnotationsEntry
	nil,                                          // 43: google.cloud.backupdr.v1.DataSource.LabelsEntry
	(*Backup_GCPBackupPlanInfo)(nil),             // 44: google.cloud.backupdr.v1.Backup.GCPBackupPlanInfo
	nil,                                          // 45: google.cloud.backupdr.v1.Backup.LabelsEntry
	(*timestamppb.Timestamp)(nil),                // 46: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                  // 47: google.protobuf.Duration
	(*status.Status)(nil),                        // 48: google.rpc.Status
	(*ComputeInstanceDataSourceProperties)(nil),  // 49: google.cloud.backupdr.v1.ComputeInstanceDataSourceProperties
	(*ComputeInstanceBackupProperties)(nil),      // 50: google.cloud.backupdr.v1.ComputeInstanceBackupProperties
	(*BackupApplianceBackupProperties)(nil),      // 51: google.cloud.backupdr.v1.BackupApplianceBackupProperties
	(*fieldmaskpb.FieldMask)(nil),                // 52: google.protobuf.FieldMask
	(*ComputeInstanceTargetEnvironment)(nil),     // 53: google.cloud.backupdr.v1.ComputeInstanceTargetEnvironment
	(*ComputeInstanceRestoreProperties)(nil),     // 54: google.cloud.backupdr.v1.ComputeInstanceRestoreProperties
}
var file_google_cloud_backupdr_v1_backupvault_proto_depIdxs = []int32{
	41, // 0: google.cloud.backupdr.v1.BackupVault.labels:type_name -> google.cloud.backupdr.v1.BackupVault.LabelsEntry
	46, // 1: google.cloud.backupdr.v1.BackupVault.create_time:type_name -> google.protobuf.Timestamp
	46, // 2: google.cloud.backupdr.v1.BackupVault.update_time:type_name -> google.protobuf.Timestamp
	47, // 3: google.cloud.backupdr.v1.BackupVault.backup_minimum_enforced_retention_duration:type_name -> google.protobuf.Duration
	3,  // 4: google.cloud.backupdr.v1.BackupVault.state:type_name -> google.cloud.backupdr.v1.BackupVault.State
	46, // 5: google.cloud.backupdr.v1.BackupVault.effective_time:type_name -> google.protobuf.Timestamp
	42, // 6: google.cloud.backupdr.v1.BackupVault.annotations:type_name -> google.cloud.backupdr.v1.BackupVault.AnnotationsEntry
	4,  // 7: google.cloud.backupdr.v1.BackupVault.access_restriction:type_name -> google.cloud.backupdr.v1.BackupVault.AccessRestriction
	5,  // 8: google.cloud.backupdr.v1.DataSource.state:type_name -> google.cloud.backupdr.v1.DataSource.State
	43, // 9: google.cloud.backupdr.v1.DataSource.labels:type_name -> google.cloud.backupdr.v1.DataSource.LabelsEntry
	46, // 10: google.cloud.backupdr.v1.DataSource.create_time:type_name -> google.protobuf.Timestamp
	46, // 11: google.cloud.backupdr.v1.DataSource.update_time:type_name -> google.protobuf.Timestamp
	0,  // 12: google.cloud.backupdr.v1.DataSource.config_state:type_name -> google.cloud.backupdr.v1.BackupConfigState
	11, // 13: google.cloud.backupdr.v1.DataSource.backup_config_info:type_name -> google.cloud.backupdr.v1.BackupConfigInfo
	14, // 14: google.cloud.backupdr.v1.DataSource.data_source_gcp_resource:type_name -> google.cloud.backupdr.v1.DataSourceGcpResource
	15, // 15: google.cloud.backupdr.v1.DataSource.data_source_backup_appliance_application:type_name -> google.cloud.backupdr.v1.DataSourceBackupApplianceApplication
	6,  // 16: google.cloud.backupdr.v1.BackupConfigInfo.last_backup_state:type_name -> google.cloud.backupdr.v1.BackupConfigInfo.LastBackupState
	46, // 17: google.cloud.backupdr.v1.BackupConfigInfo.last_successful_backup_consistency_time:type_name -> google.protobuf.Timestamp
	48, // 18: google.cloud.backupdr.v1.BackupConfigInfo.last_backup_error:type_name -> google.rpc.Status
	12, // 19: google.cloud.backupdr.v1.BackupConfigInfo.gcp_backup_config:type_name -> google.cloud.backupdr.v1.GcpBackupConfig
	13, // 20: google.cloud.backupdr.v1.BackupConfigInfo.backup_appliance_backup_config:type_name -> google.cloud.backupdr.v1.BackupApplianceBackupConfig
	49, // 21: google.cloud.backupdr.v1.DataSourceGcpResource.compute_instance_datasource_properties:type_name -> google.cloud.backupdr.v1.ComputeInstanceDataSourceProperties
	46, // 22: google.cloud.backupdr.v1.BackupLock.lock_until_time:type_name -> google.protobuf.Timestamp
	17, // 23: google.cloud.backupdr.v1.BackupLock.backup_appliance_lock_info:type_name -> google.cloud.backupdr.v1.BackupApplianceLockInfo
	16, // 24: google.cloud.backupdr.v1.BackupLock.service_lock_info:type_name -> google.cloud.backupdr.v1.ServiceLockInfo
	46, // 25: google.cloud.backupdr.v1.Backup.create_time:type_name -> google.protobuf.Timestamp
	46, // 26: google.cloud.backupdr.v1.Backup.update_time:type_name -> google.protobuf.Timestamp
	45, // 27: google.cloud.backupdr.v1.Backup.labels:type_name -> google.cloud.backupdr.v1.Backup.LabelsEntry
	46, // 28: google.cloud.backupdr.v1.Backup.enforced_retention_end_time:type_name -> google.protobuf.Timestamp
	46, // 29: google.cloud.backupdr.v1.Backup.expire_time:type_name -> google.protobuf.Timestamp
	46, // 30: google.cloud.backupdr.v1.Backup.consistency_time:type_name -> google.protobuf.Timestamp
	7,  // 31: google.cloud.backupdr.v1.Backup.state:type_name -> google.cloud.backupdr.v1.Backup.State
	18, // 32: google.cloud.backupdr.v1.Backup.service_locks:type_name -> google.cloud.backupdr.v1.BackupLock
	18, // 33: google.cloud.backupdr.v1.Backup.backup_appliance_locks:type_name -> google.cloud.backupdr.v1.BackupLock
	50, // 34: google.cloud.backupdr.v1.Backup.compute_instance_backup_properties:type_name -> google.cloud.backupdr.v1.ComputeInstanceBackupProperties
	51, // 35: google.cloud.backupdr.v1.Backup.backup_appliance_backup_properties:type_name -> google.cloud.backupdr.v1.BackupApplianceBackupProperties
	8,  // 36: google.cloud.backupdr.v1.Backup.backup_type:type_name -> google.cloud.backupdr.v1.Backup.BackupType
	44, // 37: google.cloud.backupdr.v1.Backup.gcp_backup_plan_info:type_name -> google.cloud.backupdr.v1.Backup.GCPBackupPlanInfo
	9,  // 38: google.cloud.backupdr.v1.CreateBackupVaultRequest.backup_vault:type_name -> google.cloud.backupdr.v1.BackupVault
	2,  // 39: google.cloud.backupdr.v1.ListBackupVaultsRequest.view:type_name -> google.cloud.backupdr.v1.BackupVaultView
	9,  // 40: google.cloud.backupdr.v1.ListBackupVaultsResponse.backup_vaults:type_name -> google.cloud.backupdr.v1.BackupVault
	9,  // 41: google.cloud.backupdr.v1.FetchUsableBackupVaultsResponse.backup_vaults:type_name -> google.cloud.backupdr.v1.BackupVault
	2,  // 42: google.cloud.backupdr.v1.GetBackupVaultRequest.view:type_name -> google.cloud.backupdr.v1.BackupVaultView
	52, // 43: google.cloud.backupdr.v1.UpdateBackupVaultRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 44: google.cloud.backupdr.v1.UpdateBackupVaultRequest.backup_vault:type_name -> google.cloud.backupdr.v1.BackupVault
	10, // 45: google.cloud.backupdr.v1.ListDataSourcesResponse.data_sources:type_name -> google.cloud.backupdr.v1.DataSource
	52, // 46: google.cloud.backupdr.v1.UpdateDataSourceRequest.update_mask:type_name -> google.protobuf.FieldMask
	10, // 47: google.cloud.backupdr.v1.UpdateDataSourceRequest.data_source:type_name -> google.cloud.backupdr.v1.DataSource
	1,  // 48: google.cloud.backupdr.v1.ListBackupsRequest.view:type_name -> google.cloud.backupdr.v1.BackupView
	19, // 49: google.cloud.backupdr.v1.ListBackupsResponse.backups:type_name -> google.cloud.backupdr.v1.Backup
	1,  // 50: google.cloud.backupdr.v1.GetBackupRequest.view:type_name -> google.cloud.backupdr.v1.BackupView
	52, // 51: google.cloud.backupdr.v1.UpdateBackupRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 52: google.cloud.backupdr.v1.UpdateBackupRequest.backup:type_name -> google.cloud.backupdr.v1.Backup
	53, // 53: google.cloud.backupdr.v1.RestoreBackupRequest.compute_instance_target_environment:type_name -> google.cloud.backupdr.v1.ComputeInstanceTargetEnvironment
	54, // 54: google.cloud.backupdr.v1.RestoreBackupRequest.compute_instance_restore_properties:type_name -> google.cloud.backupdr.v1.ComputeInstanceRestoreProperties
	39, // 55: google.cloud.backupdr.v1.RestoreBackupResponse.target_resource:type_name -> google.cloud.backupdr.v1.TargetResource
	40, // 56: google.cloud.backupdr.v1.TargetResource.gcp_resource:type_name -> google.cloud.backupdr.v1.GcpResource
	57, // [57:57] is the sub-list for method output_type
	57, // [57:57] is the sub-list for method input_type
	57, // [57:57] is the sub-list for extension type_name
	57, // [57:57] is the sub-list for extension extendee
	0,  // [0:57] is the sub-list for field type_name
}

func init() { file_google_cloud_backupdr_v1_backupvault_proto_init() }
func file_google_cloud_backupdr_v1_backupvault_proto_init() {
	if File_google_cloud_backupdr_v1_backupvault_proto != nil {
		return
	}
	file_google_cloud_backupdr_v1_backupvault_ba_proto_init()
	file_google_cloud_backupdr_v1_backupvault_gce_proto_init()
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[1].OneofWrappers = []any{
		(*DataSource_DataSourceGcpResource)(nil),
		(*DataSource_DataSourceBackupApplianceApplication)(nil),
	}
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[2].OneofWrappers = []any{
		(*BackupConfigInfo_GcpBackupConfig)(nil),
		(*BackupConfigInfo_BackupApplianceBackupConfig)(nil),
	}
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[5].OneofWrappers = []any{
		(*DataSourceGcpResource_ComputeInstanceDatasourceProperties)(nil),
	}
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[8].OneofWrappers = []any{
		(*BackupApplianceLockInfo_JobName)(nil),
		(*BackupApplianceLockInfo_BackupImage)(nil),
		(*BackupApplianceLockInfo_SlaId)(nil),
	}
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[9].OneofWrappers = []any{
		(*BackupLock_BackupApplianceLockInfo)(nil),
		(*BackupLock_ServiceLockInfo)(nil),
	}
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[10].OneofWrappers = []any{
		(*Backup_ComputeInstanceBackupProperties)(nil),
		(*Backup_BackupApplianceBackupProperties)(nil),
		(*Backup_GcpBackupPlanInfo)(nil),
	}
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[28].OneofWrappers = []any{
		(*RestoreBackupRequest_ComputeInstanceTargetEnvironment)(nil),
		(*RestoreBackupRequest_ComputeInstanceRestoreProperties)(nil),
	}
	file_google_cloud_backupdr_v1_backupvault_proto_msgTypes[30].OneofWrappers = []any{
		(*TargetResource_GcpResource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_backupdr_v1_backupvault_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_backupdr_v1_backupvault_proto_goTypes,
		DependencyIndexes: file_google_cloud_backupdr_v1_backupvault_proto_depIdxs,
		EnumInfos:         file_google_cloud_backupdr_v1_backupvault_proto_enumTypes,
		MessageInfos:      file_google_cloud_backupdr_v1_backupvault_proto_msgTypes,
	}.Build()
	File_google_cloud_backupdr_v1_backupvault_proto = out.File
	file_google_cloud_backupdr_v1_backupvault_proto_rawDesc = nil
	file_google_cloud_backupdr_v1_backupvault_proto_goTypes = nil
	file_google_cloud_backupdr_v1_backupvault_proto_depIdxs = nil
}
