// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package discoveryengine

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	discoveryenginepb "cloud.google.com/go/discoveryengine/apiv1alpha/discoveryenginepb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newSiteSearchEngineClientHook clientHook

// SiteSearchEngineCallOptions contains the retry settings for each method of SiteSearchEngineClient.
type SiteSearchEngineCallOptions struct {
	GetSiteSearchEngine           []gax.CallOption
	CreateTargetSite              []gax.CallOption
	BatchCreateTargetSites        []gax.CallOption
	GetTargetSite                 []gax.CallOption
	UpdateTargetSite              []gax.CallOption
	DeleteTargetSite              []gax.CallOption
	ListTargetSites               []gax.CallOption
	EnableAdvancedSiteSearch      []gax.CallOption
	DisableAdvancedSiteSearch     []gax.CallOption
	RecrawlUris                   []gax.CallOption
	BatchVerifyTargetSites        []gax.CallOption
	FetchDomainVerificationStatus []gax.CallOption
	SetUriPatternDocumentData     []gax.CallOption
	GetUriPatternDocumentData     []gax.CallOption
	CancelOperation               []gax.CallOption
	GetOperation                  []gax.CallOption
	ListOperations                []gax.CallOption
}

func defaultSiteSearchEngineGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("discoveryengine.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("discoveryengine.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("discoveryengine.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://discoveryengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultSiteSearchEngineCallOptions() *SiteSearchEngineCallOptions {
	return &SiteSearchEngineCallOptions{
		GetSiteSearchEngine:           []gax.CallOption{},
		CreateTargetSite:              []gax.CallOption{},
		BatchCreateTargetSites:        []gax.CallOption{},
		GetTargetSite:                 []gax.CallOption{},
		UpdateTargetSite:              []gax.CallOption{},
		DeleteTargetSite:              []gax.CallOption{},
		ListTargetSites:               []gax.CallOption{},
		EnableAdvancedSiteSearch:      []gax.CallOption{},
		DisableAdvancedSiteSearch:     []gax.CallOption{},
		RecrawlUris:                   []gax.CallOption{},
		BatchVerifyTargetSites:        []gax.CallOption{},
		FetchDomainVerificationStatus: []gax.CallOption{},
		SetUriPatternDocumentData:     []gax.CallOption{},
		GetUriPatternDocumentData:     []gax.CallOption{},
		CancelOperation: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetOperation: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListOperations: []gax.CallOption{
			gax.WithTimeout(300000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        30000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultSiteSearchEngineRESTCallOptions() *SiteSearchEngineCallOptions {
	return &SiteSearchEngineCallOptions{
		GetSiteSearchEngine:           []gax.CallOption{},
		CreateTargetSite:              []gax.CallOption{},
		BatchCreateTargetSites:        []gax.CallOption{},
		GetTargetSite:                 []gax.CallOption{},
		UpdateTargetSite:              []gax.CallOption{},
		DeleteTargetSite:              []gax.CallOption{},
		ListTargetSites:               []gax.CallOption{},
		EnableAdvancedSiteSearch:      []gax.CallOption{},
		DisableAdvancedSiteSearch:     []gax.CallOption{},
		RecrawlUris:                   []gax.CallOption{},
		BatchVerifyTargetSites:        []gax.CallOption{},
		FetchDomainVerificationStatus: []gax.CallOption{},
		SetUriPatternDocumentData:     []gax.CallOption{},
		GetUriPatternDocumentData:     []gax.CallOption{},
		CancelOperation: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetOperation: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListOperations: []gax.CallOption{
			gax.WithTimeout(300000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        30000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalSiteSearchEngineClient is an interface that defines the methods available from Discovery Engine API.
type internalSiteSearchEngineClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetSiteSearchEngine(context.Context, *discoveryenginepb.GetSiteSearchEngineRequest, ...gax.CallOption) (*discoveryenginepb.SiteSearchEngine, error)
	CreateTargetSite(context.Context, *discoveryenginepb.CreateTargetSiteRequest, ...gax.CallOption) (*CreateTargetSiteOperation, error)
	CreateTargetSiteOperation(name string) *CreateTargetSiteOperation
	BatchCreateTargetSites(context.Context, *discoveryenginepb.BatchCreateTargetSitesRequest, ...gax.CallOption) (*BatchCreateTargetSitesOperation, error)
	BatchCreateTargetSitesOperation(name string) *BatchCreateTargetSitesOperation
	GetTargetSite(context.Context, *discoveryenginepb.GetTargetSiteRequest, ...gax.CallOption) (*discoveryenginepb.TargetSite, error)
	UpdateTargetSite(context.Context, *discoveryenginepb.UpdateTargetSiteRequest, ...gax.CallOption) (*UpdateTargetSiteOperation, error)
	UpdateTargetSiteOperation(name string) *UpdateTargetSiteOperation
	DeleteTargetSite(context.Context, *discoveryenginepb.DeleteTargetSiteRequest, ...gax.CallOption) (*DeleteTargetSiteOperation, error)
	DeleteTargetSiteOperation(name string) *DeleteTargetSiteOperation
	ListTargetSites(context.Context, *discoveryenginepb.ListTargetSitesRequest, ...gax.CallOption) *TargetSiteIterator
	EnableAdvancedSiteSearch(context.Context, *discoveryenginepb.EnableAdvancedSiteSearchRequest, ...gax.CallOption) (*EnableAdvancedSiteSearchOperation, error)
	EnableAdvancedSiteSearchOperation(name string) *EnableAdvancedSiteSearchOperation
	DisableAdvancedSiteSearch(context.Context, *discoveryenginepb.DisableAdvancedSiteSearchRequest, ...gax.CallOption) (*DisableAdvancedSiteSearchOperation, error)
	DisableAdvancedSiteSearchOperation(name string) *DisableAdvancedSiteSearchOperation
	RecrawlUris(context.Context, *discoveryenginepb.RecrawlUrisRequest, ...gax.CallOption) (*RecrawlUrisOperation, error)
	RecrawlUrisOperation(name string) *RecrawlUrisOperation
	BatchVerifyTargetSites(context.Context, *discoveryenginepb.BatchVerifyTargetSitesRequest, ...gax.CallOption) (*BatchVerifyTargetSitesOperation, error)
	BatchVerifyTargetSitesOperation(name string) *BatchVerifyTargetSitesOperation
	FetchDomainVerificationStatus(context.Context, *discoveryenginepb.FetchDomainVerificationStatusRequest, ...gax.CallOption) *TargetSiteIterator
	SetUriPatternDocumentData(context.Context, *discoveryenginepb.SetUriPatternDocumentDataRequest, ...gax.CallOption) (*SetUriPatternDocumentDataOperation, error)
	SetUriPatternDocumentDataOperation(name string) *SetUriPatternDocumentDataOperation
	GetUriPatternDocumentData(context.Context, *discoveryenginepb.GetUriPatternDocumentDataRequest, ...gax.CallOption) (*discoveryenginepb.GetUriPatternDocumentDataResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// SiteSearchEngineClient is a client for interacting with Discovery Engine API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service for managing site search related resources.
type SiteSearchEngineClient struct {
	// The internal transport-dependent client.
	internalClient internalSiteSearchEngineClient

	// The call options for this service.
	CallOptions *SiteSearchEngineCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *SiteSearchEngineClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *SiteSearchEngineClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *SiteSearchEngineClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetSiteSearchEngine gets the
// SiteSearchEngine.
func (c *SiteSearchEngineClient) GetSiteSearchEngine(ctx context.Context, req *discoveryenginepb.GetSiteSearchEngineRequest, opts ...gax.CallOption) (*discoveryenginepb.SiteSearchEngine, error) {
	return c.internalClient.GetSiteSearchEngine(ctx, req, opts...)
}

// CreateTargetSite creates a TargetSite.
func (c *SiteSearchEngineClient) CreateTargetSite(ctx context.Context, req *discoveryenginepb.CreateTargetSiteRequest, opts ...gax.CallOption) (*CreateTargetSiteOperation, error) {
	return c.internalClient.CreateTargetSite(ctx, req, opts...)
}

// CreateTargetSiteOperation returns a new CreateTargetSiteOperation from a given name.
// The name must be that of a previously created CreateTargetSiteOperation, possibly from a different process.
func (c *SiteSearchEngineClient) CreateTargetSiteOperation(name string) *CreateTargetSiteOperation {
	return c.internalClient.CreateTargetSiteOperation(name)
}

// BatchCreateTargetSites creates TargetSite in a
// batch.
func (c *SiteSearchEngineClient) BatchCreateTargetSites(ctx context.Context, req *discoveryenginepb.BatchCreateTargetSitesRequest, opts ...gax.CallOption) (*BatchCreateTargetSitesOperation, error) {
	return c.internalClient.BatchCreateTargetSites(ctx, req, opts...)
}

// BatchCreateTargetSitesOperation returns a new BatchCreateTargetSitesOperation from a given name.
// The name must be that of a previously created BatchCreateTargetSitesOperation, possibly from a different process.
func (c *SiteSearchEngineClient) BatchCreateTargetSitesOperation(name string) *BatchCreateTargetSitesOperation {
	return c.internalClient.BatchCreateTargetSitesOperation(name)
}

// GetTargetSite gets a TargetSite.
func (c *SiteSearchEngineClient) GetTargetSite(ctx context.Context, req *discoveryenginepb.GetTargetSiteRequest, opts ...gax.CallOption) (*discoveryenginepb.TargetSite, error) {
	return c.internalClient.GetTargetSite(ctx, req, opts...)
}

// UpdateTargetSite updates a TargetSite.
func (c *SiteSearchEngineClient) UpdateTargetSite(ctx context.Context, req *discoveryenginepb.UpdateTargetSiteRequest, opts ...gax.CallOption) (*UpdateTargetSiteOperation, error) {
	return c.internalClient.UpdateTargetSite(ctx, req, opts...)
}

// UpdateTargetSiteOperation returns a new UpdateTargetSiteOperation from a given name.
// The name must be that of a previously created UpdateTargetSiteOperation, possibly from a different process.
func (c *SiteSearchEngineClient) UpdateTargetSiteOperation(name string) *UpdateTargetSiteOperation {
	return c.internalClient.UpdateTargetSiteOperation(name)
}

// DeleteTargetSite deletes a TargetSite.
func (c *SiteSearchEngineClient) DeleteTargetSite(ctx context.Context, req *discoveryenginepb.DeleteTargetSiteRequest, opts ...gax.CallOption) (*DeleteTargetSiteOperation, error) {
	return c.internalClient.DeleteTargetSite(ctx, req, opts...)
}

// DeleteTargetSiteOperation returns a new DeleteTargetSiteOperation from a given name.
// The name must be that of a previously created DeleteTargetSiteOperation, possibly from a different process.
func (c *SiteSearchEngineClient) DeleteTargetSiteOperation(name string) *DeleteTargetSiteOperation {
	return c.internalClient.DeleteTargetSiteOperation(name)
}

// ListTargetSites gets a list of
// TargetSites.
func (c *SiteSearchEngineClient) ListTargetSites(ctx context.Context, req *discoveryenginepb.ListTargetSitesRequest, opts ...gax.CallOption) *TargetSiteIterator {
	return c.internalClient.ListTargetSites(ctx, req, opts...)
}

// EnableAdvancedSiteSearch upgrade from basic site search to advanced site search.
func (c *SiteSearchEngineClient) EnableAdvancedSiteSearch(ctx context.Context, req *discoveryenginepb.EnableAdvancedSiteSearchRequest, opts ...gax.CallOption) (*EnableAdvancedSiteSearchOperation, error) {
	return c.internalClient.EnableAdvancedSiteSearch(ctx, req, opts...)
}

// EnableAdvancedSiteSearchOperation returns a new EnableAdvancedSiteSearchOperation from a given name.
// The name must be that of a previously created EnableAdvancedSiteSearchOperation, possibly from a different process.
func (c *SiteSearchEngineClient) EnableAdvancedSiteSearchOperation(name string) *EnableAdvancedSiteSearchOperation {
	return c.internalClient.EnableAdvancedSiteSearchOperation(name)
}

// DisableAdvancedSiteSearch downgrade from advanced site search to basic site search.
func (c *SiteSearchEngineClient) DisableAdvancedSiteSearch(ctx context.Context, req *discoveryenginepb.DisableAdvancedSiteSearchRequest, opts ...gax.CallOption) (*DisableAdvancedSiteSearchOperation, error) {
	return c.internalClient.DisableAdvancedSiteSearch(ctx, req, opts...)
}

// DisableAdvancedSiteSearchOperation returns a new DisableAdvancedSiteSearchOperation from a given name.
// The name must be that of a previously created DisableAdvancedSiteSearchOperation, possibly from a different process.
func (c *SiteSearchEngineClient) DisableAdvancedSiteSearchOperation(name string) *DisableAdvancedSiteSearchOperation {
	return c.internalClient.DisableAdvancedSiteSearchOperation(name)
}

// RecrawlUris request on-demand recrawl for a list of URIs.
func (c *SiteSearchEngineClient) RecrawlUris(ctx context.Context, req *discoveryenginepb.RecrawlUrisRequest, opts ...gax.CallOption) (*RecrawlUrisOperation, error) {
	return c.internalClient.RecrawlUris(ctx, req, opts...)
}

// RecrawlUrisOperation returns a new RecrawlUrisOperation from a given name.
// The name must be that of a previously created RecrawlUrisOperation, possibly from a different process.
func (c *SiteSearchEngineClient) RecrawlUrisOperation(name string) *RecrawlUrisOperation {
	return c.internalClient.RecrawlUrisOperation(name)
}

// BatchVerifyTargetSites verify target sites’ ownership and validity.
// This API sends all the target sites under site search engine for
// verification.
func (c *SiteSearchEngineClient) BatchVerifyTargetSites(ctx context.Context, req *discoveryenginepb.BatchVerifyTargetSitesRequest, opts ...gax.CallOption) (*BatchVerifyTargetSitesOperation, error) {
	return c.internalClient.BatchVerifyTargetSites(ctx, req, opts...)
}

// BatchVerifyTargetSitesOperation returns a new BatchVerifyTargetSitesOperation from a given name.
// The name must be that of a previously created BatchVerifyTargetSitesOperation, possibly from a different process.
func (c *SiteSearchEngineClient) BatchVerifyTargetSitesOperation(name string) *BatchVerifyTargetSitesOperation {
	return c.internalClient.BatchVerifyTargetSitesOperation(name)
}

// FetchDomainVerificationStatus returns list of target sites with its domain verification status.
// This method can only be called under data store with BASIC_SITE_SEARCH
// state at the moment.
func (c *SiteSearchEngineClient) FetchDomainVerificationStatus(ctx context.Context, req *discoveryenginepb.FetchDomainVerificationStatusRequest, opts ...gax.CallOption) *TargetSiteIterator {
	return c.internalClient.FetchDomainVerificationStatus(ctx, req, opts...)
}

// SetUriPatternDocumentData sets the URI Pattern to Document data mapping for an Advanced Site Search
// DataStore.
func (c *SiteSearchEngineClient) SetUriPatternDocumentData(ctx context.Context, req *discoveryenginepb.SetUriPatternDocumentDataRequest, opts ...gax.CallOption) (*SetUriPatternDocumentDataOperation, error) {
	return c.internalClient.SetUriPatternDocumentData(ctx, req, opts...)
}

// SetUriPatternDocumentDataOperation returns a new SetUriPatternDocumentDataOperation from a given name.
// The name must be that of a previously created SetUriPatternDocumentDataOperation, possibly from a different process.
func (c *SiteSearchEngineClient) SetUriPatternDocumentDataOperation(name string) *SetUriPatternDocumentDataOperation {
	return c.internalClient.SetUriPatternDocumentDataOperation(name)
}

// GetUriPatternDocumentData gets the URI Pattern to Document data mapping for an Advanced Site Search
// DataStore.
func (c *SiteSearchEngineClient) GetUriPatternDocumentData(ctx context.Context, req *discoveryenginepb.GetUriPatternDocumentDataRequest, opts ...gax.CallOption) (*discoveryenginepb.GetUriPatternDocumentDataResponse, error) {
	return c.internalClient.GetUriPatternDocumentData(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *SiteSearchEngineClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *SiteSearchEngineClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *SiteSearchEngineClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// siteSearchEngineGRPCClient is a client for interacting with Discovery Engine API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type siteSearchEngineGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing SiteSearchEngineClient
	CallOptions **SiteSearchEngineCallOptions

	// The gRPC API client.
	siteSearchEngineClient discoveryenginepb.SiteSearchEngineServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewSiteSearchEngineClient creates a new site search engine service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service for managing site search related resources.
func NewSiteSearchEngineClient(ctx context.Context, opts ...option.ClientOption) (*SiteSearchEngineClient, error) {
	clientOpts := defaultSiteSearchEngineGRPCClientOptions()
	if newSiteSearchEngineClientHook != nil {
		hookOpts, err := newSiteSearchEngineClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := SiteSearchEngineClient{CallOptions: defaultSiteSearchEngineCallOptions()}

	c := &siteSearchEngineGRPCClient{
		connPool:               connPool,
		siteSearchEngineClient: discoveryenginepb.NewSiteSearchEngineServiceClient(connPool),
		CallOptions:            &client.CallOptions,
		logger:                 internaloption.GetLogger(opts),
		operationsClient:       longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *siteSearchEngineGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *siteSearchEngineGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *siteSearchEngineGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type siteSearchEngineRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing SiteSearchEngineClient
	CallOptions **SiteSearchEngineCallOptions

	logger *slog.Logger
}

// NewSiteSearchEngineRESTClient creates a new site search engine service rest client.
//
// Service for managing site search related resources.
func NewSiteSearchEngineRESTClient(ctx context.Context, opts ...option.ClientOption) (*SiteSearchEngineClient, error) {
	clientOpts := append(defaultSiteSearchEngineRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultSiteSearchEngineRESTCallOptions()
	c := &siteSearchEngineRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &SiteSearchEngineClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultSiteSearchEngineRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://discoveryengine.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://discoveryengine.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://discoveryengine.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://discoveryengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *siteSearchEngineRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *siteSearchEngineRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *siteSearchEngineRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *siteSearchEngineGRPCClient) GetSiteSearchEngine(ctx context.Context, req *discoveryenginepb.GetSiteSearchEngineRequest, opts ...gax.CallOption) (*discoveryenginepb.SiteSearchEngine, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSiteSearchEngine[0:len((*c.CallOptions).GetSiteSearchEngine):len((*c.CallOptions).GetSiteSearchEngine)], opts...)
	var resp *discoveryenginepb.SiteSearchEngine
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.GetSiteSearchEngine, req, settings.GRPC, c.logger, "GetSiteSearchEngine")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *siteSearchEngineGRPCClient) CreateTargetSite(ctx context.Context, req *discoveryenginepb.CreateTargetSiteRequest, opts ...gax.CallOption) (*CreateTargetSiteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateTargetSite[0:len((*c.CallOptions).CreateTargetSite):len((*c.CallOptions).CreateTargetSite)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.CreateTargetSite, req, settings.GRPC, c.logger, "CreateTargetSite")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateTargetSiteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) BatchCreateTargetSites(ctx context.Context, req *discoveryenginepb.BatchCreateTargetSitesRequest, opts ...gax.CallOption) (*BatchCreateTargetSitesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).BatchCreateTargetSites[0:len((*c.CallOptions).BatchCreateTargetSites):len((*c.CallOptions).BatchCreateTargetSites)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.BatchCreateTargetSites, req, settings.GRPC, c.logger, "BatchCreateTargetSites")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &BatchCreateTargetSitesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) GetTargetSite(ctx context.Context, req *discoveryenginepb.GetTargetSiteRequest, opts ...gax.CallOption) (*discoveryenginepb.TargetSite, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTargetSite[0:len((*c.CallOptions).GetTargetSite):len((*c.CallOptions).GetTargetSite)], opts...)
	var resp *discoveryenginepb.TargetSite
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.GetTargetSite, req, settings.GRPC, c.logger, "GetTargetSite")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *siteSearchEngineGRPCClient) UpdateTargetSite(ctx context.Context, req *discoveryenginepb.UpdateTargetSiteRequest, opts ...gax.CallOption) (*UpdateTargetSiteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "target_site.name", url.QueryEscape(req.GetTargetSite().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateTargetSite[0:len((*c.CallOptions).UpdateTargetSite):len((*c.CallOptions).UpdateTargetSite)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.UpdateTargetSite, req, settings.GRPC, c.logger, "UpdateTargetSite")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateTargetSiteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) DeleteTargetSite(ctx context.Context, req *discoveryenginepb.DeleteTargetSiteRequest, opts ...gax.CallOption) (*DeleteTargetSiteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteTargetSite[0:len((*c.CallOptions).DeleteTargetSite):len((*c.CallOptions).DeleteTargetSite)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.DeleteTargetSite, req, settings.GRPC, c.logger, "DeleteTargetSite")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTargetSiteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) ListTargetSites(ctx context.Context, req *discoveryenginepb.ListTargetSitesRequest, opts ...gax.CallOption) *TargetSiteIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListTargetSites[0:len((*c.CallOptions).ListTargetSites):len((*c.CallOptions).ListTargetSites)], opts...)
	it := &TargetSiteIterator{}
	req = proto.Clone(req).(*discoveryenginepb.ListTargetSitesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*discoveryenginepb.TargetSite, string, error) {
		resp := &discoveryenginepb.ListTargetSitesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.siteSearchEngineClient.ListTargetSites, req, settings.GRPC, c.logger, "ListTargetSites")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTargetSites(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *siteSearchEngineGRPCClient) EnableAdvancedSiteSearch(ctx context.Context, req *discoveryenginepb.EnableAdvancedSiteSearchRequest, opts ...gax.CallOption) (*EnableAdvancedSiteSearchOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EnableAdvancedSiteSearch[0:len((*c.CallOptions).EnableAdvancedSiteSearch):len((*c.CallOptions).EnableAdvancedSiteSearch)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.EnableAdvancedSiteSearch, req, settings.GRPC, c.logger, "EnableAdvancedSiteSearch")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &EnableAdvancedSiteSearchOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) DisableAdvancedSiteSearch(ctx context.Context, req *discoveryenginepb.DisableAdvancedSiteSearchRequest, opts ...gax.CallOption) (*DisableAdvancedSiteSearchOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DisableAdvancedSiteSearch[0:len((*c.CallOptions).DisableAdvancedSiteSearch):len((*c.CallOptions).DisableAdvancedSiteSearch)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.DisableAdvancedSiteSearch, req, settings.GRPC, c.logger, "DisableAdvancedSiteSearch")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DisableAdvancedSiteSearchOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) RecrawlUris(ctx context.Context, req *discoveryenginepb.RecrawlUrisRequest, opts ...gax.CallOption) (*RecrawlUrisOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RecrawlUris[0:len((*c.CallOptions).RecrawlUris):len((*c.CallOptions).RecrawlUris)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.RecrawlUris, req, settings.GRPC, c.logger, "RecrawlUris")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RecrawlUrisOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) BatchVerifyTargetSites(ctx context.Context, req *discoveryenginepb.BatchVerifyTargetSitesRequest, opts ...gax.CallOption) (*BatchVerifyTargetSitesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).BatchVerifyTargetSites[0:len((*c.CallOptions).BatchVerifyTargetSites):len((*c.CallOptions).BatchVerifyTargetSites)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.BatchVerifyTargetSites, req, settings.GRPC, c.logger, "BatchVerifyTargetSites")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &BatchVerifyTargetSitesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) FetchDomainVerificationStatus(ctx context.Context, req *discoveryenginepb.FetchDomainVerificationStatusRequest, opts ...gax.CallOption) *TargetSiteIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).FetchDomainVerificationStatus[0:len((*c.CallOptions).FetchDomainVerificationStatus):len((*c.CallOptions).FetchDomainVerificationStatus)], opts...)
	it := &TargetSiteIterator{}
	req = proto.Clone(req).(*discoveryenginepb.FetchDomainVerificationStatusRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*discoveryenginepb.TargetSite, string, error) {
		resp := &discoveryenginepb.FetchDomainVerificationStatusResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.siteSearchEngineClient.FetchDomainVerificationStatus, req, settings.GRPC, c.logger, "FetchDomainVerificationStatus")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTargetSites(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *siteSearchEngineGRPCClient) SetUriPatternDocumentData(ctx context.Context, req *discoveryenginepb.SetUriPatternDocumentDataRequest, opts ...gax.CallOption) (*SetUriPatternDocumentDataOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetUriPatternDocumentData[0:len((*c.CallOptions).SetUriPatternDocumentData):len((*c.CallOptions).SetUriPatternDocumentData)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.SetUriPatternDocumentData, req, settings.GRPC, c.logger, "SetUriPatternDocumentData")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SetUriPatternDocumentDataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *siteSearchEngineGRPCClient) GetUriPatternDocumentData(ctx context.Context, req *discoveryenginepb.GetUriPatternDocumentDataRequest, opts ...gax.CallOption) (*discoveryenginepb.GetUriPatternDocumentDataResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetUriPatternDocumentData[0:len((*c.CallOptions).GetUriPatternDocumentData):len((*c.CallOptions).GetUriPatternDocumentData)], opts...)
	var resp *discoveryenginepb.GetUriPatternDocumentDataResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.siteSearchEngineClient.GetUriPatternDocumentData, req, settings.GRPC, c.logger, "GetUriPatternDocumentData")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *siteSearchEngineGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *siteSearchEngineGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *siteSearchEngineGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetSiteSearchEngine gets the
// SiteSearchEngine.
func (c *siteSearchEngineRESTClient) GetSiteSearchEngine(ctx context.Context, req *discoveryenginepb.GetSiteSearchEngineRequest, opts ...gax.CallOption) (*discoveryenginepb.SiteSearchEngine, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSiteSearchEngine[0:len((*c.CallOptions).GetSiteSearchEngine):len((*c.CallOptions).GetSiteSearchEngine)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &discoveryenginepb.SiteSearchEngine{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetSiteSearchEngine")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateTargetSite creates a TargetSite.
func (c *siteSearchEngineRESTClient) CreateTargetSite(ctx context.Context, req *discoveryenginepb.CreateTargetSiteRequest, opts ...gax.CallOption) (*CreateTargetSiteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTargetSite()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v/targetSites", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateTargetSite")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &CreateTargetSiteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// BatchCreateTargetSites creates TargetSite in a
// batch.
func (c *siteSearchEngineRESTClient) BatchCreateTargetSites(ctx context.Context, req *discoveryenginepb.BatchCreateTargetSitesRequest, opts ...gax.CallOption) (*BatchCreateTargetSitesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v/targetSites:batchCreate", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "BatchCreateTargetSites")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &BatchCreateTargetSitesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetTargetSite gets a TargetSite.
func (c *siteSearchEngineRESTClient) GetTargetSite(ctx context.Context, req *discoveryenginepb.GetTargetSiteRequest, opts ...gax.CallOption) (*discoveryenginepb.TargetSite, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetTargetSite[0:len((*c.CallOptions).GetTargetSite):len((*c.CallOptions).GetTargetSite)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &discoveryenginepb.TargetSite{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetTargetSite")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateTargetSite updates a TargetSite.
func (c *siteSearchEngineRESTClient) UpdateTargetSite(ctx context.Context, req *discoveryenginepb.UpdateTargetSiteRequest, opts ...gax.CallOption) (*UpdateTargetSiteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTargetSite()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v", req.GetTargetSite().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "target_site.name", url.QueryEscape(req.GetTargetSite().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateTargetSite")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &UpdateTargetSiteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteTargetSite deletes a TargetSite.
func (c *siteSearchEngineRESTClient) DeleteTargetSite(ctx context.Context, req *discoveryenginepb.DeleteTargetSiteRequest, opts ...gax.CallOption) (*DeleteTargetSiteOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteTargetSite")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &DeleteTargetSiteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListTargetSites gets a list of
// TargetSites.
func (c *siteSearchEngineRESTClient) ListTargetSites(ctx context.Context, req *discoveryenginepb.ListTargetSitesRequest, opts ...gax.CallOption) *TargetSiteIterator {
	it := &TargetSiteIterator{}
	req = proto.Clone(req).(*discoveryenginepb.ListTargetSitesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*discoveryenginepb.TargetSite, string, error) {
		resp := &discoveryenginepb.ListTargetSitesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1alpha/%v/targetSites", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListTargetSites")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetTargetSites(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// EnableAdvancedSiteSearch upgrade from basic site search to advanced site search.
func (c *siteSearchEngineRESTClient) EnableAdvancedSiteSearch(ctx context.Context, req *discoveryenginepb.EnableAdvancedSiteSearchRequest, opts ...gax.CallOption) (*EnableAdvancedSiteSearchOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v:enableAdvancedSiteSearch", req.GetSiteSearchEngine())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "EnableAdvancedSiteSearch")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &EnableAdvancedSiteSearchOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DisableAdvancedSiteSearch downgrade from advanced site search to basic site search.
func (c *siteSearchEngineRESTClient) DisableAdvancedSiteSearch(ctx context.Context, req *discoveryenginepb.DisableAdvancedSiteSearchRequest, opts ...gax.CallOption) (*DisableAdvancedSiteSearchOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v:disableAdvancedSiteSearch", req.GetSiteSearchEngine())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "DisableAdvancedSiteSearch")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &DisableAdvancedSiteSearchOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RecrawlUris request on-demand recrawl for a list of URIs.
func (c *siteSearchEngineRESTClient) RecrawlUris(ctx context.Context, req *discoveryenginepb.RecrawlUrisRequest, opts ...gax.CallOption) (*RecrawlUrisOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v:recrawlUris", req.GetSiteSearchEngine())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RecrawlUris")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &RecrawlUrisOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// BatchVerifyTargetSites verify target sites’ ownership and validity.
// This API sends all the target sites under site search engine for
// verification.
func (c *siteSearchEngineRESTClient) BatchVerifyTargetSites(ctx context.Context, req *discoveryenginepb.BatchVerifyTargetSitesRequest, opts ...gax.CallOption) (*BatchVerifyTargetSitesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v:batchVerifyTargetSites", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "BatchVerifyTargetSites")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &BatchVerifyTargetSitesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// FetchDomainVerificationStatus returns list of target sites with its domain verification status.
// This method can only be called under data store with BASIC_SITE_SEARCH
// state at the moment.
func (c *siteSearchEngineRESTClient) FetchDomainVerificationStatus(ctx context.Context, req *discoveryenginepb.FetchDomainVerificationStatusRequest, opts ...gax.CallOption) *TargetSiteIterator {
	it := &TargetSiteIterator{}
	req = proto.Clone(req).(*discoveryenginepb.FetchDomainVerificationStatusRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*discoveryenginepb.TargetSite, string, error) {
		resp := &discoveryenginepb.FetchDomainVerificationStatusResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1alpha/%v:fetchDomainVerificationStatus", req.GetSiteSearchEngine())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "FetchDomainVerificationStatus")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetTargetSites(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SetUriPatternDocumentData sets the URI Pattern to Document data mapping for an Advanced Site Search
// DataStore.
func (c *siteSearchEngineRESTClient) SetUriPatternDocumentData(ctx context.Context, req *discoveryenginepb.SetUriPatternDocumentDataRequest, opts ...gax.CallOption) (*SetUriPatternDocumentDataOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v:setUriPatternDocumentData", req.GetSiteSearchEngine())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "SetUriPatternDocumentData")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1alpha/%s", resp.GetName())
	return &SetUriPatternDocumentDataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetUriPatternDocumentData gets the URI Pattern to Document data mapping for an Advanced Site Search
// DataStore.
func (c *siteSearchEngineRESTClient) GetUriPatternDocumentData(ctx context.Context, req *discoveryenginepb.GetUriPatternDocumentDataRequest, opts ...gax.CallOption) (*discoveryenginepb.GetUriPatternDocumentDataResponse, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v:getUriPatternDocumentData", req.GetSiteSearchEngine())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "site_search_engine", url.QueryEscape(req.GetSiteSearchEngine()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetUriPatternDocumentData[0:len((*c.CallOptions).GetUriPatternDocumentData):len((*c.CallOptions).GetUriPatternDocumentData)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &discoveryenginepb.GetUriPatternDocumentDataResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetUriPatternDocumentData")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *siteSearchEngineRESTClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *siteSearchEngineRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1alpha/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *siteSearchEngineRESTClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1alpha/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// BatchCreateTargetSitesOperation returns a new BatchCreateTargetSitesOperation from a given name.
// The name must be that of a previously created BatchCreateTargetSitesOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) BatchCreateTargetSitesOperation(name string) *BatchCreateTargetSitesOperation {
	return &BatchCreateTargetSitesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// BatchCreateTargetSitesOperation returns a new BatchCreateTargetSitesOperation from a given name.
// The name must be that of a previously created BatchCreateTargetSitesOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) BatchCreateTargetSitesOperation(name string) *BatchCreateTargetSitesOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &BatchCreateTargetSitesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// BatchVerifyTargetSitesOperation returns a new BatchVerifyTargetSitesOperation from a given name.
// The name must be that of a previously created BatchVerifyTargetSitesOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) BatchVerifyTargetSitesOperation(name string) *BatchVerifyTargetSitesOperation {
	return &BatchVerifyTargetSitesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// BatchVerifyTargetSitesOperation returns a new BatchVerifyTargetSitesOperation from a given name.
// The name must be that of a previously created BatchVerifyTargetSitesOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) BatchVerifyTargetSitesOperation(name string) *BatchVerifyTargetSitesOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &BatchVerifyTargetSitesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateTargetSiteOperation returns a new CreateTargetSiteOperation from a given name.
// The name must be that of a previously created CreateTargetSiteOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) CreateTargetSiteOperation(name string) *CreateTargetSiteOperation {
	return &CreateTargetSiteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateTargetSiteOperation returns a new CreateTargetSiteOperation from a given name.
// The name must be that of a previously created CreateTargetSiteOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) CreateTargetSiteOperation(name string) *CreateTargetSiteOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &CreateTargetSiteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteTargetSiteOperation returns a new DeleteTargetSiteOperation from a given name.
// The name must be that of a previously created DeleteTargetSiteOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) DeleteTargetSiteOperation(name string) *DeleteTargetSiteOperation {
	return &DeleteTargetSiteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteTargetSiteOperation returns a new DeleteTargetSiteOperation from a given name.
// The name must be that of a previously created DeleteTargetSiteOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) DeleteTargetSiteOperation(name string) *DeleteTargetSiteOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &DeleteTargetSiteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DisableAdvancedSiteSearchOperation returns a new DisableAdvancedSiteSearchOperation from a given name.
// The name must be that of a previously created DisableAdvancedSiteSearchOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) DisableAdvancedSiteSearchOperation(name string) *DisableAdvancedSiteSearchOperation {
	return &DisableAdvancedSiteSearchOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DisableAdvancedSiteSearchOperation returns a new DisableAdvancedSiteSearchOperation from a given name.
// The name must be that of a previously created DisableAdvancedSiteSearchOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) DisableAdvancedSiteSearchOperation(name string) *DisableAdvancedSiteSearchOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &DisableAdvancedSiteSearchOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// EnableAdvancedSiteSearchOperation returns a new EnableAdvancedSiteSearchOperation from a given name.
// The name must be that of a previously created EnableAdvancedSiteSearchOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) EnableAdvancedSiteSearchOperation(name string) *EnableAdvancedSiteSearchOperation {
	return &EnableAdvancedSiteSearchOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// EnableAdvancedSiteSearchOperation returns a new EnableAdvancedSiteSearchOperation from a given name.
// The name must be that of a previously created EnableAdvancedSiteSearchOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) EnableAdvancedSiteSearchOperation(name string) *EnableAdvancedSiteSearchOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &EnableAdvancedSiteSearchOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RecrawlUrisOperation returns a new RecrawlUrisOperation from a given name.
// The name must be that of a previously created RecrawlUrisOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) RecrawlUrisOperation(name string) *RecrawlUrisOperation {
	return &RecrawlUrisOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RecrawlUrisOperation returns a new RecrawlUrisOperation from a given name.
// The name must be that of a previously created RecrawlUrisOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) RecrawlUrisOperation(name string) *RecrawlUrisOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &RecrawlUrisOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// SetUriPatternDocumentDataOperation returns a new SetUriPatternDocumentDataOperation from a given name.
// The name must be that of a previously created SetUriPatternDocumentDataOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) SetUriPatternDocumentDataOperation(name string) *SetUriPatternDocumentDataOperation {
	return &SetUriPatternDocumentDataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SetUriPatternDocumentDataOperation returns a new SetUriPatternDocumentDataOperation from a given name.
// The name must be that of a previously created SetUriPatternDocumentDataOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) SetUriPatternDocumentDataOperation(name string) *SetUriPatternDocumentDataOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &SetUriPatternDocumentDataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateTargetSiteOperation returns a new UpdateTargetSiteOperation from a given name.
// The name must be that of a previously created UpdateTargetSiteOperation, possibly from a different process.
func (c *siteSearchEngineGRPCClient) UpdateTargetSiteOperation(name string) *UpdateTargetSiteOperation {
	return &UpdateTargetSiteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateTargetSiteOperation returns a new UpdateTargetSiteOperation from a given name.
// The name must be that of a previously created UpdateTargetSiteOperation, possibly from a different process.
func (c *siteSearchEngineRESTClient) UpdateTargetSiteOperation(name string) *UpdateTargetSiteOperation {
	override := fmt.Sprintf("/v1alpha/%s", name)
	return &UpdateTargetSiteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
