// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/eventarc/v1/pipeline.proto

package eventarcpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A representation of the Pipeline resource.
type Pipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the Pipeline. Must be unique within the
	// location of the project and must be in
	// `projects/{project}/locations/{location}/pipelines/{pipeline}` format.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	// A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
	// to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
	// "2014-10-02T15:01:23.045123456Z".
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	// A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
	// to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
	// "2014-10-02T15:01:23.045123456Z".
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User labels attached to the Pipeline that can be used to group
	// resources. An object containing a list of "key": value pairs. Example: {
	// "name": "wrench", "mass": "1.3kg", "count": "3" }.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Server-assigned unique identifier for the Pipeline. The value
	// is a UUID4 string and guaranteed to remain unchanged until the resource is
	// deleted.
	Uid string `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. User-defined annotations. See
	// https://google.aip.dev/128#annotations.
	Annotations map[string]string `protobuf:"bytes,6,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Display name of resource.
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. List of destinations to which messages will be forwarded.
	// Currently, exactly one destination is supported per Pipeline.
	Destinations []*Pipeline_Destination `protobuf:"bytes,8,rep,name=destinations,proto3" json:"destinations,omitempty"`
	// Optional. List of mediation operations to be performed on the message.
	// Currently, only one Transformation operation is allowed in each Pipeline.
	Mediations []*Pipeline_Mediation `protobuf:"bytes,9,rep,name=mediations,proto3" json:"mediations,omitempty"`
	// Optional. Resource name of a KMS crypto key (managed by the user) used to
	// encrypt/decrypt the event data. If not set, an internal Google-owned key
	// will be used to encrypt messages. It must match the pattern
	// "projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}".
	CryptoKeyName string `protobuf:"bytes,10,opt,name=crypto_key_name,json=cryptoKeyName,proto3" json:"crypto_key_name,omitempty"`
	// Optional. The payload format expected for the messages received by the
	// Pipeline. If input_payload_format is set then any messages not matching
	// this format will be treated as persistent errors. If input_payload_format
	// is not set, then the message data will be treated as an opaque binary and
	// no output format can be set on the Pipeline through the
	// Pipeline.Destination.output_payload_format field. Any Mediations on the
	// Pipeline that involve access to the data field will fail as persistent
	// errors.
	InputPayloadFormat *Pipeline_MessagePayloadFormat `protobuf:"bytes,11,opt,name=input_payload_format,json=inputPayloadFormat,proto3" json:"input_payload_format,omitempty"`
	// Optional. Config to control Platform Logging for Pipelines.
	LoggingConfig *LoggingConfig `protobuf:"bytes,12,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Optional. The retry policy to use in the pipeline.
	RetryPolicy *Pipeline_RetryPolicy `protobuf:"bytes,13,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
	// Output only. This checksum is computed by the server based on the value of
	// other fields, and might be sent only on create requests to ensure that the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,99,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Pipeline) Reset() {
	*x = Pipeline{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline) ProtoMessage() {}

func (x *Pipeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline.ProtoReflect.Descriptor instead.
func (*Pipeline) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0}
}

func (x *Pipeline) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Pipeline) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Pipeline) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Pipeline) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Pipeline) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Pipeline) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Pipeline) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Pipeline) GetDestinations() []*Pipeline_Destination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

func (x *Pipeline) GetMediations() []*Pipeline_Mediation {
	if x != nil {
		return x.Mediations
	}
	return nil
}

func (x *Pipeline) GetCryptoKeyName() string {
	if x != nil {
		return x.CryptoKeyName
	}
	return ""
}

func (x *Pipeline) GetInputPayloadFormat() *Pipeline_MessagePayloadFormat {
	if x != nil {
		return x.InputPayloadFormat
	}
	return nil
}

func (x *Pipeline) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *Pipeline) GetRetryPolicy() *Pipeline_RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

func (x *Pipeline) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Represents the format of message data.
type Pipeline_MessagePayloadFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of message format.
	// One of Protobuf, Avro, and JSON supported.
	// This allows specification of what specific format
	// messages are sent and received.
	//
	// Types that are assignable to Kind:
	//
	//	*Pipeline_MessagePayloadFormat_Protobuf
	//	*Pipeline_MessagePayloadFormat_Avro
	//	*Pipeline_MessagePayloadFormat_Json
	Kind isPipeline_MessagePayloadFormat_Kind `protobuf_oneof:"kind"`
}

func (x *Pipeline_MessagePayloadFormat) Reset() {
	*x = Pipeline_MessagePayloadFormat{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_MessagePayloadFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_MessagePayloadFormat) ProtoMessage() {}

func (x *Pipeline_MessagePayloadFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_MessagePayloadFormat.ProtoReflect.Descriptor instead.
func (*Pipeline_MessagePayloadFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 0}
}

func (m *Pipeline_MessagePayloadFormat) GetKind() isPipeline_MessagePayloadFormat_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Pipeline_MessagePayloadFormat) GetProtobuf() *Pipeline_MessagePayloadFormat_ProtobufFormat {
	if x, ok := x.GetKind().(*Pipeline_MessagePayloadFormat_Protobuf); ok {
		return x.Protobuf
	}
	return nil
}

func (x *Pipeline_MessagePayloadFormat) GetAvro() *Pipeline_MessagePayloadFormat_AvroFormat {
	if x, ok := x.GetKind().(*Pipeline_MessagePayloadFormat_Avro); ok {
		return x.Avro
	}
	return nil
}

func (x *Pipeline_MessagePayloadFormat) GetJson() *Pipeline_MessagePayloadFormat_JsonFormat {
	if x, ok := x.GetKind().(*Pipeline_MessagePayloadFormat_Json); ok {
		return x.Json
	}
	return nil
}

type isPipeline_MessagePayloadFormat_Kind interface {
	isPipeline_MessagePayloadFormat_Kind()
}

type Pipeline_MessagePayloadFormat_Protobuf struct {
	// Optional. Protobuf format.
	Protobuf *Pipeline_MessagePayloadFormat_ProtobufFormat `protobuf:"bytes,1,opt,name=protobuf,proto3,oneof"`
}

type Pipeline_MessagePayloadFormat_Avro struct {
	// Optional. Avro format.
	Avro *Pipeline_MessagePayloadFormat_AvroFormat `protobuf:"bytes,2,opt,name=avro,proto3,oneof"`
}

type Pipeline_MessagePayloadFormat_Json struct {
	// Optional. JSON format.
	Json *Pipeline_MessagePayloadFormat_JsonFormat `protobuf:"bytes,3,opt,name=json,proto3,oneof"`
}

func (*Pipeline_MessagePayloadFormat_Protobuf) isPipeline_MessagePayloadFormat_Kind() {}

func (*Pipeline_MessagePayloadFormat_Avro) isPipeline_MessagePayloadFormat_Kind() {}

func (*Pipeline_MessagePayloadFormat_Json) isPipeline_MessagePayloadFormat_Kind() {}

// Represents a target of an invocation over HTTP.
type Pipeline_Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Network config is used to configure how Pipeline resolves and
	// connects to a destination.
	NetworkConfig *Pipeline_Destination_NetworkConfig `protobuf:"bytes,1,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// The destination identifier to which the request should be routed to.
	//
	// Types that are assignable to DestinationDescriptor:
	//
	//	*Pipeline_Destination_HttpEndpoint_
	//	*Pipeline_Destination_Workflow
	//	*Pipeline_Destination_MessageBus
	//	*Pipeline_Destination_Topic
	DestinationDescriptor isPipeline_Destination_DestinationDescriptor `protobuf_oneof:"destination_descriptor"`
	// Optional. An authentication config used to authenticate message requests,
	// such that destinations can verify the source. For example, this can be
	// used with private GCP destinations that require GCP credentials to access
	// like Cloud Run. This field is optional and should be set only by users
	// interested in authenticated push
	AuthenticationConfig *Pipeline_Destination_AuthenticationConfig `protobuf:"bytes,5,opt,name=authentication_config,json=authenticationConfig,proto3" json:"authentication_config,omitempty"`
	// Optional. The message format before it is delivered to the destination.
	// If not set, the message will be delivered in the format it was originally
	// delivered to the Pipeline. This field can only be set if
	// Pipeline.input_payload_format is also set.
	OutputPayloadFormat *Pipeline_MessagePayloadFormat `protobuf:"bytes,6,opt,name=output_payload_format,json=outputPayloadFormat,proto3" json:"output_payload_format,omitempty"`
}

func (x *Pipeline_Destination) Reset() {
	*x = Pipeline_Destination{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_Destination) ProtoMessage() {}

func (x *Pipeline_Destination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_Destination.ProtoReflect.Descriptor instead.
func (*Pipeline_Destination) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Pipeline_Destination) GetNetworkConfig() *Pipeline_Destination_NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

func (m *Pipeline_Destination) GetDestinationDescriptor() isPipeline_Destination_DestinationDescriptor {
	if m != nil {
		return m.DestinationDescriptor
	}
	return nil
}

func (x *Pipeline_Destination) GetHttpEndpoint() *Pipeline_Destination_HttpEndpoint {
	if x, ok := x.GetDestinationDescriptor().(*Pipeline_Destination_HttpEndpoint_); ok {
		return x.HttpEndpoint
	}
	return nil
}

func (x *Pipeline_Destination) GetWorkflow() string {
	if x, ok := x.GetDestinationDescriptor().(*Pipeline_Destination_Workflow); ok {
		return x.Workflow
	}
	return ""
}

func (x *Pipeline_Destination) GetMessageBus() string {
	if x, ok := x.GetDestinationDescriptor().(*Pipeline_Destination_MessageBus); ok {
		return x.MessageBus
	}
	return ""
}

func (x *Pipeline_Destination) GetTopic() string {
	if x, ok := x.GetDestinationDescriptor().(*Pipeline_Destination_Topic); ok {
		return x.Topic
	}
	return ""
}

func (x *Pipeline_Destination) GetAuthenticationConfig() *Pipeline_Destination_AuthenticationConfig {
	if x != nil {
		return x.AuthenticationConfig
	}
	return nil
}

func (x *Pipeline_Destination) GetOutputPayloadFormat() *Pipeline_MessagePayloadFormat {
	if x != nil {
		return x.OutputPayloadFormat
	}
	return nil
}

type isPipeline_Destination_DestinationDescriptor interface {
	isPipeline_Destination_DestinationDescriptor()
}

type Pipeline_Destination_HttpEndpoint_ struct {
	// Optional. An HTTP endpoint destination described by an URI.
	// If a DNS FQDN is provided as the endpoint, Pipeline will create a
	// peering zone to the consumer VPC and forward DNS requests to the VPC
	// specified by network config to resolve the service endpoint. See:
	// https://cloud.google.com/dns/docs/zones/zones-overview#peering_zones
	HttpEndpoint *Pipeline_Destination_HttpEndpoint `protobuf:"bytes,2,opt,name=http_endpoint,json=httpEndpoint,proto3,oneof"`
}

type Pipeline_Destination_Workflow struct {
	// Optional. The resource name of the Workflow whose Executions are
	// triggered by the events. The Workflow resource should be deployed in
	// the same project as the Pipeline. Format:
	// `projects/{project}/locations/{location}/workflows/{workflow}`
	Workflow string `protobuf:"bytes,3,opt,name=workflow,proto3,oneof"`
}

type Pipeline_Destination_MessageBus struct {
	// Optional. The resource name of the Message Bus to which events should
	// be published. The Message Bus resource should exist in the same project
	// as the Pipeline. Format:
	// `projects/{project}/locations/{location}/messageBuses/{message_bus}`
	MessageBus string `protobuf:"bytes,4,opt,name=message_bus,json=messageBus,proto3,oneof"`
}

type Pipeline_Destination_Topic struct {
	// Optional. The resource name of the Pub/Sub topic to which events should
	// be published. Format:
	// `projects/{project}/locations/{location}/topics/{topic}`
	Topic string `protobuf:"bytes,8,opt,name=topic,proto3,oneof"`
}

func (*Pipeline_Destination_HttpEndpoint_) isPipeline_Destination_DestinationDescriptor() {}

func (*Pipeline_Destination_Workflow) isPipeline_Destination_DestinationDescriptor() {}

func (*Pipeline_Destination_MessageBus) isPipeline_Destination_DestinationDescriptor() {}

func (*Pipeline_Destination_Topic) isPipeline_Destination_DestinationDescriptor() {}

// Mediation defines different ways to modify the Pipeline.
type Pipeline_Mediation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The config of mediation.
	//
	// Types that are assignable to MediationDescriptor:
	//
	//	*Pipeline_Mediation_Transformation_
	MediationDescriptor isPipeline_Mediation_MediationDescriptor `protobuf_oneof:"mediation_descriptor"`
}

func (x *Pipeline_Mediation) Reset() {
	*x = Pipeline_Mediation{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_Mediation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_Mediation) ProtoMessage() {}

func (x *Pipeline_Mediation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_Mediation.ProtoReflect.Descriptor instead.
func (*Pipeline_Mediation) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 2}
}

func (m *Pipeline_Mediation) GetMediationDescriptor() isPipeline_Mediation_MediationDescriptor {
	if m != nil {
		return m.MediationDescriptor
	}
	return nil
}

func (x *Pipeline_Mediation) GetTransformation() *Pipeline_Mediation_Transformation {
	if x, ok := x.GetMediationDescriptor().(*Pipeline_Mediation_Transformation_); ok {
		return x.Transformation
	}
	return nil
}

type isPipeline_Mediation_MediationDescriptor interface {
	isPipeline_Mediation_MediationDescriptor()
}

type Pipeline_Mediation_Transformation_ struct {
	// Optional. How the Pipeline is to transform messages
	Transformation *Pipeline_Mediation_Transformation `protobuf:"bytes,1,opt,name=transformation,proto3,oneof"`
}

func (*Pipeline_Mediation_Transformation_) isPipeline_Mediation_MediationDescriptor() {}

// The retry policy configuration for the Pipeline. The pipeline
// exponentially backs off in case the destination is non responsive or
// returns a retryable error code. The default semantics are as follows:
// The backoff starts with a 5 second delay and doubles the
// delay after each failed attempt (10 seconds, 20 seconds, 40 seconds, etc.).
// The delay is capped at 60 seconds by default.
// Please note that if you set the min_retry_delay and max_retry_delay fields
// to the same value this will make the duration between retries constant.
type Pipeline_RetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maximum number of delivery attempts for any message. The
	// value must be between 1 and 100. The default value for this field is 5.
	MaxAttempts int32 `protobuf:"varint,1,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// Optional. The minimum amount of seconds to wait between retry attempts.
	// The value must be between 1 and 600. The default value for this field
	// is 5.
	MinRetryDelay *durationpb.Duration `protobuf:"bytes,2,opt,name=min_retry_delay,json=minRetryDelay,proto3" json:"min_retry_delay,omitempty"`
	// Optional. The maximum amount of seconds to wait between retry attempts.
	// The value must be between 1 and 600. The default value for this field
	// is 60.
	MaxRetryDelay *durationpb.Duration `protobuf:"bytes,3,opt,name=max_retry_delay,json=maxRetryDelay,proto3" json:"max_retry_delay,omitempty"`
}

func (x *Pipeline_RetryPolicy) Reset() {
	*x = Pipeline_RetryPolicy{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_RetryPolicy) ProtoMessage() {}

func (x *Pipeline_RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_RetryPolicy.ProtoReflect.Descriptor instead.
func (*Pipeline_RetryPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Pipeline_RetryPolicy) GetMaxAttempts() int32 {
	if x != nil {
		return x.MaxAttempts
	}
	return 0
}

func (x *Pipeline_RetryPolicy) GetMinRetryDelay() *durationpb.Duration {
	if x != nil {
		return x.MinRetryDelay
	}
	return nil
}

func (x *Pipeline_RetryPolicy) GetMaxRetryDelay() *durationpb.Duration {
	if x != nil {
		return x.MaxRetryDelay
	}
	return nil
}

// The format of a JSON message payload.
type Pipeline_MessagePayloadFormat_JsonFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Pipeline_MessagePayloadFormat_JsonFormat) Reset() {
	*x = Pipeline_MessagePayloadFormat_JsonFormat{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_MessagePayloadFormat_JsonFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_MessagePayloadFormat_JsonFormat) ProtoMessage() {}

func (x *Pipeline_MessagePayloadFormat_JsonFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_MessagePayloadFormat_JsonFormat.ProtoReflect.Descriptor instead.
func (*Pipeline_MessagePayloadFormat_JsonFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 0, 0}
}

// The format of a Protobuf message payload.
type Pipeline_MessagePayloadFormat_ProtobufFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The entire schema definition is stored in this field.
	SchemaDefinition string `protobuf:"bytes,1,opt,name=schema_definition,json=schemaDefinition,proto3" json:"schema_definition,omitempty"`
}

func (x *Pipeline_MessagePayloadFormat_ProtobufFormat) Reset() {
	*x = Pipeline_MessagePayloadFormat_ProtobufFormat{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_MessagePayloadFormat_ProtobufFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_MessagePayloadFormat_ProtobufFormat) ProtoMessage() {}

func (x *Pipeline_MessagePayloadFormat_ProtobufFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_MessagePayloadFormat_ProtobufFormat.ProtoReflect.Descriptor instead.
func (*Pipeline_MessagePayloadFormat_ProtobufFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *Pipeline_MessagePayloadFormat_ProtobufFormat) GetSchemaDefinition() string {
	if x != nil {
		return x.SchemaDefinition
	}
	return ""
}

// The format of an AVRO message payload.
type Pipeline_MessagePayloadFormat_AvroFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The entire schema definition is stored in this field.
	SchemaDefinition string `protobuf:"bytes,1,opt,name=schema_definition,json=schemaDefinition,proto3" json:"schema_definition,omitempty"`
}

func (x *Pipeline_MessagePayloadFormat_AvroFormat) Reset() {
	*x = Pipeline_MessagePayloadFormat_AvroFormat{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_MessagePayloadFormat_AvroFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_MessagePayloadFormat_AvroFormat) ProtoMessage() {}

func (x *Pipeline_MessagePayloadFormat_AvroFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_MessagePayloadFormat_AvroFormat.ProtoReflect.Descriptor instead.
func (*Pipeline_MessagePayloadFormat_AvroFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 0, 2}
}

func (x *Pipeline_MessagePayloadFormat_AvroFormat) GetSchemaDefinition() string {
	if x != nil {
		return x.SchemaDefinition
	}
	return ""
}

// Represents a network config to be used for destination resolution and
// connectivity.
type Pipeline_Destination_NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the NetworkAttachment that allows access to the
	// consumer VPC. Format:
	// `projects/{PROJECT_ID}/regions/{REGION}/networkAttachments/{NETWORK_ATTACHMENT_NAME}`
	NetworkAttachment string `protobuf:"bytes,1,opt,name=network_attachment,json=networkAttachment,proto3" json:"network_attachment,omitempty"`
}

func (x *Pipeline_Destination_NetworkConfig) Reset() {
	*x = Pipeline_Destination_NetworkConfig{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_Destination_NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_Destination_NetworkConfig) ProtoMessage() {}

func (x *Pipeline_Destination_NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_Destination_NetworkConfig.ProtoReflect.Descriptor instead.
func (*Pipeline_Destination_NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Pipeline_Destination_NetworkConfig) GetNetworkAttachment() string {
	if x != nil {
		return x.NetworkAttachment
	}
	return ""
}

// Represents a HTTP endpoint destination.
type Pipeline_Destination_HttpEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI of the HTTP enpdoint.
	//
	// The value must be a RFC2396 URI string.
	// Examples: `https://svc.us-central1.p.local:8080/route`.
	// Only the HTTPS protocol is supported.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. The CEL expression used to modify how the destination-bound
	// HTTP request is constructed.
	//
	// If a binding expression is not specified here, the message
	// is treated as a CloudEvent and is mapped to the HTTP request according
	// to the CloudEvent HTTP Protocol Binding Binary Content Mode. In this
	// representation, all fields except the `data` and `datacontenttype`
	// field on the message are mapped to HTTP request headers with a prefix
	// of `ce-`.
	//
	// To construct the HTTP request payload and the value of the content-type
	// HTTP header, the payload format is defined as follows:
	//  1. Use the output_payload_format_type on the Pipeline.Destination if it
	//     is set, else:
	//  2. Use the input_payload_format_type on the Pipeline if it is set,
	//     else:
	//  3. Treat the payload as opaque binary data.
	//
	// The `data` field of the message is converted to the payload format or
	// left as-is for case 3) and then attached as the payload of the HTTP
	// request. The `content-type` header on the HTTP request is set to the
	// payload format type or left empty for case 3). However, if a mediation
	// has updated the `datacontenttype` field on the message so that it is
	// not the same as the payload format type but it is still a prefix of the
	// payload format type, then the `content-type` header on the HTTP request
	// is set to this `datacontenttype` value. For example, if the
	// `datacontenttype` is "application/json" and the payload format type is
	// "application/json; charset=utf-8", then the `content-type` header on
	// the HTTP request is set to "application/json; charset=utf-8".
	//
	// If a non-empty binding expression is specified then this expression is
	// used to modify the default CloudEvent HTTP Protocol Binding Binary
	// Content representation.
	// The result of the CEL expression must be a map of key/value pairs
	// which is used as follows:
	// - If a map named `headers` exists on the result of the expression,
	// then its key/value pairs are directly mapped to the HTTP request
	// headers. The headers values are constructed from the corresponding
	// value type’s canonical representation. If the `headers` field doesn’t
	// exist then the resulting HTTP request will be the headers of the
	// CloudEvent HTTP Binding Binary Content Mode representation of the final
	// message. Note: If the specified binding expression, has updated the
	// `datacontenttype` field on the message so that it is not the same as
	// the payload format type but it is still a prefix of the payload format
	// type, then the `content-type` header in the `headers` map is set to
	// this `datacontenttype` value.
	// - If a field named `body` exists on the result of the expression then
	// its value is directly mapped to the body of the request. If the value
	// of the `body` field is of type bytes or string then it is used for
	// the HTTP request body as-is, with no conversion. If the body field is
	// of any other type then it is converted to a JSON string. If the body
	// field does not exist then the resulting payload of the HTTP request
	// will be data value of the CloudEvent HTTP Binding Binary Content Mode
	// representation of the final message as described earlier.
	// - Any other fields in the resulting expression will be ignored.
	//
	// The CEL expression may access the incoming CloudEvent message in its
	// definition, as follows:
	// - The `data` field of the incoming CloudEvent message can be accessed
	// using the `message.data` value. Subfields of `message.data` may also be
	// accessed if an input_payload_format has been specified on the Pipeline.
	// - Each attribute of the incoming CloudEvent message can be accessed
	// using the `message.<key>` value, where <key> is replaced with the
	// name of the attribute.
	// - Existing headers can be accessed in the CEL expression using the
	// `headers` variable. The `headers` variable defines a map of key/value
	// pairs corresponding to the HTTP headers of the CloudEvent HTTP Binding
	// Binary Content Mode representation of the final message as described
	// earlier. For example, the following CEL expression can be used to
	// construct an HTTP request by adding an additional header to the HTTP
	// headers of the CloudEvent HTTP Binding Binary Content Mode
	// representation of the final message and by overwriting the body of the
	// request:
	//
	// ```
	//
	//	{
	//	  "headers": headers.merge({"new-header-key": "new-header-value"}),
	//	  "body": "new-body"
	//	}
	//
	// ```
	//
	// Additionally, the following CEL extension functions are provided for
	// use in this CEL expression:
	//   - toBase64Url:
	//     map.toBase64Url() -> string
	//   - Converts a CelValue to a base64url encoded string
	//   - toJsonString: map.toJsonString() -> string
	//   - Converts a CelValue to a JSON string
	//   - merge:
	//     map1.merge(map2) -> map3
	//   - Merges the passed CEL map with the existing CEL map the
	//     function is applied to.
	//   - If the same key exists in both maps, if the key's value is type
	//     map both maps are merged else the value from the passed map is
	//     used.
	//   - denormalize:
	//     map.denormalize() -> map
	//   - Denormalizes a CEL map such that every value of type map or key
	//     in the map is expanded to return a single level map.
	//   - The resulting keys are "." separated indices of the map keys.
	//   - For example:
	//     {
	//     "a": 1,
	//     "b": {
	//     "c": 2,
	//     "d": 3
	//     }
	//     "e": [4, 5]
	//     }
	//     .denormalize()
	//     -> {
	//     "a": 1,
	//     "b.c": 2,
	//     "b.d": 3,
	//     "e.0": 4,
	//     "e.1": 5
	//     }
	//   - setField:
	//     map.setField(key, value) -> message
	//   - Sets the field of the message with the given key to the
	//     given value.
	//   - If the field is not present it will be added.
	//   - If the field is present it will be overwritten.
	//   - The key can be a dot separated path to set a field in a nested
	//     message.
	//   - Key must be of type string.
	//   - Value may be any valid type.
	//   - removeFields:
	//     map.removeFields([key1, key2, ...]) -> message
	//   - Removes the fields of the map with the given keys.
	//   - The keys can be a dot separated path to remove a field in a
	//     nested message.
	//   - If a key is not found it will be ignored.
	//   - Keys must be of type string.
	//   - toMap:
	//     [map1, map2, ...].toMap() -> map
	//   - Converts a CEL list of CEL maps to a single CEL map
	//   - toDestinationPayloadFormat():
	//     message.data.toDestinationPayloadFormat() -> string or bytes
	//   - Converts the message data to the destination payload format
	//     specified in Pipeline.Destination.output_payload_format
	//   - This function is meant to be applied to the message.data field.
	//   - If the destination payload format is not set, the function will
	//     return the message data unchanged.
	//   - toCloudEventJsonWithPayloadFormat:
	//     message.toCloudEventJsonWithPayloadFormat() -> map
	//   - Converts a message to the corresponding structure of JSON
	//     format for CloudEvents
	//   - This function applies toDestinationPayloadFormat() to the
	//     message data. It also sets the corresponding datacontenttype of
	//     the CloudEvent, as indicated by
	//     Pipeline.Destination.output_payload_format. If no
	//     output_payload_format is set it will use the existing
	//     datacontenttype on the CloudEvent if present, else leave
	//     datacontenttype absent.
	//   - This function expects that the content of the message will
	//     adhere to the standard CloudEvent format. If it doesn’t then this
	//     function will fail.
	//   - The result is a CEL map that corresponds to the JSON
	//     representation of the CloudEvent. To convert that data to a JSON
	//     string it can be chained with the toJsonString function.
	//
	// The Pipeline expects that the message it receives adheres to the
	// standard CloudEvent format. If it doesn’t then the outgoing message
	// request may fail with a persistent error.
	MessageBindingTemplate string `protobuf:"bytes,3,opt,name=message_binding_template,json=messageBindingTemplate,proto3" json:"message_binding_template,omitempty"`
}

func (x *Pipeline_Destination_HttpEndpoint) Reset() {
	*x = Pipeline_Destination_HttpEndpoint{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_Destination_HttpEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_Destination_HttpEndpoint) ProtoMessage() {}

func (x *Pipeline_Destination_HttpEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_Destination_HttpEndpoint.ProtoReflect.Descriptor instead.
func (*Pipeline_Destination_HttpEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *Pipeline_Destination_HttpEndpoint) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Pipeline_Destination_HttpEndpoint) GetMessageBindingTemplate() string {
	if x != nil {
		return x.MessageBindingTemplate
	}
	return ""
}

// Represents a config used to authenticate message requests.
type Pipeline_Destination_AuthenticationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of authentication method.
	//
	// Types that are assignable to AuthenticationMethodDescriptor:
	//
	//	*Pipeline_Destination_AuthenticationConfig_GoogleOidc
	//	*Pipeline_Destination_AuthenticationConfig_OauthToken
	AuthenticationMethodDescriptor isPipeline_Destination_AuthenticationConfig_AuthenticationMethodDescriptor `protobuf_oneof:"authentication_method_descriptor"`
}

func (x *Pipeline_Destination_AuthenticationConfig) Reset() {
	*x = Pipeline_Destination_AuthenticationConfig{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_Destination_AuthenticationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_Destination_AuthenticationConfig) ProtoMessage() {}

func (x *Pipeline_Destination_AuthenticationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_Destination_AuthenticationConfig.ProtoReflect.Descriptor instead.
func (*Pipeline_Destination_AuthenticationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 1, 2}
}

func (m *Pipeline_Destination_AuthenticationConfig) GetAuthenticationMethodDescriptor() isPipeline_Destination_AuthenticationConfig_AuthenticationMethodDescriptor {
	if m != nil {
		return m.AuthenticationMethodDescriptor
	}
	return nil
}

func (x *Pipeline_Destination_AuthenticationConfig) GetGoogleOidc() *Pipeline_Destination_AuthenticationConfig_OidcToken {
	if x, ok := x.GetAuthenticationMethodDescriptor().(*Pipeline_Destination_AuthenticationConfig_GoogleOidc); ok {
		return x.GoogleOidc
	}
	return nil
}

func (x *Pipeline_Destination_AuthenticationConfig) GetOauthToken() *Pipeline_Destination_AuthenticationConfig_OAuthToken {
	if x, ok := x.GetAuthenticationMethodDescriptor().(*Pipeline_Destination_AuthenticationConfig_OauthToken); ok {
		return x.OauthToken
	}
	return nil
}

type isPipeline_Destination_AuthenticationConfig_AuthenticationMethodDescriptor interface {
	isPipeline_Destination_AuthenticationConfig_AuthenticationMethodDescriptor()
}

type Pipeline_Destination_AuthenticationConfig_GoogleOidc struct {
	// Optional. This authenticate method will apply Google OIDC tokens
	// signed by a GCP service account to the requests.
	GoogleOidc *Pipeline_Destination_AuthenticationConfig_OidcToken `protobuf:"bytes,1,opt,name=google_oidc,json=googleOidc,proto3,oneof"`
}

type Pipeline_Destination_AuthenticationConfig_OauthToken struct {
	// Optional. If specified, an [OAuth
	// token](https://developers.google.com/identity/protocols/OAuth2) will
	// be generated and attached as an `Authorization` header in the HTTP
	// request.
	//
	// This type of authorization should generally only be used when calling
	// Google APIs hosted on *.googleapis.com.
	OauthToken *Pipeline_Destination_AuthenticationConfig_OAuthToken `protobuf:"bytes,2,opt,name=oauth_token,json=oauthToken,proto3,oneof"`
}

func (*Pipeline_Destination_AuthenticationConfig_GoogleOidc) isPipeline_Destination_AuthenticationConfig_AuthenticationMethodDescriptor() {
}

func (*Pipeline_Destination_AuthenticationConfig_OauthToken) isPipeline_Destination_AuthenticationConfig_AuthenticationMethodDescriptor() {
}

// Represents a config used to authenticate with a Google OIDC token using
// a GCP service account. Use this authentication method to invoke your
// Cloud Run and Cloud Functions destinations or HTTP endpoints that
// support Google OIDC.
type Pipeline_Destination_AuthenticationConfig_OidcToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Service account email used to generate the OIDC Token.
	// The principal who calls this API must have
	// iam.serviceAccounts.actAs permission in the service account. See
	// https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common
	// for more information. Eventarc service agents must have
	// roles/roles/iam.serviceAccountTokenCreator role to allow the
	// Pipeline to create OpenID tokens for authenticated requests.
	ServiceAccount string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Audience to be used to generate the OIDC Token. The
	// audience claim identifies the recipient that the JWT is intended for.
	// If unspecified, the destination URI will be used.
	Audience string `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *Pipeline_Destination_AuthenticationConfig_OidcToken) Reset() {
	*x = Pipeline_Destination_AuthenticationConfig_OidcToken{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_Destination_AuthenticationConfig_OidcToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_Destination_AuthenticationConfig_OidcToken) ProtoMessage() {}

func (x *Pipeline_Destination_AuthenticationConfig_OidcToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_Destination_AuthenticationConfig_OidcToken.ProtoReflect.Descriptor instead.
func (*Pipeline_Destination_AuthenticationConfig_OidcToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 1, 2, 0}
}

func (x *Pipeline_Destination_AuthenticationConfig_OidcToken) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Pipeline_Destination_AuthenticationConfig_OidcToken) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

// Contains information needed for generating an
// [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
// This type of authorization should generally only be used when calling
// Google APIs hosted on *.googleapis.com.
type Pipeline_Destination_AuthenticationConfig_OAuthToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Service account email used to generate the [OAuth
	// token](https://developers.google.com/identity/protocols/OAuth2).
	// The principal who calls this API must have
	// iam.serviceAccounts.actAs permission in the service account. See
	// https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common
	// for more information. Eventarc service agents must have
	// roles/roles/iam.serviceAccountTokenCreator role to allow Pipeline
	// to create OAuth2 tokens for authenticated requests.
	ServiceAccount string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. OAuth scope to be used for generating OAuth access token.
	// If not specified, "https://www.googleapis.com/auth/cloud-platform"
	// will be used.
	Scope string `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
}

func (x *Pipeline_Destination_AuthenticationConfig_OAuthToken) Reset() {
	*x = Pipeline_Destination_AuthenticationConfig_OAuthToken{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_Destination_AuthenticationConfig_OAuthToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_Destination_AuthenticationConfig_OAuthToken) ProtoMessage() {}

func (x *Pipeline_Destination_AuthenticationConfig_OAuthToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_Destination_AuthenticationConfig_OAuthToken.ProtoReflect.Descriptor instead.
func (*Pipeline_Destination_AuthenticationConfig_OAuthToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 1, 2, 1}
}

func (x *Pipeline_Destination_AuthenticationConfig_OAuthToken) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Pipeline_Destination_AuthenticationConfig_OAuthToken) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

// Transformation defines the way to transform an incoming message.
type Pipeline_Mediation_Transformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The CEL expression template to apply to transform messages.
	// The following CEL extension functions are provided for
	// use in this CEL expression:
	//   - merge:
	//     map1.merge(map2) -> map3
	//   - Merges the passed CEL map with the existing CEL map the
	//     function is applied to.
	//   - If the same key exists in both maps, if the key's value is type
	//     map both maps are merged else the value from the passed map is
	//     used.
	//   - denormalize:
	//     map.denormalize() -> map
	//   - Denormalizes a CEL map such that every value of type map or key
	//     in the map is expanded to return a single level map.
	//   - The resulting keys are "." separated indices of the map keys.
	//   - For example:
	//     {
	//     "a": 1,
	//     "b": {
	//     "c": 2,
	//     "d": 3
	//     }
	//     "e": [4, 5]
	//     }
	//     .denormalize()
	//     -> {
	//     "a": 1,
	//     "b.c": 2,
	//     "b.d": 3,
	//     "e.0": 4,
	//     "e.1": 5
	//     }
	//   - setField:
	//     map.setField(key, value) -> message
	//   - Sets the field of the message with the given key to the
	//     given value.
	//   - If the field is not present it will be added.
	//   - If the field is present it will be overwritten.
	//   - The key can be a dot separated path to set a field in a nested
	//     message.
	//   - Key must be of type string.
	//   - Value may be any valid type.
	//   - removeFields:
	//     map.removeFields([key1, key2, ...]) -> message
	//   - Removes the fields of the map with the given keys.
	//   - The keys can be a dot separated path to remove a field in a
	//     nested message.
	//   - If a key is not found it will be ignored.
	//   - Keys must be of type string.
	//   - toMap:
	//     [map1, map2, ...].toMap() -> map
	//   - Converts a CEL list of CEL maps to a single CEL map
	//   - toDestinationPayloadFormat():
	//     message.data.toDestinationPayloadFormat() -> string or bytes
	//   - Converts the message data to the destination payload format
	//     specified in Pipeline.Destination.output_payload_format
	//   - This function is meant to be applied to the message.data field.
	//   - If the destination payload format is not set, the function will
	//     return the message data unchanged.
	//   - toCloudEventJsonWithPayloadFormat:
	//     message.toCloudEventJsonWithPayloadFormat() -> map
	//   - Converts a message to the corresponding structure of JSON
	//     format for CloudEvents
	//   - This function applies toDestinationPayloadFormat() to the
	//     message data. It also sets the corresponding datacontenttype of
	//     the CloudEvent, as indicated by
	//     Pipeline.Destination.output_payload_format. If no
	//     output_payload_format is set it will use the existing
	//     datacontenttype on the CloudEvent if present, else leave
	//     datacontenttype absent.
	//   - This function expects that the content of the message will
	//     adhere to the standard CloudEvent format. If it doesn’t then this
	//     function will fail.
	//   - The result is a CEL map that corresponds to the JSON
	//     representation of the CloudEvent. To convert that data to a JSON
	//     string it can be chained with the toJsonString function.
	TransformationTemplate string `protobuf:"bytes,1,opt,name=transformation_template,json=transformationTemplate,proto3" json:"transformation_template,omitempty"`
}

func (x *Pipeline_Mediation_Transformation) Reset() {
	*x = Pipeline_Mediation_Transformation{}
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pipeline_Mediation_Transformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline_Mediation_Transformation) ProtoMessage() {}

func (x *Pipeline_Mediation_Transformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline_Mediation_Transformation.ProtoReflect.Descriptor instead.
func (*Pipeline_Mediation_Transformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Pipeline_Mediation_Transformation) GetTransformationTemplate() string {
	if x != nil {
		return x.TransformationTemplate
	}
	return ""
}

var File_google_cloud_eventarc_v1_pipeline_proto protoreflect.FileDescriptor

var file_google_cloud_eventarc_v1_pipeline_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x61, 0x72, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x89, 0x1c, 0x0a,
	0x08, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x5a, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x51, 0x0a, 0x0a, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x51, 0x0a, 0x0f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0d, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6e, 0x0a, 0x14, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x53, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0c, 0x72, 0x65,
	0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x63, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x1a, 0xd9, 0x03, 0x0a, 0x14, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12,
	0x69, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x12, 0x5d, 0x0a, 0x04, 0x61, 0x76,
	0x72, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x2e, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x04, 0x61, 0x76, 0x72, 0x6f, 0x12, 0x5d, 0x0a, 0x04, 0x6a, 0x73, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x04, 0x6a, 0x73, 0x6f, 0x6e, 0x1a, 0x0c, 0x0a, 0x0a, 0x4a, 0x73, 0x6f, 0x6e,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x1a, 0x42, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x3e, 0x0a, 0x0a, 0x41, 0x76,
	0x72, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x1a, 0xc4, 0x0b, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61,
	0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x0d,
	0x68, 0x74, 0x74, 0x70, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x48, 0x00, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x4d,
	0x0a, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x75, 0x73, 0x48,
	0x00, 0x52, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x75, 0x73, 0x12, 0x3b, 0x0a,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41,
	0x01, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x48, 0x00, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x7d, 0x0a, 0x15, 0x61, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x15, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x1a, 0x70, 0x0a, 0x0d, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x12,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x64, 0x0a,
	0x0c, 0x48, 0x74, 0x74, 0x70, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x12, 0x3d, 0x0a, 0x18, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x1a, 0xa9, 0x04, 0x0a, 0x14, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x0b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x6f, 0x69, 0x64, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x4f,
	0x69, 0x64, 0x63, 0x12, 0x76, 0x0a, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x41,
	0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x0a, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x80, 0x01, 0x0a, 0x09,
	0x4f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x52, 0x0a, 0x0f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a,
	0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x7b,
	0x0a, 0x0a, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x52, 0x0a, 0x0f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69,
	0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x42, 0x22, 0x0a, 0x20, 0x61,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x42,
	0x18, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x1a, 0xdf, 0x01, 0x0a, 0x09, 0x4d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x4e, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x1a, 0xc5, 0x01, 0x0a, 0x0b,
	0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x6d,
	0x61, 0x78, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x41, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x73, 0x12, 0x46, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x79,
	0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6d, 0x69,
	0x6e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x46, 0x0a, 0x0f, 0x6d,
	0x61, 0x78, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x74, 0x72, 0x79, 0x44, 0x65,
	0x6c, 0x61, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e,
	0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x78,
	0xea, 0x41, 0x75, 0x0a, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x7d, 0x2a, 0x09, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x32, 0x08,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x80, 0x02, 0xea, 0x41, 0x40, 0x0a, 0x1b,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x21, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x7d, 0x0a, 0x1c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x70, 0x62, 0x3b, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x61, 0x72, 0x63, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_eventarc_v1_pipeline_proto_rawDescOnce sync.Once
	file_google_cloud_eventarc_v1_pipeline_proto_rawDescData = file_google_cloud_eventarc_v1_pipeline_proto_rawDesc
)

func file_google_cloud_eventarc_v1_pipeline_proto_rawDescGZIP() []byte {
	file_google_cloud_eventarc_v1_pipeline_proto_rawDescOnce.Do(func() {
		file_google_cloud_eventarc_v1_pipeline_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_eventarc_v1_pipeline_proto_rawDescData)
	})
	return file_google_cloud_eventarc_v1_pipeline_proto_rawDescData
}

var file_google_cloud_eventarc_v1_pipeline_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_eventarc_v1_pipeline_proto_goTypes = []any{
	(*Pipeline)(nil),                      // 0: google.cloud.eventarc.v1.Pipeline
	(*Pipeline_MessagePayloadFormat)(nil), // 1: google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat
	(*Pipeline_Destination)(nil),          // 2: google.cloud.eventarc.v1.Pipeline.Destination
	(*Pipeline_Mediation)(nil),            // 3: google.cloud.eventarc.v1.Pipeline.Mediation
	(*Pipeline_RetryPolicy)(nil),          // 4: google.cloud.eventarc.v1.Pipeline.RetryPolicy
	nil,                                   // 5: google.cloud.eventarc.v1.Pipeline.LabelsEntry
	nil,                                   // 6: google.cloud.eventarc.v1.Pipeline.AnnotationsEntry
	(*Pipeline_MessagePayloadFormat_JsonFormat)(nil),             // 7: google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.JsonFormat
	(*Pipeline_MessagePayloadFormat_ProtobufFormat)(nil),         // 8: google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.ProtobufFormat
	(*Pipeline_MessagePayloadFormat_AvroFormat)(nil),             // 9: google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.AvroFormat
	(*Pipeline_Destination_NetworkConfig)(nil),                   // 10: google.cloud.eventarc.v1.Pipeline.Destination.NetworkConfig
	(*Pipeline_Destination_HttpEndpoint)(nil),                    // 11: google.cloud.eventarc.v1.Pipeline.Destination.HttpEndpoint
	(*Pipeline_Destination_AuthenticationConfig)(nil),            // 12: google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig
	(*Pipeline_Destination_AuthenticationConfig_OidcToken)(nil),  // 13: google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig.OidcToken
	(*Pipeline_Destination_AuthenticationConfig_OAuthToken)(nil), // 14: google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig.OAuthToken
	(*Pipeline_Mediation_Transformation)(nil),                    // 15: google.cloud.eventarc.v1.Pipeline.Mediation.Transformation
	(*timestamppb.Timestamp)(nil),                                // 16: google.protobuf.Timestamp
	(*LoggingConfig)(nil),                                        // 17: google.cloud.eventarc.v1.LoggingConfig
	(*durationpb.Duration)(nil),                                  // 18: google.protobuf.Duration
}
var file_google_cloud_eventarc_v1_pipeline_proto_depIdxs = []int32{
	16, // 0: google.cloud.eventarc.v1.Pipeline.create_time:type_name -> google.protobuf.Timestamp
	16, // 1: google.cloud.eventarc.v1.Pipeline.update_time:type_name -> google.protobuf.Timestamp
	5,  // 2: google.cloud.eventarc.v1.Pipeline.labels:type_name -> google.cloud.eventarc.v1.Pipeline.LabelsEntry
	6,  // 3: google.cloud.eventarc.v1.Pipeline.annotations:type_name -> google.cloud.eventarc.v1.Pipeline.AnnotationsEntry
	2,  // 4: google.cloud.eventarc.v1.Pipeline.destinations:type_name -> google.cloud.eventarc.v1.Pipeline.Destination
	3,  // 5: google.cloud.eventarc.v1.Pipeline.mediations:type_name -> google.cloud.eventarc.v1.Pipeline.Mediation
	1,  // 6: google.cloud.eventarc.v1.Pipeline.input_payload_format:type_name -> google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat
	17, // 7: google.cloud.eventarc.v1.Pipeline.logging_config:type_name -> google.cloud.eventarc.v1.LoggingConfig
	4,  // 8: google.cloud.eventarc.v1.Pipeline.retry_policy:type_name -> google.cloud.eventarc.v1.Pipeline.RetryPolicy
	8,  // 9: google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.protobuf:type_name -> google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.ProtobufFormat
	9,  // 10: google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.avro:type_name -> google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.AvroFormat
	7,  // 11: google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.json:type_name -> google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat.JsonFormat
	10, // 12: google.cloud.eventarc.v1.Pipeline.Destination.network_config:type_name -> google.cloud.eventarc.v1.Pipeline.Destination.NetworkConfig
	11, // 13: google.cloud.eventarc.v1.Pipeline.Destination.http_endpoint:type_name -> google.cloud.eventarc.v1.Pipeline.Destination.HttpEndpoint
	12, // 14: google.cloud.eventarc.v1.Pipeline.Destination.authentication_config:type_name -> google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig
	1,  // 15: google.cloud.eventarc.v1.Pipeline.Destination.output_payload_format:type_name -> google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat
	15, // 16: google.cloud.eventarc.v1.Pipeline.Mediation.transformation:type_name -> google.cloud.eventarc.v1.Pipeline.Mediation.Transformation
	18, // 17: google.cloud.eventarc.v1.Pipeline.RetryPolicy.min_retry_delay:type_name -> google.protobuf.Duration
	18, // 18: google.cloud.eventarc.v1.Pipeline.RetryPolicy.max_retry_delay:type_name -> google.protobuf.Duration
	13, // 19: google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig.google_oidc:type_name -> google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig.OidcToken
	14, // 20: google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig.oauth_token:type_name -> google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig.OAuthToken
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_eventarc_v1_pipeline_proto_init() }
func file_google_cloud_eventarc_v1_pipeline_proto_init() {
	if File_google_cloud_eventarc_v1_pipeline_proto != nil {
		return
	}
	file_google_cloud_eventarc_v1_logging_config_proto_init()
	file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[1].OneofWrappers = []any{
		(*Pipeline_MessagePayloadFormat_Protobuf)(nil),
		(*Pipeline_MessagePayloadFormat_Avro)(nil),
		(*Pipeline_MessagePayloadFormat_Json)(nil),
	}
	file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[2].OneofWrappers = []any{
		(*Pipeline_Destination_HttpEndpoint_)(nil),
		(*Pipeline_Destination_Workflow)(nil),
		(*Pipeline_Destination_MessageBus)(nil),
		(*Pipeline_Destination_Topic)(nil),
	}
	file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[3].OneofWrappers = []any{
		(*Pipeline_Mediation_Transformation_)(nil),
	}
	file_google_cloud_eventarc_v1_pipeline_proto_msgTypes[12].OneofWrappers = []any{
		(*Pipeline_Destination_AuthenticationConfig_GoogleOidc)(nil),
		(*Pipeline_Destination_AuthenticationConfig_OauthToken)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_eventarc_v1_pipeline_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_eventarc_v1_pipeline_proto_goTypes,
		DependencyIndexes: file_google_cloud_eventarc_v1_pipeline_proto_depIdxs,
		MessageInfos:      file_google_cloud_eventarc_v1_pipeline_proto_msgTypes,
	}.Build()
	File_google_cloud_eventarc_v1_pipeline_proto = out.File
	file_google_cloud_eventarc_v1_pipeline_proto_rawDesc = nil
	file_google_cloud_eventarc_v1_pipeline_proto_goTypes = nil
	file_google_cloud_eventarc_v1_pipeline_proto_depIdxs = nil
}
