// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package migrationcenter

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	migrationcenterpb "cloud.google.com/go/migrationcenter/apiv1/migrationcenterpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListAssets            []gax.CallOption
	GetAsset              []gax.CallOption
	UpdateAsset           []gax.CallOption
	BatchUpdateAssets     []gax.CallOption
	DeleteAsset           []gax.CallOption
	BatchDeleteAssets     []gax.CallOption
	ReportAssetFrames     []gax.CallOption
	AggregateAssetsValues []gax.CallOption
	CreateImportJob       []gax.CallOption
	ListImportJobs        []gax.CallOption
	GetImportJob          []gax.CallOption
	DeleteImportJob       []gax.CallOption
	UpdateImportJob       []gax.CallOption
	ValidateImportJob     []gax.CallOption
	RunImportJob          []gax.CallOption
	GetImportDataFile     []gax.CallOption
	ListImportDataFiles   []gax.CallOption
	CreateImportDataFile  []gax.CallOption
	DeleteImportDataFile  []gax.CallOption
	ListGroups            []gax.CallOption
	GetGroup              []gax.CallOption
	CreateGroup           []gax.CallOption
	UpdateGroup           []gax.CallOption
	DeleteGroup           []gax.CallOption
	AddAssetsToGroup      []gax.CallOption
	RemoveAssetsFromGroup []gax.CallOption
	ListErrorFrames       []gax.CallOption
	GetErrorFrame         []gax.CallOption
	ListSources           []gax.CallOption
	GetSource             []gax.CallOption
	CreateSource          []gax.CallOption
	UpdateSource          []gax.CallOption
	DeleteSource          []gax.CallOption
	ListPreferenceSets    []gax.CallOption
	GetPreferenceSet      []gax.CallOption
	CreatePreferenceSet   []gax.CallOption
	UpdatePreferenceSet   []gax.CallOption
	DeletePreferenceSet   []gax.CallOption
	GetSettings           []gax.CallOption
	UpdateSettings        []gax.CallOption
	CreateReportConfig    []gax.CallOption
	GetReportConfig       []gax.CallOption
	ListReportConfigs     []gax.CallOption
	DeleteReportConfig    []gax.CallOption
	CreateReport          []gax.CallOption
	GetReport             []gax.CallOption
	ListReports           []gax.CallOption
	DeleteReport          []gax.CallOption
	GetLocation           []gax.CallOption
	ListLocations         []gax.CallOption
	CancelOperation       []gax.CallOption
	DeleteOperation       []gax.CallOption
	GetOperation          []gax.CallOption
	ListOperations        []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("migrationcenter.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("migrationcenter.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("migrationcenter.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://migrationcenter.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		BatchUpdateAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		BatchDeleteAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReportAssetFrames: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		AggregateAssetsValues: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListImportJobs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ValidateImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RunImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetImportDataFile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListImportDataFiles: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateImportDataFile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteImportDataFile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGroups: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		AddAssetsToGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RemoveAssetsFromGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListErrorFrames: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetErrorFrame: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSources: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSource: []gax.CallOption{
			gax.WithTimeout(600000 * time.Millisecond),
		},
		ListPreferenceSets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetPreferenceSet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreatePreferenceSet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdatePreferenceSet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeletePreferenceSet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetSettings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSettings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateReportConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetReportConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReportConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteReportConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReports: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		BatchUpdateAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteAsset: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		BatchDeleteAssets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReportAssetFrames: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		AggregateAssetsValues: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListImportJobs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ValidateImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RunImportJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetImportDataFile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListImportDataFiles: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateImportDataFile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteImportDataFile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGroups: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		AddAssetsToGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RemoveAssetsFromGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListErrorFrames: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetErrorFrame: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListSources: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSource: []gax.CallOption{
			gax.WithTimeout(600000 * time.Millisecond),
		},
		ListPreferenceSets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetPreferenceSet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreatePreferenceSet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdatePreferenceSet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeletePreferenceSet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetSettings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateSettings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateReportConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetReportConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReportConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteReportConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReports: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Migration Center API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListAssets(context.Context, *migrationcenterpb.ListAssetsRequest, ...gax.CallOption) *AssetIterator
	GetAsset(context.Context, *migrationcenterpb.GetAssetRequest, ...gax.CallOption) (*migrationcenterpb.Asset, error)
	UpdateAsset(context.Context, *migrationcenterpb.UpdateAssetRequest, ...gax.CallOption) (*migrationcenterpb.Asset, error)
	BatchUpdateAssets(context.Context, *migrationcenterpb.BatchUpdateAssetsRequest, ...gax.CallOption) (*migrationcenterpb.BatchUpdateAssetsResponse, error)
	DeleteAsset(context.Context, *migrationcenterpb.DeleteAssetRequest, ...gax.CallOption) error
	BatchDeleteAssets(context.Context, *migrationcenterpb.BatchDeleteAssetsRequest, ...gax.CallOption) error
	ReportAssetFrames(context.Context, *migrationcenterpb.ReportAssetFramesRequest, ...gax.CallOption) (*migrationcenterpb.ReportAssetFramesResponse, error)
	AggregateAssetsValues(context.Context, *migrationcenterpb.AggregateAssetsValuesRequest, ...gax.CallOption) (*migrationcenterpb.AggregateAssetsValuesResponse, error)
	CreateImportJob(context.Context, *migrationcenterpb.CreateImportJobRequest, ...gax.CallOption) (*CreateImportJobOperation, error)
	CreateImportJobOperation(name string) *CreateImportJobOperation
	ListImportJobs(context.Context, *migrationcenterpb.ListImportJobsRequest, ...gax.CallOption) *ImportJobIterator
	GetImportJob(context.Context, *migrationcenterpb.GetImportJobRequest, ...gax.CallOption) (*migrationcenterpb.ImportJob, error)
	DeleteImportJob(context.Context, *migrationcenterpb.DeleteImportJobRequest, ...gax.CallOption) (*DeleteImportJobOperation, error)
	DeleteImportJobOperation(name string) *DeleteImportJobOperation
	UpdateImportJob(context.Context, *migrationcenterpb.UpdateImportJobRequest, ...gax.CallOption) (*UpdateImportJobOperation, error)
	UpdateImportJobOperation(name string) *UpdateImportJobOperation
	ValidateImportJob(context.Context, *migrationcenterpb.ValidateImportJobRequest, ...gax.CallOption) (*ValidateImportJobOperation, error)
	ValidateImportJobOperation(name string) *ValidateImportJobOperation
	RunImportJob(context.Context, *migrationcenterpb.RunImportJobRequest, ...gax.CallOption) (*RunImportJobOperation, error)
	RunImportJobOperation(name string) *RunImportJobOperation
	GetImportDataFile(context.Context, *migrationcenterpb.GetImportDataFileRequest, ...gax.CallOption) (*migrationcenterpb.ImportDataFile, error)
	ListImportDataFiles(context.Context, *migrationcenterpb.ListImportDataFilesRequest, ...gax.CallOption) *ImportDataFileIterator
	CreateImportDataFile(context.Context, *migrationcenterpb.CreateImportDataFileRequest, ...gax.CallOption) (*CreateImportDataFileOperation, error)
	CreateImportDataFileOperation(name string) *CreateImportDataFileOperation
	DeleteImportDataFile(context.Context, *migrationcenterpb.DeleteImportDataFileRequest, ...gax.CallOption) (*DeleteImportDataFileOperation, error)
	DeleteImportDataFileOperation(name string) *DeleteImportDataFileOperation
	ListGroups(context.Context, *migrationcenterpb.ListGroupsRequest, ...gax.CallOption) *GroupIterator
	GetGroup(context.Context, *migrationcenterpb.GetGroupRequest, ...gax.CallOption) (*migrationcenterpb.Group, error)
	CreateGroup(context.Context, *migrationcenterpb.CreateGroupRequest, ...gax.CallOption) (*CreateGroupOperation, error)
	CreateGroupOperation(name string) *CreateGroupOperation
	UpdateGroup(context.Context, *migrationcenterpb.UpdateGroupRequest, ...gax.CallOption) (*UpdateGroupOperation, error)
	UpdateGroupOperation(name string) *UpdateGroupOperation
	DeleteGroup(context.Context, *migrationcenterpb.DeleteGroupRequest, ...gax.CallOption) (*DeleteGroupOperation, error)
	DeleteGroupOperation(name string) *DeleteGroupOperation
	AddAssetsToGroup(context.Context, *migrationcenterpb.AddAssetsToGroupRequest, ...gax.CallOption) (*AddAssetsToGroupOperation, error)
	AddAssetsToGroupOperation(name string) *AddAssetsToGroupOperation
	RemoveAssetsFromGroup(context.Context, *migrationcenterpb.RemoveAssetsFromGroupRequest, ...gax.CallOption) (*RemoveAssetsFromGroupOperation, error)
	RemoveAssetsFromGroupOperation(name string) *RemoveAssetsFromGroupOperation
	ListErrorFrames(context.Context, *migrationcenterpb.ListErrorFramesRequest, ...gax.CallOption) *ErrorFrameIterator
	GetErrorFrame(context.Context, *migrationcenterpb.GetErrorFrameRequest, ...gax.CallOption) (*migrationcenterpb.ErrorFrame, error)
	ListSources(context.Context, *migrationcenterpb.ListSourcesRequest, ...gax.CallOption) *SourceIterator
	GetSource(context.Context, *migrationcenterpb.GetSourceRequest, ...gax.CallOption) (*migrationcenterpb.Source, error)
	CreateSource(context.Context, *migrationcenterpb.CreateSourceRequest, ...gax.CallOption) (*CreateSourceOperation, error)
	CreateSourceOperation(name string) *CreateSourceOperation
	UpdateSource(context.Context, *migrationcenterpb.UpdateSourceRequest, ...gax.CallOption) (*UpdateSourceOperation, error)
	UpdateSourceOperation(name string) *UpdateSourceOperation
	DeleteSource(context.Context, *migrationcenterpb.DeleteSourceRequest, ...gax.CallOption) (*DeleteSourceOperation, error)
	DeleteSourceOperation(name string) *DeleteSourceOperation
	ListPreferenceSets(context.Context, *migrationcenterpb.ListPreferenceSetsRequest, ...gax.CallOption) *PreferenceSetIterator
	GetPreferenceSet(context.Context, *migrationcenterpb.GetPreferenceSetRequest, ...gax.CallOption) (*migrationcenterpb.PreferenceSet, error)
	CreatePreferenceSet(context.Context, *migrationcenterpb.CreatePreferenceSetRequest, ...gax.CallOption) (*CreatePreferenceSetOperation, error)
	CreatePreferenceSetOperation(name string) *CreatePreferenceSetOperation
	UpdatePreferenceSet(context.Context, *migrationcenterpb.UpdatePreferenceSetRequest, ...gax.CallOption) (*UpdatePreferenceSetOperation, error)
	UpdatePreferenceSetOperation(name string) *UpdatePreferenceSetOperation
	DeletePreferenceSet(context.Context, *migrationcenterpb.DeletePreferenceSetRequest, ...gax.CallOption) (*DeletePreferenceSetOperation, error)
	DeletePreferenceSetOperation(name string) *DeletePreferenceSetOperation
	GetSettings(context.Context, *migrationcenterpb.GetSettingsRequest, ...gax.CallOption) (*migrationcenterpb.Settings, error)
	UpdateSettings(context.Context, *migrationcenterpb.UpdateSettingsRequest, ...gax.CallOption) (*UpdateSettingsOperation, error)
	UpdateSettingsOperation(name string) *UpdateSettingsOperation
	CreateReportConfig(context.Context, *migrationcenterpb.CreateReportConfigRequest, ...gax.CallOption) (*CreateReportConfigOperation, error)
	CreateReportConfigOperation(name string) *CreateReportConfigOperation
	GetReportConfig(context.Context, *migrationcenterpb.GetReportConfigRequest, ...gax.CallOption) (*migrationcenterpb.ReportConfig, error)
	ListReportConfigs(context.Context, *migrationcenterpb.ListReportConfigsRequest, ...gax.CallOption) *ReportConfigIterator
	DeleteReportConfig(context.Context, *migrationcenterpb.DeleteReportConfigRequest, ...gax.CallOption) (*DeleteReportConfigOperation, error)
	DeleteReportConfigOperation(name string) *DeleteReportConfigOperation
	CreateReport(context.Context, *migrationcenterpb.CreateReportRequest, ...gax.CallOption) (*CreateReportOperation, error)
	CreateReportOperation(name string) *CreateReportOperation
	GetReport(context.Context, *migrationcenterpb.GetReportRequest, ...gax.CallOption) (*migrationcenterpb.Report, error)
	ListReports(context.Context, *migrationcenterpb.ListReportsRequest, ...gax.CallOption) *ReportIterator
	DeleteReport(context.Context, *migrationcenterpb.DeleteReportRequest, ...gax.CallOption) (*DeleteReportOperation, error)
	DeleteReportOperation(name string) *DeleteReportOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// Client is a client for interacting with Migration Center API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service describing handlers for resources.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListAssets lists all the assets in a given project and location.
func (c *Client) ListAssets(ctx context.Context, req *migrationcenterpb.ListAssetsRequest, opts ...gax.CallOption) *AssetIterator {
	return c.internalClient.ListAssets(ctx, req, opts...)
}

// GetAsset gets the details of an asset.
func (c *Client) GetAsset(ctx context.Context, req *migrationcenterpb.GetAssetRequest, opts ...gax.CallOption) (*migrationcenterpb.Asset, error) {
	return c.internalClient.GetAsset(ctx, req, opts...)
}

// UpdateAsset updates the parameters of an asset.
func (c *Client) UpdateAsset(ctx context.Context, req *migrationcenterpb.UpdateAssetRequest, opts ...gax.CallOption) (*migrationcenterpb.Asset, error) {
	return c.internalClient.UpdateAsset(ctx, req, opts...)
}

// BatchUpdateAssets updates the parameters of a list of assets.
func (c *Client) BatchUpdateAssets(ctx context.Context, req *migrationcenterpb.BatchUpdateAssetsRequest, opts ...gax.CallOption) (*migrationcenterpb.BatchUpdateAssetsResponse, error) {
	return c.internalClient.BatchUpdateAssets(ctx, req, opts...)
}

// DeleteAsset deletes an asset.
func (c *Client) DeleteAsset(ctx context.Context, req *migrationcenterpb.DeleteAssetRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteAsset(ctx, req, opts...)
}

// BatchDeleteAssets deletes list of Assets.
func (c *Client) BatchDeleteAssets(ctx context.Context, req *migrationcenterpb.BatchDeleteAssetsRequest, opts ...gax.CallOption) error {
	return c.internalClient.BatchDeleteAssets(ctx, req, opts...)
}

// ReportAssetFrames reports a set of frames.
func (c *Client) ReportAssetFrames(ctx context.Context, req *migrationcenterpb.ReportAssetFramesRequest, opts ...gax.CallOption) (*migrationcenterpb.ReportAssetFramesResponse, error) {
	return c.internalClient.ReportAssetFrames(ctx, req, opts...)
}

// AggregateAssetsValues aggregates the requested fields based on provided function.
func (c *Client) AggregateAssetsValues(ctx context.Context, req *migrationcenterpb.AggregateAssetsValuesRequest, opts ...gax.CallOption) (*migrationcenterpb.AggregateAssetsValuesResponse, error) {
	return c.internalClient.AggregateAssetsValues(ctx, req, opts...)
}

// CreateImportJob creates an import job.
func (c *Client) CreateImportJob(ctx context.Context, req *migrationcenterpb.CreateImportJobRequest, opts ...gax.CallOption) (*CreateImportJobOperation, error) {
	return c.internalClient.CreateImportJob(ctx, req, opts...)
}

// CreateImportJobOperation returns a new CreateImportJobOperation from a given name.
// The name must be that of a previously created CreateImportJobOperation, possibly from a different process.
func (c *Client) CreateImportJobOperation(name string) *CreateImportJobOperation {
	return c.internalClient.CreateImportJobOperation(name)
}

// ListImportJobs lists all import jobs.
func (c *Client) ListImportJobs(ctx context.Context, req *migrationcenterpb.ListImportJobsRequest, opts ...gax.CallOption) *ImportJobIterator {
	return c.internalClient.ListImportJobs(ctx, req, opts...)
}

// GetImportJob gets the details of an import job.
func (c *Client) GetImportJob(ctx context.Context, req *migrationcenterpb.GetImportJobRequest, opts ...gax.CallOption) (*migrationcenterpb.ImportJob, error) {
	return c.internalClient.GetImportJob(ctx, req, opts...)
}

// DeleteImportJob deletes an import job.
func (c *Client) DeleteImportJob(ctx context.Context, req *migrationcenterpb.DeleteImportJobRequest, opts ...gax.CallOption) (*DeleteImportJobOperation, error) {
	return c.internalClient.DeleteImportJob(ctx, req, opts...)
}

// DeleteImportJobOperation returns a new DeleteImportJobOperation from a given name.
// The name must be that of a previously created DeleteImportJobOperation, possibly from a different process.
func (c *Client) DeleteImportJobOperation(name string) *DeleteImportJobOperation {
	return c.internalClient.DeleteImportJobOperation(name)
}

// UpdateImportJob updates an import job.
func (c *Client) UpdateImportJob(ctx context.Context, req *migrationcenterpb.UpdateImportJobRequest, opts ...gax.CallOption) (*UpdateImportJobOperation, error) {
	return c.internalClient.UpdateImportJob(ctx, req, opts...)
}

// UpdateImportJobOperation returns a new UpdateImportJobOperation from a given name.
// The name must be that of a previously created UpdateImportJobOperation, possibly from a different process.
func (c *Client) UpdateImportJobOperation(name string) *UpdateImportJobOperation {
	return c.internalClient.UpdateImportJobOperation(name)
}

// ValidateImportJob validates an import job.
func (c *Client) ValidateImportJob(ctx context.Context, req *migrationcenterpb.ValidateImportJobRequest, opts ...gax.CallOption) (*ValidateImportJobOperation, error) {
	return c.internalClient.ValidateImportJob(ctx, req, opts...)
}

// ValidateImportJobOperation returns a new ValidateImportJobOperation from a given name.
// The name must be that of a previously created ValidateImportJobOperation, possibly from a different process.
func (c *Client) ValidateImportJobOperation(name string) *ValidateImportJobOperation {
	return c.internalClient.ValidateImportJobOperation(name)
}

// RunImportJob runs an import job.
func (c *Client) RunImportJob(ctx context.Context, req *migrationcenterpb.RunImportJobRequest, opts ...gax.CallOption) (*RunImportJobOperation, error) {
	return c.internalClient.RunImportJob(ctx, req, opts...)
}

// RunImportJobOperation returns a new RunImportJobOperation from a given name.
// The name must be that of a previously created RunImportJobOperation, possibly from a different process.
func (c *Client) RunImportJobOperation(name string) *RunImportJobOperation {
	return c.internalClient.RunImportJobOperation(name)
}

// GetImportDataFile gets an import data file.
func (c *Client) GetImportDataFile(ctx context.Context, req *migrationcenterpb.GetImportDataFileRequest, opts ...gax.CallOption) (*migrationcenterpb.ImportDataFile, error) {
	return c.internalClient.GetImportDataFile(ctx, req, opts...)
}

// ListImportDataFiles list import data files.
func (c *Client) ListImportDataFiles(ctx context.Context, req *migrationcenterpb.ListImportDataFilesRequest, opts ...gax.CallOption) *ImportDataFileIterator {
	return c.internalClient.ListImportDataFiles(ctx, req, opts...)
}

// CreateImportDataFile creates an import data file.
func (c *Client) CreateImportDataFile(ctx context.Context, req *migrationcenterpb.CreateImportDataFileRequest, opts ...gax.CallOption) (*CreateImportDataFileOperation, error) {
	return c.internalClient.CreateImportDataFile(ctx, req, opts...)
}

// CreateImportDataFileOperation returns a new CreateImportDataFileOperation from a given name.
// The name must be that of a previously created CreateImportDataFileOperation, possibly from a different process.
func (c *Client) CreateImportDataFileOperation(name string) *CreateImportDataFileOperation {
	return c.internalClient.CreateImportDataFileOperation(name)
}

// DeleteImportDataFile delete an import data file.
func (c *Client) DeleteImportDataFile(ctx context.Context, req *migrationcenterpb.DeleteImportDataFileRequest, opts ...gax.CallOption) (*DeleteImportDataFileOperation, error) {
	return c.internalClient.DeleteImportDataFile(ctx, req, opts...)
}

// DeleteImportDataFileOperation returns a new DeleteImportDataFileOperation from a given name.
// The name must be that of a previously created DeleteImportDataFileOperation, possibly from a different process.
func (c *Client) DeleteImportDataFileOperation(name string) *DeleteImportDataFileOperation {
	return c.internalClient.DeleteImportDataFileOperation(name)
}

// ListGroups lists all groups in a given project and location.
func (c *Client) ListGroups(ctx context.Context, req *migrationcenterpb.ListGroupsRequest, opts ...gax.CallOption) *GroupIterator {
	return c.internalClient.ListGroups(ctx, req, opts...)
}

// GetGroup gets the details of a group.
func (c *Client) GetGroup(ctx context.Context, req *migrationcenterpb.GetGroupRequest, opts ...gax.CallOption) (*migrationcenterpb.Group, error) {
	return c.internalClient.GetGroup(ctx, req, opts...)
}

// CreateGroup creates a new group in a given project and location.
func (c *Client) CreateGroup(ctx context.Context, req *migrationcenterpb.CreateGroupRequest, opts ...gax.CallOption) (*CreateGroupOperation, error) {
	return c.internalClient.CreateGroup(ctx, req, opts...)
}

// CreateGroupOperation returns a new CreateGroupOperation from a given name.
// The name must be that of a previously created CreateGroupOperation, possibly from a different process.
func (c *Client) CreateGroupOperation(name string) *CreateGroupOperation {
	return c.internalClient.CreateGroupOperation(name)
}

// UpdateGroup updates the parameters of a group.
func (c *Client) UpdateGroup(ctx context.Context, req *migrationcenterpb.UpdateGroupRequest, opts ...gax.CallOption) (*UpdateGroupOperation, error) {
	return c.internalClient.UpdateGroup(ctx, req, opts...)
}

// UpdateGroupOperation returns a new UpdateGroupOperation from a given name.
// The name must be that of a previously created UpdateGroupOperation, possibly from a different process.
func (c *Client) UpdateGroupOperation(name string) *UpdateGroupOperation {
	return c.internalClient.UpdateGroupOperation(name)
}

// DeleteGroup deletes a group.
func (c *Client) DeleteGroup(ctx context.Context, req *migrationcenterpb.DeleteGroupRequest, opts ...gax.CallOption) (*DeleteGroupOperation, error) {
	return c.internalClient.DeleteGroup(ctx, req, opts...)
}

// DeleteGroupOperation returns a new DeleteGroupOperation from a given name.
// The name must be that of a previously created DeleteGroupOperation, possibly from a different process.
func (c *Client) DeleteGroupOperation(name string) *DeleteGroupOperation {
	return c.internalClient.DeleteGroupOperation(name)
}

// AddAssetsToGroup adds assets to a group.
func (c *Client) AddAssetsToGroup(ctx context.Context, req *migrationcenterpb.AddAssetsToGroupRequest, opts ...gax.CallOption) (*AddAssetsToGroupOperation, error) {
	return c.internalClient.AddAssetsToGroup(ctx, req, opts...)
}

// AddAssetsToGroupOperation returns a new AddAssetsToGroupOperation from a given name.
// The name must be that of a previously created AddAssetsToGroupOperation, possibly from a different process.
func (c *Client) AddAssetsToGroupOperation(name string) *AddAssetsToGroupOperation {
	return c.internalClient.AddAssetsToGroupOperation(name)
}

// RemoveAssetsFromGroup removes assets from a group.
func (c *Client) RemoveAssetsFromGroup(ctx context.Context, req *migrationcenterpb.RemoveAssetsFromGroupRequest, opts ...gax.CallOption) (*RemoveAssetsFromGroupOperation, error) {
	return c.internalClient.RemoveAssetsFromGroup(ctx, req, opts...)
}

// RemoveAssetsFromGroupOperation returns a new RemoveAssetsFromGroupOperation from a given name.
// The name must be that of a previously created RemoveAssetsFromGroupOperation, possibly from a different process.
func (c *Client) RemoveAssetsFromGroupOperation(name string) *RemoveAssetsFromGroupOperation {
	return c.internalClient.RemoveAssetsFromGroupOperation(name)
}

// ListErrorFrames lists all error frames in a given source and location.
func (c *Client) ListErrorFrames(ctx context.Context, req *migrationcenterpb.ListErrorFramesRequest, opts ...gax.CallOption) *ErrorFrameIterator {
	return c.internalClient.ListErrorFrames(ctx, req, opts...)
}

// GetErrorFrame gets the details of an error frame.
func (c *Client) GetErrorFrame(ctx context.Context, req *migrationcenterpb.GetErrorFrameRequest, opts ...gax.CallOption) (*migrationcenterpb.ErrorFrame, error) {
	return c.internalClient.GetErrorFrame(ctx, req, opts...)
}

// ListSources lists all the sources in a given project and location.
func (c *Client) ListSources(ctx context.Context, req *migrationcenterpb.ListSourcesRequest, opts ...gax.CallOption) *SourceIterator {
	return c.internalClient.ListSources(ctx, req, opts...)
}

// GetSource gets the details of a source.
func (c *Client) GetSource(ctx context.Context, req *migrationcenterpb.GetSourceRequest, opts ...gax.CallOption) (*migrationcenterpb.Source, error) {
	return c.internalClient.GetSource(ctx, req, opts...)
}

// CreateSource creates a new source in a given project and location.
func (c *Client) CreateSource(ctx context.Context, req *migrationcenterpb.CreateSourceRequest, opts ...gax.CallOption) (*CreateSourceOperation, error) {
	return c.internalClient.CreateSource(ctx, req, opts...)
}

// CreateSourceOperation returns a new CreateSourceOperation from a given name.
// The name must be that of a previously created CreateSourceOperation, possibly from a different process.
func (c *Client) CreateSourceOperation(name string) *CreateSourceOperation {
	return c.internalClient.CreateSourceOperation(name)
}

// UpdateSource updates the parameters of a source.
func (c *Client) UpdateSource(ctx context.Context, req *migrationcenterpb.UpdateSourceRequest, opts ...gax.CallOption) (*UpdateSourceOperation, error) {
	return c.internalClient.UpdateSource(ctx, req, opts...)
}

// UpdateSourceOperation returns a new UpdateSourceOperation from a given name.
// The name must be that of a previously created UpdateSourceOperation, possibly from a different process.
func (c *Client) UpdateSourceOperation(name string) *UpdateSourceOperation {
	return c.internalClient.UpdateSourceOperation(name)
}

// DeleteSource deletes a source.
func (c *Client) DeleteSource(ctx context.Context, req *migrationcenterpb.DeleteSourceRequest, opts ...gax.CallOption) (*DeleteSourceOperation, error) {
	return c.internalClient.DeleteSource(ctx, req, opts...)
}

// DeleteSourceOperation returns a new DeleteSourceOperation from a given name.
// The name must be that of a previously created DeleteSourceOperation, possibly from a different process.
func (c *Client) DeleteSourceOperation(name string) *DeleteSourceOperation {
	return c.internalClient.DeleteSourceOperation(name)
}

// ListPreferenceSets lists all the preference sets in a given project and location.
func (c *Client) ListPreferenceSets(ctx context.Context, req *migrationcenterpb.ListPreferenceSetsRequest, opts ...gax.CallOption) *PreferenceSetIterator {
	return c.internalClient.ListPreferenceSets(ctx, req, opts...)
}

// GetPreferenceSet gets the details of a preference set.
func (c *Client) GetPreferenceSet(ctx context.Context, req *migrationcenterpb.GetPreferenceSetRequest, opts ...gax.CallOption) (*migrationcenterpb.PreferenceSet, error) {
	return c.internalClient.GetPreferenceSet(ctx, req, opts...)
}

// CreatePreferenceSet creates a new preference set in a given project and location.
func (c *Client) CreatePreferenceSet(ctx context.Context, req *migrationcenterpb.CreatePreferenceSetRequest, opts ...gax.CallOption) (*CreatePreferenceSetOperation, error) {
	return c.internalClient.CreatePreferenceSet(ctx, req, opts...)
}

// CreatePreferenceSetOperation returns a new CreatePreferenceSetOperation from a given name.
// The name must be that of a previously created CreatePreferenceSetOperation, possibly from a different process.
func (c *Client) CreatePreferenceSetOperation(name string) *CreatePreferenceSetOperation {
	return c.internalClient.CreatePreferenceSetOperation(name)
}

// UpdatePreferenceSet updates the parameters of a preference set.
func (c *Client) UpdatePreferenceSet(ctx context.Context, req *migrationcenterpb.UpdatePreferenceSetRequest, opts ...gax.CallOption) (*UpdatePreferenceSetOperation, error) {
	return c.internalClient.UpdatePreferenceSet(ctx, req, opts...)
}

// UpdatePreferenceSetOperation returns a new UpdatePreferenceSetOperation from a given name.
// The name must be that of a previously created UpdatePreferenceSetOperation, possibly from a different process.
func (c *Client) UpdatePreferenceSetOperation(name string) *UpdatePreferenceSetOperation {
	return c.internalClient.UpdatePreferenceSetOperation(name)
}

// DeletePreferenceSet deletes a preference set.
func (c *Client) DeletePreferenceSet(ctx context.Context, req *migrationcenterpb.DeletePreferenceSetRequest, opts ...gax.CallOption) (*DeletePreferenceSetOperation, error) {
	return c.internalClient.DeletePreferenceSet(ctx, req, opts...)
}

// DeletePreferenceSetOperation returns a new DeletePreferenceSetOperation from a given name.
// The name must be that of a previously created DeletePreferenceSetOperation, possibly from a different process.
func (c *Client) DeletePreferenceSetOperation(name string) *DeletePreferenceSetOperation {
	return c.internalClient.DeletePreferenceSetOperation(name)
}

// GetSettings gets the details of regional settings.
func (c *Client) GetSettings(ctx context.Context, req *migrationcenterpb.GetSettingsRequest, opts ...gax.CallOption) (*migrationcenterpb.Settings, error) {
	return c.internalClient.GetSettings(ctx, req, opts...)
}

// UpdateSettings updates the regional-level project settings.
func (c *Client) UpdateSettings(ctx context.Context, req *migrationcenterpb.UpdateSettingsRequest, opts ...gax.CallOption) (*UpdateSettingsOperation, error) {
	return c.internalClient.UpdateSettings(ctx, req, opts...)
}

// UpdateSettingsOperation returns a new UpdateSettingsOperation from a given name.
// The name must be that of a previously created UpdateSettingsOperation, possibly from a different process.
func (c *Client) UpdateSettingsOperation(name string) *UpdateSettingsOperation {
	return c.internalClient.UpdateSettingsOperation(name)
}

// CreateReportConfig creates a report configuration.
func (c *Client) CreateReportConfig(ctx context.Context, req *migrationcenterpb.CreateReportConfigRequest, opts ...gax.CallOption) (*CreateReportConfigOperation, error) {
	return c.internalClient.CreateReportConfig(ctx, req, opts...)
}

// CreateReportConfigOperation returns a new CreateReportConfigOperation from a given name.
// The name must be that of a previously created CreateReportConfigOperation, possibly from a different process.
func (c *Client) CreateReportConfigOperation(name string) *CreateReportConfigOperation {
	return c.internalClient.CreateReportConfigOperation(name)
}

// GetReportConfig gets details of a single ReportConfig.
func (c *Client) GetReportConfig(ctx context.Context, req *migrationcenterpb.GetReportConfigRequest, opts ...gax.CallOption) (*migrationcenterpb.ReportConfig, error) {
	return c.internalClient.GetReportConfig(ctx, req, opts...)
}

// ListReportConfigs lists ReportConfigs in a given project and location.
func (c *Client) ListReportConfigs(ctx context.Context, req *migrationcenterpb.ListReportConfigsRequest, opts ...gax.CallOption) *ReportConfigIterator {
	return c.internalClient.ListReportConfigs(ctx, req, opts...)
}

// DeleteReportConfig deletes a ReportConfig.
func (c *Client) DeleteReportConfig(ctx context.Context, req *migrationcenterpb.DeleteReportConfigRequest, opts ...gax.CallOption) (*DeleteReportConfigOperation, error) {
	return c.internalClient.DeleteReportConfig(ctx, req, opts...)
}

// DeleteReportConfigOperation returns a new DeleteReportConfigOperation from a given name.
// The name must be that of a previously created DeleteReportConfigOperation, possibly from a different process.
func (c *Client) DeleteReportConfigOperation(name string) *DeleteReportConfigOperation {
	return c.internalClient.DeleteReportConfigOperation(name)
}

// CreateReport creates a report.
func (c *Client) CreateReport(ctx context.Context, req *migrationcenterpb.CreateReportRequest, opts ...gax.CallOption) (*CreateReportOperation, error) {
	return c.internalClient.CreateReport(ctx, req, opts...)
}

// CreateReportOperation returns a new CreateReportOperation from a given name.
// The name must be that of a previously created CreateReportOperation, possibly from a different process.
func (c *Client) CreateReportOperation(name string) *CreateReportOperation {
	return c.internalClient.CreateReportOperation(name)
}

// GetReport gets details of a single Report.
func (c *Client) GetReport(ctx context.Context, req *migrationcenterpb.GetReportRequest, opts ...gax.CallOption) (*migrationcenterpb.Report, error) {
	return c.internalClient.GetReport(ctx, req, opts...)
}

// ListReports lists Reports in a given ReportConfig.
func (c *Client) ListReports(ctx context.Context, req *migrationcenterpb.ListReportsRequest, opts ...gax.CallOption) *ReportIterator {
	return c.internalClient.ListReports(ctx, req, opts...)
}

// DeleteReport deletes a Report.
func (c *Client) DeleteReport(ctx context.Context, req *migrationcenterpb.DeleteReportRequest, opts ...gax.CallOption) (*DeleteReportOperation, error) {
	return c.internalClient.DeleteReport(ctx, req, opts...)
}

// DeleteReportOperation returns a new DeleteReportOperation from a given name.
// The name must be that of a previously created DeleteReportOperation, possibly from a different process.
func (c *Client) DeleteReportOperation(name string) *DeleteReportOperation {
	return c.internalClient.DeleteReportOperation(name)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *Client) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *Client) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *Client) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *Client) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Migration Center API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client migrationcenterpb.MigrationCenterClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewClient creates a new migration center client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service describing handlers for resources.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		client:           migrationcenterpb.NewMigrationCenterClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	logger *slog.Logger
}

// NewRESTClient creates a new migration center rest client.
//
// Service describing handlers for resources.
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://migrationcenter.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://migrationcenter.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://migrationcenter.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://migrationcenter.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListAssets(ctx context.Context, req *migrationcenterpb.ListAssetsRequest, opts ...gax.CallOption) *AssetIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAssets[0:len((*c.CallOptions).ListAssets):len((*c.CallOptions).ListAssets)], opts...)
	it := &AssetIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListAssetsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.Asset, string, error) {
		resp := &migrationcenterpb.ListAssetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListAssets, req, settings.GRPC, c.logger, "ListAssets")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAssets(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetAsset(ctx context.Context, req *migrationcenterpb.GetAssetRequest, opts ...gax.CallOption) (*migrationcenterpb.Asset, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAsset[0:len((*c.CallOptions).GetAsset):len((*c.CallOptions).GetAsset)], opts...)
	var resp *migrationcenterpb.Asset
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetAsset, req, settings.GRPC, c.logger, "GetAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateAsset(ctx context.Context, req *migrationcenterpb.UpdateAssetRequest, opts ...gax.CallOption) (*migrationcenterpb.Asset, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "asset.name", url.QueryEscape(req.GetAsset().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAsset[0:len((*c.CallOptions).UpdateAsset):len((*c.CallOptions).UpdateAsset)], opts...)
	var resp *migrationcenterpb.Asset
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateAsset, req, settings.GRPC, c.logger, "UpdateAsset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) BatchUpdateAssets(ctx context.Context, req *migrationcenterpb.BatchUpdateAssetsRequest, opts ...gax.CallOption) (*migrationcenterpb.BatchUpdateAssetsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).BatchUpdateAssets[0:len((*c.CallOptions).BatchUpdateAssets):len((*c.CallOptions).BatchUpdateAssets)], opts...)
	var resp *migrationcenterpb.BatchUpdateAssetsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.BatchUpdateAssets, req, settings.GRPC, c.logger, "BatchUpdateAssets")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteAsset(ctx context.Context, req *migrationcenterpb.DeleteAssetRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteAsset[0:len((*c.CallOptions).DeleteAsset):len((*c.CallOptions).DeleteAsset)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.client.DeleteAsset, req, settings.GRPC, c.logger, "DeleteAsset")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) BatchDeleteAssets(ctx context.Context, req *migrationcenterpb.BatchDeleteAssetsRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).BatchDeleteAssets[0:len((*c.CallOptions).BatchDeleteAssets):len((*c.CallOptions).BatchDeleteAssets)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.client.BatchDeleteAssets, req, settings.GRPC, c.logger, "BatchDeleteAssets")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) ReportAssetFrames(ctx context.Context, req *migrationcenterpb.ReportAssetFramesRequest, opts ...gax.CallOption) (*migrationcenterpb.ReportAssetFramesResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReportAssetFrames[0:len((*c.CallOptions).ReportAssetFrames):len((*c.CallOptions).ReportAssetFrames)], opts...)
	var resp *migrationcenterpb.ReportAssetFramesResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ReportAssetFrames, req, settings.GRPC, c.logger, "ReportAssetFrames")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) AggregateAssetsValues(ctx context.Context, req *migrationcenterpb.AggregateAssetsValuesRequest, opts ...gax.CallOption) (*migrationcenterpb.AggregateAssetsValuesResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AggregateAssetsValues[0:len((*c.CallOptions).AggregateAssetsValues):len((*c.CallOptions).AggregateAssetsValues)], opts...)
	var resp *migrationcenterpb.AggregateAssetsValuesResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.AggregateAssetsValues, req, settings.GRPC, c.logger, "AggregateAssetsValues")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateImportJob(ctx context.Context, req *migrationcenterpb.CreateImportJobRequest, opts ...gax.CallOption) (*CreateImportJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateImportJob[0:len((*c.CallOptions).CreateImportJob):len((*c.CallOptions).CreateImportJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateImportJob, req, settings.GRPC, c.logger, "CreateImportJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListImportJobs(ctx context.Context, req *migrationcenterpb.ListImportJobsRequest, opts ...gax.CallOption) *ImportJobIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListImportJobs[0:len((*c.CallOptions).ListImportJobs):len((*c.CallOptions).ListImportJobs)], opts...)
	it := &ImportJobIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListImportJobsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.ImportJob, string, error) {
		resp := &migrationcenterpb.ListImportJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListImportJobs, req, settings.GRPC, c.logger, "ListImportJobs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetImportJobs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetImportJob(ctx context.Context, req *migrationcenterpb.GetImportJobRequest, opts ...gax.CallOption) (*migrationcenterpb.ImportJob, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetImportJob[0:len((*c.CallOptions).GetImportJob):len((*c.CallOptions).GetImportJob)], opts...)
	var resp *migrationcenterpb.ImportJob
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetImportJob, req, settings.GRPC, c.logger, "GetImportJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteImportJob(ctx context.Context, req *migrationcenterpb.DeleteImportJobRequest, opts ...gax.CallOption) (*DeleteImportJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteImportJob[0:len((*c.CallOptions).DeleteImportJob):len((*c.CallOptions).DeleteImportJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteImportJob, req, settings.GRPC, c.logger, "DeleteImportJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateImportJob(ctx context.Context, req *migrationcenterpb.UpdateImportJobRequest, opts ...gax.CallOption) (*UpdateImportJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "import_job.name", url.QueryEscape(req.GetImportJob().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateImportJob[0:len((*c.CallOptions).UpdateImportJob):len((*c.CallOptions).UpdateImportJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateImportJob, req, settings.GRPC, c.logger, "UpdateImportJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ValidateImportJob(ctx context.Context, req *migrationcenterpb.ValidateImportJobRequest, opts ...gax.CallOption) (*ValidateImportJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ValidateImportJob[0:len((*c.CallOptions).ValidateImportJob):len((*c.CallOptions).ValidateImportJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ValidateImportJob, req, settings.GRPC, c.logger, "ValidateImportJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ValidateImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) RunImportJob(ctx context.Context, req *migrationcenterpb.RunImportJobRequest, opts ...gax.CallOption) (*RunImportJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RunImportJob[0:len((*c.CallOptions).RunImportJob):len((*c.CallOptions).RunImportJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.RunImportJob, req, settings.GRPC, c.logger, "RunImportJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RunImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetImportDataFile(ctx context.Context, req *migrationcenterpb.GetImportDataFileRequest, opts ...gax.CallOption) (*migrationcenterpb.ImportDataFile, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetImportDataFile[0:len((*c.CallOptions).GetImportDataFile):len((*c.CallOptions).GetImportDataFile)], opts...)
	var resp *migrationcenterpb.ImportDataFile
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetImportDataFile, req, settings.GRPC, c.logger, "GetImportDataFile")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListImportDataFiles(ctx context.Context, req *migrationcenterpb.ListImportDataFilesRequest, opts ...gax.CallOption) *ImportDataFileIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListImportDataFiles[0:len((*c.CallOptions).ListImportDataFiles):len((*c.CallOptions).ListImportDataFiles)], opts...)
	it := &ImportDataFileIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListImportDataFilesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.ImportDataFile, string, error) {
		resp := &migrationcenterpb.ListImportDataFilesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListImportDataFiles, req, settings.GRPC, c.logger, "ListImportDataFiles")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetImportDataFiles(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CreateImportDataFile(ctx context.Context, req *migrationcenterpb.CreateImportDataFileRequest, opts ...gax.CallOption) (*CreateImportDataFileOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateImportDataFile[0:len((*c.CallOptions).CreateImportDataFile):len((*c.CallOptions).CreateImportDataFile)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateImportDataFile, req, settings.GRPC, c.logger, "CreateImportDataFile")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateImportDataFileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteImportDataFile(ctx context.Context, req *migrationcenterpb.DeleteImportDataFileRequest, opts ...gax.CallOption) (*DeleteImportDataFileOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteImportDataFile[0:len((*c.CallOptions).DeleteImportDataFile):len((*c.CallOptions).DeleteImportDataFile)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteImportDataFile, req, settings.GRPC, c.logger, "DeleteImportDataFile")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteImportDataFileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListGroups(ctx context.Context, req *migrationcenterpb.ListGroupsRequest, opts ...gax.CallOption) *GroupIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGroups[0:len((*c.CallOptions).ListGroups):len((*c.CallOptions).ListGroups)], opts...)
	it := &GroupIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListGroupsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.Group, string, error) {
		resp := &migrationcenterpb.ListGroupsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListGroups, req, settings.GRPC, c.logger, "ListGroups")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGroups(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetGroup(ctx context.Context, req *migrationcenterpb.GetGroupRequest, opts ...gax.CallOption) (*migrationcenterpb.Group, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGroup[0:len((*c.CallOptions).GetGroup):len((*c.CallOptions).GetGroup)], opts...)
	var resp *migrationcenterpb.Group
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetGroup, req, settings.GRPC, c.logger, "GetGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateGroup(ctx context.Context, req *migrationcenterpb.CreateGroupRequest, opts ...gax.CallOption) (*CreateGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGroup[0:len((*c.CallOptions).CreateGroup):len((*c.CallOptions).CreateGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateGroup, req, settings.GRPC, c.logger, "CreateGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateGroup(ctx context.Context, req *migrationcenterpb.UpdateGroupRequest, opts ...gax.CallOption) (*UpdateGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group.name", url.QueryEscape(req.GetGroup().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGroup[0:len((*c.CallOptions).UpdateGroup):len((*c.CallOptions).UpdateGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateGroup, req, settings.GRPC, c.logger, "UpdateGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteGroup(ctx context.Context, req *migrationcenterpb.DeleteGroupRequest, opts ...gax.CallOption) (*DeleteGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteGroup[0:len((*c.CallOptions).DeleteGroup):len((*c.CallOptions).DeleteGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteGroup, req, settings.GRPC, c.logger, "DeleteGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) AddAssetsToGroup(ctx context.Context, req *migrationcenterpb.AddAssetsToGroupRequest, opts ...gax.CallOption) (*AddAssetsToGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group", url.QueryEscape(req.GetGroup()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AddAssetsToGroup[0:len((*c.CallOptions).AddAssetsToGroup):len((*c.CallOptions).AddAssetsToGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.AddAssetsToGroup, req, settings.GRPC, c.logger, "AddAssetsToGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &AddAssetsToGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) RemoveAssetsFromGroup(ctx context.Context, req *migrationcenterpb.RemoveAssetsFromGroupRequest, opts ...gax.CallOption) (*RemoveAssetsFromGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group", url.QueryEscape(req.GetGroup()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RemoveAssetsFromGroup[0:len((*c.CallOptions).RemoveAssetsFromGroup):len((*c.CallOptions).RemoveAssetsFromGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.RemoveAssetsFromGroup, req, settings.GRPC, c.logger, "RemoveAssetsFromGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RemoveAssetsFromGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListErrorFrames(ctx context.Context, req *migrationcenterpb.ListErrorFramesRequest, opts ...gax.CallOption) *ErrorFrameIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListErrorFrames[0:len((*c.CallOptions).ListErrorFrames):len((*c.CallOptions).ListErrorFrames)], opts...)
	it := &ErrorFrameIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListErrorFramesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.ErrorFrame, string, error) {
		resp := &migrationcenterpb.ListErrorFramesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListErrorFrames, req, settings.GRPC, c.logger, "ListErrorFrames")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetErrorFrames(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetErrorFrame(ctx context.Context, req *migrationcenterpb.GetErrorFrameRequest, opts ...gax.CallOption) (*migrationcenterpb.ErrorFrame, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetErrorFrame[0:len((*c.CallOptions).GetErrorFrame):len((*c.CallOptions).GetErrorFrame)], opts...)
	var resp *migrationcenterpb.ErrorFrame
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetErrorFrame, req, settings.GRPC, c.logger, "GetErrorFrame")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListSources(ctx context.Context, req *migrationcenterpb.ListSourcesRequest, opts ...gax.CallOption) *SourceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSources[0:len((*c.CallOptions).ListSources):len((*c.CallOptions).ListSources)], opts...)
	it := &SourceIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListSourcesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.Source, string, error) {
		resp := &migrationcenterpb.ListSourcesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListSources, req, settings.GRPC, c.logger, "ListSources")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSources(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetSource(ctx context.Context, req *migrationcenterpb.GetSourceRequest, opts ...gax.CallOption) (*migrationcenterpb.Source, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSource[0:len((*c.CallOptions).GetSource):len((*c.CallOptions).GetSource)], opts...)
	var resp *migrationcenterpb.Source
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetSource, req, settings.GRPC, c.logger, "GetSource")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateSource(ctx context.Context, req *migrationcenterpb.CreateSourceRequest, opts ...gax.CallOption) (*CreateSourceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSource[0:len((*c.CallOptions).CreateSource):len((*c.CallOptions).CreateSource)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateSource, req, settings.GRPC, c.logger, "CreateSource")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateSource(ctx context.Context, req *migrationcenterpb.UpdateSourceRequest, opts ...gax.CallOption) (*UpdateSourceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "source.name", url.QueryEscape(req.GetSource().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSource[0:len((*c.CallOptions).UpdateSource):len((*c.CallOptions).UpdateSource)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateSource, req, settings.GRPC, c.logger, "UpdateSource")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteSource(ctx context.Context, req *migrationcenterpb.DeleteSourceRequest, opts ...gax.CallOption) (*DeleteSourceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSource[0:len((*c.CallOptions).DeleteSource):len((*c.CallOptions).DeleteSource)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteSource, req, settings.GRPC, c.logger, "DeleteSource")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListPreferenceSets(ctx context.Context, req *migrationcenterpb.ListPreferenceSetsRequest, opts ...gax.CallOption) *PreferenceSetIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListPreferenceSets[0:len((*c.CallOptions).ListPreferenceSets):len((*c.CallOptions).ListPreferenceSets)], opts...)
	it := &PreferenceSetIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListPreferenceSetsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.PreferenceSet, string, error) {
		resp := &migrationcenterpb.ListPreferenceSetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListPreferenceSets, req, settings.GRPC, c.logger, "ListPreferenceSets")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPreferenceSets(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetPreferenceSet(ctx context.Context, req *migrationcenterpb.GetPreferenceSetRequest, opts ...gax.CallOption) (*migrationcenterpb.PreferenceSet, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetPreferenceSet[0:len((*c.CallOptions).GetPreferenceSet):len((*c.CallOptions).GetPreferenceSet)], opts...)
	var resp *migrationcenterpb.PreferenceSet
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetPreferenceSet, req, settings.GRPC, c.logger, "GetPreferenceSet")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreatePreferenceSet(ctx context.Context, req *migrationcenterpb.CreatePreferenceSetRequest, opts ...gax.CallOption) (*CreatePreferenceSetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreatePreferenceSet[0:len((*c.CallOptions).CreatePreferenceSet):len((*c.CallOptions).CreatePreferenceSet)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreatePreferenceSet, req, settings.GRPC, c.logger, "CreatePreferenceSet")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreatePreferenceSetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdatePreferenceSet(ctx context.Context, req *migrationcenterpb.UpdatePreferenceSetRequest, opts ...gax.CallOption) (*UpdatePreferenceSetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "preference_set.name", url.QueryEscape(req.GetPreferenceSet().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdatePreferenceSet[0:len((*c.CallOptions).UpdatePreferenceSet):len((*c.CallOptions).UpdatePreferenceSet)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdatePreferenceSet, req, settings.GRPC, c.logger, "UpdatePreferenceSet")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdatePreferenceSetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeletePreferenceSet(ctx context.Context, req *migrationcenterpb.DeletePreferenceSetRequest, opts ...gax.CallOption) (*DeletePreferenceSetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeletePreferenceSet[0:len((*c.CallOptions).DeletePreferenceSet):len((*c.CallOptions).DeletePreferenceSet)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeletePreferenceSet, req, settings.GRPC, c.logger, "DeletePreferenceSet")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeletePreferenceSetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetSettings(ctx context.Context, req *migrationcenterpb.GetSettingsRequest, opts ...gax.CallOption) (*migrationcenterpb.Settings, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSettings[0:len((*c.CallOptions).GetSettings):len((*c.CallOptions).GetSettings)], opts...)
	var resp *migrationcenterpb.Settings
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetSettings, req, settings.GRPC, c.logger, "GetSettings")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateSettings(ctx context.Context, req *migrationcenterpb.UpdateSettingsRequest, opts ...gax.CallOption) (*UpdateSettingsOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "settings.name", url.QueryEscape(req.GetSettings().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSettings[0:len((*c.CallOptions).UpdateSettings):len((*c.CallOptions).UpdateSettings)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateSettings, req, settings.GRPC, c.logger, "UpdateSettings")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateSettingsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateReportConfig(ctx context.Context, req *migrationcenterpb.CreateReportConfigRequest, opts ...gax.CallOption) (*CreateReportConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateReportConfig[0:len((*c.CallOptions).CreateReportConfig):len((*c.CallOptions).CreateReportConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateReportConfig, req, settings.GRPC, c.logger, "CreateReportConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateReportConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetReportConfig(ctx context.Context, req *migrationcenterpb.GetReportConfigRequest, opts ...gax.CallOption) (*migrationcenterpb.ReportConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetReportConfig[0:len((*c.CallOptions).GetReportConfig):len((*c.CallOptions).GetReportConfig)], opts...)
	var resp *migrationcenterpb.ReportConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetReportConfig, req, settings.GRPC, c.logger, "GetReportConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListReportConfigs(ctx context.Context, req *migrationcenterpb.ListReportConfigsRequest, opts ...gax.CallOption) *ReportConfigIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListReportConfigs[0:len((*c.CallOptions).ListReportConfigs):len((*c.CallOptions).ListReportConfigs)], opts...)
	it := &ReportConfigIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListReportConfigsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.ReportConfig, string, error) {
		resp := &migrationcenterpb.ListReportConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListReportConfigs, req, settings.GRPC, c.logger, "ListReportConfigs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetReportConfigs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DeleteReportConfig(ctx context.Context, req *migrationcenterpb.DeleteReportConfigRequest, opts ...gax.CallOption) (*DeleteReportConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteReportConfig[0:len((*c.CallOptions).DeleteReportConfig):len((*c.CallOptions).DeleteReportConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteReportConfig, req, settings.GRPC, c.logger, "DeleteReportConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteReportConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateReport(ctx context.Context, req *migrationcenterpb.CreateReportRequest, opts ...gax.CallOption) (*CreateReportOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateReport[0:len((*c.CallOptions).CreateReport):len((*c.CallOptions).CreateReport)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateReport, req, settings.GRPC, c.logger, "CreateReport")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateReportOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetReport(ctx context.Context, req *migrationcenterpb.GetReportRequest, opts ...gax.CallOption) (*migrationcenterpb.Report, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetReport[0:len((*c.CallOptions).GetReport):len((*c.CallOptions).GetReport)], opts...)
	var resp *migrationcenterpb.Report
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetReport, req, settings.GRPC, c.logger, "GetReport")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListReports(ctx context.Context, req *migrationcenterpb.ListReportsRequest, opts ...gax.CallOption) *ReportIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListReports[0:len((*c.CallOptions).ListReports):len((*c.CallOptions).ListReports)], opts...)
	it := &ReportIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListReportsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.Report, string, error) {
		resp := &migrationcenterpb.ListReportsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListReports, req, settings.GRPC, c.logger, "ListReports")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetReports(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DeleteReport(ctx context.Context, req *migrationcenterpb.DeleteReportRequest, opts ...gax.CallOption) (*DeleteReportOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteReport[0:len((*c.CallOptions).DeleteReport):len((*c.CallOptions).DeleteReport)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteReport, req, settings.GRPC, c.logger, "DeleteReport")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteReportOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListAssets lists all the assets in a given project and location.
func (c *restClient) ListAssets(ctx context.Context, req *migrationcenterpb.ListAssetsRequest, opts ...gax.CallOption) *AssetIterator {
	it := &AssetIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListAssetsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.Asset, string, error) {
		resp := &migrationcenterpb.ListAssetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/assets", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetView() != 0 {
			params.Add("view", fmt.Sprintf("%v", req.GetView()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAssets")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAssets(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetAsset gets the details of an asset.
func (c *restClient) GetAsset(ctx context.Context, req *migrationcenterpb.GetAssetRequest, opts ...gax.CallOption) (*migrationcenterpb.Asset, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAsset[0:len((*c.CallOptions).GetAsset):len((*c.CallOptions).GetAsset)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.Asset{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetAsset")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateAsset updates the parameters of an asset.
func (c *restClient) UpdateAsset(ctx context.Context, req *migrationcenterpb.UpdateAssetRequest, opts ...gax.CallOption) (*migrationcenterpb.Asset, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAsset()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetAsset().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "asset.name", url.QueryEscape(req.GetAsset().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAsset[0:len((*c.CallOptions).UpdateAsset):len((*c.CallOptions).UpdateAsset)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.Asset{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateAsset")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// BatchUpdateAssets updates the parameters of a list of assets.
func (c *restClient) BatchUpdateAssets(ctx context.Context, req *migrationcenterpb.BatchUpdateAssetsRequest, opts ...gax.CallOption) (*migrationcenterpb.BatchUpdateAssetsResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/assets:batchUpdate", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).BatchUpdateAssets[0:len((*c.CallOptions).BatchUpdateAssets):len((*c.CallOptions).BatchUpdateAssets)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.BatchUpdateAssetsResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "BatchUpdateAssets")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteAsset deletes an asset.
func (c *restClient) DeleteAsset(ctx context.Context, req *migrationcenterpb.DeleteAssetRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteAsset")
		return err
	}, opts...)
}

// BatchDeleteAssets deletes list of Assets.
func (c *restClient) BatchDeleteAssets(ctx context.Context, req *migrationcenterpb.BatchDeleteAssetsRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/assets:batchDelete", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "BatchDeleteAssets")
		return err
	}, opts...)
}

// ReportAssetFrames reports a set of frames.
func (c *restClient) ReportAssetFrames(ctx context.Context, req *migrationcenterpb.ReportAssetFramesRequest, opts ...gax.CallOption) (*migrationcenterpb.ReportAssetFramesResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetFrames()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/assets:reportAssetFrames", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("source", fmt.Sprintf("%v", req.GetSource()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ReportAssetFrames[0:len((*c.CallOptions).ReportAssetFrames):len((*c.CallOptions).ReportAssetFrames)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.ReportAssetFramesResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ReportAssetFrames")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// AggregateAssetsValues aggregates the requested fields based on provided function.
func (c *restClient) AggregateAssetsValues(ctx context.Context, req *migrationcenterpb.AggregateAssetsValuesRequest, opts ...gax.CallOption) (*migrationcenterpb.AggregateAssetsValuesResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/assets:aggregateValues", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).AggregateAssetsValues[0:len((*c.CallOptions).AggregateAssetsValues):len((*c.CallOptions).AggregateAssetsValues)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.AggregateAssetsValuesResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "AggregateAssetsValues")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateImportJob creates an import job.
func (c *restClient) CreateImportJob(ctx context.Context, req *migrationcenterpb.CreateImportJobRequest, opts ...gax.CallOption) (*CreateImportJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetImportJob()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/importJobs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("importJobId", fmt.Sprintf("%v", req.GetImportJobId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateImportJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListImportJobs lists all import jobs.
func (c *restClient) ListImportJobs(ctx context.Context, req *migrationcenterpb.ListImportJobsRequest, opts ...gax.CallOption) *ImportJobIterator {
	it := &ImportJobIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListImportJobsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.ImportJob, string, error) {
		resp := &migrationcenterpb.ListImportJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/importJobs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetView() != 0 {
			params.Add("view", fmt.Sprintf("%v", req.GetView()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListImportJobs")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetImportJobs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetImportJob gets the details of an import job.
func (c *restClient) GetImportJob(ctx context.Context, req *migrationcenterpb.GetImportJobRequest, opts ...gax.CallOption) (*migrationcenterpb.ImportJob, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetImportJob[0:len((*c.CallOptions).GetImportJob):len((*c.CallOptions).GetImportJob)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.ImportJob{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetImportJob")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteImportJob deletes an import job.
func (c *restClient) DeleteImportJob(ctx context.Context, req *migrationcenterpb.DeleteImportJobRequest, opts ...gax.CallOption) (*DeleteImportJobOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteImportJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateImportJob updates an import job.
func (c *restClient) UpdateImportJob(ctx context.Context, req *migrationcenterpb.UpdateImportJobRequest, opts ...gax.CallOption) (*UpdateImportJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetImportJob()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetImportJob().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "import_job.name", url.QueryEscape(req.GetImportJob().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateImportJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ValidateImportJob validates an import job.
func (c *restClient) ValidateImportJob(ctx context.Context, req *migrationcenterpb.ValidateImportJobRequest, opts ...gax.CallOption) (*ValidateImportJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:validate", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ValidateImportJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ValidateImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RunImportJob runs an import job.
func (c *restClient) RunImportJob(ctx context.Context, req *migrationcenterpb.RunImportJobRequest, opts ...gax.CallOption) (*RunImportJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:run", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RunImportJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RunImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetImportDataFile gets an import data file.
func (c *restClient) GetImportDataFile(ctx context.Context, req *migrationcenterpb.GetImportDataFileRequest, opts ...gax.CallOption) (*migrationcenterpb.ImportDataFile, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetImportDataFile[0:len((*c.CallOptions).GetImportDataFile):len((*c.CallOptions).GetImportDataFile)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.ImportDataFile{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetImportDataFile")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListImportDataFiles list import data files.
func (c *restClient) ListImportDataFiles(ctx context.Context, req *migrationcenterpb.ListImportDataFilesRequest, opts ...gax.CallOption) *ImportDataFileIterator {
	it := &ImportDataFileIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListImportDataFilesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.ImportDataFile, string, error) {
		resp := &migrationcenterpb.ListImportDataFilesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/importDataFiles", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListImportDataFiles")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetImportDataFiles(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateImportDataFile creates an import data file.
func (c *restClient) CreateImportDataFile(ctx context.Context, req *migrationcenterpb.CreateImportDataFileRequest, opts ...gax.CallOption) (*CreateImportDataFileOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetImportDataFile()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/importDataFiles", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("importDataFileId", fmt.Sprintf("%v", req.GetImportDataFileId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateImportDataFile")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateImportDataFileOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteImportDataFile delete an import data file.
func (c *restClient) DeleteImportDataFile(ctx context.Context, req *migrationcenterpb.DeleteImportDataFileRequest, opts ...gax.CallOption) (*DeleteImportDataFileOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteImportDataFile")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteImportDataFileOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListGroups lists all groups in a given project and location.
func (c *restClient) ListGroups(ctx context.Context, req *migrationcenterpb.ListGroupsRequest, opts ...gax.CallOption) *GroupIterator {
	it := &GroupIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListGroupsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.Group, string, error) {
		resp := &migrationcenterpb.ListGroupsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/groups", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListGroups")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGroups(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetGroup gets the details of a group.
func (c *restClient) GetGroup(ctx context.Context, req *migrationcenterpb.GetGroupRequest, opts ...gax.CallOption) (*migrationcenterpb.Group, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGroup[0:len((*c.CallOptions).GetGroup):len((*c.CallOptions).GetGroup)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.Group{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetGroup")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateGroup creates a new group in a given project and location.
func (c *restClient) CreateGroup(ctx context.Context, req *migrationcenterpb.CreateGroupRequest, opts ...gax.CallOption) (*CreateGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGroup()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/groups", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("groupId", fmt.Sprintf("%v", req.GetGroupId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateGroup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateGroup updates the parameters of a group.
func (c *restClient) UpdateGroup(ctx context.Context, req *migrationcenterpb.UpdateGroupRequest, opts ...gax.CallOption) (*UpdateGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGroup()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetGroup().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group.name", url.QueryEscape(req.GetGroup().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateGroup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteGroup deletes a group.
func (c *restClient) DeleteGroup(ctx context.Context, req *migrationcenterpb.DeleteGroupRequest, opts ...gax.CallOption) (*DeleteGroupOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteGroup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// AddAssetsToGroup adds assets to a group.
func (c *restClient) AddAssetsToGroup(ctx context.Context, req *migrationcenterpb.AddAssetsToGroupRequest, opts ...gax.CallOption) (*AddAssetsToGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:addAssets", req.GetGroup())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group", url.QueryEscape(req.GetGroup()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "AddAssetsToGroup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &AddAssetsToGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RemoveAssetsFromGroup removes assets from a group.
func (c *restClient) RemoveAssetsFromGroup(ctx context.Context, req *migrationcenterpb.RemoveAssetsFromGroupRequest, opts ...gax.CallOption) (*RemoveAssetsFromGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:removeAssets", req.GetGroup())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group", url.QueryEscape(req.GetGroup()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RemoveAssetsFromGroup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RemoveAssetsFromGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListErrorFrames lists all error frames in a given source and location.
func (c *restClient) ListErrorFrames(ctx context.Context, req *migrationcenterpb.ListErrorFramesRequest, opts ...gax.CallOption) *ErrorFrameIterator {
	it := &ErrorFrameIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListErrorFramesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.ErrorFrame, string, error) {
		resp := &migrationcenterpb.ListErrorFramesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/errorFrames", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetView() != 0 {
			params.Add("view", fmt.Sprintf("%v", req.GetView()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListErrorFrames")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetErrorFrames(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetErrorFrame gets the details of an error frame.
func (c *restClient) GetErrorFrame(ctx context.Context, req *migrationcenterpb.GetErrorFrameRequest, opts ...gax.CallOption) (*migrationcenterpb.ErrorFrame, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetErrorFrame[0:len((*c.CallOptions).GetErrorFrame):len((*c.CallOptions).GetErrorFrame)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.ErrorFrame{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetErrorFrame")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListSources lists all the sources in a given project and location.
func (c *restClient) ListSources(ctx context.Context, req *migrationcenterpb.ListSourcesRequest, opts ...gax.CallOption) *SourceIterator {
	it := &SourceIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListSourcesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.Source, string, error) {
		resp := &migrationcenterpb.ListSourcesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/sources", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListSources")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSources(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetSource gets the details of a source.
func (c *restClient) GetSource(ctx context.Context, req *migrationcenterpb.GetSourceRequest, opts ...gax.CallOption) (*migrationcenterpb.Source, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSource[0:len((*c.CallOptions).GetSource):len((*c.CallOptions).GetSource)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.Source{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetSource")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateSource creates a new source in a given project and location.
func (c *restClient) CreateSource(ctx context.Context, req *migrationcenterpb.CreateSourceRequest, opts ...gax.CallOption) (*CreateSourceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSource()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/sources", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	params.Add("sourceId", fmt.Sprintf("%v", req.GetSourceId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateSource")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateSource updates the parameters of a source.
func (c *restClient) UpdateSource(ctx context.Context, req *migrationcenterpb.UpdateSourceRequest, opts ...gax.CallOption) (*UpdateSourceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSource()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSource().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "source.name", url.QueryEscape(req.GetSource().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateSource")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteSource deletes a source.
func (c *restClient) DeleteSource(ctx context.Context, req *migrationcenterpb.DeleteSourceRequest, opts ...gax.CallOption) (*DeleteSourceOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteSource")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListPreferenceSets lists all the preference sets in a given project and location.
func (c *restClient) ListPreferenceSets(ctx context.Context, req *migrationcenterpb.ListPreferenceSetsRequest, opts ...gax.CallOption) *PreferenceSetIterator {
	it := &PreferenceSetIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListPreferenceSetsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.PreferenceSet, string, error) {
		resp := &migrationcenterpb.ListPreferenceSetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/preferenceSets", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListPreferenceSets")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetPreferenceSets(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetPreferenceSet gets the details of a preference set.
func (c *restClient) GetPreferenceSet(ctx context.Context, req *migrationcenterpb.GetPreferenceSetRequest, opts ...gax.CallOption) (*migrationcenterpb.PreferenceSet, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetPreferenceSet[0:len((*c.CallOptions).GetPreferenceSet):len((*c.CallOptions).GetPreferenceSet)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.PreferenceSet{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetPreferenceSet")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreatePreferenceSet creates a new preference set in a given project and location.
func (c *restClient) CreatePreferenceSet(ctx context.Context, req *migrationcenterpb.CreatePreferenceSetRequest, opts ...gax.CallOption) (*CreatePreferenceSetOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPreferenceSet()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/preferenceSets", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("preferenceSetId", fmt.Sprintf("%v", req.GetPreferenceSetId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreatePreferenceSet")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreatePreferenceSetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdatePreferenceSet updates the parameters of a preference set.
func (c *restClient) UpdatePreferenceSet(ctx context.Context, req *migrationcenterpb.UpdatePreferenceSetRequest, opts ...gax.CallOption) (*UpdatePreferenceSetOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPreferenceSet()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetPreferenceSet().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "preference_set.name", url.QueryEscape(req.GetPreferenceSet().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdatePreferenceSet")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdatePreferenceSetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeletePreferenceSet deletes a preference set.
func (c *restClient) DeletePreferenceSet(ctx context.Context, req *migrationcenterpb.DeletePreferenceSetRequest, opts ...gax.CallOption) (*DeletePreferenceSetOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeletePreferenceSet")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeletePreferenceSetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetSettings gets the details of regional settings.
func (c *restClient) GetSettings(ctx context.Context, req *migrationcenterpb.GetSettingsRequest, opts ...gax.CallOption) (*migrationcenterpb.Settings, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSettings[0:len((*c.CallOptions).GetSettings):len((*c.CallOptions).GetSettings)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.Settings{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetSettings")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateSettings updates the regional-level project settings.
func (c *restClient) UpdateSettings(ctx context.Context, req *migrationcenterpb.UpdateSettingsRequest, opts ...gax.CallOption) (*UpdateSettingsOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSettings()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSettings().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "settings.name", url.QueryEscape(req.GetSettings().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateSettings")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateSettingsOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateReportConfig creates a report configuration.
func (c *restClient) CreateReportConfig(ctx context.Context, req *migrationcenterpb.CreateReportConfigRequest, opts ...gax.CallOption) (*CreateReportConfigOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetReportConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/reportConfigs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("reportConfigId", fmt.Sprintf("%v", req.GetReportConfigId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateReportConfig")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateReportConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetReportConfig gets details of a single ReportConfig.
func (c *restClient) GetReportConfig(ctx context.Context, req *migrationcenterpb.GetReportConfigRequest, opts ...gax.CallOption) (*migrationcenterpb.ReportConfig, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetReportConfig[0:len((*c.CallOptions).GetReportConfig):len((*c.CallOptions).GetReportConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.ReportConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetReportConfig")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListReportConfigs lists ReportConfigs in a given project and location.
func (c *restClient) ListReportConfigs(ctx context.Context, req *migrationcenterpb.ListReportConfigsRequest, opts ...gax.CallOption) *ReportConfigIterator {
	it := &ReportConfigIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListReportConfigsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.ReportConfig, string, error) {
		resp := &migrationcenterpb.ListReportConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/reportConfigs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListReportConfigs")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetReportConfigs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteReportConfig deletes a ReportConfig.
func (c *restClient) DeleteReportConfig(ctx context.Context, req *migrationcenterpb.DeleteReportConfigRequest, opts ...gax.CallOption) (*DeleteReportConfigOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteReportConfig")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteReportConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateReport creates a report.
func (c *restClient) CreateReport(ctx context.Context, req *migrationcenterpb.CreateReportRequest, opts ...gax.CallOption) (*CreateReportOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetReport()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/reports", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("reportId", fmt.Sprintf("%v", req.GetReportId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateReport")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateReportOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetReport gets details of a single Report.
func (c *restClient) GetReport(ctx context.Context, req *migrationcenterpb.GetReportRequest, opts ...gax.CallOption) (*migrationcenterpb.Report, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetReport[0:len((*c.CallOptions).GetReport):len((*c.CallOptions).GetReport)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &migrationcenterpb.Report{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetReport")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListReports lists Reports in a given ReportConfig.
func (c *restClient) ListReports(ctx context.Context, req *migrationcenterpb.ListReportsRequest, opts ...gax.CallOption) *ReportIterator {
	it := &ReportIterator{}
	req = proto.Clone(req).(*migrationcenterpb.ListReportsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*migrationcenterpb.Report, string, error) {
		resp := &migrationcenterpb.ListReportsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/reports", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetView() != 0 {
			params.Add("view", fmt.Sprintf("%v", req.GetView()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListReports")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetReports(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteReport deletes a Report.
func (c *restClient) DeleteReport(ctx context.Context, req *migrationcenterpb.DeleteReportRequest, opts ...gax.CallOption) (*DeleteReportOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteReport")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteReportOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *restClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *restClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *restClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *restClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// AddAssetsToGroupOperation returns a new AddAssetsToGroupOperation from a given name.
// The name must be that of a previously created AddAssetsToGroupOperation, possibly from a different process.
func (c *gRPCClient) AddAssetsToGroupOperation(name string) *AddAssetsToGroupOperation {
	return &AddAssetsToGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// AddAssetsToGroupOperation returns a new AddAssetsToGroupOperation from a given name.
// The name must be that of a previously created AddAssetsToGroupOperation, possibly from a different process.
func (c *restClient) AddAssetsToGroupOperation(name string) *AddAssetsToGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &AddAssetsToGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateGroupOperation returns a new CreateGroupOperation from a given name.
// The name must be that of a previously created CreateGroupOperation, possibly from a different process.
func (c *gRPCClient) CreateGroupOperation(name string) *CreateGroupOperation {
	return &CreateGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateGroupOperation returns a new CreateGroupOperation from a given name.
// The name must be that of a previously created CreateGroupOperation, possibly from a different process.
func (c *restClient) CreateGroupOperation(name string) *CreateGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateImportDataFileOperation returns a new CreateImportDataFileOperation from a given name.
// The name must be that of a previously created CreateImportDataFileOperation, possibly from a different process.
func (c *gRPCClient) CreateImportDataFileOperation(name string) *CreateImportDataFileOperation {
	return &CreateImportDataFileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateImportDataFileOperation returns a new CreateImportDataFileOperation from a given name.
// The name must be that of a previously created CreateImportDataFileOperation, possibly from a different process.
func (c *restClient) CreateImportDataFileOperation(name string) *CreateImportDataFileOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateImportDataFileOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateImportJobOperation returns a new CreateImportJobOperation from a given name.
// The name must be that of a previously created CreateImportJobOperation, possibly from a different process.
func (c *gRPCClient) CreateImportJobOperation(name string) *CreateImportJobOperation {
	return &CreateImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateImportJobOperation returns a new CreateImportJobOperation from a given name.
// The name must be that of a previously created CreateImportJobOperation, possibly from a different process.
func (c *restClient) CreateImportJobOperation(name string) *CreateImportJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreatePreferenceSetOperation returns a new CreatePreferenceSetOperation from a given name.
// The name must be that of a previously created CreatePreferenceSetOperation, possibly from a different process.
func (c *gRPCClient) CreatePreferenceSetOperation(name string) *CreatePreferenceSetOperation {
	return &CreatePreferenceSetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreatePreferenceSetOperation returns a new CreatePreferenceSetOperation from a given name.
// The name must be that of a previously created CreatePreferenceSetOperation, possibly from a different process.
func (c *restClient) CreatePreferenceSetOperation(name string) *CreatePreferenceSetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreatePreferenceSetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateReportOperation returns a new CreateReportOperation from a given name.
// The name must be that of a previously created CreateReportOperation, possibly from a different process.
func (c *gRPCClient) CreateReportOperation(name string) *CreateReportOperation {
	return &CreateReportOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateReportOperation returns a new CreateReportOperation from a given name.
// The name must be that of a previously created CreateReportOperation, possibly from a different process.
func (c *restClient) CreateReportOperation(name string) *CreateReportOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateReportOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateReportConfigOperation returns a new CreateReportConfigOperation from a given name.
// The name must be that of a previously created CreateReportConfigOperation, possibly from a different process.
func (c *gRPCClient) CreateReportConfigOperation(name string) *CreateReportConfigOperation {
	return &CreateReportConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateReportConfigOperation returns a new CreateReportConfigOperation from a given name.
// The name must be that of a previously created CreateReportConfigOperation, possibly from a different process.
func (c *restClient) CreateReportConfigOperation(name string) *CreateReportConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateReportConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateSourceOperation returns a new CreateSourceOperation from a given name.
// The name must be that of a previously created CreateSourceOperation, possibly from a different process.
func (c *gRPCClient) CreateSourceOperation(name string) *CreateSourceOperation {
	return &CreateSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateSourceOperation returns a new CreateSourceOperation from a given name.
// The name must be that of a previously created CreateSourceOperation, possibly from a different process.
func (c *restClient) CreateSourceOperation(name string) *CreateSourceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteGroupOperation returns a new DeleteGroupOperation from a given name.
// The name must be that of a previously created DeleteGroupOperation, possibly from a different process.
func (c *gRPCClient) DeleteGroupOperation(name string) *DeleteGroupOperation {
	return &DeleteGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteGroupOperation returns a new DeleteGroupOperation from a given name.
// The name must be that of a previously created DeleteGroupOperation, possibly from a different process.
func (c *restClient) DeleteGroupOperation(name string) *DeleteGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteImportDataFileOperation returns a new DeleteImportDataFileOperation from a given name.
// The name must be that of a previously created DeleteImportDataFileOperation, possibly from a different process.
func (c *gRPCClient) DeleteImportDataFileOperation(name string) *DeleteImportDataFileOperation {
	return &DeleteImportDataFileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteImportDataFileOperation returns a new DeleteImportDataFileOperation from a given name.
// The name must be that of a previously created DeleteImportDataFileOperation, possibly from a different process.
func (c *restClient) DeleteImportDataFileOperation(name string) *DeleteImportDataFileOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteImportDataFileOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteImportJobOperation returns a new DeleteImportJobOperation from a given name.
// The name must be that of a previously created DeleteImportJobOperation, possibly from a different process.
func (c *gRPCClient) DeleteImportJobOperation(name string) *DeleteImportJobOperation {
	return &DeleteImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteImportJobOperation returns a new DeleteImportJobOperation from a given name.
// The name must be that of a previously created DeleteImportJobOperation, possibly from a different process.
func (c *restClient) DeleteImportJobOperation(name string) *DeleteImportJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeletePreferenceSetOperation returns a new DeletePreferenceSetOperation from a given name.
// The name must be that of a previously created DeletePreferenceSetOperation, possibly from a different process.
func (c *gRPCClient) DeletePreferenceSetOperation(name string) *DeletePreferenceSetOperation {
	return &DeletePreferenceSetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeletePreferenceSetOperation returns a new DeletePreferenceSetOperation from a given name.
// The name must be that of a previously created DeletePreferenceSetOperation, possibly from a different process.
func (c *restClient) DeletePreferenceSetOperation(name string) *DeletePreferenceSetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeletePreferenceSetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteReportOperation returns a new DeleteReportOperation from a given name.
// The name must be that of a previously created DeleteReportOperation, possibly from a different process.
func (c *gRPCClient) DeleteReportOperation(name string) *DeleteReportOperation {
	return &DeleteReportOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteReportOperation returns a new DeleteReportOperation from a given name.
// The name must be that of a previously created DeleteReportOperation, possibly from a different process.
func (c *restClient) DeleteReportOperation(name string) *DeleteReportOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteReportOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteReportConfigOperation returns a new DeleteReportConfigOperation from a given name.
// The name must be that of a previously created DeleteReportConfigOperation, possibly from a different process.
func (c *gRPCClient) DeleteReportConfigOperation(name string) *DeleteReportConfigOperation {
	return &DeleteReportConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteReportConfigOperation returns a new DeleteReportConfigOperation from a given name.
// The name must be that of a previously created DeleteReportConfigOperation, possibly from a different process.
func (c *restClient) DeleteReportConfigOperation(name string) *DeleteReportConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteReportConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteSourceOperation returns a new DeleteSourceOperation from a given name.
// The name must be that of a previously created DeleteSourceOperation, possibly from a different process.
func (c *gRPCClient) DeleteSourceOperation(name string) *DeleteSourceOperation {
	return &DeleteSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteSourceOperation returns a new DeleteSourceOperation from a given name.
// The name must be that of a previously created DeleteSourceOperation, possibly from a different process.
func (c *restClient) DeleteSourceOperation(name string) *DeleteSourceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RemoveAssetsFromGroupOperation returns a new RemoveAssetsFromGroupOperation from a given name.
// The name must be that of a previously created RemoveAssetsFromGroupOperation, possibly from a different process.
func (c *gRPCClient) RemoveAssetsFromGroupOperation(name string) *RemoveAssetsFromGroupOperation {
	return &RemoveAssetsFromGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RemoveAssetsFromGroupOperation returns a new RemoveAssetsFromGroupOperation from a given name.
// The name must be that of a previously created RemoveAssetsFromGroupOperation, possibly from a different process.
func (c *restClient) RemoveAssetsFromGroupOperation(name string) *RemoveAssetsFromGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RemoveAssetsFromGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RunImportJobOperation returns a new RunImportJobOperation from a given name.
// The name must be that of a previously created RunImportJobOperation, possibly from a different process.
func (c *gRPCClient) RunImportJobOperation(name string) *RunImportJobOperation {
	return &RunImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RunImportJobOperation returns a new RunImportJobOperation from a given name.
// The name must be that of a previously created RunImportJobOperation, possibly from a different process.
func (c *restClient) RunImportJobOperation(name string) *RunImportJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RunImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateGroupOperation returns a new UpdateGroupOperation from a given name.
// The name must be that of a previously created UpdateGroupOperation, possibly from a different process.
func (c *gRPCClient) UpdateGroupOperation(name string) *UpdateGroupOperation {
	return &UpdateGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateGroupOperation returns a new UpdateGroupOperation from a given name.
// The name must be that of a previously created UpdateGroupOperation, possibly from a different process.
func (c *restClient) UpdateGroupOperation(name string) *UpdateGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateImportJobOperation returns a new UpdateImportJobOperation from a given name.
// The name must be that of a previously created UpdateImportJobOperation, possibly from a different process.
func (c *gRPCClient) UpdateImportJobOperation(name string) *UpdateImportJobOperation {
	return &UpdateImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateImportJobOperation returns a new UpdateImportJobOperation from a given name.
// The name must be that of a previously created UpdateImportJobOperation, possibly from a different process.
func (c *restClient) UpdateImportJobOperation(name string) *UpdateImportJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdatePreferenceSetOperation returns a new UpdatePreferenceSetOperation from a given name.
// The name must be that of a previously created UpdatePreferenceSetOperation, possibly from a different process.
func (c *gRPCClient) UpdatePreferenceSetOperation(name string) *UpdatePreferenceSetOperation {
	return &UpdatePreferenceSetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdatePreferenceSetOperation returns a new UpdatePreferenceSetOperation from a given name.
// The name must be that of a previously created UpdatePreferenceSetOperation, possibly from a different process.
func (c *restClient) UpdatePreferenceSetOperation(name string) *UpdatePreferenceSetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdatePreferenceSetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateSettingsOperation returns a new UpdateSettingsOperation from a given name.
// The name must be that of a previously created UpdateSettingsOperation, possibly from a different process.
func (c *gRPCClient) UpdateSettingsOperation(name string) *UpdateSettingsOperation {
	return &UpdateSettingsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateSettingsOperation returns a new UpdateSettingsOperation from a given name.
// The name must be that of a previously created UpdateSettingsOperation, possibly from a different process.
func (c *restClient) UpdateSettingsOperation(name string) *UpdateSettingsOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateSettingsOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateSourceOperation returns a new UpdateSourceOperation from a given name.
// The name must be that of a previously created UpdateSourceOperation, possibly from a different process.
func (c *gRPCClient) UpdateSourceOperation(name string) *UpdateSourceOperation {
	return &UpdateSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateSourceOperation returns a new UpdateSourceOperation from a given name.
// The name must be that of a previously created UpdateSourceOperation, possibly from a different process.
func (c *restClient) UpdateSourceOperation(name string) *UpdateSourceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ValidateImportJobOperation returns a new ValidateImportJobOperation from a given name.
// The name must be that of a previously created ValidateImportJobOperation, possibly from a different process.
func (c *gRPCClient) ValidateImportJobOperation(name string) *ValidateImportJobOperation {
	return &ValidateImportJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ValidateImportJobOperation returns a new ValidateImportJobOperation from a given name.
// The name must be that of a previously created ValidateImportJobOperation, possibly from a different process.
func (c *restClient) ValidateImportJobOperation(name string) *ValidateImportJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ValidateImportJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
