// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/shippingsettings.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Shipment type of shipping service.
type Service_ShipmentType int32

const (
	// This service did not specify shipment type.
	Service_SHIPMENT_TYPE_UNSPECIFIED Service_ShipmentType = 0
	// This service ships orders to an address chosen by the customer.
	Service_DELIVERY Service_ShipmentType = 1
	// This service ships orders to an address chosen by the customer.
	// The order is shipped from a local store near by.
	Service_LOCAL_DELIVERY Service_ShipmentType = 2
	// This service ships orders to an address chosen by the customer.
	// The order is shipped from a collection point.
	Service_COLLECTION_POINT Service_ShipmentType = 3
)

// Enum value maps for Service_ShipmentType.
var (
	Service_ShipmentType_name = map[int32]string{
		0: "SHIPMENT_TYPE_UNSPECIFIED",
		1: "DELIVERY",
		2: "LOCAL_DELIVERY",
		3: "COLLECTION_POINT",
	}
	Service_ShipmentType_value = map[string]int32{
		"SHIPMENT_TYPE_UNSPECIFIED": 0,
		"DELIVERY":                  1,
		"LOCAL_DELIVERY":            2,
		"COLLECTION_POINT":          3,
	}
)

func (x Service_ShipmentType) Enum() *Service_ShipmentType {
	p := new(Service_ShipmentType)
	*p = x
	return p
}

func (x Service_ShipmentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_ShipmentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes[0].Descriptor()
}

func (Service_ShipmentType) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes[0]
}

func (x Service_ShipmentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_ShipmentType.Descriptor instead.
func (Service_ShipmentType) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{1, 0}
}

// Indicates whether all stores, or selected stores, listed by the
// merchant provide local delivery.
type Service_StoreConfig_StoreServiceType int32

const (
	// Did not specify store service type.
	Service_StoreConfig_STORE_SERVICE_TYPE_UNSPECIFIED Service_StoreConfig_StoreServiceType = 0
	// Indicates whether all stores, current and future, listed by this
	// merchant provide local delivery.
	Service_StoreConfig_ALL_STORES Service_StoreConfig_StoreServiceType = 1
	// Indicates that only the stores listed in `store_codes` are eligible
	// for local delivery.
	Service_StoreConfig_SELECTED_STORES Service_StoreConfig_StoreServiceType = 2
)

// Enum value maps for Service_StoreConfig_StoreServiceType.
var (
	Service_StoreConfig_StoreServiceType_name = map[int32]string{
		0: "STORE_SERVICE_TYPE_UNSPECIFIED",
		1: "ALL_STORES",
		2: "SELECTED_STORES",
	}
	Service_StoreConfig_StoreServiceType_value = map[string]int32{
		"STORE_SERVICE_TYPE_UNSPECIFIED": 0,
		"ALL_STORES":                     1,
		"SELECTED_STORES":                2,
	}
)

func (x Service_StoreConfig_StoreServiceType) Enum() *Service_StoreConfig_StoreServiceType {
	p := new(Service_StoreConfig_StoreServiceType)
	*p = x
	return p
}

func (x Service_StoreConfig_StoreServiceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_StoreConfig_StoreServiceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes[1].Descriptor()
}

func (Service_StoreConfig_StoreServiceType) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes[1]
}

func (x Service_StoreConfig_StoreServiceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_StoreConfig_StoreServiceType.Descriptor instead.
func (Service_StoreConfig_StoreServiceType) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{1, 0, 0}
}

// Unit can differ based on country, it is parameterized to include miles
// and kilometers.
type Distance_Unit int32

const (
	// Unit unspecified
	Distance_UNIT_UNSPECIFIED Distance_Unit = 0
	// Unit in miles
	Distance_MILES Distance_Unit = 1
	// Unit in kilometers
	Distance_KILOMETERS Distance_Unit = 2
)

// Enum value maps for Distance_Unit.
var (
	Distance_Unit_name = map[int32]string{
		0: "UNIT_UNSPECIFIED",
		1: "MILES",
		2: "KILOMETERS",
	}
	Distance_Unit_value = map[string]int32{
		"UNIT_UNSPECIFIED": 0,
		"MILES":            1,
		"KILOMETERS":       2,
	}
)

func (x Distance_Unit) Enum() *Distance_Unit {
	p := new(Distance_Unit)
	*p = x
	return p
}

func (x Distance_Unit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Distance_Unit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes[2].Descriptor()
}

func (Distance_Unit) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes[2]
}

func (x Distance_Unit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Distance_Unit.Descriptor instead.
func (Distance_Unit) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{2, 0}
}

type BusinessDayConfig_Weekday int32

const (
	BusinessDayConfig_WEEKDAY_UNSPECIFIED BusinessDayConfig_Weekday = 0
	BusinessDayConfig_MONDAY              BusinessDayConfig_Weekday = 1
	BusinessDayConfig_TUESDAY             BusinessDayConfig_Weekday = 2
	BusinessDayConfig_WEDNESDAY           BusinessDayConfig_Weekday = 3
	BusinessDayConfig_THURSDAY            BusinessDayConfig_Weekday = 4
	BusinessDayConfig_FRIDAY              BusinessDayConfig_Weekday = 5
	BusinessDayConfig_SATURDAY            BusinessDayConfig_Weekday = 6
	BusinessDayConfig_SUNDAY              BusinessDayConfig_Weekday = 7
)

// Enum value maps for BusinessDayConfig_Weekday.
var (
	BusinessDayConfig_Weekday_name = map[int32]string{
		0: "WEEKDAY_UNSPECIFIED",
		1: "MONDAY",
		2: "TUESDAY",
		3: "WEDNESDAY",
		4: "THURSDAY",
		5: "FRIDAY",
		6: "SATURDAY",
		7: "SUNDAY",
	}
	BusinessDayConfig_Weekday_value = map[string]int32{
		"WEEKDAY_UNSPECIFIED": 0,
		"MONDAY":              1,
		"TUESDAY":             2,
		"WEDNESDAY":           3,
		"THURSDAY":            4,
		"FRIDAY":              5,
		"SATURDAY":            6,
		"SUNDAY":              7,
	}
)

func (x BusinessDayConfig_Weekday) Enum() *BusinessDayConfig_Weekday {
	p := new(BusinessDayConfig_Weekday)
	*p = x
	return p
}

func (x BusinessDayConfig_Weekday) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BusinessDayConfig_Weekday) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes[3].Descriptor()
}

func (BusinessDayConfig_Weekday) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes[3]
}

func (x BusinessDayConfig_Weekday) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BusinessDayConfig_Weekday.Descriptor instead.
func (BusinessDayConfig_Weekday) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{8, 0}
}

// The merchant account's [shipping
// setting](https://support.google.com/merchants/answer/6069284).
type ShippingSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the shipping setting.
	// Format: `accounts/{account}/shippingSetting`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The target account's list of services.
	Services []*Service `protobuf:"bytes,2,rep,name=services,proto3" json:"services,omitempty"`
	// Optional. A list of warehouses which can be referred to in `services`.
	Warehouses []*Warehouse `protobuf:"bytes,3,rep,name=warehouses,proto3" json:"warehouses,omitempty"`
	// Required. This field is used for avoid async issue. Make sure shipping
	// setting data
	//
	//	didn't change between get call and insert call. The user should do
	//	following steps：
	//
	// 1. Set etag field as empty string for initial shipping setting creation.
	//
	// 2. After initial creation, call get method to obtain an etag and current
	// shipping setting data before call insert.
	//
	// 3. Modify to wanted shipping setting information.
	//
	// 4. Call insert method with the wanted shipping setting information with
	// the etag obtained from step 2.
	//
	// 5. If shipping setting data changed between step 2 and step 4. Insert
	// request will fail because the etag changes every time the shipping setting
	// data changes. User should repeate step 2-4 with the new etag.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *ShippingSettings) Reset() {
	*x = ShippingSettings{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShippingSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShippingSettings) ProtoMessage() {}

func (x *ShippingSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShippingSettings.ProtoReflect.Descriptor instead.
func (*ShippingSettings) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{0}
}

func (x *ShippingSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ShippingSettings) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *ShippingSettings) GetWarehouses() []*Warehouse {
	if x != nil {
		return x.Warehouses
	}
	return nil
}

func (x *ShippingSettings) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Shipping service.
type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Free-form name of the service. Must be unique within target
	// account.
	ServiceName *string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3,oneof" json:"service_name,omitempty"`
	// Required. A boolean exposing the active status of the shipping service.
	Active *bool `protobuf:"varint,2,opt,name=active,proto3,oneof" json:"active,omitempty"`
	// Required. The CLDR territory code of the countries to which the service
	// applies.
	DeliveryCountries []string `protobuf:"bytes,3,rep,name=delivery_countries,json=deliveryCountries,proto3" json:"delivery_countries,omitempty"`
	// The CLDR code of the currency to which this service applies. Must match
	// that of the prices in rate groups.
	CurrencyCode *string `protobuf:"bytes,4,opt,name=currency_code,json=currencyCode,proto3,oneof" json:"currency_code,omitempty"`
	// Required. Time spent in various aspects from order to the delivery of the
	// product.
	DeliveryTime *DeliveryTime `protobuf:"bytes,5,opt,name=delivery_time,json=deliveryTime,proto3,oneof" json:"delivery_time,omitempty"`
	// Optional. Shipping rate group definitions. Only the last one is allowed to
	// have an empty `applicable_shipping_labels`, which means "everything else".
	// The other `applicable_shipping_labels` must not overlap.
	RateGroups []*RateGroup `protobuf:"bytes,6,rep,name=rate_groups,json=rateGroups,proto3" json:"rate_groups,omitempty"`
	// Type of locations this service ships orders to.
	ShipmentType *Service_ShipmentType `protobuf:"varint,7,opt,name=shipment_type,json=shipmentType,proto3,enum=google.shopping.merchant.accounts.v1beta.Service_ShipmentType,oneof" json:"shipment_type,omitempty"`
	// Minimum order value for this service. If set, indicates that customers
	// will have to spend at least this amount.
	// All prices within a service must have the same currency.
	// Cannot be set together with minimum_order_value_table.
	MinimumOrderValue *typepb.Price `protobuf:"bytes,8,opt,name=minimum_order_value,json=minimumOrderValue,proto3,oneof" json:"minimum_order_value,omitempty"`
	// Table of per store minimum order values for the pickup fulfillment type.
	// Cannot be set together with minimum_order_value.
	MinimumOrderValueTable *MinimumOrderValueTable `protobuf:"bytes,9,opt,name=minimum_order_value_table,json=minimumOrderValueTable,proto3,oneof" json:"minimum_order_value_table,omitempty"`
	// A list of stores your products are delivered from.
	// This is only valid for the local delivery shipment type.
	StoreConfig *Service_StoreConfig `protobuf:"bytes,10,opt,name=store_config,json=storeConfig,proto3,oneof" json:"store_config,omitempty"`
	// Optional. Loyalty programs that this shipping service is limited to.
	LoyaltyPrograms []*Service_LoyaltyProgram `protobuf:"bytes,11,rep,name=loyalty_programs,json=loyaltyPrograms,proto3" json:"loyalty_programs,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{1}
}

func (x *Service) GetServiceName() string {
	if x != nil && x.ServiceName != nil {
		return *x.ServiceName
	}
	return ""
}

func (x *Service) GetActive() bool {
	if x != nil && x.Active != nil {
		return *x.Active
	}
	return false
}

func (x *Service) GetDeliveryCountries() []string {
	if x != nil {
		return x.DeliveryCountries
	}
	return nil
}

func (x *Service) GetCurrencyCode() string {
	if x != nil && x.CurrencyCode != nil {
		return *x.CurrencyCode
	}
	return ""
}

func (x *Service) GetDeliveryTime() *DeliveryTime {
	if x != nil {
		return x.DeliveryTime
	}
	return nil
}

func (x *Service) GetRateGroups() []*RateGroup {
	if x != nil {
		return x.RateGroups
	}
	return nil
}

func (x *Service) GetShipmentType() Service_ShipmentType {
	if x != nil && x.ShipmentType != nil {
		return *x.ShipmentType
	}
	return Service_SHIPMENT_TYPE_UNSPECIFIED
}

func (x *Service) GetMinimumOrderValue() *typepb.Price {
	if x != nil {
		return x.MinimumOrderValue
	}
	return nil
}

func (x *Service) GetMinimumOrderValueTable() *MinimumOrderValueTable {
	if x != nil {
		return x.MinimumOrderValueTable
	}
	return nil
}

func (x *Service) GetStoreConfig() *Service_StoreConfig {
	if x != nil {
		return x.StoreConfig
	}
	return nil
}

func (x *Service) GetLoyaltyPrograms() []*Service_LoyaltyProgram {
	if x != nil {
		return x.LoyaltyPrograms
	}
	return nil
}

// Maximum delivery radius.
// This is only required for the local delivery shipment type.
type Distance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Integer value of distance.
	Value *int64 `protobuf:"varint,1,opt,name=value,proto3,oneof" json:"value,omitempty"`
	// Unit can differ based on country, it is parameterized to include miles
	// and kilometers.
	Unit *Distance_Unit `protobuf:"varint,2,opt,name=unit,proto3,enum=google.shopping.merchant.accounts.v1beta.Distance_Unit,oneof" json:"unit,omitempty"`
}

func (x *Distance) Reset() {
	*x = Distance{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Distance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distance) ProtoMessage() {}

func (x *Distance) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distance.ProtoReflect.Descriptor instead.
func (*Distance) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{2}
}

func (x *Distance) GetValue() int64 {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return 0
}

func (x *Distance) GetUnit() Distance_Unit {
	if x != nil && x.Unit != nil {
		return *x.Unit
	}
	return Distance_UNIT_UNSPECIFIED
}

// A fulfillment warehouse, which stores and handles inventory.
// Next tag: 7
type Warehouse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the warehouse. Must be unique within account.
	Name *string `protobuf:"bytes,1,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Required. Shipping address of the warehouse.
	ShippingAddress *Address `protobuf:"bytes,2,opt,name=shipping_address,json=shippingAddress,proto3,oneof" json:"shipping_address,omitempty"`
	// Required. The latest time of day that an order can be accepted and begin
	// processing. Later orders will be processed in the next day. The time is
	// based on the warehouse postal code.
	CutoffTime *WarehouseCutoffTime `protobuf:"bytes,3,opt,name=cutoff_time,json=cutoffTime,proto3,oneof" json:"cutoff_time,omitempty"`
	// Required. The number of days it takes for this warehouse to pack up and
	// ship an item. This is on the warehouse level, but can be overridden on the
	// offer level based on the attributes of an item.
	HandlingDays *int64 `protobuf:"varint,4,opt,name=handling_days,json=handlingDays,proto3,oneof" json:"handling_days,omitempty"`
	// Business days of the warehouse.
	// If not set, will be Monday to Friday by default.
	BusinessDayConfig *BusinessDayConfig `protobuf:"bytes,5,opt,name=business_day_config,json=businessDayConfig,proto3,oneof" json:"business_day_config,omitempty"`
}

func (x *Warehouse) Reset() {
	*x = Warehouse{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Warehouse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Warehouse) ProtoMessage() {}

func (x *Warehouse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Warehouse.ProtoReflect.Descriptor instead.
func (*Warehouse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{3}
}

func (x *Warehouse) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Warehouse) GetShippingAddress() *Address {
	if x != nil {
		return x.ShippingAddress
	}
	return nil
}

func (x *Warehouse) GetCutoffTime() *WarehouseCutoffTime {
	if x != nil {
		return x.CutoffTime
	}
	return nil
}

func (x *Warehouse) GetHandlingDays() int64 {
	if x != nil && x.HandlingDays != nil {
		return *x.HandlingDays
	}
	return 0
}

func (x *Warehouse) GetBusinessDayConfig() *BusinessDayConfig {
	if x != nil {
		return x.BusinessDayConfig
	}
	return nil
}

// The latest time of day that an order can be accepted and begin processing.
// Later orders will be processed in the next day. The time is based on the
// warehouse postal code.
type WarehouseCutoffTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hour of the cutoff time until which an order has to be placed to
	// be processed in the same day by the warehouse. Hour is based on the
	// timezone of warehouse.
	Hour *int32 `protobuf:"varint,1,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
	// Required. Minute of the cutoff time until which an order has to be placed
	// to be processed in the same day by the warehouse. Minute is based on the
	// timezone of warehouse.
	Minute *int32 `protobuf:"varint,2,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
}

func (x *WarehouseCutoffTime) Reset() {
	*x = WarehouseCutoffTime{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WarehouseCutoffTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WarehouseCutoffTime) ProtoMessage() {}

func (x *WarehouseCutoffTime) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WarehouseCutoffTime.ProtoReflect.Descriptor instead.
func (*WarehouseCutoffTime) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{4}
}

func (x *WarehouseCutoffTime) GetHour() int32 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

func (x *WarehouseCutoffTime) GetMinute() int32 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

// Shipping address of the warehouse.
type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Street-level part of the address. For example: `111w 31st Street`.
	StreetAddress *string `protobuf:"bytes,1,opt,name=street_address,json=streetAddress,proto3,oneof" json:"street_address,omitempty"`
	// Required. City, town or commune. May also include dependent localities or
	// sublocalities (For example neighborhoods or suburbs).
	City *string `protobuf:"bytes,2,opt,name=city,proto3,oneof" json:"city,omitempty"`
	// Required. Top-level administrative subdivision of the country. For example,
	// a state like California ("CA") or a province like Quebec ("QC").
	AdministrativeArea *string `protobuf:"bytes,3,opt,name=administrative_area,json=administrativeArea,proto3,oneof" json:"administrative_area,omitempty"`
	// Required. Postal code or ZIP (For example "94043").
	PostalCode *string `protobuf:"bytes,4,opt,name=postal_code,json=postalCode,proto3,oneof" json:"postal_code,omitempty"`
	// Required. [CLDR country
	// code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	// (For example "US").
	RegionCode *string `protobuf:"bytes,5,opt,name=region_code,json=regionCode,proto3,oneof" json:"region_code,omitempty"`
}

func (x *Address) Reset() {
	*x = Address{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{5}
}

func (x *Address) GetStreetAddress() string {
	if x != nil && x.StreetAddress != nil {
		return *x.StreetAddress
	}
	return ""
}

func (x *Address) GetCity() string {
	if x != nil && x.City != nil {
		return *x.City
	}
	return ""
}

func (x *Address) GetAdministrativeArea() string {
	if x != nil && x.AdministrativeArea != nil {
		return *x.AdministrativeArea
	}
	return ""
}

func (x *Address) GetPostalCode() string {
	if x != nil && x.PostalCode != nil {
		return *x.PostalCode
	}
	return ""
}

func (x *Address) GetRegionCode() string {
	if x != nil && x.RegionCode != nil {
		return *x.RegionCode
	}
	return ""
}

// Time spent in various aspects from order to the delivery of the product.
type DeliveryTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum number of business days that is spent in transit. 0 means same
	// day delivery, 1 means next day delivery.
	// Either `min_transit_days`, `max_transit_days` or
	// `transit_time_table` must be set, but not both.
	MinTransitDays *int32 `protobuf:"varint,1,opt,name=min_transit_days,json=minTransitDays,proto3,oneof" json:"min_transit_days,omitempty"`
	// Maximum number of business days that is spent in transit. 0 means same
	// day delivery, 1 means next day delivery. Must be greater than or equal
	// to `min_transit_days`.
	MaxTransitDays *int32 `protobuf:"varint,2,opt,name=max_transit_days,json=maxTransitDays,proto3,oneof" json:"max_transit_days,omitempty"`
	// Business days cutoff time definition.
	// If not configured the cutoff time will be defaulted to 8AM PST.
	CutoffTime *CutoffTime `protobuf:"bytes,3,opt,name=cutoff_time,json=cutoffTime,proto3,oneof" json:"cutoff_time,omitempty"`
	// Minimum number of business days spent before an order is shipped.
	// 0 means same day shipped, 1 means next day shipped.
	// 'min_handling_days' and 'max_handling_days' should be either set or not set
	// at the same time.
	MinHandlingDays *int32 `protobuf:"varint,4,opt,name=min_handling_days,json=minHandlingDays,proto3,oneof" json:"min_handling_days,omitempty"`
	// Maximum number of business days spent before an order is shipped.
	// 0 means same day shipped, 1 means next day shipped.
	// Must be greater than or equal to `min_handling_days`.
	// 'min_handling_days' and 'max_handling_days' should be either set or not set
	// at the same time.
	MaxHandlingDays *int32 `protobuf:"varint,5,opt,name=max_handling_days,json=maxHandlingDays,proto3,oneof" json:"max_handling_days,omitempty"`
	// Transit time table, number of business days spent in transit based on row
	// and column dimensions. Either `min_transit_days`, `max_transit_days` or
	// `transit_time_table` can be set, but not both.
	TransitTimeTable *TransitTable `protobuf:"bytes,6,opt,name=transit_time_table,json=transitTimeTable,proto3,oneof" json:"transit_time_table,omitempty"`
	// The business days during which orders can be handled.
	// If not provided, Monday to Friday business days will be assumed.
	HandlingBusinessDayConfig *BusinessDayConfig `protobuf:"bytes,7,opt,name=handling_business_day_config,json=handlingBusinessDayConfig,proto3,oneof" json:"handling_business_day_config,omitempty"`
	// The business days during which orders can be in-transit.
	// If not provided, Monday to Friday business days will be assumed.
	TransitBusinessDayConfig *BusinessDayConfig `protobuf:"bytes,8,opt,name=transit_business_day_config,json=transitBusinessDayConfig,proto3,oneof" json:"transit_business_day_config,omitempty"`
	// Optional. Indicates that the delivery time should be calculated per
	// warehouse (shipping origin location) based on the settings of the selected
	// carrier. When set, no other transit time related field in [delivery
	// time][[google.shopping.content.bundles.ShippingSetting.DeliveryTime] should
	// be set.
	WarehouseBasedDeliveryTimes []*WarehouseBasedDeliveryTime `protobuf:"bytes,9,rep,name=warehouse_based_delivery_times,json=warehouseBasedDeliveryTimes,proto3" json:"warehouse_based_delivery_times,omitempty"`
}

func (x *DeliveryTime) Reset() {
	*x = DeliveryTime{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeliveryTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeliveryTime) ProtoMessage() {}

func (x *DeliveryTime) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeliveryTime.ProtoReflect.Descriptor instead.
func (*DeliveryTime) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{6}
}

func (x *DeliveryTime) GetMinTransitDays() int32 {
	if x != nil && x.MinTransitDays != nil {
		return *x.MinTransitDays
	}
	return 0
}

func (x *DeliveryTime) GetMaxTransitDays() int32 {
	if x != nil && x.MaxTransitDays != nil {
		return *x.MaxTransitDays
	}
	return 0
}

func (x *DeliveryTime) GetCutoffTime() *CutoffTime {
	if x != nil {
		return x.CutoffTime
	}
	return nil
}

func (x *DeliveryTime) GetMinHandlingDays() int32 {
	if x != nil && x.MinHandlingDays != nil {
		return *x.MinHandlingDays
	}
	return 0
}

func (x *DeliveryTime) GetMaxHandlingDays() int32 {
	if x != nil && x.MaxHandlingDays != nil {
		return *x.MaxHandlingDays
	}
	return 0
}

func (x *DeliveryTime) GetTransitTimeTable() *TransitTable {
	if x != nil {
		return x.TransitTimeTable
	}
	return nil
}

func (x *DeliveryTime) GetHandlingBusinessDayConfig() *BusinessDayConfig {
	if x != nil {
		return x.HandlingBusinessDayConfig
	}
	return nil
}

func (x *DeliveryTime) GetTransitBusinessDayConfig() *BusinessDayConfig {
	if x != nil {
		return x.TransitBusinessDayConfig
	}
	return nil
}

func (x *DeliveryTime) GetWarehouseBasedDeliveryTimes() []*WarehouseBasedDeliveryTime {
	if x != nil {
		return x.WarehouseBasedDeliveryTimes
	}
	return nil
}

// Business days cutoff time definition.
type CutoffTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hour of the cutoff time until which an order has to be placed to
	// be processed in the same day.
	Hour *int32 `protobuf:"varint,1,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
	// Required. Minute of the cutoff time until which an order has to be placed
	// to be processed in the same day.
	Minute *int32 `protobuf:"varint,2,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
	// Required. [Timezone
	// identifier](https://developers.google.com/adwords/api/docs/appendix/codes-formats#timezone-ids)
	// For example "Europe/Zurich".
	TimeZone *string `protobuf:"bytes,3,opt,name=time_zone,json=timeZone,proto3,oneof" json:"time_zone,omitempty"`
}

func (x *CutoffTime) Reset() {
	*x = CutoffTime{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CutoffTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CutoffTime) ProtoMessage() {}

func (x *CutoffTime) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CutoffTime.ProtoReflect.Descriptor instead.
func (*CutoffTime) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{7}
}

func (x *CutoffTime) GetHour() int32 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

func (x *CutoffTime) GetMinute() int32 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

func (x *CutoffTime) GetTimeZone() string {
	if x != nil && x.TimeZone != nil {
		return *x.TimeZone
	}
	return ""
}

// Business days of the warehouse.
type BusinessDayConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Regular business days.
	// May not be empty.
	BusinessDays []BusinessDayConfig_Weekday `protobuf:"varint,1,rep,packed,name=business_days,json=businessDays,proto3,enum=google.shopping.merchant.accounts.v1beta.BusinessDayConfig_Weekday" json:"business_days,omitempty"`
}

func (x *BusinessDayConfig) Reset() {
	*x = BusinessDayConfig{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BusinessDayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BusinessDayConfig) ProtoMessage() {}

func (x *BusinessDayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BusinessDayConfig.ProtoReflect.Descriptor instead.
func (*BusinessDayConfig) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{8}
}

func (x *BusinessDayConfig) GetBusinessDays() []BusinessDayConfig_Weekday {
	if x != nil {
		return x.BusinessDays
	}
	return nil
}

// Indicates that the delivery time should be calculated per warehouse
// (shipping origin location) based on the settings of the selected carrier.
// When set, no other transit time related field in `delivery_time` should be
// set.
type WarehouseBasedDeliveryTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Carrier, such as `"UPS"` or `"Fedex"`.
	Carrier *string `protobuf:"bytes,1,opt,name=carrier,proto3,oneof" json:"carrier,omitempty"`
	// Required. Carrier service, such as `"ground"` or `"2 days"`. The name of
	// the service must be in the eddSupportedServices list.
	CarrierService *string `protobuf:"bytes,2,opt,name=carrier_service,json=carrierService,proto3,oneof" json:"carrier_service,omitempty"`
	// Required. Warehouse name. This should match
	// [warehouse][ShippingSetting.warehouses.name]
	Warehouse *string `protobuf:"bytes,3,opt,name=warehouse,proto3,oneof" json:"warehouse,omitempty"`
}

func (x *WarehouseBasedDeliveryTime) Reset() {
	*x = WarehouseBasedDeliveryTime{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WarehouseBasedDeliveryTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WarehouseBasedDeliveryTime) ProtoMessage() {}

func (x *WarehouseBasedDeliveryTime) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WarehouseBasedDeliveryTime.ProtoReflect.Descriptor instead.
func (*WarehouseBasedDeliveryTime) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{9}
}

func (x *WarehouseBasedDeliveryTime) GetCarrier() string {
	if x != nil && x.Carrier != nil {
		return *x.Carrier
	}
	return ""
}

func (x *WarehouseBasedDeliveryTime) GetCarrierService() string {
	if x != nil && x.CarrierService != nil {
		return *x.CarrierService
	}
	return ""
}

func (x *WarehouseBasedDeliveryTime) GetWarehouse() string {
	if x != nil && x.Warehouse != nil {
		return *x.Warehouse
	}
	return ""
}

// Shipping rate group definitions. Only the last one is allowed to have an
// empty `applicable_shipping_labels`, which means
// "everything else". The other `applicable_shipping_labels` must
// not overlap.
type RateGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of [shipping
	// labels](https://support.google.com/merchants/answer/6324504) defining the
	// products to which this rate group applies to. This is a disjunction: only
	// one of the labels has to match for the rate group to apply. May only be
	// empty for the last rate group of a service.
	ApplicableShippingLabels []string `protobuf:"bytes,1,rep,name=applicable_shipping_labels,json=applicableShippingLabels,proto3" json:"applicable_shipping_labels,omitempty"`
	// The value of the rate group (For example flat rate $10). Can only be set
	// if `main_table` and `subtables` are not set.
	SingleValue *Value `protobuf:"bytes,2,opt,name=single_value,json=singleValue,proto3,oneof" json:"single_value,omitempty"`
	// A table defining the rate group, when `single_value` is not
	// expressive enough. Can only be set if `single_value` is not
	// set.
	MainTable *Table `protobuf:"bytes,3,opt,name=main_table,json=mainTable,proto3,oneof" json:"main_table,omitempty"`
	// Optional. A list of subtables referred to by `main_table`. Can only
	// be set if `main_table` is set.
	Subtables []*Table `protobuf:"bytes,4,rep,name=subtables,proto3" json:"subtables,omitempty"`
	// Optional. A list of carrier rates that can be referred to by
	// `main_table` or `single_value`.
	CarrierRates []*CarrierRate `protobuf:"bytes,5,rep,name=carrier_rates,json=carrierRates,proto3" json:"carrier_rates,omitempty"`
	// Optional. Name of the rate group.
	// If set has to be unique within shipping service.
	Name *string `protobuf:"bytes,6,opt,name=name,proto3,oneof" json:"name,omitempty"`
}

func (x *RateGroup) Reset() {
	*x = RateGroup{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RateGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateGroup) ProtoMessage() {}

func (x *RateGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateGroup.ProtoReflect.Descriptor instead.
func (*RateGroup) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{10}
}

func (x *RateGroup) GetApplicableShippingLabels() []string {
	if x != nil {
		return x.ApplicableShippingLabels
	}
	return nil
}

func (x *RateGroup) GetSingleValue() *Value {
	if x != nil {
		return x.SingleValue
	}
	return nil
}

func (x *RateGroup) GetMainTable() *Table {
	if x != nil {
		return x.MainTable
	}
	return nil
}

func (x *RateGroup) GetSubtables() []*Table {
	if x != nil {
		return x.Subtables
	}
	return nil
}

func (x *RateGroup) GetCarrierRates() []*CarrierRate {
	if x != nil {
		return x.CarrierRates
	}
	return nil
}

func (x *RateGroup) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

// A table defining the rate group, when `single_value` is not
// expressive enough.
type Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the table. Required for subtables, ignored for the main table.
	Name *string `protobuf:"bytes,1,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Required. Headers of the table's rows.
	RowHeaders *Headers `protobuf:"bytes,2,opt,name=row_headers,json=rowHeaders,proto3,oneof" json:"row_headers,omitempty"`
	// Headers of the table's columns. Optional: if not set then the table has
	// only one dimension.
	ColumnHeaders *Headers `protobuf:"bytes,3,opt,name=column_headers,json=columnHeaders,proto3,oneof" json:"column_headers,omitempty"`
	// Required. The list of rows that constitute the table. Must have the same
	// length as `row_headers`.
	Rows []*Row `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *Table) Reset() {
	*x = Table{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table) ProtoMessage() {}

func (x *Table) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table.ProtoReflect.Descriptor instead.
func (*Table) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{11}
}

func (x *Table) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Table) GetRowHeaders() *Headers {
	if x != nil {
		return x.RowHeaders
	}
	return nil
}

func (x *Table) GetColumnHeaders() *Headers {
	if x != nil {
		return x.ColumnHeaders
	}
	return nil
}

func (x *Table) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

// Transit time table, number of business days spent in transit based on row
// and column dimensions. Either `min_transit_days`, `max_transit_days` or
// `transit_time_table` can be set, but not both.
type TransitTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of region names
	// [Region.name][google.shopping.merchant.accounts.v1beta.Region.name] . The
	// last value can be
	// `"all other locations"`. Example:
	// `["zone 1", "zone 2", "all other locations"]`. The referred
	// postal code groups must match the delivery country of the service.
	PostalCodeGroupNames []string `protobuf:"bytes,1,rep,name=postal_code_group_names,json=postalCodeGroupNames,proto3" json:"postal_code_group_names,omitempty"`
	// Required. A list of transit time labels. The last value can be
	// `"all other labels"`. Example:
	// `["food", "electronics", "all other labels"]`.
	TransitTimeLabels []string `protobuf:"bytes,2,rep,name=transit_time_labels,json=transitTimeLabels,proto3" json:"transit_time_labels,omitempty"`
	// Required. If there's only one dimension set of `postal_code_group_names` or
	// `transit_time_labels`, there are multiple rows each with one value
	// for that dimension. If there are two dimensions, each row corresponds to a
	// `postal_code_group_names`, and columns (values) to a
	// `transit_time_labels`.
	Rows []*TransitTable_TransitTimeRow `protobuf:"bytes,3,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *TransitTable) Reset() {
	*x = TransitTable{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransitTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitTable) ProtoMessage() {}

func (x *TransitTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitTable.ProtoReflect.Descriptor instead.
func (*TransitTable) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{12}
}

func (x *TransitTable) GetPostalCodeGroupNames() []string {
	if x != nil {
		return x.PostalCodeGroupNames
	}
	return nil
}

func (x *TransitTable) GetTransitTimeLabels() []string {
	if x != nil {
		return x.TransitTimeLabels
	}
	return nil
}

func (x *TransitTable) GetRows() []*TransitTable_TransitTimeRow {
	if x != nil {
		return x.Rows
	}
	return nil
}

// Table of per store minimum order values for the pickup fulfillment type.
type MinimumOrderValueTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of store code sets sharing the same minimum order value
	// (MOV). At least two sets are required and the last one must be empty, which
	// signifies 'MOV for all other stores'. Each store code can only appear once
	// across all the sets. All prices within a service must have the same
	// currency.
	StoreCodeSetWithMovs []*MinimumOrderValueTable_StoreCodeSetWithMov `protobuf:"bytes,1,rep,name=store_code_set_with_movs,json=storeCodeSetWithMovs,proto3" json:"store_code_set_with_movs,omitempty"`
}

func (x *MinimumOrderValueTable) Reset() {
	*x = MinimumOrderValueTable{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MinimumOrderValueTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MinimumOrderValueTable) ProtoMessage() {}

func (x *MinimumOrderValueTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MinimumOrderValueTable.ProtoReflect.Descriptor instead.
func (*MinimumOrderValueTable) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{13}
}

func (x *MinimumOrderValueTable) GetStoreCodeSetWithMovs() []*MinimumOrderValueTable_StoreCodeSetWithMov {
	if x != nil {
		return x.StoreCodeSetWithMovs
	}
	return nil
}

// A non-empty list of row or column headers for a table.
// Exactly one of `prices`, `weights`,
// `num_items`, `postal_code_group_names`, or
// `location` must be set.
type Headers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of inclusive order price upper bounds. The last price's
	// value can be infinity by setting price amount_micros = -1. For example
	// `[{"amount_micros": 10000000, "currency_code": "USD"},
	// {"amount_micros": 500000000, "currency_code": "USD"},
	// {"amount_micros": -1, "currency_code": "USD"}]` represents the headers
	// "<= $10", "<= $500", and "> $500". All prices within a service must have
	// the same currency. Must be non-empty. Must be positive except -1. Can only
	// be set if all other fields are not set.
	Prices []*typepb.Price `protobuf:"bytes,1,rep,name=prices,proto3" json:"prices,omitempty"`
	// Required. A list of inclusive order weight upper bounds. The last weight's
	// value can be infinity by setting price amount_micros = -1. For example
	// `[{"amount_micros": 10000000, "unit": "kg"}, {"amount_micros": 50000000,
	// "unit": "kg"},
	// {"amount_micros": -1, "unit": "kg"}]` represents the headers
	// "<= 10kg", "<= 50kg", and "> 50kg". All weights within a service must have
	// the same unit. Must be non-empty. Must be positive except -1. Can only be
	// set if all other fields are not set.
	Weights []*typepb.Weight `protobuf:"bytes,2,rep,name=weights,proto3" json:"weights,omitempty"`
	// Required. A list of inclusive number of items upper bounds. The last value
	// can be
	// `"infinity"`. For example
	// `["10", "50", "infinity"]` represents the headers
	// "<= 10 items", "<= 50 items", and "> 50 items". Must be non-empty. Can
	// only be set if all other fields are not set.
	NumberOfItems []string `protobuf:"bytes,3,rep,name=number_of_items,json=numberOfItems,proto3" json:"number_of_items,omitempty"`
	// Required. A list of postal group names. The last value can be
	// `"all other locations"`. Example:
	// `["zone 1", "zone 2", "all other locations"]`. The referred
	// postal code groups must match the delivery country of the service. Must
	// be non-empty. Can only be set if all other fields are not set.
	PostalCodeGroupNames []string `protobuf:"bytes,4,rep,name=postal_code_group_names,json=postalCodeGroupNames,proto3" json:"postal_code_group_names,omitempty"`
	// Required. A list of location ID sets. Must be non-empty. Can only be set if
	// all other fields are not set.
	Locations []*LocationIdSet `protobuf:"bytes,5,rep,name=locations,proto3" json:"locations,omitempty"`
}

func (x *Headers) Reset() {
	*x = Headers{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Headers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Headers) ProtoMessage() {}

func (x *Headers) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Headers.ProtoReflect.Descriptor instead.
func (*Headers) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{14}
}

func (x *Headers) GetPrices() []*typepb.Price {
	if x != nil {
		return x.Prices
	}
	return nil
}

func (x *Headers) GetWeights() []*typepb.Weight {
	if x != nil {
		return x.Weights
	}
	return nil
}

func (x *Headers) GetNumberOfItems() []string {
	if x != nil {
		return x.NumberOfItems
	}
	return nil
}

func (x *Headers) GetPostalCodeGroupNames() []string {
	if x != nil {
		return x.PostalCodeGroupNames
	}
	return nil
}

func (x *Headers) GetLocations() []*LocationIdSet {
	if x != nil {
		return x.Locations
	}
	return nil
}

// A list of location ID sets. Must be non-empty. Can only be set if all
// other fields are not set.
type LocationIdSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A non-empty list of
	// [location
	// IDs](https://developers.google.com/adwords/api/docs/appendix/geotargeting).
	// They must all be of the same location type (For
	// example, state).
	LocationIds []string `protobuf:"bytes,1,rep,name=location_ids,json=locationIds,proto3" json:"location_ids,omitempty"`
}

func (x *LocationIdSet) Reset() {
	*x = LocationIdSet{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationIdSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationIdSet) ProtoMessage() {}

func (x *LocationIdSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationIdSet.ProtoReflect.Descriptor instead.
func (*LocationIdSet) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{15}
}

func (x *LocationIdSet) GetLocationIds() []string {
	if x != nil {
		return x.LocationIds
	}
	return nil
}

// Include a list of cells.
type Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of cells that constitute the row. Must have the same
	// length as `columnHeaders` for two-dimensional tables, a length of 1 for
	// one-dimensional tables.
	Cells []*Value `protobuf:"bytes,1,rep,name=cells,proto3" json:"cells,omitempty"`
}

func (x *Row) Reset() {
	*x = Row{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Row.ProtoReflect.Descriptor instead.
func (*Row) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{16}
}

func (x *Row) GetCells() []*Value {
	if x != nil {
		return x.Cells
	}
	return nil
}

// The single value of a rate group or the value of a rate group table's cell.
// Exactly one of `no_shipping`, `flat_rate`,
// `price_percentage`, `carrier_rateName`,
// `subtable_name` must be set.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, then the product can't be shipped. Must be true when set, can only
	// be set if all other fields are not set.
	NoShipping *bool `protobuf:"varint,1,opt,name=no_shipping,json=noShipping,proto3,oneof" json:"no_shipping,omitempty"`
	// A flat rate. Can only be set if all other fields are not set.
	FlatRate *typepb.Price `protobuf:"bytes,2,opt,name=flat_rate,json=flatRate,proto3,oneof" json:"flat_rate,omitempty"`
	// A percentage of the price represented as a number in decimal notation
	// (For example, `"5.4"`). Can only be set if all other fields are not
	// set.
	PricePercentage *string `protobuf:"bytes,3,opt,name=price_percentage,json=pricePercentage,proto3,oneof" json:"price_percentage,omitempty"`
	// The name of a carrier rate referring to a carrier rate defined in the
	// same rate group. Can only be set if all other fields are not set.
	CarrierRate *string `protobuf:"bytes,4,opt,name=carrier_rate,json=carrierRate,proto3,oneof" json:"carrier_rate,omitempty"`
	// The name of a subtable. Can only be set in table cells (For example, not
	// for single values), and only if all other fields are not set.
	Subtable *string `protobuf:"bytes,5,opt,name=subtable,proto3,oneof" json:"subtable,omitempty"`
}

func (x *Value) Reset() {
	*x = Value{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{17}
}

func (x *Value) GetNoShipping() bool {
	if x != nil && x.NoShipping != nil {
		return *x.NoShipping
	}
	return false
}

func (x *Value) GetFlatRate() *typepb.Price {
	if x != nil {
		return x.FlatRate
	}
	return nil
}

func (x *Value) GetPricePercentage() string {
	if x != nil && x.PricePercentage != nil {
		return *x.PricePercentage
	}
	return ""
}

func (x *Value) GetCarrierRate() string {
	if x != nil && x.CarrierRate != nil {
		return *x.CarrierRate
	}
	return ""
}

func (x *Value) GetSubtable() string {
	if x != nil && x.Subtable != nil {
		return *x.Subtable
	}
	return ""
}

// A list of carrier rates that can be referred to by
// `main_table` or `single_value`.
type CarrierRate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the carrier rate. Must be unique per rate group.
	Name *string `protobuf:"bytes,1,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Required. Carrier service, such as `"UPS"` or `"Fedex"`.
	Carrier *string `protobuf:"bytes,2,opt,name=carrier,proto3,oneof" json:"carrier,omitempty"`
	// Required. Carrier service, such as `"ground"` or `"2 days"`.
	CarrierService *string `protobuf:"bytes,3,opt,name=carrier_service,json=carrierService,proto3,oneof" json:"carrier_service,omitempty"`
	// Required. Shipping origin for this carrier rate.
	OriginPostalCode *string `protobuf:"bytes,4,opt,name=origin_postal_code,json=originPostalCode,proto3,oneof" json:"origin_postal_code,omitempty"`
	// Optional. Multiplicative shipping rate modifier as a number in decimal
	// notation. Can be negative. For example `"5.4"` increases the rate by 5.4%,
	// `"-3"` decreases the rate by 3%.
	PercentageAdjustment *string `protobuf:"bytes,5,opt,name=percentage_adjustment,json=percentageAdjustment,proto3,oneof" json:"percentage_adjustment,omitempty"`
	// Optional. Additive shipping rate modifier. Can be negative. For example
	// `{ "amount_micros": 1, "currency_code" : "USD" }` adds $1 to the rate,
	// `{ "amount_micros": -3, "currency_code" : "USD" }` removes $3 from the
	// rate.
	FlatAdjustment *typepb.Price `protobuf:"bytes,6,opt,name=flat_adjustment,json=flatAdjustment,proto3,oneof" json:"flat_adjustment,omitempty"`
}

func (x *CarrierRate) Reset() {
	*x = CarrierRate{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CarrierRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CarrierRate) ProtoMessage() {}

func (x *CarrierRate) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CarrierRate.ProtoReflect.Descriptor instead.
func (*CarrierRate) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{18}
}

func (x *CarrierRate) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *CarrierRate) GetCarrier() string {
	if x != nil && x.Carrier != nil {
		return *x.Carrier
	}
	return ""
}

func (x *CarrierRate) GetCarrierService() string {
	if x != nil && x.CarrierService != nil {
		return *x.CarrierService
	}
	return ""
}

func (x *CarrierRate) GetOriginPostalCode() string {
	if x != nil && x.OriginPostalCode != nil {
		return *x.OriginPostalCode
	}
	return ""
}

func (x *CarrierRate) GetPercentageAdjustment() string {
	if x != nil && x.PercentageAdjustment != nil {
		return *x.PercentageAdjustment
	}
	return ""
}

func (x *CarrierRate) GetFlatAdjustment() *typepb.Price {
	if x != nil {
		return x.FlatAdjustment
	}
	return nil
}

// Request message for the `GetShippingSetting` method.
type GetShippingSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the shipping setting to retrieve.
	// Format: `accounts/{account}/shippingsetting`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetShippingSettingsRequest) Reset() {
	*x = GetShippingSettingsRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetShippingSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetShippingSettingsRequest) ProtoMessage() {}

func (x *GetShippingSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetShippingSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetShippingSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{19}
}

func (x *GetShippingSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `InsertShippingSetting` method.
type InsertShippingSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account where this product will be inserted.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The new version of the account.
	ShippingSetting *ShippingSettings `protobuf:"bytes,2,opt,name=shipping_setting,json=shippingSetting,proto3" json:"shipping_setting,omitempty"`
}

func (x *InsertShippingSettingsRequest) Reset() {
	*x = InsertShippingSettingsRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InsertShippingSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertShippingSettingsRequest) ProtoMessage() {}

func (x *InsertShippingSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertShippingSettingsRequest.ProtoReflect.Descriptor instead.
func (*InsertShippingSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{20}
}

func (x *InsertShippingSettingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InsertShippingSettingsRequest) GetShippingSetting() *ShippingSettings {
	if x != nil {
		return x.ShippingSetting
	}
	return nil
}

// A list of stores your products are delivered from.
// This is only valid for the local delivery shipment type.
type Service_StoreConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether all stores, or selected stores, listed by this
	// merchant provide local delivery.
	StoreServiceType *Service_StoreConfig_StoreServiceType `protobuf:"varint,1,opt,name=store_service_type,json=storeServiceType,proto3,enum=google.shopping.merchant.accounts.v1beta.Service_StoreConfig_StoreServiceType,oneof" json:"store_service_type,omitempty"`
	// Optional. A list of store codes that provide local delivery.
	// If empty, then `all_stores` must be true.
	StoreCodes []string `protobuf:"bytes,2,rep,name=store_codes,json=storeCodes,proto3" json:"store_codes,omitempty"`
	// Configs related to local delivery ends for the day.
	CutoffConfig *Service_StoreConfig_CutoffConfig `protobuf:"bytes,3,opt,name=cutoff_config,json=cutoffConfig,proto3,oneof" json:"cutoff_config,omitempty"`
	// Maximum delivery radius.
	// This is only required for the local delivery shipment type.
	ServiceRadius *Distance `protobuf:"bytes,4,opt,name=service_radius,json=serviceRadius,proto3,oneof" json:"service_radius,omitempty"`
}

func (x *Service_StoreConfig) Reset() {
	*x = Service_StoreConfig{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service_StoreConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_StoreConfig) ProtoMessage() {}

func (x *Service_StoreConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_StoreConfig.ProtoReflect.Descriptor instead.
func (*Service_StoreConfig) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Service_StoreConfig) GetStoreServiceType() Service_StoreConfig_StoreServiceType {
	if x != nil && x.StoreServiceType != nil {
		return *x.StoreServiceType
	}
	return Service_StoreConfig_STORE_SERVICE_TYPE_UNSPECIFIED
}

func (x *Service_StoreConfig) GetStoreCodes() []string {
	if x != nil {
		return x.StoreCodes
	}
	return nil
}

func (x *Service_StoreConfig) GetCutoffConfig() *Service_StoreConfig_CutoffConfig {
	if x != nil {
		return x.CutoffConfig
	}
	return nil
}

func (x *Service_StoreConfig) GetServiceRadius() *Distance {
	if x != nil {
		return x.ServiceRadius
	}
	return nil
}

// [Loyalty program](https://support.google.com/merchants/answer/12922446)
// provided by a merchant.
type Service_LoyaltyProgram struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is the loyalty program label set in your loyalty program settings in
	// Merchant Center. This sub-attribute allows Google to map your loyalty
	// program to eligible offers.
	ProgramLabel *string `protobuf:"bytes,1,opt,name=program_label,json=programLabel,proto3,oneof" json:"program_label,omitempty"`
	// Optional. Loyalty program tier of this shipping service.
	LoyaltyProgramTiers []*Service_LoyaltyProgram_LoyaltyProgramTiers `protobuf:"bytes,2,rep,name=loyalty_program_tiers,json=loyaltyProgramTiers,proto3" json:"loyalty_program_tiers,omitempty"`
}

func (x *Service_LoyaltyProgram) Reset() {
	*x = Service_LoyaltyProgram{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service_LoyaltyProgram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_LoyaltyProgram) ProtoMessage() {}

func (x *Service_LoyaltyProgram) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_LoyaltyProgram.ProtoReflect.Descriptor instead.
func (*Service_LoyaltyProgram) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Service_LoyaltyProgram) GetProgramLabel() string {
	if x != nil && x.ProgramLabel != nil {
		return *x.ProgramLabel
	}
	return ""
}

func (x *Service_LoyaltyProgram) GetLoyaltyProgramTiers() []*Service_LoyaltyProgram_LoyaltyProgramTiers {
	if x != nil {
		return x.LoyaltyProgramTiers
	}
	return nil
}

// Configs related to local delivery ends for the day.
type Service_StoreConfig_CutoffConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time that local delivery ends for the day.
	LocalCutoffTime *Service_StoreConfig_CutoffConfig_LocalCutoffTime `protobuf:"bytes,1,opt,name=local_cutoff_time,json=localCutoffTime,proto3,oneof" json:"local_cutoff_time,omitempty"`
	// Only valid with local delivery fulfillment. Represents cutoff time
	// as the number of hours before store closing. Mutually exclusive
	// with `local_cutoff_time`.
	StoreCloseOffsetHours *int64 `protobuf:"varint,2,opt,name=store_close_offset_hours,json=storeCloseOffsetHours,proto3,oneof" json:"store_close_offset_hours,omitempty"`
	// Merchants can opt-out of showing n+1 day local delivery when they have
	// a shipping service configured to n day local delivery. For example, if
	// the shipping service defines same-day delivery, and it's past the
	// cut-off, setting this field to `true` results in the calculated
	// shipping service rate returning `NO_DELIVERY_POST_CUTOFF`. In the
	// same example, setting this field to `false` results in the calculated
	// shipping time being one day. This is only for local delivery.
	NoDeliveryPostCutoff *bool `protobuf:"varint,3,opt,name=no_delivery_post_cutoff,json=noDeliveryPostCutoff,proto3,oneof" json:"no_delivery_post_cutoff,omitempty"`
}

func (x *Service_StoreConfig_CutoffConfig) Reset() {
	*x = Service_StoreConfig_CutoffConfig{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service_StoreConfig_CutoffConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_StoreConfig_CutoffConfig) ProtoMessage() {}

func (x *Service_StoreConfig_CutoffConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_StoreConfig_CutoffConfig.ProtoReflect.Descriptor instead.
func (*Service_StoreConfig_CutoffConfig) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *Service_StoreConfig_CutoffConfig) GetLocalCutoffTime() *Service_StoreConfig_CutoffConfig_LocalCutoffTime {
	if x != nil {
		return x.LocalCutoffTime
	}
	return nil
}

func (x *Service_StoreConfig_CutoffConfig) GetStoreCloseOffsetHours() int64 {
	if x != nil && x.StoreCloseOffsetHours != nil {
		return *x.StoreCloseOffsetHours
	}
	return 0
}

func (x *Service_StoreConfig_CutoffConfig) GetNoDeliveryPostCutoff() bool {
	if x != nil && x.NoDeliveryPostCutoff != nil {
		return *x.NoDeliveryPostCutoff
	}
	return false
}

// Time that local delivery ends for the day.
type Service_StoreConfig_CutoffConfig_LocalCutoffTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hour local delivery orders must be placed by to process the same
	// day.
	Hour *int64 `protobuf:"varint,1,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
	// Minute local delivery orders must be placed by to process the same
	// day.
	Minute *int64 `protobuf:"varint,2,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
}

func (x *Service_StoreConfig_CutoffConfig_LocalCutoffTime) Reset() {
	*x = Service_StoreConfig_CutoffConfig_LocalCutoffTime{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service_StoreConfig_CutoffConfig_LocalCutoffTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_StoreConfig_CutoffConfig_LocalCutoffTime) ProtoMessage() {}

func (x *Service_StoreConfig_CutoffConfig_LocalCutoffTime) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_StoreConfig_CutoffConfig_LocalCutoffTime.ProtoReflect.Descriptor instead.
func (*Service_StoreConfig_CutoffConfig_LocalCutoffTime) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{1, 0, 0, 0}
}

func (x *Service_StoreConfig_CutoffConfig_LocalCutoffTime) GetHour() int64 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

func (x *Service_StoreConfig_CutoffConfig_LocalCutoffTime) GetMinute() int64 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

// Subset of a merchants loyalty program.
type Service_LoyaltyProgram_LoyaltyProgramTiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The tier label [tier_label] sub-attribute differentiates offer level
	// benefits between each tier. This value is also set in your program
	// settings in Merchant Center, and is required for data source changes
	// even if your loyalty program only has 1 tier.
	TierLabel *string `protobuf:"bytes,1,opt,name=tier_label,json=tierLabel,proto3,oneof" json:"tier_label,omitempty"`
}

func (x *Service_LoyaltyProgram_LoyaltyProgramTiers) Reset() {
	*x = Service_LoyaltyProgram_LoyaltyProgramTiers{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service_LoyaltyProgram_LoyaltyProgramTiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_LoyaltyProgram_LoyaltyProgramTiers) ProtoMessage() {}

func (x *Service_LoyaltyProgram_LoyaltyProgramTiers) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_LoyaltyProgram_LoyaltyProgramTiers.ProtoReflect.Descriptor instead.
func (*Service_LoyaltyProgram_LoyaltyProgramTiers) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (x *Service_LoyaltyProgram_LoyaltyProgramTiers) GetTierLabel() string {
	if x != nil && x.TierLabel != nil {
		return *x.TierLabel
	}
	return ""
}

// If there's only one dimension set of `postal_code_group_names` or
// `transit_time_labels`, there are multiple rows each with one value
// for that dimension. If there are two dimensions, each row corresponds to a
// `postal_code_group_names`, and columns (values) to a
// `transit_time_labels`.
type TransitTable_TransitTimeRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Transit time range (min-max) in business days.
	Values []*TransitTable_TransitTimeRow_TransitTimeValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *TransitTable_TransitTimeRow) Reset() {
	*x = TransitTable_TransitTimeRow{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransitTable_TransitTimeRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitTable_TransitTimeRow) ProtoMessage() {}

func (x *TransitTable_TransitTimeRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitTable_TransitTimeRow.ProtoReflect.Descriptor instead.
func (*TransitTable_TransitTimeRow) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{12, 0}
}

func (x *TransitTable_TransitTimeRow) GetValues() []*TransitTable_TransitTimeRow_TransitTimeValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// Transit time range (min-max) in business days.
type TransitTable_TransitTimeRow_TransitTimeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum transit time range in business days. 0 means same
	// day delivery, 1 means next day delivery.
	MinTransitDays *int32 `protobuf:"varint,1,opt,name=min_transit_days,json=minTransitDays,proto3,oneof" json:"min_transit_days,omitempty"`
	// Must be greater than or equal to `min_transit_days`.
	MaxTransitDays *int32 `protobuf:"varint,2,opt,name=max_transit_days,json=maxTransitDays,proto3,oneof" json:"max_transit_days,omitempty"`
}

func (x *TransitTable_TransitTimeRow_TransitTimeValue) Reset() {
	*x = TransitTable_TransitTimeRow_TransitTimeValue{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransitTable_TransitTimeRow_TransitTimeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitTable_TransitTimeRow_TransitTimeValue) ProtoMessage() {}

func (x *TransitTable_TransitTimeRow_TransitTimeValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitTable_TransitTimeRow_TransitTimeValue.ProtoReflect.Descriptor instead.
func (*TransitTable_TransitTimeRow_TransitTimeValue) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{12, 0, 0}
}

func (x *TransitTable_TransitTimeRow_TransitTimeValue) GetMinTransitDays() int32 {
	if x != nil && x.MinTransitDays != nil {
		return *x.MinTransitDays
	}
	return 0
}

func (x *TransitTable_TransitTimeRow_TransitTimeValue) GetMaxTransitDays() int32 {
	if x != nil && x.MaxTransitDays != nil {
		return *x.MaxTransitDays
	}
	return 0
}

// A list of store code sets sharing the same minimum order value. At least
// two sets are required and the last one must be empty, which signifies
// 'MOV for all other stores'.
// Each store code can only appear once across all the sets.
// All prices within a service must have the same currency.
type MinimumOrderValueTable_StoreCodeSetWithMov struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of unique store codes or empty for the catch all.
	StoreCodes []string `protobuf:"bytes,1,rep,name=store_codes,json=storeCodes,proto3" json:"store_codes,omitempty"`
	// The minimum order value for the given stores.
	Value *typepb.Price `protobuf:"bytes,2,opt,name=value,proto3,oneof" json:"value,omitempty"`
}

func (x *MinimumOrderValueTable_StoreCodeSetWithMov) Reset() {
	*x = MinimumOrderValueTable_StoreCodeSetWithMov{}
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MinimumOrderValueTable_StoreCodeSetWithMov) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MinimumOrderValueTable_StoreCodeSetWithMov) ProtoMessage() {}

func (x *MinimumOrderValueTable_StoreCodeSetWithMov) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MinimumOrderValueTable_StoreCodeSetWithMov.ProtoReflect.Descriptor instead.
func (*MinimumOrderValueTable_StoreCodeSetWithMov) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP(), []int{13, 0}
}

func (x *MinimumOrderValueTable_StoreCodeSetWithMov) GetStoreCodes() []string {
	if x != nil {
		return x.StoreCodes
	}
	return nil
}

func (x *MinimumOrderValueTable_StoreCodeSetWithMov) GetValue() *typepb.Price {
	if x != nil {
		return x.Value
	}
	return nil
}

var File_google_shopping_merchant_accounts_v1beta_shippingsettings_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x68, 0x69, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xed, 0x02, 0x0a, 0x10, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x52,
	0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x12, 0x58, 0x0a, 0x0a, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x3a, 0x79, 0xea, 0x41, 0x76, 0x0a, 0x2b, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x23, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x73, 0x68, 0x69, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2a, 0x10, 0x73, 0x68,
	0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x10,
	0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0xa7, 0x13, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2b, 0x0a, 0x0c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01,
	0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x28, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x65, 0x0a, 0x0d, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52,
	0x0c, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x59, 0x0a, 0x0b, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x52, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x72, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x68, 0x0a, 0x0d, 0x73,
	0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x48, 0x04, 0x52, 0x0c, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x13, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d,
	0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x48,
	0x05, 0x52, 0x11, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x80, 0x01, 0x0a, 0x19, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x06, 0x52,
	0x16, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x65, 0x0a, 0x0c, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x07, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01,
	0x01, 0x12, 0x70, 0x0a, 0x10, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x4c,
	0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x73, 0x1a, 0xeb, 0x07, 0x0a, 0x0b, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x81, 0x01, 0x0a, 0x12, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x48, 0x00, 0x52, 0x10, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x74, 0x0a,
	0x0d, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x01, 0x52, 0x0c, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72,
	0x61, 0x64, 0x69, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48,
	0x02, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x61, 0x64, 0x69, 0x75, 0x73,
	0x88, 0x01, 0x01, 0x1a, 0xc2, 0x03, 0x0a, 0x0c, 0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x8b, 0x01, 0x0a, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x63,
	0x75, 0x74, 0x6f, 0x66, 0x66, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x0f,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x3c, 0x0a, 0x18, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x73,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x15, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6c, 0x6f,
	0x73, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x3a, 0x0a, 0x17, 0x6e, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x70, 0x6f, 0x73, 0x74, 0x5f, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x02, 0x52, 0x14, 0x6e, 0x6f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x50,
	0x6f, 0x73, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x88, 0x01, 0x01, 0x1a, 0x5b, 0x0a, 0x0f,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x04, 0x68, 0x6f, 0x75, 0x72, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x06, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x42, 0x09,
	0x0a, 0x07, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x5f, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42,
	0x1b, 0x0a, 0x19, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x42, 0x1a, 0x0a, 0x18,
	0x5f, 0x6e, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x73,
	0x74, 0x5f, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x22, 0x5b, 0x0a, 0x10, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e,
	0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x4c, 0x4c, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x53, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x4f,
	0x52, 0x45, 0x53, 0x10, 0x02, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x11,
	0x0a, 0x0f, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x61, 0x64, 0x69, 0x75,
	0x73, 0x1a, 0xa6, 0x02, 0x0a, 0x0e, 0x4c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x8d,
	0x01, 0x0a, 0x15, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x4c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x2e, 0x4c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x54,
	0x69, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6c, 0x6f, 0x79, 0x61, 0x6c,
	0x74, 0x79, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x54, 0x69, 0x65, 0x72, 0x73, 0x1a, 0x48,
	0x0a, 0x13, 0x4c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x54, 0x69, 0x65, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x69, 0x65, 0x72, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x65,
	0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x74, 0x69,
	0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x65, 0x0a, 0x0c, 0x53, 0x68,
	0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x48,
	0x49, 0x50, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x49, 0x56, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x43, 0x41, 0x4c,
	0x5f, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x43,
	0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x10,
	0x03, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42,
	0x10, 0x0a, 0x0e, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x1c, 0x0a, 0x1a, 0x5f,
	0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xc3, 0x01, 0x0a, 0x08, 0x44,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x50, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x48, 0x01, 0x52, 0x04, 0x75, 0x6e, 0x69,
	0x74, 0x88, 0x01, 0x01, 0x22, 0x37, 0x0a, 0x04, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x14, 0x0a, 0x10,
	0x55, 0x4e, 0x49, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x49, 0x4c, 0x45, 0x53, 0x10, 0x01, 0x12, 0x0e, 0x0a,
	0x0a, 0x4b, 0x49, 0x4c, 0x4f, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x53, 0x10, 0x02, 0x42, 0x08, 0x0a,
	0x06, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x75, 0x6e, 0x69, 0x74,
	0x22, 0xf4, 0x03, 0x0a, 0x09, 0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x12, 0x1c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x66, 0x0a, 0x10,
	0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01,
	0x52, 0x0f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x68, 0x0a, 0x0b, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x43, 0x75,
	0x74, 0x6f, 0x66, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x02, 0x52,
	0x0a, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2d,
	0x0a, 0x0d, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52, 0x0c, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a,
	0x13, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x61, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x44, 0x61,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x04, 0x52, 0x11, 0x62, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x44, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x42,
	0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73, 0x68, 0x69,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x42,
	0x16, 0x0a, 0x14, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x61, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x69, 0x0a, 0x13, 0x57, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x43, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1c,
	0x0a, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x00, 0x52, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x06,
	0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x01, 0x52, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x07,
	0x0a, 0x05, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x22, 0xb8, 0x02, 0x0a, 0x07, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2a,
	0x0a, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x04, 0x63, 0x69,
	0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52,
	0x04, 0x63, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x13, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x12, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x41, 0x72, 0x65, 0x61,
	0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0b, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52,
	0x0a, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x29,
	0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x04, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x65, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x07, 0x0a, 0x05,
	0x5f, 0x63, 0x69, 0x74, 0x79, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x22, 0xe9, 0x07,
	0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d,
	0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x64, 0x61,
	0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a,
	0x10, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x64, 0x61, 0x79,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12, 0x5a, 0x0a, 0x0b,
	0x63, 0x75, 0x74, 0x6f, 0x66, 0x66, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x74,
	0x6f, 0x66, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x02, 0x52, 0x0a, 0x63, 0x75, 0x74, 0x6f, 0x66,
	0x66, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x5f,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x03, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69,
	0x6e, 0x67, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x61, 0x78,
	0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x04, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x69, 0x6e, 0x67, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12, 0x69, 0x0a, 0x12, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x05,
	0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x1c, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69,
	0x6e, 0x67, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x61, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73,
	0x44, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x06, 0x52, 0x19, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x44, 0x61, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x7f, 0x0a, 0x1b, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x61,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65,
	0x73, 0x73, 0x44, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x07, 0x52, 0x18, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x44, 0x61,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x8e, 0x01, 0x0a, 0x1e, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x42, 0x61, 0x73, 0x65, 0x64, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x42, 0x61, 0x73, 0x65, 0x64, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x5f,
	0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x64, 0x61, 0x79, 0x73,
	0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
	0x5f, 0x64, 0x61, 0x79, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x75, 0x74, 0x6f, 0x66, 0x66,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f,
	0x6d, 0x61, 0x78, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x79,
	0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x64,
	0x61, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x64,
	0x61, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x95, 0x01, 0x0a, 0x0a, 0x43, 0x75,
	0x74, 0x6f, 0x66, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x04, 0x68, 0x6f, 0x75, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x04, 0x68,
	0x6f, 0x75, 0x72, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x06, 0x6d,
	0x69, 0x6e, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x48, 0x02, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x07, 0x0a, 0x05, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x69, 0x6e,
	0x75, 0x74, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e,
	0x65, 0x22, 0x82, 0x02, 0x0a, 0x11, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x44, 0x61,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6d, 0x0a, 0x0d, 0x62, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65,
	0x73, 0x73, 0x44, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x57, 0x65, 0x65, 0x6b,
	0x64, 0x61, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65,
	0x73, 0x73, 0x44, 0x61, 0x79, 0x73, 0x22, 0x7e, 0x0a, 0x07, 0x57, 0x65, 0x65, 0x6b, 0x64, 0x61,
	0x79, 0x12, 0x17, 0x0a, 0x13, 0x57, 0x45, 0x45, 0x4b, 0x44, 0x41, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f,
	0x4e, 0x44, 0x41, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x55, 0x45, 0x53, 0x44, 0x41,
	0x59, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x57, 0x45, 0x44, 0x4e, 0x45, 0x53, 0x44, 0x41, 0x59,
	0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x48, 0x55, 0x52, 0x53, 0x44, 0x41, 0x59, 0x10, 0x04,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x52, 0x49, 0x44, 0x41, 0x59, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x41, 0x54, 0x55, 0x52, 0x44, 0x41, 0x59, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x55,
	0x4e, 0x44, 0x41, 0x59, 0x10, 0x07, 0x22, 0xc9, 0x01, 0x0a, 0x1a, 0x57, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x42, 0x61, 0x73, 0x65, 0x64, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x07, 0x63,
	0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x0f, 0x63, 0x61, 0x72,
	0x72, 0x69, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x0e, 0x63, 0x61, 0x72, 0x72, 0x69,
	0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x09, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x22, 0xf8, 0x03, 0x0a, 0x09, 0x52, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x41, 0x0a, 0x1a, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73,
	0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x57, 0x0a, 0x0c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x0a,
	0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x48, 0x01, 0x52, 0x09, 0x6d, 0x61, 0x69, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x52, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x75, 0x62, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x0d, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x52,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65,
	0x72, 0x52, 0x61, 0x74, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd1, 0x02,
	0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x5c, 0x0a, 0x0b, 0x72, 0x6f, 0x77, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52,
	0x0a, 0x72, 0x6f, 0x77, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x88, 0x01, 0x01, 0x12, 0x5d,
	0x0a, 0x0e, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x48, 0x02, 0x52, 0x0d, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x88, 0x01, 0x01, 0x12, 0x46, 0x0a,
	0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x72, 0x6f, 0x77, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x42, 0x11,
	0x0a, 0x0f, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x22, 0x84, 0x04, 0x0a, 0x0c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x3a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c,
	0x43, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x33,
	0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x5e, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x72,
	0x6f, 0x77, 0x73, 0x1a, 0xa2, 0x02, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x52, 0x6f, 0x77, 0x12, 0x73, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x6f, 0x77, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x9a, 0x01, 0x0a, 0x10,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f,
	0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x69,
	0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x2d, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x64,
	0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x0e, 0x6d, 0x61, 0x78,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x42, 0x13,
	0x0a, 0x11, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x64,
	0x61, 0x79, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x22, 0xab, 0x02, 0x0a, 0x16, 0x4d, 0x69, 0x6e,
	0x69, 0x6d, 0x75, 0x6d, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x91, 0x01, 0x0a, 0x18, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6d, 0x6f, 0x76, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x53, 0x65, 0x74, 0x57, 0x69, 0x74, 0x68, 0x4d, 0x6f, 0x76, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x14, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x53, 0x65, 0x74, 0x57,
	0x69, 0x74, 0x68, 0x4d, 0x6f, 0x76, 0x73, 0x1a, 0x7d, 0x0a, 0x13, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x53, 0x65, 0x74, 0x57, 0x69, 0x74, 0x68, 0x4d, 0x6f, 0x76, 0x12, 0x24,
	0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc5, 0x02, 0x0a, 0x07, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x12, 0x38, 0x0a, 0x06, 0x70, 0x72, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x72, 0x69, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x07,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x5f, 0x6f, 0x66, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x4f,
	0x66, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x3a, 0x0a, 0x17, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x70, 0x6f,
	0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x53, 0x65, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x37,
	0x0a, 0x0d, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x53, 0x65, 0x74, 0x12,
	0x26, 0x0a, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x22, 0x51, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x4a,
	0x0a, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x22, 0xb6, 0x02, 0x0a, 0x05, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x6e, 0x6f, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0a, 0x6e, 0x6f, 0x53,
	0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x09, 0x66, 0x6c,
	0x61, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x48, 0x01, 0x52, 0x08, 0x66, 0x6c,
	0x61, 0x74, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x61, 0x72,
	0x72, 0x69, 0x65, 0x72, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x03, 0x52, 0x0b, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x1f, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x08, 0x73, 0x75, 0x62, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x88,
	0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x6e, 0x6f, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x66, 0x6c, 0x61, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x42, 0x13, 0x0a, 0x11, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65,
	0x72, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x73, 0x75, 0x62, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0xb7, 0x03, 0x0a, 0x0b, 0x43, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x52,
	0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x07, 0x63, 0x61, 0x72, 0x72, 0x69,
	0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x0f, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x0e, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x12, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52, 0x10, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x50, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x3d, 0x0a, 0x15, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x61,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x14, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
	0x67, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12,
	0x4e, 0x0a, 0x0f, 0x66, 0x6c, 0x61, 0x74, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52, 0x0e, 0x66, 0x6c,
	0x61, 0x74, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42,
	0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x61, 0x72,
	0x72, 0x69, 0x65, 0x72, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42,
	0x18, 0x0a, 0x16, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x61,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x66, 0x6c,
	0x61, 0x74, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x65, 0x0a,
	0x1a, 0x47, 0x65, 0x74, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x68,
	0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x1d, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x53,
	0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x6a, 0x0a, 0x10, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x32,
	0xb8, 0x04, 0x0a, 0x17, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xdb, 0x01, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0xf5, 0x01, 0x0a, 0x16, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x50, 0x3a, 0x10, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x22, 0x3c, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x69, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x97, 0x01, 0x0a, 0x2c, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x15, 0x53, 0x68, 0x69,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_goTypes = []any{
	(Service_ShipmentType)(0),                 // 0: google.shopping.merchant.accounts.v1beta.Service.ShipmentType
	(Service_StoreConfig_StoreServiceType)(0), // 1: google.shopping.merchant.accounts.v1beta.Service.StoreConfig.StoreServiceType
	(Distance_Unit)(0),                        // 2: google.shopping.merchant.accounts.v1beta.Distance.Unit
	(BusinessDayConfig_Weekday)(0),            // 3: google.shopping.merchant.accounts.v1beta.BusinessDayConfig.Weekday
	(*ShippingSettings)(nil),                  // 4: google.shopping.merchant.accounts.v1beta.ShippingSettings
	(*Service)(nil),                           // 5: google.shopping.merchant.accounts.v1beta.Service
	(*Distance)(nil),                          // 6: google.shopping.merchant.accounts.v1beta.Distance
	(*Warehouse)(nil),                         // 7: google.shopping.merchant.accounts.v1beta.Warehouse
	(*WarehouseCutoffTime)(nil),               // 8: google.shopping.merchant.accounts.v1beta.WarehouseCutoffTime
	(*Address)(nil),                           // 9: google.shopping.merchant.accounts.v1beta.Address
	(*DeliveryTime)(nil),                      // 10: google.shopping.merchant.accounts.v1beta.DeliveryTime
	(*CutoffTime)(nil),                        // 11: google.shopping.merchant.accounts.v1beta.CutoffTime
	(*BusinessDayConfig)(nil),                 // 12: google.shopping.merchant.accounts.v1beta.BusinessDayConfig
	(*WarehouseBasedDeliveryTime)(nil),        // 13: google.shopping.merchant.accounts.v1beta.WarehouseBasedDeliveryTime
	(*RateGroup)(nil),                         // 14: google.shopping.merchant.accounts.v1beta.RateGroup
	(*Table)(nil),                             // 15: google.shopping.merchant.accounts.v1beta.Table
	(*TransitTable)(nil),                      // 16: google.shopping.merchant.accounts.v1beta.TransitTable
	(*MinimumOrderValueTable)(nil),            // 17: google.shopping.merchant.accounts.v1beta.MinimumOrderValueTable
	(*Headers)(nil),                           // 18: google.shopping.merchant.accounts.v1beta.Headers
	(*LocationIdSet)(nil),                     // 19: google.shopping.merchant.accounts.v1beta.LocationIdSet
	(*Row)(nil),                               // 20: google.shopping.merchant.accounts.v1beta.Row
	(*Value)(nil),                             // 21: google.shopping.merchant.accounts.v1beta.Value
	(*CarrierRate)(nil),                       // 22: google.shopping.merchant.accounts.v1beta.CarrierRate
	(*GetShippingSettingsRequest)(nil),        // 23: google.shopping.merchant.accounts.v1beta.GetShippingSettingsRequest
	(*InsertShippingSettingsRequest)(nil),     // 24: google.shopping.merchant.accounts.v1beta.InsertShippingSettingsRequest
	(*Service_StoreConfig)(nil),               // 25: google.shopping.merchant.accounts.v1beta.Service.StoreConfig
	(*Service_LoyaltyProgram)(nil),            // 26: google.shopping.merchant.accounts.v1beta.Service.LoyaltyProgram
	(*Service_StoreConfig_CutoffConfig)(nil),  // 27: google.shopping.merchant.accounts.v1beta.Service.StoreConfig.CutoffConfig
	(*Service_StoreConfig_CutoffConfig_LocalCutoffTime)(nil), // 28: google.shopping.merchant.accounts.v1beta.Service.StoreConfig.CutoffConfig.LocalCutoffTime
	(*Service_LoyaltyProgram_LoyaltyProgramTiers)(nil),       // 29: google.shopping.merchant.accounts.v1beta.Service.LoyaltyProgram.LoyaltyProgramTiers
	(*TransitTable_TransitTimeRow)(nil),                      // 30: google.shopping.merchant.accounts.v1beta.TransitTable.TransitTimeRow
	(*TransitTable_TransitTimeRow_TransitTimeValue)(nil),     // 31: google.shopping.merchant.accounts.v1beta.TransitTable.TransitTimeRow.TransitTimeValue
	(*MinimumOrderValueTable_StoreCodeSetWithMov)(nil),       // 32: google.shopping.merchant.accounts.v1beta.MinimumOrderValueTable.StoreCodeSetWithMov
	(*typepb.Price)(nil),                                     // 33: google.shopping.type.Price
	(*typepb.Weight)(nil),                                    // 34: google.shopping.type.Weight
}
var file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_depIdxs = []int32{
	5,  // 0: google.shopping.merchant.accounts.v1beta.ShippingSettings.services:type_name -> google.shopping.merchant.accounts.v1beta.Service
	7,  // 1: google.shopping.merchant.accounts.v1beta.ShippingSettings.warehouses:type_name -> google.shopping.merchant.accounts.v1beta.Warehouse
	10, // 2: google.shopping.merchant.accounts.v1beta.Service.delivery_time:type_name -> google.shopping.merchant.accounts.v1beta.DeliveryTime
	14, // 3: google.shopping.merchant.accounts.v1beta.Service.rate_groups:type_name -> google.shopping.merchant.accounts.v1beta.RateGroup
	0,  // 4: google.shopping.merchant.accounts.v1beta.Service.shipment_type:type_name -> google.shopping.merchant.accounts.v1beta.Service.ShipmentType
	33, // 5: google.shopping.merchant.accounts.v1beta.Service.minimum_order_value:type_name -> google.shopping.type.Price
	17, // 6: google.shopping.merchant.accounts.v1beta.Service.minimum_order_value_table:type_name -> google.shopping.merchant.accounts.v1beta.MinimumOrderValueTable
	25, // 7: google.shopping.merchant.accounts.v1beta.Service.store_config:type_name -> google.shopping.merchant.accounts.v1beta.Service.StoreConfig
	26, // 8: google.shopping.merchant.accounts.v1beta.Service.loyalty_programs:type_name -> google.shopping.merchant.accounts.v1beta.Service.LoyaltyProgram
	2,  // 9: google.shopping.merchant.accounts.v1beta.Distance.unit:type_name -> google.shopping.merchant.accounts.v1beta.Distance.Unit
	9,  // 10: google.shopping.merchant.accounts.v1beta.Warehouse.shipping_address:type_name -> google.shopping.merchant.accounts.v1beta.Address
	8,  // 11: google.shopping.merchant.accounts.v1beta.Warehouse.cutoff_time:type_name -> google.shopping.merchant.accounts.v1beta.WarehouseCutoffTime
	12, // 12: google.shopping.merchant.accounts.v1beta.Warehouse.business_day_config:type_name -> google.shopping.merchant.accounts.v1beta.BusinessDayConfig
	11, // 13: google.shopping.merchant.accounts.v1beta.DeliveryTime.cutoff_time:type_name -> google.shopping.merchant.accounts.v1beta.CutoffTime
	16, // 14: google.shopping.merchant.accounts.v1beta.DeliveryTime.transit_time_table:type_name -> google.shopping.merchant.accounts.v1beta.TransitTable
	12, // 15: google.shopping.merchant.accounts.v1beta.DeliveryTime.handling_business_day_config:type_name -> google.shopping.merchant.accounts.v1beta.BusinessDayConfig
	12, // 16: google.shopping.merchant.accounts.v1beta.DeliveryTime.transit_business_day_config:type_name -> google.shopping.merchant.accounts.v1beta.BusinessDayConfig
	13, // 17: google.shopping.merchant.accounts.v1beta.DeliveryTime.warehouse_based_delivery_times:type_name -> google.shopping.merchant.accounts.v1beta.WarehouseBasedDeliveryTime
	3,  // 18: google.shopping.merchant.accounts.v1beta.BusinessDayConfig.business_days:type_name -> google.shopping.merchant.accounts.v1beta.BusinessDayConfig.Weekday
	21, // 19: google.shopping.merchant.accounts.v1beta.RateGroup.single_value:type_name -> google.shopping.merchant.accounts.v1beta.Value
	15, // 20: google.shopping.merchant.accounts.v1beta.RateGroup.main_table:type_name -> google.shopping.merchant.accounts.v1beta.Table
	15, // 21: google.shopping.merchant.accounts.v1beta.RateGroup.subtables:type_name -> google.shopping.merchant.accounts.v1beta.Table
	22, // 22: google.shopping.merchant.accounts.v1beta.RateGroup.carrier_rates:type_name -> google.shopping.merchant.accounts.v1beta.CarrierRate
	18, // 23: google.shopping.merchant.accounts.v1beta.Table.row_headers:type_name -> google.shopping.merchant.accounts.v1beta.Headers
	18, // 24: google.shopping.merchant.accounts.v1beta.Table.column_headers:type_name -> google.shopping.merchant.accounts.v1beta.Headers
	20, // 25: google.shopping.merchant.accounts.v1beta.Table.rows:type_name -> google.shopping.merchant.accounts.v1beta.Row
	30, // 26: google.shopping.merchant.accounts.v1beta.TransitTable.rows:type_name -> google.shopping.merchant.accounts.v1beta.TransitTable.TransitTimeRow
	32, // 27: google.shopping.merchant.accounts.v1beta.MinimumOrderValueTable.store_code_set_with_movs:type_name -> google.shopping.merchant.accounts.v1beta.MinimumOrderValueTable.StoreCodeSetWithMov
	33, // 28: google.shopping.merchant.accounts.v1beta.Headers.prices:type_name -> google.shopping.type.Price
	34, // 29: google.shopping.merchant.accounts.v1beta.Headers.weights:type_name -> google.shopping.type.Weight
	19, // 30: google.shopping.merchant.accounts.v1beta.Headers.locations:type_name -> google.shopping.merchant.accounts.v1beta.LocationIdSet
	21, // 31: google.shopping.merchant.accounts.v1beta.Row.cells:type_name -> google.shopping.merchant.accounts.v1beta.Value
	33, // 32: google.shopping.merchant.accounts.v1beta.Value.flat_rate:type_name -> google.shopping.type.Price
	33, // 33: google.shopping.merchant.accounts.v1beta.CarrierRate.flat_adjustment:type_name -> google.shopping.type.Price
	4,  // 34: google.shopping.merchant.accounts.v1beta.InsertShippingSettingsRequest.shipping_setting:type_name -> google.shopping.merchant.accounts.v1beta.ShippingSettings
	1,  // 35: google.shopping.merchant.accounts.v1beta.Service.StoreConfig.store_service_type:type_name -> google.shopping.merchant.accounts.v1beta.Service.StoreConfig.StoreServiceType
	27, // 36: google.shopping.merchant.accounts.v1beta.Service.StoreConfig.cutoff_config:type_name -> google.shopping.merchant.accounts.v1beta.Service.StoreConfig.CutoffConfig
	6,  // 37: google.shopping.merchant.accounts.v1beta.Service.StoreConfig.service_radius:type_name -> google.shopping.merchant.accounts.v1beta.Distance
	29, // 38: google.shopping.merchant.accounts.v1beta.Service.LoyaltyProgram.loyalty_program_tiers:type_name -> google.shopping.merchant.accounts.v1beta.Service.LoyaltyProgram.LoyaltyProgramTiers
	28, // 39: google.shopping.merchant.accounts.v1beta.Service.StoreConfig.CutoffConfig.local_cutoff_time:type_name -> google.shopping.merchant.accounts.v1beta.Service.StoreConfig.CutoffConfig.LocalCutoffTime
	31, // 40: google.shopping.merchant.accounts.v1beta.TransitTable.TransitTimeRow.values:type_name -> google.shopping.merchant.accounts.v1beta.TransitTable.TransitTimeRow.TransitTimeValue
	33, // 41: google.shopping.merchant.accounts.v1beta.MinimumOrderValueTable.StoreCodeSetWithMov.value:type_name -> google.shopping.type.Price
	23, // 42: google.shopping.merchant.accounts.v1beta.ShippingSettingsService.GetShippingSettings:input_type -> google.shopping.merchant.accounts.v1beta.GetShippingSettingsRequest
	24, // 43: google.shopping.merchant.accounts.v1beta.ShippingSettingsService.InsertShippingSettings:input_type -> google.shopping.merchant.accounts.v1beta.InsertShippingSettingsRequest
	4,  // 44: google.shopping.merchant.accounts.v1beta.ShippingSettingsService.GetShippingSettings:output_type -> google.shopping.merchant.accounts.v1beta.ShippingSettings
	4,  // 45: google.shopping.merchant.accounts.v1beta.ShippingSettingsService.InsertShippingSettings:output_type -> google.shopping.merchant.accounts.v1beta.ShippingSettings
	44, // [44:46] is the sub-list for method output_type
	42, // [42:44] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_shippingsettings_proto != nil {
		return
	}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[2].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[4].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[9].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[10].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[11].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[17].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[18].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[21].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[22].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[23].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[24].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[25].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[27].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes[28].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_shippingsettings_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_shippingsettings_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ShippingSettingsServiceClient is the client API for ShippingSettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ShippingSettingsServiceClient interface {
	// Retrieve shipping setting information.
	GetShippingSettings(ctx context.Context, in *GetShippingSettingsRequest, opts ...grpc.CallOption) (*ShippingSettings, error)
	// Replace the shipping setting of a merchant with the request shipping
	// setting. Executing this method requires admin access.
	InsertShippingSettings(ctx context.Context, in *InsertShippingSettingsRequest, opts ...grpc.CallOption) (*ShippingSettings, error)
}

type shippingSettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewShippingSettingsServiceClient(cc grpc.ClientConnInterface) ShippingSettingsServiceClient {
	return &shippingSettingsServiceClient{cc}
}

func (c *shippingSettingsServiceClient) GetShippingSettings(ctx context.Context, in *GetShippingSettingsRequest, opts ...grpc.CallOption) (*ShippingSettings, error) {
	out := new(ShippingSettings)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.ShippingSettingsService/GetShippingSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *shippingSettingsServiceClient) InsertShippingSettings(ctx context.Context, in *InsertShippingSettingsRequest, opts ...grpc.CallOption) (*ShippingSettings, error) {
	out := new(ShippingSettings)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.ShippingSettingsService/InsertShippingSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ShippingSettingsServiceServer is the server API for ShippingSettingsService service.
type ShippingSettingsServiceServer interface {
	// Retrieve shipping setting information.
	GetShippingSettings(context.Context, *GetShippingSettingsRequest) (*ShippingSettings, error)
	// Replace the shipping setting of a merchant with the request shipping
	// setting. Executing this method requires admin access.
	InsertShippingSettings(context.Context, *InsertShippingSettingsRequest) (*ShippingSettings, error)
}

// UnimplementedShippingSettingsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedShippingSettingsServiceServer struct {
}

func (*UnimplementedShippingSettingsServiceServer) GetShippingSettings(context.Context, *GetShippingSettingsRequest) (*ShippingSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetShippingSettings not implemented")
}
func (*UnimplementedShippingSettingsServiceServer) InsertShippingSettings(context.Context, *InsertShippingSettingsRequest) (*ShippingSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertShippingSettings not implemented")
}

func RegisterShippingSettingsServiceServer(s *grpc.Server, srv ShippingSettingsServiceServer) {
	s.RegisterService(&_ShippingSettingsService_serviceDesc, srv)
}

func _ShippingSettingsService_GetShippingSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetShippingSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ShippingSettingsServiceServer).GetShippingSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.ShippingSettingsService/GetShippingSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ShippingSettingsServiceServer).GetShippingSettings(ctx, req.(*GetShippingSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ShippingSettingsService_InsertShippingSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertShippingSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ShippingSettingsServiceServer).InsertShippingSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.ShippingSettingsService/InsertShippingSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ShippingSettingsServiceServer).InsertShippingSettings(ctx, req.(*InsertShippingSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ShippingSettingsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.ShippingSettingsService",
	HandlerType: (*ShippingSettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetShippingSettings",
			Handler:    _ShippingSettingsService_GetShippingSettings_Handler,
		},
		{
			MethodName: "InsertShippingSettings",
			Handler:    _ShippingSettingsService_InsertShippingSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/shippingsettings.proto",
}
