// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/datasources/v1beta/datasourcetypes.proto

package datasourcespb

import (
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Data Source Channel.
//
// Channel is used to distinguish between data sources for different product
// verticals.
type PrimaryProductDataSource_Channel int32

const (
	// Not specified.
	PrimaryProductDataSource_CHANNEL_UNSPECIFIED PrimaryProductDataSource_Channel = 0
	// Online product.
	PrimaryProductDataSource_ONLINE_PRODUCTS PrimaryProductDataSource_Channel = 1
	// Local product.
	PrimaryProductDataSource_LOCAL_PRODUCTS PrimaryProductDataSource_Channel = 2
	// Unified data source for both local and online products.
	// Note: Products management through the API is not possible for this
	// channel.
	PrimaryProductDataSource_PRODUCTS PrimaryProductDataSource_Channel = 3
)

// Enum value maps for PrimaryProductDataSource_Channel.
var (
	PrimaryProductDataSource_Channel_name = map[int32]string{
		0: "CHANNEL_UNSPECIFIED",
		1: "ONLINE_PRODUCTS",
		2: "LOCAL_PRODUCTS",
		3: "PRODUCTS",
	}
	PrimaryProductDataSource_Channel_value = map[string]int32{
		"CHANNEL_UNSPECIFIED": 0,
		"ONLINE_PRODUCTS":     1,
		"LOCAL_PRODUCTS":      2,
		"PRODUCTS":            3,
	}
)

func (x PrimaryProductDataSource_Channel) Enum() *PrimaryProductDataSource_Channel {
	p := new(PrimaryProductDataSource_Channel)
	*p = x
	return p
}

func (x PrimaryProductDataSource_Channel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrimaryProductDataSource_Channel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_enumTypes[0].Descriptor()
}

func (PrimaryProductDataSource_Channel) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_enumTypes[0]
}

func (x PrimaryProductDataSource_Channel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrimaryProductDataSource_Channel.Descriptor instead.
func (PrimaryProductDataSource_Channel) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{0, 0}
}

// The state of the destination.
type PrimaryProductDataSource_Destination_State int32

const (
	// Not specified.
	PrimaryProductDataSource_Destination_STATE_UNSPECIFIED PrimaryProductDataSource_Destination_State = 0
	// Indicates that the destination is enabled.
	PrimaryProductDataSource_Destination_ENABLED PrimaryProductDataSource_Destination_State = 1
	// Indicates that the destination is disabled.
	PrimaryProductDataSource_Destination_DISABLED PrimaryProductDataSource_Destination_State = 2
)

// Enum value maps for PrimaryProductDataSource_Destination_State.
var (
	PrimaryProductDataSource_Destination_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	PrimaryProductDataSource_Destination_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ENABLED":           1,
		"DISABLED":          2,
	}
)

func (x PrimaryProductDataSource_Destination_State) Enum() *PrimaryProductDataSource_Destination_State {
	p := new(PrimaryProductDataSource_Destination_State)
	*p = x
	return p
}

func (x PrimaryProductDataSource_Destination_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrimaryProductDataSource_Destination_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_enumTypes[1].Descriptor()
}

func (PrimaryProductDataSource_Destination_State) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_enumTypes[1]
}

func (x PrimaryProductDataSource_Destination_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrimaryProductDataSource_Destination_State.Descriptor instead.
func (PrimaryProductDataSource_Destination_State) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{0, 1, 0}
}

// The primary data source for local and online products.
type PrimaryProductDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Immutable. Specifies the type of data source channel.
	Channel PrimaryProductDataSource_Channel `protobuf:"varint,3,opt,name=channel,proto3,enum=google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource_Channel" json:"channel,omitempty"`
	// Optional. Immutable. The feed label that is specified on the data source
	// level.
	//
	// Must be less than or equal to 20 uppercase letters (A-Z), numbers (0-9),
	// and dashes (-).
	//
	// See also [migration to feed
	// labels](https://developers.google.com/shopping-content/guides/products/feed-labels).
	//
	// `feedLabel` and `contentLanguage` must be either both set or unset for data
	// sources with product content type.
	// They must be set for data sources with a file input.
	//
	// If set, the data source will only accept products matching this
	// combination. If unset, the data source will accept products without that
	// restriction.
	FeedLabel *string `protobuf:"bytes,4,opt,name=feed_label,json=feedLabel,proto3,oneof" json:"feed_label,omitempty"`
	// Optional. Immutable. The two-letter ISO 639-1 language of the items in the
	// data source.
	//
	// `feedLabel` and `contentLanguage` must be either both set or unset.
	// The fields can only be unset for data sources without file input.
	//
	// If set, the data source will only accept products matching this
	// combination. If unset, the data source will accept products without that
	// restriction.
	ContentLanguage *string `protobuf:"bytes,5,opt,name=content_language,json=contentLanguage,proto3,oneof" json:"content_language,omitempty"`
	// Optional. The countries where the items may be displayed. Represented as a
	// [CLDR territory
	// code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
	Countries []string `protobuf:"bytes,6,rep,name=countries,proto3" json:"countries,omitempty"`
	// Optional. Default rule management of the data source. If set, the linked
	// data sources will be replaced.
	DefaultRule *PrimaryProductDataSource_DefaultRule `protobuf:"bytes,7,opt,name=default_rule,json=defaultRule,proto3" json:"default_rule,omitempty"`
	// Optional. A list of destinations describing where products of the data
	// source can be shown.
	//
	// When retrieving the data source, the list contains all the destinations
	// that can be used for the data source, including the ones that are disabled
	// for the data source but enabled for the account.
	//
	// Only destinations that are enabled on the account, for example through
	// program participation, can be enabled on the data source.
	//
	// If unset, during creation, the destinations will be inherited based on the
	// account level program participation.
	//
	// If set, during creation or update, the data source will be set only for the
	// specified destinations.
	//
	// Updating this field requires at least one destination.
	Destinations []*PrimaryProductDataSource_Destination `protobuf:"bytes,10,rep,name=destinations,proto3" json:"destinations,omitempty"`
}

func (x *PrimaryProductDataSource) Reset() {
	*x = PrimaryProductDataSource{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrimaryProductDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrimaryProductDataSource) ProtoMessage() {}

func (x *PrimaryProductDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrimaryProductDataSource.ProtoReflect.Descriptor instead.
func (*PrimaryProductDataSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{0}
}

func (x *PrimaryProductDataSource) GetChannel() PrimaryProductDataSource_Channel {
	if x != nil {
		return x.Channel
	}
	return PrimaryProductDataSource_CHANNEL_UNSPECIFIED
}

func (x *PrimaryProductDataSource) GetFeedLabel() string {
	if x != nil && x.FeedLabel != nil {
		return *x.FeedLabel
	}
	return ""
}

func (x *PrimaryProductDataSource) GetContentLanguage() string {
	if x != nil && x.ContentLanguage != nil {
		return *x.ContentLanguage
	}
	return ""
}

func (x *PrimaryProductDataSource) GetCountries() []string {
	if x != nil {
		return x.Countries
	}
	return nil
}

func (x *PrimaryProductDataSource) GetDefaultRule() *PrimaryProductDataSource_DefaultRule {
	if x != nil {
		return x.DefaultRule
	}
	return nil
}

func (x *PrimaryProductDataSource) GetDestinations() []*PrimaryProductDataSource_Destination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

// The supplemental data source for local and online products. After creation,
// you should make sure to link the supplemental product data source into one or
// more primary product data sources.
type SupplementalProductDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Immutable. The feed label that is specified on the data source
	// level.
	//
	// Must be less than or equal to 20 uppercase letters (A-Z), numbers (0-9),
	// and dashes (-).
	//
	// See also [migration to feed
	// labels](https://developers.google.com/shopping-content/guides/products/feed-labels).
	//
	// `feedLabel` and `contentLanguage` must be either both set or unset for data
	// sources with product content type.
	//
	// They must be set for data sources with a [file
	// input][google.shopping.merchant.datasources.v1main.FileInput].
	// The fields must be unset for data sources without [file
	// input][google.shopping.merchant.datasources.v1main.FileInput].
	//
	// If set, the data source will only accept products matching this
	// combination. If unset, the data source will accept produts without that
	// restriction.
	FeedLabel *string `protobuf:"bytes,4,opt,name=feed_label,json=feedLabel,proto3,oneof" json:"feed_label,omitempty"`
	// Optional. Immutable. The two-letter ISO 639-1 language of the items in the
	// data source.
	//
	// `feedLabel` and `contentLanguage` must be either both set or unset.
	// The fields can only be unset for data sources without file input.
	//
	// If set, the data source will only accept products matching this
	// combination. If unset, the data source will accept produts without that
	// restriction.
	ContentLanguage *string `protobuf:"bytes,5,opt,name=content_language,json=contentLanguage,proto3,oneof" json:"content_language,omitempty"`
	// Output only. The (unordered and deduplicated) list of all primary data
	// sources linked to this data source in either default or custom rules.
	// Supplemental data source cannot be deleted before all links are removed.
	ReferencingPrimaryDataSources []*DataSourceReference `protobuf:"bytes,7,rep,name=referencing_primary_data_sources,json=referencingPrimaryDataSources,proto3" json:"referencing_primary_data_sources,omitempty"`
}

func (x *SupplementalProductDataSource) Reset() {
	*x = SupplementalProductDataSource{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SupplementalProductDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupplementalProductDataSource) ProtoMessage() {}

func (x *SupplementalProductDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupplementalProductDataSource.ProtoReflect.Descriptor instead.
func (*SupplementalProductDataSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{1}
}

func (x *SupplementalProductDataSource) GetFeedLabel() string {
	if x != nil && x.FeedLabel != nil {
		return *x.FeedLabel
	}
	return ""
}

func (x *SupplementalProductDataSource) GetContentLanguage() string {
	if x != nil && x.ContentLanguage != nil {
		return *x.ContentLanguage
	}
	return ""
}

func (x *SupplementalProductDataSource) GetReferencingPrimaryDataSources() []*DataSourceReference {
	if x != nil {
		return x.ReferencingPrimaryDataSources
	}
	return nil
}

// The local inventory data source.
type LocalInventoryDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The feed label of the offers to which the local
	// inventory is provided.
	//
	// Must be less than or equal to 20 uppercase letters (A-Z), numbers (0-9),
	// and dashes (-).
	//
	// See also [migration to feed
	// labels](https://developers.google.com/shopping-content/guides/products/feed-labels).
	FeedLabel string `protobuf:"bytes,4,opt,name=feed_label,json=feedLabel,proto3" json:"feed_label,omitempty"`
	// Required. Immutable. The two-letter ISO 639-1 language of the items to
	// which the local inventory is provided.
	ContentLanguage string `protobuf:"bytes,5,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
}

func (x *LocalInventoryDataSource) Reset() {
	*x = LocalInventoryDataSource{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalInventoryDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalInventoryDataSource) ProtoMessage() {}

func (x *LocalInventoryDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalInventoryDataSource.ProtoReflect.Descriptor instead.
func (*LocalInventoryDataSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{2}
}

func (x *LocalInventoryDataSource) GetFeedLabel() string {
	if x != nil {
		return x.FeedLabel
	}
	return ""
}

func (x *LocalInventoryDataSource) GetContentLanguage() string {
	if x != nil {
		return x.ContentLanguage
	}
	return ""
}

// The regional inventory data source.
type RegionalInventoryDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The feed label of the offers to which the regional
	// inventory is provided.
	//
	// Must be less than or equal to 20 uppercase letters (A-Z), numbers (0-9),
	// and dashes (-).
	//
	// See also [migration to feed
	// labels](https://developers.google.com/shopping-content/guides/products/feed-labels).
	FeedLabel string `protobuf:"bytes,4,opt,name=feed_label,json=feedLabel,proto3" json:"feed_label,omitempty"`
	// Required. Immutable. The two-letter ISO 639-1 language of the items to
	// which the regional inventory is provided.
	ContentLanguage string `protobuf:"bytes,5,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
}

func (x *RegionalInventoryDataSource) Reset() {
	*x = RegionalInventoryDataSource{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegionalInventoryDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegionalInventoryDataSource) ProtoMessage() {}

func (x *RegionalInventoryDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegionalInventoryDataSource.ProtoReflect.Descriptor instead.
func (*RegionalInventoryDataSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{3}
}

func (x *RegionalInventoryDataSource) GetFeedLabel() string {
	if x != nil {
		return x.FeedLabel
	}
	return ""
}

func (x *RegionalInventoryDataSource) GetContentLanguage() string {
	if x != nil {
		return x.ContentLanguage
	}
	return ""
}

// The promotion data source.
type PromotionDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The target country used as part of the unique
	// identifier. Represented as a [CLDR territory
	// code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
	//
	// Promotions are only available in selected
	// [countries](https://support.google.com/merchants/answer/4588460).
	TargetCountry string `protobuf:"bytes,1,opt,name=target_country,json=targetCountry,proto3" json:"target_country,omitempty"`
	// Required. Immutable. The two-letter ISO 639-1 language of the items in the
	// data source.
	ContentLanguage string `protobuf:"bytes,2,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
}

func (x *PromotionDataSource) Reset() {
	*x = PromotionDataSource{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PromotionDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromotionDataSource) ProtoMessage() {}

func (x *PromotionDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromotionDataSource.ProtoReflect.Descriptor instead.
func (*PromotionDataSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{4}
}

func (x *PromotionDataSource) GetTargetCountry() string {
	if x != nil {
		return x.TargetCountry
	}
	return ""
}

func (x *PromotionDataSource) GetContentLanguage() string {
	if x != nil {
		return x.ContentLanguage
	}
	return ""
}

// The product review data source.
type ProductReviewDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ProductReviewDataSource) Reset() {
	*x = ProductReviewDataSource{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductReviewDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductReviewDataSource) ProtoMessage() {}

func (x *ProductReviewDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductReviewDataSource.ProtoReflect.Descriptor instead.
func (*ProductReviewDataSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{5}
}

// The merchant review data source.
type MerchantReviewDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MerchantReviewDataSource) Reset() {
	*x = MerchantReviewDataSource{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MerchantReviewDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantReviewDataSource) ProtoMessage() {}

func (x *MerchantReviewDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantReviewDataSource.ProtoReflect.Descriptor instead.
func (*MerchantReviewDataSource) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{6}
}

// Data source reference can be used to manage related data sources within the
// data source service.
type DataSourceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to DataSourceId:
	//
	//	*DataSourceReference_Self
	//	*DataSourceReference_PrimaryDataSourceName
	//	*DataSourceReference_SupplementalDataSourceName
	DataSourceId isDataSourceReference_DataSourceId `protobuf_oneof:"data_source_id"`
}

func (x *DataSourceReference) Reset() {
	*x = DataSourceReference{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataSourceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSourceReference) ProtoMessage() {}

func (x *DataSourceReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSourceReference.ProtoReflect.Descriptor instead.
func (*DataSourceReference) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{7}
}

func (m *DataSourceReference) GetDataSourceId() isDataSourceReference_DataSourceId {
	if m != nil {
		return m.DataSourceId
	}
	return nil
}

func (x *DataSourceReference) GetSelf() bool {
	if x, ok := x.GetDataSourceId().(*DataSourceReference_Self); ok {
		return x.Self
	}
	return false
}

func (x *DataSourceReference) GetPrimaryDataSourceName() string {
	if x, ok := x.GetDataSourceId().(*DataSourceReference_PrimaryDataSourceName); ok {
		return x.PrimaryDataSourceName
	}
	return ""
}

func (x *DataSourceReference) GetSupplementalDataSourceName() string {
	if x, ok := x.GetDataSourceId().(*DataSourceReference_SupplementalDataSourceName); ok {
		return x.SupplementalDataSourceName
	}
	return ""
}

type isDataSourceReference_DataSourceId interface {
	isDataSourceReference_DataSourceId()
}

type DataSourceReference_Self struct {
	// Self should be used to reference the primary data source itself.
	Self bool `protobuf:"varint,1,opt,name=self,proto3,oneof"`
}

type DataSourceReference_PrimaryDataSourceName struct {
	// Optional. The name of the primary data source.
	// Format:
	// `accounts/{account}/dataSources/{datasource}`
	PrimaryDataSourceName string `protobuf:"bytes,3,opt,name=primary_data_source_name,json=primaryDataSourceName,proto3,oneof"`
}

type DataSourceReference_SupplementalDataSourceName struct {
	// Optional. The name of the supplemental data source.
	// Format:
	// `accounts/{account}/dataSources/{datasource}`
	SupplementalDataSourceName string `protobuf:"bytes,2,opt,name=supplemental_data_source_name,json=supplementalDataSourceName,proto3,oneof"`
}

func (*DataSourceReference_Self) isDataSourceReference_DataSourceId() {}

func (*DataSourceReference_PrimaryDataSourceName) isDataSourceReference_DataSourceId() {}

func (*DataSourceReference_SupplementalDataSourceName) isDataSourceReference_DataSourceId() {}

// Default rule management of the data source.
type PrimaryProductDataSource_DefaultRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of data sources linked in the [default
	// rule](https://support.google.com/merchants/answer/7450276).
	// This list is ordered by the default rule priority of joining the data.
	// It might include none or multiple references to `self` and supplemental
	// data sources.
	//
	// The list must not be empty.
	//
	// To link the data source to the default rule, you need to add a
	// new reference to this list (in sequential order).
	//
	// To unlink the data source from the default rule, you need to
	// remove the given reference from this list.
	//
	// Changing the order of this list will result in changing the priority of
	// data sources in the default rule.
	//
	// For example, providing the following list: [`1001`, `self`] will
	// take attribute values from supplemental data source `1001`, and fallback
	// to `self` if the attribute is not set in `1001`.
	TakeFromDataSources []*DataSourceReference `protobuf:"bytes,1,rep,name=take_from_data_sources,json=takeFromDataSources,proto3" json:"take_from_data_sources,omitempty"`
}

func (x *PrimaryProductDataSource_DefaultRule) Reset() {
	*x = PrimaryProductDataSource_DefaultRule{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrimaryProductDataSource_DefaultRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrimaryProductDataSource_DefaultRule) ProtoMessage() {}

func (x *PrimaryProductDataSource_DefaultRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrimaryProductDataSource_DefaultRule.ProtoReflect.Descriptor instead.
func (*PrimaryProductDataSource_DefaultRule) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PrimaryProductDataSource_DefaultRule) GetTakeFromDataSources() []*DataSourceReference {
	if x != nil {
		return x.TakeFromDataSources
	}
	return nil
}

// Destinations also known as [Marketing
// methods](https://support.google.com/merchants/answer/15130232) selections.
type PrimaryProductDataSource_Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Marketing methods](https://support.google.com/merchants/answer/15130232)
	// (also known as destination) selections.
	Destination typepb.Destination_DestinationEnum `protobuf:"varint,1,opt,name=destination,proto3,enum=google.shopping.type.Destination_DestinationEnum" json:"destination,omitempty"`
	// The state of the destination.
	State PrimaryProductDataSource_Destination_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource_Destination_State" json:"state,omitempty"`
}

func (x *PrimaryProductDataSource_Destination) Reset() {
	*x = PrimaryProductDataSource_Destination{}
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrimaryProductDataSource_Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrimaryProductDataSource_Destination) ProtoMessage() {}

func (x *PrimaryProductDataSource_Destination) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrimaryProductDataSource_Destination.ProtoReflect.Descriptor instead.
func (*PrimaryProductDataSource_Destination) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP(), []int{0, 1}
}

func (x *PrimaryProductDataSource_Destination) GetDestination() typepb.Destination_DestinationEnum {
	if x != nil {
		return x.Destination
	}
	return typepb.Destination_DestinationEnum(0)
}

func (x *PrimaryProductDataSource_Destination) GetState() PrimaryProductDataSource_Destination_State {
	if x != nil {
		return x.State
	}
	return PrimaryProductDataSource_Destination_STATE_UNSPECIFIED
}

var File_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDesc = []byte{
	0x0a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xa3, 0x08, 0x0a, 0x18, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x6f, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x12, 0x2a, 0x0a, 0x0a, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52,
	0x09, 0x66, 0x65, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a,
	0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x48,
	0x01, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x79, 0x0a, 0x0c, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x7a, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x89, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x7a, 0x0a, 0x16, 0x74, 0x61, 0x6b, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x74, 0x61, 0x6b, 0x65, 0x46, 0x72, 0x6f, 0x6d,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x8c, 0x02, 0x0a, 0x0b,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6e, 0x75, 0x6d, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x39, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x59, 0x0a, 0x07, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54,
	0x53, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x50, 0x52, 0x4f,
	0x44, 0x55, 0x43, 0x54, 0x53, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x52, 0x4f, 0x44, 0x55,
	0x43, 0x54, 0x53, 0x10, 0x03, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0xb8, 0x02, 0x0a, 0x1d, 0x53, 0x75,
	0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x66,
	0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x09, 0x66, 0x65, 0x65, 0x64, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x48, 0x01, 0x52, 0x0f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x8e, 0x01, 0x0a, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f,
	0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42,
	0x13, 0x0a, 0x11, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x22, 0x74, 0x0a, 0x18, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x25, 0x0a, 0x0a, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x66, 0x65,
	0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x31, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0x77, 0x0a, 0x1b, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0a, 0x66, 0x65, 0x65,
	0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x66, 0x65, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x12, 0x31, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0,
	0x41, 0x05, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x22, 0x77, 0x0a, 0x13, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2d, 0x0a, 0x0e, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x31, 0x0a, 0x10, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0x19, 0x0a, 0x17,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x4d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x13, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x04, 0x73,
	0x65, 0x6c, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x04, 0x73, 0x65, 0x6c,
	0x66, 0x12, 0x3e, 0x0a, 0x18, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x15, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x48, 0x0a, 0x1d, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x1a, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x42, 0xb0, 0x02,
	0x0a, 0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x42, 0x14, 0x44, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x57, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x70, 0x62, 0xaa, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x53, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0xca, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x5c, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5c, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02,
	0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x3a, 0x3a, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x3a, 0x3a, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescData = file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDesc
)

func file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescData)
	})
	return file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDescData
}

var file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_goTypes = []any{
	(PrimaryProductDataSource_Channel)(0),           // 0: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.Channel
	(PrimaryProductDataSource_Destination_State)(0), // 1: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.Destination.State
	(*PrimaryProductDataSource)(nil),                // 2: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource
	(*SupplementalProductDataSource)(nil),           // 3: google.shopping.merchant.datasources.v1beta.SupplementalProductDataSource
	(*LocalInventoryDataSource)(nil),                // 4: google.shopping.merchant.datasources.v1beta.LocalInventoryDataSource
	(*RegionalInventoryDataSource)(nil),             // 5: google.shopping.merchant.datasources.v1beta.RegionalInventoryDataSource
	(*PromotionDataSource)(nil),                     // 6: google.shopping.merchant.datasources.v1beta.PromotionDataSource
	(*ProductReviewDataSource)(nil),                 // 7: google.shopping.merchant.datasources.v1beta.ProductReviewDataSource
	(*MerchantReviewDataSource)(nil),                // 8: google.shopping.merchant.datasources.v1beta.MerchantReviewDataSource
	(*DataSourceReference)(nil),                     // 9: google.shopping.merchant.datasources.v1beta.DataSourceReference
	(*PrimaryProductDataSource_DefaultRule)(nil),    // 10: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.DefaultRule
	(*PrimaryProductDataSource_Destination)(nil),    // 11: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.Destination
	(typepb.Destination_DestinationEnum)(0),         // 12: google.shopping.type.Destination.DestinationEnum
}
var file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_depIdxs = []int32{
	0,  // 0: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.channel:type_name -> google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.Channel
	10, // 1: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.default_rule:type_name -> google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.DefaultRule
	11, // 2: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.destinations:type_name -> google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.Destination
	9,  // 3: google.shopping.merchant.datasources.v1beta.SupplementalProductDataSource.referencing_primary_data_sources:type_name -> google.shopping.merchant.datasources.v1beta.DataSourceReference
	9,  // 4: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.DefaultRule.take_from_data_sources:type_name -> google.shopping.merchant.datasources.v1beta.DataSourceReference
	12, // 5: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.Destination.destination:type_name -> google.shopping.type.Destination.DestinationEnum
	1,  // 6: google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.Destination.state:type_name -> google.shopping.merchant.datasources.v1beta.PrimaryProductDataSource.Destination.State
	7,  // [7:7] is the sub-list for method output_type
	7,  // [7:7] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_init() }
func file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_init() {
	if File_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto != nil {
		return
	}
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes[7].OneofWrappers = []any{
		(*DataSourceReference_Self)(nil),
		(*DataSourceReference_PrimaryDataSourceName)(nil),
		(*DataSourceReference_SupplementalDataSourceName)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto = out.File
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_rawDesc = nil
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_goTypes = nil
	file_google_shopping_merchant_datasources_v1beta_datasourcetypes_proto_depIdxs = nil
}
